/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.main.ServerInstance;

public abstract class ServerContainer
extends Application
implements Runnable {
    protected static final String ID_POP3 = "POP3";
    protected static final String ID_SMTP = "SMTP";
    protected static final String ID_FWD = "FWD";
    protected static final String ID_MPA = "MPA";
    protected Configuration cnf = Configuration.getConfig();
    protected LockObject loThreadStarted = null;
    protected String strContainerName = null;
    protected int intInstances = -1;
    protected Thread thrd = null;
    protected boolean blnIsRunning = false;
    private Vector vecInstances = null;
    private boolean blnRoundRobin = true;
    private int intLastResource = -1;

    public ServerContainer(String strContainerName) {
        this.strContainerName = strContainerName;
    }

    protected void addInstance(ServerInstance si) {
        this.vecInstances.addElement(si);
    }

    public void dispose() {
        Thread t;
        this.setThreadName();
        Configuration.logContext.write("D Starting dispose of container");
        this.blnDisposed = true;
        if (this.loThreadStarted != null) {
            this.loThreadStarted.dispose();
            this.loThreadStarted = null;
        }
        if (this.vecInstances != null) {
            int i = 0;
            while (i < this.vecInstances.size()) {
                ServerInstance si = (ServerInstance)this.vecInstances.elementAt(i);
                si.dispose();
                ++i;
            }
            this.vecInstances.removeAllElements();
            this.vecInstances = null;
        }
        if ((t = this.thrd) != null) {
            this.blnIsRunning = false;
            try {
                t.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.thrd = null;
            t = null;
        }
        Configuration.logContext.write("D container disposed");
        this.resetThreadName();
    }

    protected int getBusyInstanceCount() {
        return this.getInstanceCount() - this.getFreeInstanceCount();
    }

    protected ServerInstance getFreeInstance() {
        if (this.vecInstances == null || this.vecInstances.size() == 0 || this.blnDisposed) {
            return null;
        }
        int intPosition = 0;
        if (this.blnRoundRobin) {
            intPosition = this.intLastResource + 1;
        }
        Vector vector = this.vecInstances;
        synchronized (vector) {
            int i = 0;
            while (i < this.vecInstances.size()) {
                if (intPosition >= this.vecInstances.size()) {
                    intPosition = 0;
                }
                ServerInstance si = (ServerInstance)this.vecInstances.elementAt(intPosition);
                if (this.blnDisposed) {
                    return null;
                }
                if (si != null && !si.isBusy()) {
                    this.intLastResource = intPosition;
                    si.setBusy(true);
                    return si;
                }
                ++intPosition;
                ++i;
            }
        }
        return null;
    }

    protected int getFreeInstanceCount() {
        int intCnt = 0;
        Vector vector = this.vecInstances;
        synchronized (vector) {
            int i = 0;
            while (i < this.vecInstances.size()) {
                ServerInstance si = (ServerInstance)this.vecInstances.elementAt(i);
                if (si != null && !si.isBusy()) {
                    ++intCnt;
                }
                ++i;
            }
        }
        return intCnt;
    }

    protected int getInstanceCount() {
        return this.vecInstances.size();
    }

    protected boolean init() throws Throwable {
        String strID = this.strContainerName.toUpperCase().trim();
        if (strID.equals(ID_POP3)) {
            this.intInstances = this.cnf.intPOP3_Instances;
            this.blnRoundRobin = this.cnf.blnPOP3_RoundRobin;
        }
        if (strID.equals(ID_SMTP)) {
            this.intInstances = this.cnf.intSMTP_Instances;
            this.blnRoundRobin = this.cnf.blnSMTP_RoundRobin;
        }
        if (strID.equals(ID_FWD)) {
            this.intInstances = this.cnf.intFWD_Instances;
            this.blnRoundRobin = this.cnf.blnFWD_RoundRobin;
        }
        if (strID.equals(ID_MPA)) {
            this.intInstances = this.cnf.intMPA_Instances;
            this.blnRoundRobin = this.cnf.blnMPA_RoundRobin;
        }
        this.vecInstances = new Vector(this.intInstances);
        this.loThreadStarted = new LockObject();
        return this.intInstances > 0;
    }

    public boolean isRunning() {
        return !this.blnDisposed && this.blnIsRunning;
    }

    protected void kickThread() {
        this.blnIsRunning = false;
        this.thrd = new Thread((Runnable)this, this.getThreadName());
        this.thrd.setPriority(1);
        this.thrd.start();
        this.loThreadStarted.lo_wait();
        if (!this.blnIsRunning) {
            this.dispose();
            throw new InitializationException();
        }
    }

    public abstract void run();
}

