/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.ForceFetchmailEvent;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.event.RestartEvent;
import net.zerotoaster.mta.event.RestartFullyEvent;
import net.zerotoaster.mta.event.ShutdownEvent;
import net.zerotoaster.mta.io.RemoteFile;
import net.zerotoaster.mta.storage.StatisticsRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.util.Helper;

public abstract class LocalStorageManager
extends StorageManager {
    protected void adminForceFetchmail_Impl() throws IOException {
        MTAEventQueue.postEvent(new ForceFetchmailEvent());
    }

    protected void adminFullRestart_Impl() throws IOException {
        MTAEventQueue.postEvent(new RestartFullyEvent());
    }

    protected void adminRestart_Impl() throws IOException {
        MTAEventQueue.postEvent(new RestartEvent());
    }

    protected void adminShutdown_Impl() throws IOException {
        MTAEventQueue.postEvent(new ShutdownEvent());
    }

    protected void fileDelete_Impl(String string) throws Throwable {
        String strFile = Helper.platformPath(string);
        new File(strFile).delete();
    }

    protected RemoteFile fileGet_Impl(String string) throws Throwable {
        String strPath = Helper.platformPath(string);
        return new RemoteFile(strPath);
    }

    protected RemoteFile[] fileList_Impl(String string) throws Throwable {
        String strPath = Helper.platformPath(string);
        File fl = new File(strPath);
        String[] s = fl.list();
        RemoteFile[] f = new RemoteFile[s.length];
        int i = 0;
        while (i < s.length) {
            f[i] = new RemoteFile(strPath, s[i]);
            ++i;
        }
        return f;
    }

    protected void fileLoad_Impl(String string, OutputStream out) throws Throwable {
        String strFile = Helper.platformPath(string);
        FileInputStream in = new FileInputStream(strFile);
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = in.read(buffer)) != -1) {
            out.write(buffer, 0, i);
        }
        out.flush();
    }

    protected void fileSave_Impl(String string, InputStream in) throws Throwable {
        String strFile = Helper.platformPath(string);
        FileOutputStream out = new FileOutputStream(strFile);
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = in.read(buffer)) != -1) {
            out.write(buffer, 0, i);
        }
        out.flush();
        out.close();
    }

    protected String[] logGet_Impl() throws Throwable {
        return Configuration.logContext.getLogBuffer();
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        this.cnf.statrec.lngTimeCurrent = TimeFactory.getTime();
        return this.cnf.statrec;
    }
}

