/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.TimeFactory;
import de.zwanzigeins.util.VectorString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.storage.StorageRecord;

public class MailHeaderRecord
extends StorageRecord
implements Serializable,
Cloneable {
    private String strEnvelopeFrom_Redirected = null;
    private VectorString vecEnvelopeTo_Redirected = null;
    private long lngMailSize = -1L;
    private String strUID = null;
    private boolean blnExternalMail = false;
    private long lngTimeReceived = -1L;
    private long lngTimeNextRetry = -1L;
    private int intRetryCount = 0;
    private boolean blnMailDeleted = false;
    private boolean blnMailLocked = false;
    private long lngMailLockedTimestamp = 0L;
    private long lngTimeFetched = -1L;
    private boolean blnIsRelayMail = false;
    private boolean blnIsHubMail = false;
    private String strAccounting = null;
    private boolean blnIsBounce = false;
    private String strRoutedIP = null;
    private String strEnvelopeFrom_Orginal = null;
    private VectorString vecEnvelopeTo_Orginal = null;
    private String strHELO = null;
    private VectorString vecMailSent = null;

    public MailHeaderRecord() {
        this.init();
    }

    public void addEnvelopeTo_Orginal(String s) {
        this.vecEnvelopeTo_Orginal.addElement(s);
    }

    public void addEnvelopeTo_Redirected(String s) {
        this.vecEnvelopeTo_Redirected.addElement(s);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String getAccounting() {
        return this.strAccounting;
    }

    public String getEnvelopeFrom_Orginal() {
        return this.strEnvelopeFrom_Orginal;
    }

    public String getEnvelopeFrom_Redirected() {
        return this.strEnvelopeFrom_Redirected;
    }

    public String[] getEnvelopeTo_Orginal() {
        String[] s = new String[this.vecEnvelopeTo_Orginal.size()];
        this.vecEnvelopeTo_Orginal.copyInto(s);
        return s;
    }

    public String[] getEnvelopeTo_Redirected() {
        String[] s = new String[this.vecEnvelopeTo_Redirected.size()];
        this.vecEnvelopeTo_Redirected.copyInto(s);
        return s;
    }

    public boolean getExternalMail() {
        return this.blnExternalMail;
    }

    public String getHELO() {
        return this.strHELO;
    }

    public boolean getIsBounce() {
        return this.blnIsBounce;
    }

    public boolean getIsHubMail() {
        return this.blnIsHubMail;
    }

    public boolean getIsRelayMail() {
        return this.blnIsRelayMail;
    }

    public boolean getMailDeleted() {
        return this.blnMailDeleted;
    }

    public boolean getMailLocked() {
        return this.blnMailLocked;
    }

    public long getMailLockedTimestamp() {
        return this.lngMailLockedTimestamp;
    }

    public boolean getMailSent(int intRecipient) {
        if (intRecipient > this.vecMailSent.size()) {
            return false;
        }
        return this.vecMailSent.elementAt(intRecipient).equals("1");
    }

    public long getMailSize() {
        return this.lngMailSize;
    }

    public int getRetryCount() {
        return this.intRetryCount;
    }

    public String getRoutedIP() {
        return this.strRoutedIP;
    }

    public long getTimeFetched() {
        return this.lngTimeFetched;
    }

    public long getTimeNextRetry() {
        return this.lngTimeNextRetry;
    }

    public long getTimeReceived() {
        return this.lngTimeReceived;
    }

    public String getUID() {
        return this.strUID;
    }

    public void init() {
        this.strEnvelopeFrom_Redirected = "";
        this.vecEnvelopeTo_Redirected = new VectorString();
        this.strUID = "";
        this.lngMailSize = -1L;
        this.blnExternalMail = false;
        this.lngTimeReceived = -1L;
        this.lngTimeNextRetry = -1L;
        this.intRetryCount = 0;
        this.blnMailDeleted = false;
        this.blnMailLocked = false;
        this.lngMailLockedTimestamp = 0L;
        this.lngTimeFetched = -1L;
        this.strAccounting = "";
        this.blnIsBounce = false;
        this.strRoutedIP = "";
        this.strEnvelopeFrom_Orginal = "";
        this.vecEnvelopeTo_Orginal = new VectorString();
        this.strHELO = "";
        this.vecMailSent = new VectorString();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        File fl = new File("c:/4/x");
        LineReader lr = new LineReader(new FileInputStream(fl));
        MailHeaderRecord mhr = new MailHeaderRecord();
        try {
            mhr.recordImport(lr.readln());
        }
        catch (Throwable throwable) {}
        lr.close();
    }

    public void recipientReset() {
        this.vecEnvelopeTo_Redirected = new VectorString();
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUID);
        strb.append('\u0014');
        strb.append(this.strEnvelopeFrom_Redirected.replace('\u0014', '?'));
        strb.append('\u0014');
        strb.append(this.vecEnvelopeTo_Redirected.elementAt(0).replace('\u0014', '?'));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.lngMailSize, (int)20, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnExternalMail), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.lngTimeReceived, (int)20, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.lngTimeNextRetry, (int)20, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.intRetryCount, (int)4, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnMailDeleted), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnMailLocked), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.lngMailLockedTimestamp, (int)20, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((long)this.lngTimeFetched, (int)20, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnIsRelayMail), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnIsHubMail), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(this.strAccounting.replace('\u0014', '?'));
        strb.append('\u0014');
        strb.append(HelperFormat.lset((String)String.valueOf(this.blnIsBounce), (int)5, (char)' '));
        strb.append('\u0014');
        strb.append(this.strRoutedIP);
        strb.append('\u0014');
        strb.append(this.strEnvelopeFrom_Orginal.replace('\u0014', '?'));
        strb.append('\u0014');
        strb.append(this.vecEnvelopeTo_Orginal.elementAt(0).replace('\u0014', '?'));
        strb.append('\u0014');
        strb.append(this.strHELO.replace('\u0014', '?'));
        strb.append('\u0014');
        if (this.blnExternalMail || this.blnIsRelayMail) {
            strb.append(this.vecEnvelopeTo_Redirected.size());
            strb.append('\u0014');
            int i = 0;
            while (i < this.vecEnvelopeTo_Redirected.size()) {
                strb.append(this.vecEnvelopeTo_Orginal.elementAt(i));
                strb.append('\u0014');
                strb.append(this.vecEnvelopeTo_Redirected.elementAt(i));
                strb.append('\u0014');
                strb.append("0");
                strb.append('\u0014');
                ++i;
            }
        }
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.init();
        this.strUID = this.nextToken();
        this.strEnvelopeFrom_Redirected = this.nextToken();
        this.vecEnvelopeTo_Redirected.addElement(this.nextToken());
        this.lngMailSize = this.nextTokenLong();
        this.blnExternalMail = this.nextTokenBoolean();
        this.lngTimeReceived = this.nextTokenLong();
        this.lngTimeNextRetry = this.nextTokenLong();
        this.intRetryCount = this.nextTokenInteger();
        this.blnMailDeleted = this.nextTokenBoolean();
        this.blnMailLocked = this.nextTokenBoolean();
        this.lngMailLockedTimestamp = this.nextTokenLong();
        this.lngTimeFetched = TimeFactory.getTime();
        try {
            this.lngTimeFetched = this.nextTokenLong();
        }
        catch (Throwable throwable) {}
        this.blnIsRelayMail = this.nextTokenBoolean();
        this.blnIsHubMail = this.nextTokenBoolean();
        this.strAccounting = this.nextToken();
        this.blnIsBounce = this.nextTokenBoolean();
        if (this.hasMoreTokens()) {
            this.strRoutedIP = this.nextToken();
        }
        if (this.hasMoreTokens()) {
            this.strEnvelopeFrom_Orginal = this.nextToken();
            this.vecEnvelopeTo_Orginal.addElement(this.nextToken());
            this.strHELO = this.nextToken();
        }
        if (this.hasMoreTokens() && (this.blnExternalMail || this.blnIsRelayMail)) {
            int intCnt = Integer.parseInt(this.nextToken());
            this.vecEnvelopeTo_Orginal.removeAllElements();
            this.vecEnvelopeTo_Redirected.removeAllElements();
            int i = 0;
            while (i < intCnt) {
                this.vecEnvelopeTo_Orginal.addElement(this.nextToken());
                this.vecEnvelopeTo_Redirected.addElement(this.nextToken());
                this.vecMailSent.addElement(this.nextToken());
                ++i;
            }
        }
    }

    public void setAccounting(String s) {
        this.strAccounting = s;
    }

    public void setEnvelopeFrom_Orginal(String s) {
        this.strEnvelopeFrom_Orginal = s;
    }

    public void setEnvelopeFrom_Redirected(String s) {
        this.strEnvelopeFrom_Redirected = s;
    }

    public void setExternalMail(boolean b) {
        this.blnExternalMail = b;
    }

    public void setHELO(String s) {
        this.strHELO = s;
    }

    public void setIsBounce(boolean b) {
        this.blnIsBounce = b;
    }

    public void setIsHubMail(boolean b) {
        this.blnIsHubMail = b;
    }

    public void setIsRelayMail(boolean b) {
        this.blnIsRelayMail = b;
    }

    public void setMailDeleted(boolean b) {
        this.blnMailDeleted = b;
    }

    public void setMailLocked(boolean b) {
        this.blnMailLocked = b;
    }

    public void setMailLockedTimestamp(long l) {
        this.lngMailLockedTimestamp = l;
    }

    public void setMailSent(int intRecipient) {
        while (intRecipient < this.vecMailSent.size()) {
            this.vecMailSent.addElement("0");
        }
        this.vecMailSent.setElementAt("1", intRecipient);
    }

    public void setMailSize(long l) {
        this.lngMailSize = l;
    }

    public void setRetryCount(int i) {
        this.intRetryCount = i;
    }

    public void setRoutedIP(String s) {
        this.strRoutedIP = s;
    }

    public void setTimeFetched(long l) {
        if (this.lngTimeFetched < 1L) {
            this.lngTimeFetched = l;
        }
    }

    public void setTimeNextRetry(long l) {
        this.lngTimeNextRetry = l;
    }

    public void setTimeReceived(long l) {
        this.lngTimeReceived = l;
    }

    public void setUID(String s) {
        this.strUID = s;
    }

    public String toString() {
        StringBuffer strbTmp = new StringBuffer();
        String[] strReceivers = this.getEnvelopeTo_Redirected();
        int i = 0;
        while (i < strReceivers.length) {
            strbTmp.append(strReceivers[i]);
            strbTmp.append(",");
            ++i;
        }
        if (strbTmp.length() > 1) {
            strbTmp.setLength(strbTmp.length() - 1);
        }
        return String.valueOf(this.getEnvelopeFrom_Redirected()) + " -> " + strbTmp.toString() + (this.getIsRelayMail() ? " (relay)" : "");
    }
}

