/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.Application;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.event.PostmasterAlert;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.io.RemoteFile;
import net.zerotoaster.mta.mailfilters.MailFilterChain;
import net.zerotoaster.mta.main.MPA_ServerContainer;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.LicenceRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.MailingListRecord;
import net.zerotoaster.mta.storage.StatisticsRecord;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.storage.UserRecord;

public abstract class StorageManager
extends Application {
    protected Configuration cnf = Configuration.getConfig();

    public Vector accountingRead(String strID) {
        try {
            return this.accountingRead_Impl(strID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public Vector accountingReadAll() {
        try {
            return this.accountingReadAll_Impl();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector accountingReadAll_Impl() throws Throwable;

    protected abstract Vector accountingRead_Impl(String var1) throws Throwable;

    public void accountingStore(String strID, String strUser, long lngBytesReceived, long lngBytesSent) {
        try {
            this.accountingStore_Impl(strID, strUser, lngBytesReceived, lngBytesSent);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void accountingStore_Impl(String var1, String var2, long var3, long var5);

    public final void adminForceFetchmail() {
        try {
            this.adminForceFetchmail_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error during force fetchmail", t);
            throw new StorageException();
        }
    }

    protected abstract void adminForceFetchmail_Impl() throws Throwable;

    public final void adminFullRestart() {
        try {
            this.adminFullRestart_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error during fullrestart", t);
            throw new StorageException();
        }
    }

    protected abstract void adminFullRestart_Impl() throws Throwable;

    public final void adminRestart() {
        try {
            this.adminRestart_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error during restart", t);
            throw new StorageException();
        }
    }

    protected abstract void adminRestart_Impl() throws Throwable;

    public final void adminShutdown() {
        try {
            this.adminShutdown_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Error during shutdown", t);
            throw new StorageException();
        }
    }

    protected abstract void adminShutdown_Impl() throws Throwable;

    public final void cleanup(boolean blnStartupMode) {
        try {
            this.cleanup_Impl(blnStartupMode);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void cleanup_Impl(boolean var1) throws Throwable;

    public final void commit() {
        try {
            this.commit_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void commit_Impl() throws Throwable;

    public void dispose() {
        this.blnDisposed = true;
    }

    public final void domainDelete(String strDomain) {
        try {
            this.domainDelete_Impl(strDomain);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void domainDelete_Impl(String var1) throws Throwable;

    public final DomainRecord domainRead(String strDomain) {
        try {
            return this.domainRead_Impl(strDomain);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final Vector domainReadAll() {
        try {
            return this.domainReadAll_Impl();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector domainReadAll_Impl() throws Throwable;

    protected abstract DomainRecord domainRead_Impl(String var1) throws Throwable;

    public final void domainRename(String strOldDomain, String strNewDomain) {
        try {
            this.domainRename_Impl(strOldDomain, strNewDomain);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void domainRename_Impl(String var1, String var2) throws Throwable;

    public final void domainWrite(DomainRecord dom) {
        try {
            this.domainWrite_Impl(dom);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void domainWrite_Impl(DomainRecord var1) throws Throwable;

    public final void fileDelete(String strFile) {
        try {
            this.fileDelete_Impl(strFile);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void fileDelete_Impl(String var1) throws Throwable;

    public final RemoteFile fileGet(String strPath) {
        try {
            return this.fileGet_Impl(strPath);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract RemoteFile fileGet_Impl(String var1) throws Throwable;

    public final RemoteFile[] fileList(String strPath) {
        try {
            return this.fileList_Impl(strPath);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract RemoteFile[] fileList_Impl(String var1) throws Throwable;

    public final void fileLoad(String strFile, OutputStream out) {
        try {
            this.fileLoad_Impl(strFile, out);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void fileLoad_Impl(String var1, OutputStream var2) throws Throwable;

    public final void fileSave(String strFile, InputStream in) {
        try {
            this.fileSave_Impl(strFile, in);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void fileSave_Impl(String var1, InputStream var2) throws Throwable;

    public final void filterDelete(String strName) {
        try {
            this.filterDelete_Impl(strName);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void filterDelete_Impl(String var1) throws Throwable;

    public final FilterRecord filterRead(String strName) {
        try {
            return this.filterRead_Impl(strName);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final Vector filterReadAll() {
        try {
            return this.filterReadAll_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector filterReadAll_Impl() throws Throwable;

    protected abstract FilterRecord filterRead_Impl(String var1) throws Throwable;

    public final void filterWrite(FilterRecord fr) {
        try {
            this.filterWrite_Impl(fr);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void filterWrite_Impl(FilterRecord var1) throws Throwable;

    public final void keyDataDelete(String strApplName, String strUserName, String strKey) {
        try {
            this.keyDataDelete_Impl(strApplName, strUserName, strKey);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void keyDataDelete_Impl(String var1, String var2, String var3) throws Throwable;

    public final String keyDataRead(String strApplName, String strUser, String strKey) {
        try {
            return this.keyDataRead_Impl(strApplName, strUser, strKey);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final Vector keyDataReadAll(String strApplName, String strUserName) {
        try {
            return this.keyDataReadAll_Impl(strApplName, strUserName);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector keyDataReadAll_Impl(String var1, String var2) throws Throwable;

    protected abstract String keyDataRead_Impl(String var1, String var2, String var3) throws Throwable;

    public final void keyDataWrite(String strApplName, String strUserName, String strKey, String strData) {
        try {
            this.keyDataWrite_Impl(strApplName, strUserName, strKey, strData);
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void keyDataWrite_Impl(String var1, String var2, String var3, String var4) throws Throwable;

    public final String licenceCheck() {
        try {
            return this.licenceCheck_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected String licenceCheck_Impl() throws Throwable {
        Vector vecDomains = this.domainReadAll_Impl();
        int intCurrDomains = vecDomains.size();
        int intCurrUsers = 0;
        int i = 0;
        while (i < vecDomains.size()) {
            String strDomain = (String)vecDomains.elementAt(i);
            intCurrUsers += this.userReadAllByDomain_Impl(strDomain).size();
            ++i;
        }
        int intCurrLists = this.mailinglistReadAll_Impl().size();
        LicenceRecord licr = this.cnf.lic;
        StringBuffer strbMsg = new StringBuffer();
        boolean blnCritical = false;
        boolean blnLicenceExpired = false;
        if (intCurrDomains > licr.intMaxDomains) {
            strbMsg.append("Domains (" + intCurrDomains + ", max: " + licr.intMaxDomains + "), ");
            blnCritical |= intCurrDomains > licr.intMaxDomains + 1;
        }
        if (intCurrUsers > licr.intMaxUsers) {
            strbMsg.append("Users (" + intCurrUsers + ", max: " + licr.intMaxUsers + "), ");
            blnCritical |= intCurrUsers > licr.intMaxUsers + 2;
        }
        if (intCurrLists > licr.intMaxLists) {
            strbMsg.append("Mailinglists (" + intCurrLists + ", max: " + licr.intMaxLists + "), ");
            blnCritical |= intCurrLists > licr.intMaxLists + 1;
        }
        if (strbMsg.length() > 2) {
            strbMsg.setLength(strbMsg.length() - 2);
        }
        String licDate = LicenceRecord.long2date(licr.lngValidTo);
        String proDate = LicenceRecord.long2date(32004L);
        long lngLicDate = Long.parseLong(String.valueOf(licDate.substring(3)) + licDate.substring(0, 2));
        long lngProDate = Long.parseLong(String.valueOf(proDate.substring(3)) + proDate.substring(0, 2));
        if (lngProDate > lngLicDate) {
            strbMsg.setLength(0);
            strbMsg.append("Licence expired. Please backup to previous version.");
            blnCritical = false;
            blnLicenceExpired = true;
        }
        if (strbMsg.length() == 0) {
            Configuration.logContext.setSlowDown(0L);
            return "";
        }
        if (blnCritical || blnLicenceExpired) {
            if (!blnLicenceExpired) {
                strbMsg.insert(0, "Error: Too many ");
            }
            strbMsg.append(". Server will run slower.");
            long lngDelay = Configuration.logContext.getSlowDown();
            if (lngDelay == 0L) {
                lngDelay = 2000L;
            }
            Configuration.logContext.setSlowDown(lngDelay += 50L);
            Configuration.logContext.write("? " + strbMsg.toString());
            MTAEventQueue.postEvent(new PostmasterAlert("ZeroToaster::MTA Licencemanager:\r\n" + strbMsg.toString()));
            return strbMsg.toString();
        }
        if (!blnLicenceExpired) {
            strbMsg.insert(0, "Warning: Too many ");
            strbMsg.append(".");
        }
        Configuration.logContext.setSlowDown(0L);
        Configuration.logContext.write("! " + strbMsg.toString());
        MTAEventQueue.postEvent(new PostmasterAlert("ZeroToaster::MTA Licencemanager:\r\n" + strbMsg.toString()));
        return strbMsg.toString();
    }

    public final String[] logGet() {
        try {
            return this.logGet_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract String[] logGet_Impl() throws Throwable;

    public final Vector mailGetAllHeaders() {
        try {
            return this.mailGetAllHeaders_Impl();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetAllHeaders_Impl() throws Throwable;

    public final Vector mailGetHeadersForDomain(String strDomain) {
        try {
            return this.mailGetHeadersForDomain_Impl(strDomain);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersForDomain_Impl(String var1) throws Throwable;

    public final Vector mailGetHeadersForUser(String strUser) {
        try {
            return this.mailGetHeadersForUser_Impl(strUser);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersForUser_Impl(String var1) throws Throwable;

    public final Vector mailGetHeadersToSend(int intUpperLimit, long lngRetryDelay) {
        try {
            return this.mailGetHeadersToSend_Impl(intUpperLimit, lngRetryDelay);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailGetHeadersToSend_Impl(int var1, long var2) throws Throwable;

    public void mailinglistDelete(String strTarget) {
        try {
            this.mailinglistDelete_Impl(strTarget);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailinglistDelete_Impl(String var1) throws Throwable;

    public MailingListRecord mailinglistRead(String strTarget) {
        try {
            return this.mailinglistRead_Impl(strTarget);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public Vector mailinglistReadAll() {
        try {
            return this.mailinglistReadAll_Impl();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailinglistReadAll_Impl() throws Throwable;

    protected abstract MailingListRecord mailinglistRead_Impl(String var1) throws Throwable;

    public void mailinglistWrite(MailingListRecord mlr) {
        try {
            this.mailinglistWrite_Impl(mlr);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailinglistWrite_Impl(MailingListRecord var1) throws Throwable;

    public final void mailMove(MailHeaderRecord mhrOld, MailHeaderRecord mhrNew) {
        try {
            this.mailMove_Impl(mhrOld, mhrNew);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailMove_Impl(MailHeaderRecord var1, MailHeaderRecord var2) throws Throwable;

    public final void mailProcessQueueAdd(MailQueueRecord mqr) {
        try {
            this.mailProcessQueueAdd_Impl(mqr);
            MPA_ServerContainer.notify_me();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailProcessQueueAdd_Impl(MailQueueRecord var1) throws Throwable;

    public final Vector mailProcessQueueNext(int intUpbMails) {
        try {
            return this.mailProcessQueueNext_Impl(intUpbMails);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector mailProcessQueueNext_Impl(int var1) throws Throwable;

    public final void mailProcessQueueRemove(MailQueueRecord mqr) {
        try {
            this.mailProcessQueueRemove_Impl(mqr);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailProcessQueueRemove_Impl(MailQueueRecord var1) throws Throwable;

    public final LineReader mailReadBody(MailHeaderRecord mhr) {
        try {
            return this.mailReadBody_Impl(mhr);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final void mailReadBody(MailHeaderRecord mhr, POP3OutputWriter out) {
        try {
            this.mailReadBody_Impl(mhr, out);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract LineReader mailReadBody_Impl(MailHeaderRecord var1) throws Throwable;

    protected abstract void mailReadBody_Impl(MailHeaderRecord var1, POP3OutputWriter var2) throws Throwable;

    public final MailHeaderRecord mailReadHeader(String strUID) {
        try {
            return this.mailReadHeader_Impl(strUID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract MailHeaderRecord mailReadHeader_Impl(String var1) throws Throwable;

    public final void mailWriteFromString(MailHeaderRecord mhr, String strMail) {
        try {
            this.mailWriteFromString_Impl(mhr, strMail);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailWriteFromString_Impl(MailHeaderRecord var1, String var2) throws Throwable;

    public final void mailWriteFromTemp(MailFilterChain mfc, MailHeaderRecord mhr, String strUID) {
        try {
            this.mailWriteFromTemp_Impl(mfc, mhr, strUID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void mailWriteFromTemp_Impl(MailFilterChain var1, MailHeaderRecord var2, String var3) throws Throwable;

    public final void mailWriteHeader(MailHeaderRecord mhr) {
        try {
            this.mailWriteHeader_Impl(mhr);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract int mailWriteHeader_Impl(MailHeaderRecord var1) throws Throwable;

    public final void quotaCleanup() {
        try {
            this.quotaCleanup_Impl();
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void quotaCleanup_Impl() throws Throwable;

    public final boolean quotaExceeded(String strUser) {
        try {
            return this.quotaExceeded_Impl(strUser);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract boolean quotaExceeded_Impl(String var1) throws Throwable;

    public final void rollback() {
        try {
            this.rollback_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void rollback_Impl() throws Throwable;

    public final StatisticsRecord statsGet() {
        try {
            return this.statsGet_Impl();
        }
        catch (Throwable t) {
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract StatisticsRecord statsGet_Impl() throws Throwable;

    public final void tempDelete(String strUID) {
        try {
            this.tempDelete_Impl(strUID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void tempDelete_Impl(String var1) throws Throwable;

    public final LineReader tempRead(String strTemp_UID) {
        try {
            return this.tempRead_Impl(strTemp_UID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract LineReader tempRead_Impl(String var1) throws Throwable;

    public final LineWriter tempWrite(String strUID) {
        try {
            return this.tempWrite_Impl(strUID);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final void tempWrite(String strUID, LineReader in) {
        try {
            this.tempWrite_Impl(strUID, in);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract LineWriter tempWrite_Impl(String var1) throws Throwable;

    protected abstract void tempWrite_Impl(String var1, LineReader var2) throws Throwable;

    public abstract String toString();

    public final void userDelete(String strUser) {
        try {
            this.userDelete_Impl(strUser);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void userDelete_Impl(String var1) throws Throwable;

    public final UserRecord userRead(String strUser) {
        try {
            return this.userRead_Impl(strUser);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    public final Vector userReadAllByDomain(String strDomain) {
        try {
            return this.userReadAllByDomain_Impl(strDomain);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract Vector userReadAllByDomain_Impl(String var1) throws Throwable;

    protected abstract UserRecord userRead_Impl(String var1) throws Throwable;

    public final void userWrite(UserRecord usr) {
        try {
            this.userWrite_Impl(usr);
        }
        catch (Throwable t) {
            this.rollback();
            Configuration.logContext.write(t);
            throw new StorageException();
        }
    }

    protected abstract void userWrite_Impl(UserRecord var1) throws Throwable;
}

