/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.util;

import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.util.StringTokenizer;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.util.Helper;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.dns;

public class RBLCheck {
    private Configuration cnf = null;
    private LogContext log = null;
    private String strTXTResult = "";
    private String strIPResult = "";
    private long lngTimeNeeded = 0L;
    private static final Object objLock = new Object();

    public RBLCheck(LogContext log, Configuration cnf) {
        this.cnf = cnf;
        this.log = log;
    }

    public boolean check(String strIP, String strZone, String string) {
        this.lngTimeNeeded = 0L;
        this.strTXTResult = "";
        this.strIPResult = "";
        long lngTime = TimeFactory.getTime();
        String strIPR = "";
        StringTokenizer strt = new StringTokenizer(strIP, ".");
        while (strt.hasMoreTokens()) {
            strIPR = String.valueOf(strt.nextToken()) + "." + strIPR;
        }
        if (strIPR.length() < 5) {
            return false;
        }
        String cfr_ignored_0 = String.valueOf(Helper.lset(strIP, 15, ' ')) + "/" + strZone + " ";
        Record[] recA = dns.getRecords((String)(String.valueOf(strIPR) + strZone), (short)1);
        if (recA == null) {
            this.strTXTResult = "Not in RBL";
            return false;
        }
        Record[] recT = dns.getRecords((String)(String.valueOf(strIPR) + strZone), (short)16);
        StringBuffer strb = new StringBuffer(string.length());
        strt = new StringTokenizer(string, ",");
        while (strt.hasMoreTokens()) {
            strb.append(strt.nextToken().trim());
            strb.append("#");
        }
        String strMatch = strb.toString();
        boolean blnFound = false;
        String strText = "";
        int i = 0;
        while (i < recA.length) {
            String strA;
            if (strMatch.length() <= 0 || strMatch.indexOf(strA = String.valueOf(((ARecord)recA[i]).getAddress().getHostAddress()) + "#") != -1) {
                if (recT != null && recT.length == recA.length) {
                    strText = (String)((TXTRecord)recT[i]).getStrings().elementAt(0);
                }
                this.strIPResult = String.valueOf(this.strIPResult) + ((ARecord)recA[i]).getAddress().getHostAddress() + ", ";
                if (strText.length() == 0) {
                    strText = "RBL Blocked by " + strZone;
                }
                blnFound = true;
            }
            ++i;
        }
        if (!blnFound) {
            strText = "Found, but no matching result";
        }
        if (this.strIPResult.length() > 2) {
            this.strIPResult = this.strIPResult.substring(0, this.strIPResult.length() - 2);
        }
        this.lngTimeNeeded = TimeFactory.getTime() - lngTime;
        this.strTXTResult = strText;
        return blnFound;
    }

    public void dispose() {
        this.cnf = null;
        this.log = null;
    }

    public String getIPMessage() {
        return this.strIPResult;
    }

    public String getMessage() {
        return this.strTXTResult;
    }

    public long getTime() {
        return this.lngTimeNeeded;
    }

    public static void main(String[] stringArray) {
        String[] args;
        RBLCheck rbl = new RBLCheck(null, Configuration.getConfig());
        if (stringArray.length < 2) {
            args = new String[]{"82.44.41.136", "dnsbl.jammconsulting.com"};
        }
        System.out.println("[Scanning]");
        if (rbl.check(args[0], args[1], "")) {
            System.out.println(String.valueOf(args[0]) + " / " + args[1] + ": " + rbl.getMessage());
        } else {
            System.out.println(String.valueOf(args[0]) + " / " + args[1] + ": " + rbl.getMessage());
        }
        System.out.println("[End of query]");
        rbl.dispose();
    }
}

