/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.whois;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.whois.WhoisConstants;
import net.zerotoaster.mta.whois.WhoisResult;
import net.zerotoaster.mta.whois.WhoisServer;
import net.zerotoaster.mta.whois.WhoisServerBasic;
import net.zerotoaster.mta.whois.WhoisServerHTTP;
import net.zerotoaster.mta.whois.WhoisServerHTTP_Redirect;
import net.zerotoaster.mta.whois.WhoisServerNIC_TLD;
import net.zerotoaster.mta.whois.WhoisServerRipe;

public class Whois
implements WhoisConstants {
    private Vector vecTLD = null;
    private Vector vecIP = null;
    private Hashtable hshTLD = null;
    private Socket sok = null;
    private BufferedReader br = null;
    private PrintWriter pw = null;
    private int intRecursionDepth = 0;

    public Whois() {
        this.init();
    }

    private void closeAll() {
        try {
            this.br.close();
        }
        catch (Throwable throwable) {}
        try {
            this.pw.close();
        }
        catch (Throwable throwable) {}
        try {
            this.sok.close();
        }
        catch (Throwable throwable) {}
    }

    public void dispose() {
        this.closeAll();
        this.hshTLD.clear();
        this.vecTLD.removeAllElements();
        this.vecIP.removeAllElements();
    }

    public String getCountry(String strDomain, String strDefault) {
        int pp = strDomain.indexOf(".");
        String strTLD = pp == -1 ? "." + strDomain : strDomain.substring(pp);
        String s = (String)this.hshTLD.get(strTLD);
        return s == null ? strDefault : s;
    }

    private void init() {
        this.vecTLD = new Vector();
        this.vecTLD.addElement(new WhoisServerBasic(".priv.at", "whois.nic.priv.at"));
        this.vecTLD.addElement(new WhoisServerBasic(".asn.au", "whois.ausregistry.net.au"));
        this.vecTLD.addElement(new WhoisServerBasic(".com.au", "whois.ausregistry.net.au"));
        this.vecTLD.addElement(new WhoisServerBasic(".id.au", "whois.ausregistry.net.au"));
        this.vecTLD.addElement(new WhoisServerBasic(".net.au", "whois.ausregistry.net.au"));
        this.vecTLD.addElement(new WhoisServerBasic(".org.au", "whois.ausregistry.net.au"));
        this.vecTLD.addElement(new WhoisServerBasic(".au.com", "whois.au.com"));
        this.vecTLD.addElement(new WhoisServerBasic(".ac.uk", "whois.ja.com"));
        this.vecTLD.addElement(new WhoisServerBasic(".gov.uk", "whois.ja.com"));
        this.vecTLD.addElement(new WhoisServerHTTP(".ac", "www.nic.ac", "/cgi-bin/whois?query=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".ae", "whois.uaenic.ae"));
        this.vecTLD.addElement(new WhoisServer(".af", 3, "http://www.nic.af", 80, "/whois.jsp"));
        this.vecTLD.addElement(new WhoisServerBasic(".ag", "whois.nic.ag"));
        this.vecTLD.addElement(new WhoisServerBasic(".ai", "whois.ainic.ai"));
        this.vecTLD.addElement(new WhoisServer(".am", 3, "https://www.amnic.net", 0, "/whois"));
        this.vecTLD.addElement(new WhoisServer(".ar", 1, "www.nic.ar", 80, "/consdom.html", "nombre=%2&dominio=%3"));
        this.vecTLD.addElement(new WhoisServer(".as", 1, "www.nic.as", 80, "/whois.cfm?", "reseller=&domain=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".at", "whois.aco.net"));
        this.vecTLD.addElement(new WhoisServerBasic(".au", "whois.aunic.net"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".ba", "http://www.nic.ba/stream/whois/index.php"));
        this.vecTLD.addElement(new WhoisServer(".bb", 1, "domains.org.bb", 80, "/regsearch/getdetails.cfm?DND=%1"));
        this.vecTLD.addElement(new WhoisServer(".bd", 1, "www.bttb.net.bd", 8080, "/dotbd/ViewDomain_2.jsp", "dName=%2.%5&Submit=Submit"));
        this.vecTLD.addElement(new WhoisServerBasic(".be", "whois.dns.be"));
        this.vecTLD.addElement(new WhoisServerBasic(".bg", "whois.digsys.bg"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".bh", "http://www.inet.com.bh/"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".bi", "http://whois.nic.bi/register/whois.hei"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".bj"));
        this.vecTLD.addElement(new WhoisServer(".bm", 1, "207.228.133.14", 80, "/CGI-BIN/LANSAWEB?WEBEVENT+L0A6925175AE65508655A84I+WHO+ENG", "_NAME=ADOM++++++&_ROW=3&_COLUMN=18&_SELECT=00&_PANEL=BMWHO+++++BMWHO2+001&_BUTTON=OK&_CALFLD=ADOM++++++&_PROCESS=BMWHO+&_FUNCTION=BMWHO2+&_OPROCESS=BMWHO&_OFUNCTION=BMWHO2&_PARTITION=WHO&_COLORFLD=&_LW3TRCID=&_EXCHALLBL=&ADOM++++++=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".br", "www.registro.br"));
        this.vecTLD.addElement(new WhoisServer(".bt", 1, "www.nic.bt", 80, "/mwhois.php", "domainbt=%2&Submit.x=0&Submit.y=0"));
        this.vecTLD.addElement(new WhoisServerBasic(".bv", "whois.norid.no"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".bv", "http://www.norid.no/domenenavnbaser/bv-sj.html"));
        this.vecTLD.addElement(new WhoisServer(".by", 1, "www.tld.by", 80, "/cgi-bin/registry.cgi", "mode=slquest&lang=e&domain=%2"));
        this.vecTLD.addElement(new WhoisServerBasic(".bz", "whois.belizenic.bz"));
        this.vecTLD.addElement(new WhoisServerBasic(".ca", "whois.cira.ca"));
        this.vecTLD.addElement(new WhoisServerBasic(".cc", "whois.www.tv"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".ch"));
        this.vecTLD.addElement(new WhoisServer(".ci", 1, "www.nic.ci", 80, "/whois.php", "reseller=&domain=%1"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".ck"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".cl"));
        this.vecTLD.addElement(new WhoisServerBasic(".cn", "whois.cnnic.net.cn"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".co", "http://www.nic.co/"));
        this.vecTLD.addElement(new WhoisServer(".cr", 1, "www.nic.cr", 80, "/servlet/niccr?tid=TWhois&Lng=1&Act=REL", "_formClass=com.niccr.form.TConsultaDomForm&_formName=TConsultaDomForm&dominio=%2&codtipdom=%5"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".cx", "http://www.nic.cx/whois.jsp"));
        this.vecTLD.addElement(new WhoisServer(".cy", 1, "www.nic.cy", 80, "/nslookup/dns_get_record.php?search=%2&what=%5&submit=Search"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".cz"));
        this.vecTLD.addElement(new WhoisServer(".de", 0, "whois.denic.de", 43, "-T dn %1"));
        this.vecTLD.addElement(new WhoisServer(".dk", 0, "whois.dk-hostmaster.dk", 43, "--show-handles %1"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".dm"));
        this.vecTLD.addElement(new WhoisServer(".dz", 1, "www.eldjazair.dz", 80, "/template/rechercherdomaine.php?domain_name=%2&domaine=%3&B2=Envoyer"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".ec", "http://www.nic.ec"));
        this.vecTLD.addElement(new WhoisServerBasic(".ee", "whois.eenet.ee"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".es", "https://www.nic.es/"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".eu", "http://www.whois.eu/"));
        this.vecTLD.addElement(new WhoisServerBasic(".fi", "whois.ficora.fi"));
        this.vecTLD.addElement(new WhoisServer(".fj", 1, "domains.fj", 80, "/public/whois.php?searchDomainName=%2&searchTopLevel=%4&submitSearch=Search"));
        this.vecTLD.addElement(new WhoisServer(".fm", 1, "www.dot.fm", 80, "/query_whois.cfm", "domain=%2&tld=%4"));
        this.vecTLD.addElement(new WhoisServerRipe(".fo"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".fr"));
        this.vecTLD.addElement(new WhoisServerBasic(".ge", "whois.sanet.ge"));
        this.vecTLD.addElement(new WhoisServerBasic(".gg", "whois.channelisles.net"));
        this.vecTLD.addElement(new WhoisServer(".gi", 1, "www.nic.gi", 80, "/whois/", "lookup=%1&search=Search"));
        this.vecTLD.addElement(new WhoisServer(".gl", 1, "search.greennet.gl", 80, "/cgi-bin/dnscheck/eng.dnscheck.pl?action=dnscheck&webaddress=%1"));
        this.vecTLD.addElement(new WhoisServerRipe(".gm"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".gr", "https://grweb.ics.forth.gr/Whois?lang=en"));
        this.vecTLD.addElement(new WhoisServer(".gs", 1, "adamsnames.tc", 80, "/whois/whois.cgi?domain=%1"));
        this.vecTLD.addElement(new WhoisServer(".gt", 1, "www.gt", 80, "/cgi-bin/search.cgi", "domain=%1&Buscar=Buscar"));
        this.vecTLD.addElement(new WhoisServerBasic(".hk", "whois.hkdnr.net.hk"));
        this.vecTLD.addElement(new WhoisServerBasic(".hm", "whois.registry.hm"));
        this.vecTLD.addElement(new WhoisServer(".com.hr", 1, "hr-t.dns.hr", 80, "/php/search.php", "domena=%2&Submit=Tra\u00a5i"));
        this.vecTLD.addElement(new WhoisServer(".iz.hr", 1, "www.dns.hr", 80, "/asp/traziFOdomenu.asp", "Upit=%2&Submit=Tra%BEi"));
        this.vecTLD.addElement(new WhoisServer(".hr", 1, "www.dns.hr", 80, "/asp/trazidomenu.asp", "Upit=%2&Submit=Tra%BEi"));
        this.vecTLD.addElement(new WhoisServer(".ht", 1, "www.nic.ht", 80, "/info/whois.cfm?domain=%1&Submit=G+O"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".hu"));
        this.vecTLD.addElement(new WhoisServerBasic(".ie", "whois.domainregistry.ie"));
        this.vecTLD.addElement(new WhoisServerBasic(".il", "whois.isoc.org.il"));
        this.vecTLD.addElement(new WhoisServer(".im", 1, "www.nic.im", 80, "/scripts/imreg/domenq.asp?domain=%2&domainType=%3"));
        this.vecTLD.addElement(new WhoisServerBasic(".in", "whois.registry.in"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".io"));
        this.vecTLD.addElement(new WhoisServerBasic(".ir", "whois.nic.ir"));
        this.vecTLD.addElement(new WhoisServerBasic(".is", "whois.isnic.is"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".it"));
        this.vecTLD.addElement(new WhoisServerBasic(".je", "whois.channelisles.net"));
        this.vecTLD.addElement(new WhoisServer(".jo", 1, "www.nis.gov.jo", 80, "/pls/dns/jo_organization_info?dom=%2&subd=%5"));
        this.vecTLD.addElement(new WhoisServerBasic(".jp", "whois.jprs.jp"));
        this.vecTLD.addElement(new WhoisServerBasic(".ke", "whois.kenic.or.ke"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".kg", "http://www.domain.kg/whois.html"));
        this.vecTLD.addElement(new WhoisServer(".ki", 1, "www.ki", 80, "/dns/whois.html?subdomain=%2&tld=%4&whois=Submit"));
        this.vecTLD.addElement(new WhoisServerBasic(".kr", "whois.nic.or.kr"));
        this.vecTLD.addElement(new WhoisServer(".ky", 1, "kynseweb.messagesecure.com", 80, "/whois.asp", "domain_name_pref=%2&domain_name_suff=%3"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".kz"));
        this.vecTLD.addElement(new WhoisServerBasic(".la", "whois2.afilias-grs.net"));
        this.vecTLD.addElement(new WhoisServer(".lb", 1, "www.aub.edu.lb", 80, "/cgi-bin/lbdr.pl", "cn=%1&B1=Search"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".li"));
        this.vecTLD.addElement(new WhoisServer(".lk", 1, "www.nic.lk", 80, "/cgi-bin/searchdom2.cgi", "domain=%2&seclev=%3"));
        this.vecTLD.addElement(new WhoisServerBasic(".lt", "whois.domreg.lt"));
        this.vecTLD.addElement(new WhoisServerBasic(".lu", "whois.restena.lu"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".lv"));
        this.vecTLD.addElement(new WhoisServerRipe(".mc"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".mg"));
        this.vecTLD.addElement(new WhoisServer(".mn", 1, "www.nic.mn", 80, "/index.php3?command=owner&domainname=%2"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".mo", "http://www.monic.net.mo/page.php?m=2&n=1"));
        this.vecTLD.addElement(new WhoisServer(".ms", 1, "adamsnames.tc", 80, "/whois/whois.cgi?domain=%1"));
        this.vecTLD.addElement(new WhoisServer(".mt", 1, "www.um.edu.mt", 80, "/cgi-bin/nic/whois?domain=%1"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".mu"));
        this.vecTLD.addElement(new WhoisServer(".mw", 1, "www.registrar.mw", 80, "/index.php?domain=registrar.mw&Submit=Search"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".mx"));
        this.vecTLD.addElement(new WhoisServerBasic(".my", "whois.mynic.net.my"));
        this.vecTLD.addElement(new WhoisServerBasic(".na", "whois.na-nic.com.na"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".nf", "https://secure.nf/index.jsp"));
        this.vecTLD.addElement(new WhoisServer(".ni", 1, "www.nic.ni", 80, "/formatos_whois.php", "enviar=%2&select=%5"));
        this.vecTLD.addElement(new WhoisServerBasic(".nl", "whois.domain-registry.nl"));
        this.vecTLD.addElement(new WhoisServerBasic(".no", "whois.norid.no"));
        this.vecTLD.addElement(new WhoisServer(".np", 1, "www.mos.com.np", 80, "/cgi-bin/search.cgi", "domain_name=%1"));
        this.vecTLD.addElement(new WhoisServer(".nr", 1, "www.cenpac.net.nr", 80, "/dns/whois.html?subdomain=%2&tld=%4&whois=Submit"));
        this.vecTLD.addElement(new WhoisServerBasic(".nu", "whois.nic.nu"));
        this.vecTLD.addElement(new WhoisServerBasic(".nz", "whois.srs.net.nz"));
        this.vecTLD.addElement(new WhoisServer(".pa", 1, "www.nic.pa", 80, "/egh/whois.php?nombre_d=%2&escojer=%3"));
        this.vecTLD.addElement(new WhoisServer(".pe", 1, "www.nic.pe", 80, "/detpublic.php?decid=B&ndom=%1"));
        this.vecTLD.addElement(new WhoisServer(".pk", 1, "pknic.net.pk", 80, "/cgi-bin/pknic-db/bill.html?name=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".pl", "whois.nask.pl"));
        this.vecTLD.addElement(new WhoisServerBasic(".pm", "whois.nic.fr"));
        this.vecTLD.addElement(new WhoisServerBasic(".pr", "whois.uprr.pr"));
        this.vecTLD.addElement(new WhoisServerBasic(".pt", "whois.dns.pt"));
        this.vecTLD.addElement(new WhoisServer(".pw", 1, "whois.pwregistry.pw", 80, "/cgi-bin/whois.cgi", "host=%1"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".re"));
        this.vecTLD.addElement(new WhoisServerBasic(".ro", "whois.rotld.ro"));
        this.vecTLD.addElement(new WhoisServerBasic(".ru", "whois.ripn.net"));
        this.vecTLD.addElement(new WhoisServerBasic(".sa", "saudinic.net.sa"));
        this.vecTLD.addElement(new WhoisServerBasic(".sb", "whois.nic.net.sb"));
        this.vecTLD.addElement(new WhoisServer(".se", 1, "www.nic-se.se", 80, "/cgi-bin/whois/www-to-whois?domain=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".sg", "whois.nic.net.sg"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".sh"));
        this.vecTLD.addElement(new WhoisServerBasic(".si", "whois.arnes.si"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".sj", "http://www.norid.no/domenenavnbaser/bv-sj.html"));
        this.vecTLD.addElement(new WhoisServerBasic(".sk", "whois.sk-nic.sk"));
        this.vecTLD.addElement(new WhoisServerRipe(".sm"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".st"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".sv", "http://www.uca.edu.sv/cgi-bin/wwwisis/svbd.cgi"));
        this.vecTLD.addElement(new WhoisServer(".tc", 1, "adamsnames.tc", 80, "/whois/whois.cgi?domain=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".tf", "whois.afnic.fr"));
        this.vecTLD.addElement(new WhoisServerBasic(".th", "whois.thnic.net"));
        this.vecTLD.addElement(new WhoisServer(".tj", 1, "www.nic.tj", 80, "/cgi/lookup?DOMAIN=%2"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".tk"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".tl", "http://www.nic.tl/whois.jsp"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".tm"));
        this.vecTLD.addElement(new WhoisServer(".tn", 1, "whois.ati.tn", 80, "/index.php", "domain=%2&ext=1&action=whois&submit=ok&B1=Existe+%3F"));
        this.vecTLD.addElement(new WhoisServerBasic(".to", "whois.tonic.to"));
        this.vecTLD.addElement(new WhoisServerHTTP_Redirect(".tp", "http://www.nic.tp/whois.jsp"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".tr"));
        this.vecTLD.addElement(new WhoisServerBasic(".tv", "whois.www.tv"));
        this.vecTLD.addElement(new WhoisServerBasic(".tw", "whois.twnic.net.tw"));
        this.vecTLD.addElement(new WhoisServerBasic(".ua", "whois.net.ua"));
        this.vecTLD.addElement(new WhoisServerBasic(".ug", "whois.co.ug"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".uk"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".us"));
        this.vecTLD.addElement(new WhoisServer(".uy", 1, "www.nic.org.uy", 80, "/cgi/dom.pl", "dominio=%1&mandar=Buscar"));
        this.vecTLD.addElement(new WhoisServerBasic(".uz", "whois.cctld.uz"));
        this.vecTLD.addElement(new WhoisServerRipe(".va"));
        this.vecTLD.addElement(new WhoisServerBasic(".vc", "whois2.afilias-grs.net"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".ve"));
        this.vecTLD.addElement(new WhoisServer(".vg", 1, "adamsnames.tc", 80, "/whois/whois.cgi?domain=%1"));
        this.vecTLD.addElement(new WhoisServer(".vi", 1, "www.nic.vi", 80, "/whois.asp", "text1=%1&submit1=Submit"));
        this.vecTLD.addElement(new WhoisServer(".vu", 1, "www.vunic.vu", 80, "/whois", "whois=%2&B1=Submit"));
        this.vecTLD.addElement(new WhoisServerBasic(".wf", "whois.afnic.fr"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".ws"));
        this.vecTLD.addElement(new WhoisServerNIC_TLD(".yt"));
        this.vecTLD.addElement(new WhoisServer(".ac.za", 1, "whois.ac.za", 80, "/cgi/cgi_DomainQuery.exe?domain=%1"));
        this.vecTLD.addElement(new WhoisServer(".co.za", 1, "co.za", 80, "/cgi-bin/whois.sh?Domain=%1"));
        this.vecTLD.addElement(new WhoisServer(".gov.za", 1, "dnsadmin.gov.za", 80, "/avail/navail.php", "ipnamex=%1&submit=Start"));
        this.vecTLD.addElement(new WhoisServer(".org.za", 1, "www.org.za", 80, "/cgi-bin/rwhois", "domain=%2&format=full"));
        this.vecTLD.addElement(new WhoisServerBasic(".arpa", "whois.ripe.net"));
        this.vecTLD.addElement(new WhoisServer(".com", 0, "whois.internic.net", 43, "=%1"));
        this.vecTLD.addElement(new WhoisServerBasic(".edu", "whois.educause.net"));
        this.vecTLD.addElement(new WhoisServerBasic(".info", "whois.afilias.info"));
        this.vecTLD.addElement(new WhoisServerBasic(".int", "whois.iana.org"));
        this.vecTLD.addElement(new WhoisServerBasic(".net", "whois.internic.net"));
        this.vecTLD.addElement(new WhoisServerBasic(".org", "whois.publicinterestregistry.net"));
        this.vecIP = new Vector();
        this.vecIP.addElement(new WhoisServerBasic("IP", "whois.afrinic.net"));
        this.vecIP.addElement(new WhoisServerBasic("IP", "whois.apnic.net"));
        this.vecIP.addElement(new WhoisServerBasic("IP", "whois.arin.net"));
        this.vecIP.addElement(new WhoisServerBasic("IP", "whois.lacnic.net"));
        this.vecIP.addElement(new WhoisServerBasic("IP", "whois.ripe.net"));
        this.hshTLD = new Hashtable();
        this.hshTLD.put(".ac", "Ascension Island");
        this.hshTLD.put(".ad", "Andorra");
        this.hshTLD.put(".ae", "United Arab Emirates");
        this.hshTLD.put(".af", "Afghanistan");
        this.hshTLD.put(".ag", "Antigua and Barbuda");
        this.hshTLD.put(".ai", "Anguilla");
        this.hshTLD.put(".al", "Albania");
        this.hshTLD.put(".am", "Armenia");
        this.hshTLD.put(".an", "Netherlands Antilles");
        this.hshTLD.put(".ao", "Angola");
        this.hshTLD.put(".aq", "Antarctica");
        this.hshTLD.put(".ar", "Argentina");
        this.hshTLD.put(".as", "American Samoa");
        this.hshTLD.put(".at", "Austria");
        this.hshTLD.put(".au", "Australia");
        this.hshTLD.put(".aw", "Aruba");
        this.hshTLD.put(".az", "Azerbaijan");
        this.hshTLD.put(".ax", "Aland Islands");
        this.hshTLD.put(".ba", "Bosnia and Herzegovina");
        this.hshTLD.put(".bb", "Barbados");
        this.hshTLD.put(".bd", "Bangladesh");
        this.hshTLD.put(".be", "Belgium");
        this.hshTLD.put(".bf", "Burkina Faso");
        this.hshTLD.put(".bg", "Bulgaria");
        this.hshTLD.put(".bh", "Bahrain");
        this.hshTLD.put(".bi", "Burundi");
        this.hshTLD.put(".bj", "Benin");
        this.hshTLD.put(".bm", "Bermuda");
        this.hshTLD.put(".bn", "Brunei Darussalam");
        this.hshTLD.put(".bo", "Bolivia");
        this.hshTLD.put(".br", "Brazil");
        this.hshTLD.put(".bs", "Bahamas");
        this.hshTLD.put(".bt", "Bhutan");
        this.hshTLD.put(".bv", "Bouvet Island");
        this.hshTLD.put(".bw", "Botswana");
        this.hshTLD.put(".by", "Belarus");
        this.hshTLD.put(".bz", "Belize");
        this.hshTLD.put(".ca", "Canada");
        this.hshTLD.put(".cc", "Cocos(Keeling) Islands");
        this.hshTLD.put(".cd", "Congo, The Democratic Republic of the");
        this.hshTLD.put(".cf", "Central African Republic");
        this.hshTLD.put(".cg", "Congo, Republic of");
        this.hshTLD.put(".ch", "Switzerland");
        this.hshTLD.put(".ci", "Cote d ' Ivoire");
        this.hshTLD.put(".ck", "Cook Islands");
        this.hshTLD.put(".cl", "Chile");
        this.hshTLD.put(".cm", "Cameroon");
        this.hshTLD.put(".cn", "China");
        this.hshTLD.put(".co", "Colombia");
        this.hshTLD.put(".cr", "Costa Rica");
        this.hshTLD.put(".cs", "Serbia and Montenegro");
        this.hshTLD.put(".cu", "Cuba");
        this.hshTLD.put(".cv", "Cape Verde");
        this.hshTLD.put(".cx", "Christmas Island");
        this.hshTLD.put(".cy", "Cyprus");
        this.hshTLD.put(".cz", "Czech Republic");
        this.hshTLD.put(".de", "Germany");
        this.hshTLD.put(".dj", "Djibouti");
        this.hshTLD.put(".dk", "Denmark");
        this.hshTLD.put(".dm", "Dominica");
        this.hshTLD.put(".do", "Dominican Republic");
        this.hshTLD.put(".dz", "Algeria");
        this.hshTLD.put(".ec", "Ecuador");
        this.hshTLD.put(".ee", "Estonia");
        this.hshTLD.put(".eg", "Egypt");
        this.hshTLD.put(".eh", "Western Sahara");
        this.hshTLD.put(".er", "Eritrea");
        this.hshTLD.put(".es", "Spain");
        this.hshTLD.put(".et", "Ethiopia");
        this.hshTLD.put(".eu", "European Union");
        this.hshTLD.put(".fi", "Finland");
        this.hshTLD.put(".fj", "Fiji");
        this.hshTLD.put(".fk", "Falkland Islands(Malvinas)");
        this.hshTLD.put(".fm", "Micronesia, Federal State of");
        this.hshTLD.put(".fo", "Faroe Islands");
        this.hshTLD.put(".fr", "France");
        this.hshTLD.put(".ga", "Gabon");
        this.hshTLD.put(".gb", "United Kingdom");
        this.hshTLD.put(".gd", "Grenada");
        this.hshTLD.put(".ge", "Georgia");
        this.hshTLD.put(".gf", "French Guiana");
        this.hshTLD.put(".gg", "Guernsey");
        this.hshTLD.put(".gh", "Ghana");
        this.hshTLD.put(".gi", "Gibraltar");
        this.hshTLD.put(".gl", "Greenland");
        this.hshTLD.put(".gm", "Gambia");
        this.hshTLD.put(".gn", "Guinea");
        this.hshTLD.put(".gp", "Guadeloupe");
        this.hshTLD.put(".gq", "Equatorial Guinea");
        this.hshTLD.put(".gr", "Greece");
        this.hshTLD.put(".gs", "South Georgia and the South Sandwich Islands");
        this.hshTLD.put(".gt", "Guatemala");
        this.hshTLD.put(".gu", "Guam");
        this.hshTLD.put(".gw", "Guinea - Bissau");
        this.hshTLD.put(".gy", "Guyana");
        this.hshTLD.put(".hk", "Hong Kong");
        this.hshTLD.put(".hm", "Heard and McDonald Islands");
        this.hshTLD.put(".hn", "Honduras");
        this.hshTLD.put(".hr", "Croatia / Hrvatska");
        this.hshTLD.put(".ht", "Haiti");
        this.hshTLD.put(".hu", "Hungary");
        this.hshTLD.put(".id", "Indonesia");
        this.hshTLD.put(".ie", "Ireland");
        this.hshTLD.put(".il", "Israel");
        this.hshTLD.put(".im", "Isle of Man");
        this.hshTLD.put(".in", "India");
        this.hshTLD.put(".io", "British Indian Ocean Territory");
        this.hshTLD.put(".iq", "Iraq");
        this.hshTLD.put(".ir", "Iran, Islamic Republic of");
        this.hshTLD.put(".is", "Iceland");
        this.hshTLD.put(".it", "Italy");
        this.hshTLD.put(".je", "Jersey");
        this.hshTLD.put(".jm", "Jamaica");
        this.hshTLD.put(".jo", "Jordan");
        this.hshTLD.put(".jp", "Japan");
        this.hshTLD.put(".ke", "Kenya");
        this.hshTLD.put(".kg", "Kyrgyzstan");
        this.hshTLD.put(".kh", "Cambodia");
        this.hshTLD.put(".ki", "Kiribati");
        this.hshTLD.put(".km", "Comoros");
        this.hshTLD.put(".kn", "Saint Kitts and Nevis");
        this.hshTLD.put(".kp", "Korea, Democratic People ' s Republic");
        this.hshTLD.put(".kr", "Korea, Republic of");
        this.hshTLD.put(".kw", "Kuwait");
        this.hshTLD.put(".ky", "Cayman Islands");
        this.hshTLD.put(".kz", "Kazakhstan");
        this.hshTLD.put(".la", "Lao People ' s Democratic Republic");
        this.hshTLD.put(".lb", "Lebanon");
        this.hshTLD.put(".lc", "Saint Lucia");
        this.hshTLD.put(".li", "Liechtenstein");
        this.hshTLD.put(".lk", "Sri Lanka");
        this.hshTLD.put(".lr", "Liberia");
        this.hshTLD.put(".ls", "Lesotho");
        this.hshTLD.put(".lt", "Lithuania");
        this.hshTLD.put(".lu", "Luxembourg");
        this.hshTLD.put(".lv", "Latvia");
        this.hshTLD.put(".ly", "Libyan Arab Jamahiriya");
        this.hshTLD.put(".ma", "Morocco");
        this.hshTLD.put(".mc", "Monaco");
        this.hshTLD.put(".md", "Moldova, Republic of");
        this.hshTLD.put(".mg", "Madagascar");
        this.hshTLD.put(".mh", "Marshall Islands");
        this.hshTLD.put(".mk", "Macedonia, The Former Yugoslav Republic of");
        this.hshTLD.put(".ml", "Mali");
        this.hshTLD.put(".mm", "Myanmar");
        this.hshTLD.put(".mn", "Mongolia");
        this.hshTLD.put(".mo", "Macau");
        this.hshTLD.put(".mp", "Northern Mariana Islands");
        this.hshTLD.put(".mq", "Martinique");
        this.hshTLD.put(".mr", "Mauritania");
        this.hshTLD.put(".ms", "Montserrat");
        this.hshTLD.put(".mt", "Malta");
        this.hshTLD.put(".mu", "Mauritius");
        this.hshTLD.put(".mv", "Maldives");
        this.hshTLD.put(".mw", "Malawi");
        this.hshTLD.put(".mx", "Mexico");
        this.hshTLD.put(".my", "Malaysia");
        this.hshTLD.put(".mz", "Mozambique");
        this.hshTLD.put(".na", "Namibia");
        this.hshTLD.put(".nc", "New Caledonia");
        this.hshTLD.put(".ne", "Niger");
        this.hshTLD.put(".nf", "Norfolk Island");
        this.hshTLD.put(".ng", "Nigeria");
        this.hshTLD.put(".ni", "Nicaragua");
        this.hshTLD.put(".nl", "Netherlands");
        this.hshTLD.put(".no", "Norway");
        this.hshTLD.put(".np", "Nepal");
        this.hshTLD.put(".nr", "Nauru");
        this.hshTLD.put(".nu", "Niue");
        this.hshTLD.put(".nz", "New Zealand");
        this.hshTLD.put(".om", "Oman");
        this.hshTLD.put(".pa", "Panama");
        this.hshTLD.put(".pe", "Peru");
        this.hshTLD.put(".pf", "French Polynesia");
        this.hshTLD.put(".pg", "Papua New Guinea");
        this.hshTLD.put(".ph", "Philippines");
        this.hshTLD.put(".pk", "Pakistan");
        this.hshTLD.put(".pl", "Poland");
        this.hshTLD.put(".pm", "Saint Pierre and Miquelon");
        this.hshTLD.put(".pn", "Pitcairn Island");
        this.hshTLD.put(".pr", "Puerto Rico");
        this.hshTLD.put(".ps", "Palestinian Territories");
        this.hshTLD.put(".pt", "Portugal");
        this.hshTLD.put(".pw", "Palau");
        this.hshTLD.put(".py", "Paraguay");
        this.hshTLD.put(".qa", "Qatar");
        this.hshTLD.put(".re", "Reunion Island");
        this.hshTLD.put(".ro", "Romania");
        this.hshTLD.put(".ru", "Russian Federation");
        this.hshTLD.put(".rw", "Rwanda");
        this.hshTLD.put(".sa", "Saudi Arabia");
        this.hshTLD.put(".sb", "Solomon Islands");
        this.hshTLD.put(".sc", "Seychelles");
        this.hshTLD.put(".sd", "Sudan");
        this.hshTLD.put(".se", "Sweden");
        this.hshTLD.put(".sg", "Singapore");
        this.hshTLD.put(".sh", "Saint Helena");
        this.hshTLD.put(".si", "Slovenia");
        this.hshTLD.put(".sj", "Svalbard and Jan Mayen Islands");
        this.hshTLD.put(".sk", "Slovak Republic");
        this.hshTLD.put(".sl", "Sierra Leone");
        this.hshTLD.put(".sm", "San Marino");
        this.hshTLD.put(".sn", "Senegal");
        this.hshTLD.put(".so", "Somalia");
        this.hshTLD.put(".sr", "Suriname");
        this.hshTLD.put(".st", "Sao Tome and Principe");
        this.hshTLD.put(".sv", "El Salvador");
        this.hshTLD.put(".sy", "Syrian Arab Republic");
        this.hshTLD.put(".sz", "Swaziland");
        this.hshTLD.put(".tc", "Turks and Caicos Islands");
        this.hshTLD.put(".td", "Chad");
        this.hshTLD.put(".tf", "French Southern Territories");
        this.hshTLD.put(".tg", "Togo");
        this.hshTLD.put(".th", "Thailand");
        this.hshTLD.put(".tj", "Tajikistan");
        this.hshTLD.put(".tk", "Tokelau");
        this.hshTLD.put(".tl", "Timor - Leste");
        this.hshTLD.put(".tm", "Turkmenistan");
        this.hshTLD.put(".tn", "Tunisia");
        this.hshTLD.put(".to", "Tonga");
        this.hshTLD.put(".tp", "East Timor");
        this.hshTLD.put(".tr", "Turkey");
        this.hshTLD.put(".tt", "Trinidad and Tobago");
        this.hshTLD.put(".tv", "Tuvalu");
        this.hshTLD.put(".tw", "Taiwan");
        this.hshTLD.put(".tz", "Tanzania");
        this.hshTLD.put(".ua", "Ukraine");
        this.hshTLD.put(".ug", "Uganda");
        this.hshTLD.put(".uk", "United Kingdom");
        this.hshTLD.put(".um", "United States Minor Outlying Islands");
        this.hshTLD.put(".us", "United States");
        this.hshTLD.put(".uy", "Uruguay");
        this.hshTLD.put(".uz", "Uzbekistan");
        this.hshTLD.put(".va", "Holy See(Vatican City State)");
        this.hshTLD.put(".vc", "Saint Vincent and the Grenadines");
        this.hshTLD.put(".ve", "Venezuela");
        this.hshTLD.put(".vg", "Virgin Islands, British");
        this.hshTLD.put(".vi", "Virgin Islands, U.S.");
        this.hshTLD.put(".vn", "Vietnam");
        this.hshTLD.put(".vu", "Vanuatu");
        this.hshTLD.put(".wf", "Wallis and Futuna Islands");
        this.hshTLD.put(".ws", "Western Samoa");
        this.hshTLD.put(".ye", "Yemen");
        this.hshTLD.put(".yt", "Mayotte");
        this.hshTLD.put(".yu", "Yugoslavia");
        this.hshTLD.put(".za", "South Africa");
        this.hshTLD.put(".zm", "Zambia");
        this.hshTLD.put(".zw", "Zimbabwe");
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIPv4(String strIP) {
        strt = new StringTokenizer(strIP, ".");
        if (strt.countTokens() == 4) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            i = -1;
            try {
                i = Integer.parseInt(strt.nextToken());
            }
            catch (NumberFormatException v0) {
                return false;
            }
            if (i >= 0 && i <= 255) continue;
            return false;
lbl12:
            // 2 sources

            ** while (strt.hasMoreTokens())
        }
lbl13:
        // 1 sources

        return true;
    }

    private boolean isIPv6(String strIP) {
        return strIP.indexOf(":") != -1;
    }

    private void log(String s) {
    }

    private void log(String s, Throwable t) {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: 'whois domain.tld' or 'whois ip'");
            return;
        }
        Whois who = new Whois();
        WhoisResult wr = who.query(args[0]);
        who.dispose();
        switch (wr.intResult) {
            case 1: {
                System.out.println("Sorry, no WHOIS-Server found for your query '" + args[0] + "'");
                return;
            }
            case 2: {
                System.out.println("Error connecting to " + wr.ws.strWhoisHost + ": " + wr.strErrorMessage);
                return;
            }
            case 3: {
                System.out.println("Error sending query to " + wr.ws.strWhoisHost + ": " + wr.strErrorMessage);
                return;
            }
            case 4: {
                System.out.println("Error reading from " + wr.ws.strWhoisHost + ": " + wr.strErrorMessage);
                return;
            }
            case 0: {
                break;
            }
            default: {
                System.out.println("Oops?!");
                return;
            }
        }
        System.out.println("Answer from " + wr.inaServer);
        switch (wr.ws.intQueryType) {
            case 0: {
                int i = 0;
                while (i < wr.strAnswer.length) {
                    System.out.println(wr.strAnswer[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                System.out.println("We have found a webfrontend for your query, but cannot display the result");
                System.out.println("in a console application. Please visit this URL to get the result");
                System.out.println("http://" + wr.ws.strWhoisHost + (wr.ws.intWhoisPort == 80 ? "" : ":" + wr.ws.intWhoisPort));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                System.out.println("We have found a webfrontend for your query, but cannot query it");
                System.out.println("due to other limitations. Please visit this URL to get the result");
                System.out.println("http://" + wr.ws.strWhoisHost + (wr.ws.intWhoisPort == 80 ? "" : ":" + wr.ws.intWhoisPort) + wr.ws.strQuery);
                break;
            }
            default: {
                System.out.println("Oops!?");
                return;
            }
        }
    }

    public WhoisResult query(String string) {
        WhoisServer ws;
        WhoisServer wsTmp;
        int i;
        this.init();
        String strDomain = string.toLowerCase().trim();
        WhoisResult wr = new WhoisResult();
        if (this.isIPv4(strDomain) || this.isIPv6(strDomain)) {
            if (strDomain.startsWith("2002:")) {
                strDomain = Whois.to4decode(strDomain);
            }
            i = 0;
            while (i < this.vecIP.size()) {
                wsTmp = (WhoisServer)this.vecIP.elementAt(i);
                ws = (WhoisServer)wsTmp.clone();
                wr = this.query_ip(ws, strDomain);
                if (wr.intResult == 0) {
                    return wr;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.vecTLD.size()) {
            wsTmp = (WhoisServer)this.vecTLD.elementAt(i);
            ws = (WhoisServer)wsTmp.clone();
            if (strDomain.endsWith(ws.strTLD)) {
                switch (ws.intQueryType) {
                    case 0: {
                        return this.query_basic(ws, strDomain);
                    }
                    case 1: {
                        return this.query_http(ws, strDomain);
                    }
                    case 3: {
                        wr.intResult = 0;
                        wr.ws = ws;
                        return wr;
                    }
                }
            }
            ++i;
        }
        wr.intResult = 1;
        return wr;
    }

    private WhoisResult query_basic(WhoisServer ws, String strDomain) {
        Vector<String> v2;
        Vector<String> v1;
        WhoisResult wr;
        block13: {
            wr = new WhoisResult();
            wr.ws = ws;
            try {
                this.log("Resolving " + ws.strWhoisHost);
                wr.inaServer = InetAddress.getByName(ws.strWhoisHost);
                this.log("Connecting to " + wr.inaServer.toString());
                this.sok = new Socket(wr.inaServer, ws.intWhoisPort);
                this.sok.setSoTimeout(5000);
            }
            catch (IOException e) {
                this.log("Error: " + e.toString());
                wr.intResult = 2;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
            try {
                this.pw = new PrintWriter(new OutputStreamWriter(this.sok.getOutputStream()));
                ws.strQuery = this.query_build(ws.strQuery, strDomain);
                this.log("Sending query '" + ws.strQuery + "'");
                this.pw.println(ws.strQuery);
                this.pw.flush();
            }
            catch (IOException e) {
                this.log("Error during send", e);
                wr.intResult = 3;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
            boolean blnHadText = false;
            boolean blnHadDomain = false;
            v1 = new Vector<String>();
            v2 = new Vector<String>();
            try {
                this.log("Read result");
                this.br = new BufferedReader(new InputStreamReader(this.sok.getInputStream()));
                String strBuffer = null;
                while ((strBuffer = this.br.readLine()) != null) {
                    strBuffer = strBuffer.trim();
                    if (!blnHadText && strBuffer.length() != 0) {
                        blnHadText = true;
                    }
                    if (!blnHadText) continue;
                    v2.addElement(strBuffer);
                    if (!blnHadDomain && strBuffer.toLowerCase().startsWith("domain")) {
                        blnHadDomain = true;
                    }
                    if (!blnHadDomain) continue;
                    v1.addElement(strBuffer);
                }
            }
            catch (IOException e) {
                if (blnHadText) break block13;
                this.log("Error during read", e);
                wr.intResult = 4;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
        }
        this.closeAll();
        if (v1.size() == 0) {
            v1 = v2;
        }
        int i = 0;
        while (i < v1.size()) {
            String s = (String)v1.elementAt(i);
            if ((s = s.trim().toLowerCase()).startsWith("whois server:") && (s = s.substring("whois server:".length()).trim()).length() != 0 && !s.equalsIgnoreCase(ws.strWhoisHost)) {
                this.log("Found reference to different whois server");
                if (this.intRecursionDepth++ < 4) {
                    this.log("Too much recursion, abort");
                    ws.strWhoisHost = s;
                    ws.strQuery = "%1";
                    wr = this.query_basic(ws, strDomain);
                }
                --this.intRecursionDepth;
                return wr;
            }
            ++i;
        }
        wr.intResult = 0;
        wr.strAnswer = new String[v1.size()];
        v1.copyInto(wr.strAnswer);
        return wr;
    }

    /*
     * Unable to fully structure code
     */
    private String query_build(String var1_1, String strDomain) {
        ppDOT = strDomain.indexOf(".");
        if (ppDOT != -1) ** GOTO lbl5
        return strDomain;
lbl-1000:
        // 1 sources

        {
            strQuery = String.valueOf(var1_1.substring(0, (int)var4_4)) + strDomain + var1_1.substring((int)(var4_4 + 2));
lbl5:
            // 2 sources

            ** while ((pp = strQuery.indexOf((String)"%1")) != -1)
        }
lbl6:
        // 2 sources

        while ((pp = strQuery.indexOf("%2")) != -1) {
            strQuery = String.valueOf(strQuery.substring(0, pp)) + strDomain.substring(0, ppDOT) + strQuery.substring(pp + 2);
        }
        while ((pp = strQuery.indexOf("%3")) != -1) {
            strQuery = String.valueOf(strQuery.substring(0, pp)) + strDomain.substring(ppDOT) + strQuery.substring(pp + 2);
        }
        while ((pp = strQuery.indexOf("%4")) != -1) {
            strQuery = String.valueOf(strQuery.substring(0, pp)) + strDomain.substring(ppDOT + 1) + strQuery.substring(pp + 2);
        }
        strSLD = strDomain.substring(ppDOT + 1);
        pp = strSLD.indexOf(".");
        strSLD = pp != -1 ? strSLD.substring(0, pp) : "";
        while ((pp = strQuery.indexOf("%5")) != -1) {
            strQuery = String.valueOf(strQuery.substring(0, pp)) + strSLD + strQuery.substring(pp + 2);
        }
        return strQuery;
    }

    private WhoisResult query_http(WhoisServer ws, String strDomain) {
        WhoisResult wr = new WhoisResult();
        wr.ws = ws;
        Vector<String> v = new Vector<String>();
        try {
            this.log("Resolving " + ws.strWhoisHost);
            wr.inaServer = InetAddress.getByName(ws.strWhoisHost);
            this.log("Connecting to " + wr.inaServer.toString());
            this.sok = new Socket(wr.inaServer, ws.intWhoisPort);
            this.sok.setSoTimeout(30000);
        }
        catch (IOException e) {
            this.log("Error connecting to " + ws.strWhoisHost + ": " + e.toString());
            wr.intResult = 2;
            wr.strErrorMessage = e.toString();
            this.closeAll();
            return wr;
        }
        try {
            this.pw = new PrintWriter(new OutputStreamWriter(this.sok.getOutputStream()));
            ws.strQuery = this.query_build(ws.strQuery, strDomain);
            this.log("Sending query '" + ws.strQuery + "'");
            if (ws.strPostArg != null) {
                this.pw.println("POST " + ws.strQuery + " HTTP/1.1");
            } else {
                this.pw.println("GET " + ws.strQuery + " HTTP/1.1");
            }
            String strReferer = null;
            if (ws.intWhoisPort == 80) {
                this.pw.println("Host: " + ws.strWhoisHost);
                strReferer = "http://" + ws.strWhoisHost + ws.strQuery;
            } else {
                this.pw.println("Host: " + ws.strWhoisHost + ":" + ws.intWhoisPort);
                strReferer = "http://" + ws.strWhoisHost + ":" + ws.intWhoisPort + ws.strQuery;
            }
            this.pw.println("Referer: " + strReferer);
            this.pw.println("User-Agent: java-whoisquery (http://www.zwanzigeins.de)");
            this.pw.println("Accept: text/plain;q=1.0,text/xml,application/xml,application/xhtml+xml,text/html;q=0.9");
            this.pw.println("Accept-Language: de,us");
            this.pw.println("Accept-Charset: ISO-8859-15, US-ASCII");
            this.pw.println("Connection: close");
            if (ws.strPostArg != null) {
                ws.strPostArg = this.query_build(ws.strPostArg, strDomain);
                this.log("Sending POST '" + ws.strPostArg + "'");
                this.pw.println("Content-Type: application/x-www-form-urlencoded");
                this.pw.println("Content-Length: " + ws.strPostArg.length());
                this.pw.println("");
                this.pw.print(ws.strPostArg);
            } else {
                this.pw.println("");
            }
            this.pw.flush();
        }
        catch (IOException e) {
            this.log("Error during send", e);
            wr.intResult = 3;
            wr.strErrorMessage = e.toString();
            this.closeAll();
            return wr;
        }
        try {
            this.log("Read result");
            this.br = new BufferedReader(new InputStreamReader(this.sok.getInputStream()));
            String strBuffer = null;
            boolean blnHaveBody = false;
            while ((strBuffer = this.br.readLine()) != null) {
                if (!blnHaveBody && strBuffer.trim().startsWith("<")) {
                    blnHaveBody = true;
                    continue;
                }
                if (!blnHaveBody) continue;
                v.addElement(strBuffer);
            }
        }
        catch (IOException e) {
            this.log("Error during read", e);
            wr.intResult = 4;
            wr.strErrorMessage = e.toString();
            this.closeAll();
            return wr;
        }
        this.closeAll();
        wr.intResult = 0;
        wr.strAnswer = new String[v.size()];
        v.copyInto(wr.strAnswer);
        return wr;
    }

    private WhoisResult query_ip(WhoisServer ws, String strIP) {
        Vector<String> v;
        WhoisResult wr;
        block15: {
            wr = new WhoisResult();
            v = new Vector<String>();
            wr.ws = ws;
            try {
                this.log("Resolving " + ws.strWhoisHost);
                wr.inaServer = InetAddress.getByName(ws.strWhoisHost);
                this.log("Connecting to " + wr.inaServer.toString());
                this.sok = new Socket(wr.inaServer, ws.intWhoisPort);
                this.sok.setSoTimeout(5000);
            }
            catch (IOException e) {
                this.log("Error: " + e.toString());
                wr.intResult = 2;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
            try {
                this.pw = new PrintWriter(new OutputStreamWriter(this.sok.getOutputStream()));
                ws.strQuery = this.query_build(ws.strQuery, strIP);
                this.log("Sending query '" + ws.strQuery + "'");
                this.pw.println(ws.strQuery);
                this.pw.flush();
            }
            catch (IOException e) {
                this.log("Error during send", e);
                wr.intResult = 3;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
            boolean blnHadResult = false;
            try {
                this.log("Read result");
                this.br = new BufferedReader(new InputStreamReader(this.sok.getInputStream()));
                String strBuffer = null;
                while ((strBuffer = this.br.readLine()) != null) {
                    strBuffer = strBuffer.trim();
                    boolean blnNotResponsible = false;
                    String strCmp = strBuffer.toLowerCase();
                    if (strCmp.startsWith("inetnum:") && strCmp.endsWith("0.0.0.0 - 255.255.255.255")) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.startsWith("inet6num:") && strCmp.endsWith("0::/0")) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.indexOf("no match found") != -1) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.startsWith("referralserver")) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.indexOf("this network range is not allocated to") != -1) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.indexOf("not allocated by") != -1) {
                        blnNotResponsible = true;
                    }
                    if (strCmp.indexOf("is not administered by") != -1) {
                        blnNotResponsible = true;
                    }
                    if (blnNotResponsible) {
                        this.closeAll();
                        wr.intResult = 99;
                        return wr;
                    }
                    v.addElement(strBuffer);
                    blnHadResult = true;
                }
            }
            catch (IOException e) {
                if (blnHadResult) break block15;
                this.log("Error during read", e);
                wr.intResult = 4;
                wr.strErrorMessage = e.toString();
                this.closeAll();
                return wr;
            }
        }
        this.closeAll();
        wr.intResult = 0;
        wr.strAnswer = new String[v.size()];
        v.copyInto(wr.strAnswer);
        return wr;
    }

    private static String to4decode(String string) {
        String strIP = string.substring(5);
        StringTokenizer strt = new StringTokenizer(strIP, ":");
        String strIP12 = strt.nextToken();
        String strIP34 = strt.nextToken();
        while (strIP12.length() < 4) {
            strIP12 = "0" + strIP12;
        }
        while (strIP34.length() < 4) {
            strIP34 = "0" + strIP34;
        }
        int intIP1 = Integer.valueOf(strIP12.substring(0, 2), 16);
        int intIP2 = Integer.valueOf(strIP12.substring(2, 4), 16);
        int intIP3 = Integer.valueOf(strIP34.substring(0, 2), 16);
        int intIP4 = Integer.valueOf(strIP34.substring(2, 4), 16);
        return intIP1 + "." + intIP2 + "." + intIP3 + "." + intIP4;
    }
}

