/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import java.io.Serializable;

public class Tag
implements Serializable {
    private final int _tagType;
    private final Directory _directory;

    public int getTagType() {
        return this._tagType;
    }

    public String getTagTypeHex() {
        String string = Integer.toHexString(this._tagType);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    public String getDescription() throws MetadataException {
        return this._directory.getDescription(this._tagType);
    }

    public String getTagName() {
        return this._directory.getTagName(this._tagType);
    }

    public String getDirectoryName() {
        return this._directory.getName();
    }

    public String toString() {
        String string;
        try {
            string = this.getDescription();
        }
        catch (MetadataException metadataException) {
            string = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "] " + this.getTagName() + " - " + string;
    }

    public Tag(int n, Directory directory) {
        this._tagType = n;
        this._directory = directory;
    }
}

