/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.exif.ExifInfoWriter;
import org.instituteofthefuture.exif.SaveDialog;
import org.instituteofthefuture.gui.GUIUtilities;
import org.instituteofthefuture.gui.ImageBorder;
import org.instituteofthefuture.io.ImageUtilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SizedExifInfoPanel
extends JPanel
implements ActionListener,
IFConstants {
    private static boolean DEBUG = false;
    private ExifInfoWriter myExifWriter;
    public boolean failed;
    private JFrame parent;

    private final void setupInterface() {
        JPanel jPanel;
        JLabel jLabel = new JLabel(this.myExifWriter.getSelectedFileName(), 0);
        jLabel.setFont(new Font("Serif", 0, 20));
        jLabel.setBounds(10, 20, 230, 30);
        ImageIcon imageIcon = new ImageIcon(this.myExifWriter.getSelectedFile().toString());
        ImageUtilities.resizeTo(imageIcon, 200);
        JLabel jLabel2 = new JLabel(imageIcon);
        if (IFConstants.isMacOSX) {
            jPanel = ImageBorder.getOSXImageWellPanel(jLabel2);
        } else {
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel2, "Center");
        }
        jPanel.setBounds(20, 50, 200, 200);
        JButton jButton = new JButton("Export Info File");
        jButton.addActionListener(this);
        jButton.setBounds(30, 270, 180, 26);
        JButton jButton2 = new JButton("Process this Folder");
        jButton2.addActionListener(this);
        jButton2.setBounds(30, 300, 180, 26);
        Object[] objectArray = new String[]{"Tag Name", "Tag Value"};
        SizedExifInfoPanel.output("about to get tags...");
        Object[][] objectArray2 = this.myExifWriter.getTagsAsObjectArray();
        if (objectArray2 == null) {
            this.failed = true;
            return;
        }
        SizedExifInfoPanel.output("got (" + objectArray2.length + ") tags...");
        JTable jTable = new JTable(objectArray2, objectArray);
        GUIUtilities.setCellEditable(jTable, false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 350));
        jScrollPane.setBounds(240, 20, 450, 380);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(700, 450));
        this.add(jLabel);
        this.add(jPanel);
        this.add(jButton);
        this.add(jButton2);
        this.add(jScrollPane);
        this.setVisible(true);
    }

    public void processFolder() {
        SaveDialog saveDialog = new SaveDialog(this.parent);
        if (saveDialog.okToSave()) {
            if (saveDialog.getHTML()) {
                this.myExifWriter.writeInfoForFolder(0);
            } else {
                this.myExifWriter.writeInfoForFolder(1);
            }
        }
    }

    public void writeInfoFile() {
        SaveDialog saveDialog = new SaveDialog(this.parent);
        if (saveDialog.okToSave()) {
            if (saveDialog.getHTML()) {
                this.myExifWriter.writeInfoForImage(0);
            } else {
                this.myExifWriter.writeInfoForImage(1);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (((JButton)object).getText().equals("Export Info File")) {
                this.writeInfoFile();
            } else if (((JButton)object).getText().equals("Process this Folder")) {
                this.processFolder();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Exif Info Panel");
        jFrame.getContentPane().add(new SizedExifInfoPanel(jFrame));
        jFrame.setBounds(10, 10, 700, 450);
        jFrame.setVisible(true);
    }

    public static void output(String string) {
        if (DEBUG) {
            System.out.println(" SizedExifInfoPanel : " + string);
        }
    }

    private final /* synthetic */ void this() {
        this.failed = false;
    }

    public SizedExifInfoPanel(JFrame jFrame, File file) {
        this.this();
        this.parent = jFrame;
        this.myExifWriter = new ExifInfoWriter();
        this.myExifWriter.setFile(file);
        this.setupInterface();
    }

    public SizedExifInfoPanel(JFrame jFrame) {
        this.this();
        this.parent = jFrame;
        this.myExifWriter = new ExifInfoWriter();
        if (this.myExifWriter.selectFile() == null) {
            this.failed = true;
            return;
        }
        this.setupInterface();
    }
}

