/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JPanel;
import org.instituteofthefuture.io.ImageUtilities;

public class JImagePanel
extends JPanel {
    private static boolean DEBUG = false;
    Image image;

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public void setImage(String string) {
        this.image = Toolkit.getDefaultToolkit().getImage(string);
        if (this.image == null) {
            System.out.println("NO IMAGE!");
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image != null) {
            this.setBounds(0, 0, image.getWidth(null), image.getHeight(null));
        }
    }

    public void printInfo() {
        if (DEBUG) {
            System.out.println("Imagesize - " + this.image.getWidth(null) + 'x' + this.image.getHeight(null));
        }
    }

    public int getImgWidth() {
        return this.image.getWidth(null);
    }

    public int getImgHeight() {
        return this.image.getHeight(null);
    }

    public JImagePanel() {
    }

    public JImagePanel(String string) {
        this.image = ImageUtilities.getImageFromResource(string);
    }

    public JImagePanel(String string, Color color) {
        this.setBackground(color);
        this.image = ImageUtilities.getImageFromResource(string);
    }

    public JImagePanel(Image image) {
        this.image = image;
    }
}

