/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import jexifviewer.JBatchData;
import jexifviewer.JBatchDialog;
import jexifviewer.JColChooserData;
import jexifviewer.JColChooserDialog;
import jexifviewer.JExifDataModel;
import jexifviewer.JFileNameFilter;
import jexifviewer.JIfdData;
import jexifviewer.JImgView;
import jexifviewer.JPathTreeNode;
import jexifviewer.JSettingsDialog;
import jexifviewer.Main;
import shared.browser.JBrowser;
import shared.browserlaunch.JBrowserLaunch;
import shared.classpathhelper.JClassPathHelper;
import shared.cvshelper.Cvs;
import shared.dialog.JWaitDialog;
import shared.files.JFileHelper;
import shared.files.JMyFileFilter;
import shared.files.JPathHelper;
import shared.jinfohelper.JInfoHelper;
import shared.popupmenu.JStatusCheckBoxMenuItem;
import shared.popupmenu.JStatusMenu;
import shared.popupmenu.JStatusMenuItem;
import shared.popupmenu.JStatusPopupMenu;
import shared.popupmenu.JStatusRadioButtonMenuItem;
import shared.popupmenu.PopupMenuAdapter;
import shared.progbar.JProgBar;
import shared.proglistener.ProgNotify;
import shared.statusbar.JStatusBar;
import shared.table.JTableHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JMainFrame.java,v 1.10 2010/04/03 07:59:53 reiner Exp $")
public final class JMainFrame
extends JFrame {
    private JSplitPane m_splitPaneVert;
    private JSplitPane m_splitPaneHor;
    private JTable m_table;
    private JTree m_tree;
    private boolean m_bTreePopupMenu = false;
    private JImgView m_imgView;
    public JStatusBar m_statusBar;
    public JProgBar m_progBar;
    private JMenuBar m_menuBar;
    private int m_dekoStyle;
    private float m_zoom;
    private boolean m_bUndecorated;
    private JExifDataModel m_tableData;
    private Timer m_imgDisplayTimer;
    private Timer m_fillListTimer;
    private Timer m_slideshowTimer;
    private JIfdData[] m_preloadData = new JIfdData[2];
    private Thread m_fillListThread = null;
    private Thread m_expandThread = null;
    private boolean m_bImgFullSize = false;
    private int m_dividerSizeVert = 0;
    private int m_dividerSizeHor = 0;
    private double m_dividerLocationVert = 0.0;
    private double m_dividerLocationHor = 0.0;
    public JScrollPane m_imgScrollPane;
    private JScrollPane m_treeScrollPane;
    private JScrollPane m_listScrollPane;
    private PageFormat m_pageFormat = null;
    private JStatusMenuItem m_slideShowStartStop_menuItem;
    private JStatusCheckBoxMenuItem m_slideShowPause_menuItem;
    private JStatusCheckBoxMenuItem m_slideShowLoop_menuItem;
    private JStatusRadioButtonMenuItem[] m_slideShowDirection_menuItem = new JStatusRadioButtonMenuItem[3];
    private ArrayList<Integer> m_slideShowRandomList = new ArrayList();
    private Random m_slideShowRandom = new Random();
    private int m_slideShowRandomNextRow = -1;
    private boolean m_bSlideShowPause = false;
    private boolean m_bInFullScreenMode = false;
    private JBatchData m_batchData = new JBatchData();
    private static final String m_homepage = "http://jexifviewer.sourceforge.net";
    private static final String m_updateFile = "http://jexifviewer.sourceforge.net/update.php";

    public JMainFrame() {
        super("");
        this.updateTitle(null);
        this.setIconImage(Main.m_icon16.getImage());
        this.m_statusBar = new JStatusBar();
        this.m_progBar = new JProgBar(0, 0, 1000);
        this.m_progBar.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = this.m_progBar.getPreferredSize();
        this.m_progBar.setPreferredSize(new Dimension(120, (int)dimension.getHeight()));
        this.m_progBar.setForeground(new Color(0.0f, 0.0f, 0.5f));
        this.m_progBar.setFont(this.m_progBar.getFont().deriveFont(11.0f));
        this.doAddMenuBar();
        this.doInitTimers();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                boolean bl = false;
                if (!(!JMainFrame.this.m_bImgFullSize || keyEvent.getID() != 401 || keyEvent.isShiftDown() || keyEvent.isAltDown() || keyEvent.isAltGraphDown() || keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                    switch (keyEvent.getKeyCode()) {
                        case 40: {
                            int n = JMainFrame.this.m_table.getSelectedRow();
                            if (n >= 0 && JMainFrame.this.m_table.getRowCount() > n + 1) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, n + 1, false);
                            }
                            bl = true;
                            break;
                        }
                        case 38: {
                            int n = JMainFrame.this.m_table.getSelectedRow();
                            if (n > 0) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, n - 1, false);
                            }
                            bl = true;
                            break;
                        }
                        case 34: {
                            int n = JMainFrame.this.m_table.getSelectedRow();
                            if (n >= 0 && JMainFrame.this.m_table.getRowCount() > n + Main.m_settings.getFullScreenPageSize()) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, n + Main.m_settings.getFullScreenPageSize(), false);
                            } else {
                                JTableHelper.selectRow(JMainFrame.this.m_table, JMainFrame.this.m_table.getRowCount() - 1, false);
                            }
                            bl = true;
                            break;
                        }
                        case 33: {
                            int n = JMainFrame.this.m_table.getSelectedRow();
                            if (n > Main.m_settings.getFullScreenPageSize()) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, n - Main.m_settings.getFullScreenPageSize(), false);
                            } else {
                                JTableHelper.selectRow(JMainFrame.this.m_table, 0, false);
                            }
                            bl = true;
                            break;
                        }
                        case 36: {
                            if (JMainFrame.this.m_table.getRowCount() > 0) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, 0, false);
                            }
                            bl = true;
                            break;
                        }
                        case 35: {
                            if (JMainFrame.this.m_table.getRowCount() > 0) {
                                JTableHelper.selectRow(JMainFrame.this.m_table, JMainFrame.this.m_table.getRowCount() - 1, false);
                            }
                            bl = true;
                        }
                    }
                }
                return bl;
            }
        });
        this.m_tableData = new JExifDataModel(Main.m_settings.getResBundle(), Main.m_settings.m_sortData);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JMainFrame.this.m_imgView.setJpg(null);
                JMainFrame.this.doSaveSettings();
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (Main.m_settings.getExtendedState() == 6) {
                    JMainFrame.this.setExtendedState(6);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JMainFrame.this.m_splitPaneHor.setDividerLocation(Main.m_settings.getHorDividerLocation());
                        JMainFrame.this.m_splitPaneVert.setDividerLocation(Main.m_settings.getVertDividerLocation());
                    }
                });
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!JMainFrame.this.m_bInFullScreenMode && JMainFrame.this.getExtendedState() != 6) {
                    Main.m_settings.setSize(JMainFrame.this.getSize());
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if (!JMainFrame.this.m_bInFullScreenMode && JMainFrame.this.getExtendedState() != 6 && JMainFrame.this.getBounds().x >= 0 && JMainFrame.this.getBounds().y >= 0) {
                    Main.m_settings.setLocation(JMainFrame.this.getLocation());
                }
            }
        });
        Container container = this.getContentPane();
        this.m_splitPaneHor = new JSplitPane(1, true);
        this.m_splitPaneHor.setOneTouchExpandable(true);
        this.m_splitPaneHor.setResizeWeight(Main.m_settings.getVertResizeWeight());
        this.m_splitPaneVert = new JSplitPane(0, true);
        this.m_splitPaneVert.setOneTouchExpandable(true);
        this.m_splitPaneVert.setResizeWeight(Main.m_settings.getHorResizeWeight());
        this.m_treeScrollPane = new JScrollPane();
        this.m_imgScrollPane = new JScrollPane();
        this.m_imgScrollPane.setBorder(null);
        this.m_listScrollPane = new JScrollPane();
        this.m_table = new JTable(){

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    JIfdData jIfdData = JMainFrame.this.m_tableData.getRowData(n);
                    boolean bl = true;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int n2 = -1;
                    for (int n3 : Main.m_settings.m_toolTipTags) {
                        if (n3 >= 0 && !jIfdData.isTagPresent(n3)) continue;
                        if (n3 >= 0 || n2 != -1) {
                            arrayList.add(new Integer(n3));
                        }
                        n2 = n3;
                    }
                    if (!arrayList.isEmpty() && (Integer)arrayList.get(0) == -1) {
                        arrayList.remove(0);
                    }
                    if (!arrayList.isEmpty() && (Integer)arrayList.get(arrayList.size() - 1) == -1) {
                        arrayList.remove(arrayList.size() - 1);
                    }
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        Integer n4 = (Integer)object.next();
                        bl = JMainFrame.this.buildTooltipTagEntry(jIfdData, n4, stringBuilder, bl);
                    }
                    stringBuilder.append(Main.m_settings.isToolTipTable() ? "</table></html>" : "</html>");
                    stringBuilder.insert(0, Main.m_settings.isToolTipTable() ? "<html><table>" : "<html>");
                    return stringBuilder.toString();
                }
                return null;
            }
        };
        ToolTipManager.sharedInstance().setDismissDelay(Main.m_settings.getToolTipDismissDelay());
        ToolTipManager.sharedInstance().registerComponent(this.m_table);
        this.m_table.setAutoCreateColumnsFromModel(false);
        this.m_table.setModel(this.m_tableData);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel;
                if (!listSelectionEvent.getValueIsAdjusting() && !(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    if (Main.m_settings.isDebug()) {
                        System.err.println("Table selection changed");
                    }
                    if (JMainFrame.this.m_imgDisplayTimer.getDelay() == 0) {
                        JMainFrame.this.doSetImg();
                    } else {
                        JMainFrame.this.m_imgDisplayTimer.restart();
                    }
                }
            }
        });
        this.doAddGPSHandler();
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(115, 0), "slideshow_startstop");
        this.m_imgScrollPane.getActionMap().put("slideshow_startstop", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doStartStopSlideShow();
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "slideshow_pause");
        this.m_imgScrollPane.getActionMap().put("slideshow_pause", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doSlideShowPause();
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "del");
        this.m_imgScrollPane.getActionMap().put("del", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doDel(-1);
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(82, 128), "ctrl_r");
        this.m_imgScrollPane.getActionMap().put("ctrl_r", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doRename();
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(80, 128), "ctrl_p");
        this.m_imgScrollPane.getActionMap().put("ctrl_p", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doCopy(-1, false);
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(77, 128), "ctrl_m");
        this.m_imgScrollPane.getActionMap().put("ctrl_m", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doMove();
            }
        });
        this.m_imgScrollPane.getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), "down");
        this.m_imgScrollPane.getActionMap().put("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JMainFrame.this.m_table.getSelectedRow();
                if (n >= 0 && JMainFrame.this.m_table.getRowCount() < n + 1) {
                    JTableHelper.selectRow(JMainFrame.this.m_table, n + 1, false);
                }
            }
        });
        this.m_listScrollPane.setViewportView(this.m_table);
        File[] fileArray = File.listRoots();
        JPathTreeNode jPathTreeNode = null;
        jPathTreeNode = new JPathTreeNode("/", false, true);
        this.m_tree = new JTree(){

            public String getToolTipText(MouseEvent mouseEvent) {
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    return JMainFrame.this.getPathFromTreePath(treePath);
                }
                return null;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        this.m_tree.setRootVisible(false);
        if (Main.m_settings.m_homeDir != null) {
            for (String object : Main.m_settings.m_homeDir) {
                jPathTreeNode.add(new JPathTreeNode(object, !JPathTreeNode.hasChilds(new File(object)), false, true));
            }
        }
        if (fileArray.length == 1) {
            jPathTreeNode.add(new JPathTreeNode(fileArray[0].getPath(), false, false));
        } else {
            for (File file : fileArray) {
                jPathTreeNode.add(new JPathTreeNode(file.getPath(), false, false));
            }
        }
        ((DefaultTreeModel)this.m_tree.getModel()).setRoot(jPathTreeNode);
        this.m_treeScrollPane.setViewportView(this.m_tree);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.doAddTreeSelectionListener();
        this.doAddTreeExpandListener();
        this.doAddTreePopupMenu();
        try {
            this.m_tree.fireTreeWillExpand(new TreePath(jPathTreeNode));
        }
        catch (ExpandVetoException expandVetoException) {
            // empty catch block
        }
        this.m_splitPaneVert.setBorder(null);
        this.m_splitPaneVert.setTopComponent(this.m_treeScrollPane);
        this.m_splitPaneVert.setBottomComponent(this.m_imgScrollPane);
        this.m_imgView = new JImgView(Main.m_settings.getImgCacheSize());
        this.doAddImgListener();
        this.m_imgScrollPane.setViewportView(this.m_imgView);
        this.m_splitPaneHor.setBorder(null);
        this.m_splitPaneHor.setLeftComponent(this.m_splitPaneVert);
        this.m_splitPaneHor.setRightComponent(this.m_listScrollPane);
        container.setLayout(new BorderLayout());
        container.add((Component)this.m_splitPaneHor, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.m_statusBar, "Center");
        jPanel.add((Component)this.m_progBar, "East");
        container.add((Component)jPanel, "South");
        this.doSetTableCols();
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        jTableHeader.setResizingAllowed(true);
        jTableHeader.setForeground(Color.RED);
        this.doAddTableHeaderMenu();
        this.doAddTableMenu();
        this.doAddTableMouseListener();
        this.doInitTableCols();
        if (Main.m_settings.isCheckUpdate()) {
            Thread thread = new Thread(){

                public void run() {
                    JMainFrame.this.doCheckForUpdates(false);
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    private boolean buildTooltipTagEntry(JIfdData jIfdData, int n, StringBuilder stringBuilder, boolean bl) {
        if (n != 69632) {
            if (n < 0) {
                if (!bl) {
                    stringBuilder.append(Main.m_settings.isToolTipTable() ? "<tr><td colspan=\"2\"><hr></td></tr>" : "<hr>");
                    bl = true;
                }
            } else {
                if (!Main.m_settings.isToolTipTable() && !bl) {
                    stringBuilder.append("<br>");
                }
                if (Main.m_settings.isToolTipTable()) {
                    stringBuilder.append("<tr><td>");
                }
                if (Main.m_settings.isToolTipBold()) {
                    stringBuilder.append("<b>");
                }
                stringBuilder.append(Main.getString(String.format("colheader_tag_0x%1$04X", n)));
                stringBuilder.append(Main.m_settings.isToolTipBold() ? ":</b> " : ": ");
                if (Main.m_settings.isToolTipTable()) {
                    stringBuilder.append("</td><td>");
                }
                String string = JExifDataModel.getTagValue(jIfdData, n).toString();
                if (n == 270 && string.length() > 30) {
                    stringBuilder.append(string.substring(0, 30));
                    stringBuilder.append(" ...");
                } else {
                    stringBuilder.append(string);
                }
                if (Main.m_settings.isToolTipTable()) {
                    stringBuilder.append("</tr>");
                }
                bl = false;
            }
        }
        return bl;
    }

    private void doAddGPSHandler() {
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JIfdData jIfdData;
                int n;
                int n2;
                TableColumnModel tableColumnModel = JMainFrame.this.m_table.getColumnModel();
                int n3 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n3 >= 0 && (n2 = tableColumnModel.getColumn(n3).getModelIndex()) >= 0 && (n = JExifDataModel.m_colTag[n2]) == 69632 && (n2 = JMainFrame.this.m_table.getSelectedRow()) >= 0 && (jIfdData = JMainFrame.this.m_tableData.getRowData(n2)).isTagPresent(n)) {
                    Date date;
                    float f = jIfdData.getGPSLatitude();
                    if (jIfdData.getGPSLatitudeRef().equals("S")) {
                        f = -f;
                    }
                    float f2 = jIfdData.getGPSLongitude();
                    if (jIfdData.getGPSLongitudeRef().equals("W")) {
                        f2 = -f2;
                    }
                    if ((date = JIfdData.getDateFromString(jIfdData.getDigitizedDateTime())) == null) {
                        date = jIfdData.getFileDate();
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
                    StringBuffer stringBuffer = new StringBuffer();
                    simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                    String string = stringBuffer + ", " + DateFormat.getDateInstance(1).format(date);
                    String string2 = DateFormat.getTimeInstance(2).format(date);
                    String string3 = jIfdData.getFullFileName();
                    String string4 = String.format(Main.getString("data_gps_title"), string3, string, string2);
                    String string5 = JExifDataModel.getTagValue(jIfdData, 65538).toString();
                    String string6 = JExifDataModel.getTagValue(jIfdData, 65540).toString();
                    String string7 = "";
                    if (jIfdData.isTagPresent(65542)) {
                        string7 = JExifDataModel.getTagValue(jIfdData, 65542).toString();
                    }
                    String string8 = String.format(Main.getString("data_gps_info"), string3, string, string2, string5, string6, string7);
                    try {
                        string4 = URLEncoder.encode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    try {
                        string8 = URLEncoder.encode(string8, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n4 = (int)((float)dimension.width * 0.66f);
                    int n5 = (int)((float)dimension.height * 0.66f);
                    String string9 = "";
                    Locale locale = Locale.getDefault();
                    Locale.setDefault(Locale.US);
                    int n6 = tableColumnModel.getColumn(n3).getWidth() / 3;
                    int n7 = 0;
                    for (int i = 0; i < n3; ++i) {
                        n7 += tableColumnModel.getColumn(i).getWidth();
                    }
                    n7 = mouseEvent.getX() - n7;
                    string9 = n7 < n6 ? String.format(Main.getString("data_gps_gmlinkhttp"), Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f), Float.valueOf(f2), "hybrid", 15, string8, string4, n4, n5) : (n7 >= n6 && n7 < 2 * n6 ? String.format(Main.getString("data_gps_velinkhttp"), Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f), Float.valueOf(f2), "birdhybrid", 15, string8, string4, n4, n5) : String.format(Main.getString("data_gps_oslinkhttp"), Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f), Float.valueOf(f2), "nik", 15, string8, string4, n4, n5));
                    Locale.setDefault(locale);
                    JBrowserLaunch.openURL(string9);
                }
            }
        });
    }

    private void doDel(int n) {
        int n2 = n = n >= 0 ? n : this.m_table.getSelectedRow();
        if (n >= 0) {
            JIfdData jIfdData = this.m_tableData.getRowData(n);
            File file = new File(jIfdData.getFilePath());
            if (!Main.m_settings.isDelConfirm() || JOptionPane.showConfirmDialog(this, String.format(Main.getString("del_confirm"), file.getPath()), Main.getMessageBoxCaption(), 0, 2) == 0) {
                if (file.delete()) {
                    this.m_tableData.removeRow(n);
                    this.m_imgView.removeFromCache(file.getPath());
                    if (this.m_imgView.getIfdData() == jIfdData) {
                        this.m_imgView.setJpg(null);
                        this.updateTitle(null);
                    }
                    if (this.m_tableData.getRowCount() <= n) {
                        --n;
                    }
                    if (n >= 0) {
                        this.selectRow(n, true);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, String.format(Main.getString("del_err"), file.getPath()), Main.getMessageBoxCaption(), 0);
                }
            }
        }
    }

    private void doRename() {
        int n = this.m_table.getSelectedRow();
        if (n >= 0) {
            JIfdData jIfdData = this.m_tableData.getRowData(n);
            File file = new File(jIfdData.getFilePath());
            String string = (String)JOptionPane.showInputDialog(this, Main.getString("rename_msg"), Main.getMessageBoxCaption(), 3, null, null, file.getName());
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(JPathHelper.getFolder(file));
                JPathHelper.addSeparator(stringBuilder);
                stringBuilder.append(string);
                File file2 = new File(stringBuilder.toString());
                boolean bl = file2.exists();
                if (!bl || !Main.m_settings.isOverwriteConfirm() || JOptionPane.showConfirmDialog(Main.m_mainFrame, String.format(Main.getString("rename_overwrite_confirm"), file2.getPath()), Main.getMessageBoxCaption(), 0, 2) == 0) {
                    if (file.renameTo(file2)) {
                        int n2 = -1;
                        if (bl) {
                            n2 = this.m_tableData.findRow(file2.getPath());
                        }
                        jIfdData.setFilePath(file2.getPath());
                        this.m_tableData.fireTableCellUpdated(n, 0);
                        if (n2 >= 0) {
                            this.m_tableData.removeRow(n2);
                        }
                        if (this.m_imgView.getIfdData() == jIfdData) {
                            this.updateTitle(jIfdData);
                        }
                        this.m_tableData.sort();
                        n = this.m_tableData.findRow(jIfdData);
                        if (n >= 0) {
                            this.selectRow(n, false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, String.format(Main.getString("rename_err"), file.getPath(), file2.getPath()), Main.getMessageBoxCaption(), 0);
                    }
                }
            }
        }
    }

    private boolean doCopy(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = n = n >= 0 ? n : this.m_table.getSelectedRow();
        if (n >= 0) {
            JIfdData jIfdData = this.m_tableData.getRowData(n);
            File file = new File(jIfdData.getFilePath());
            JFileChooser jFileChooser = new JFileChooser(bl ? Main.m_settings.getMoveDirectory() : Main.m_settings.getCopyDirectory());
            jFileChooser.setDialogTitle(Main.getString(bl ? "caption_move" : "caption_copy"));
            FileFilter fileFilter = jFileChooser.getAcceptAllFileFilter();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            JMyFileFilter jMyFileFilter = new JMyFileFilter();
            for (String object : Main.m_settings.m_jpgExtensions) {
                jMyFileFilter.addExtension(object);
            }
            jMyFileFilter.setDescription(Main.getString("filefilter_jpg"));
            jFileChooser.addChoosableFileFilter(jMyFileFilter);
            jFileChooser.addChoosableFileFilter(fileFilter);
            jFileChooser.setFileFilter(jMyFileFilter);
            jFileChooser.setSelectedFile(new File(file.getName()));
            if (jFileChooser.showSaveDialog(this) == 0) {
                File file2 = jFileChooser.getSelectedFile();
                if (bl) {
                    Main.m_settings.setMoveDirectory(file2.getParent());
                } else {
                    Main.m_settings.setCopyDirectory(file2.getParent());
                }
                int n3 = file2.exists() ? 1 : 0;
                if (n3 == 0 || !Main.m_settings.isOverwriteConfirm() || JOptionPane.showConfirmDialog(Main.m_mainFrame, String.format(Main.getString("copy_overwrite_confirm"), file2.getPath()), Main.getMessageBoxCaption(), 0, 2) == 0) {
                    if (JFileHelper.copyFile(file, file2)) {
                        int n4;
                        if (n3 != 0 && (n4 = this.m_tableData.findRow(file2.getPath())) >= 0) {
                            JIfdData jIfdData2;
                            this.m_tableData.removeRow(n4);
                            if (JMainFrame.hasJpegExtension(file2) && ((jIfdData2 = new JIfdData()).readFromFile(file2) || Main.m_settings.isDisplayAllInages())) {
                                this.m_tableData.addData(jIfdData2);
                                this.m_tableData.sort();
                            }
                        }
                        bl2 = true;
                    } else {
                        JOptionPane.showMessageDialog(this, String.format(Main.getString("copy_err"), file.getPath(), file2.getPath()), Main.getMessageBoxCaption(), 0);
                    }
                }
            }
        }
        return bl2;
    }

    private void doMove() {
        int n = this.m_table.getSelectedRow();
        if (n >= 0) {
            JIfdData jIfdData = this.m_tableData.getRowData(n);
            if (this.doCopy(n, true) && (n = this.m_tableData.findRow(jIfdData)) >= 0) {
                this.doDel(n);
            }
        }
    }

    private void doSlideShowRandomDeInit() {
        this.m_slideShowRandomList.clear();
        if (Main.m_settings.isDebug()) {
            System.err.println("SlideShow deinit");
        }
        this.m_slideShowRandomNextRow = -1;
    }

    private void doSlideShowRandomInit() {
        this.m_slideShowRandomList.clear();
        int n = this.m_table.getSelectionModel().getMinSelectionIndex();
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            if (i == n) continue;
            this.m_slideShowRandomList.add(i);
        }
        if (Main.m_settings.isDebug()) {
            System.err.println("SlideShow init");
        }
    }

    private void doSlideShowStart() {
        if (this.m_table.getRowCount() > 0) {
            this.doSlideShowRandomInit();
            this.m_slideShowRandomNextRow = this.doSlideShowRandomNextRow();
            this.m_slideshowTimer.start();
            this.m_slideShowStartStop_menuItem.setText(Main.getString("menu_slideshow_stop"), Main.getString("statusbar_menu_slideshow_stop_help"));
            this.m_slideShowPause_menuItem.setEnabled(true);
            this.m_slideShowPause_menuItem.setSelected(false);
            this.m_bSlideShowPause = false;
            if (Main.m_settings.isDebug()) {
                System.err.println("SlideShow start");
            }
            this.updateTitle(this.m_imgView.getIfdData());
        }
    }

    private void doSlideShowStop() {
        this.m_slideshowTimer.stop();
        this.m_slideShowStartStop_menuItem.setText(Main.getString("menu_slideshow_start"), Main.getString("statusbar_menu_slideshow_start_help"));
        this.m_slideShowPause_menuItem.setEnabled(false);
        this.m_slideShowPause_menuItem.setSelected(false);
        this.m_bSlideShowPause = false;
        if (Main.m_settings.isDebug()) {
            System.err.println("SlideShow stop");
        }
        this.doSlideShowRandomDeInit();
        this.updateTitle(this.m_imgView.getIfdData());
    }

    private void doSlideShowPause() {
        if (!this.m_bSlideShowPause && this.m_slideshowTimer.isRunning()) {
            this.m_slideshowTimer.stop();
            this.m_bSlideShowPause = true;
            this.m_slideShowPause_menuItem.setSelected(true);
            if (Main.m_settings.isDebug()) {
                System.err.println("SlideShow pause on");
            }
            this.updateTitle(this.m_imgView.getIfdData());
        } else if (this.m_bSlideShowPause && !this.m_slideshowTimer.isRunning()) {
            this.m_slideshowTimer.start();
            this.m_bSlideShowPause = false;
            this.m_slideShowPause_menuItem.setSelected(false);
            if (Main.m_settings.isDebug()) {
                System.err.println("SlideShow pause off");
            }
            this.updateTitle(this.m_imgView.getIfdData());
        }
    }

    private void doSetSlideShowDirection(int n) {
        Main.m_settings.setSlideShowDirection(n);
        for (int i = 0; i < this.m_slideShowDirection_menuItem.length; ++i) {
            this.m_slideShowDirection_menuItem[i].setSelected(i == n);
        }
    }

    private void doStartStopSlideShow() {
        if (this.m_slideshowTimer.isRunning() || this.m_bSlideShowPause) {
            this.doSlideShowStop();
        } else {
            this.doSlideShowStart();
        }
    }

    private void doAddMenuBar() {
        this.m_menuBar = new JMenuBar();
        this.setJMenuBar(this.m_menuBar);
        JStatusMenu jStatusMenu = new JStatusMenu(Main.getString("menu_slideshow"), this.m_statusBar);
        this.m_menuBar.add(jStatusMenu);
        this.m_slideShowStartStop_menuItem = new JStatusMenuItem(Main.getString("menu_slideshow_start"), Main.getString("statusbar_menu_slideshow_start_help"), this.m_statusBar);
        this.m_slideShowStartStop_menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        jStatusMenu.add(this.m_slideShowStartStop_menuItem);
        this.m_slideShowStartStop_menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doStartStopSlideShow();
            }
        });
        this.m_slideShowPause_menuItem = new JStatusCheckBoxMenuItem(Main.getString("menu_slideshow_pause"), Main.getString("statusbar_menu_slideshow_pause_help"), this.m_statusBar);
        this.m_slideShowPause_menuItem.setAccelerator(KeyStroke.getKeyStroke(32, 0));
        jStatusMenu.add(this.m_slideShowPause_menuItem);
        this.m_slideShowPause_menuItem.setEnabled(false);
        this.m_slideShowPause_menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doSlideShowPause();
            }
        });
        JMenu jMenu = new JMenu(Main.getString("menu_slideshow_direction"));
        jStatusMenu.add(jMenu);
        for (int i = 0; i < this.m_slideShowDirection_menuItem.length; ++i) {
            this.m_slideShowDirection_menuItem[i] = new JStatusRadioButtonMenuItem(Main.getString(String.format("menu_slideshow_direction_%1$d", i)), Main.getString(String.format("statusbar_menu_slideshow_direction_%1$d_help", i)), this.m_statusBar);
            jMenu.add(this.m_slideShowDirection_menuItem[i]);
            final int n = i;
            this.m_slideShowDirection_menuItem[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMainFrame.this.doSetSlideShowDirection(n);
                }
            });
        }
        this.m_slideShowDirection_menuItem[Main.m_settings.getSlideShowDirection()].setSelected(true);
        this.m_slideShowLoop_menuItem = new JStatusCheckBoxMenuItem(Main.getString("menu_slideshow_loop"), Main.getString("statusbar_menu_slideshow_loop_help"), this.m_statusBar);
        this.m_slideShowLoop_menuItem.setState(Main.m_settings.getSlideShowLoop());
        jStatusMenu.add(this.m_slideShowLoop_menuItem);
        this.m_slideShowLoop_menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.m_settings.setSlideShowLoop(!Main.m_settings.getSlideShowLoop());
                JMainFrame.this.m_slideShowLoop_menuItem.setState(Main.m_settings.getSlideShowLoop());
            }
        });
        jStatusMenu = new JStatusMenu(Main.getString("menu_extra"), this.m_statusBar);
        this.m_menuBar.add(jStatusMenu);
        JStatusMenuItem jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_extra_settings"), Main.getString("statusbar_menu_extra_settings_help"), this.m_statusBar);
        jStatusMenu.add(jStatusMenuItem);
        jStatusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSettingsDialog jSettingsDialog = new JSettingsDialog(Main.m_mainFrame);
                if (jSettingsDialog.doModal()) {
                    JMainFrame.this.doSaveSettings();
                    JMainFrame.this.doInitTimers();
                }
            }
        });
        final JMenu jMenu2 = new JMenu(Main.getString("menu_lookandfeel"));
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        boolean bl = false;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray) {
            JStatusRadioButtonMenuItem jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(lookAndFeelInfo.getName(), String.format(Main.getString("statusbar_menu_extra_lf_help"), lookAndFeelInfo.getName()), this.m_statusBar);
            jStatusRadioButtonMenuItem.setActionCommand(lookAndFeelInfo.getClassName());
            jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Main.m_settings.setLookAndFeel(actionEvent.getActionCommand());
                        int n = jMenu2.getItemCount();
                        for (int i = 0; i < n; ++i) {
                            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)jMenu2.getItem(i);
                            jRadioButtonMenuItem.setSelected(jRadioButtonMenuItem.getActionCommand().equals(actionEvent.getActionCommand()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (JOptionPane.showConfirmDialog(Main.m_mainFrame, Main.getString("lookandfeel_restart_ask"), Main.getMessageBoxCaption(), 0, 3) == 0) {
                        try {
                            String string = JClassPathHelper.getClassPath(this, true);
                            if (string != null) {
                                JMainFrame.this.doSaveSettings();
                                JMainFrame.this.setVisible(false);
                                string = JPathHelper.addSeparator(string);
                                string = string + "jstart.jar";
                                String[] stringArray = new String[]{JInfoHelper.getJavaExecutablePath(), "-jar", string};
                                if (Main.m_settings.isDebug()) {
                                    System.err.println(stringArray[0]);
                                    System.err.println(string);
                                }
                                Runtime.getRuntime().exec(stringArray);
                                System.exit(0);
                            }
                        }
                        catch (Exception exception) {
                            JMainFrame.this.setVisible(true);
                            System.err.println(exception);
                        }
                    }
                }
            });
            jStatusRadioButtonMenuItem.setSelected(Main.m_settings.getLookAndFeel().equals(lookAndFeelInfo.getClassName()));
            jMenu2.add(jStatusRadioButtonMenuItem);
        }
        jStatusMenu.add(jMenu2);
        jStatusMenu = new JStatusMenu(Main.getString("menu_help"), this.m_statusBar);
        this.m_menuBar.add(jStatusMenu);
        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_help_help"), Main.getString("statusbar_menu_help_help_help"), this.m_statusBar);
        jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jStatusMenu.add(jStatusMenuItem);
        jStatusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBrowser jBrowser = new JBrowser(Main.m_mainFrame, Main.getString("help_caption"), this.getClass().getResource(Main.getString("helpfile")));
                jBrowser.setVisible(true);
            }
        });
        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_help_web"), Main.getString("statusbar_menu_help_web_help"), this.m_statusBar);
        jStatusMenu.add(jStatusMenuItem);
        jStatusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JBrowserLaunch.openURL(JMainFrame.m_homepage)) {
                    JOptionPane.showMessageDialog(Main.m_mainFrame, String.format(Main.getString("msg_browserlaunch_failed"), JMainFrame.m_homepage), Main.getMessageBoxCaption(), -1, Main.m_icon32);
                }
            }
        });
        jStatusMenu.addSeparator();
        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_help_update"), Main.getString("statusbar_menu_help_update_help"), this.m_statusBar);
        jStatusMenu.add(jStatusMenuItem);
        jStatusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doCheckForUpdates(true);
            }
        });
        jStatusMenu.addSeparator();
        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_help_about"), Main.getString("statusbar_menu_help_about_help"), this.m_statusBar);
        jStatusMenu.add(jStatusMenuItem);
        jStatusMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Author: Reiner Pr\u00f6ls\nVersion: 1.8\nCopyright \u00a9 2006-2010 by Reiner Pr\u00f6ls\nLicense: GPLv3");
                stringBuilder.append("\n\n");
                stringBuilder.append("Homepage:\n");
                stringBuilder.append(JMainFrame.m_homepage);
                stringBuilder.append("\n\n");
                stringBuilder.append(JInfoHelper.getJavaInfo(Main.m_settings.isDebug() ? 2 : 1));
                if (Main.m_settings.isDebug()) {
                    stringBuilder.append("\n\nMemory: (total, free, max): " + Runtime.getRuntime().totalMemory() + ", " + Runtime.getRuntime().freeMemory() + ", " + Runtime.getRuntime().maxMemory());
                }
                JOptionPane.showMessageDialog(Main.m_mainFrame, stringBuilder.toString(), Main.getMessageBoxCaption(), -1, Main.m_icon32);
            }
        });
    }

    public void doCheckForUpdates(boolean bl) {
        boolean bl2;
        block16: {
            bl2 = false;
            try {
                String string;
                if (bl) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                }
                URL uRL = new URL(m_updateFile);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setUseCaches(false);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                bufferedReader.close();
                Pattern pattern = Pattern.compile("jexifviewer_version=(\\d+)\\.(\\d+)");
                Matcher matcher = pattern.matcher(stringBuilder.toString());
                if (matcher.find()) {
                    int n = Integer.parseInt(matcher.group(1));
                    int n2 = Integer.parseInt(matcher.group(2));
                    pattern = Pattern.compile("(\\d+)\\.(\\d+)");
                    matcher = pattern.matcher("1.8");
                    if (matcher.find()) {
                        int n3 = Integer.parseInt(matcher.group(1));
                        int n4 = Integer.parseInt(matcher.group(2));
                        if (bl) {
                            this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        if (n3 < n || n3 == n && n4 < n2) {
                            final String string2 = String.format(Main.getString("upadte_msg"), n3, n4, n, n2);
                            final JMainFrame jMainFrame = this;
                            if (bl) {
                                JOptionPane.showMessageDialog(this, string2, Main.getMessageBoxCaption(), 2);
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(jMainFrame, string2, Main.getMessageBoxCaption(), 2);
                                    }
                                });
                            }
                        } else if (bl && (n3 > n || n3 == n && n4 > n2)) {
                            JOptionPane.showMessageDialog(this, String.format(Main.getString("noupadte_beta_msg"), n3, n4), Main.getMessageBoxCaption(), 1);
                        } else if (bl) {
                            JOptionPane.showMessageDialog(this, String.format(Main.getString("noupadte_msg"), n3, n4), Main.getMessageBoxCaption(), 1);
                        }
                        bl2 = true;
                    }
                }
            }
            catch (IOException iOException) {
                if (!Main.m_settings.isDebug()) break block16;
                System.err.println("Unable to get update infos");
            }
        }
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (!bl2 && bl) {
            JOptionPane.showMessageDialog(this, Main.getString("upadte_err"), Main.getMessageBoxCaption(), 0);
        }
    }

    public void updateTitle(JIfdData jIfdData) {
        String string;
        if (jIfdData != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (jIfdData.getFileSize() < 1024L) {
                stringBuilder.append(Long.toString(jIfdData.getFileSize()));
            } else if (jIfdData.getFileSize() < 0x100000L) {
                stringBuilder.append(String.format("%1$.1f ", Float.valueOf((float)jIfdData.getFileSize() / 1024.0f)));
                stringBuilder.append(Main.getString("KByte"));
            } else if (jIfdData.getFileSize() < 0x40000000L) {
                stringBuilder.append(String.format("%1$.2f ", Float.valueOf((float)jIfdData.getFileSize() / 1048576.0f)));
                stringBuilder.append(Main.getString("MByte"));
            }
            string = jIfdData.getDigitizedDateTime();
            Date date = JIfdData.getDateFromString(string);
            if (date == null) {
                date = jIfdData.getFileDate();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
            String string2 = stringBuffer + ", " + DateFormat.getDateInstance(1).format(date);
            String string3 = DateFormat.getTimeInstance(2).format(date);
            String string4 = "";
            if (this.m_slideshowTimer.isRunning()) {
                switch (Main.m_settings.getSlideShowDirection()) {
                    case 0: {
                        string4 = Main.getString("caption_slideshow_up");
                        break;
                    }
                    case 1: {
                        string4 = Main.getString("caption_slideshow_down");
                        break;
                    }
                    case 2: {
                        string4 = Main.getString("caption_slideshow_random");
                    }
                }
            } else if (this.m_bSlideShowPause) {
                string4 = Main.getString("caption_slideshow_pause");
            }
            string = String.format(Main.getString("caption_img"), Main.getString("caption"), jIfdData.getFullFileName(), string2, string3, stringBuilder.toString(), Float.valueOf(this.m_imgView.getRealZoom() * 100.0f), this.m_slideshowTimer.isRunning() || this.m_bSlideShowPause ? Main.getString("caption_slideshow") + string4 : "");
        } else {
            string = Main.getString("caption");
            if (this.m_slideshowTimer != null && this.m_slideshowTimer.isRunning()) {
                string = string + "  -  " + Main.getString("caption_slideshow");
            }
        }
        string = string.trim();
        this.setTitle(string);
    }

    private void doSetPreload(int n) {
        if (Main.m_settings.isImgUsePreload()) {
            this.m_preloadData[0] = null;
            this.m_preloadData[1] = null;
            if (Main.m_settings.getImgCacheSize() >= 3) {
                if (--n >= 0) {
                    this.m_preloadData[0] = this.m_tableData.getRowData(n);
                }
                n += 2;
            } else {
                ++n;
            }
            if (n < this.m_tableData.getRowCount()) {
                this.m_preloadData[1] = this.m_tableData.getRowData(n);
            }
        }
    }

    public void doSetImg() {
        ListSelectionModel listSelectionModel = this.m_table.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        JIfdData jIfdData = this.m_tableData.getRowData(n);
        if (!this.m_slideshowTimer.isRunning()) {
            this.doSetPreload(n);
        }
        this.m_imgView.setJpg(jIfdData);
    }

    public void doInitTimers() {
        this.m_imgDisplayTimer = new Timer(Main.m_settings.getImgDisplayTimer(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMainFrame.this.doSetImg();
            }
        });
        this.m_imgDisplayTimer.setRepeats(false);
        this.m_imgDisplayTimer.stop();
        this.m_fillListTimer = new Timer(Main.m_settings.getFillListTimer(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JMainFrame.this.getPathFromTreePath(JMainFrame.this.m_tree.getLeadSelectionPath());
                if (string != null) {
                    JMainFrame.this.doFillList(string);
                }
                JMainFrame.this.m_imgView.clearCache();
            }
        });
        this.m_fillListTimer.setRepeats(false);
        this.m_fillListTimer.stop();
        this.m_slideshowTimer = new Timer(Main.m_settings.getSlideShowTimer(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JMainFrame.this.doSlideShowNext() && JMainFrame.this.m_bImgFullSize) {
                    JMainFrame.this.toggleView();
                }
            }
        });
        this.m_slideshowTimer.stop();
    }

    public int doSlideShowRandomNextRow() {
        int n = -1;
        if (this.m_slideShowRandomList.size() > 0) {
            int n2 = this.m_slideShowRandom.nextInt(this.m_slideShowRandomList.size());
            int n3 = n = this.m_slideShowRandomList.isEmpty() ? -1 : this.m_slideShowRandomList.get(n2);
            if (n >= 0) {
                this.m_slideShowRandomList.remove(n2);
                if (Main.m_settings.isImgUsePreload()) {
                    this.m_imgView.preloadImg(this.m_tableData.getRowData(n));
                }
            }
        }
        return n;
    }

    public boolean doSlideShowNext() {
        boolean bl = true;
        if (this.m_table.getRowCount() > 0) {
            int n = this.m_table.getSelectedRow();
            if (n >= 0) {
                switch (Main.m_settings.getSlideShowDirection()) {
                    case 0: {
                        --n;
                        break;
                    }
                    case 1: {
                        ++n;
                        break;
                    }
                    case 2: {
                        n = this.m_slideShowRandomNextRow;
                        if (n < 0) {
                            this.doSlideShowStop();
                            bl = false;
                        }
                        if ((this.m_slideShowRandomNextRow = this.doSlideShowRandomNextRow()) >= 0 || !Main.m_settings.getSlideShowLoop()) break;
                        this.doSlideShowRandomInit();
                        this.m_slideShowRandomNextRow = this.doSlideShowRandomNextRow();
                    }
                }
            } else {
                int n2 = n = Main.m_settings.getSlideShowDirection() != 0 ? 0 : this.m_table.getRowCount() - 1;
            }
            if (Main.m_settings.getSlideShowDirection() != 2) {
                if (n >= this.m_table.getRowCount()) {
                    if (Main.m_settings.getSlideShowLoop()) {
                        n = 0;
                    } else {
                        this.doSlideShowStop();
                        bl = false;
                    }
                } else if (n < 0) {
                    if (Main.m_settings.getSlideShowLoop()) {
                        n = this.m_table.getRowCount() - 1;
                    } else {
                        this.doSlideShowStop();
                        bl = false;
                    }
                }
            }
            if (n >= 0 && n < this.m_table.getRowCount()) {
                this.selectRow(n, true);
                if (Main.m_settings.isDebug()) {
                    System.err.println("SlideShow next: " + n);
                }
                if (bl && Main.m_settings.isImgUsePreload() && Main.m_settings.getSlideShowDirection() != 2) {
                    int n3 = n + (Main.m_settings.getSlideShowDirection() == 1 ? 1 : -1);
                    if (n3 >= this.m_table.getRowCount()) {
                        n3 = 0;
                    }
                    if (n3 < 0) {
                        n3 = this.m_table.getRowCount() - 1;
                    }
                    this.m_imgView.preloadImg(this.m_tableData.getRowData(n3));
                }
            }
        } else {
            this.doSlideShowStop();
            bl = false;
        }
        return bl;
    }

    public void doPreload() {
        if (this.m_preloadData[1] != null) {
            JIfdData jIfdData = this.m_preloadData[1];
            this.m_preloadData[1] = null;
            this.m_imgView.preloadImg(jIfdData);
            return;
        }
        if (this.m_preloadData[0] != null) {
            JIfdData jIfdData = this.m_preloadData[0];
            this.m_preloadData[0] = null;
            this.m_imgView.preloadImg(jIfdData);
        }
    }

    private void doSaveSettings() {
        Serializable serializable;
        int n;
        int n2 = this.m_table.getColumnCount();
        Main.m_settings.m_cols = new short[n2];
        Main.m_settings.m_colWidth = new int[n2];
        TableColumnModel tableColumnModel = this.m_table.getColumnModel();
        for (n = 0; n < n2; ++n) {
            Main.m_settings.m_cols[n] = (short)this.m_table.convertColumnIndexToModel(n);
            serializable = tableColumnModel.getColumn(n);
            Main.m_settings.m_colWidth[n] = ((TableColumn)serializable).getPreferredWidth();
        }
        serializable = (DefaultTreeModel)this.m_tree.getModel();
        JPathTreeNode jPathTreeNode = (JPathTreeNode)((DefaultTreeModel)serializable).getRoot();
        n2 = jPathTreeNode.getChildCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            JPathTreeNode jPathTreeNode2 = (JPathTreeNode)jPathTreeNode.getChildAt(n);
            if (jPathTreeNode2.isDummy() || !jPathTreeNode2.isCustom()) continue;
            arrayList.add(jPathTreeNode2.getName());
        }
        n2 = arrayList.size();
        Main.m_settings.m_homeDir = new String[n2];
        for (n = 0; n < n2; ++n) {
            Main.m_settings.m_homeDir[n] = (String)arrayList.get(n);
        }
        this.doSaveSize();
        Main.m_settings.save(JPathHelper.addSeparator(System.getProperty("user.home")) + "jexifviewer.properties");
    }

    private void doSaveSize() {
        Main.m_settings.setExtendedState(this.getExtendedState());
        if (this.getExtendedState() != 6) {
            Main.m_settings.setSize(this.getSize());
            Main.m_settings.setLocation(this.getLocation());
        }
        if (!this.m_bImgFullSize) {
            Main.m_settings.setHorDividerLocation((double)this.m_splitPaneHor.getDividerLocation() / (double)(this.m_splitPaneHor.getWidth() - this.m_dividerSizeHor));
            Main.m_settings.setVertDividerLocation((double)this.m_splitPaneVert.getDividerLocation() / (double)(this.m_splitPaneVert.getHeight() - this.m_dividerSizeVert));
        } else {
            Main.m_settings.setVertDividerLocation((double)this.m_splitPaneVert.getLastDividerLocation() / (double)(this.m_splitPaneHor.getWidth() - this.m_dividerSizeHor));
            Main.m_settings.setHorDividerLocation((double)this.m_splitPaneHor.getLastDividerLocation() / (double)(this.m_splitPaneVert.getHeight() - this.m_dividerSizeVert));
        }
    }

    private void doSetTableCols() {
        assert (this.m_table.getColumnCount() == 0);
        for (int i = 0; i < Main.m_settings.m_cols.length; ++i) {
            TableColumn tableColumn = new TableColumn();
            tableColumn.setModelIndex(Main.m_settings.m_cols[i]);
            if (JExifDataModel.m_colTag[Main.m_settings.m_cols[i]] == 69632) {
                int n = new ImageIcon(Main.m_url_map).getIconWidth();
                tableColumn.setPreferredWidth(n);
                tableColumn.setMaxWidth(n);
                tableColumn.setMinWidth(n);
            } else {
                tableColumn.setPreferredWidth(Main.m_settings.m_colWidth[i]);
            }
            this.m_table.addColumn(tableColumn);
        }
    }

    private void setTableHeaderValues() {
        int n = this.m_table.getColumnCount();
        TableColumnModel tableColumnModel = this.m_table.getColumnModel();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = this.m_table.convertColumnIndexToModel(i);
            JLabel jLabel = (JLabel)((Object)tableColumn.getHeaderRenderer());
            if (jLabel != null) {
                jLabel.setIcon(this.m_tableData.getColIcon(n2));
                continue;
            }
            String string = this.m_tableData.getColIconStr(n2);
            string = string == null || string.length() == 0 ? this.m_tableData.getColumnName(n2) : String.format("<html><img src=\"%s\">&nbsp;%s</html>", string, this.m_tableData.getColumnName(n2));
            tableColumn.setHeaderValue(string);
        }
    }

    private void doInitTableCols() {
        this.setTableHeaderValues();
        this.m_tableData.sort();
    }

    private void doAddTableMenu() {
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            protected void doShowPopupMenu(MouseEvent mouseEvent) {
                int n = JMainFrame.this.m_table.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    JMainFrame.this.selectRow(n, false);
                    JStatusPopupMenu jStatusPopupMenu = new JStatusPopupMenu(JMainFrame.this.m_statusBar);
                    JStatusMenuItem jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_table_rename"), Main.getString("statusbar_menutable_rename_help"), JMainFrame.this.m_statusBar);
                    jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMainFrame.this.doRename();
                        }
                    });
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_table_copy"), Main.getString("statusbar_menutable_copy_help"), JMainFrame.this.m_statusBar);
                    jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMainFrame.this.doCopy(-1, false);
                        }
                    });
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_table_move"), Main.getString("statusbar_menutable_move_help"), JMainFrame.this.m_statusBar);
                    jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 128));
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMainFrame.this.doMove();
                        }
                    });
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_table_del"), Main.getString("statusbar_menutable_del_help"), JMainFrame.this.m_statusBar);
                    jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMainFrame.this.doDel(-1);
                        }
                    });
                    jStatusPopupMenu.addSeparator();
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("cancel"), Main.getString("statusbar_menutable_cancel_help"), JMainFrame.this.m_statusBar);
                    jStatusPopupMenu.add(jStatusMenuItem);
                    JMainFrame.this.m_statusBar.saveText();
                    jStatusPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void doAddTableHeaderMenu() {
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getButton();
                if (n == 1 || n == 2) {
                    TableColumnModel tableColumnModel = JMainFrame.this.m_table.getColumnModel();
                    int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    n2 = JMainFrame.this.m_table.convertColumnIndexToModel(n2);
                    if (Main.m_settings.isDebug()) {
                        System.err.println("Sort:" + n2);
                    }
                    if (JMainFrame.this.m_tableData.getSortCol() != n2) {
                        JMainFrame.this.m_tableData.setSortCol(n2);
                    } else {
                        JMainFrame.this.m_tableData.setSortUp(!JMainFrame.this.m_tableData.getSortUp());
                    }
                    JMainFrame.this.setTableHeaderValues();
                    JIfdData jIfdData = null;
                    int n3 = JMainFrame.this.m_table.getSelectedRow();
                    if (n3 >= 0) {
                        jIfdData = JMainFrame.this.m_tableData.getRowData(n3);
                    }
                    JMainFrame.this.m_tableData.sort();
                    if (jIfdData != null && (n3 = JMainFrame.this.m_tableData.findRow(jIfdData)) >= 0) {
                        JMainFrame.this.selectRow(n3, true);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            protected void doShowPopupMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JStatusMenuItem jStatusMenuItem;
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    final MouseEvent mouseEvent2 = mouseEvent;
                    final TableModel tableModel = JMainFrame.this.m_table.getModel();
                    if (tableModel.getColumnCount() != JMainFrame.this.m_table.getColumnCount()) {
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_tableheader_add"), Main.getString("statusbar_menutableheader_add_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n;
                                int n2 = tableModel.getColumnCount();
                                int n3 = 0;
                                JColChooserData[] jColChooserDataArray = new JColChooserData[n2 - JMainFrame.this.m_table.getColumnCount()];
                                for (int i = 0; i < n2; ++i) {
                                    n = JMainFrame.this.m_table.convertColumnIndexToView(i);
                                    if (n != -1) continue;
                                    jColChooserDataArray[n3++] = new JColChooserData(tableModel.getColumnName(i), i);
                                }
                                JColChooserDialog jColChooserDialog = new JColChooserDialog(Main.m_mainFrame, jColChooserDataArray);
                                jColChooserDialog.setVisible(true);
                                if (jColChooserDialog.isOk()) {
                                    JColChooserData jColChooserData = jColChooserDialog.getSelectedItem();
                                    TableColumn tableColumn = new TableColumn();
                                    tableColumn.setModelIndex(jColChooserData.m_modelColIndex);
                                    TableColumnModel tableColumnModel = JMainFrame.this.m_table.getColumnModel();
                                    n = tableColumnModel.getColumnIndexAtX(mouseEvent2.getX());
                                    JMainFrame.this.m_table.addColumn(tableColumn);
                                    JMainFrame.this.m_table.moveColumn(JMainFrame.this.m_table.getColumnCount() - 1, n);
                                    if (JExifDataModel.m_colTag[jColChooserData.m_modelColIndex] == 69632) {
                                        int n4 = new ImageIcon(Main.m_url_map).getIconWidth();
                                        tableColumn.setPreferredWidth(n4);
                                        tableColumn.setMaxWidth(n4);
                                        tableColumn.setMinWidth(n4);
                                    }
                                }
                            }
                        });
                    }
                    if (JMainFrame.this.m_table.getColumnCount() > 1) {
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_tableheader_delete"), Main.getString("statusbar_menutableheader_delete_help"), JMainFrame.this.m_statusBar);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                TableColumnModel tableColumnModel = JMainFrame.this.m_table.getColumnModel();
                                int n = tableColumnModel.getColumnIndexAtX(mouseEvent2.getX());
                                TableColumn tableColumn = tableColumnModel.getColumn(n);
                                JMainFrame.this.m_table.removeColumn(tableColumn);
                            }
                        });
                        jPopupMenu.add(jStatusMenuItem);
                    }
                    jPopupMenu.addSeparator();
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("cancel"), Main.getString("statusbar_menutableheader_cancel_help"), JMainFrame.this.m_statusBar);
                    jPopupMenu.add(jStatusMenuItem);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void selectRow(int n, boolean bl) {
        if (n >= 0 && n < this.m_tableData.getRowCount()) {
            this.m_table.setRowSelectionInterval(n, n);
            if (bl) {
                Rectangle rectangle = this.m_table.getCellRect(n, 0, true);
                this.m_table.scrollRectToVisible(rectangle);
            }
        }
    }

    private void doAddTableMouseListener() {
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = JMainFrame.this.m_table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                    JMainFrame.this.doSetPreload(n);
                    int n2 = JMainFrame.this.m_imgDisplayTimer.getInitialDelay();
                    JMainFrame.this.m_imgDisplayTimer.setInitialDelay(0);
                    JMainFrame.this.m_imgDisplayTimer.restart();
                    JMainFrame.this.m_imgDisplayTimer.setInitialDelay(n2);
                }
            }
        });
    }

    private String getPathFromTreePath(TreePath treePath) {
        Object[] objectArray;
        if (treePath != null && (objectArray = treePath.getPath()) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : objectArray) {
                JPathTreeNode jPathTreeNode = (JPathTreeNode)object;
                if (jPathTreeNode.isDummy()) continue;
                JPathHelper.addSeparator(stringBuilder);
                stringBuilder.append(jPathTreeNode.getName());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    protected static boolean hasJpegExtension(File file) {
        String string = JPathHelper.getFileExtension(file);
        for (String string2 : Main.m_settings.m_jpgExtensions) {
            if (!string2.equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void doFillList(final String string) {
        if (Main.m_settings.isDebug()) {
            System.err.println("FillList: " + string);
        }
        if (this.m_fillListThread != null) {
            this.m_fillListThread.interrupt();
            try {
                this.m_fillListThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_tableData.removeAll();
        this.m_fillListThread = new Thread(){

            /*
             * WARNING - void declaration
             */
            public void run() {
                int n = 0;
                int n2 = 0;
                File file = new File(string);
                final File[] fileArray = file.listFiles(new JFileNameFilter());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JMainFrame.this.m_progBar.setString(null);
                    }
                });
                final ArrayList<JIfdData> arrayList = new ArrayList<JIfdData>();
                if (fileArray != null) {
                    for (File file2 : fileArray) {
                        JIfdData jIfdData;
                        if (this.isInterrupted()) break;
                        final int n3 = n2++;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JMainFrame.this.m_progBar.setValue(n3 * 1000 / fileArray.length);
                            }
                        });
                        if (file2.isDirectory() || file2.isHidden() || !file2.canRead()) continue;
                        if (Main.m_settings.isDebug()) {
                            System.err.println("Reading: " + file2.getPath());
                        }
                        if (!(jIfdData = new JIfdData()).readFromFile(file2) && !Main.m_settings.isDisplayAllInages()) continue;
                        ++n;
                        arrayList.add(jIfdData);
                    }
                }
                if (!this.isInterrupted()) {
                    void var6_9;
                    if (n != 0) {
                        String string2 = String.format(Main.getString("statusbar_filllist_items"), n);
                    } else {
                        String string3 = Main.getString("statusbar_filllist_noitems");
                    }
                    void var7_11 = var6_9;
                    SwingUtilities.invokeLater(new Runnable((String)var7_11){
                        final /* synthetic */ String val$message;
                        {
                            this.val$message = string;
                        }

                        public void run() {
                            JMainFrame.this.m_tableData.addData(arrayList);
                            JMainFrame.this.m_tableData.sort();
                            JMainFrame.this.m_statusBar.setText(this.val$message);
                            JMainFrame.this.m_progBar.reset();
                            JMainFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                            JMainFrame.this.m_fillListThread = null;
                        }
                    });
                }
            }
        };
        this.m_statusBar.setText(Main.getString("statusbar_filllist_start"));
        this.m_progBar.setString(Main.getString("progressbar_filllist_scanningdir"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_fillListThread.start();
    }

    private void doAddTreeSelectionListener() {
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath;
                if (!JMainFrame.this.m_bTreePopupMenu && (treePath = treeSelectionEvent.getPath()) != null) {
                    JMainFrame.this.m_fillListTimer.restart();
                    JMainFrame.this.doSlideShowStop();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExpandTree(final TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        final TreePath treePath = treeExpansionEvent.getPath();
        if (treePath == null) return;
        final JPathTreeNode jPathTreeNode = (JPathTreeNode)treePath.getLastPathComponent();
        if (jPathTreeNode.isDummy()) throw new ExpandVetoException(treeExpansionEvent);
        if (this.m_expandThread != null) throw new ExpandVetoException(treeExpansionEvent);
        this.m_expandThread = new Thread(){

            public void run() {
                jPathTreeNode.addChilds(treePath);
                final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)((JTree)treeExpansionEvent.getSource()).getModel();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        defaultTreeModel.nodeStructureChanged(jPathTreeNode);
                        JMainFrame.this.m_progBar.reset();
                        JMainFrame.this.m_statusBar.setText(String.format(Main.getString("statusbar_opendir_items"), jPathTreeNode.getChildCount()));
                        JMainFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        JMainFrame.this.m_expandThread = null;
                    }
                });
            }
        };
        this.m_progBar.setString(Main.getString("progressbar_opendir_scanningdir"));
        this.m_statusBar.setText(Main.getString("statusbar_opendir_start"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_expandThread.start();
    }

    private void doAddTreeExpandListener() {
        this.m_tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                JMainFrame.this.doExpandTree(treeExpansionEvent);
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath != null) {
                    JPathTreeNode jPathTreeNode = (JPathTreeNode)treePath.getLastPathComponent();
                    jPathTreeNode.removeAllChildren();
                    jPathTreeNode.add(new JPathTreeNode("", false, true));
                    ((DefaultTreeModel)JMainFrame.this.m_tree.getModel()).nodeStructureChanged(jPathTreeNode);
                }
            }
        });
    }

    private void doAddTreePopupMenu() {
        this.m_tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.doShowPopupMenu(mouseEvent);
            }

            protected void doShowPopupMenu(MouseEvent mouseEvent) {
                JPathTreeNode jPathTreeNode;
                TreePath treePath;
                if (mouseEvent.isPopupTrigger() && (treePath = JMainFrame.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && !(jPathTreeNode = (JPathTreeNode)treePath.getLastPathComponent()).isDummy()) {
                    JStatusMenuItem jStatusMenuItem;
                    final TreePath treePath2 = JMainFrame.this.m_tree.getLeadSelectionPath();
                    JMainFrame.this.m_bTreePopupMenu = true;
                    JMainFrame.this.m_tree.setSelectionPath(treePath);
                    JMainFrame.this.m_tree.scrollPathToVisible(treePath);
                    JStatusPopupMenu jStatusPopupMenu = new JStatusPopupMenu(JMainFrame.this.m_statusBar);
                    jStatusPopupMenu.addPopupMenuListener(new PopupMenuAdapter(){

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                            JMainFrame.this.m_bTreePopupMenu = false;
                        }
                    });
                    final DefaultTreeModel defaultTreeModel = (DefaultTreeModel)JMainFrame.this.m_tree.getModel();
                    if (jPathTreeNode.isCustom()) {
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_tree_remove"), Main.getString("statusbar_menutree_remove_help"), JMainFrame.this.m_statusBar);
                        jStatusPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jPathTreeNode.getParent();
                                defaultMutableTreeNode.remove(jPathTreeNode);
                                defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                            }
                        });
                    } else {
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_tree_add"), Main.getString("statusbar_menutree_add_help"), JMainFrame.this.m_statusBar);
                        jStatusPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string;
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
                                JPathTreeNode jPathTreeNode = new JPathTreeNode(string, !JPathTreeNode.hasChilds(new File(string = JMainFrame.this.getPathFromTreePath(treePath))), false, true);
                                defaultMutableTreeNode.insert(jPathTreeNode, 0);
                                defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                                JMainFrame.this.m_tree.scrollPathToVisible(treePath2);
                                JMainFrame.this.m_tree.scrollPathToVisible(new TreePath(jPathTreeNode.getPath()));
                            }
                        });
                    }
                    jStatusPopupMenu.addSeparator();
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_tree_batch"), Main.getString("statusbar_menutree_batch_help"), JMainFrame.this.m_statusBar);
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ((JMainFrame)JMainFrame.this).m_batchData.m_srcFolder = JMainFrame.this.getPathFromTreePath(treePath);
                            JMainFrame.this.doBatch();
                        }
                    });
                    jStatusPopupMenu.addSeparator();
                    jStatusMenuItem = new JStatusMenuItem(Main.getString("cancel"), Main.getString("statusbar_menutree_cancel_help"), JMainFrame.this.m_statusBar);
                    jStatusPopupMenu.add(jStatusMenuItem);
                    jStatusPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void doAddImgListener() {
        this.m_imgView.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = 0;
                n = JImgView.getNextOrientation(JMainFrame.this.m_imgView.getOrientation(), mouseWheelEvent.getWheelRotation() >= 0);
                if (n != 0) {
                    JMainFrame.this.m_imgView.setOrientation(n);
                    JMainFrame.this.updateTitle(JMainFrame.this.m_imgView.getIfdData());
                }
            }
        });
        this.m_imgView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JMainFrame.this.m_imgView.isImage()) {
                    if (mouseEvent.getButton() == 1) {
                        if (mouseEvent.getClickCount() == 2) {
                            JMainFrame.this.toggleView();
                        }
                    } else if (mouseEvent.getButton() == 2) {
                        int n = JImgView.getNextFlipOrientation(JMainFrame.this.m_imgView.getOrientation());
                        if (n != 0) {
                            JMainFrame.this.m_imgView.setOrientation(n);
                        }
                    } else if (mouseEvent.getButton() == 3) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.addPopupMenuListener(new PopupMenuAdapter(){

                            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                                JMainFrame.this.m_statusBar.setText(null);
                            }
                        });
                        JStatusMenuItem jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_rotate_90"), Main.getString("statusbar_menuimg_rotate90_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = JImgView.getNextOrientation(JMainFrame.this.m_imgView.getOrientation(), true);
                                if (n != 0) {
                                    JMainFrame.this.m_imgView.setOrientation(n);
                                }
                            }
                        });
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_rotate_-90"), Main.getString("statusbar_menuimg_rotate-90_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = JImgView.getNextOrientation(JMainFrame.this.m_imgView.getOrientation(), false);
                                if (n != 0) {
                                    JMainFrame.this.m_imgView.setOrientation(n);
                                }
                            }
                        });
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_rotate_180"), Main.getString("statusbar_menuimg_rotate180_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = JImgView.getNextOrientation(JMainFrame.this.m_imgView.getOrientation(), true);
                                if ((n = JImgView.getNextOrientation(n, true)) != 0) {
                                    JMainFrame.this.m_imgView.setOrientation(n);
                                }
                            }
                        });
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_rotate_flip"), Main.getString("statusbar_menuimg_rotateflip_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = JImgView.getNextFlipOrientation(JMainFrame.this.m_imgView.getOrientation());
                                if (n != 0) {
                                    JMainFrame.this.m_imgView.setOrientation(n);
                                }
                            }
                        });
                        if (JMainFrame.this.m_imgView.getCustomOrientation() != 0) {
                            jPopupMenu.addSeparator();
                            jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_rotate_original"), Main.getString("statusbar_menuimg_original_help"), JMainFrame.this.m_statusBar);
                            jPopupMenu.add(jStatusMenuItem);
                            jStatusMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    JMainFrame.this.m_imgView.setOrientation(0);
                                }
                            });
                        }
                        jPopupMenu.addSeparator();
                        JMenu jMenu = new JMenu(Main.getString("menu_img_size"));
                        float f = JMainFrame.this.m_imgView.getZoom();
                        JStatusRadioButtonMenuItem jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_fit"), Main.getString("statusbar_menuimg_size_fit_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 0.0f);
                        jStatusRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 128));
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.resetZoom();
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_8"), Main.getString("statusbar_menuimg_size_8_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 8.0f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(8.0f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_4"), Main.getString("statusbar_menuimg_size_4_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 4.0f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(4.0f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_2"), Main.getString("statusbar_menuimg_size_2_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 2.0f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(2.0f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_1"), Main.getString("statusbar_menuimg_size_1_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(106, 128));
                        jStatusRadioButtonMenuItem.setSelected(f == 1.0f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(1.0f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_075"), Main.getString("statusbar_menuimg_size_075_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 0.75f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(0.75f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_050"), Main.getString("statusbar_menuimg_size_050_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(111, 128));
                        jStatusRadioButtonMenuItem.setSelected(f == 0.5f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(0.5f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_025"), Main.getString("statusbar_menuimg_size_025_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 0.25f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(0.25f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_0125"), Main.getString("statusbar_menuimg_size_0125_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 0.125f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(0.125f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jStatusRadioButtonMenuItem = new JStatusRadioButtonMenuItem(Main.getString("menu_img_size_00625"), Main.getString("statusbar_menuimg_size_00625_help"), JMainFrame.this.m_statusBar);
                        jStatusRadioButtonMenuItem.setSelected(f == 0.0625f);
                        jStatusRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoom(0.0625f);
                            }
                        });
                        jMenu.add(jStatusRadioButtonMenuItem);
                        jMenu.addSeparator();
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_size_down"), Main.getString("statusbar_menuimg_size_down_help"), JMainFrame.this.m_statusBar);
                        jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(109, 128));
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoomDown();
                            }
                        });
                        jMenu.add(jStatusMenuItem);
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_size_up"), Main.getString("statusbar_menuimg_size_up_help"), JMainFrame.this.m_statusBar);
                        jStatusMenuItem.setAccelerator(KeyStroke.getKeyStroke(107, 128));
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.setZoomUp();
                            }
                        });
                        jMenu.add(jStatusMenuItem);
                        jPopupMenu.add(jMenu);
                        jPopupMenu.addSeparator();
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_print"), Main.getString("statusbar_menuimg_print_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                PageFormat pageFormat;
                                final PrinterJob printerJob = PrinterJob.getPrinterJob();
                                if (JMainFrame.this.m_pageFormat == null) {
                                    JMainFrame.this.m_pageFormat = printerJob.defaultPage();
                                }
                                if ((pageFormat = printerJob.pageDialog(JMainFrame.this.m_pageFormat)) != JMainFrame.this.m_pageFormat) {
                                    JMainFrame.this.m_pageFormat = pageFormat;
                                    printerJob.setPrintable(JMainFrame.this.m_imgView, JMainFrame.this.m_pageFormat);
                                    printerJob.setJobName(Main.getString("caption"));
                                    if (printerJob.printDialog()) {
                                        Thread thread = new Thread(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Loose catch block
                                             */
                                            public void run() {
                                                try {
                                                    printerJob.print();
                                                }
                                                catch (PrinterException printerException) {
                                                    SwingUtilities.invokeLater(new Runnable(){

                                                        public void run() {
                                                            JMainFrame.this.m_statusBar.setText(Main.getString("statusbar_print_end"));
                                                            JMainFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                                        }
                                                    });
                                                    catch (Throwable throwable) {
                                                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                                        throw throwable;
                                                    }
                                                }
                                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                            }
                                        };
                                        JMainFrame.this.m_statusBar.setText(Main.getString("statusbar_print_start"));
                                        JMainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                        thread.start();
                                    }
                                }
                            }
                        });
                        JIfdData jIfdData = JMainFrame.this.m_imgView.getIfdData();
                        if (jIfdData != null && JMainFrame.this.m_imgView.getCustomOrientation() != 0) {
                            jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_save"), Main.getString("statusbar_menuimg_save_help"), JMainFrame.this.m_statusBar);
                            jStatusMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    JMainFrame.this.m_imgView.saveOrientation(true);
                                }
                            });
                            jPopupMenu.addSeparator();
                            jPopupMenu.add(jStatusMenuItem);
                        }
                        jPopupMenu.addSeparator();
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("menu_img_export"), Main.getString("statusbar_menuimg_export_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        jStatusMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                JMainFrame.this.m_imgView.export();
                            }
                        });
                        jPopupMenu.addSeparator();
                        jStatusMenuItem = new JStatusMenuItem(Main.getString("cancel"), Main.getString("statusbar_menuimg_cancel_help"), JMainFrame.this.m_statusBar);
                        jPopupMenu.add(jStatusMenuItem);
                        JMainFrame.this.m_statusBar.saveText();
                        jPopupMenu.show(JMainFrame.this.m_imgView, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
    }

    public void toggleView() {
        if (this.m_bImgFullSize) {
            if (this.m_bInFullScreenMode) {
                this.setVisible(false);
                this.dispose();
                GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
                this.getRootPane().setWindowDecorationStyle(this.m_dekoStyle);
                this.setUndecorated(this.m_bUndecorated);
                this.m_bInFullScreenMode = false;
            }
            this.m_imgView.setZoom(this.m_zoom);
            ToolTipManager.sharedInstance().setEnabled(true);
            this.setJMenuBar(this.m_menuBar);
            this.m_statusBar.setVisible(true);
            this.m_progBar.setVisible(true);
            this.m_splitPaneVert.setTopComponent(this.m_treeScrollPane);
            this.m_splitPaneHor.setRightComponent(this.m_listScrollPane);
            this.m_bImgFullSize = false;
            this.setResizable(true);
            Main.setSize();
            this.setVisible(true);
            this.requestFocus();
            this.m_table.requestFocus();
            Timer timer = new Timer(150, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Main.m_settings.getExtendedState() == 6) {
                        JMainFrame.this.setExtendedState(6);
                    }
                    Timer timer = new Timer(150, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMainFrame.this.m_splitPaneVert.setDividerSize(JMainFrame.this.m_dividerSizeVert);
                            JMainFrame.this.m_splitPaneHor.setDividerSize(JMainFrame.this.m_dividerSizeHor);
                            JMainFrame.this.m_splitPaneVert.setDividerLocation(JMainFrame.this.m_dividerLocationVert);
                            JMainFrame.this.m_splitPaneHor.setDividerLocation(JMainFrame.this.m_dividerLocationHor);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            });
            timer.setRepeats(false);
            timer.start();
            int n = this.m_table.getSelectedRow();
            if (n >= 0) {
                Rectangle rectangle = this.m_table.getCellRect(n, 0, true);
                this.m_table.scrollRectToVisible(rectangle);
            }
        } else {
            this.m_dividerSizeVert = this.m_splitPaneVert.getDividerSize();
            this.m_dividerSizeHor = this.m_splitPaneHor.getDividerSize();
            this.m_dividerLocationHor = (double)this.m_splitPaneHor.getDividerLocation() / (double)(this.m_splitPaneHor.getWidth() - this.m_dividerSizeHor);
            this.m_dividerLocationVert = (double)this.m_splitPaneVert.getDividerLocation() / (double)(this.m_splitPaneVert.getHeight() - this.m_dividerSizeVert);
            ToolTipManager.sharedInstance().setEnabled(false);
            this.setJMenuBar(null);
            this.m_statusBar.setVisible(false);
            this.m_progBar.setVisible(false);
            this.m_splitPaneVert.setTopComponent(null);
            this.m_splitPaneHor.setRightComponent(null);
            this.m_splitPaneVert.setDividerSize(0);
            this.m_splitPaneVert.setDividerLocation(0.0);
            this.m_splitPaneHor.setDividerSize(0);
            this.m_splitPaneHor.setDividerLocation(1.0);
            if (Main.m_settings.getUseFullScreenMode() || this.getExtendedState() != 6) {
                this.setResizable(false);
            }
            this.m_zoom = this.m_imgView.getZoom();
            this.m_imgView.resetZoom();
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported() && Main.m_settings.getUseFullScreenMode()) {
                this.doSaveSize();
                this.setVisible(false);
                this.dispose();
                this.m_bUndecorated = this.isUndecorated();
                this.m_dekoStyle = this.getRootPane().getWindowDecorationStyle();
                this.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(0);
                GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(Main.m_mainFrame);
                this.m_bInFullScreenMode = true;
            }
            this.m_bImgFullSize = true;
            this.validate();
            this.setVisible(true);
            this.requestFocus();
            try {
                Robot robot = new Robot();
                robot.mouseMove(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth() + 48, -48);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    public void updateTableItem(JIfdData jIfdData) {
        int n = this.m_tableData.findRow(jIfdData.getFilePath());
        if (n >= 0) {
            this.m_tableData.getRowData(n).readFromFile(jIfdData.getFilePath());
            this.m_tableData.fireTableRowsUpdated(n, n);
        }
    }

    public void selectNextItem(boolean bl) {
        ListSelectionModel listSelectionModel = this.m_table.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n >= 0) {
            n = bl ? --n : ++n;
            if (n >= 0 && n < this.m_tableData.getRowCount()) {
                listSelectionModel.setSelectionInterval(n, n);
            }
        }
    }

    private void doBatch() {
        JBatchDialog jBatchDialog = new JBatchDialog(Main.m_mainFrame, this.m_batchData);
        if (jBatchDialog.doModal()) {
            this.doBatch(this.m_batchData);
        }
    }

    private void doBatchCollect(String string, JBatchData jBatchData, ArrayList<File> arrayList) {
        String[] stringArray;
        File file = new File(string);
        string = JPathHelper.addSeparator(string);
        for (String string2 : stringArray = file.list(jBatchData)) {
            string2 = string + string2;
            File file2 = new File(string2);
            if (file2.isDirectory()) {
                if (!jBatchData.m_bRecursive) continue;
                this.doBatchCollect(string2, jBatchData, arrayList);
                continue;
            }
            arrayList.add(new File(string2));
        }
    }

    private void doBatch(final JBatchData jBatchData) {
        jBatchData.m_targetFolder = JPathHelper.addSeparator(jBatchData.m_targetFolder);
        final JWaitDialog jWaitDialog = new JWaitDialog((JFrame)this, Main.getString("wait_scan_caption"), null);
        final ArrayList arrayList = new ArrayList();
        jWaitDialog.setIndeterminate(true);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JMainFrame.this.doBatchCollect(jBatchData.m_srcFolder, jBatchData, arrayList);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jWaitDialog.stop();
                    }
                });
            }
        });
        thread.start();
        jWaitDialog.start();
        final JWaitDialog jWaitDialog2 = new JWaitDialog((JFrame)this, Main.getString("wait_convert_caption"), Main.getString("cancel"));
        jWaitDialog2.setRange(0, arrayList.size());
        thread = new Thread(new Runnable(){

            public void run() {
                int n = 0;
                String string = Main.getString("wait_convert");
                for (File file : arrayList) {
                    Object object;
                    int n2;
                    if (jWaitDialog2.wasCancelled()) break;
                    String string2 = file.getPath();
                    String string3 = jBatchData.m_targetFolder + string2.substring(jBatchData.m_srcFolder.length() + 1, string2.length());
                    string3 = string3.substring(0, string3.length() - JPathHelper.getFileExtension(string3).length());
                    string3 = string3 + jBatchData.getTargetExtension();
                    String string4 = JPathHelper.getBaseFileName(string3);
                    String string5 = JPathHelper.addSeparator(JPathHelper.getFolder(string3));
                    String string6 = JPathHelper.getFileExtension(string3);
                    File file2 = new File(string2);
                    string3 = string5 + jBatchData.m_targetTemplate.replaceAll("%1", string4) + "." + string6;
                    File file3 = new File(string3);
                    if (!file2.equals(file3)) {
                        n2 = 0;
                        object = new File(JPathHelper.getFolder(file3));
                        if (((File)object).exists() || ((File)object).mkdirs()) {
                            try {
                                JIfdData jIfdData = new JIfdData(file2);
                                BufferedImage bufferedImage = ImageIO.read(file2);
                                switch (jBatchData.m_targetFormat) {
                                    case 1: {
                                        JMainFrame.this.m_imgView.saveJPG(file3, bufferedImage, jIfdData, jBatchData.m_scaleFactor, jBatchData.m_quality, jBatchData.m_bOptimizedHuffmanTable);
                                        break;
                                    }
                                    case 2: {
                                        JMainFrame.this.m_imgView.savePNG(file3, bufferedImage, jIfdData, jBatchData.m_scaleFactor);
                                        break;
                                    }
                                    case 4: {
                                        JMainFrame.this.m_imgView.saveBMP(file3, bufferedImage, jIfdData, jBatchData.m_scaleFactor);
                                    }
                                }
                            }
                            catch (IOException iOException) {}
                        } else if (Main.m_settings.isDebug()) {
                            System.err.println("Unable to ceate directory: " + object);
                        }
                    } else if (Main.m_settings.isDebug()) {
                        System.err.println("Source and target are identical: " + file3);
                    }
                    n2 = n++;
                    object = String.format(string, string4 + "." + string6);
                    SwingUtilities.invokeLater(new Runnable((String)object){
                        final /* synthetic */ String val$str;
                        {
                            this.val$str = string;
                        }

                        public void run() {
                            jWaitDialog2.notify(new ProgNotify(1, n2, this.val$str));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jWaitDialog2.stop();
                    }
                });
            }
        });
        thread.start();
        jWaitDialog2.start();
    }
}

