/*This computer program is copyrighted by Douglas M. Eagleson, 217 East Deer Park Dr.
Gaithersburg, MD 20877.  

Copyright Notice
This freeware may be copied and passed on to others for non-commercial research use only,
provided the notice of copyright shown below is placed on
the label of the copied disk and that no alterations or changes are made to
the software, or Copyright notice, below.

All other rights are reserved.


Software Copyright (c)2001 Douglas M. Eagleson

Please read the following disclaimer of liability before using the software.
If you do not accept fully the terms and conditions of use described below,
do not use the software.

THIS FREEWARE VERSION OF class Logic IS SUPPLIED
WITHOUT WARRANTY OF ANY KIND INCLUDING , BUT NOT 
LIMITED TO ANY IMPLIED WARRANTIES OF 
MERCHANTABILITY OR FITNESS FOR ANY PURPOSE.

UNDER NO CIRCUMSTANCES SHALL Douglas Eagleson 
NOR HIS AGENTS, HEIRS OR SUCCESSORS BE LIABLE FOR
ANY DAMAGES, INCLUDING CONSEQUENTIAL, INCIDENTAL
OR SPECIAL DAMAGES ARISING DIRECTLY OR INDIRECTLY
FROM ITS USE. 


The mathematical logic implemented by this class, comprises the concept of generalized
matrix mathematics.  The term shuffling function is used to refer to this basic logical operation
of integer matrix mathematics.  It is a logic very ammenable to the creation of linguistic
definitions and quantum mechanical definitions.

Please note that generalized mathematical matrix operations are inclusive of the standard
arithmatic operations(+,-,/,*).  Shuffling is a fundamental logic of symbolic manipulation
and can implement the standard operations-with significant programming effort.  This is
a CLASS of mathematical operation NOT SIMPLE LIKE ADDITION.

The integer function in this example was intended to be a constant = 1, except an encryption
key was included for another reason, to make three unique shuffles for the GPS application, 
and creates an unelucidatable, but wholly definable function. To make the function, i.e. the logic
applied to the shuffle, be a unit constant, "the key" must be set to 1.  And several nested loops
must be removed, also, leaving a single loop.  Be warned- This program is not for encryption
use, it is a very simple function.

***The key to thinking in such a general symbolic way is to realise that the range of a continous
integer function must always be explicitly included in the matrice's definition.***  The logic
of the function is then reducable to a set of matrix shuffling operation boundaries.

Given this concept, this mathematics may implement the Calculus.

Note: This is a non-standard mathematics. P.S. The Integral must not use a graphical
interpretation and functional continuity must be defined without a spatial continuity concept.
Philosophically, mathematics are purely descriptions of our error-prone observations.
An integer is defined to include observation results in decimal point format.  Significant
digits and unit analysis are real controling factors in any system.
*/

//	THIS java class IS INCLUDED AS INFORMATION ONLY WITH THE moddes ENCRYPTION PROGRAM.

public class Logic {

int h;
int i;
int j;
int k;
int l;
int m;
int n;
int o;
int p;
int q;
int r;
int Z[] = new int[9];
int arr[] = new int[59];
int A[] = new int[59];
int Key[] = new int[9];
int iterend = 9; // this defines functional logic also.  This is non-standard symbolic logic.
int fix; //selects one of the key values

public Logic () {}

public int[] shuffle ( int A[], int key[][], int fix ) {

for ( i=0; i<9; i++){
        Key[i]= key[fix][i];
} //load key locally

for ( i=0; i<59; i++){
        A[i]=A[i];
} 


for ( h=0; h<1; h++){ //this controls the degree of shuffling, a good shuffle has h=1000

//start of shuffle logic, REMEMBER, IT IS THE LOGIC OF THIS CLASSES OUTCOME THAT IS UNIQUE.	

        for ( i=0; i<59; i++){

        for( j = Key[0]; j<iterend; j++ ) {
                if( (i-j*9) >= 0 ){ 
                Z[0] = A[i-j*9];
                A[i-j*9]= A[i];
                A[i] = Z[0];
                }
        
        for( k = Key[1]; k<iterend; k++ ) {
                if( (i-k*9) >= 0 ){
                Z[1]= A[i-k*9];
                A[i-k*9]= A[i];
                A[i] = Z[1];
                }
        
        for( l = Key[2]; l<iterend; l++ ) {
                if( (i-l*9) >= 0 ){
                Z[2]= A[i-l*9];
                A[i-l*9]= A[i];
                A[i] = Z[2];
                }
        
        for( m = Key[3]; m<iterend; m++ ) {
                if( (i-m*9) >= 0 ){
                Z[3]= A[i-m*9];
                A[i-m*9]= A[i];
                A[i] = Z[3];
                }
        
        for( n = Key[4]; n<iterend; n++ ) {
                if( (i-n*9) >= 0 ){
                Z[4]= A[i-n*9];
                A[i-n*9]= A[i];
                A[i] = Z[4];
                }
        
        for( o = Key[5]; o<iterend; o++ ) {
                if( (i-o*9) >= 0 ){
                Z[5]= A[i-o*9];
                A[i-o*9]= A[i];
                A[i] = Z[5];
                }
        
        for( p = Key[6]; p<iterend; p++ ) {
                if( (i-p*9) >= 0 ){
                Z[6]= A[i-p*9];
                A[i-p*9]= A[i];
                A[i] = Z[6];
                }
        
        for( q = Key[7]; q<iterend; q++ ) {
                if( (i-q*9) >= 0 ){
                Z[7]= A[i-q*9];
                A[i-q*9]= A[i];
                A[i] = Z[7];
                }
        
        for( r = Key[8]; r<iterend; r++ ) {
                if( (i-r*9) >= 0 ){
                Z[8]= A[i-r*9];
                A[i-r*9]= A[i];
                A[i] = Z[8];
                }

        }}}}}}}}};  //nested loops

        } //end of inner step loop , end of shuffle definition

} // end big loop, this partially defines the particular integer function

for(j=0;j<59;j++) {
arr[j]=A[j];
}
return arr;
} //end method



} // end of class
