public interface BlockDevice {
  
  /*
   * Copy the specified block into the buffer (which must
   * be at least as large as the block size).
   */
  public void readBlock (byte[] buffer, int block);

  /*
   * Write the first n bytes of the buffer to the specified
   * block, where n is the block size.
   */
  public void writeBlock (byte[] buffer, int block);

  /*
   * Return the block size of the device.  This may be assumed
   * to be a power of two in the range 128 - 4096.
   */
  public int getBlockSize ();

  /*
   * Return the total number of blocks available on the device.
   * This may be assumed to be at least 100 and less than 2^16.
   */
  public int getNumberOfBlocks ();

}

