/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.BasicFileSystem;
import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.TableDirectoryPane;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AutoRefresher
extends Thread {
    private DirectoryPane pane;
    private Hashtable tableOfContents;
    private boolean blocked = true;
    private boolean killed = false;

    public AutoRefresher(DirectoryPane pane) {
        super("DirectoryPane AutoRefresher");
        this.pane = pane;
        this.tableOfContents = new Hashtable();
        this.setPriority(1);
        this.start();
    }

    private boolean checkForA_DriveParentOnWindows(File dir) {
        boolean fromWinADrive = false;
        File parent = dir;
        if (parent instanceof BasicFileSystem.WindowsDrive && parent.getPath().equals("A:\\")) {
            fromWinADrive = true;
        }
        while ((parent = this.pane.getParentDirectory(parent)) != null) {
            if (!(parent instanceof BasicFileSystem.WindowsDrive) || !parent.getPath().equals("A:\\")) continue;
            fromWinADrive = true;
        }
        return fromWinADrive;
    }

    public synchronized void reset(File dir) {
        if (dir != null) {
            if (this.checkForA_DriveParentOnWindows(dir)) {
                return;
            }
            this.blocked = true;
            if (this.pane instanceof TableDirectoryPane) {
                this.clear();
            }
            File[] contents = this.getAcceptedFilesForDir(dir);
            this.tableOfContents.put(dir, contents);
            this.blocked = false;
        }
    }

    public synchronized void add(File dir) {
        if (dir != null) {
            if (this.checkForA_DriveParentOnWindows(dir)) {
                return;
            }
            if (this.pane instanceof TableDirectoryPane) {
                this.clear();
            }
            File[] contents = this.getAcceptedFilesForDir(dir);
            this.tableOfContents.put(dir, contents);
        }
    }

    public synchronized void remove(File dir) {
        if (dir != null) {
            this.tableOfContents.remove(dir);
        }
    }

    public synchronized void clear() {
        this.tableOfContents.clear();
    }

    public synchronized void block() {
        this.blocked = true;
    }

    public synchronized void unblock() {
        this.blocked = false;
    }

    public void kill() {
        this.killed = true;
    }

    protected File[] getAcceptedFilesForDir(File dir) {
        if (dir == null) {
            return new File[0];
        }
        File[] files = this.pane.getFiles(dir, this.pane.isFileHidingEnabled());
        Vector<File> v = new Vector<File>(files.length);
        int selectionMode = this.pane.getFileSelectionMode();
        switch (selectionMode) {
            case 2: {
                int i = 0;
                while (i < files.length) {
                    File f = files[i];
                    if (this.pane.accept(f)) {
                        v.addElement(f);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < files.length) {
                    File f = files[i];
                    if (this.pane.isTraversable(f) && this.pane.accept(f)) {
                        v.addElement(f);
                    }
                    ++i;
                }
                break;
            }
            case 0: {
                int i = 0;
                while (i < files.length) {
                    File f = files[i];
                    if (!this.pane.isTraversable(f) && this.pane.accept(f)) {
                        v.addElement(f);
                    }
                    ++i;
                }
                break;
            }
        }
        Object[] accepted = new File[v.size()];
        v.copyInto(accepted);
        return accepted;
    }

    protected boolean contains(File element, File[] container) {
        boolean found = false;
        if (element == null) {
            return found;
        }
        int i = 0;
        while (i < container.length) {
            if (element.getPath().equalsIgnoreCase(container[i].getPath())) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    protected boolean check(File curDir) {
        if (curDir != null && this.tableOfContents.containsKey(curDir)) {
            File[] oldContents = (File[])this.tableOfContents.get(curDir);
            int oldCount = oldContents.length;
            File[] newContents = this.getAcceptedFilesForDir(curDir);
            int newCount = newContents.length;
            if (newCount < oldCount) {
                return false;
            }
            if (newCount > oldCount) {
                return false;
            }
            int i = 0;
            while (i < newCount) {
                File f = newContents[i];
                if (!this.contains(f, oldContents)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void doRefresh(final File dir) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoRefresher.this.pane.refresh(dir);
            }
        });
    }

    public void run() {
        while (!this.killed) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            if (this.blocked) continue;
            Enumeration keys = this.tableOfContents.keys();
            while (keys.hasMoreElements()) {
                File key = (File)keys.nextElement();
                if (this.check(key)) continue;
                this.doRefresh(key);
            }
        }
        this.pane = null;
        this.tableOfContents = null;
    }
}

