/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.DefaultTreeFileSystemModel;
import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.ExportComponentsFactory;
import com.hbworks.dirpane.FileFilter;
import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.TreeFileSystemModel;
import com.hbworks.dirpane.plaf.TreeDirectoryPaneUI;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeDirectoryPane
extends DirectoryPane {
    static final long serialVersionUID = 3766162503307801280L;
    private static final String uiClassID = "TreeDirectoryPaneUI";
    public static final String IS_LARGEMODEL_PROPERTY = "largeModelChanged";
    public static final String IS_ROOTVISIBLE_PROPERTY = "rootVisibleChanged";
    public static final String QUEUE_AWTEVENTS_CHANGED_PROPERTY = "queueAWTEventsChanged";
    public static final String SELECTIONMODEL_CHANGED_PROPERTY = "selectionModelChanged";
    public static final String SELECTIONMODE_CHANGED_PROPERTY = "selectionModeChanged";
    public static final String ROOT_CHANGED_PROPERTY = "rootChanged";
    public static final int LOADED_TOSETDIR = 0;
    public static final int LOADED_TOSYNC = 1;
    public static final int LOADED_TORESTORE = 2;
    private boolean largeModel = true;
    private boolean rootVisible = true;
    private boolean queueAWTEvents = true;
    private TreeSelectionModel treeSelectionModel = null;
    private int selectionMode = 4;
    private String rootLocation = null;
    private transient boolean isRebuilding = false;
    private transient boolean isUpdating = false;
    protected transient Vector expansionBuffer = new Vector();
    protected transient TreePath[] expansionCache;
    protected transient TreePath[] selectionCache;
    protected TreeCellRenderer customTreeCellRenderer = null;
    protected transient Vector treeSelectionListeners = null;
    protected transient Vector treeExpansionListeners = null;
    protected transient Vector treeWillExpandListeners = null;

    public TreeDirectoryPane() {
        this(null, null, 2);
    }

    public TreeDirectoryPane(String rootPath) {
        this(rootPath, null, 2);
    }

    public TreeDirectoryPane(String rootPath, FileFilter filter) {
        this(rootPath, filter, 2);
    }

    public TreeDirectoryPane(String rootPath, int mode) {
        this(rootPath, null, mode);
    }

    public TreeDirectoryPane(String rootPath, FileFilter filter, int mode) {
        if (filter != null) {
            this.fileFilter = filter;
            this.addChoosableFileFilter(filter);
        }
        if (mode == 0 || mode == 1 || mode == 2) {
            this.fileSelectionMode = mode;
        }
        this.setModel(this.createFileSystemModel(rootPath));
        this.defFileView.setModel(this.filesystemModel);
        this.addTreeSelectionListener(this.createDefaultSelectionListener());
        this.addTreeExpansionListener(this.createDefaultExpansionListener());
        this.addTreeWillExpandListener(this.createDefaultWillExpandListener());
        this.setCurrentDirectory(this.getRoot().getPathString());
        this.setUserDirectory(this.getHomeDirectory().getPath());
        this.rootLocation = this.getRoot().getPathString();
        this.updateUI();
    }

    protected JTree getTreeFromUI() {
        if (this.ui != null) {
            return ((TreeDirectoryPaneUI)this.ui).getUITree();
        }
        return null;
    }

    public JComboBox getDirectoryComboBox() {
        return ExportComponentsFactory.createTreeDirectoryComboBox(this);
    }

    public JTextField getFilenameField() {
        return ExportComponentsFactory.createTreeFilenameField(this);
    }

    public boolean isRebuilding() {
        return this.isRebuilding;
    }

    public void setRebuilding(boolean building) {
        this.isRebuilding = building;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void setUpdating(boolean update) {
        this.isUpdating = update;
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public void setRootLocation(String loc) {
        this.setRoot(loc);
    }

    public void requestFocus() {
        JTree t = this.getTreeFromUI();
        if (t != null) {
            t.requestFocus();
        }
    }

    public void setLargeModel(boolean newValue) {
        boolean oldValue = this.largeModel;
        this.largeModel = newValue;
        this.firePropertyChange(IS_LARGEMODEL_PROPERTY, oldValue, newValue);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setQueueAWTEvents(boolean newValue) {
        boolean oldValue = this.queueAWTEvents;
        this.queueAWTEvents = newValue;
        this.firePropertyChange(QUEUE_AWTEVENTS_CHANGED_PROPERTY, oldValue, newValue);
    }

    public boolean isQueueAWTEvents() {
        return this.queueAWTEvents;
    }

    public void setRootVisible(boolean newValue) {
        boolean oldValue = this.rootVisible;
        this.rootVisible = newValue;
        this.firePropertyChange(IS_ROOTVISIBLE_PROPERTY, oldValue, newValue);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void addTreeExpansionListener(TreeExpansionListener l) {
        if (this.treeExpansionListeners == null) {
            this.treeExpansionListeners = new Vector();
        }
        this.treeExpansionListeners.addElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.addTreeExpansionListener(l);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener l) {
        if (l == null || this.treeExpansionListeners == null) {
            return;
        }
        this.treeExpansionListeners.removeElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.removeTreeExpansionListener(l);
        }
    }

    public Vector getTreeExpansionListeners() {
        return this.treeExpansionListeners;
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l) {
        if (this.treeWillExpandListeners == null) {
            this.treeWillExpandListeners = new Vector();
        }
        this.treeWillExpandListeners.addElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.addTreeWillExpandListener(l);
        }
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener l) {
        if (l == null || this.treeWillExpandListeners == null) {
            return;
        }
        this.treeWillExpandListeners.removeElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.removeTreeWillExpandListener(l);
        }
    }

    public Vector getTreeWillExpandListeners() {
        return this.treeWillExpandListeners;
    }

    public void addCustomRenderer(TreeCellRenderer renderer) {
        this.customTreeCellRenderer = renderer;
    }

    public TreeCellRenderer getCustomRenderer() {
        return this.customTreeCellRenderer;
    }

    public void removeCustomRenderer() {
        this.customTreeCellRenderer = null;
    }

    protected TreeFileSystemModel createFileSystemModel(String rootPath) {
        return new DefaultTreeFileSystemModel(this, rootPath);
    }

    protected void setModel(FileSystemModel newModel) {
        if (!(newModel instanceof TreeFileSystemModel)) {
            throw new IllegalArgumentException("Wrong model type: TreeDirectoryPane only accepts a TreeFileSystemModel");
        }
        FileSystemModel oldModel = this.getModel();
        if (oldModel != null) {
            this.removePropertyChangeListener(oldModel);
        }
        this.filesystemModel = newModel;
        if (newModel != null) {
            this.addPropertyChangeListener(newModel);
        }
    }

    protected TreeSelectionModel createSelectionModel() {
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        return model;
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public void setSelectionModel(TreeSelectionModel newModel) {
        TreeSelectionModel oldModel = this.treeSelectionModel;
        this.treeSelectionModel = newModel;
        this.firePropertyChange(SELECTIONMODEL_CHANGED_PROPERTY, oldModel, newModel);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        if (enabled) {
            this.setSelectionMode(4);
        } else {
            this.setSelectionMode(1);
        }
    }

    public void setSelectionMode(int newMode) {
        int oldMode = this.selectionMode;
        this.selectionMode = newMode;
        this.firePropertyChange(SELECTIONMODE_CHANGED_PROPERTY, oldMode, newMode);
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        if (this.treeSelectionListeners == null) {
            this.treeSelectionListeners = new Vector();
        }
        this.treeSelectionListeners.addElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.addTreeSelectionListener(l);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener l) {
        if (l == null || this.treeSelectionListeners == null) {
            return;
        }
        this.treeSelectionListeners.removeElement(l);
        JTree tree = this.getTreeFromUI();
        if (tree != null) {
            tree.removeTreeSelectionListener(l);
        }
    }

    public Vector getTreeSelectionListeners() {
        return this.treeSelectionListeners;
    }

    public void restoreUIView() {
        if (this.ui != null) {
            ((TreeDirectoryPaneUI)this.ui).restoreUIView();
        }
    }

    public TreePath[] getExpansionCache() {
        return this.expansionCache;
    }

    public TreePath[] getSelectionCache() {
        return this.selectionCache;
    }

    public void expandPath(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.expandPath(path);
        }
    }

    public void collapsePath(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.collapsePath(path);
        }
    }

    public void expandNode(FileNode node) {
        TreePath path = new TreePath(this.getPathToRoot(node));
        this.expandPath(path);
    }

    public void collapseNode(FileNode node) {
        TreePath path = new TreePath(this.getPathToRoot(node));
        this.collapsePath(path);
    }

    public boolean isExpanded(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.isExpanded(path);
        }
        return false;
    }

    public boolean isCollapsed(TreePath path) {
        return !this.isExpanded(path);
    }

    public boolean isVisible(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.isVisible(path);
        }
        return false;
    }

    public void makeVisible(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.makeVisible(path);
        }
    }

    public void scrollPathToVisible(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.scrollPathToVisible(path);
        }
    }

    public TreePath getSelectionPath() {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.getSelectionPath();
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.getLeadSelectionPath();
        }
        return null;
    }

    public TreePath[] getSelectionPaths() {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.getSelectionPaths();
        }
        return null;
    }

    public void setSelectionPath(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.setSelectionPath(path);
        }
    }

    public void setSelectionPaths(TreePath[] paths) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            uiTree.setSelectionPaths(paths);
        }
    }

    public FileNode getLastSelectedPathComponent() {
        return (FileNode)this.getTreeFromUI().getLastSelectedPathComponent();
    }

    public boolean isPathSelected(TreePath path) {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.isPathSelected(path);
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            return uiTree.isSelectionEmpty();
        }
        return true;
    }

    public void clearSelection() {
        JTree uiTree = this.getTreeFromUI();
        if (uiTree != null) {
            this.clearSelection();
        }
    }

    public File getSelectedFile() {
        JTree uiTree = this.getTreeFromUI();
        File file = null;
        TreePath selPath = this.getLeadSelectionPath();
        if (selPath != null) {
            file = this.getFile(selPath);
        }
        return file;
    }

    public File[] getSelectedFiles() {
        TreePath[] paths = this.getSelectionPaths();
        int len = paths == null ? 0 : paths.length;
        Object[] files = new File[len];
        Vector<File> v = new Vector<File>();
        int i = 0;
        while (i < len) {
            TreePath path = paths[i];
            v.addElement(this.getFile(path));
            ++i;
        }
        v.copyInto(files);
        return files;
    }

    public void createNewFolder() {
        File containingDir = this.getCurrentDirectory();
        if (this.isReadOnly(containingDir)) {
            return;
        }
        JTree t = this.getTreeFromUI();
        if (t.isEditing()) {
            t.getCellEditor().cancelCellEditing();
        }
        String folderName = this.getDefaultNewFolderName();
        File newFolder = this.createFileObject(containingDir, folderName);
        this.expandNode(this.getCurrentNode());
        int i = 2;
        while (this.doesFileExist(newFolder) && i < 100) {
            newFolder = this.createFileObject(containingDir, folderName + "(" + i + ")");
            ++i;
        }
        boolean b = this.createDirectory(containingDir, newFolder.getName());
        if (b) {
            this.startEditorOnFile(newFolder);
        }
    }

    public void startEditorOnFile(File file) {
        TreeFileSystemModel model = (TreeFileSystemModel)this.getModel();
        FileNode node = model.getFromTableOfNodes(file.getPath());
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(this.getPathToRoot(node));
        if (this.isVisible(path)) {
            this.getTreeFromUI().startEditingAtPath(path);
        }
    }

    public void setCurrentDirectory(String dirname) {
        if (this.isRebuilding() || this.isUpdating()) {
            return;
        }
        if (((TreeFileSystemModel)this.filesystemModel).isDescendantOfRoot(this.createFileObject(dirname))) {
            super.setCurrentDirectory(dirname);
        }
    }

    protected void synchronizeSlaveDirectory(File masterDir) {
        if (((TreeFileSystemModel)this.filesystemModel).isDescendantOfRoot(masterDir)) {
            super.synchronizeSlaveDirectory(masterDir);
        }
    }

    public void goHome() {
        if (((TreeFileSystemModel)this.filesystemModel).isDescendantOfRoot(this.userDirectory)) {
            super.goHome();
        }
    }

    public void goUp() {
        File curDir = this.getCurrentDirectory();
        File parent = this.filesystemModel.getParentDirectory(curDir);
        if (parent != null && ((TreeFileSystemModel)this.filesystemModel).isDescendantOfRoot(parent)) {
            this.setCurrentDirectory(parent.getPath());
        }
    }

    public void prepareForRebuild() {
        this.setRebuilding(true);
        Object[] temp = new TreePath[this.expansionBuffer.size()];
        this.expansionBuffer.copyInto(temp);
        this.expansionCache = (TreePath[])temp.clone();
        TreePath[] selPaths = null;
        if (this.getTreeFromUI() != null) {
            selPaths = this.getSelectionPaths();
        }
        if (selPaths != null) {
            this.selectionCache = (TreePath[])selPaths.clone();
        }
    }

    public void refreshAll() {
        ((TreeFileSystemModel)this.filesystemModel).refreshAll();
    }

    public void setFileSystem(FileSystem newFileSystem) {
        FileSystem oldFileSystem = this.filesystemModel.getFileSystem();
        if (!newFileSystem.equals(oldFileSystem)) {
            this.blockAutoRefresher();
            this.clearAutoRefresher();
            this.filesystemModel.setFileSystem(newFileSystem);
            this.currentDirectory = newFileSystem.getFileSystemRoot();
            this.rootLocation = this.currentDirectory.getPath();
            this.firePropertyChange("fileSystemChanged", oldFileSystem, newFileSystem);
        }
    }

    public void setRoot(String newRoot) {
        FileNode oldRoot = this.getRoot();
        File test = this.createFileObject(newRoot);
        if (this.doesFileExist(test)) {
            ((TreeFileSystemModel)this.filesystemModel).setRoot(newRoot);
            this.currentDirectory = null;
            this.rootLocation = newRoot;
            this.firePropertyChange(ROOT_CHANGED_PROPERTY, oldRoot, this.getRoot());
            this.setCurrentDirectory(newRoot == null ? this.getFileSystemRoot().getPath() : newRoot);
        }
    }

    public FileNode getRoot() {
        return (FileNode)((TreeFileSystemModel)this.filesystemModel).getRoot();
    }

    public void reload() {
        ((TreeFileSystemModel)this.filesystemModel).reload();
    }

    public void reload(FileNode node) {
        ((TreeFileSystemModel)this.filesystemModel).reload(node);
    }

    public int getChildCount(FileNode node) {
        return ((TreeFileSystemModel)this.filesystemModel).getChildCount(node);
    }

    public FileNode getCurrentNode() {
        return ((TreeFileSystemModel)this.filesystemModel).getCurrentNode();
    }

    public TreePath getCurrentPath() {
        return ((TreeFileSystemModel)this.filesystemModel).getCurrentPath();
    }

    public FileNode[] getPathToRoot(FileNode node) {
        return ((TreeFileSystemModel)this.filesystemModel).getPathToRoot(node);
    }

    protected FileNode createFileNode(File file) {
        return ((TreeFileSystemModel)this.filesystemModel).createFileNode(file);
    }

    public File getFile(FileNode node) {
        return ((TreeFileSystemModel)this.filesystemModel).getFile(node);
    }

    public File getFile(TreePath path) {
        return ((TreeFileSystemModel)this.filesystemModel).getFile(path);
    }

    public TreeExpansionListener createDefaultExpansionListener() {
        return new DefaultExpansionListener();
    }

    public TreeWillExpandListener createDefaultWillExpandListener() {
        return new DefaultWillExpandListener();
    }

    public TreeSelectionListener createDefaultSelectionListener() {
        return new DefaultSelectionListener();
    }

    public void performDoubleClick() {
        File f = this.getSelectedFile();
        if (f == null) {
            return;
        }
        if (this.isTraversable(f)) {
            this.fireActionPerformed(this.getDoubleClickContainerCommand());
        } else {
            this.fireActionPerformed(this.getDoubleClickCommand());
        }
    }

    public void setUI(TreeDirectoryPaneUI ui) {
        if ((TreeDirectoryPaneUI)this.ui != ui) {
            super.setUI(ui);
            this.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.prepareForRebuild();
        this.setUI((TreeDirectoryPaneUI)UIManager.getUI(this));
        JTree t = this.getTreeFromUI();
        if (t != null) {
            this.treeSelectionModel = t.getSelectionModel();
        }
        this.restoreUIView();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.validate();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.isRebuilding = false;
        this.isUpdating = false;
        this.expansionBuffer = new Vector();
        if (!this.doesFileExist(this.getRoot().getFile())) {
            this.setModel(this.createFileSystemModel(null));
        }
        this.addTreeSelectionListener(this.createDefaultSelectionListener());
        this.addTreeExpansionListener(this.createDefaultExpansionListener());
        this.addTreeWillExpandListener(this.createDefaultWillExpandListener());
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class DefaultSelectionListener
    implements TreeSelectionListener {
        protected DefaultSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath selPath = e.getPath();
            if (selPath != null) {
                FileNode selNode = (FileNode)selPath.getLastPathComponent();
                if (!selNode.isLeaf()) {
                    TreeDirectoryPane.this.setCurrentDirectory(selNode.getPathString());
                } else {
                    TreePath curpath = selPath.getParentPath();
                    TreeDirectoryPane.this.setCurrentDirectory(selNode.getFile().getParent());
                    if (TreeDirectoryPane.this.isPathSelected(curpath)) {
                        TreeDirectoryPane.this.setSelectionPath(selPath);
                        TreeDirectoryPane.this.scrollPathToVisible(selPath);
                    }
                }
            }
        }
    }

    protected class PathCleaner
    extends Thread {
        TreePath path;
        FileNode node;

        public PathCleaner(TreePath path) {
            this.path = path;
            this.node = (FileNode)path.getLastPathComponent();
        }

        public void run() {
            if (this.node.hasChildrenLoaded() && !this.node.isSorted()) {
                this.node.sortChildren();
                TreeDirectoryPane.this.reload(this.node);
            }
            if (TreeDirectoryPane.this.expansionBuffer != null) {
                boolean childIsCurDir = false;
                Enumeration<TreeNode> subtree = this.node.depthFirstEnumeration();
                while (subtree.hasMoreElements()) {
                    FileNode n = (FileNode)subtree.nextElement();
                    Object[] nodes = n.getPath();
                    TreePath p = new TreePath(nodes);
                    if (TreeDirectoryPane.this.getCurrentNode().equals(n)) {
                        childIsCurDir = true;
                    }
                    if (!TreeDirectoryPane.this.expansionBuffer.contains(p)) continue;
                    TreeDirectoryPane.this.expansionBuffer.removeElement(p);
                }
                if (childIsCurDir) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ PathCleaner this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            PathCleaner.access$000(this.this$1).setCurrentDirectory(this.this$1.node.getPathString());
                        }
                    });
                }
                if (TreeDirectoryPane.this.expansionBuffer.contains(this.path)) {
                    TreeDirectoryPane.this.expansionBuffer.removeElement(this.path);
                }
            }
        }

        static /* synthetic */ TreeDirectoryPane access$000(PathCleaner x0) {
            return x0.TreeDirectoryPane.this;
        }
    }

    protected class DefaultWillExpandListener
    implements TreeWillExpandListener {
        protected DefaultWillExpandListener() {
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            FileNode node = (FileNode)path.getLastPathComponent();
            if (TreeDirectoryPane.this.isFileSelectionEnabled()) {
                TreeDirectoryPane.this.setSelectionPath(path);
            } else {
                ((TreeFileSystemModel)TreeDirectoryPane.this.filesystemModel).loadPath(node, -1);
            }
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }
    }

    protected class DefaultExpansionListener
    implements TreeExpansionListener {
        protected DefaultExpansionListener() {
        }

        public void treeExpanded(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            TreeDirectoryPane.this.expansionBuffer.addElement(path);
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            PathCleaner t = new PathCleaner(path);
            t.start();
        }
    }
}

