/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.TreeFileSystemModel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;

public class DirectoryComboBox
extends JComboBox {
    static final long serialVersionUID = -5601203648770338674L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    protected DirectoryPane pane;
    protected DirectoryComboBoxModel model;
    protected File root;
    protected File selectedDirectory = null;
    static final int space = 10;

    public DirectoryComboBox() {
        this((DirectoryPane)null);
    }

    public DirectoryComboBox(DirectoryPane pane) {
        this.setRenderer(new DirectoryComboBoxRenderer());
        this.setMaximumRowCount(5);
        if (pane != null) {
            this.pane = pane;
            this.model = this.createDirectoryComboBoxModel();
            this.setModel(this.model);
            this.addActionListener(new ComboActionListener());
            pane.addPropertyChangeListener(this.createDirectoryChangedListener());
            File curDir = pane.getCurrentDirectory();
            if (curDir != this.root) {
                this.model.addItem(curDir);
            } else {
                this.model.setSelectedItem(curDir);
            }
        }
    }

    public void setDirectoryPane(DirectoryPane newpane) {
        DirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        DirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.model = this.createDirectoryComboBoxModel();
        this.setModel(this.model);
        this.addActionListener(new ComboActionListener());
        this.pane.addPropertyChangeListener(this.createDirectoryChangedListener());
        File curDir = this.pane.getCurrentDirectory();
        if (curDir != this.root) {
            this.model.addItem(curDir);
        } else {
            this.model.setSelectedItem(curDir);
        }
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public DirectoryPane getDirectoryPane() {
        return this.pane;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel() {
        return new DirectoryComboBoxModel();
    }

    protected PropertyChangeListener createDirectoryChangedListener() {
        return new DirectoryChangedListener();
    }

    private class DirectoryChangedListener
    implements PropertyChangeListener {
        private DirectoryChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            File f;
            String name = e.getPropertyName();
            if (name == "fileSystemChanged") {
                DirectoryComboBox.this.model = DirectoryComboBox.this.createDirectoryComboBoxModel();
                DirectoryComboBox.this.setModel(DirectoryComboBox.this.model);
            }
            if ((name == "directoryChanged" || name == "syncSlaveDirectory") && (f = (File)e.getNewValue()) != null && f != DirectoryComboBox.this.selectedDirectory && DirectoryComboBox.this.pane.getModel().belongsToFileSystem(f)) {
                if (DirectoryComboBox.this.pane instanceof TreeDirectoryPane && !((TreeFileSystemModel)DirectoryComboBox.this.pane.getModel()).isDescendantOfRoot(f)) {
                    return;
                }
                DirectoryComboBox.this.model.addItem(f);
            }
        }
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        public void actionPerformed(ActionEvent ignored) {
            File selection = (File)DirectoryComboBox.this.getSelectedItem();
            if (selection != null) {
                String dir = selection.getPath();
                DirectoryComboBox.this.pane.setCurrentDirectory(dir);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected Vector directories = new Vector();
        protected int topIndex = -1;
        protected int pathCount = 0;

        public DirectoryComboBoxModel() {
            DirectoryComboBox.this.root = DirectoryComboBox.this.pane.getFileSystemRoot();
            this.directories.addElement(DirectoryComboBox.this.root);
            File[] drives = DirectoryComboBox.this.pane.getFiles(DirectoryComboBox.this.root, DirectoryComboBox.this.pane.isFileHidingEnabled());
            if (DirectoryComboBox.this.pane.getFileSorter() != null) {
                DirectoryComboBox.this.pane.getFileSorter().sort(drives);
            }
            int i = 0;
            while (i < drives.length) {
                if (DirectoryComboBox.this.pane.isTraversable(drives[i])) {
                    this.directories.addElement(drives[i]);
                }
                ++i;
            }
        }

        protected void removeSelectedDirectory() {
            if (this.topIndex >= 0) {
                int i = this.topIndex;
                while (i < this.topIndex + this.pathCount) {
                    this.directories.removeElementAt(this.topIndex + 1);
                    ++i;
                }
            }
            this.topIndex = -1;
            this.pathCount = 0;
            DirectoryComboBox.this.selectedDirectory = null;
        }

        protected void addItem(File directory) {
            if (directory == null) {
                return;
            }
            if (DirectoryComboBox.this.selectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File parent = directory;
            Vector<File> path = new Vector<File>(10);
            while (parent != null && !this.directories.contains(parent)) {
                path.addElement(parent);
                if (this.directories.contains(parent)) {
                    this.topIndex = this.directories.indexOf(parent);
                }
                parent = DirectoryComboBox.this.pane.getParentDirectory(parent);
            }
            this.pathCount = path.size();
            if (this.topIndex < 0 && this.directories.contains(parent)) {
                this.topIndex = this.directories.indexOf(parent);
            }
            int i = 0;
            while (i < path.size()) {
                this.directories.insertElementAt(path.elementAt(i), this.topIndex + 1);
                ++i;
            }
            this.setSelectedItem(directory);
        }

        public void setSelectedItem(Object selected) {
            DirectoryComboBox.this.selectedDirectory = (File)selected;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return DirectoryComboBox.this.selectedDirectory;
        }

        public int getSelectedIndex() {
            return this.directories.indexOf(DirectoryComboBox.this.selectedDirectory);
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x + this.depth * 10, y);
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File directory = (File)value;
            if (directory == null) {
                this.setText("");
                return this;
            }
            String fileName = DirectoryComboBox.this.pane.getName(directory);
            this.setText(fileName);
            int depth = 0;
            if (index != -1) {
                File parent = DirectoryComboBox.this.pane.getParentDirectory(directory);
                while (parent != null) {
                    ++depth;
                    parent = DirectoryComboBox.this.pane.getParentDirectory(parent);
                }
            }
            this.ii.icon = icon = DirectoryComboBox.this.pane.getTypeIcon(directory);
            this.ii.depth = depth;
            this.setIcon(this.ii);
            return this;
        }
    }
}

