/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.filechooser;

import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.filechooser.FileChooserDialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThumbnailViewer
extends JComponent
implements ListSelectionListener,
PropertyChangeListener {
    ImageIcon thumbnail = null;
    File imageFile = null;
    FileChooserDialog chooser;

    public ThumbnailViewer(FileChooserDialog chooser) {
        this.setPreferredSize(new Dimension(100, 50));
        this.chooser = chooser;
        chooser.addListSelectionListener(this);
        chooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.imageFile != null) {
            ImageIcon tmpIcon = new ImageIcon(this.imageFile.getPath());
            this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
        }
    }

    public void valueChanged(ListSelectionEvent ignored) {
        TableDirectoryPane pane = this.chooser.getDirectoryPane();
        this.imageFile = ((DirectoryPane)pane).getSelectedFile();
        if (this.isShowing()) {
            this.loadImage();
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name == "directoryChanged" || name == "syncSlaveDirectory") {
            this.thumbnail = null;
            this.imageFile = null;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

