/*
 * Decompiled with CFR 0.152.
 */
package fontviewer;

import fontviewer.ApplicationProperties;
import fontviewer.components.MainPanel;
import fontviewer.components.PreviewPanel;
import fontviewer.components.TreePanel;
import fontviewer.i18n.I18N;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.SplashScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel;

public class FontViewer
extends JFrame {
    private final JSplitPane splitPane = new JSplitPane();
    private ApplicationProperties properties = null;
    private Font appFont = new Font("Dialog", 0, 14);
    private I18N resources = null;
    private Locale applicationLocale = null;
    private MainPanel mainPanel = null;
    private String frameTitle = "FontViewer";
    private TreePanel treePanel = null;
    private static SplashScreen splashScreen;

    public FontViewer() {
        int n;
        Object object;
        this.loadProperties();
        try {
            object = this.properties.getProperty("skin");
            if (object == null) {
                object = "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel";
            }
            SubstanceLookAndFeel.setSkin((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.properties.getProperty("language") == null || this.properties.getProperty("language").equals("") || this.properties.getProperty("country") == null || this.properties.getProperty("country").equals("")) {
            this.properties.setProperty("language", "en");
            this.properties.setProperty("country", "US");
        }
        this.applicationLocale = new Locale(this.properties.getProperty("language"), this.properties.getProperty("country"));
        Locale.setDefault(this.applicationLocale);
        this.loadLocalisedResources(this.applicationLocale);
        object = UIManager.getDefaults();
        ((UIDefaults)object).put("OptionPane.okButtonText", this.resources.localisedString("Gui.OptionPane.Ok.Button"));
        ((UIDefaults)object).put("FileChooser.cancelButtonText", this.resources.localisedString("Gui.FileChooser.Cancel.Button"));
        ((UIDefaults)object).put("ColorChooser.okText", this.resources.localisedString("Gui.ColourChooser.Ok.Button"));
        ((UIDefaults)object).put("ColorChooser.cancelText", this.resources.localisedString("Gui.ColourChooser.Cancel.Button"));
        ((UIDefaults)object).put("ColorChooser.resetText", this.resources.localisedString("Gui.ColourChooser.Reset.Button"));
        this.setTitle(this.frameTitle);
        this.setIconImage(new ImageIcon(FontViewer.class.getResource("/fontviewer/resources/application-icon.png")).getImage());
        int n2 = Integer.parseInt(this.properties.getProperty("x"));
        int n3 = Integer.parseInt(this.properties.getProperty("y"));
        this.setLocation(n2, n3);
        int n4 = Integer.parseInt(this.properties.getProperty("width"));
        int n5 = Integer.parseInt(this.properties.getProperty("height"));
        this.setSize(n4, n5);
        int n6 = Integer.parseInt(this.properties.getProperty("extended.state"));
        this.setExtendedState(n6);
        int n7 = Integer.parseInt(this.properties.getProperty("font.paths"));
        ArrayList<String> arrayList = new ArrayList<String>(n7);
        this.treePanel = new TreePanel(this);
        for (n = 0; n < n7; ++n) {
            arrayList.add(n, this.properties.getProperty("font.path." + n));
        }
        this.treePanel.updateTree(arrayList);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FontViewer.this.exitApplication();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                if (FontViewer.this.getExtendedState() == 0 || FontViewer.this.getExtendedState() == 2 || FontViewer.this.getExtendedState() == 4) {
                    Point point = FontViewer.this.getLocation();
                    Dimension dimension = FontViewer.this.getSize();
                    FontViewer.this.properties.setProperty("x", point.x + "");
                    FontViewer.this.properties.setProperty("y", point.y + "");
                    FontViewer.this.properties.setProperty("width", dimension.width + "");
                    FontViewer.this.properties.setProperty("height", dimension.height + "");
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (FontViewer.this.getExtendedState() == 0 || FontViewer.this.getExtendedState() == 2 || FontViewer.this.getExtendedState() == 4) {
                    Point point = FontViewer.this.getLocation();
                    Dimension dimension = FontViewer.this.getSize();
                    FontViewer.this.properties.setProperty("x", point.x + "");
                    FontViewer.this.properties.setProperty("y", point.y + "");
                    FontViewer.this.properties.setProperty("width", dimension.width + "");
                    FontViewer.this.properties.setProperty("height", dimension.height + "");
                }
            }
        });
        this.mainPanel = new MainPanel(this);
        n = Integer.parseInt(this.properties.getProperty("split.location"));
        this.splitPane.setDividerLocation(n);
        this.splitPane.setLeftComponent(this.treePanel);
        this.splitPane.setRightComponent(this.mainPanel);
        this.mainPanel.setPanelFont(this.appFont);
        this.createMenuBar();
        this.getContentPane().add((Component)this.splitPane, "Center");
        if (splashScreen != null) {
            splashScreen.close();
        }
        this.setVisible(true);
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.resources.localisedString("Gui.Menu.File"));
        ImageIcon imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/cancel.png"));
        JMenuItem jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.File.Exit"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontViewer.this.exitApplication();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.resources.localisedString("Gui.Menu.Settings"));
        JMenu jMenu2 = new JMenu(this.resources.localisedString("Gui.Menu.Settings.Language"));
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/us.gif"));
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.Settings.Language.EnglishUS"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontViewer.this.updateLocale("en", "US");
            }
        });
        jMenu2.add(jMenuItem);
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/gb.gif"));
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.Settings.Language.EnglishUK"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontViewer.this.updateLocale("en", "UK");
            }
        });
        jMenu2.add(jMenuItem);
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/de.gif"));
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.Settings.Language.German"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontViewer.this.updateLocale("de", "DE");
            }
        });
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/gr.gif"));
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.Settings.Language.Greek"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontViewer.this.updateLocale("el", "GR");
            }
        });
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu.add(new JSeparator());
        jMenu2 = this.skinMenu();
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.resources.localisedString("Gui.Menu.Help"));
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/information.png"));
        jMenuItem = new JMenuItem(this.resources.localisedString("Gui.Menu.Help.About"), imageIcon);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JEditorPane jEditorPane = new JEditorPane("text/html", "<html>FontViewer V0.6<br>Author: Charalampos Anargyrou<br>E-mail: <a href='sendmail'>c_anargyrou@users.sourceforge.net</a><br>Site: <a href='showsite'>http://fontviewer.sourceforge.net</a><br><br><br>Many thanks to the translators!</html>");
                jEditorPane.setEditable(false);
                jEditorPane.setOpaque(false);
                jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                            Desktop desktop = Desktop.getDesktop();
                            if (hyperlinkEvent.getDescription().equals("sendmail")) {
                                try {
                                    desktop.mail(new URI("mailto:c_anargyrou@users.sourceforge.net"));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (hyperlinkEvent.getDescription().equals("showsite")) {
                                try {
                                    desktop.browse(new URI("http://fontviewer.sourceforge.net"));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                });
                JOptionPane.showMessageDialog(FontViewer.this, jEditorPane, FontViewer.this.resources.localisedString("Gui.Menu.Help.About"), 1);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void exitApplication() {
        String string = this.properties.getProperty("language");
        String string2 = this.properties.getProperty("country");
        this.properties.clearProperties();
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        if (this.getExtendedState() == 0 || this.getExtendedState() == 2 || this.getExtendedState() == 4) {
            this.properties.setProperty("x", point.x + "");
            this.properties.setProperty("y", point.y + "");
            this.properties.setProperty("width", dimension.width + "");
            this.properties.setProperty("height", dimension.height + "");
        }
        this.properties.setProperty("split.location", this.splitPane.getDividerLocation() + "");
        this.properties.setProperty("extended.state", this.getExtendedState() + "");
        ArrayList arrayList = this.treePanel.getFontPaths();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = new File((String)arrayList.get(i));
            if (!file.exists() || !file.isDirectory()) continue;
            this.properties.setProperty("font.path." + i, (String)arrayList.get(i));
            ++n;
        }
        this.properties.setProperty("font.paths", n + "");
        this.properties.setProperty("skin", SubstanceLookAndFeel.getCurrentSkin().getClass().getName());
        this.properties.setProperty("language", string);
        this.properties.setProperty("country", string2);
        this.properties.saveProperties();
        this.dispose();
    }

    public I18N getLocalisedResources() {
        return this.resources;
    }

    private void loadLocalisedResources(Locale locale) {
        this.resources = new I18N(locale);
    }

    private void loadProperties() {
        this.properties = new ApplicationProperties();
    }

    private JMenu skinMenu() {
        JMenu jMenu = new JMenu("Skins");
        ButtonGroup buttonGroup = new ButtonGroup();
        final Map<String, SkinInfo> map = SubstanceLookAndFeel.getAllSkins();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                        SubstanceLookAndFeel.setSkin(((SkinInfo)map.get(jRadioButtonMenuItem.getText())).getClassName());
                    }
                });
            }
        };
        String string = SubstanceLookAndFeel.getCurrentSkin().getClass().getName();
        for (String string2 : map.keySet()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2, string.equals(map.get(string2).getClassName()));
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    public void updateFont(Font font, boolean bl) {
        if (bl) {
            this.appFont = font.deriveFont(this.appFont.getStyle(), this.appFont.getSize());
            this.mainPanel.setPanelFont(this.appFont);
        } else {
            this.appFont = font;
            this.mainPanel.setPanelFont(font);
        }
    }

    public void updateFont(String string) {
        try {
            this.appFont = Font.createFont(0, new FileInputStream(string)).deriveFont(this.appFont.getStyle(), this.appFont.getSize());
            this.mainPanel.setPanelFont(this.appFont);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, this.resources.localisedString("Messages.Font.Error"), "", 1);
            return;
        }
        catch (FontFormatException fontFormatException) {
            JOptionPane.showMessageDialog(this, this.resources.localisedString("Messages.Font.Error"), "", 1);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.resources.localisedString("Messages.Font.Error"), "", 1);
            return;
        }
    }

    private void updateLocale(String string, String string2) {
        this.properties.setProperty("language", string);
        this.properties.setProperty("country", string2);
        JOptionPane.showMessageDialog(this, this.resources.localisedString("Messages.Restart.Action"), "", 1);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Graphics2D graphics2D;
                    FontViewer.splashScreen = SplashScreen.getSplashScreen();
                    if (splashScreen != null && (graphics2D = splashScreen.createGraphics()) != null) {
                        splashScreen.update();
                    }
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                    UIManager.setLookAndFeel(new SubstanceCremeLookAndFeel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new FontViewer();
            }
        });
    }
}

