/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.components;

import fontviewer.beans.CharacterRange;
import fontviewer.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CharacterMapPanel
extends JPanel {
    private final Vector choices = new Vector();
    private final JPanel mapPanel = new JPanel();

    public CharacterMapPanel(I18N i18N) {
        Object object;
        Object object2;
        Object object3;
        this.setLayout(new BorderLayout());
        URL uRL = CharacterMapPanel.class.getResource("/fontviewer/resources/CharacterRanges.dat");
        this.choices.add(new CharacterRange("", -1, -1));
        try {
            object3 = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                object = ((String)object2).split("#");
                this.choices.add(new CharacterRange(object[0], this.hexToInt(object[1]), this.hexToInt(object[2])));
            }
        }
        catch (IOException iOException) {
            this.choices.add(new CharacterRange("Printable ASCII Characters", 33, 126));
        }
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout(1));
        ((JComponent)object3).setBorder(BorderFactory.createTitledBorder(i18N.localisedString("Gui.Panel.Map.CharacterRange")));
        object2 = new JComboBox(this.choices);
        ((JComboBox)object2).addActionListener(new ActionListener((JComboBox)object2){
            final /* synthetic */ JComboBox val$comboBox;
            {
                this.val$comboBox = jComboBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CharacterMapPanel.this.mapPanel.removeAll();
                if (this.val$comboBox.getSelectedIndex() != 0) {
                    CharacterRange characterRange = (CharacterRange)this.val$comboBox.getSelectedItem();
                    int n = characterRange.getMax() - characterRange.getMin();
                    CharacterMapPanel.this.mapPanel.setLayout(new GridLayout(n / 2, n / 2));
                    for (int i = characterRange.getMin(); i <= characterRange.getMax(); ++i) {
                        JLabel jLabel = new JLabel((char)i + "");
                        jLabel.setFont(CharacterMapPanel.this.mapPanel.getFont());
                        CharacterMapPanel.this.mapPanel.add(jLabel);
                    }
                }
                CharacterMapPanel.this.validate();
                CharacterMapPanel.this.repaint();
            }
        });
        ((Container)object3).add((Component)object2);
        this.add((Component)object3, "North");
        object = new JScrollPane(this.mapPanel);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(i18N.localisedString("Gui.Panel.Map.Preview")));
        this.add((Component)object, "Center");
    }

    private int hexToInt(String string) {
        return Integer.parseInt(string, 16);
    }

    public void setPanelFont(Font font) {
        this.mapPanel.setFont(font.deriveFont(0, 16.0f));
        Component[] componentArray = this.mapPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JLabel)) continue;
            componentArray[i].setFont(this.mapPanel.getFont());
        }
        this.validate();
        this.repaint();
    }
}

