/*
 * Decompiled with CFR 0.152.
 */
package fontviewer.components;

import fontviewer.components.MainPanel;
import fontviewer.components.StatusBar;
import fontviewer.i18n.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreviewPanel
extends JPanel {
    private final JLabel sample = new JLabel();
    private final JScrollPane scrollPane = new JScrollPane(this.sample);
    private final JTextField textField = new JTextField(20);
    private final StatusBar statusBar;
    private I18N resources;

    public PreviewPanel(I18N i18N) {
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
        this.resources = i18N;
        this.setLayout(new BorderLayout());
        this.sample.setText("This is a preview.");
        this.statusBar = new StatusBar(i18N);
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(i18N.localisedString("Gui.Panel.Preview.Button"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.updateText();
            }
        });
        jPanel.setBorder(BorderFactory.createTitledBorder(i18N.localisedString("Gui.Panel.Preview.ChangeText")));
        jPanel.add(this.textField);
        jPanel.add(jButton);
        this.sample.setHorizontalAlignment(0);
        this.sample.setVerticalAlignment(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.scrollPane, "Center");
        jPanel2.add((Component)this.statusBar, "South");
        this.add((Component)this.createToolbar(), "North");
        this.add((Component)jPanel2, "Center");
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(14, 0, 500, 1);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setMaximumSize(new Dimension(50, 25));
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PreviewPanel.this.updateFontSize(spinnerNumberModel.getNumber().floatValue());
            }
        });
        jToolBar.add(new JLabel(this.resources.localisedString("Gui.Spinner.Label")));
        jToolBar.addSeparator();
        jToolBar.add(jSpinner);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(this.resources.localisedString("Gui.Toolbar.Style.Label")));
        jToolBar.addSeparator();
        ImageIcon imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/bold.gif"));
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.boldFont();
            }
        });
        jToolBar.add(jToggleButton);
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/italic.gif"));
        jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.italicFont();
            }
        });
        jToolBar.add(jToggleButton);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(this.resources.localisedString("Gui.Toolbar.Colour.Label")));
        jToolBar.addSeparator();
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/bg.gif"));
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.changeBackgroundColour();
            }
        });
        jToolBar.add(jButton);
        imageIcon = new ImageIcon(PreviewPanel.class.getResource("/fontviewer/resources/fg.gif"));
        jButton = new JButton(imageIcon);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.changeForegroundColour();
            }
        });
        jToolBar.add(jButton);
        return jToolBar;
    }

    private void boldFont() {
        Font font = this.getFont();
        if (font.isBold()) {
            ((MainPanel)this.getParent().getParent()).updateFont(this.getFont().deriveFont(this.getFont().getStyle() - 1));
        } else {
            ((MainPanel)this.getParent().getParent()).updateFont(this.getFont().deriveFont(this.getFont().getStyle() + 1));
        }
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
    }

    private void changeBackgroundColour() {
        Color color = JColorChooser.showDialog(this, this.resources.localisedString("Gui.ColourChooser.Background"), this.sample.getBackground());
        if (color != null) {
            this.scrollPane.getViewport().setBackground(color);
            this.sample.setBackground(color);
            this.repaint();
        }
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
    }

    private void changeForegroundColour() {
        Color color = JColorChooser.showDialog(this, this.resources.localisedString("Gui.ColourChooser.Foreground"), this.sample.getForeground());
        if (color != null) {
            this.sample.setForeground(color);
            this.repaint();
        }
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
    }

    private void italicFont() {
        Font font = this.getFont();
        if (font.isItalic()) {
            ((MainPanel)this.getParent().getParent()).updateFont(this.getFont().deriveFont(this.getFont().getStyle() - 2));
        } else {
            ((MainPanel)this.getParent().getParent()).updateFont(this.getFont().deriveFont(this.getFont().getStyle() + 2));
        }
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
    }

    public void setPanelFont(Font font) {
        super.setFont(font);
        this.sample.setFont(font);
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
        this.repaint();
    }

    private void updateFontSize(float f) {
        ((MainPanel)this.getParent().getParent()).updateFont(this.getFont().deriveFont(f));
        this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
    }

    public void updateText() {
        if (!this.textField.getText().equals("")) {
            this.sample.setText(this.textField.getText());
            this.statusBar.updateStatusBar(this.getFont(), this.sample.getText());
        }
    }
}

