/*
 * Created on 14.09.2006
 */
package de.ssfuture.tools.updater;

/**
 * @author Sebastian Schleemilch
 */
public class DefaultConsoleLogging implements LoggingInterface {
	int progress_min, progress_max, progress_stat;
	float progress_onePercent; 
	String progress_description;

	public void defaultLog(String text) {
		System.out.println(text);
	}
	
	public void headlineLog(String text) {
		System.err.println(text);
	}
	
	public void progressStatus(int status) {
		if(status >= progress_min && status <= progress_max) {
			int stat2 = Math.round( (status - progress_min) / progress_onePercent );
			progress_stat = stat2 - progress_stat;
			for(int i = 0; i < progress_stat; i++)
				System.out.print('.');
			progress_stat = stat2;
		}
	}
	
	public void progressStatusExit() {
		System.out.println(" DONE");
		progress_min = 0;
		progress_max = 1;
		progress_description = "";
	}
	
	public void progressStatusInit(String description, int min, int max) {
		System.out.println(description + ":");
		for(int i = 0; i < 100; i++)
			System.out.print(".");
		System.out.println();
		progress_min = min;
		progress_max = max;
		progress_description = description;
		
		progress_onePercent = (progress_max - progress_min) / 100;
		progress_stat = 0;
	}
	
	public static void main(String[] args) {
		DefaultConsoleLogging log = new DefaultConsoleLogging();
		log.progressStatusInit("Rechne was", 0, 99999);
		for(int i = 0; i < 99999; i++) {
			log.progressStatus(i);
			Math.round(0.000000000005923);
			Math.sin(0.5899955665);
		}
		log.progressStatusExit();
		log.headlineLog("Sehr wichtig");
		log.defaultLog("geht so");
		System.exit(0);
	}
}
