/*
 * Created on 13.09.2006
 */
package de.ssfuture.tools.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author Sebastian Schleemilch
 */
public class Updater {
	LoggingInterface log;
	String workdir;
	
	public Updater(String basejar, URL updatejar, LoggingInterface logging) throws IOException {
		log = logging;
		workdir = System.getProperty("user.home");
		
		String updatejar_filename = updatejar.getFile();
		updatejar_filename = 
			updatejar_filename.substring(updatejar_filename.lastIndexOf('/')+1);
		
		log.headlineLog("Updater: Unpack " + basejar);
		Unpack up = new Unpack(basejar, log);
		log.headlineLog("Updater: Read " + updatejar);
		readFile(updatejar, new File(updatejar_filename));
		log.headlineLog("Updater: Read " + updatejar +".a32");
		readFile(new URL(updatejar.toString() + ".a32"), 
				new File(updatejar_filename + ".a32"));
		log.headlineLog("Updater: Unpack " + updatejar_filename);
		up = new Unpack(updatejar_filename, log);
		log.headlineLog("Exit software to finish update process");
		log.progressStatusInit("Time to exit", 0, 10);
		for(int i = 0; i < 10; i++) {
			log.progressStatus(i);
			try {
				Thread.currentThread().sleep(100);
			} catch (InterruptedException e) {}
		}
		Runtime.getRuntime().exec("java -jar UpdateInstaller.jar \"" + basejar + "\"");
		System.exit(0);
	}
	
	public void readFile(URL src, File target) throws IOException {
		BufferedInputStream br;
		if(src.toString().startsWith("file://")) {
			System.out.flush();
			br = new BufferedInputStream(new FileInputStream(src.toString().substring(7)));
		}
		else
		br = new BufferedInputStream(src.openStream());
		BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(target));
		
		for(int c; (c = br.read()) != -1; ) {
			bw.write(c);
		}
		bw.flush();
		bw.close();
		br.close();
	}

	public static void main(String[] args) {
		try {
			new Updater("ComS-CMS.jar", new URL("file://D:/Java/eclipse/workspace/Funny.jar"), new DefaultConsoleLogging());
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
