/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.jburner.gui;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.vyx.Consts;
import com.vyx.jburner.BurnerHW;
import com.vyx.jburner.gui.BurnerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class DriveSpeedPanel
extends BurnerPanel {
    private JLabel ivjCDROML = null;
    private JButton ivjCDROMResetSpeedB = null;
    private JComboBox ivjCDROMSpeedC = null;
    private JButton ivjCDROMSpeedLockB = null;
    private JLabel ivjCDRWL = null;
    private JButton ivjCDRWResetSpeedB = null;
    private JComboBox ivjCDRWSpeedC = null;
    private JButton ivjCDRWSpeedLockB = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);

    public DriveSpeedPanel() {
        this.initialize();
    }

    public DriveSpeedPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public DriveSpeedPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public DriveSpeedPanel(boolean bl) {
        super(bl);
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.setSpeed(false, 0);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.setSpeed(true, 0);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ActionEvent actionEvent) {
        try {
            this.setCDROMSpeedLock();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ActionEvent actionEvent) {
        try {
            this.setCDRWSpeedLock();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private JLabel getCDROML() {
        if (this.ivjCDROML == null) {
            try {
                this.ivjCDROML = new JLabel();
                this.ivjCDROML.setName("CDROML");
                this.ivjCDROML.setText("CDROM");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDROML;
    }

    private JButton getCDROMResetSpeedB() {
        if (this.ivjCDROMResetSpeedB == null) {
            try {
                this.ivjCDROMResetSpeedB = new JButton();
                this.ivjCDROMResetSpeedB.setName("CDROMResetSpeedB");
                this.ivjCDROMResetSpeedB.setMnemonic('s');
                this.ivjCDROMResetSpeedB.setText("Reset speed");
                this.ivjCDROMResetSpeedB.setFocusPainted(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDROMResetSpeedB;
    }

    private JComboBox getCDROMSpeedC() {
        if (this.ivjCDROMSpeedC == null) {
            try {
                this.ivjCDROMSpeedC = new JComboBox();
                this.ivjCDROMSpeedC.setName("CDROMSpeedC");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDROMSpeedC;
    }

    private JButton getCDROMSpeedLockB() {
        if (this.ivjCDROMSpeedLockB == null) {
            try {
                this.ivjCDROMSpeedLockB = new JButton();
                this.ivjCDROMSpeedLockB.setName("CDROMSpeedLockB");
                this.ivjCDROMSpeedLockB.setMnemonic('o');
                this.ivjCDROMSpeedLockB.setText("Lock speed");
                this.ivjCDROMSpeedLockB.setFocusPainted(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDROMSpeedLockB;
    }

    private JLabel getCDRWL() {
        if (this.ivjCDRWL == null) {
            try {
                this.ivjCDRWL = new JLabel();
                this.ivjCDRWL.setName("CDRWL");
                this.ivjCDRWL.setText("CDRW");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDRWL;
    }

    private JButton getCDRWResetSpeedB() {
        if (this.ivjCDRWResetSpeedB == null) {
            try {
                this.ivjCDRWResetSpeedB = new JButton();
                this.ivjCDRWResetSpeedB.setName("CDRWResetSpeedB");
                this.ivjCDRWResetSpeedB.setMnemonic('r');
                this.ivjCDRWResetSpeedB.setText("Reset speed");
                this.ivjCDRWResetSpeedB.setFocusPainted(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDRWResetSpeedB;
    }

    private JComboBox getCDRWSpeedC() {
        if (this.ivjCDRWSpeedC == null) {
            try {
                this.ivjCDRWSpeedC = new JComboBox();
                this.ivjCDRWSpeedC.setName("CDRWSpeedC");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDRWSpeedC;
    }

    private JButton getCDRWSpeedLockB() {
        if (this.ivjCDRWSpeedLockB == null) {
            try {
                this.ivjCDRWSpeedLockB = new JButton();
                this.ivjCDRWSpeedLockB.setName("CDRWSpeedLockB");
                this.ivjCDRWSpeedLockB.setMnemonic('l');
                this.ivjCDRWSpeedLockB.setText("Lock speed");
                this.ivjCDRWSpeedLockB.setFocusPainted(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCDRWSpeedLockB;
    }

    public String getPanelName() {
        return "Lock drive speed...";
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() throws Exception {
        this.getCDROMResetSpeedB().addActionListener((ActionListener)this.ivjEventHandler);
        this.getCDRWResetSpeedB().addActionListener((ActionListener)this.ivjEventHandler);
        this.getCDROMSpeedLockB().addActionListener((ActionListener)this.ivjEventHandler);
        this.getCDRWSpeedLockB().addActionListener((ActionListener)this.ivjEventHandler);
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("DriveSpeedPanel");
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            ((Component)((Object)this)).setSize(501, 96);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.ipadx = 5;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDRWL(), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.ipadx = 5;
            gridBagConstraints2.ipady = 5;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDROML(), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 0.1;
            gridBagConstraints3.ipadx = 5;
            gridBagConstraints3.ipady = 5;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDROMSpeedC(), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 0.1;
            gridBagConstraints4.ipadx = 5;
            gridBagConstraints4.ipady = 5;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDRWSpeedC(), gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 9;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.ipadx = 5;
            gridBagConstraints5.ipady = 5;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDRWResetSpeedB(), gridBagConstraints5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 7;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.ipadx = 5;
            gridBagConstraints6.ipady = 5;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDROMSpeedLockB(), gridBagConstraints6);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 9;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.ipadx = 5;
            gridBagConstraints7.ipady = 5;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDROMResetSpeedB(), gridBagConstraints7);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 7;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.ipadx = 5;
            gridBagConstraints8.ipady = 5;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            ((Container)((Object)this)).add((Component)this.getCDRWSpeedLockB(), gridBagConstraints8);
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.setCombo(this.getCDROMSpeedC());
        this.setCombo(this.getCDRWSpeedC());
    }

    public void refreshMedia() {
        if (this.burner != null) {
            boolean bl = this.burner.cdromMedia != null;
            this.getCDROMResetSpeedB().setEnabled(bl);
            this.getCDROMSpeedC().setEnabled(bl);
            this.getCDROMSpeedLockB().setEnabled(bl);
            bl = this.burner.cdrwMedia != null;
            this.getCDRWResetSpeedB().setEnabled(bl);
            this.getCDRWSpeedC().setEnabled(bl);
            this.getCDRWSpeedLockB().setEnabled(bl);
        }
    }

    public void setBurner(BurnerHW burnerHW) {
        super.setBurner(burnerHW);
        if (burnerHW != null) {
            this.refreshMedia();
        }
    }

    public void setCDROMEnable(boolean bl) {
        this.getCDROML().setVisible(bl);
        this.getCDROMResetSpeedB().setVisible(bl);
        this.getCDROMSpeedC().setVisible(bl);
        this.getCDROMSpeedLockB().setVisible(bl);
    }

    final void setCDROMSpeedLock() {
        try {
            this.setSpeed(false, Consts.CDRW_SPEEDS[this.getCDROMSpeedC().getSelectedIndex()]);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    final void setCDRWSpeedLock() {
        this.setSpeed(true, Consts.CDRW_SPEEDS[this.getCDRWSpeedC().getSelectedIndex()]);
    }

    private void setCombo(JComboBox jComboBox) {
        jComboBox.addItem((Object)" 1x ");
        jComboBox.addItem((Object)" 2x ");
        jComboBox.addItem((Object)" 4x ");
        jComboBox.addItem((Object)" 6x ");
        jComboBox.addItem((Object)" 8x ");
        jComboBox.addItem((Object)" 10x ");
        jComboBox.setSelectedIndex(2);
    }

    public void setSpeed(boolean bl, int n) {
        if (this.burner != null) {
            int n2 = this.burner.lockSpeed(bl, n);
            if (n2 != 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)this.burner.burner.rc2msg(n2), (String)"Error", (int)0);
            }
        } else {
            System.out.println(String.valueOf(bl ? "CDRW " : "CDROM") + ": " + n);
        }
    }

    static JButton access$getCDRWSpeedLockB(DriveSpeedPanel driveSpeedPanel) {
        return driveSpeedPanel.getCDRWSpeedLockB();
    }

    static void access$connEtoC3(DriveSpeedPanel driveSpeedPanel, ActionEvent actionEvent) {
        driveSpeedPanel.connEtoC3(actionEvent);
    }

    static JButton access$getCDRWResetSpeedB(DriveSpeedPanel driveSpeedPanel) {
        return driveSpeedPanel.getCDRWResetSpeedB();
    }

    static void access$connEtoC2(DriveSpeedPanel driveSpeedPanel, ActionEvent actionEvent) {
        driveSpeedPanel.connEtoC2(actionEvent);
    }

    static void access$connEtoC4(DriveSpeedPanel driveSpeedPanel, ActionEvent actionEvent) {
        driveSpeedPanel.connEtoC4(actionEvent);
    }

    static JButton access$getCDROMResetSpeedB(DriveSpeedPanel driveSpeedPanel) {
        return driveSpeedPanel.getCDROMResetSpeedB();
    }

    static void access$connEtoC1(DriveSpeedPanel driveSpeedPanel, ActionEvent actionEvent) {
        driveSpeedPanel.connEtoC1(actionEvent);
    }

    static JButton access$getCDROMSpeedLockB(DriveSpeedPanel driveSpeedPanel) {
        return driveSpeedPanel.getCDROMSpeedLockB();
    }

    class IvjEventHandler
    implements ActionListener {
        /* synthetic */ DriveSpeedPanel this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DriveSpeedPanel.access$getCDROMResetSpeedB(this.this$0)) {
                DriveSpeedPanel.access$connEtoC1(this.this$0, actionEvent);
            }
            if (actionEvent.getSource() == DriveSpeedPanel.access$getCDRWResetSpeedB(this.this$0)) {
                DriveSpeedPanel.access$connEtoC2(this.this$0, actionEvent);
            }
            if (actionEvent.getSource() == DriveSpeedPanel.access$getCDROMSpeedLockB(this.this$0)) {
                DriveSpeedPanel.access$connEtoC3(this.this$0, actionEvent);
            }
            if (actionEvent.getSource() == DriveSpeedPanel.access$getCDRWSpeedLockB(this.this$0)) {
                DriveSpeedPanel.access$connEtoC4(this.this$0, actionEvent);
            }
        }

        IvjEventHandler(DriveSpeedPanel driveSpeedPanel) {
            this.this$0 = driveSpeedPanel;
        }
    }
}

