/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.jni;

import com.ibm.regex.Match;
import com.ibm.regex.RegularExpression;
import com.vyx.jni.CDMediaInfo;
import com.vyx.jni.CDTOCCallback;
import com.vyx.jni.CDTOCRec;
import com.vyx.jni.ICDRDAOCallback;
import com.vyx.jni.MediaInfoCB;
import com.vyx.jni.SCSIDeviceRec;
import com.vyx.jni.StubCallback;
import com.vyx.jni.TOCInfo;
import com.vyx.jni.TOCInfoCB;
import java.util.Vector;

public final class CDRDAO {
    private static CDRDAO burner = null;
    public static String libName = "JCDRDAO";
    public static final int ERR_NOERRORS = 0;
    public static final int ERR_COMMON = 1;
    public static final int ERR_OPEN_FILE = 90;
    public static final int ERR_WRITE_FILE = 91;
    public static final int ERR_DEVICE_NOT_READY = 99;
    public static final int ERR_NO_DISK_IN_DRIVE = 100;
    public static final int ERR_TOC_IS_NULL = 1000;
    public static final int ERR_DEVICE_IS_NULL = 1001;
    private Vector tmpdevs = new Vector(16, 16);
    private ScanBusCB scan_callback = new ScanBusCB(this);

    static {
        Runtime.getRuntime().loadLibrary(libName);
    }

    private CDRDAO() {
        this.init();
    }

    private native int burn0(String var1, String var2, char var3, boolean var4, String var5, boolean var6, boolean var7, String var8, ICDRDAOCallback var9, int var10);

    public final int burnImage(String string, String string2, char c, boolean bl, String string3, boolean bl2, boolean bl3, String string4, int n, ICDRDAOCallback iCDRDAOCallback) {
        if (n < 1 || n > 40) {
            throw new IllegalArgumentException("illegal speed == " + n);
        }
        if (string == null) {
            throw new IllegalArgumentException("drive == null");
        }
        if (!(c >= 'A' && c <= 'Z' || c >= 'z' && c <= 'z' || c == '\u0000')) {
            throw new IllegalArgumentException("Unsupported drive letter: `" + c + "'");
        }
        return this.burn0(string, string2, c, bl, string3, bl2, bl3, string4, iCDRDAOCallback, n);
    }

    public final native void cancel();

    private native int clear0(String var1, String var2, boolean var3, ICDRDAOCallback var4);

    public final int clearCDRW(String string, String string2, char c, boolean bl, ICDRDAOCallback iCDRDAOCallback) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("drive == null");
        }
        if (!(c >= 'A' && c <= 'Z' || c >= 'z' && c <= 'z' || c == '\u0000')) {
            throw new IllegalArgumentException("Unsupported drive letter: `" + c + "'");
        }
        return this.clear0(string, string2, bl, iCDRDAOCallback);
    }

    public final int copyCD(String string, String string2, String string3, String string4, int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, ICDRDAOCallback iCDRDAOCallback) {
        this.setSimulateMode(bl3);
        this.setWriteSpeed(n2);
        this.setBuffer(n3 * 2);
        return this.copyCD(string, string2, string3, string4, n, bl, bl2, bl4, iCDRDAOCallback);
    }

    public final native int copyCD(String var1, String var2, String var3, String var4, int var5, boolean var6, boolean var7, boolean var8, ICDRDAOCallback var9);

    public final int diskInfo(String string, String string2, CDMediaInfo cDMediaInfo) {
        MediaInfoCB mediaInfoCB = new MediaInfoCB(cDMediaInfo);
        int n = this.diskInfo0(string, string2, mediaInfoCB);
        if (n == 0) {
            cDMediaInfo.calcBlocks();
        }
        return n;
    }

    public final int diskInfo(String string, String string2, ICDRDAOCallback iCDRDAOCallback) {
        return this.diskInfo0(string, string2, iCDRDAOCallback);
    }

    private native int diskInfo0(String var1, String var2, ICDRDAOCallback var3);

    public final CDTOCRec[] diskTOC(String string, String string2) {
        Vector vector = new Vector(16, 16);
        int n = this.readDiskTOC(string, string2, new CDTOCCallback(vector));
        if (n == 0) {
            CDTOCRec[] cDTOCRecArray = new CDTOCRec[vector.size()];
            int n2 = 0;
            while (n2 < cDTOCRecArray.length) {
                cDTOCRecArray[n2] = (CDTOCRec)vector.elementAt(n2);
                ++n2;
            }
            return cDTOCRecArray;
        }
        return null;
    }

    public native void done();

    public static final CDRDAO getInstance() {
        return burner == null ? (burner = new CDRDAO()) : burner;
    }

    private native int getTOCInfo(String var1, boolean var2, ICDRDAOCallback var3);

    private native void init();

    public final boolean isDiskInDrive(String string, String string2) {
        return this.diskInfo(string, string2, new StubCallback()) == 0;
    }

    public final String rc2msg(int n) {
        switch (n) {
            case 0: {
                return "OK";
            }
            case 99: {
                return "Device not ready";
            }
            case 100: {
                return "No disk in drive";
            }
            case 1: {
                return "Common error";
            }
            case 1000: {
                return "TOC string is null";
            }
            case 1001: {
                return "Device string is null";
            }
        }
        return "RC=" + n;
    }

    public final native int readCD(String var1, String var2, int var3, boolean var4, boolean var5, String var6, String var7, ICDRDAOCallback var8);

    public final native int readDiskTOC(String var1, String var2, ICDRDAOCallback var3);

    public final SCSIDeviceRec[] scanBus() {
        int n = this.scanBus0(this.scan_callback);
        if (n == 0) {
            SCSIDeviceRec[] sCSIDeviceRecArray = new SCSIDeviceRec[this.tmpdevs.size()];
            int n2 = 0;
            while (n2 < this.tmpdevs.size()) {
                sCSIDeviceRecArray[n2] = (SCSIDeviceRec)this.tmpdevs.elementAt(n2);
                ++n2;
            }
            return sCSIDeviceRecArray;
        }
        return null;
    }

    private native int scanBus0(ICDRDAOCallback var1);

    public final void setBuffer(int n) {
        this.setBufferSize0(n < 32 ? 32 : n);
    }

    private native void setBufferSize0(int var1);

    public final native int setSimulateMode(boolean var1);

    public final int setSpeed(String string, String string2, char c, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("drive == null");
        }
        if (n < 0 || n > 52) {
            n = 1;
        }
        return this.setSpeed0(string, string2, n);
    }

    public final int setSpeed(String string, String string2, int n) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("drive == null");
        }
        if (n < 0 || n > 52) {
            n = 1;
        }
        return this.setSpeed0(string, string2, n);
    }

    private native int setSpeed0(String var1, String var2, int var3);

    public final native void setWriteSpeed(int var1);

    public int TOCInfo(String string, boolean bl, TOCInfo tOCInfo) {
        if (string == null || tOCInfo == null) {
            return -1;
        }
        return this.getTOCInfo(string, bl, new TOCInfoCB(tOCInfo));
    }

    private native int write0(String var1, String var2, int var3, String var4, boolean var5, boolean var6, boolean var7, ICDRDAOCallback var8);

    public final int writeTOC(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, boolean bl5, ICDRDAOCallback iCDRDAOCallback) {
        if (string == null) {
            return 1001;
        }
        if (string4 == null) {
            return 1000;
        }
        char c = !bl2 ? (char)'\u0000' : (string3 == null ? (char)'\u0000' : string3.charAt(0));
        this.setWriteSpeed(n2);
        this.setSimulateMode(bl5);
        this.setBufferSize0(n);
        return this.write0(string, string2, c, string4, bl, bl3, bl4, iCDRDAOCallback);
    }

    public final int writeTOC(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, ICDRDAOCallback iCDRDAOCallback) {
        if (string == null) {
            return 1001;
        }
        if (string4 == null) {
            return 1000;
        }
        char c = !bl2 ? (char)'\u0000' : (string3 == null ? (char)'\u0000' : string3.charAt(0));
        return this.write0(string, string2, c, string4, bl, bl3, bl4, iCDRDAOCallback);
    }

    static Vector access$tmpdevs(CDRDAO cDRDAO) {
        return cDRDAO.tmpdevs;
    }

    class ScanBusCB
    implements ICDRDAOCallback {
        /* synthetic */ CDRDAO this$0;
        RegularExpression re = null;
        Match m = new Match();

        public ScanBusCB(CDRDAO cDRDAO) {
            this.this$0 = cDRDAO;
            this.re = new RegularExpression("(\\d+,\\d+,\\d+):(.*)");
        }

        public void toc(String string) {
        }

        public void msgf(int n, String string) {
            if (n == 0 && this.re.matches(string, this.m)) {
                CDRDAO.access$tmpdevs(this.this$0).addElement(new SCSIDeviceRec(this.m.getCapturedText(1).trim(), this.m.getCapturedText(2).trim()));
            }
        }
    }
}

