#pragma check_stack (off)
#include "os2.h"
#include "hopf6036.h"
#include "dcfioctl.h"
#include "common.h"

static USHORT usMaskSt = MASK_ST_ANT       +    // Info ber Ersatzantenne
                         MASK_ST_HLEAP     +    // Info ber Stundensprung
                         MASK_ST_SLEAP     +    // Info ber Schaltsekunde
                         MASK_ST_TZONE1    +    // Info ber Zeitzone 1
                         MASK_ST_TZONE2    +    // Info ber Zeitzone 2
                         MASK_ST_CARRIER   +    // Info ber Trger vorhanden
                         MASK_ST_TIMEVALID +    // Info ber Zeit gltig
                         MASK_ST_SET       ;    // Info ber Zahl der Setzvorgnge
static SHORT clocksetcnt = 0;
static DCF77_DATETIME dt;

short utcflag    = 0;
short offset     = 0;
short portaddr   = 0x280;
short intervall  = 10;

/* Externe Methoden und Variable im masm - code */
void outbyte (short port, short value);
UCHAR inbyte (short port);
void INT_3 (void);

int getTime (void)
{
    int my_offset;
    int stat_val;

    stat_val = inbyte (portaddr + OFFSET_STAT);
    if (((stat_val & HSTAT_DCFTIME) == 0) ||          // no DCF time
        (stat_val == 0xFF))                           // HW not found
       return FALSE;

    dt.hours    = bcd2bin (inbyte (portaddr + OFFSET_HOUR));
    dt.minutes  = bcd2bin (inbyte (portaddr + OFFSET_MIN ));
    dt.seconds  = bcd2bin (inbyte (portaddr + OFFSET_SEC ));
    dt.day      = bcd2bin (inbyte (portaddr + OFFSET_DAY ));
    dt.month    = bcd2bin (inbyte (portaddr + OFFSET_MON ));
    dt.year     = bcd2bin (inbyte (portaddr + OFFSET_YEAR));
    dt.timezone = (SHORT)TZ_DCF;

    my_offset = offset;
    if (utcflag)
    {
        if (stat_val & HSTAT_TZONE1)
            my_offset -= 1;
        if (stat_val & HSTAT_TZONE2)
            my_offset -= 2;
    } /* endif */

    dt.hours += offset;
    dt.year  += (dt.year > 80 ? 1900 : 2000);

    if (dt.hours > 23)
    {
        dt.hours -= 24;
        dt.day++;
        if (dt.day > lastDay (dt.month, dt.year))
        {
            dt.day -= lastDay (dt.month, dt.year);
            dt.month++;
            if (dt.month > 12)
            {
                dt.month -= 12;
                dt.year++;
            } /* endif month */
        } /* endif day */

    } /* endif hours */

    if (dt.hours < 0)
    {
        dt.hours += 24;
        dt.day--;
        if (dt.day > 1)
        {
            dt.month--;
            dt.day += lastDay (dt.month, dt.year);
            if (dt.month < 1)
            {
                dt.month += 12;
                dt.year--;
            } /* endif month */
        } /* endif */
    } /* endif */

    return TRUE;
}

int ioctl_fctn (UCHAR far* newdate, USHORT categUfkt)
{
    USHORT categ = (USHORT)categUfkt /256;
    USHORT fkt   = (USHORT)categUfkt %256;
    UCHAR  ucVal;
    SHORT  i;
    SHORT  port;

    if (categ == IOCTL_DCF77)
    {
        if (fkt == DCF77_GETSTATUS)
        {
            // Neue FKT
            DCF77_STATUS far *status = (DCF77_STATUS far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_STATUS)) == 1)
                return 0x8103;

            status->cDrvType        = DRVTYPE_HOPF6036;   // Treiber ist ZEIT.SYS
            status->cVerMajor       = H_VERSION;          // Hauptversionsnummer
            status->cVerMinor       = SW_VERSION;         // Unterversionsnummer
            status->bIsHRTimerAvail = FALSE;            // HR-Timer nicht verfgbar
            status->bPolarity       = 0;                  // Polaritt 0=negativ, 1=positiv
            status->uscBadSeconds   = 0;                  // empfangene falsche Zeiten
            status->uscGoodSeconds  = 0;                  // empfangene korrekte Zeiten
            status->uscTimeSet      = clocksetcnt;        // Zahl der Setzvorgnge
            status->flStatus        = 0;
            status->flMaskST        = usMaskSt;
            status->flMaskSS        = MASK_SS_HOPF;
            status->flMaskTO        = MASK_TO_ALL;
            status->flMaskIV        = MASK_IV_UPDATE;
            status->flMaskLN        = 0;

            ucVal = inbyte (portaddr + OFFSET_STAT);
            if (ucVal != 0xFF)
            {
                if (ucVal & HSTAT_ANT)
                    status->flStatus |= STATUS_ANT;
                if (ucVal & HSTAT_HLEAP)
                    status->flStatus |= STATUS_HLEAP;
                if (ucVal & HSTAT_SLEAP)
                    status->flStatus |= STATUS_SLEAP;
                if (ucVal & HSTAT_TZONE1)
                    status->flStatus |= STATUS_TZONE1;
                if (ucVal & HSTAT_TZONE2)
                    status->flStatus |= STATUS_TZONE2;
                if (ucVal & HSTAT_DCFTIME)
                    status->flStatus |= STATUS_TIMEVALID + STATUS_CARRIER;
            } /* endif */

            return 0;
        } // Ende Getstatus

        if (fkt == DCF77_GETDATETIME)
        {
            DCF77_DATETIME far *datetime = (DCF77_DATETIME far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_DATETIME)) == 1)
                return 0x8103;

            if (getTime ())
            {
              datetime->hours    = dt.hours;
              datetime->minutes  = dt.minutes;
              datetime->seconds  = dt.seconds;
              datetime->day      = dt.day;
              datetime->month    = dt.month;
              datetime->year     = dt.year;
              datetime->timezone = dt.timezone;
            }
            return 0;
        } // Ende GetDate

        if (fkt == DCF77_QUERYOFFSET)
        {
            DCF77_OFFSET far *offs = (DCF77_OFFSET far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_OFFSET)) == 1)
                return 0x8103;

            offs->flUTC =   utcflag;
            offs->sOffset = offset;  // Zeitoffset -3...+2 Stunden
            return 0;
        }

        if (fkt == DCF77_QUERYDATA)
        {
            DCF77_DATA far *data = (DCF77_DATA far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_DATA)) == 1)
                return 0x8103;

            data->bSupply       = 0;
            data->bcRepeat      = 0;
            data->usIOAddr      = (USHORT)portaddr;
            data->usSetInterval = (USHORT)intervall;
            data->usThreshold   = 0;
            data->bPort         = PORT_HOPF6036;
            return 0;
        }

        if (fkt == DCF77_SETOFFSET)
        {
            DCF77_OFFSET far *offs = (DCF77_OFFSET far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_OFFSET)) == 1)
                return 0x8103;

            utcflag = offs->flUTC;
            if ((offs->sOffset > -3 ) && (offs->sOffset < 4))
                offset = (char)offs->sOffset;
            else
                return 0x8103;
            return 0;
        }

        if (fkt == DCF77_SETDATA)
        {
            DCF77_DATA far *data = (DCF77_DATA far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_DATA)) == 1)
                return 0x8103;

            portaddr = data->usIOAddr;
            if (data->usSetInterval > 0)
                intervall   = (short) data->usSetInterval;
            return 0;
        }

        if (fkt == DCF77_SETPORT)
        {
            DCF77_PORT far *data = (DCF77_PORT far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_PORT)) == 1)
                return 0x8103;

            for (i=0; i<data->bNum; i++)
            {
               port = portaddr + data->ppData[i].bPortOfs;
               outbyte (port, data->ppData[i].bValue);
            } /* endfor */
            return 0;
        }

        if (fkt == DCF77_GETMILLI)
        {
            DCF77_MILLI far *data = (DCF77_MILLI far *)newdate;
            if (TestSeg (newdate, sizeof (DCF77_MILLI)) == 1)
                return 0x8103;

                if ((inbyte (portaddr+0x3B) == 0x58) && (inbyte (portaddr+0x3C) == 0x4E))
                    data->usValue = inbyte (portaddr+0x38) + (inbyte (portaddr+0x39) * 256);
                else
                    data->usValue = 0xFFFF;
            return 0;
        }
    }
}

void timer_fctn (void)
{
    static short intervallcnt = 2;

    intervallcnt--;

    if (intervallcnt <= 0)
    {
        if ((getTime ()) && (setClock (&dt)))    // wait time is successfull
        {
            intervallcnt = intervall;
            clocksetcnt++;
        }
    } /* endif */
}

