/* DeskWPS - Install / UnInstall for Desktop Clock          */

PARSE ARG action

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END

Exit /* End of DeskWPS.cmd                       */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'No installation parameter specified.'
SAY 'Correct parameter is: I = Install,  U = UnInstall, any other key = Exit.'
SAY 'Please try again with correct parameter.'
PARSE PULL action

SELECT
    WHEN TRANSLATE(STRIP(action)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(STRIP(action)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction
END

RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
SAY 'Error! No installation parameter specified. Press any key to exit ...'
PULL answer

CALL SysCls

Exit /* End of NoAction */

/* InstallMe - procedura za instalaciju programa DesktopClock */

InstallMe:  PROCEDURE

CALL SysCls

SAY 'Welcome to Desktop Clock Installation procedure!'
SAY 'Your files are in directory: '||DIRECTORY()
SAY 'This procedure will do following:'
SAY '     Create Program Object for Desktop Clock files on your Desktop,'
SAY '     Add Desktop Clock specific entry in OS2.INI file, in App ToolsByGoran.'
SAY 'Press "Y" (and Enter) to start Installation, any other key to exit...'
PARSE PULL answer

IF TRANSLATE(STRIP(answer)) <> "Y" THEN DO
    CALL NoAction
END

SAY 'Writing entry in OS2.INI'
CALL SysIni 'USER','ToolsByGoran','DesktopClockINIfile',DIRECTORY()||'\DESKCLK.INI'

ProgTitle = 'Desktop Clock 1.00'
EXE = 'DeskClk.exe'
ICO = 'DeskClk.ico'
InstallDir = DIRECTORY()
WorkDir = DIRECTORY()
Setup = 'OBJECTID=<DESKTOPCLOCK100_PROG>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = Replace
SAY 'Creating Program object'
CALL SysCreateObject 'WPProgram',ProgTitle,'<WP_DESKTOP>',Setup,Action
SAY 'WPS object created! To create shadow of Desktop Clock in Startup folder,'
SAY 'press "Y" (and Enter) to create shadow, any other key to exit...'
PARSE PULL answer
IF TRANSLATE(STRIP(answer)) = "Y" THEN DO
    CALL SysCreateShadow '<DESKTOPCLOCK090_PROG>', '<WP_START>'
END
CALL SysCls
'START /F View.exe DeskClk.inf Introduction'
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall DesktopClock */

UnInstallMe: PROCEDURE

CALL SysCls
SAY 'This is Desktop Clock UnInstallation procedure!'
SAY 'Your files are in directory: '||DIRECTORY()
SAY 'This program will do following:'
SAY '     Remove Desktop Clock specific entry in OS2.INI file, App ToolsByGoran.'
SAY '     Destroy Desktop Clock Program object'
SAY 'Note: if you want to ReInstall DesktopClock, start (DeskWPS I) again.'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer

IF answer <> "Y" THEN DO
    CALL NoAction
END

SAY 'Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','DesktopClockINIfile','DELETE:'
SAY 'Destroying Program object'
CALL SysDestroyObject '<DESKTOPCLOCK090_PROG>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory: '||DIRECTORY()
CALL SysFileTree DIRECTORY()||'\*.*', 'files', 'FSO'
DO i = 1 TO files.0
    SAY '     '||FILESPEC('name',files.i)
END
SAY 'If you want to ReInstall Desktop Clock, start DeskWPS I.Press any key to exit...'
PULL answer
RETURN /* End of UnInstallMe */
