/*
  Picture Clock /2 Module  Default Digital clock
*/

extern "C"{

#include "Module.h"
#include "stdio.h"

struct _Alarm{
  int hour;
  int minute;
};

typedef struct _Alarm Alarm;


static PSZ APPNAME = "Alarm 1.0";
static PSZ WINPOS = "Window Position";


MRESULT APIENTRY PC2ModuleProcedure
    (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg ){
  case MDL_ID:
    return MPFROMP(MDLID_V100);

  case MDL_STATE:
    return MPFROMLONG( MDLSTATE_HIDE );

  case MDL_TRIGGER:
    {
      ModuleInfo* minfo = (ModuleInfo*)PVOIDFROMMP(mp1);
      Alarm* inf = (Alarm*)(minfo->buffer);
      int min = minfo->datetime.minutes;
      int hour = minfo->datetime.hours;
printf( "Alarm trigger\n" ); fflush( stdout );
      if( inf->hour != hour ){
	inf->minute = min;
	inf->hour = hour;
	WinAlarm( HWND_DESKTOP, WA_NOTE );
      }
      return 0;
    }
    
  case MDL_TITLE:
    return MRFROMP( "WA[" );

  default:
    return 0;
  }
}

// end of extern "C"
}
