#include"Dial.h"
#include"sinTable.h"
#include<math.h>
#include<stdio.h>

#define RADIOUS_LARGE	0.06
#define RADIOUS_SMALL	0.02
#define R	(1.0-RADIOUS_LARGE)

#define GAP 3

#define M_PI 3.14159265358979323846


// TƂ̑傫
static void drawCircles
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i+=5 ){
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_LARGE;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
}


// PƂ̓_
static void drawDots
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, LONG dro )
{
    for( int i=0; i<60; i++ ){
	if( i%5 == 0 ) continue;
	POINTL pt;
	LONG r = (LONG)((float)half * R);
	pt.x = (ULONG)((LONG)(r * Cos[i])>>16) + orgX;
	pt.y = (ULONG)((LONG)(r * Sin[i])>>16) + orgY;
	GpiMove( hps, &pt );
	float a = half * RADIOUS_SMALL;
	GpiFullArc( hps, dro, ((ULONG)a)<<16 );
	}
}


static void rotate
	( const POLYGON& src, POLYGON& dest,
	  double orgX, double orgY, double magnify, double min )
{
    double Sin = sin( M_PI*min/30.0 );
    double Cos = cos( M_PI*min/30.0 );

    dest.ulPoints = src.ulPoints;
    for( int i=0; i<src.ulPoints; i++ ){
	double x, y;
	x = magnify * src.aPointl[i].x;
	y = magnify * src.aPointl[i].y;
	dest.aPointl[i].x = (ULONG)(  x * Cos + y * Sin + orgX);
	dest.aPointl[i].y = (ULONG)( -x * Sin + y * Cos + orgY);
	}
}


// j
#define LNDL_POINTS 5	// j`̓_
#define SNDL_POINTS 5	// Zj`̓_
const static POINTL needleL[LNDL_POINTS] = {	// j
	{  0, 100 },
	{ -8, 0 },
	{  0,-20 },
	{  8, 0 },
	{  0, 100 }
	};
const static POLYGON ndlL = { LNDL_POINTS, needleL };

const static POINTL needleS[LNDL_POINTS] = {	// Zj
	{  0, 70 },
	{ -10, 0 },
	{  0,-15 },
	{  10, 0 },
	{  0, 70 }
	};
const static  POLYGON ndlS = { SNDL_POINTS, needleS };

void Dial :: drawNeedle
	( HPS hps, ULONG orgX, ULONG orgY, ULONG half, BOOL real )
{
    POINTL rotNeedleL[LNDL_POINTS];
    POLYGON rotNdlL;
    rotNdlL.aPointl = rotNeedleL;
    POINTL rotNeedleS[SNDL_POINTS];
    POLYGON rotNdlS;
    rotNdlS.aPointl = rotNeedleS;

    // ]̍W𓾂
    rotate( ndlS, rotNdlS,
	(double)orgX, (double)orgY, (double)half/100.0, 
	(double)(this->hour)*5.0 + (double)(this->min)/12.0 );
    rotate( ndlL, rotNdlL,
	(double)orgX, (double)orgY, (double)half/100.0,
	(double)(this->min) );


    // Zj`
    GpiMove( hps, rotNdlS.aPointl );
    rotNdlS.ulPoints--;
    rotNdlS.aPointl++;
    if( real ){
	GpiSetPattern ( hps, this->ptnShadow ) ;
	GpiSetColor( hps, this->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, this->lcolorNeedle );
	GpiPolyLine( hps, rotNdlS.ulPoints, rotNdlS.aPointl );
    }else{
	GpiSetPattern ( hps, this->ptnShadow ) ;
	GpiSetColor( hps, this->colorShadow );
	GpiPolygons( hps, 1, &rotNdlS, POLYGON_BOUNDARY, POLYGON_INCL );
	}

    // j`
    GpiMove( hps, rotNdlL.aPointl );
    rotNdlL.ulPoints--;
    rotNdlL.aPointl++;
    if( real ){
	GpiSetPattern ( hps, this->ptnNeedle ) ;
	GpiSetColor( hps, this->colorNeedle );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	GpiSetColor( hps, this->lcolorNeedle );
	GpiPolyLine( hps, rotNdlL.ulPoints, rotNdlL.aPointl );
    }else{
	GpiSetPattern ( hps, this->ptnShadow ) ;
	GpiSetColor( hps, this->colorShadow );
	GpiPolygons( hps, 1, &rotNdlL, POLYGON_BOUNDARY, POLYGON_INCL );
	}
}


Dial :: Dial( ClockManager* mgr, HAB hab, HWND parent )
    : TimeView( mgr, hab, parent )
{
    colorShadow = CLR_BLACK;
    ptnShadow = PATSYM_HALFTONE;

    colorCircle = CLR_PALEGRAY;
    lcolorCircle = CLR_BLACK;
    ptnCircle = PATSYM_SOLID;

    colorNeedle = CLR_PALEGRAY;
    lcolorNeedle = CLR_BLACK;
    ptnNeedle = PATSYM_HALFTONE;
};


Dial :: ~Dial( )
{
};


void Dial :: drawTime( HPS hps, ULONG width, ULONG height )
{
    ULONG x1, y1, x2, y2, half, orgX, orgY;
    // Shadow
    x1 = GAP;	y1 = 0;
    x2 = width;	y2 = height - GAP;
    orgX = (x1+x2)>>1;	orgY = (y1+y2)>>1;
    half = (width<height) ? (width-GAP) >> 1 : (height-GAP) >> 1;
    GpiSetLineType( hps, LINETYPE_INVISIBLE );
    GpiSetLineWidth( hps, LINEWIDTH_NORMAL );
    GpiSetPattern ( hps, this->ptnShadow ) ;
    GpiSetColor( hps, this->colorShadow );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    drawNeedle( hps, orgX, orgY, half, FALSE );

    // Real
    x1 = 0;	y1 = GAP;
    x2 = width-GAP;	y2 = height;
    orgX = (x1+x2)>>1;	orgY = (y1+y2)>>1;
    half = (width<height) ? (width-GAP) >> 1 : (height-GAP) >> 1;
    GpiSetLineType( hps, LINETYPE_SOLID );
    GpiSetLineWidth( hps, LINEWIDTH_NORMAL );
    GpiSetPattern ( hps, this->ptnCircle );
    GpiSetColor( hps, this->colorCircle );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    drawDots( hps, orgX, orgY, half, DRO_OUTLINEFILL );
    GpiSetColor( hps, this->lcolorCircle );
    drawCircles( hps, orgX, orgY, half, DRO_OUTLINE );
    drawDots( hps, orgX, orgY, half, DRO_OUTLINE );
    drawNeedle( hps, orgX, orgY, half, TRUE );

    return;
}


BOOL Dial :: trigger()
{
    if( this->oldMin != this->min || this->oldHour != this->hour ){
	this->oldMin = this->min;
	this->oldHour = this->hour;
	return TRUE;
	}

    return FALSE;
}


void Dial :: init( HINI hini )
{
    int i[4];
    char string[1024];

    // e̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Shadow", "", string, 1024 );
    if( sscanf( string, "%d %d", i, i+1 ) == 2 ){
	colorShadow = i[0];
	ptnShadow = i[1];
	}

    // ڐ̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Circle", "", string, 1024 );
    if( sscanf( string, "%d %d %d", i, i+1, i+2 ) == 3 ){
	colorCircle = i[0];
	lcolorCircle = i[1];
	ptnCircle = i[2];
	}

    // j̐F
    PrfQueryProfileString(
	hini, "Dial1.0", "Needle", "", string, 1024 );
    if( sscanf( string, "%d %d %d", i, i+1, i+2 ) == 3 ){
	colorNeedle = i[0];
	lcolorNeedle = i[1];
	ptnNeedle = i[2];
	}

    // \ʒu
    PrfQueryProfileString(
	hini, "Dial1.0", "WinPostion", "0 0 150 150", string, 1024 );
    if( sscanf( string, "%d %d %d %d", i, i+1, i+2, i+3 ) == 4 ){
	WinSetWindowPos(
	    this->hwndFrame,
	    HWND_TOP,
	    i[0], i[1], i[2], i[3],
	    SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER);
	}
}


void Dial :: writeIni( HINI hini )
{
    char string[1024];

    // e̐F
    sprintf( string, "%d %d",
	(int)this->colorShadow, (int)this->ptnShadow );
    PrfWriteProfileString(
	hini, "Dial1.0", "Shadow", string );

    // ڐ̐F
    sprintf( string, "%d %d %d",
      (int)this->colorCircle, (int)this->lcolorCircle, (int)this->ptnCircle );
    PrfWriteProfileString(
	hini, "Dial1.0", "Circle", string );

    // j̐F
    sprintf( string, "%d %d %d",
      (int)this->colorNeedle, (int)this->lcolorNeedle, (int)this->ptnNeedle );
    PrfWriteProfileString(
	hini, "Dial1.0", "Needle", string );

    // \ʒu
    SWP swp;
    WinQueryWindowPos( this->hwndFrame, &swp );
    sprintf( string, "%d %d %d %d",
	(int)swp.x, (int)swp.y, (int)swp.cx, (int)swp.cy );
    PrfWriteProfileString(
	hini, "Dial1.0", "WinPostion", string );
}
