/* ^Cgo[̂ȂEBhE */
/*   1996.3.3 -  by Akishi.Murata */

#include "Window.h"
#include <stdio.h>

#define CN_Window "Window"
#define CN_NoFrameWindow "NoFrameWindow"
#define PTR_CPPOBJ	0L
#define CB_WND_DATA	(sizeof(PVOID)+4L)
#define WS_DEFAULT	(WS_ANIMATE|WS_VISIBLE)
#define FCF_DEFAULT	(FCF_SHELLPOSITION|FCF_SIZEBORDER|FCF_TASKLIST|FCF_NOBYTEALIGN)


// EBhEvV[WɃNX֐ݒ肷@Ȃ̂ŁA
// xNX֐ʂ܂
// Send message to class message procedure
static MRESULT EXPENTRY fowardFrameMessage
    ( HWND aHwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    Window *instance
	= (Window*)WinQueryWindowPtr( aHwnd, PTR_CPPOBJ );

    return instance->frameProc( aHwnd, msg, mp1, mp2 );
}


static MRESULT EXPENTRY fowardClientMessage
    ( HWND aHwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    Window *instance
	= (Window*)WinQueryWindowPtr( aHwnd, PTR_CPPOBJ );

    return instance->clientProc( aHwnd, msg, mp1, mp2 );
}


Window :: Window( HAB aHab )
{
    this->hab = aHab;
    this->hwndParent = HWND_DESKTOP;
    this->frameFlags = FCF_DEFAULT;
    this->initialize( WS_DEFAULT );
}


Window ::  Window( HAB aHab, HWND parent )
{
    this->hab = aHab;
    this->hwndParent = parent;
    this->frameFlags = FCF_DEFAULT;
    this->initialize( WS_DEFAULT );
}


Window :: Window( HAB aHab, HWND parent, ULONG clientStyle )
{
    this->hab = aHab;
    this->hwndParent = parent;
    this->frameFlags = FCF_DEFAULT;
    Window :: initialize( clientStyle );
}


Window :: Window( HAB aHab, HWND parent, ULONG clientStyle, ULONG frameStyle )
{
    this->hab = aHab;
    this->hwndParent = parent;
    this->frameFlags = frameStyle;
    Window :: initialize( clientStyle );
}


Window :: Window(
	HAB	hab,
	HWND	parent,
	ULONG	flStyle,
	LONG	x, LONG y, LONG cx, LONG cy )
{
    this->hab = hab;
    this->hwndParent = parent;
    this->hwndFrame = NULLHANDLE;

    // EBhENX̓o^
    /* Register window class if not registered */
    static CLASSINFO cinfo;
    if( FALSE == WinQueryClassInfo(
	this->hab, CN_NoFrameWindow, &cinfo ) ){
	WinRegisterClass(
	    this->hab,
	    (PSZ)CN_NoFrameWindow,
	    NULL,
	    flStyle,
	    CB_WND_DATA );
	}

    this->hwndClient = WinCreateWindow(
	this->hwndParent,
	CN_NoFrameWindow,
	NULL,
	flStyle,
	x, y, cx, cy,
	this->hwndParent,
	HWND_TOP,
	0,
	NULL,
	NULL );

    this->setWindowProcedure();
}


Window :: ~Window()
{
    WinDestroyWindow( this->hwndFrame );
}


// qɌĂ΂ď
// ȗlɏ_ɑΉ邽
// Called by constructor, for flexibility
void Window :: initialize( ULONG clientStyle )
{
    // EBhENX̓o^
    /* Register window class if not registered */
    static CLASSINFO cinfo;
    if( FALSE == WinQueryClassInfo(
	this->hab, CN_Window, &cinfo ) ){
	WinRegisterClass(
	    this->hab,
	    CN_Window,
	    NULL,
	    CS_SIZEREDRAW,
	    CB_WND_DATA );
	}

    // EBhE쐻
    /* Make Window */
    this->hwndFrame = WinCreateStdWindow(
	this->hwndParent,
	clientStyle,
        &(this->frameFlags),
	CN_Window,	//	NULL,
	"",
	NULLHANDLE,
	0,
	0,
	&(this->hwndClient) );

    this->setWindowProcedure();
}


void Window :: setWindowProcedure( void )
{
    // EBhEvV[W̐ݒ
    // Set Window procedure
    this->defaultClientProc =
	WinSubclassWindow( this->hwndClient, fowardClientMessage );
    WinSetWindowPtr( this->hwndClient, PTR_CPPOBJ, (PVOID)this );

    if( this->hwndFrame == NULLHANDLE ) return;
    this->defaultFrameProc =
	WinSubclassWindow( this->hwndFrame, fowardFrameMessage );
    WinSetWindowPtr( this->hwndFrame, PTR_CPPOBJ, (PVOID)this );
}


MRESULT EXPENTRY Window :: frameProc
    ( HWND aHwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    return this->defaultFrameProc( aHwnd, msg, mp1, mp2 );
}


MRESULT EXPENTRY Window :: clientProc
    ( HWND aHwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    return this->defaultClientProc( aHwnd, msg, mp1, mp2 );
}

/*
void Window :: init( HINI ){ return; }
void Window :: writeIni( HINI ){ return; }
*/
