// #define kurz_msg                            /* kurze Debugmessages     */

#include <stdio.h>
#include <stdlib.h>

#include "bastypes.h"
#include "os.h"

/*---------------------------------------------------------------------*/

#define ushort unsigned short               /*                         */
#define ulong  unsigned long                /*                         */

void     out_blk_std(char  *data, unsigned short length)    ;
void (  *out_blk)   (char  *data, unsigned short length) = 0;

char buff1 [2048] = {0};

char hex[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

char buff2 [2048] = {0};

FILE* log_file2 = NULL;

char buff3 [2048] = {0};

/* ------------------------------------------------------------------- */
/* capi-unabhaengige funktionen                                         */
/* ------------------------------------------------------------------- */

ushort str_len  (char  *str) { ushort t; for (t=0;*str++;t++); return (t); }
void   prn_str  (char  *str) { out_blk (str,str_len(str));}
void   prn_crlf (void)      { prn_str ("\n");}
void   prn_char (char c)    { out_blk (&c,1);}

void   prn_chr (char num)
{
   prn_str ("\'");
   prn_char (num);
   prn_str ("\'");
}

void   prn_hex8 (char num)
{
   prn_str ("0x");
   prn_char (hex[num >>  4 & 0x000f]);
   prn_char (hex[num       & 0x000f]);
}

void   prn_hex16 (ushort num)
{
  prn_str ("0x");
  prn_char (hex[num >> 12 & 0x000f]);
  prn_char (hex[num >>  8 & 0x000f]);
  prn_char (hex[num >>  4 & 0x000f]);
  prn_char (hex[num       & 0x000f]);
}

void   prn_hex32 (ulong num)
{
  prn_str ("0x");
  prn_char (hex[(num & 0xf0000000) >> 28]);
  prn_char (hex[(num & 0x0f000000) >> 24]);
  prn_char (hex[(num & 0x00f00000) >> 20]);
  prn_char (hex[(num & 0x000f0000) >> 16]);
  prn_char (hex[(num & 0x0000f000) >> 12]);
  prn_char (hex[(num & 0x00000f00) >>  8]);
  prn_char (hex[(num & 0x000000f0) >>  4]);
  prn_char (hex[(num & 0x0000000f)      ]);
}

void prn_bin32 (ulong num)
{
   ulong i;

   for (i=1;i<=32;i++) {
      if ((num & 0x80000000) == 0x80000000) prn_str ("1"); else prn_str ("0");
      num = num << 1;
   }
   prn_str ("b");
}

void prn_bin16 (ushort num)
{
   ushort i;

   for (i=1;i<=32;i++) {
      if ((num & 0x8000) == 0x8000) prn_str ("1"); else prn_str ("0");
      num = num << 1;
   }
   prn_str ("b");
}

void prn_bin8 (char num)
{
   char i;

   for (i=1;i<=32;i++) {
      if ((num & 0x80) == 0x80) prn_str ("1"); else prn_str ("0");
      num = num << 1;
   }
   prn_str ("b");
}

void prn_dec32 (ulong num)
{
   ulong help;
   char  start = 0;

   help = num / 10000000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help * 10000000);};
   help = num /  1000000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *  1000000);};
   help = num /   100000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *   100000);};
   help = num /    10000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *    10000);};
   help = num /     1000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *     1000);};
   help = num /      100; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *      100);};
   help = num /       10; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *       10);};
   prn_char (hex[num]);
}

void prn_dec16 (ushort num)
{
   ushort help;
   char  start = 0;

   help = num /    10000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *    10000);};
   help = num /     1000; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *     1000);};
   help = num /      100; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *      100);};
   help = num /       10; if (help) start = 1; if (start) {prn_char (hex[help]); num = num - (help *       10);};
   prn_char (hex[num]);
}

void prn_dec8 (unsigned char num)
{
   prn_char (hex[num]);
}

void prn_struc (char  *ptr)
{
   char len;
   char i;

   len = *ptr++;
   prn_str ("len = ");
   prn_hex8 (len);
   prn_str (" / data: ");
   for (i=1;i<=len;i++) {
      prn_hex8 (*ptr++);
      prn_str (" ");
   }
}

void   prn_sys_time (void)
{
/*
   char         dp[2] = ":";

   systics = CIOSJOBCLK (&ticlen, &zeit);

   if (zeit.systime_hour < 10) prn_char (hex[0]);
   prn_dec32 (zeit.systime_hour);
   prn_char (dp[0]);

   if (zeit.systime_min < 10) prn_char (hex[0]);
   prn_dec32 (zeit.systime_min);
   prn_char (dp[0]);

   if (zeit.systime_sec < 10) prn_char (hex[0]);
   prn_dec32 (zeit.systime_sec);
   dp[0] = '.';
   prn_char (dp[0]);

   if (zeit.systime_msec < 100) prn_char (hex[0]);
   if (zeit.systime_msec < 10 ) prn_char (hex[0]);
   prn_dec32 (zeit.systime_msec);
*/
}


void prn_msgn20 (ushort command);
void prn_msgn11 (ushort command);

/* ------------------------------------------------------------------- */
/* capi funktionen (1.1 und 2.0)                                       */
/* ------------------------------------------------------------------- */
void prn_res     (ushort result){prn_str ("| Result: Funktionsergebnis: ");prn_hex16 (        result);prn_crlf ();}
void prn_aid     (ulong  aid   ){prn_str ("| Applikationsnummer.......: ");prn_hex16 ((ushort)aid   );prn_crlf ();}
void prn_plci16  (ushort plci  ){prn_str ("| PLCI.....................: ");prn_hex16 (        plci  );prn_crlf ();}
void prn_plci32  (ulong  plci  ){prn_str ("| PLCI.....................: ");prn_hex32 (        plci  );prn_crlf ();}
void prn_ncci16  (ushort ncci  ){prn_str ("| NCCI.....................: ");prn_hex16 (        ncci  );prn_crlf ();}
void prn_ncci32  (ulong  ncci  ){prn_str ("| NCCI.....................: ");prn_hex32 (        ncci  );prn_crlf ();}
void prn_addr32  (ulong  addr  ){prn_str ("| Adresse der Daten........: ");prn_hex32 (        addr  );prn_crlf ();}
void prn_lendta  (ushort len   ){prn_str ("| Laenge der Daten.........: ");prn_dec32 (        len   );prn_crlf ();}
void prn_handta  (ushort handle){prn_str ("| Referenz.................: ");prn_dec32 (        handle);prn_crlf ();}
void prn_flags   (ushort flags ){prn_str ("| Flags....................: ");prn_hex16 (        flags );prn_crlf ();}
void prn_rejct8  (char   reject){prn_str ("| Reject...................: ");prn_hex8  (        reject);prn_crlf ();}
void prn_rejct16 (ushort reject){prn_str ("| Reject...................: ");prn_hex16 (        reject);prn_crlf ();}
void prn_ctrl8   (char   ctrl  ){prn_str ("| Controller...............: ");prn_hex8  ((char)  ctrl  );prn_crlf ();}
void prn_ctrl32  (ulong  ctrl  ){prn_str ("| Controller...............: ");prn_hex32 (        ctrl  );prn_crlf ();}
void prn_manuid  (ulong  manuid){prn_str ("| Manu ID..................: ");prn_hex32 (        manuid);prn_crlf ();}
void prn_infom   (ulong  infom ){prn_str ("| Info Mask................: ");prn_hex32 (        infom );prn_str (" / ");prn_bin32 (infom); prn_crlf ();}
void prn_infon   (ushort infon ){prn_str ("| Info number..............: ");prn_hex16 (        infon );prn_crlf ();}
void prn_cipm    (ulong  cipm  ){prn_str ("| CIP Mask.................: ");prn_hex32 (        cipm  );prn_str (" / ");prn_bin32 (cipm ); prn_crlf ();}
void prn_cipm2   (ulong  cipm2 ){prn_str ("| CIP Mask 2...............: ");prn_hex32 (        cipm2 );prn_str (" / ");prn_bin32 (cipm2); prn_crlf ();}
void prn_cipv    (ushort cipv  ){prn_str ("| CIP Value................: ");prn_hex16 (        cipv  );prn_str (" / ");prn_bin32 (cipv ); prn_crlf ();}
void prn_bchan   (char   bchan ){prn_str ("| B-Channel................: ");prn_hex8  (        bchan );prn_crlf ();}
void prn_outgs   (char   outgs ){prn_str ("| Outgoing Service.........: ");prn_hex8  (        outgs );prn_crlf ();}
void prn_outgsa  (char   outgsa){prn_str ("| Outgoing-Service-Add.....: ");prn_hex8  (        outgsa);prn_crlf ();}
void prn_seaz    (char   seaz  ){prn_str ("| Source-EAZ...............: ");prn_chr   (        seaz  );prn_crlf ();}
void prn_reqs    (char   reqs  ){prn_str ("| Requested-Service........: ");prn_hex8  (        reqs  );prn_crlf ();}
void prn_reqsa   (char   reqsa ){prn_str ("| Requested-Service-Add....: ");prn_hex8  (        reqsa );prn_crlf ();}
void prn_reaz    (char   reaz  ){prn_str ("| Requested-EAZ............: ");prn_chr   (        reaz  );prn_crlf ();}
void prn_cause   (char   cause ){prn_str ("| Cause....................: ");prn_hex8  (        cause );prn_crlf ();}
void prn_seeaz   (ushort seeaz ){prn_str ("| Serviced-EAZ-Mask........: ");prn_hex16 (        seeaz );prn_str (" / ");prn_bin32 (seeaz) ;prn_crlf ();}
void prn_ssimsk  (ushort ssimsk){prn_str ("| Serviced-SI-Mask.........: ");prn_hex16 (        ssimsk);prn_str (" / ");prn_bin32 (ssimsk);prn_crlf ();}
void prn_b3lc    (char   b3lc  ){prn_str ("| B3-Link-Cout.............: ");prn_hex8  (        b3lc  );prn_crlf ();}
void prn_ser     (char   ser   ){prn_str ("| Service..................: ");prn_hex8  (        ser   );prn_crlf ();}
void prn_sera    (char   sera  ){prn_str ("| Service-Add..............: ");prn_hex8  (        sera  );prn_crlf ();}
void prn_sere    (char   sere  ){prn_str ("| Service-EAZ..............: ");prn_chr   (        sere  );prn_crlf ();}
void prn_b2prot  (char   b2prot){prn_str ("| B2-Protocol..............: ");prn_hex8  (        b2prot);prn_crlf ();}
void prn_b3prot  (char   b3prot){prn_str ("| B3-Protocol..............: ");prn_hex8  (        b3prot);prn_crlf ();}
void prn_number  (char   number){prn_str ("| Number...................: ");prn_hex8  (        number);prn_crlf ();}
void prn_dadd    (char  *msg    ){prn_str ("| Destination-Address......: ");prn_struc (msg);prn_crlf ();}
void prn_caladd  (char  *msg    ){prn_str ("| Caller-Address...........: ");prn_struc (msg);prn_crlf ();}
void prn_conadd  (char  *msg    ){prn_str ("| Connected-Address........: ");prn_struc (msg);prn_crlf ();}
void prn_dlpd    (char  *msg    ){prn_str ("| DLPD.....................: ");prn_struc (msg);prn_crlf ();}
void prn_ncpd    (char  *msg    ){prn_str ("| NCPD.....................: ");prn_struc (msg);prn_crlf ();}
void prn_cipn    (char  *msg    ){prn_str ("| Calling party number.....: ");prn_struc (msg);prn_crlf ();}
void prn_cipsa   (char  *msg    ){prn_str ("| Calling party subaddress.: ");prn_struc (msg);prn_crlf ();}
void prn_cdpn    (char  *msg    ){prn_str ("| Called party number......: ");prn_struc (msg);prn_crlf ();}
void prn_cdpsa   (char  *msg    ){prn_str ("| Called party subaddress..: ");prn_struc (msg);prn_crlf ();}
void prn_cn      (char  *msg    ){prn_str ("| Connected number.........: ");prn_struc (msg);prn_crlf ();}
void prn_cs      (char  *msg    ){prn_str ("| Connected subaddress.....: ");prn_struc (msg);prn_crlf ();}
void prn_bprot   (char  *msg    ){prn_str ("| B protocol...............: ");prn_struc (msg);prn_crlf ();}
void prn_bc      (char  *msg    ){prn_str ("| BC.......................: ");prn_struc (msg);prn_crlf ();}
void prn_llc     (char  *msg    ){prn_str ("| LLC......................: ");prn_struc (msg);prn_crlf ();}
void prn_hlc     (char  *msg    ){prn_str ("| HLC......................: ");prn_struc (msg);prn_crlf ();}
void prn_addi    (char  *msg    ){prn_str ("| Additional info..........: ");prn_struc (msg);prn_crlf ();}
void prn_cpn     (ulong  cpn       ){prn_str ("| Controller/PLCI/NCCI.....: ");prn_hex32 (        cpn); prn_crlf ();}
void prn_cp      (ulong  cp        ){prn_str ("| Controller/PLCI..........: ");prn_hex32 (        cp ); prn_crlf ();}
void prn_fs      (ushort fs        ){prn_str ("| Facility selector........: ");prn_hex16 (        fs ); prn_crlf ();}
void prn_frp     (char  *msg    ){prn_str ("| Facility request parametr: ");prn_struc (msg);prn_crlf ();}
void prn_fcp     (char  *msg    ){prn_str ("| Facility conf. parameter.: ");prn_struc (msg);prn_crlf ();}
void prn_fip     (char  *msg    ){prn_str ("| Facility ind. parameter..: ");prn_struc (msg);prn_crlf ();}
void prn_fpp     (char  *msg    ){prn_str ("| Facility resp. parameter.: ");prn_struc (msg);prn_crlf ();}
void prn_infoe   (char  *msg    ){prn_str ("| Info element.............: ");prn_struc (msg);prn_crlf ();}
void prn_end_str (void          ){prn_str ("\\--------------------------\n");}

void prn_ncpi  (char  *msg)
{
   char len;
   char t;

   prn_str ("| NCPI (Len/NCPI)..........: ");
   len = *msg++;
   prn_dec32 (len);
   prn_str (" / ");
   for (t=0;t<len;t++) {prn_hex8 (*msg++); prn_str (" ");};
   prn_crlf ();
}

void prn_info  (ushort info  )
{
   prn_str ("| Info.....................: ");
   prn_hex16 (info  );
   prn_str (" (");
   prn_dec32 ((ulong)((char)(info >> 8)));
   prn_str ("/");
   prn_dec32 ((ulong)(info & 0x00ff));
   prn_str (")");
   prn_crlf ();
}

void prn_reason  (ushort info)
{
   prn_str ("| Reason...................: ");
   prn_hex16 (info  );
   prn_str (" (");
   prn_dec32 ((ulong)((char)(info >> 8)));
   prn_str ("/");
   prn_dec32 ((ulong)(info & 0x00ff));
   prn_str (")");
   prn_crlf ();
}

void prn_reasb3 (ushort info)
{
   prn_str ("| Reason_B3................: ");
   prn_hex16 (info  );
   prn_str (" (");
   prn_dec32 ((ulong)((char)(info >> 8)));
   prn_str ("/");
   prn_dec32 ((ulong)(info & 0x00ff));
   prn_str (")");
   prn_crlf ();
}

void prn_msg_body (char  * msg, ushort capi, ushort result)
{
  prn_aid (*((ushort *)(msg+2)))  ;
  prn_str ("| Result: Funktionsergebnis: ");prn_hex16 (result)  ;prn_crlf ();
  prn_str ("| Adresse der Message......: ");prn_hex32 ((ulong)msg);prn_crlf ();
  prn_str ("| | Laenge der Message.....: ");prn_dec16 (*((ushort *)(msg+0)))  ;prn_crlf ();
  prn_str ("| | Applikationsnummer.....: ");prn_hex16 (*((ushort *)(msg+2)))  ;prn_crlf ();
  prn_str ("| | Message................: ");
  switch (capi) {
     case 1 : prn_msgn11  (*((ushort *)(msg+4))); break;
     case 2 : prn_msgn20  (*((ushort *)(msg+4))); break;
     default: prn_str ("Unbekannte CAPI-Version!!!"); break;
  }
  prn_crlf ();

  prn_str ("| | Message-Folgenummer....: ");prn_hex16 (*((ushort *)(msg+6)))  ;prn_crlf ();
}

void analyze_register( char  *pApplBuf,
                       ushort uwMessageBufferSize,
                       ushort uwMaxLogicalConnection,
                       ushort uwMaxBDataBlocks,
                       ushort uwMaxBDataLen,
                       ushort result,
                       ushort capi)
{
  prn_sys_time();
  prn_str ("  API REGISTER\n");
  if (capi==1) {prn_str ("| Max. Anz. der Messages...: ");prn_dec32 ((ushort)uwMessageBufferSize);prn_crlf();};
  if (capi==2) {prn_str ("| Groesse d. Messagebuffers: ");prn_dec32 ((ushort)uwMessageBufferSize);prn_crlf();};
  prn_str ("| Max. Anz. B3-Verbindungen: ");prn_dec32 ((ushort)uwMaxLogicalConnection); prn_crlf();
  prn_str ("| Max. Anz. B3-Bloecke/Verb: ");prn_dec32 ((ushort)uwMaxBDataBlocks);       prn_crlf();
  prn_str ("| Max. Groesse eines B3-Blk: ");prn_dec32 ((ushort)uwMaxBDataLen);          prn_crlf();
  prn_str ("| Adresse Applikat.-Buffer.: ");prn_hex32 ((ulong )pApplBuf);               prn_crlf();
  prn_str ("| Result: Applikationsnr...: ");prn_hex16 (result) ;prn_crlf ();
  prn_end_str ();
}

/* ------------------------------------------------------------------- */
/* capi 1.1 funktionen                                                 */
/* ------------------------------------------------------------------- */

void capi_analyze_init   (ulong result,FILE* log_file)
{
  out_blk = out_blk_std;
  log_file2 = log_file;
//  printf ("\n\rfile=%d\n\r",log_file2);

  prn_str ("# ISDNcheck\n");
  prn_str ("|\n");
  prn_str ("| fuer CAPI 1.1 Profil A & CAPI 2.0\n");
  prn_str ("| Ver. 1.10 vom 16.04.96 /wf\n");
  prn_str ("|\n");
  prn_str ("| Result: Funktionsergebnis: ");prn_hex32 (result);prn_crlf ();
  prn_end_str ();
}


void prn_msgn11( ushort command )
{
  //prn_str ("("); prn_hex16 (command); prn_str (")");
  switch( command & 0x00FF )  {
    case 0x02 : prn_str ("CONNECT_"        );break;
    case 0x09 : prn_str ("CONNECT_INFO_"   );break;
    case 0x03 : prn_str ("CONNECT_ACTIVE_" );break;
    case 0x04 : prn_str ("DISCONNECT_"     );break;
    case 0x05 : prn_str ("LISTEN_"         );break;
    case 0x06 : prn_str ("GET_PARAMS_"     );break;
    case 0x07 : prn_str ("INFO_"           );break;
    case 0x08 : prn_str ("DATA_"           );break;
    case 0x40 : prn_str ("SELECT_B2_PROTOCOL_");break;
    case 0x80 : prn_str ("SELECT_B3_PROTOCOL_");break;
    case 0x81 : prn_str ("LISTEN_B3_"       );break;
    case 0x82 : prn_str ("CONNECT_B3_"      );break;
    case 0x83 : prn_str ("CONNECT_B3_ACTIVE_");break;
    case 0x84 : prn_str ("DISCONNECT_B3_"   );break;
    case 0x85 : prn_str ("GET_B3_PARAMS_"   );break;
    case 0x86 : prn_str ("DATA_B3_"         );break;
    case 0x01 : prn_str ("RESET_B3_"        );break;
    case 0x87 : prn_str ("HANDSET_"         );break;
    case 0xFF : prn_str ("MANUFACTURER_"    );break;
  }
  switch( (command >> 8) & 0x00FF )  {
    case 0x00 : prn_str ("REQ");    break;
    case 0x01 : prn_str ("CONF");   break;
    case 0x02 : prn_str ("IND");    break;
    case 0x03 : prn_str ("RESP");   break;
  }

}

void c11_analyze_msg (char  *msg)
{
   switch (*((ushort *)(msg+4))) {
      case 0x0002 :                                             /* connect_req */
                    msg += 8;
                    prn_ctrl8 (*(msg));             msg += 1;   /* Controller */
                    prn_bchan (*(msg));             msg += 1;   /* B-Channel */
                    prn_infom (*((ulong  *)(msg))); msg += 4;   /* Info-Mask */
                    prn_outgs (*(msg));             msg += 1;   /* Outgoing-Service */
                    prn_outgsa(*(msg));             msg += 1;   /* Outgoing-S. Add */
                    prn_seaz  (*(msg));             msg += 1;   /* Source-EAZ */
                    prn_dadd  (msg);                            /* Destination-Address */
                    break;

      case 0x0102 :                                             /* connect_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg))); msg += 2;    /* Info */
                    break;
      case 0x0202 :                                             /* connect_ind */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_ctrl8 (*(msg));            msg += 1;    /* Controller */
                    prn_reqs  (*(msg));            msg += 1;    /* Requested-Service */
                    prn_reqsa (*(msg));            msg += 1;    /* Requested-Service-Add */
                    prn_reaz  (*(msg));            msg += 1;    /* Requested EAZ */
                    prn_caladd(msg);                            /* Caller-Address */
                    break;
      case 0x0302 :                                             /* connect_resp */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_rejct8(*(msg));                         /* Reject */
                    break;

      case 0x0009 :                                             /* connect_info_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_dadd  (msg);                            /* Destination-Address */
                    break;
      case 0x0109 :                                             /* connect_info_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg))); msg += 2;    /* Info */
                    break;

      case 0x0203 :                                             /* connect_active_ind */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_conadd  (msg);                          /* Connected-Address */
                    break;
      case 0x0303 :                                             /* connect_active_resp */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg)));              /* PLCI */
                    break;

      case 0x0004 :                                             /* disconnect_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_cause (*(msg));                         /* Cause */
                    break;
      case 0x0104 :                                             /* disconnect_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0204 :                                             /* disconnect_ind */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg))); msg += 2;    /* Info */
                    break;
      case 0x0304 :                                             /* disconnect_resp */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    break;

      case 0x0005 :                                             /* listen_req */
                    msg +=8;
                    prn_ctrl8 (*(msg));            msg += 1;    /* Controller */
                    prn_infom (*((ulong *)(msg))); msg += 4;    /* Info-Mask */
                    prn_seeaz (*((ushort*)(msg))); msg += 2;    /* serviced EAZ-Mask */
                    prn_ssimsk(*((ushort*)(msg)));              /* serviced EAZ-Mask */
                    break;
      case 0x0105 :                                             /* listen_conf */
                    msg +=8;
                    prn_ctrl8 (*(msg));            msg += 1;    /* Controller */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;

      case 0x0006 :                                             /* get_params_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg)));              /* PLCI */
                    break;
      case 0x0106 :                                             /* get_params_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_ctrl8 (*(msg));            msg += 1;    /* Controller */
                    prn_bchan (*(msg));            msg += 1;    /* B-Channel */
                    prn_info  (*((ushort*)(msg))); msg += 2;    /* Info */
                    prn_b3lc  (*(msg));            msg += 1;    /* B3-Link-Count */
                    prn_ser   (*(msg));            msg += 1;    /* Service */
                    prn_sera  (*(msg));            msg += 1;    /* Service-Add */
                    prn_sere  (*(msg));            msg += 1;    /* Service-EAZ */
                    prn_conadd  (msg);                          /* Connected-Address */
                    break;

      case 0x0007 :                                             /* info_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_infom (*((ulong *)(msg)));              /* Info-Mask */
                    break;
      case 0x0107 :                                             /* info_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0207 : msg += 8;                                   /* info_ind */
                    prn_plci16 (*((ushort *)(msg))); msg += 2;  /* PLCI */
                    prn_infon (*((ushort *)(msg)));  msg += 2;  /* Info-Number */
                    prn_infoe (msg);                            /* Info-Element */
                    break;
      case 0x0307 :                                             /* info_resp */
                    msg +=8;
                    prn_plci16 (*((ushort *)(msg)));            /* PLCI */
                    break;

      case 0x0008 :                                             /* data_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    break;
      case 0x0108 :                                             /* data_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0208 :                                             /* data_ind */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    break;
      case 0x0308 :                                             /* data_resp */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    break;

      case 0x0040 :                                             /* select_b2_protocol_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_b2prot (*(msg));           msg += 1;    /* B2-Protocol */
                    prn_dlpd   (msg);                           /* DLPD */
                    break;
      case 0x0140 :                                             /* select_b2_protocol_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;

      case 0x0080 :                                             /* select_b3_protocol_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_b3prot (*(msg));           msg += 1;    /* B3-Protocol */
                    prn_ncpd   (msg);                           /* NCPD */
                    break;
      case 0x0180 :                                             /* select_b3_protocol_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;

      case 0x0081 :                                             /* listen_b3_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg)));              /* PLCI */
                    break;
      case 0x0181 :                                             /* listen_b3_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;

      case 0x0082 :                                             /* connect_b3_req */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0182 :                                             /* connect_b3_conf */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0282 :                                             /* connect_b3_ind */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0382 :                                             /* connect_b3_resp */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_rejct8(*(msg));            msg += 1;    /* Reject */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0283 :                                             /* connect_b3_active_ind */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0383 :                                             /* connect_b3_active_resp */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg)));              /* NCCI */
                    break;

      case 0x0084 :                                             /* disconnect_b3_req */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0184 :                                             /* disconnect_b3_conf */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0284 :                                             /* disconnect_b3_ind */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_info  (*((ushort*)(msg))); msg += 2;    /* Info */
                    prn_ncpi (msg);                             /* NCPI */
                    break;
      case 0x0384 :                                             /* disconnect_b3_resp */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg)));              /* NCCI */
                    break;

      case 0x0085 :                                             /* get_b3_params_req */
                    msg += 8;
                    prn_ncci16(*((ushort*)(msg)));              /* NCCI */
                    break;
      case 0x0185 :                                             /* get_b3_params_conf */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;

      case 0x0086 :                                             /* data_b3_req */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                                                   msg += 2;    /* Data-Length */
                    prn_addr32(*((ulong *)(msg))); msg += 4;    /* Data */
                    prn_number(*(msg)) ;           msg += 1;    /* Number */
                    prn_flags(*((ushort*)(msg)));               /* Flags */
                    break;

      case 0x0186 :                                             /* data_b3_conf */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_number(*(msg));            msg += 1;    /* Number */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0286 :                                             /* data_b3_ind */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                                                   msg += 2;    /* Data-Length */
                    prn_addr32(*((ulong *)(msg))); msg += 4;    /* Data */
                    prn_number(*(msg));            msg += 1;    /* Number */
                    prn_flags(*((ushort*)(msg)));               /* Flags */
                    break;
      case 0x0386 :                                             /* data_b3_resp */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_number(*(msg));                         /* Number */
                    break;

      case 0x0001 :                                             /* reset_b3_req */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    break;
      case 0x0101 :                                             /* reset_b3_conf */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg))); msg += 2;    /* NCCI */
                    prn_info  (*((ushort*)(msg)));              /* Info */
                    break;
      case 0x0201 :                                             /* reset_b3_ind */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg)));              /* NCCI */
                    break;
      case 0x0301 :                                             /* reset_b3_resp */
                    msg +=8;
                    prn_ncci16(*((ushort*)(msg)));              /* NCCI */
                    break;

      case 0x0287 :                                             /* handset_ind */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg))); msg += 2;    /* PLCI */
                    break;
      case 0x0387 :                                             /* handset_resp */
                    msg +=8;
                    prn_plci16(*((ushort*)(msg)));              /* PLCI */
                    break;

      case 0x00ff :                                             /* manufactuer_req */
                    msg +=8;
                    break;
      case 0x01ff :                                             /* manufactuer_conf */
                    msg +=8;
                    break;
      case 0x02ff :                                             /* manufacturer_ind */
                    msg +=8;
                    break;
      case 0x03ff :                                             /* manufactuer_resp */
                    msg +=8;
                    break;
   }
}


void   c11_analyze_register( char  *pApplBuf,
                                      ushort uwMessageBufferSize,
                                      ushort uwMaxLogicalConnection,
                                      ushort uwMaxBDataBlocks,
                                      ushort uwMaxBDataLen,
                                      ushort result)
{
   analyze_register( pApplBuf,uwMessageBufferSize,uwMaxLogicalConnection,uwMaxBDataBlocks,uwMaxBDataLen,result,1);
}

void   c11_analyze_put_msg (char  *msg, ushort result)
{
#ifdef kurz_msg
  ushort num;

  num = *((ushort *)(msg+4));
  if (num != 0x00ff) {
    prn_str ("Put ");
    prn_hex16 (*((ushort *)(msg+4)));
    prn_str ("\n");
  }
#else
  prn_sys_time();
  prn_str ("  API PUT MESSAGE\n");
  prn_msg_body(msg,1,result);
  c11_analyze_msg(msg);
  prn_end_str ();
#endif
}

void   c11_analyze_get_msg (char  *msg, ushort result)
{
#ifdef kurz_msg
  ushort num;

  num = *((ushort *)(msg+4));
  if (num  != 0x01ff) {
    prn_str ("Get ");
    prn_hex16 (*((ushort *)(msg+4)));
    prn_str ("\n");
}
#else
  prn_sys_time();
  prn_str ("  API GET MESSAGE\n");
  prn_msg_body(msg,1,result);
  c11_analyze_msg(msg);
  prn_end_str ();
#endif
}


/* ------------------------------------------------------------------- */
/* capi 2.0 funktionen                                                 */
/* ------------------------------------------------------------------- */

void prn_msgn20 (ushort command)
{
   switch (command) {
      case 0x8001 : prn_str ("ALERT_REQ"   );break;
      case 0x8101 : prn_str ("ALERT_CONF"  );break;

      case 0x8002 : prn_str ("CONNECT_REQ" );break;
      case 0x8102 : prn_str ("CONNECT_CONF");break;
      case 0x8202 : prn_str ("CONNECT_IND" );break;
      case 0x8302 : prn_str ("CONNECT_RESP");break;

      case 0x8203 : prn_str ("CONNECT_ACTIVE_IND");break;
      case 0x8303 : prn_str ("CONNECT_ACTIVE_RESP");break;
      case 0x8283 : prn_str ("CONNECT_B3_ACTIVE_IND"); break;
      case 0x8383 : prn_str ("CONNECT_B3_ACTIVE_RESP"); break;
      case 0x8082 : prn_str ("CONNECT_B3_REQ"); break;
      case 0x8182 : prn_str ("CONNECT_B3_CONF"); break;
      case 0x8282 : prn_str ("CONNECT_B3_IND"); break;
      case 0x8382 : prn_str ("CONNECT_B3_RESP"); break;
      case 0x8288 : prn_str ("CONNECT_B3_T90_ACTIVE_IND"); break;
      case 0x8388 : prn_str ("CONNECT_B3_T90_ACTIVE_RESP"); break;

      case 0x8086 : prn_str ("DATA_B3_REQ" );break;
      case 0x8186 : prn_str ("DATA_B3_CONF");break;
      case 0x8286 : prn_str ("DATA_B3_IND" );break;
      case 0x8386 : prn_str ("DATA_B3_RESP");break;

      case 0x8084 : prn_str ("DISCONNECT_B3_REQ" ); break;
      case 0x8184 : prn_str ("DISCONNECT_B3_CONF" ); break;
      case 0x8284 : prn_str ("DISCONNECT_B3_IND" ); break;
      case 0x8384 : prn_str ("DISCONNECT_B3_RESP"); break;
      case 0x8004 : prn_str ("DISCONNECT_REQ"); break;
      case 0x8104 : prn_str ("DISCONNECT_CONF"); break;
      case 0x8204 : prn_str ("DISCONNECT_IND"); break;
      case 0x8304 : prn_str ("DISCONNECT_RESP"); break;

      case 0x8080 : prn_str ("FACILITY_REQ"); break;
      case 0x8180 : prn_str ("FACILITY_CONF"); break;
      case 0x8280 : prn_str ("FACILITY_IND"); break;
      case 0x8380 : prn_str ("FACILITY_RESP"); break;

      case 0x8008 : prn_str ("INFO_REQ"); break;
      case 0x8108 : prn_str ("INFO_CONF"); break;
      case 0x8208 : prn_str ("INFO_IND"); break;
      case 0x8308 : prn_str ("INFO_RESP"); break;

      case 0x8005 : prn_str ("LISTEN_REQ"); break;
      case 0x8105 : prn_str ("LISTEN_CONF"); break;

      case 0x80ff : prn_str ("MANUFACTURER_REQ"); break;
      case 0x81ff : prn_str ("MANUFACTURER_CONF"); break;
      case 0x82ff : prn_str ("MANUFACTURER_IND"); break;
      case 0x83ff : prn_str ("MANUFACTURER_RESP"); break;

      case 0x8087 : prn_str ("RESET_B3_REQ"); break;
      case 0x8187 : prn_str ("RESET_B3_CONF"); break;
      case 0x8287 : prn_str ("RESET_B3_IND"); break;
      case 0x8387 : prn_str ("RESET_B3_RESP"); break;

      case 0x8041 : prn_str ("SELECT_B_PROTOCOL_REQ"); break;
      case 0x8141 : prn_str ("SELECT_B_PROTOCOL_CONF"); break;

      default     : prn_str ("UNKNOWN MESSAGE: "); prn_hex16 (command); break;
   }
}

void c20_analyze_msg (char  *msg)
{
   switch (*((ushort *)(msg+4))) {
      case 0x8001 : msg += 8;                                /* alert_req */
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_addi  (msg);
                    break;

      case 0x8101 : msg += 8;                                /* alert_conf */
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_info  (*((ushort *)(msg)));
                    break;

      case 0x8002 : msg += 8;                                /* connect_req */
                    prn_ctrl32(*((ulong *)(msg))); msg += 4;
                    prn_cipv  (*((ushort*)(msg))); msg += 2;
                    prn_cdpn  (msg); msg += *msg + 1;
                    prn_cipn  (msg); msg += *msg + 1;
                    prn_cdpsa (msg); msg += *msg + 1;
                    prn_cipsa (msg); msg += *msg + 1;
                    prn_bprot (msg); msg += *msg + 1;
                    prn_bc    (msg); msg += *msg + 1;
                    prn_llc   (msg); msg += *msg + 1;
                    prn_hlc   (msg); msg += *msg + 1;
                    prn_addi  (msg);
                    break;

      case 0x8102 : prn_plci32(*((ulong  *)(msg+8 )));       /* connect_conf */
                    prn_info  (*((ushort *)(msg+12)));
                    break;

      case 0x8202 : msg += 8;                                /* connect_ind */
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_cipv  (*((ushort*)(msg))) ; msg += 2;
                    prn_cdpn  (msg); msg += *msg + 1;
                    prn_cipn  (msg); msg += *msg + 1;
                    prn_cdpsa (msg); msg += *msg + 1;
                    prn_cipsa (msg); msg += *msg + 1;
                    prn_bc    (msg); msg += *msg + 1;
                    prn_llc   (msg); msg += *msg + 1;
                    prn_hlc   (msg); msg += *msg + 1;
                    prn_addi  (msg);
                    break;

      case 0x8302 : msg += 8;
                    prn_plci32 (*((ulong  *)(msg))); msg += 4;
                    prn_rejct16(*((ushort *)(msg))); msg += 2;
                    prn_bprot (msg); msg += *msg + 1;
                    prn_cn    (msg); msg += *msg + 1;
                    prn_cs    (msg); msg += *msg + 1;
                    prn_llc   (msg); msg += *msg + 1;
                    prn_addi  (msg);
                    break;

      case 0x8203 : msg += 8;
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_cn    (msg); msg += *msg + 1;
                    prn_cs    (msg); msg += *msg + 1;
                    prn_llc   (msg); msg += *msg + 1;
                    break;

      case 0x8303 : prn_plci32(*((ulong  *)(msg+8 )));       /* conect_act_resp */
                    break;

      case 0x8283 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8383 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    break;

      case 0x8082 : prn_plci32(*((ulong  *)(msg+8 )));
                    prn_ncpi (msg+12);
                    break;

      case 0x8182 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_info  (*((ushort *)(msg+12)));
                    break;

      case 0x8282 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8382 : prn_ncci32 (*((ulong  *)(msg+ 8)));
                    prn_rejct16(*((ushort *)(msg+12)));
                    prn_ncpi (msg+14);
                    break;

      case 0x8288 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8388 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    break;

      case 0x8286 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_ind */
                    prn_addr32(*((ulong  *)(msg+12)));
                    prn_lendta(*((ushort *)(msg+16)));
                    prn_handta(*((ushort *)(msg+18)));
                    prn_flags (*((ushort *)(msg+20)));
                    break;

      case 0x8086 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_req */
                    prn_addr32(*((ulong  *)(msg+12)));
                    prn_lendta(*((ushort *)(msg+16)));
                    prn_handta(*((ushort *)(msg+18)));
                    prn_flags (*((ushort *)(msg+20)));
                    break;

      case 0x8186 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_conf */
                    prn_handta(*((ushort *)(msg+12)));
                    prn_info  (*((ushort *)(msg+14)));
                    break;

      case 0x8386 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_resp */
                    prn_handta(*((ushort *)(msg+12)));
                    break;

      case 0x8084 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8184 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_conf */
                    prn_info  (*((ushort *)(msg+14)));
                    break;

      case 0x8284 : prn_ncci32(*((ulong  *)(msg+8)));       /* disconnect_b3_ind */
                    prn_reasb3(*((ushort *)(msg+12)));
                    prn_ncpi (msg+14);
                    break;

      case 0x8384 : prn_ncci32(*((ulong  *)(msg+ 8)));      /* data_b3_conf */
                    break;

      case 0x8004 : prn_plci32(*((ulong  *)(msg+8)));        /* disconnect_req */
                    prn_addi  (msg+12);
                    break;

      case 0x8104 : prn_plci32(*((ulong  *)(msg+8)));       /* disconnect_ind */
                    prn_info(*((ushort *)(msg+12)));
                    break;

      case 0x8204 : prn_plci32(*((ulong  *)(msg+8)));       /* disconnect_ind */
                    prn_reason(*((ushort *)(msg+12)));
                    break;

      case 0x8304 : prn_plci32(*((ulong  *)(msg+8)));       /* disconnect_ind */
                    break;

      case 0x8080 : msg += 8;
                    prn_cpn (*((ulong  *)(msg))); msg += 4;
                    prn_fs  (*((ushort *)(msg))); msg += 2;
                    prn_frp (msg);
                    break;

      case 0x8180 : msg += 8;
                    prn_cpn (*((ulong  *)(msg))); msg += 4;
                    prn_info(*((ushort *)(msg))); msg += 2;
                    prn_fs  (*((ushort *)(msg))); msg += 2;
                    prn_fcp (msg);
                    break;

      case 0x8280 : msg += 8;
                    prn_cpn (*((ulong  *)(msg))); msg += 4;
                    prn_fs  (*((ushort *)(msg))); msg += 2;
                    prn_fip (msg);
                    break;

      case 0x8380 : msg += 8;
                    prn_cpn (*((ulong  *)(msg))); msg += 4;
                    prn_fs  (*((ushort *)(msg))); msg += 2;
                    prn_fpp (msg);
                    break;

      case 0x8008 : msg += 8;
                    prn_cp   (*((ulong *)(msg))); msg += 4;
                    prn_cdpn  (msg); msg += *msg + 1;
                    prn_addi (msg);
                    break;

      case 0x8108 : msg += 8;
                    prn_plci32 (*((ulong  *)(msg))); msg += 4;
                    prn_info   (*((ushort *)(msg)));
                    break;

      case 0x8208 : msg += 8;
                    prn_cp    (*((ulong *)(msg))); msg += 4;
                    prn_infon (*((ushort *)(msg))); msg += 2;
                    prn_infoe (msg);
                    break;

      case 0x8308 : msg += 8;
                    prn_cp    (*((ulong *)(msg)));
                    break;

      case 0x8005 : prn_ctrl32(*((ulong *)(msg+8)));        /* listen_req */
                    prn_infom (*((ulong *)(msg+12)));
                    prn_cipm  (*((ulong *)(msg+16)));
                    prn_cipm2 (*((ulong *)(msg+20)));
                    prn_cipn  (msg+24);
                    prn_cipsa (msg+24+1+(*((char  *)(msg+24))));
                    break;
      case 0x8105 : prn_ctrl32(*((ulong  *)(msg+8)));        /* listen_conf */
                    prn_info (*((ushort *)(msg+12)));
                    break;

      case 0x80ff : msg += 8;
                    prn_ctrl32(*((ulong *)(msg))); msg += 4;
                    prn_manuid(*((ulong *)(msg)));
                    break;

      case 0x81ff : msg += 8;
                    prn_ctrl32(*((ulong *)(msg))); msg += 4;
                    prn_manuid(*((ulong *)(msg)));
                    break;

      case 0x82ff : msg += 8;
                    prn_ctrl32(*((ulong *)(msg))); msg += 4;
                    prn_manuid(*((ulong *)(msg)));
                    break;

      case 0x83ff : msg += 8;
                    prn_ctrl32(*((ulong *)(msg))); msg += 4;
                    prn_manuid(*((ulong *)(msg)));
                    break;

      case 0x8087 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8187 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_info  (*((ushort *)(msg+14)));
                    break;

      case 0x8287 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    prn_ncpi (msg+12);
                    break;

      case 0x8387 : prn_ncci32(*((ulong  *)(msg+ 8)));
                    break;

      case 0x8041 : msg += 8;
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_bprot (msg); msg += *msg + 1;
                    break;

      case 0x8141 : msg += 8;
                    prn_plci32(*((ulong  *)(msg))); msg += 4;
                    prn_info  (*((ushort *)(msg)));
                    break;
   }
}

void   c20_analyze_put_msg (char  *msg, ushort result)
{
#ifdef kurz_msg
  ushort num;

  num = *((ushort *)(msg+4));
  if (num != 0x00ff) {
    prn_str ("Put ");
    prn_hex16 (*((ushort *)(msg+4)));
    prn_str ("\n");
  }
#else
  prn_sys_time();
  prn_str ("  API PUT MESSAGE\n");
  prn_msg_body(msg,2,result);
  c20_analyze_msg(msg);
  prn_end_str ();
#endif
}

void   c20_analyze_get_msg (char  *msg, ushort result)
{
#ifdef kurz_msg
  ushort num;

  num = *((ushort *)(msg+4));
  if (num != 0x00ff) {
    prn_str ("Get ");
    prn_hex16 (*((ushort *)(msg+4)));
    prn_str ("\n");
  }
#else
  prn_sys_time();
  prn_str ("  API GET MESSAGE\n");
  prn_msg_body(msg,2,result);
  c20_analyze_msg(msg);
  prn_end_str ();
#endif
}

void   c20_analyze_get_profile (char  *buffer, ulong ctrl, ushort result)
{
  prn_sys_time();
  prn_str ("  API GET PROFILE\n");
  prn_ctrl32(ctrl);
  prn_str ("| Adresse Buffer...........: ");prn_hex32 ((ulong)buffer);prn_crlf();
  prn_res (result);
  prn_end_str ();
}

void   c20_analyze_register( char  *pApplBuf,
                                      ushort uwMessageBufferSize,
                                      ushort uwMaxLogicalConnection,
                                      ushort uwMaxBDataBlocks,
                                      ushort uwMaxBDataLen,
                                      ushort result)
{
   analyze_register( pApplBuf,uwMessageBufferSize,uwMaxLogicalConnection,uwMaxBDataBlocks,uwMaxBDataLen,result,2);
}

void   c20_analyze_set_signal (ulong applid,char  *callback,ushort result)
{
  prn_sys_time();
  prn_str ("  API SET SIGNAL\n");
  prn_aid (applid);
  prn_res (result);
  prn_str ("| Adresse Signal-Funktion..: ");prn_hex32 ((ulong)callback);prn_crlf ();
  prn_end_str ();
}

void   c20_analyze_release (ulong applid, ushort result)
{
  prn_sys_time();
  prn_str ("  API RELEASE\n");
  prn_aid (applid);
  prn_res (result);
  prn_end_str ();
}

void   c20_analyze_get_version (void)
{
  prn_sys_time();
  prn_str ("  API GET VERSION\n");
  prn_end_str ();
}

void   c20_analyze_finit (ushort result)
{
  prn_sys_time();
  prn_str ("  API FINAL INIT\n");
  prn_res (result);
  prn_end_str ();
}

void   c20_analyze_get_manufacturer (void)
{
  prn_sys_time();
  prn_str ("  API GET MANUFACTURER\n");
  prn_end_str ();
}

void   c20_analyze_get_serial_number (void)
{
  prn_sys_time();
  prn_str ("  API GET SERIAL NUMBER\n");
  prn_end_str ();
}

/* ------------------------------------------------------------------- */
/* output-devices                                                      */
/* ------------------------------------------------------------------- */

void   out_blk_std(char  *data, unsigned short length)
{
//  int i;
//  for(i=0;i<length;i++) printf("%c", data[i] );
//  printf ("\n\rfile=%d\n\r",log_file2);
//for(i=0;i<length;i++) printf("%c", data[i] );
  if (log_file2) fwrite (data,length,1,log_file2);
}


