#include <stdio.h>

#ifndef UNIX
#include <conio.h>
#endif

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>

#include "bastypes.h"
#include "util.h"
#include "num2nam.h"
#include "os.h"

char value[230];
HMTX hmtxsemcfg;
char is_init = 0;

void          config_file_init         (void)
{
  OSCreateMutexSem("\\sem32\\ctsemcfg",&hmtxsemcfg ,0,FALSE);
  is_init = 1;
}

void          config_file_exit         (void)
{
  OSCloseMutexSem(&hmtxsemcfg);
}

short token_in_file(char *filename, char *token)
{
  FILE *in_file;
  char str[200];

  in_file = fopen (filename,"r");

  if (in_file) {
    while (fgets(str,200,in_file)) {
      util_delete_cr(str);
      if (strchr(str,'=')) {
        *strchr(str,'=') = 0;
        if (strcmpi(str,token) == 0) {
          fclose (in_file);
          return (1);
        }
      }
    }
    fclose (in_file);
  }
  return (0);
}

void    config_file_write_string_pre   (char *filename, char *token, char *string)
{
  FILE *cfg_write;
  FILE *cfg_read;
  char help_str1[200];
  char help_str2[200];

  if (!util_file_exist(filename)) {
    cfg_write = fopen (filename,"w");
    if (cfg_write )fclose (cfg_write);
  }

  if (token_in_file(filename,token)) {
    cfg_read  = fopen (filename,"r");
    cfg_write = fopen ("TEMP"  ,"w");

    if (cfg_read && cfg_write) {
      while (fgets(help_str1,200,cfg_read)) {
        strcpy (help_str2,help_str1);
        if (strchr(help_str2,'=')) {
          *strchr(help_str2,'=') = 0;
          if (strcmpi(help_str2,token) == 0) {
            strcpy (help_str2,token);
            strcat (help_str2,"=");
            strcat (help_str2,string);
            strcat (help_str2,"\n");
            fputs  (help_str2,cfg_write);
          } else {
            fputs (help_str1,cfg_write);
          }
        } else {
          fputs (help_str1,cfg_write);
        }
      }
      fclose (cfg_read);
      fclose (cfg_write);
      remove (filename);
      rename ("TEMP",filename);
    }
  } else {
    cfg_write = fopen (filename,"a");
    if (cfg_write) {
      strcpy (help_str1,token);
      strcat (help_str1,"=");
      strcat (help_str1,string);
      strcat (help_str1,"\n");
      fputs  (help_str1,cfg_write);
      fclose (cfg_write);
    }
  }
}


void config_file_read_string_pre  (char *filename, char *token, char *result, char *tok_default)
{
  FILE *cfg_file;
  char str[230];

  if (!util_file_exist(filename)) {
    cfg_file = fopen (filename,"w");
    if (cfg_file )fclose (cfg_file);
  }

  cfg_file = fopen (filename,"r");

  if (cfg_file) {
    while (fgets(str,200,cfg_file)) {
      util_delete_cr(str);
      if ((strlen(str)>7) && (strchr(str,'#') == NULL) && (strchr(str,'='))) {
        strcpy (value, strchr(str,'=')+1);
        *strchr(str,'=') = 0;
        if (strcmpi(str,token) == 0) {
          fclose (cfg_file);
          strcpy (result,check_time(value));
          return;
        }
      }
    }
    fclose (cfg_file);
    config_file_write_string_pre (filename, token, tok_default);
  }
  strcpy (result,tok_default);
  return;
}

unsigned long config_file_read_ulong   (char *filename, char *token, unsigned long tok_default)
{
  char help[100];
  char def_help[100];

  if (!is_init) config_file_init();

  OSRequestMutexSem(&hmtxsemcfg,-1);
    ltoa (tok_default, def_help, 10);
    config_file_read_string_pre(filename,token,help, def_help);
  OSReleaseMutexSem(&hmtxsemcfg);
  return(atol(help));
}

void    config_file_write_ulong (char *filename, char *token, unsigned long value)
{
  char help_str[200];

  if (!is_init) config_file_init();

  OSRequestMutexSem(&hmtxsemcfg,-1);
    ltoa (value, help_str, 10);
    config_file_write_string_pre (filename,token,help_str);
  OSReleaseMutexSem(&hmtxsemcfg);
}

void config_file_read_string  (char *filename, char *token, char *result, char *tok_default)
{
  if (!is_init) config_file_init();

  OSRequestMutexSem(&hmtxsemcfg,-1);
    config_file_read_string_pre (filename, token, result, tok_default);
  OSReleaseMutexSem(&hmtxsemcfg);
}

void config_file_write_string (char *filename, char *token, char *string)
{
  if (!is_init) config_file_init();

  OSRequestMutexSem(&hmtxsemcfg,-1);
    config_file_write_string_pre (filename, token, string);
  OSReleaseMutexSem(&hmtxsemcfg);
}

