/* Script to Answer On Voice Calls */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com2"
init="AT&F1H0E1V1"
hang="ATZ"
offhook="ATH1"
command_delay=0.5    /* delay between AT commands (sec) */
silence='ATMO'

/* [Voice] */
RingCount=5
VoiceInit="ATE0J2#CLS=8"
speaker="AT#VLS=3"
record="AT#VRX"
playback="AT#VTX"
beep_1="AT#VTS=[933,0,12]"
dle=x2c(10)
dle_etx=x2c(10)x2c(3)
cancel=x2c(10)x2c(18)
VoiceDir=".\VOICE"
GreetDir=".\GREET"

/* [DTMFs] */


/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
remaining=''
end_rec=1
aonname=1
debug_=0
mainlog=0
lend=x2c(a5)
num=0
crlf=d2c(13)d2c(10)


/* ------------- Entry Point -------------- */

Call SysCls

rc=crlf "       Automatic AVC56 AutoAnswer v 1.00 (c) By Alek Winner." crlf
say rc
if mainlog then call charout rclog,rc


call comport_check

parse arg voicename
if voicename \='' then signal init_1
rc=" "date()"  " time() "  Filename required ..." crlf
say rc
exit

init_1:

rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


/* ------------ AutoAnswer Part ------------------ */

call voice_init

call beep_to_line

go_rec:

rc = RxAsyncWrite( PortHandle, 0, record||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "record", "CONNECT", "  Error switching to RECORD mode... Exitting... ;("


rc=" "date()"  " time() "  Recording..." crlf
say rc
if mainlog then call charout rclog,rc


busy=0


rc=" "date()"  " time() " " voicename crlf
say rc
if mainlog then call charout rclog,rc



do until c2x(rc) = ''

frame=''

do while c2x(right(frame,2)) <> 'A5A5'

fram=frame

db = RxAsyncRead( PortHandle, 0, 2000, 'frame',,lend )
if db <> 0 then
  do

  if voicename='busy.fil' then
   do
   voicename=oldvoice
   call stream "busy.fil",'c','close'
   call SysFileDelete("busy.fil")
   end

  call stream voicename,'c','close'
  signal done

  end

frame=fram||frame
end

 n=length(frame)
 i=1

 do while i <= n

 rc=SUBSTR(frame,i,1)
 i=i+1

 if c2x(rc)=10 then
 do
 rc=SUBSTR(frame,i,1)
 i=i+1

 say c2x(rc)

   select

   when c2x(rc)=10 then NOP

   when rc='b' then
     do
     rc=SUBSTR(frame,i,1)
     i=i+1
     SAY "BUSYYYYYYYYYYYYYYYYYY !!!!!!!"
     signal bussy
     end

   when rc='d' then
     do
     rc=SUBSTR(frame,i,1)
     i=i+1

     tm=time(R)
     say tm
     if tm>13 | busy=0 then
      do
      busy=0
      tm=02
      if voicename="busy.fil" then
       do
        bsy="BSY"
        do until bsy=""
        bsy=charin("busy.fil",,1)
        call charout oldvoice,bsy
       end
      voicename=oldvoice
      bsy="BSY=" bsy crlf
      say bsy
      if debug_ then call charout debug,bsy
      call stream "busy.fil",'c','close'
      call SysFileDelete("busy.fil")
      end
      else
       do
       oldvoice=voicename
       voicename="busy.fil"
       end
  end

     if busy<3 & tm<13 then busy=busy+1
     say busy "BUSY VALUE"
     if busy=3 then
       do
       call stream "busy.fil",'c','close'
       call SysFileDelete("busy.fil")

       bussy:
       xx=" "date()"  " time() "  㦥 ᨣ  ..." crlf
       say xx
       if mainlog then call charout rclog,xx

       call RxAsyncTxImmediate PortHandle, c2x(dle)
       end_rec="d_tone"

       end
     end

   when rc='1' then
     do
     hallo=greetdir"\kora.gsm"
     call RxAsyncTxImmediate PortHandle, c2x(dle)
     db="pressed" rc crlf
     if debug_ then call charout debug,db
     end_rec="tone1"
     rc=" "date()"  " time() " " "Pressed 1" crlf
     say rc
     if mainlog then call charout rclog,rc
  
     rc=SUBSTR(frame,i,1)
     i=i+1
     end

   when rc='2' | rc='3' | rc='4' | rc='5' | rc='6' | rc='7' | rc='8' | rc='0' | rc='*' | rc='#' then
     do
     rc=" "date()"  " time() " " "Pressed "rc crlf
     say rc
     if mainlog then call charout rclog,rc
  
     rc=SUBSTR(frame,i,1)
     i=i+1
     end

   when rc='9' then
     do
     call RxAsyncTxImmediate PortHandle, c2x(dle)
     db="pressed" rc crlf
     if debug_ then call charout debug,db
     end_rec="tone9"
     rc=" "date()"  " time() " " "Pressed 9" crlf
     say rc
     if mainlog then call charout rclog,rc

     rc=SUBSTR(frame,i,1)
     i=i+1
     end

   otherwise
   call beep 262,250
   rc=" "date()"  " time() " " "ERROR Pressed "rc crlf
   say rc
   if mainlog then call charout rclog,rc

   rc=SUBSTR(frame,i,1)
   i=i+1
   end
 end

call charout voicename,rc
if chars()=1 then
do
rc=SysGetKey(noecho)
call RxAsyncTxImmediate PortHandle, c2x(dle)
end_rec="kb_key"
end
end
end

done:

select

when end_rec="tone1" then
 do
 call voice_init
 call play_file
 end

when end_rec="tone9" then
 do
 call play_new
 end

when end_rec="d_tone" then NOP

when end_rec="kb_key" then NOP

otherwise
end

call close_all

rc=" "date()"  " time() chars(voicename) / 38 * 0.02 "sec" crlf
say rc


signal term


/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

rc = RxAsyncSetLnCtrl( PortHandle, 57600, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,'',50,'00001001','10000000','','','','','' )
return

err0:
rc=crlf " "date()"  " time() "  Comport is not respond... ;(" crlf crlf
say rc
if mainlog then call charout rclog,rc
call beep 262,250
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug_ then call charout debug,db
end

if InpStr = ok_str||crlf then return

err1:
rc=crlf " "date()"  " time() err_str "rc="rc "InpStr="InpStr crlf crlf
say rc
if mainlog then call charout rclog,rc
call beep 262,250
signal halt
/* -- Check Modem String - Ends -- */



/* ----- Close All Files -------*/
close_all:
call stream hallo,'c','close'
call stream voicename,'c','close'
call stream numlog,'c','close'
call stream rclog,'c','close'
call stream debug,'c','close'
return
/* -----------------------------*/

/* ------------ Voice Initialization ------------------------- */

voice_init:

rc = RxAsyncWrite( PortHandle, 0, VoiceInit||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "VoiceInit", "OK", "Error entering to Voice mode... Exitting... ;("


rc = RxAsyncWrite( PortHandle, 0, speaker||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Speaker", "VCON", "  Error setting audio device... ;("
return

/* ---------------  Voice Init Endp  -------------------------*/


/* ---- Reading Tail of Stream from Port ---- */

cancel_stream:

rc=" "date()"  " time() "  Done..." crlf
say rc
if mainlog then call charout rclog,rc

do until rc='VCON'||crlf
db = RxAsyncRead( PortHandle, 0, 0, 'rc' )
db="process end" rc crlf
if debug_ then call charout debug,db
end

return

/* -------------- End Proc ----------------- */


/* ---------------  Beep To Line  --------------------------*/
beep_to_line:

rc = RxAsyncWrite( PortHandle, 0, beep_1||crlf, 'Remaining' )
if rc <> 0 then signal err1
call check_string "Beep_1", "OK", ""

return
/* ---------------  Beep To Line Ends ----------------------*/

fals_key:
key=c2d(SysGetKey())

sel_key:
select
when key=27 | key=32 then
do
rc=" "date()"  " time() "  ESC pressed, Aborting... ;)" crlf
say rc
if mainlog then call charout rclog,rc

call ring_break

rc=crlf
num=num+length(rc)
call charout numlog,rc
call stream numlog,'c','close'

signal patrol
end

when key=13 then
do
call ring_break
signal ring_end
end

when key=110 | key=78 then    /* (N) */
do
call play_new
signal space
end

otherwise
return
end
halt:
say " 㡨..."
term:

rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("

call close_all
call RxAsyncClose PortHandle

/*
do until rc=-1
rc = RxAsyncRead( PortHandle, 0, 0, 'InpStr' )
db="Echo" InpStr crlf
if debug_ then call charout debug,db
end
*/

prog_quit: