/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *                                                                  *
 *    Please See COPYLEFT notice.                                   *
 *                                                                  *
 ********************************************************************/
# include	"crisp.h"

list option_list = {
	"Options",
	"Auto indent",		"autoindent",			
	"Documents",		"wp_options",
	"Searching", 		"search_options",
 	"Status Line",		"echo_line_options",
	"Tabs",			"tab_options",
	};
list s_list = {
	"Line prompt           : ", { "On", "Off"},
	"Col prompt            : ", { "On", "Off"},
	"Percent thru file     : ", { "On", "Off"},
	"Time                  : ", { "On", "Off"}
	};
list	s_list1 = {
		"Fill with    : ", {"SPACES", "TABS"}
		};

void
options()
{
	select_feature(option_list, 20);
}
void
echo_line_options()
{
	list	r_list;
	int	options, new_options;

	options = echo_line(); 
		
	r_list[0] = (options & 0x01) == 0;
	r_list[1] = (options & 0x02) == 0;
	r_list[2] = (options & 0x04) == 0;
	r_list[3] = (options & 0x08) == 0;
	r_list = field_list("Echo-Line Options", r_list, s_list);
	new_options = 0;
	 
	if (!r_list[0]) 
		new_options += 0x01;
	if (!r_list[1])
		new_options += 0x02;
	if (!r_list[2])
		new_options += 0x04;
	if (!r_list[3])
		new_options += 0x08;
	if (new_options != options)
		echo_line(new_options);
}
void
tab_options()
{
	list	r_list;
	int	fill;

	fill = use_tab_char(0);
	r_list[0] = !fill;
	r_list = field_list("Tab Options", r_list, s_list1); 
	if (r_list[0] == 0)
		use_tab_char("n");
	else
		use_tab_char("y");
}
