/**********************************************************************/
/*   Support  for  kermit terminal emulation mode. This has not been  */
/*   tested or verified.					      */
/**********************************************************************/
# include	"tty.h"

# define DELETE	127

void
main()
{
	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	  */
		NULL,		/* Sequence to print characters with top  */
		     		/* bit set.				  */
		NULL,		/* Insert-mode cursor.			  */
		NULL,		/* Overwrite-mode cursor.		  */
		NULL,		/* Insert-mode cursor (on virtual space). */
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,		/* Escape sequence to repeat last character.*/
		FALSE,		/* ESC [0m resets color.		    */
		FALSE,		/* Terminal supports color.		    */
		"\x1B[%dC",	/* Sequence to move cursor on same line   */
		TRUE,   	/* ESC[K gives us a black erased line.		*/
		FALSE,		/* Allow scrolling (ins/del)		  */
		"\x1B(0",	/* Enter graphics mode.			  */
		"\x1B(B"	/* Exit graphics mode.			  */
		);

	/***********************************************/
	/*   Define  keyboard  layout  for  non-ascii  */
	/*   characters.			       */
	/***********************************************/
	set_term_keyboard(
		F1_F12, quote_list(
			"\x1BOP", "\x1BOQ", "\x1BOR", "\x1BOS", "\x1BOT",
			"\x1BOU", "\x1BOV", "\x1BOW", "\x1BOX", "\x1BOY",
			"\x1BOZ", "\x1BO[" ),

		SHIFT_F1_F12, quote_list(
			"\x1BOp", "\x1BOq", "\x1BOr", "\x1BOs", "\x1BOt",
			"\x1BOu", "\x1BOv", "\x1BOw", "\x1BOx", "\x1BOy",
			"\x1BOz", "\x1BO{" ),
		ALT_F1_F12, quote_list(
			"\x1BNP", "\x1BNQ", "\x1BNR", "\x1BNS", "\x1BNT",
			"\x1BNU", "\x1BNV", "\x1BNW", "\x1BNX", "\x1BNY",
			"\x1BNZ", "\x1BN[" ),

		CTRL_F1_F12, quote_list(
			"\x1BNp", "\x1BNq", "\x1BNr", "\x1BNs", "\x1BNt",
			"\x1BNu", "\x1BNv", "\x1BNw", "\x1BNx", "\x1BNy",
			"\x1BNz", "\x1BN{" ),
		ALT_A_Z, quote_list(
			"\x1Ba", "\x1Bb", "\x1Bc", "\x1Bd", "\x1Be",
			"\x1Bf", "\x1Bg", "\x1Bh", "\x1Bi", "\x1Bj",
			"\x1Bk", "\x1Bl", "\x1Bm", "\x1Bn", "\x1Bo",
			"\x1Bp", "\x1Bq", "\x1Br", "\x1Bs", "\x1Bt",
			"\x1Bu", "\x1Bv", "\x1Bw", "\x1Bx", "\x1By",
			"\x1Bz"),
		KEYPAD_0_9, quote_list(
			"\x1B[@", "\x05", "\x1BOB", "\x16", "\x1BOD",
			"\x1B[G", "\x1BOC", "\x01", "\x1BOA", "\x1BV"),
		CTRL_KEYPAD_0_9, quote_list(
			"\x1B?0", "\x1B\x05", "\x1B?2", "\x1B>", "\x1BB",
			"\x1B?5", "\x1BF", "\x1B\x01", "\x1B?8", "\x1B<"),
		ALT_0_9, quote_list(
			"\x1B0", "\x1B1", "\x1B2", "\x1B3", "\x1B4",
			"\x1B5", "\x1B6", "\x1B7", "\x1B8", "\x1B9"),
		SHIFT_KEYPAD_0, quote_list(
			NULL, "\x1B[y", "\x1B[b", NULL, "\x1B[d",
			NULL, "\x1B[c", "\x1B[h", "\x1B[a"),
		CUT,		"\x1B[S",
		COPY,		"\x1B[T",
		BACK_TAB, "\x1B[Z"
		);
}
