/**********************************************************************/
/*   								      */
/*      CRISP - Custom Reduced Instruction Set Programmers Editor     */
/*   								      */
/*      (C) Paul Fox, 1989                                            */
/*   								      */
/*   Please See COPYRIGHT notice.				      */
/*   								      */
/*   								      */
/*   Terminal  description  file  for  SCO  Unix  386 Console Colour  */
/*   display.							      */
/*   								      */
/*   This  file,  along  with  the associated keys and strings files  */
/*   provide support for almost all common crisp keys.		      */
/*   								      */
/*   Note  that  the  keypad  /  and enter keys only function if the  */
/*   keyboard  is  in  AT mode  (SCO  command: kbmode at). All other  */
/*   keys will produce identical scan codes in either mode.	      */
/*   								      */
/*   The  Crisp  Keys Keypad Equal, Pause, Scroll and Numlock, along  */
/*   with  their  ctrl/shift/alt  derivatives  are  not supported as  */
/*   either  the  keys  do  not  exist on PC compatible keyboards or  */
/*   they perform other functions.				      */
/*   								      */
/*   The PrtScr key is also presently unsupported. This key should    */
/*   work but I can't work out how to get it going. Ctrl/shift/alt    */
/*   PrtScr are not supported in any case.			      */
/*   								      */
/*   			     Any comments/fixes:		      */
/*   					traub@rtf.bt.co.uk            */
/*   								      */
/**********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		213,		/* Top left of window.			    */
		184,		/* Top right of window.			    */
		212,		/* Bottom left of window.		    */
		190,		/* Bottom right of window.		    */
		179,		/* Vertical bar for window sides.	    */
		205,		/* Top and bottom horizontal bar for window.*/
		0xd1,		/* Top join.				    */
		0xcf,		/* Bottom join.				    */
		0xd8,		/* Window 4-way intersection.		    */
		0xb5,		/* Left hand join.			    */
		0xc6		/* Right hand join.			    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		"\x1B[%dX",		/* Sequence to clear 'n' spaces.	    */
		"\x1B[%dg",		/* Sequence to print characters with top    */
			   		/* bit set.				    */
		"\x1B[=12;13C",		/* Insert-mode cursor.			    */
		"\x1B[=1;13C",		/* Overwrite-mode cursor.		    */
		"\x1B[=8;13C",		/* Insert-mode cursor (on virtual space).   */
		"\x1B[=1;8C",		/* Overwrite-mode cursor (on virtual space).*/
		"\x1B[27g",		/* Print ESCAPE character graphically.	    */
		NULL,			/* Escape sequence to repeat last character.*/
		TRUE,			/* ESC [0m resets color.		    */
		TRUE,			/* Terminal supports color.		    */
		"\x1B[%dC",		/* Move cursor %d columns		    */
					/* (Not available in termcap).		    */
		TRUE,			/* ESC[K gives us a black erased line.	    */
		TRUE,			/* Re-write faster than scroll?	Not much in */
					/* it but re-write causes less glitching.   */
		NULL,			/* Enter Graphics Mode Unused.		    */
		NULL			/* Leave Graphics Mode Unused.		    */
		);

	/***********************************************/
	/*   Define  keyboard  layout  for  non-ascii  */
	/*   characters.  These  can only be used for  */
	/*   the console).			       */
	/***********************************************/
	set_term_keyboard(
		F1_F12, quote_list(
			/***********************************************/
			/*   Standard SCO F1 to F12		       */
			/***********************************************/
			"\x1B[M","\x1B[N","\x1B[O","\x1B[P","\x1B[Q",
			"\x1B[R","\x1B[S","\x1B[T","\x1B[U","\x1B[V",
			"\x1B[W","\x1B[X"),
		SHIFT_F1_F12, quote_list(
			/***********************************************/
			/*   Standard SCO Shift F1 to F12	       */
			/***********************************************/
			"\x1B[Y","\x1B[Z","\x1B[a","\x1B[b","\x1B[c",
			"\x1B[d","\x1B[e","\x1B[f","\x1B[g","\x1B[h",
			"\x1B[i","\x1B[j"),
		CTRL_F1_F12, quote_list(
			/***********************************************/
			/*   Standard SCO Ctrl F1 to F12	       */
			/***********************************************/
			"\x1B[k","\x1B[l","\x1B[m","\x1B[n","\x1B[o",
			"\x1B[p","\x1B[q","\x1B[r","\x1B[s","\x1B[t",
			"\x1B[u","\x1B[v"),
		ALT_F1_F12, quote_list(
			/***********************************************/
			/*   Use  SCO  Ctrl-Shift  F1  to  F12 as SCO  */
			/*   uses  Alt  F1  to  F12  for  multiscreen  */
			/*   swapping				       */
			/***********************************************/
			"\x1B[w","\x1B[x","\x1B[y","\x1B[z","\x1B[@",
			"\x1B[[","\x1B[\\","\x1B[]","\x1B[^","\x1B[_",
			"\x1B[`","\x1B[{"),
		KEYPAD_0, quote_list(
			/***********************************************/
			/*   Standard  SCO  Keypad  with  addition of  */
			/*   PrtScr  and  Keypad  *-/+Enter. (or DEL)  */
			/*   keys  added  to usr/lib/keyboard/strings  */
			/*   and   usr/lib/keyboard/keys   as   extra  */
			/*   function  keys.  Note  that  crisp  will  */
			/*   work  ok  whether  you  map  DEL or not,  */
			/*   but  the  addition  of  DEL is useful in  */
			/*   the   Korn   Shell  for  the  equivalent  */
			/*   command (delete character forwards).      */
			/***********************************************/
			"\x1B[L","\x1B[F","\x1B[B","\x1B[G","\x1B[D",
			"\x1B[E","\x1B[C","\x1B[H","\x1B[A","\x1B[I",
			"\x1B[K","\x1B[+","\x1B[-","\x1B[*","\x1B[/",
			  NULL  ,"\x1B[J",  NULL  ,"\x1B[}"),
		BACK_TAB,
			/***********************************************/
			/*   SCO  Standard  backtab,  note  that this  */
			/*   is the same as Shift F2!! Good one SCO.   */
			/***********************************************/
			"\x1B[Z",
			
		/***********************************************/
		/*   The   rest   are   custom  additions  to  */
		/*   /usr/lib/keyboard/keys.  Be  warned that  */
		/*   these   keys  may  clash  with  standard  */
		/*   keys      for     some     international  */
		/*   (Non-English) users.		       */
		/***********************************************/
		ALT_A_Z, quote_list(
			0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,
			0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,
			0xef,0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,
			0xf6,0xf7,0xf8,0xf9,0xfa),
		ALT_0_9, quote_list(
			0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,
			0xb7,0xb8,0xb9),
		/***********************************************/
		/*   These  are  actually  Ctrl-Shift keys as  */
		/*   the   Shifted   keys  are  used  by  the  */
		/*   Numlock   key   to   provide  a  numeric  */
		/*   keypad.  If  using  the  keyboard  in AT  */
		/*   mode then keypad keys .012346789 can  be  */
		/*   accessed  with  shift  only by using the  */
		/*   equivalent cursor (grey) keys. These are  */
		/*   Del/Ins/End/Dn/PgDn/Lt/Rt/Hm/Up/PgUp.     */
		/***********************************************/
		SHIFT_KEYPAD_0,	quote_list(
			0x80,0x81,0x82,0x83,0x84,0x85,0x86,
			0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,
			0x8e,0x8f),
		CTRL_KEYPAD_0, quote_list(
			0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,
			0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,
			0xce,0xcf),
		__ALT_KEYPAD(0), quote_list(
			0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,
			0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,
			0xde,0xdf)
	);
	/***********************************************/
	/*   Now  some  extra key assignments to make  */
	/*   crisp a bit more user friendly.	       */
	/***********************************************/
	
	assign_to_key("<Ctrl-Del>","objects delete_word_right");
	/* This is actually Ctrl Backspace. Do not do
	this if you have not mapped the Del key in
	/usr/lib/keyboard/keys and strings */
	assign_to_key("#127","objects delete_word_left");
	/* Make Ctrl-L do what it should! */
	assign_to_key("<Ctrl-L>","self_insert");
	/* Use Alt-P for print since we can't get PrtScr to work */
	assign_to_key("<Alt-P>","print");	
}
