# Keyboard mapping file for ibmpc under OS/2 or DOS box
# I guess a utility to build this file would be nice, but it tends to
# be an "edit once, then use for ever" kind of process.

# Basically, if you hit a key whose ASCII code is N, you are mapped via
# the Nth (counting from 0) entry in this table.  The editor will
# only see the mapped code.  Only single character mappings are possible.
# Under DOS, you can program function keys by sending the appropriate
# Ansi sequence (see files e*.i) on startup, but this does not seem to
# work for OS/2.  Tough.

# All data after a # is ignored until end of line.
# All white space is ignored - hence escapes must be used.
# The usual C conventions apply, except for \x (hex), but
# including \s for space and \# for #.  Sorry, but you have to do a lot
# of decimal to octal conversion :-)    - MOC

# First group map basic 128 character set
\0                              # nul - noop on PC
\1                              # ^A - pick
\2                              # ^B - mark
\3                              # ^C - interrupt
\4                              # ^D - down 1/2 page
\5                              # ^E - extended control functions
\6                              # ^F - find (plus search)
\7                              # ^G - Page Up
\177                            # del - destructive backspace
				#       so that fat <-- key works :-)
\11                             # ^I - HT (tab)
\12                             # ^J - LF (cursor down)
\13                             # ^K - VT (cursor up)
\14                             # ^L - FF (cursor right)
\15                             # ^M - CR (carriage return)
\16                             # ^N - del (delete right)
\17                             # ^O - insert/overwrite mode
\20                             # ^P - noop
\21                             # ^Q - XON (resume output)
\22                             # ^R - window right
\23                             # ^S - XOFF (suspend output)
\24                             # ^T - find (minus search)
\25                             # ^U - up 1/2 page
\26                             # ^V - page down
\27                             # ^W - switch to next window
\30                             # ^X - window left
\31                             # ^Y - close (delete) line
\32                             # ^Z - save and exit
\33                             # ^[ - esc (command mode)
\34                             # ^\ - escape next char (^#, ^|, ^` or
				#      ^~ on some keyboards)
\35                             # ^] - tab left
\36                             # ^^ - home
\37                             # ^_ - open (insert blank line)
\s!"\#$%&'()*+,-./              # Space ...
0123456789:;<=>?
@ABCDEFGHIJKLMNO
PQRSTUVWXYZ[\\]^_
`abcdefghijklmno
pqrstuvwxyz{|}~\177             # ... DEL

# The extended control functions (following ^E) are not remappable:
#       ^A                      recall last command string
#       ^E                      do interactive replacement
#       ^F                      do interactive replacement, find next
#       ^J                      join line
#       ^T                      do interactive replacement, find previous
#       ^W                      alt (switch to alternate file)
#       ^Y                      erase line (replace with blanks)
#       ^^                      redraw screen
#       ^_                      split line
# These should be considered historical;  in all cases, there is an
# equivalent function key (below).

# Next group map codes over 128 - with PC, this is usually just
# the 160(dec), 240(oct) value generated by the extra cursor keys
# on some keyboards:

\200\201\202\203\204\205\206\207
\210\211\212\213\214\215\216\217
\220\221\222\223\224\225\226\227
\230\231\232\233\234\235\236\237
\240\241\242\243\244\245\246\247        # 240(oct) = 160(dec)
\250\251\252\253\254\255\256\257
\260\261\262\263\264\265\266\267
\270\271\272\273\274\275\276\277
\300\301\302\303\304\305\306\307
\310\311\312\313\314\315\316\317
\320\321\322\323\324\325\326\327
\330\331\332\333\334\335\336\337
\340\341\342\343\344\345\346\347
\350\351\352\353\354\355\356\357
\360\361\362\363\364\365\366\367
\370\371\372\373\374\375\376\377

# The final group is optional, and maps the extended ASCII codes
# from cursor and function keys.  Currently, there is provision for
# 133 of these (max value 132 == Ctrl-PgUp)
# The first character (mapping for extended code 0) must not be 0.
# This should not be a problem, as the first extended code (for NUL)
# is 3 at present.
# Example: to swap F1 (default command "open new line") with Shift-F1 (default
# command "help"), exchange codes 59 and 84 (\73 and \124).

# Currently implemented codes are:
#       Oct     Dec     Func
#
#       \17     15      |<--  (back tab)
#       \73     59      F1 (open blank line)
#       \74     60      F2 (close line)
#       \75     61      F3 (mark)
#       \76     62      F4 (pick)
#       \77     63      F5 (-pick)
#       \100    64      F6 (-mark)
#       \101    65      F7 (-close)
#       \102    66      F8 (alt)
#       \103    67      F9 (+search)
#       \104    68      F10 (-search)
#       \107    71      Home
#       \110    72      Cur Up
#       \111    73      PgUp
#       \113    75      Cur Left
#       \115    77      Cur Right
#       \117    79      End (<CMD>Home)
#       \120    80      Cur Down
#       \121    81      PgDn
#       \122    82      Ins
#       \123    83      Del
#       \124    83      Shift-F1 (help == ESC-h-CR)
#       \137    95      Ctrl-F2 (erase)
#       \144    100     Ctrl-F7 (-erase)
#       \146    102     Ctrl-F9 (interactive replace)
#       \150    104     Alt-F1 (split)
#       \151    105     Alt-F2 (join)
#       \154    108     Alt-F5 (recall last command)
#       \157    111     Alt-F8 (switch window)
#       \160    112     Alt-F9 (replace and find next)
#       \161    113     Alt-F10 (replace and find previous)
#       \167    119     Ctrl-Home (redraw screen)

\1\1\2\3\4\5\6\7                        # 0-7
\10\11\12\13\14\15\16\17                # 8-15
\20\21\22\23\24\25\26\27                # 16-23
\30\31\32\33\34\35\36\37                # 24-31
\40\41\42\43\44\45\46\47                # 32-39
\50\51\52\53\54\55\56\57                # 40-47
\60\61\62\63\64\65\66\67                # 48-55
\70\71\72\73\74\75\76\77                # 56-63
\100\101\102\103\104\105\106\107        # 64-71
\110\111\112\113\114\115\116\117        # 72-79
\120\121\122\123\124\125\126\127        # 80-87
\130\131\132\133\134\135\136\137        # 88-95
\140\141\142\143\144\145\146\147        # 96-103
\150\151\152\153\154\155\156\157        # 104-111
\160\161\162\163\164\165\166\167        # 112-119
\170\171\172\173\174\175\176\177        # 120-127
\200\201\202\203\204\205                # 128-132

