@ -----------------------------------------------------------------
@ Sample of keywords file for the keywords highlighting feature of EPM
@ -----------------------------------------------------------------
@  This file is used by EPM to figure out which keywords to highlight
@  It contains all the ANSI C keywords, plus all the #defines,
@  typedefs and function prototypes of the 2.1 toolkit.
@  Since it is huge, it may takes a long time to load
@  Update:  The size has been cut in half by converting spaces to tabs.
@           If you don't use a monospaced font, things will appear misaligned.
@           The Extended Attribute EPM.TABS was used to ensure that tab stops
@           are set at every 8 columns.
@  EPM looks for this file along the EPMPATH.
@  The loading time can be reduced by removing some keywords from the list.
@  The format to follow is described below.
@
@ ------------------------------------------------------------------
@ Format of the file
@ ------------------------------------------------------------------
@ The first character of the first line is the "special" character.
@ If it appears at the beginning of a line after, it is
@ either followed by a space and marks then a comment, or
@ by any other character and is then a topic name.
@ Currently the only topics are :
@  DELIM
@     "start string" "end string" "bg color" "fg color" "escape character" "column"
@     What's between the 'start' and 'end' delimiters is set to the 'color' color.
@     If no 'end' is specified, the whole line after any 'start' string is colored.
@     If an 'Escape' character appears just before a 'end' string, it won't be considered an end delimiter.
@     If an 'Escape' character appears just before a 'start' string, it won't be considered a start delimiter.
@     An 'Escape' character can be escaped by another 'Escape' character
@     If the column field is present, a start delimiter will be valid only if it starts on this column
@     If the end delimiter is not on the same line as the start, no color changes will be done.
@     The special character can be used as a placeholder, eg if you want a column but no escape character
@  DELIMI
@     Like DELIM, but case insensitive.
@  KEYWORDS
@     "name" "fg color" "bg color"
@     They must include only characters specified in the CHARSET section, case sensitive.
@  INSENSITIVE
@     "name" "fg color" "bg color"
@     Same as KEYWORDS except case insensitive.
@  CHARSET
@     "string including all the characters"
@     List of characters allowed in the names of the KEYWORDS and INSENSITIVE sections.
@  SPECIAL
@     "name" "fg color" "bg color"
@     Any occurrence of these strings will be changed to the specified color.
@     They can include any character.
@  SPECIALI
@     Like SPECIAL, but case insensitive.
@  BREAKCHAR
@     "character" "fg color" "bg color"
@     This character is considered as a space when keywords in @KEYWORDS
@     or @INSENSITIVE are looked for.  If colors are specified, a break
@     at the beginning of a keyword will have its own color, else it will
@     have the same color as the keyword.
@  ENDCHAR
@     "character" "fg color" "bg color"@
@     The character after this one is considered as a space when keywords
@     in @KEYWORDS or @INSENSITIVE are looked for.  If colors are
@     specified, an end char at the end of a keyword will have its own
@     color, else it will have the same color as the keyword.
@
@     An end character at the end of a keyword in @KEYWORDS or
@     @INSENSITIVE is hilited with its own color.
@
@  The background and foreground colors are values between 0 and 15
@  If a value of -1 is given then the default foreground or background
@  color is used.
@ Colors -
@   0 - Black          8 - Gray
@   1 - Blue           9 - Bright Blue
@   2 - Green         10 - Bright Green
@   3 - Cyan          11 - Bright Cyan
@   4 - Red           12 - Bright Red
@   12- Magenta       13 - Bright Magenta
@   6 - Brown         14 - Yellow
@   7 - Dark Gray     15 - White
@
@ -----------------------------------------------------------------
@ Actual description of the keywords
@ -----------------------------------------------------------------
@
@DELIM
@
@ Start   Color Color  End     Escape
@ string  bg    fg     string  character
  /*       -1      7   */
  //       -1      7
@ Caution:  Only enable the following if you always leave a space after a //
@ - otherwise, it will cause some comments to not be highlighted.
@ //todo   14     12
@ //Todo   14     12
@ //ToDo   14     12
@ //TODO   14     12
  "        -1      2   "       EOL
  '        -1     10   '       EOL
@
@SPECIAL
@
{  -1  11
}  -1  11
;  -1  11
,  -1  11
?  -1  11
:  -1  11
:: -1  12
-> -1  12
@
@CHARSET
@
abcdefghijklmnopqrstuvwxyz_#ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789
@
@KEYWORDS
@
@ -------------------- C pre-processor keywords ---------------------------
#define         -1      12
#elif           -1      12
#else           -1      12
#endif          -1      12
#include        -1      12
#if             -1      12
#ifdef          -1      12
#ifndef         -1      12
#pragma         -1      12
#undef          -1      12
@ -------------------- C language constructs ---------------------------
auto            -1      12
break           -1      12
case            -1      12
char            -1      12
const           -1      12
continue        -1      12
default         -1      12
do              -1      12
double          -1      12
enum            -1      12
else            -1      12
extern          -1      12
float           -1      12
for             -1      12
goto            -1      12
if              -1      12
int             -1      12
long            -1      12
main            -1      12
register        -1      12
return          -1      12
short           -1      12
signed          -1      12
sizeof          -1      12
static          -1      12
struct          -1      12
switch          -1      12
typedef         -1      12
union           -1      12
unsigned        -1      12
void            -1      12
volatile        -1      12
while           -1      12
freopen         -1      12
fflush          -1      12
fopen           -1      12
fclose          -1      12
remove          -1      12
rename          -1      12
tmpfile         -1      12
tmpnam          -1      12
setvbuf         -1      12
setbuf          -1      12
fprintf         -1      12
printf          -1      12
sprintf         -1      12
vprintf         -1      12
vfprintf        -1      12
vsprintf        -1      12
fscanf          -1      12
scanf           -1      12
sscanf          -1      12
fgetc           -1      12
fgets           -1      12
fputc           -1      12
fputs           -1      12
getc            -1      12
getchar         -1      12
gets            -1      12
putc            -1      12
putchar         -1      12
puts            -1      12
ungetc          -1      12
fread           -1      12
FILE            -1      12
stdin           -1      12
stderr          -1      12
stdout          -1      12
size_t          -1      12
fread           -1      12
fwrite          -1      12
fseek           -1      12
ftell           -1      12
rewind          -1      12
fgetpos         -1      12
fsetpos         -1      12
SEEK_SET        -1      12
SEEK_CUR        -1      12
SEEK_END        -1      12
fpos_t          -1      12
clearerr        -1      12
feof            -1      12
ferror          -1      12
perror          -1      12
isalnum         -1      12
isalpha         -1      12
iscntrl         -1      12
isdigit         -1      12
isgraph         -1      12
islower         -1      12
isprint         -1      12
ispunct         -1      12
isspace         -1      12
isupper         -1      12
isxdigit        -1      12
tolower         -1      12
toupper         -1      12
strcpy          -1      12
strncpy         -1      12
strcat          -1      12
strncat         -1      12
strcmp          -1      12
strncmp         -1      12
strchr          -1      12
strrchr         -1      12
strspn          -1      12
strcspn         -1      12
strpbrk         -1      12
strstr          -1      12
strlen          -1      12
strerror        -1      12
strtok          -1      12
memcpy          -1      12
memmove         -1      12
memcmp          -1      12
memchr          -1      12
memset          -1      12
sin             -1      12
cos             -1      12
tan             -1      12
asin            -1      12
acos            -1      12
atan            -1      12
atan2           -1      12
sinh            -1      12
cosh            -1      12
tanh            -1      12
exp             -1      12
log             -1      12
log10           -1      12
pow             -1      12
sqrt            -1      12
ceil            -1      12
floor           -1      12
fabs            -1      12
ldexp           -1      12
frexp           -1      12
modf            -1      12
fmod            -1      12
atof            -1      12
atoi            -1      12
atol            -1      12
strtod          -1      12
strtol          -1      12
strtoul         -1      12
rand            -1      12
srand           -1      12
calloc          -1      12
malloc          -1      12
realloc         -1      12
free            -1      12
abort           -1      12
exit            -1      12
atexit          -1      12
system          -1      12
getenv          -1      12
bsearch         -1      12
qsort           -1      12
abs             -1      12
labs            -1      12
div             -1      12
div_t           -1      12
ldiv            -1      12
ldiv_t          -1      12
assert          -1      12
va_list         -1      12
va_start        -1      12
va_arg          -1      12
va_end          -1      12
setjmp          -1      12
jmp_buf         -1      12
longjmp         -1      12
signal          -1      12
SIGABRT         -1      12
SIGFPE          -1      12
SIGILL          -1      12
SIGINT          -1      12
SIGSEV          -1      12
SIGTERM         -1      12
SIG_ERR         -1      12
raise           -1      12
clock_t         -1      12
clock           -1      12
time_t          -1      12
time            -1      12
difftime        -1      12
mktime          -1      12
tm              -1      12
asctime         -1      12
ctime           -1      12
gmtime          -1      12
localtime       -1      12
strftime        -1      12
CHAR_BIT        -1      12
CHAR_MAX        -1      12
UCHAR_MAX       -1      12
SCHAR_MAX       -1      12
CHAR_MIN        -1      12
SCHAR_MIN       -1      12
INT_MAX         -1      12
INT_MIN         -1      12
LONG_MAX        -1      12
LONG_MIN        -1      12
SCHAR_MAX       -1      12
SCHAR_MIN       -1      12
SHRT_MAX        -1      12
SHRT_MIN        -1      12
UCHAR_MAX       -1      12
UINT_MAX        -1      12
ULONG_MAX       -1      12
USHRT_MAX       -1      12
FLT_RADIX       -1      12
FLT_ROUNDS      -1      12
FLT_DIG         -1      12
FLT_EPSILON     -1      12
FLT_MANT_DIG    -1      12
FLT_MAX         -1      12
FLT_MAX_EXP     -1      12
FLT_MIN         -1      12
FLT_MIN_EXP     -1      12
DBL_DIG         -1      12
DBL_EPSILON     -1      12
DBL_MANT_DIG    -1      12
DBL_MAX         -1      12
DBL_MAX_EXP     -1      12
DBL_MIN         -1      12
DBL_MIN_EXP     -1      12
@       -------------------- C++ language constructs -------------------------
catch           -1      12
class           -1      12
delete          -1      12
friend          -1      12
inline          -1      12
new             -1      12
operator        -1      12
private         -1      12
protected       -1      12
public          -1      12
template        -1      12
this            -1      12
throw           -1      12
try             -1      12
virtual         -1      12
@ -------------------- OS/2 Toolkit definitions ---------------------------

