/*  REXX - GETFQNM.REX  */

/*
   Sample program to demonstrate ISPEXEC GETFQNM.

   Syntax:  REXX GETFQNM FileName
   FileName :: Any filename.

   The filename is converted into a fully qualified filename.
   This program also shows that when the short help message is null,
   the long help message is displayed without having to enter HELP.
*/

PARSE ARG FileName

ADDRESS ISPEXEC 'GETFQNM FullName FileName'
IF ( (Rc \= 0) | (FullName = '') ) THEN
   DO; ZerrSm = 'FAILURE'; ZerrLm = 'UNABLE TO CONVERT "' || Filename ,
   || '"INTO A FULLY QUALIFIED FILENAME'; ZerrAlrm = 'YES'; END
ELSE
   DO;  ZerrSm = ''; ZerrLm = FullName; ZerrAlrm = 'NO'; END;

ADDRESS ISPEXEC 'SETMSG MSG( ISRZ002 )'

EXIT
