/*
$VerboseHistory: cobol.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/08/1998  Time:08:17a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:17a
 * Comment:
 * Fixed tab and backtab keys for cobol mode.
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:10a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/07/1998 04:56p
 * Comment:
 * Fixed tab and backtab keys for cobol mode.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:36p
 * Comment:
 * Adding new 3.0 stuff
*/
/*

  NOTE:  I still don't think we have gotten enough feed back from
         users of this macro for it to be considered done.  Please
         call us with suggestions you have on this macro.

INSTALLATION:

    -  Load this macro module with LOAD command.  The ST.EXE
       compiler will automatically get invoked if necessary.
    -  Save the configuration. (CONFIG,Save configuration...)

  Options for COBOL syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             Keyword case.  Values may be 0,1, or 2 which correspond
                     to lower case, upper case, and capitalized.  Default
                     is 0.
       3             reserved.
       4             Specifies whether 1985 ANSI key words should be supported.
                     Default is 1.
       5             reserved.

  In addition to using the file extension setup menu to configure cobol
  defaults, you can set the variable "def_cobol_levels" with the SET-VAR
  command to configure the columns for level numbers.

  Example

      set-var def_cobol_levels 01=8 03=12 05=16 07=20 77=8 88=8

  Cobol notes for VSE developers

     *  Ryan Mcfarland. For PC, everything before column is either
        a linenumber or comment (asterisk in column 7).

     Got some sugestions from Scott Freisure phone# 806 379-0575

*/
#include 'slick.sh'
_str
   def_cobol_levels='01=8 03=12 05=16 07=20 77=8 88=8'

#define MODE_NAME 'Cobol'
#define EXTENSION 'cob'

defload()
{
   setup_info='MN='MODE_NAME',TABS=1 8 250 +4,MA=1 74 1,':+
               'KEYTAB='MODE_NAME'-keys,WW=1,IWT=0,ST=0,'
   compile_info='0 cobol *;'
   syntax_info='4 1 1 0 0 1 0'
   be_info=''
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info,"",'a-zA-Z0-9\-')

   if ( kt_index ) {
      set_eventtab_index kt_index,event2index(name2event('tab')),
                 find_index('cob-tab',COMMAND_TYPE)
      set_eventtab_index kt_index,event2index(name2event('s-tab')),
                 find_index('cob-backtab',COMMAND_TYPE)
   }
   create_ext(kt_index,'cbl',EXTENSION)



}
static _str word_case(s)
{
   parse name_info(p_index) with . . . scase .
   if ( scase==0 ) {
      return(lowcase(s)) /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s))    /* Upper case language key words. */
   }
   if (substr(s,1,1)==' ') {
      i=verify(s,' ')
      if (!i) {
         return(s);
      }
   } else {
      i=1;
   }
   return(substr(s,1,i-1):+upcase(substr(s,i,1)):+lowcase(substr(s,i+1)))  /* Capitalize */
}
_command cobol_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('cob')

}
_command cobol_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         cobol_expand_enter(p_SyntaxIndent) ) {
      call_root_key(ENTER)
   } else if (_argument=='') {
      _undo 'S'
   }

}
_command cobol_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ')
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      cobol_expand_space() ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ')
         } else {
            keyin ' '
         }
      }
   } else if (_argument=='') {
      _undo 'S'
   }

}
#define ENTER_WORDS (' accept add alter call cancel close compute delete disable ':+\
               'display divide else enable evaluate generate go if ':+\
               'initialize initiate inspect merge ':+\
               'move multiply open perform read receive release return when ')
#define ENTER_WORDS2 (' rewrite search select send set start stop string subtract ':+\
               'terminate unstring use varying write ')
#define EXPAND_WORDS (' cancel close delete disable display else enable end-evaluate ':+\
                'end-if end-perform end-string end-unstring evaluate ':+\
                'generate giving initialize initiate inspect merge open ':+\
                'perform read receive release remainder rewrite return ')
#define EXPAND_WORDS2 (' search send start stop tallying terminate thru until use ':+\
                'when write ')


static _str space_words[]={
'accept','add','alter','call','cancel','close','compute','continue',
'data','delete','disable','display','divide','else','enable',
'end-evaluate','end-if','end-perform','end-string','end-unstring',
'environment','evaluate','exit','generate','go','giving',
'identification','if','initialize','initiate','inspect',
'merge','move','multiply','open','perform','procedure',
'read','receive','release','remainder','return','rewrite','search',
'select','send','set','start','stop','string','subtract','supress',
'tallying','terminate','thru','unstring','until','use','varying',
'when','write'};

static _str old_space_words[]={
'accept','add','alter','call','cancel','close','compute','continue',
'data','delete','disable','display','divide','else','enable',
'environment','exit','generate','go','giving','identification',
'if','initialize','initiate','inspect'};


/* Returns non-zero number if fall through to enter key required */
static _str cobol_expand_enter(syntax_indent)
{
   get_line(line);
   i=verify(line,'0123456789')  /* Skip the linenumbers */
   if ( ! i ) {
      i=8;
   }
   parse substr(line,i) with orig_first_word rest
   first_word=lowcase(orig_first_word);
   if ( (pos(' 'first_word' ',ENTER_WORDS) || pos(' 'first_word' ',ENTER_WORDS2)) &&
      last_char(strip(rest))!='.' ) {
      old_col=p_col;
      p_col=verify(line,' ','',i)
      tab;
      new_col=p_col;p_col=old_col
      indent_on_enter(syntax_indent)
   } else {
      if ( first_word!='' ) {
         new_col=verify(line,' ','',i)
      } else {
         if ( i<8 ) {
            i=8
         }
         new_col=i
      }
      call_root_key(ENTER)
   }
   get_line(next_line);
   if ( p_col<new_col ) {
      diff=new_col-p_col
      if ( next_line!='' ) {
         replace_line substr('',1,diff):+next_line
      }
      p_col=p_col+diff
   }
   return(0)

}
static _str division_indent()
{
   return(substr('',1,7))

}
static _str comment_indent()
{
   return(substr('',1,6)'*')

}
static _str cobol_expand_space()
{
   status=0
   get_line tline
   line=strip(tline,'T')
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   word=strip(tline,'L')
   if ( pos(' 'word'=',' 'def_cobol_levels' ') ) {
      column=eq_name2value(word,def_cobol_levels)
      if ( isinteger(column) ) {
         replace_line indent_string(column-1):+strip(tline)' '
         _end_line
         return(0)
      }
   }
   i=verify(line,'0123456789')  /* Skip the linenumbers */
   if ( ! i ) {
      return(1)
   }
   orig_word=lowcase(strip(substr(line,i)))
   if ( is_ansi_1985() ) {
      words=space_words;
   } else {
      words=old_space_words;
   }
   aliasfilename='';
   word=min_abbrev2(orig_word,words,name_info(p_index),aliasfilename);
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='' ) return(1);
   linenum_space=substr(line,1,verify(line,' '\t,'',i)-1)
   if ( length(linenum_space)<11 ) {
      linenum_space=substr(linenum_space,1,11)
   }
   leading_space=substr('',1,length(linenum_space))
   if ( word=='accept' ) {
      replace_line linenum_space:+word_case('accept  from ')
      p_col=text_col(leading_space)+8
   } else if ( word=='add' ) {
      replace_line linenum_space:+word_case('add  to ')
      p_col=text_col(leading_space)+5
   } else if ( word=='alter' ) {
      replace_line linenum_space:+word_case('alter  to ')
      p_col=text_col(leading_space)+7
   } else if ( word=='call' ) {
      replace_line linenum_space:+word_case('call  using ')
      p_col=text_col(leading_space)+6
   } else if ( word=='continue' ) {
      replace_line linenum_space:+word_case('continue.')
      _end_line
   } else if ( word=='compute' ) {
      replace_line linenum_space:+word_case('compute  = ')
      p_col=text_col(leading_space)+9
   } else if ( word=='data' ) {
      leading_space=division_indent()
      linenum_space=substr(linenum_space,1,length(leading_space))
      replace_line linenum_space:+word_case('data division.')
      insert_line  leading_space:+word_case('file section.')
      insert_line  ''
      insert_line  leading_space:+word_case('working-storage section.')
      insert_line  ''
      insert_line  leading_space:+word_case('linkage section.')
      insert_line  leading_space:+'/'
      up 4;p_col=text_col(leading_space)+1
   } else if ( word=='divide' ) {
      replace_line linenum_space:+word_case('divide  into ')
      p_col=text_col(leading_space)+8
/*
   elseif word='else' then
      replace_line linenum_space||word_case(word)
      insert_line ''
      p_col=text_col(leading_space)+1;tab
*/
   } else if ( word=='environment' ) {
      leading_space=division_indent()
      linenum_space=substr(linenum_space,1,length(leading_space))
      replace_line linenum_space:+word_case('environment division.')
      insert_line  leading_space:+word_case('configuration section.')
      insert_line  leading_space:+word_case('source-computer ibm-personal-computer.')
      insert_line  leading_space:+word_case('object-computer ibm-personal-computer.')
      insert_line  ''
      insert_line  leading_space:+word_case('input-output section.')
      insert_line  leading_space:+word_case('file control.')
      insert_line  ''
      insert_line  leading_space:+'/'
      up;p_col=text_col(leading_space)+1;tab
   } else if ( word=='exit' ) {
      replace_line linenum_space:+word_case('exit.')
      _end_line
      /* insert_line '' */
      /* p_col=text_col(leading_space)+1 */
   } else if ( word=='go' ) {
      replace_line linenum_space:+word_case('go to ')
      p_col=text_col(leading_space)+7
   } else if ( word=='identification' ) {
      leading_space=division_indent()
      linenum_space=substr(linenum_space,1,length(leading_space))
      replace_line linenum_space:+word_case('identification division.')
      insert_line  leading_space:+word_case('program-id. 'strip_filename(p_buf_name,'pe')'.')
      insert_line  comment_indent():+word_case('author. ')
      insert_line  comment_indent():+word_case('installation. ')
      insert_line  comment_indent():+word_case('date-written. ')
      insert_line  comment_indent():+word_case('date-compiled. ')
      insert_line  leading_space:+'/'
      insert_line  ''
      p_col=text_col(leading_space)+1
   } else if ( word=='if' ) {
      replace_line linenum_space:+word_case('if ')
      if ( is_ansi_1985() ) {
         insert_line leading_space:+word_case('end-if')
         up;_end_line
      } else {
         p_col=text_col(leading_space)+4
      }
   } else if ( word=='evaluate' && is_ansi_1985() ) {
      replace_line linenum_space:+word_case('evaluate ')
      p_col=text_col(leading_space)+1;tab
      insert_line  substr('',1,p_col-1):+word_case('when other ')
      insert_line  leading_space:+word_case('end-evaluate')
      up 2;_end_line
   } else if ( word=='move' ) {
      replace_line linenum_space:+word_case('move  to ')
      p_col=text_col(leading_space)+6
   } else if ( word=='multiply' ) {
      replace_line linenum_space:+word_case('multiply  by ')
      p_col=text_col(leading_space)+10
   } else if ( word=='perform' && is_ansi_1985() ) {
      replace_line linenum_space:+word_case('perform ')
      insert_line  leading_space:+word_case('end-perform')
      up;_end_line
   } else if ( word=='procedure' ) {
      leading_space=division_indent()
      linenum_space=substr(linenum_space,1,length(leading_space))
      replace_line linenum_space:+word_case('procedure division.')
      p_col=text_col(leading_space)+19
   } else if ( word=='set' ) {
      replace_line linenum_space:+word_case('set  to ')
      p_col=text_col(leading_space)+5
   } else if ( word=='select' ) {
      replace_line linenum_space:+word_case('select  assign to ')
      if ( is_ansi_1985() ) {
         p_col=text_col(leading_space)+1;tab
         insert_line  substr('',1,p_col-1):+word_case('when ')
         up
      }
      p_col=text_col(leading_space)+8
   } else if ( word=='string' ) {
      replace_line linenum_space:+word_case('string ')
      p_col=text_col(leading_space)+1;tab
      if ( is_ansi_1985() ) {
         col=p_col
         insert_line  substr('',1,col-1):+word_case('delimited by ')
         insert_line  substr('',1,col-1):+word_case('into ')
         insert_line  leading_space:+word_case('end-string')
         up 3;
      } else {
         insert_line  substr('',1,p_col-1):+word_case('delimited by ')
         insert_line  leading_space:+word_case('into ')
         up 2;
       }
      p_col=text_col(leading_space)+8
   } else if ( word=='subtract' ) {
      replace_line linenum_space:+word_case('subtract  from ')
      p_col=text_col(leading_space)+10
   } else if ( word=='supress' ) {
      replace_line linenum_space:+word_case('supress printing.')
      _end_line
   } else if ( word=='unstring' ) {
      replace_line linenum_space:+word_case('unstring ')
      p_col=text_col(leading_space)+1;tab
      if ( is_ansi_1985() ) {
         col=p_col
         insert_line  substr('',1,col-1):+word_case('delimited by ')
         insert_line  substr('',1,col-1):+word_case('into ')
         insert_line  leading_space:+word_case('end-unstring')
         up 3;
      } else {
         insert_line  substr('',1,p_col-1):+word_case('delimited by ')
         insert_line  leading_space:+word_case('into ')
         up 2;
       }
      p_col=text_col(leading_space)+10
   } else if ( word=='varying' ) {
      replace_line linenum_space:+word_case('varying  from 1 by 1')
      p_col=text_col(leading_space)+9
   } else if ( pos(' 'word' ',EXPAND_WORDS) || pos(' 'word' ',EXPAND_WORDS2) ) {
      replace_line linenum_space:+word_case(word' ')
      _end_line
   } else {
      status=1
   }
   return status
}
static _str is_ansi_1985()
{
   parse name_info(p_index) with . . . . . ansi .
   return(ansi)

}

// COBOL procedure search supporting cobol 1985 as well as
// OOCOBOL extensions.  Parsing strategy is to first look for
// Class-id or Method-id or Procedure division.  If one is
// found, then handle it.  If after a Procedure division, we
// find a proc that is not a class method, then we turn on the
// old-style-cobol switch.  From then on, we just repeat the
// simple cobol proc search.
//
_str cob_proc_search(var proc_name,find_first)
{
   static _str cur_class_name;
   static int  old_style_cobol;
   tag_type='func';
   if (find_first) {
      cur_class_name  = '';
      old_style_cobol = 0;
   }
   if (old_style_cobol) {
      for (;;) {
         status=repeat_search();
         if ( status ) {
            return(1);
         }
         if (_clex_find(0,'g')!=CFG_KEYWORD) {
            proc_name=translate(get_text(match_length('0'),match_length('S0')),'_','-');
            break;
         }
      }
   } else {
      line_prefix_re='^([0-9]:1,6| ) *[~*]';
      cobol_id_re='[A-Za-z0-9\-]#';
      for (;;) {
         // initial search to find start of procedure division, method or class
         status=search(line_prefix_re' *(procedure *division|method-id.|class-id.)\c','ri@');
         if ( status ) {
            return(1);
         }
         get_line(line);
         // find specific tag?
         if (proc_name != '') {
            tag_tree_decompose_tag(proc_name, dp, class_name, tag_type, df);
            proc_name=translate(dp,'-','_')
            if (tag_type :== 'class' && !pos('class-id',line,1,'i')) {
               status=search(line_prefix_re' *\cclass-id.','ri@');
               if ( status ) {
                  return(1)
               }
               get_line(line);
            } else if (class_name != '' && !pos('method-id',line,1,'i')) {
               status=search(line_prefix_re' *\cmethod-id.','ri@');
               if ( status ) {
                  return(1)
               }
               get_line(line);
            }
            more_re="";
         } else {
            // find any old tag...
            proc_name=cobol_id_re;
            more_re="([ \t]@section[ \t]@|)";
         }

         if (pos('method-id. *"*{'proc_name'}"*', line, 1, 'ri')) {
            proc_name=translate(substr(line,pos('S0'),pos('0')),'_','-');
            tag_type='func';
            break;
         } else if (pos('class-id. *{'proc_name'}', line, 1, 'ri')) {
            proc_name=translate(substr(line,pos('S0'),pos('0')),'_','-');
            tag_type='class';
            break;
         } else if (pos('procedure *division',line,1,'ir')) {
            status=search(line_prefix_re'\c{'proc_name'}'more_re'.','@ri');
            if (!status) {
               tag_type='func';
               get_line(line);
               if (pos('method-id. *"*{'proc_name'}"*', line, 1, 'ri')) {
                  proc_name=translate(substr(line,pos('S0'),pos('0')),'_','-');
                  break;
               } else if (cur_class_name=='' && _clex_find(0,'g')!=CFG_KEYWORD) {
                  old_style_cobol = 1;
                  proc_name=translate(get_text(match_length('0'),match_length('S0')),'_','-');
                  if (proc_name != '') {
                     break;
                  }
               }
            }
         }
      }
   }
   if (tag_type :== 'class') {
      cur_class_name = proc_name;
      proc_name=proc_name'('tag_type')';
   } else if (cur_class_name != '') {
      proc_name=proc_name'('cur_class_name':'tag_type')'VS_TAGFLAG_inclass;
   }
   return(0)

}
_command void cob_tab() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state()) {
      call_root_key(TAB);
      return;
   }
   tab();
}
_command void cob_backtab() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state()) {
      call_root_key(S_TAB);
      return;
   }
   backtab();
#if 0
  Sample Micro Focus Version 2.5.25 error message.  Running under OS/2
     2 program-id. test.
* 106-S****************                                                      **
**    PROGRAM-ID has illegal format
#endif
}
  #define MICROFOCUS_RE '^\*(\*|) *{:n-?}\*'
  static _str
     cobol_filename
  _str
     _error_re2
     ,_error_parse

void cob_init_error()
{
   _error_parse= find_index('cob-parse-error',PROC_TYPE)
   or_re(_error_re2,MICROFOCUS_RE);
   cobol_filename=p_buf_name
}
void cob_parse_error(var filename,var line,var col,var err_msg)
{
   process_line=p_line
   get_line temp
   /* Cursor error not supported by cobol  */
   /* since can't determine cobol filename. */
   if ( ! pos(MICROFOCUS_RE,temp,1,'r') || arg(5)!='' ) {
      parse_error(filename,line,col,err_msg,arg(5));
      return;
   }
   filename=cobol_filename
   error_code=substr(temp,pos('S0'),pos('0'))
   line=p_line
   search('^[ \t]*:n','@r-');
   if ( ! rc ) {
      get_line temp
      parse temp with line .
      if ( ! isinteger(line) ) {
         line=p_line
      }
   }
   p_line=process_line
   down
   get_line err_msg
   err_msg=error_code:+err_msg
   col=''
}
