/*
$VerboseHistory: complete.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/08/1998  Time:08:24a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:24a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:23a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/07/1998 04:56p
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
//
// This module is a general purpose engine for providing completion.
// To avoid update problems, do not  modify this file if possible.  Place
// your additional completion support procedures in another file.
// See below for information on conventions.
//
// To add completion support for another argument type you need to define
// a constant, run initialization code, and define a procedure (DEFPROC)
// with the name equal to constant_value||'_match'.  You may also define a
// help procedure with name equal to constant_value||'_help'.  See c_help
// procedure for a source code help example.
// The sample code below shows the format:
//
//   include "slick.sh"
//   const
//      US_STATE_ARG='US'   /* Underscores must be dashes */
//
//   defload
//      if eq_name2value('us-state',def_user_args)='' then  /* Not exist? */
//         def_user_args=def_user_args' us-state='US_STATE_ARG
//      endif
//
//   defproc us_match(name_prefix,find_first)
//
//            This function must perform three tasks depending on the
//            value of find_first.
//
//            find_first       Task
//                0            Search for next prefix match of name_prefix.
//                             Return match found. Return '' if not found.
//                1            Search for first prefix match of name_prefix.
//                             Return match found. Return '' if not found.
//                2            Terminate match.  Only match functions
//                             with the TERMINATE_MATCH flag will be called.
//
//  Flags may be attached to the completion procedures:
//
//       TERMINATE_MATCH   =1
//       FILE_CASE_MATCH   =2
//       NO_SORT_MATCH     =4
//       REMOVE_DUPS_MATCH =8
//       AUTO_DIR_MATCH    =16
//
//
#include 'slick.sh'
_str
   _fpos_case


static _str clist_fall_through(reason,var result,key);
static void keyin_char()
{
   keyin_char= key2ascii(last_event())
   if ( length(keyin_char)!=1 ) {
      keyin_char=''
   }
   keyin keyin_char

#if 0
   /* The get_string function needs to check for this command */
   /* for this command to work correctly. */
defc list_matches
   if ( command_state() ) {
      if ( name_name(last_index())=='list-matches' ) {
         maybe_list_matches()
      } else {
         return(maybe_list_matches(arg(1),'','','1'))
      }
   }
#endif

}
_command void maybe_complete() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      if ( arg() ) {
         complete(arg(1))
      } else {
         complete()
      }
   } else {
      keyin_char()
   }
}

/*

    INPUT
       1    completion function
       3    Auto selection if one match
       4    If not '', p_text is the argument to the command.
*/
_command maybe_list_matches() name_info(','VSARG2_LASTKEY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
     get_command line,col
     args_to_command=arg(4):!=''
     auto_select=arg(3)
     if ( ! auto_select ) {
        auto_select=''
     }
     /* Could be search command like /.... */
     /* If first char of command line is not an alpha AND not just args of command. */
     if ( line!='' && ! isalpha(substr(line,1,1)) && ! args_to_command ) {
        keyin_char()
        return(0)
     }
     /* if the current character is a space and the previous character is not. */
     /* Try to expand the current argument on the command line. */
     arg_number= get_arg_number(line,col,word,start_word_col,args_to_command,arg(1))
     /* messageNwait('arg_number='arg_number' col='col' word=<'word'> start_word_col' start_word_col) */
     if ( arg_number<=1 && ! args_to_command ) {
       match_fun_prefix=COMMAND_ARG
     } else {
       if ( args_to_command ) {
          status=find_match_fun(line,arg_number,match_fun_prefix,'1',arg(1))
       } else {
          status=find_match_fun(line,arg_number,match_fun_prefix,'1')
       }
       if ( status ) {
         keyin_char()
         return(0)
       }
     }
     match_fun_index=match_prefix2index(match_fun_prefix,match_flags,multi_select, last_arg2)
     /* messageNwait('word='word' new_match_name='new_match_name) */
     for (;;) {
        old_word=strip(word)
        last_event(ESC)
        result=list_matches(strip(word),match_fun_prefix,'','','',auto_select)
        return_val=0
        if ( result=='' ) {
           /* No matches found OR ESC pressed OR match function not found. */
           return(0)
        }
        keep_listing=((match_flags & AUTO_DIR_MATCH) && last_char(result):==FILESEP)
        if ( result!='' ) {
           //last_arg=_arg_complete && last_event():==ENTER && ! keep_listing
           last_arg=_arg_complete && ! keep_listing
           if ( keep_listing ) {
              /* Translate  path/../ to / and Translate path/./ to path */
              len=length(result)
              if ( len>4 && _dbcsSubstr(result,length(result)-3)==FILESEP'..'FILESEP ) {
                 if ( _dbcsSubstr(result,length(result)-4,1)!='.' ) {
                    result=strip_filename(substr(result,1,length(result)-4),'n')
                 }
              } else if ( len>3 && _dbcsSubstr(result,length(result)-2)==FILESEP'.'FILESEP ) {
                 result=substr(result,1,length(result)-4)
              }
           }
           replace_word(line,word,start_word_col,result)
           set_command line,start_word_col+length(result)+_arg_complete;
           if ( last_arg && ! args_to_command && p_window_id==_cmdline) {
              command_execute()  /* Execute the command on the command line. */
           }
           if ( ! keep_listing ) {
              return(last_arg)
           }
           return_val=last_arg
        }
        /* matching files? */
        if ( keep_listing ) {
           /* Check if there is at least one match. */
           match_name=call_index(result,1,match_fun_index)
           if ( match_flags & TERMINATE_MATCH ) {
              call_index('',2,match_fun_index)
           }
           if ( match_name=='' ) {
              break
           }
           word=result
           continue
        }
        return(return_val)
     }
     /* messageNwait('arg_number='arg_number' col='col' word=<'word'> start_word_col' start_word_col) */
   } else {
      keyin_char()
   }
   return(0)


}
void complete()
{
  get_command line,col
  /* if the current character is a space and the previous character is not. */
  if ( col>1 && _dbcsSubstr(line,col,1):==' ' && _dbcsSubstr(line,col-1):!=' ' &&
      (isalpha(substr(line,1,1)) || arg())
  ) {
    /* Try to expand this word on the command line. */
    arg_number= get_arg_number(line,col,word,start_word_col,arg(),arg(1))
    if ( arg_number<=1 && ! arg() ) {
      index=name_match(strip(word),1,COMMAND_TYPE)
      if (!index) {
         index=name_match(strip(word),1,COMMAND_TYPE|IGNORECASE_TYPE);
      }
      if ( ! index ) {
#if 0
        // This code has got to be useless, so it has been removed.
        if ( ! name_match(strip(word),1,VAR_TYPE) ) {
          message nls('Command not internal')
        }
#endif
        keyin_char()
        k=get_event()
        call_key k
        return
      }
      fun_name_prefix=COMMAND_ARG
      command_case=1
    } else {
      if ( arg() ) {
         status=find_match_fun(line,arg_number,fun_name_prefix,'',arg(1))
      } else {
         status=find_match_fun(line,arg_number,fun_name_prefix)
      }
      if ( status || word=='' ) {
        keyin_char()
        return
      }
      command_case=0
    }
    expand_word(line,word,start_word_col,fun_name_prefix,command_case)
    return
  }
  keyin_char()

}
static _str get_arg_number(line,col,var word,var start_word_col,args_to_command,
               completion_info  // Valid only if args_to_command is FALSE
               )
{
   one_arg=999999;
   // Check for special one argument support only flag
   if (!args_to_command) {
      parse line with command rest
      index=find_index(command,COMMAND_TYPE);
      completion_info='';
      if (index) {
         parse name_info(index) with completion_info ','
      }
   }
   parse completion_info with name_prefix ':' match_flags
   if (match_flags!='' && isinteger(match_flags) && (match_flags & ONE_ARG_MATCH)) {
      one_arg=(args_to_command?1:2);
   }
   end_of_word_col=0
   arg_number=0
   word=''
   orig_line=line;
   for (;;) {
     if ( line:=='' ) {
       start_word_col=col
       arg_number=arg_number+1
       word=''
       return(arg_number)
     }
     if ( substr(line,1,1):=='"' ) {
        parse line with '"' word '"' +0 ch ' ' line
        word='"'word:+ch
     } else if ( arg_number  || args_to_command) {
        parse line with word ' ' line
     } else {
       i=verify(line,' /','M')   /* allow /. "c/x/y" will be accepted. */
       if ( i>1 ) {  /* i=1 means "/usr/xxxx/...." i=0 means not found. */
         word=substr(line,1,i-1)
         if ( substr(line,i,1):==' ' ) {  /* Just find a space? */
            line=substr(line,i+1)
         } else {
           line=substr(line,i)
         }
       } else {
         word=line
         line=''
       }
     }
     end_of_word_col=end_of_word_col+ length(word)+1;
     strip_word=strip(word)
     ch=substr(strip_word,1,1)
     /* don't count options or blanks. */
#if __PCDOS__
     if ( ch:=='-' || ch:=='+' || ch:=='[' || ch=='/' || strip_word:=='' ) { continue }
#else
     /* UNIX case */
     if ( ch:=='-' || ch:=='+' || ch:=='[' || strip_word:=='' ) { continue }
#endif
     arg_number=arg_number+1
     if (arg_number>=one_arg) {
        start_word_col= end_of_word_col-length(word)
        word=substr(orig_line,start_word_col)
        return(arg_number)
     } else if ( end_of_word_col>=col) {
        start_word_col= end_of_word_col-length(word)
        return(arg_number)
     }
   }


}
static void replace_word(var line,word,start_word_col,new_word)
{
  /* Will have to support */
  /* messageNwait('line=<'line'> word=<'word'> word_col=<'start_word_col'> new_word=<'new_word'>') */
  line= substr(line,1,start_word_col-1):+
        new_word:+
        substr(line,start_word_col+length(word))
}
_str f_match(_str name,int find_first)
{
   name=strip(name,'B','"')
   if ( substr(name,1,1)=='@' ) {
      name='@':+file_match('"'substr(name,2),find_first)
      if ( name=='@' ) {
         return('')
      }
   } else {
      name=file_match('"'name,find_first)
      option=''
   }
   last_char_is_filesep=last_char(name):==FILESEP
   if ( name:!='' ) {
      _arg_complete=(_arg_complete && ! last_char_is_filesep)
   }
   name=maybe_quote_filename(name)
   if ( last_char_is_filesep ) {
      name=strip(name,'T','"')
   }
   return _escape_unix_expansion(name)
}
_str w_match(name,find_first)
{
   if ( find_first ) {
      return(name)
   }
   return('')

}
_str make_buf_match(name)
{
   firstch=substr(name,1,1)
   if ( isdrive(substr(name,1,2)) || firstch==FILESEP || firstch==FILESEP2 ) {
      name=strip_filename(name,'P')'<'strip_filename(name,'N')'>'
   }
   return(name)

}
_str b_match(_str name,int find_first)
{
   name=make_buf_match(name)
   match=buf_match('',find_first)
   for (;;) {
      if ( rc ) {
         break
      }
      if ( match!='' ) {
         match=make_buf_match(match)
         if ( file_eq(substr(match,1,length(name)),name) ) {
            break
         }
      }
      match=buf_match('',0)
   }
   return(match)
/*
   if name<>'' then
      mname=absolute(name)
   else
      mname=''
   endif
   match=buf_match(mname,find_first)
   /* Don't want to list buffers with null name. */
   loop
     if match<>'' or rc then leave endif
     match=buf_match(mname,0)
   endloop
   return(match)
*/

}
_str c_match(name,find_first)
{
   return(name_name(cname_match(name,find_first,COMMAND_TYPE)));
}
_str c_help(line)
{
   return(help(line))

}
_str _object_match(name,find_first)
{
   index=name_match(name,find_first,OBJECT_TYPE)
   if (!index) {
      return('')
   }
   return(translate(name_name(index),'_','-'))
}
_str _form_match(name,find_first)
{
   for (;;) {
      index=name_match(name,find_first,OBJECT_TYPE)
      if (!index) {
         return('')
      }
      if (type2oi(name_type(index))==OI_FORM) {
         break;
      }
      find_first=0;
   }
   return(translate(name_name(index),'_','-'))
}
_str _menu_match(name,find_first)
{
   for (;;) {
      index=name_match(name,find_first,OBJECT_TYPE)
      if (!index) {
         return('')
      }
      if (type2oi(name_type(index))==OI_MENU) {
         break;
      }
      find_first=0;
   }
   return(translate(name_name(index),'_','-'))
}
_str _pic_match(name,find_first)
{
   return(name_name(name_match(name,find_first,PICTURE_TYPE)))

}
/* Match user recorded macro command */
_str k_match(name,find_first)
{
   index=cname_match(name,find_first,COMMAND_TYPE);
   for (;;) {
      if (!index) return('');
      parse name_info(index) with ',' flags;
      if (flags!='' && (flags &VSARG2_MACRO)) {
         return(name_name(index));
      }
      index=cname_match(name,0,COMMAND_TYPE);
   }
}
static int cignorecase_type;
int cname_match(name,find_first,kind)
{
   if (find_first) cignorecase_type=0;
   index=cname_match2(name,find_first,kind|cignorecase_type);
   if (!index) {
      cignorecase_type=IGNORECASE_TYPE;
      index=cname_match2(name,find_first,kind|cignorecase_type);
   }
   return(index);
}
static int cname_match2(name,find_first,kind)
{
   index=name_match(name,find_first,kind)
   for (;;) {
      if ( ! index || (! (name_type(index)&COMMAND_TYPE)) ||
         index_callable(index) ) {
         return(index);
      }
      index=name_match(name,0,kind)
   }

}
_str m_match(name,find_first)
{
   return(name_name(name_match(name,find_first,MODULE_TYPE)))

}
_str _dll_match(name,find_first)
{
   return(name_name(name_match(name,find_first,DLLMODULE_TYPE)))

}
_str v_match(name,find_first)
{
   return(translate(name_name(name_match(name,find_first,VAR_TYPE|BUFFER_TYPE)),'_','-'))

}
_str pc_match(name,find_first)
{
   return(name_name(cname_match(name,find_first,PROC_TYPE|COMMAND_TYPE)))
}
_str pc_help(line)
{
   return(help(line))

}
//static boolean doSlickCTagFile;
_str mt_match(_str name,int find_first)
{
   if (find_first) {
      if (find_first==2) {
         return(tag_match(name,find_first,"e"));
      }
      status=_e_MaybeBuildTagFile(tfindex);
      if (status) {
         messageNwait("Error building Slick-C tag file");
         return("");
      }

   } 
   return(tag_match(name,find_first,"e"));
}
_str mt_help(line)
{
   return(help(line))

}
#if 0
_str pcbNt_match(name,find_first)
{
   index=cname_match(name,find_first,PCB_TYPE)
   if ( index ) {
     return(field(name_name(index),16)  " "eq_value2name(name_type(index)& ~INFO_TYPE,HELP_TYPES))
   }
   return('')

}
_str pcbNt_help(line)
{
   return(help(line))

}
#endif
_str pcbt_match(name,find_first)
{
   return(name_eq_match(name,find_first,PCB_TYPES))


}
_str h_help(line)
{
   return(help(line))

}
_str hNt_match(name,find_first)
{
   index=cname_match(name,find_first,HELP_TYPE)
   if ( index ) {
     return(field(name_name(index),16) " "eq_value2name(name_type(index)& ~INFO_TYPE,HELP_TYPES))
   }
   return('')

}
_str hNt_help(line)
{
   return(help(line))

}
static _str cf_pass;

#if 0
_str cf_match(name,find_first)
{
   if ( find_first ) {
      cf_pass=1
   }
   name=name_eq_match(name,find_first,COLOR_FIELDS)
   if ( name!='' ) {
      return(name)
   }
   if ( cf_pass==1 ) {
      cf_pass=2
      return(name_eq_match(name,1,COLOR_FIELDS2))
   }
   return(name_eq_match(name,find_first,COLOR_FIELDS2))

}
#endif
_str ht_match(_str name,int find_first)
{
   return(name_eq_match(name,find_first,HELP_TYPES))

}
_str hc_match(_str name,int find_first)
{
   return(name_eq_match(name,find_first,HELP_CLASSES))

}
static _str eq_string;

_str name_eq_match(_str prefix_name,int find_first,_str string)
{
   if ( find_first ) {
     eq_string=lowcase(string);
   }
   prefix_name=lowcase(prefix_name);
   for (;;) {
     if ( eq_string=='' ) { return('') }
     parse eq_string with name '=' . eq_string;
     if ( substr(name,1,length(prefix_name))==prefix_name ) {
       return(lowcase(strip(name)));
     }
   }

}
_str e_match(_str name,int find_first)
{
   return(env_match(env_case(name),find_first))
}
static _str match_prefix2index(_str name_prefix,var match_flags,var multi_select, var last_arg2)
{
   last_arg2=0
   multi_select=0
   match_flags=0
   if ( pos('*',name_prefix) ) {
      multi_select=1
      name_prefix=stranslate(name_prefix,'','*')
   }
   if ( pos('!',name_prefix) ) {
      name_prefix=stranslate(name_prefix,'','!')
      last_arg2=1
   }
   parse name_prefix with name_prefix ':' match_flags
   if ( match_flags=='' ) match_flags=0
   index= find_index(name_prefix'-match',PROC_TYPE|COMMAND_TYPE)
   if ( ! index_callable(index) ) {
     _message_box(nls("Match function '%s' not found",name_prefix))
     return(0)
   }
   return(index)

}

void _UnderScoresToBottom()
{
   //place the under scores at the bottom.
   top();
   mark=_alloc_selection();
   if (mark>=0) {
      status=search('^ _','r@');
      if (!status) {
         _select_line(mark);
         status=search('^ ~_','ri@');
         if (status) {
            bottom();
         } else {
            up();
         }
         _select_line(mark);
         bottom();
         _move_to_cursor(mark);
      }
      _free_selection(mark);
   }
}
_str _list_matches2(title,flags,buttons,help_item,font,
                        callback_name,retrieve_name,completion)
{
   was_recording=_macro();
   min_list_width=arg(9);
   fast_complete=arg(10);
   initial_value=arg(11);  // Combo box initial value
   _macro_delete_line()
   orig_view_id=_create_temp_view(temp_view_id);
   if (orig_view_id=='') return(1);
   if ( title=='' ) {
     title=nls('Open Form')
   }
   if (fast_complete!='') {
      _insert_name_list fast_complete
   } else {
      parse completion with name_prefix ':' match_flags
      //match_fun_index=match_prefix2index(completion,match_flags,multi_select, last_arg2)
      match_fun_index=find_index(name_prefix'_match',PROC_TYPE);
      match_name=call_index('',1,match_fun_index);
      for (;;) {
         if (match_name=='') {
            break;
         }
         _lbadd_item(match_name);
         match_name=call_index('',0,match_fun_index);
      }
      if (match_flags==''){
         match_flags=0;
      }
      if ( match_flags & TERMINATE_MATCH ) {
         call_index('',2,match_fun_index)
      }
      top();
   }
   activate_view orig_view_id
   result=show('_sellist_form -hidden -reinit',
            title,
            flags,
            temp_view_id,
            buttons,
            help_item, // help item name
            '',              // font
            callback_name,   // Call back function
            '',              // Item separator for list_data
            retrieve_name,   // Retrieve form name
            completion,      // Combo box. Completion property value.
            min_list_width,  // minimum list width
            initial_value
           )
   if (result<0) return(result);
   p_window_id=result;
   if (flags&SL_MATCHCASE) {
      p_window_id=_control _sellist;
      _lbsort('e');
      _UnderScoresToBottom();
      p_window_id=result;
   } else {
      _sellist._lbsort();
   }
   _sellist._lbtop();
   _sellistcombo._set_sel(1,length(_sellistcombo.p_text)+1);
   if (flags & SL_SELECTPREFIXMATCH) {
      _sellistcombo.call_event(_sellistcombo,ON_CHANGE);
   }
   p_active_form.p_visible=1;
   result=_modal_wait(result)
   if (result=='') {
      activate_view(orig_view_id);
      return('');
   }
   activate_view(orig_view_id);
   _macro('m',was_recording)
   _macro_call(retrieve_name,result)
   return(result)
}

   static int help_proc_index;

/*
   INPUT
    1  name                   Prefix string to match
    2  function_name_prefix   One ????_ARG constants defined in slick.sh
                              OR index of find first/next function
    3                         Title of popup-window
    4                         If Not '', allow multiple selections
                              This argument is here for backward compatibility
    5                         Name of help function to call
    6                         Auto select if 1 match
    7                         Non-zero of fall through function should
                              provide popup-help when ENTER key is pressed.
*/
_str list_matches(name,match_fun_index)
{
   cmdline_active= (_cmdline==p_window_id);
   last_arg2=0
   match_flags=0
   if ( ! isinteger(match_fun_index) ) {
      match_fun_index=match_prefix2index(match_fun_index,match_flags,multi_select, last_arg2)
      if ( ! match_fun_index ) {
         return('')
      }
   }
   if (match_flags & FILE_CASE_MATCH) {
      name=_unix_expansion(name);
   }
   if ( arg(4)!='' ) {
      multi_select=arg(4)
   }
   if ( ! multi_select ) {
      multi_select=0
   } else {
      multi_select=SL_ALLOWMULTISELECT|SL_SELECTALL
   }
   orig_view_id=_create_temp_view(temp_view_id)
   if ( orig_view_id=='') {
      return('')
   }
   // multi_select not support yet for dialog boxes because
   // of interpreter string length limit.
   if (multi_select && orig_view_id!=_cmdline) {
      multi_select=0;
   }
   if ( name=='' ) { message nls('Building selection list...') }
   match_name=call_index(name,1,match_fun_index)
   if ( match_name=='' ) {
      if ( match_flags & TERMINATE_MATCH ) {
         call_index('',2,match_fun_index)
      }
      _delete_buffer;_quit_view
      if ( name=='' ) { clear_message }
      activate_view orig_view_id
      return''
   }
   title=arg(3)
   if ( title=='' ) {
     title=nls('Select a Command Parameter')
   }
   buttons=nls('&Select')  //  ,&Print')  Can't print just yet.
   help_proc_index=0
   if ( arg(5)!='' ) {  /* help function given? */
      help_proc_index=find_index(arg(5),PROC_TYPE)
   } else {
      i=pos('-',name_name(match_fun_index))
      if ( i ) {
         help_proc=substr(name_name(match_fun_index),1,i)'help'
         help_proc_index=find_index(help_proc,PROC_TYPE)
      }
   }
   if ( help_proc_index ) {
      if ( !index_callable(help_proc_index) ) {
         help_proc_index=0
      }
   }
   width=0
   for (;;) {
     if ( match_name=='' ) { break }
     insert_line ' 'match_name
     if ( length(match_name)>width ) { width=length(match_name) }
     match_name=call_index(name,0,match_fun_index)
   }
   if ( match_flags & TERMINATE_MATCH ) {
      call_index('',2,match_fun_index)
   }
   top; /* get rid of the blank line */
   if ( ! (match_flags & NO_SORT_MATCH) && 
        !((SMALLSORT_MATCH & match_flags) && p_Noflines>500)) {
      case_sense='i';
      if (match_flags & FILE_CASE_MATCH) {
         case_sense=_fpos_case
      }
      sort_buffer(case_sense)
   }
   if ( match_flags & REMOVE_DUPS_MATCH ) {
      _remove_duplicates()
   }
   clear_message
   get_line result
   if ( p_Noflines==1 && (arg(6)!='' ||
       ((match_flags&AUTO_DIR_MATCH) && last_char(result):==FILESEP))  ) {
      _delete_buffer;_quit_view
   } else {
      activate_view(orig_view_id);
      orig_wid=p_window_id;
      wid=show('_sellist_form -new -reinit',
                  title,
                  SL_VIEWID|SL_SELECTCLINE|SL_HELPCALLBACK|multi_select,
                  temp_view_id,
                  buttons,
                  (help_proc_index)?'1':'',  // help item
                  '',                   // font
                  clist_fall_through  // Call back function
                 );
      if (cmdline_active) {
         _cmdline.p_visible=1;
      }
      result=_modal_wait(wid);
      // We will assume that the form is edited if '' is returned.
      // We want the edited form to be the active window so
      // we will not change the active window.
      if (result!='' && _iswindow_valid(orig_wid)) {
         p_window_id=orig_wid;
      }
   }
   activate_view orig_view_id;_set_focus();
   _arg_complete=1
   if ( (!multi_select || substr(result,1,1)!='@') &&
      ! (match_flags & TERMINATE_MATCH) ) {
      /* Can't handle completion function that require third call. */
      /* This means that I must assume that all arguments to these */
      /* completion functions require no more typing. */
      /* Not @$list.slk case */
      line=result
      for (;;) {
         word=parse_file(line)
         if ( word=='' ) {
            break
         }
         match_name=call_index(word,1,match_fun_index)
#if 0
         if ( match_name!=word ) {
            _arg_complete=0
         }
#endif
      }
   }
   _arg_complete=_arg_complete && last_arg2
   return strip(result,'L')    /* remove leading space */

}
static _str clist_fall_through(reason,var result,key)
{
   if (reason==SL_ONUSERBUTTON) {
      switch (key) {
      case 3:
         text=_sellist._lbget_text();
         if (text=='') {
            return('');
         }
         call_index(text,help_proc_index);
      }
   }
   return('');
}
void _remove_duplicates()
{
   ignore_case=arg(1)=='I';
   top();
   get_line(previous_line);
   if (ignore_case) {
      for (;;) {
         down();
         if ( rc ) {
            break;
         }
         get_line(line);
         if (!stricmp(line,previous_line)) {
            up();_delete_line();
         }
         previous_line=line;
      }
   } else {
      for (;;) {
         down();
         if ( rc ) {
            break;
         }
         get_line(line);
         if ( line:==previous_line ) {
            up();_delete_line();
         }
         previous_line=line;
      }
   }
}
static void expand_word(line,word,start_word_col,fun_name_prefix,command_case)
{
   match_fun_index=match_prefix2index(fun_name_prefix,match_flags,multi_select, last_arg2);
   if ( ! match_fun_index ) {
      return;
   }
   strip_word=strip(word);
   if ( command_case ) {
      strip_word=name_case(strip_word);
   }
   old_wid=p_window_id;
   p_window_id=_edit_window();
   _arg_complete=1;

   if (match_flags & FILE_CASE_MATCH) {
      strip_word=_unix_expansion(strip_word);
   }
   if ( command_case && (find_index(strip_word,COMMAND_TYPE) ||
       find_index(strip_word,COMMAND_TYPE|IGNORECASE_TYPE))) {
      name=strip_word;
   } else {
      name=call_index(strip_word,1,match_fun_index);
      shortest_name=name;
      number_found=0;
      exact_match=0;
      if (name!='' && (match_flags & FILE_CASE_MATCH) && iswildcard(strip_word)) {
         name=strip_word;
      }
   }
   lenp1=length(strip_word)+1;
   dquote_ch='';
   if (substr(strip_word,1,1)=='"') {
      dquote_ch='"';
   }
   if (name!='' && substr(name,1,1)!='"') {
      name=dquote_ch:+name;
   }
   if (shortest_name!='' && substr(shortest_name,1,1)!='"') {
      shortest_name=dquote_ch:+shortest_name;
   }
   do_upcase=(match_flags & FILE_CASE_MATCH) && _fpos_case=='I';
   for (;;) {
      if (do_upcase) {
         if ( !stricmp(name,strip_word) ) {
            shortest_name=name;
            exact_match=1;
            break;
         }
      } else if ( name:==strip_word ) {
         shortest_name=name;
         exact_match=1;
         break;
      }
      if ( name=='' ) break;
      number_found=number_found+1;

      ch1=substr(shortest_name,1,1);
      ch2=substr(name,1,1);
      if ( ch1=='"' && ch2:!='"' ) {
         name='"'name;
      } else if ( ch2=='"' && ch1:!='"' ) {
         shortest_name='"'shortest_name;
      }
      
      if ( length(name)<length(shortest_name) ) {
        temp=name;
        name=shortest_name;
        shortest_name=temp;
      }
      tname=shortest_name;
      if ( do_upcase ) {
         tname=upcase(tname)
         name=upcase(name)
      }
      for (i=lenp1; i<=length(shortest_name) ; ++i) {
         if ( substr(tname,i,1):!=substr(name,i,1) ) {
            shortest_name=substr(shortest_name,1,i-1);
            if (shortest_name:!="" && !_dbcsStartOfDBCS(shortest_name,length(shortest_name))) {
                shortest_name=substr(shortest_name,1,length(shortest_name)-1);
            }
            break
         }
      }
      name=call_index(strip_word,0,match_fun_index)
      if (name!='' && substr(name,1,1)!='"') {
         name=dquote_ch:+name;
      }
   }
   if (substr(shortest_name,1,1)=='"' && substr(strip_word,1,1)!='"') {
      strip_word='"'strip_word;
   }
   if ( match_flags & TERMINATE_MATCH ) {
      call_index('',2,match_fun_index)
   }
   p_window_id=old_wid;
   /* messageNwait('sh=<'shortest_name'> fun_name='name_name(match_fun_index)' exact_match='exact_match) */
   /* directory files are deceptive.  Don't count them */
   exact_match= (number_found==1 &&
                   _arg_complete) || exact_match;
   /*
      There are still some problems with doing file completion
      in dialogs which do recursive file matching. The following
      case still will confuse a user:
       
         *  User presses space for recursive file match in
            make tags dialog, no wildcard, and a longer
            match occurs in the current directory.
            User must press right arrow to avoid completion.
            
      Possible solutions
         
         *  Turn off completion when doing recursive file
            matching.  
            This is not great because user may want to complete
            a directory name.
         *  Change completion key to shift+space.
            Could require semicolon file separator. 
            
            This works but most users will never known
            shift+space does completion.
         *  Do a recursive file match.  This works but the
            performance could be very slow.
            
      None of these solutions are any better than what we
      have.      

   */
   if (name_name(match_fun_index)=='f-match' && iswildcard(strip_word)) {
      if ( shortest_name=='' ) {
         //message(nls('Match not found'));
      }
      exact_match=1;
      shortest_name='"'strip(strip_word,'B','"')'"';
   } else if (substr(strip_word,1,1)=='"' && substr(shortest_name,1,1)!='"') {
      shortest_name='"'shortest_name;
   }
   if ( ! exact_match && length(strip_word)>=length(shortest_name) ) {
      if ( command_case ) {
#if 0
        if ( find_index(strip_word,VAR_TYPE|GVAR_TYPE) ) {
           keyin_char()
           return ''
        }
#endif
        if ( last_event():==' ' ) {
           _beep();
           message(nls('Command expanded as much as possible.  Hit space again to force insert.'));
           k=get_event();
           if ( k:==' ' ) {
              keyin_char();
              clear_message();
           } else {
              call_key(k);
           }
        }
        return;
      } else {
         if ( shortest_name=='' ) {
            // IF we are doing file match and user input starts this double quote
            if (name_name(match_fun_index)=='f-match' && substr(strip_word,1,1)=='"') {
               shortest_name=strip_word' ';
               exact_match=1
               //keyin_char();
            } else {
               _beep();
               message(nls('Match not found'));
               return;
            }
         } else {
            word_expanded_as_much_as_possible=1;
            // IF we are doing file match and user input starts this double quote
            if (name_name(match_fun_index)=='f-match' && substr(strip_word,1,1)=='"' &&
                length(shortest_name)<=length(strip_word)) {
               //say('strip_word='strip_word);
               word_expanded_as_much_as_possible=0;
            // IF there is NOT a file with this name + a space
            } else if (name_name(match_fun_index)=='f-match' && !iswildcard(strip_word) &&
                file_match(maybe_quote_filename(strip(strip_word,'B','"')' '),1):!=""
                ) {
               word_expanded_as_much_as_possible=0;
            } else if (name_name(match_fun_index)=='f-match' && iswildcard(strip_word)) {
               word_expanded_as_much_as_possible=0;
            } else if (match_flags & ONE_ARG_MATCH) {
               p_window_id=_edit_window()
               name=call_index(strip_word' ',1,match_fun_index)
               if ( match_flags & TERMINATE_MATCH ) {
                  call_index('',2,match_fun_index)
               }
               word_expanded_as_much_as_possible=(name=='');
               p_window_id=old_wid;
            }
            if (word_expanded_as_much_as_possible) {
               _beep();
               message(nls('Word expanded as much as possible'));
               return;
            }
            shortest_name=strip_word
            exact_match=1
         }
      }
   }
   col=start_word_col+length(shortest_name);
   if ( exact_match==1 ) {
      col=col+1
   }
   replace_word(line,word,start_word_col,shortest_name);
   set_command(line,col);
}
static _str find_match_fun(line,arg_number,var match_fun_name /*,keep_star,info*/)
{
   if ( arg()>4 ) {
      info=arg(5)
      get_number=0
   } else {
      parse line with command .
      command=strip(command)
      index=find_index(command,COMMAND_TYPE);
      if (!index) {
         index=find_index(command,COMMAND_TYPE|IGNORECASE_TYPE);
      }
      parse name_info(index) with info ','
      get_number=1
   }
   if ( info=='' ) {
     /* This command does not indicate its argument types. */
     return(1)
   }
   for (;;) {
     if ( info=='' ) { break }
     parse info with type info
     get_number=get_number+1
     if ( pos('*',type) ) { /* Multiples or more */
        if ( type=='*' ) {  /* More? */
           return(2)
        }
        arg_number=-1;
        if ( arg(4)=='' ) {
           type=stranslate(type,'','*')
        }
        break
     }
     if ( get_number>=arg_number ) {
        break
     }
   }
   if ( get_number<arg_number ) {
     /* This command does not indicate this argument type. */
     return(2)
   }
   if ( info=='' ) {
      type=type:+'!'
   }
   if ( arg(4)=='' ) {
      type=stranslate(type,'','!')
   }
   match_fun_name=type
   return(0)

}
/*
    This macro expands $envvar and ~ like a UNIX shell.
    tilde followed by a user name is not yet supported.

    Use \~ to escape tilde
    Use \$ to escape $ expansion
    Use \\ to escape \

      \ not followed by $, ~, or \ represents a backslash


    NOTE:  The algorithm used here is sligly different that a UNIX shell.
           No special processing is done when tilde or $ is found in a
           single or double quoted string.

*/
    struct PASSWD {
        _str pw_name;       /* user name */
        _str pw_passwd;     /* user password */
        int  pw_uid;        /* user id */
        int  pw_gid;        /* group id */
        _str pw_gecos;      /* real name */
        _str pw_dir;        /* home directory */
        _str pw_shell;      /* shell program */
    };
_str _unix_expansion(cmdline /*,do_expansion */)
{
   if (arg()<=1) {
      if ( ! def_unix_expansion ) {
         return(cmdline);
      }
   } else {
      if (!arg(2)) {
         return(cmdline);
      }
   }
   i=1;
   env_wordchars='a-zA-Z_0-9';
   username_wordchars='a-zA-Z_0-9';
   result='';
   for (;;) {
      j=pos('[$~\\]',cmdline,i,'r')
      if ( ! j ) {
         j=length(cmdline)+1
         result=result :+ substr(cmdline,i,j-i)
         return(result)
      }
      //messageNwait("_unix_expansion: cmdline="cmdline" j="j " x="pos('S'));
      result=result :+ substr(cmdline,i,j-i)
      ch=substr(cmdline,pos('S'),pos(''))
      string=ch
      //messageNwait("_unix_expansion: ch="ch);
      if ( ch=='$' ) {
         k=pos('[~'env_wordchars']',cmdline,j+1,'r');
         if ( ! k ) {
            k=length(cmdline)+1
         }
         name=substr(cmdline,j+1,k-j-1);
         if ( length(name) ) {
            string=get_env(name)
         }
         j=k-1
      } else if ( ch=='~' ) {
         k=pos('[~'username_wordchars']',cmdline,j+1,'r');
         if ( ! k ) {
            k=length(cmdline)+1;
         }
         username=substr(cmdline,j+1,k-j-1);
         //messageNwait("_unix_expansion: username="username);
         if ( length(username) ) {
            PASSWD passwd;
            status=_getpwnam(username,passwd);
            //messageNwait("_unix_expansion: status="status" passwd.pw_dir="passwd.pw_dir);
            if (status) {
               string="~"username;
            }
            string=passwd.pw_dir;
         } else {
            string=get_env('HOME');
         }
         j=k-1;
      } else if ( ch=='\' ) {
         next_ch=substr(cmdline,j+1,1);
         if ( next_ch:=='~' || next_ch:=='$' || next_ch:=='\' ) {
            string=next_ch
            j=j+1;
         }
      }
      result=result:+string
      i=j+1
   }

}
_str _escape_unix_expansion(_str cmdline)
{
   if (arg()<=1) {
      if ( ! def_unix_expansion ) {
         return(cmdline);
      }
   } else {
      if (!arg(2)) {
         return(cmdline);
      }
   }
   i=1
   result='';
   for (;;) {
      j=pos('[$~\\]',cmdline,i,'r')
      if ( ! j ) {
         j=length(cmdline)+1
         result=result :+ substr(cmdline,i,j-i)
         return(result)
      }
      result=result :+ substr(cmdline,i,j-i)
      ch=substr(cmdline,pos('S'),pos(''))
      string='\'ch
      result=result:+string
      i=j+1
   }

}
_str _maybe_unix_expansion(cmdline  /*,completion_info*/)
{
   second_arg_present=arg()>1
   completion_info='';
   if ( isalpha(substr(cmdline,1,1)) && ! second_arg_present ) {
      parse cmdline with command .
      index=find_index(command,COMMAND_TYPE);
      if (!index) {
         index=find_index(command,COMMAND_TYPE|IGNORECASE_TYPE);
      }
      if ( index ) {
         parse name_info(index) with completion_info ','
      }
   }
   parse completion_info with ':' match_flags '[!*]','r'
   if ( isinteger(match_flags) && (match_flags &FILE_CASE_MATCH) ) {
      return(_unix_expansion(cmdline));
   }
   return(cmdline);
}
