/*
$VerboseHistory: diff.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:32a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:30a
 * Comment:
 * Added support for some more key bindings in the
 * Difference Editor.
 * Changed diff dialog to be attatched to the desktop so it
 * can fall behind the MDI frame.
 * Fixed bug where undo in difference editor erroneously
 * prompted to undo past save.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:25p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
#include 'diff.sh'
static int bMatches[];
static int ToolBoxWID
static _str diff_form_size;
_command cua_select();
DiffUpdateColorInfo(int,int,int,int,int);
//   DiffUpdateInfo.timer_handle=-1;
static boolean gignore_change;

int def_max_fast_diff_size=800;
//Will try to diff concurrent process buffer

_str def_max_diffhist='10 10 10 10';

static void diff_init(int id,int OtherWid
                      /*int vid,int id,int OtherViewId, _str OtherFilename*/)
{
   top();
   p_buser=p_color_flags;
   p_color_flags|=MODIFY_COLOR_FLAG;
}
static int maybe_load_dll()
{
   index=find_index('Diff',PROC_TYPE);
   if (!index) {
      filename=slick_path_search(DIFF_DLLNAME);
      if (filename=='') return(FILE_NOT_FOUND_RC);
      return(dload(filename));
   }
   return(0);
}

static boolean file_exists(filename,...)
{
   /*hidden='';
   if (isinteger(arg(2))) {
      hidden='h';
   } */
   hidden='h';
   filename=strip(filename,'b','"');
   doAbsolute=true;
   if (isinteger(arg(3))) {
      doAbsolute=arg(3);
   }
   afilename=filename;
   if (doAbsolute) {
      afilename=absolute(afilename);
   }
   if (p_active_form.p_name=='_diffsetup_form') {
      if ((p_next.p_next.p_next.p_next.p_next.p_value && buf_match(afilename,1,'E')=='') ||
          (p_next.p_next.p_next.p_next.p_value && file_match(maybe_quote_filename(afilename)' +d -p',1)=='') ) {
         if (substr(afilename,1,2)=='\\' && last_char(afilename)!=FILESEP) {
            //This is a UNC name, could be a UNC ROOT...
            afilename=afilename:+FILESEP:+ALLFILES_RE;
            first_file_name=file_match(maybe_quote_filename(afilename)' +d -p',1)
            return(first_file_name!='');
         }
         return(0);
      }
   }else{
      if (buf_match(afilename,1,'E':+hidden)=='' && file_match(maybe_quote_filename(filename)' -D -P',1)=='')  {
         return(0);
      }
   }
   return(1);
}

static int CheckModifyStatus(_str Filename)
{
   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   OldFilename=p_buf_name;
   status=load_files('+q +b 'Filename);
   if (status) {
      p_view_id=orig_view_id;
      return(1);//File not open, need to load from disk
   }
   rv=p_modify;
   status=load_files('+b 'OldFilename);
   p_view_id=orig_view_id;
   return(rv);
}

/*static void myset_focus(wid)
{
   wid._set_focus();
}
*/

_control _ctlfile1,_ctlfile1label,_ctlfile2,_ctlfile2label,vscroll1,\
         _ctlcopy_right_all,hscroll1,_ctlfile1_readonly,_ctlfile2_readonly;

static int CheckForDifferentEOLChars(int ViewId1,int ViewId2,int &flags)
{
   orig_view_id=p_view_id;
   p_view_id=ViewId1;
   EOL1=p_newline;
   p_view_id=ViewId2;
   EOL2=p_newline;
   p_view_id=orig_view_id;
   if (EOL1!=EOL2/* && !def_smart_diff*/) {
      result=_message_box(nls("These files have different End Of Line(EOL) characters.\n\nWould you like to diff them without comparing EOL Characters?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDCANCEL) return(COMMAND_CANCELLED_RC);
      if (result==IDYES) {
         flags|=DIFF_DONT_COMPARE_EOL_CHARS;
      }
   }
   return(0);
}

//Duplicated in diffedit.e
static void BlastUndoInfo()
{
   old=p_undo_steps;
   p_undo_steps=0;
   p_undo_steps=old;
}

struct DIFF_SETUP_INFO {
   _str path1;             //Just a path if using MFDiff
   _str path2;
   _str filespec;          //'' if not using mutlti-file diff
   _str excludeFilespec;   //'' if not using mutlti-file diff
   boolean recursive;      //Only matters if using mutlti-file diff
   boolean smartDiff;      //Only matters if NOT USING mutlti-file diff...Probably won't matter at all
   boolean interleaved;    //Only matters if NOT USING mutlti-file diff
   int recordWidth;        //Only matters if NOT USING mutlti-file diff
   boolean file1IsFile;    //Only matters if NOT USING mutlti-file diff
   boolean file2IsFile;    //Only matters if NOT USING mutlti-file diff
   boolean buf1;           //Only matters if NOT USING mutlti-file diff
   boolean buf2;           //Only matters if NOT USING mutlti-file diff
   boolean spawnProcess;   //If using mutlti-file diff launch separate copy
}


static void InitDiffSetupStruct(DIFF_SETUP_INFO *psetupInfo)
{
   psetupInfo->path1='';
   psetupInfo->path2='';
   psetupInfo->filespec='';
   psetupInfo->excludeFilespec='';
   psetupInfo->recursive=false;
   psetupInfo->smartDiff=false;
   psetupInfo->interleaved=false;
   psetupInfo->recordWidth=0;
   psetupInfo->file1IsFile=false;
   psetupInfo->file2IsFile=false;
   psetupInfo->spawnProcess=false;
}

static boolean gCancel=0;

//Now dup'd in diff.e and diffedit.e
static int GetOtherWid(int &wid)
{
   wid=p_window_id;
   if (wid==_ctlfile1) {
      otherwid=_ctlfile2;
   }else{
      otherwid=_ctlfile1;
   }
   return(otherwid);
}

static void maybe_show_all()
{
   if (p_Nofhidden) {
      show_all();
      //Just line them back up together.  I was not able to reproduce this,but
      //Clark and I saw some peculiarities 10:47am 4/4/1996
      otherwid=GetOtherWid(wid)
      //3:30pm 6/11/1997:
      //Changed this so that it should work for either file
      otherwid.set_scroll_pos(wid.p_left_edge,wid.p_cursor_y);
   }
}

#define DiffParentWID _ctlcopy_right.p_user

//These 2 #defines are duplicated in diffedit.e
#define gBuf1StartTime _ctlcopy_right_line.p_user
#define gBuf2StartTime _ctlcopy_right_all.p_user

/*
Command line options:
   -i                   - interleaved output
   -r1                  - make file 1 read only
   -r2                  - make file 2 read only
   -q                   - quiet option:only shuts off the "Files match" message
   -modal               - run diff modally
   -B1                  - filename1 is a buffer name and should be loaded +b w/o absolute
   -B2                  - filename2 is a buffer name and should be loaded +b w/o absolute
   
  The options below are intended only to be used to implement
  asynchronous diffs which invoke another copy of the editor.
  
   -optionflags <flags> - set def_diff_options to flags
   -filespec <filespecs> - use this list of filespecs for multi file diff
                          MUST BE DELIMITED BY ASCII 1'S!!! EX:
                          -filespec *.c *.h
   -excludefilespec <excludefilespec> - use this list of excludefilespecs for multi file diff
                          MUST BE DELIMITED BY ASCII 1'S!!! EX:
                          -excludefilespec *.c *.h
   -recursive            - recurse subdirectories(multi-file only)
   -loadstate <diffstatefilename> - Load the previously saved diff output
                                    specified
*/
_command int diff(...) name_info(FILE_ARG'*,')
{
   //say('*******************************************************************************');
   index=find_index('Diff',PROC_TYPE)
   if (!index || !index_callable(index)) {
      _message_box("vsvcs.dll not loaded");
      return(1);
   }
   if (p_window_id==_mdi) {
      p_window_id=_mdi.p_child;
   }
   was_recording=_macro();
   _macro_delete_line();
   filename1='';filename2='';TwoTiles=have_two_matched_tiles();
   int file1inmem=1,file2inmem=1;
   _str file1disk='',file2disk='';
   gauge_form_wid=0;gauge_wid=0;
   diff_form_wid=0;
   OutputBufId=0;
   ReadOnly1=0;ReadOnly2=0;
   Buf1=Buf2=0;
   modal=0;
   temp='';

   file1trydisk=file2trydisk=0;NumOutputBuffers=0;
   File2Size=0;
   if (!_no_child_windows()) {
      if (TwoTiles) {
         GetFilenamesFrom2Windows(filename1,filename2);
      }else{
         filename1=p_buf_name;
      }
   }
   interleaved_flag=0;
   quiet=0;
   DIFF_SETUP_INFO setupInfo;
   setupInfo._makeempty();
   InitDiffSetupStruct(&setupInfo);
   usesmartdiff=def_smart_diff;
   int ParentWIDToRegister=0;
   if (arg(1)=='') {
      _macro('m',was_recording);
      result=show('-modal _diffsetup_form',filename1,filename2,"",&setupInfo);
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      if (isdirectory(setupInfo.path1)) {
         refresh();
         SaveDiffMapInfo(setupInfo.path1,setupInfo.path2,
                         setupInfo.filespec,setupInfo.excludeFilespec);
         return(MFDiff(&setupInfo));
      }
      filename1=strip(setupInfo.path1);
      filename2=strip(setupInfo.path2);
      bufwidth=setupInfo.recordWidth;
      file1trydisk=setupInfo.file1IsFile;
      file2trydisk=setupInfo.file2IsFile;
      interleaved_flag=setupInfo.interleaved;
      usesmartdiff=setupInfo.smartDiff;
      Buf1=setupInfo.buf1;
      Buf2=setupInfo.buf2;

      if (isdirectory(filename2)) {
         if (last_char(filename2)!=FILESEP) filename2=filename2:+FILESEP;
         filename2=filename2:+strip_filename(filename1,'p');
      }
   }else{
      bufwidth=0;
      recursive=0;
      arg1=arg(1);
      int VerifyMFDInput=0;
      _str filespec='',excludeFilespec='';
      for (;;) {
         filename1=parse_file(arg1);
         if (substr(filename1,1,1)!='-') break;
         option=lowcase(substr(filename1,2));
         //If we hit these options, we assume VC diff!
         if (option=='r1') {
            ReadOnly1=1;
         }else if (option=='r2') {
            ReadOnly2=1;
         }else if (option=='q') {
            quiet=1;
         }else if (option=='i') {
            interleaved_flag=DIFF_OUTPUT_INTERLEAVED;
         }else if (option=='modal') {
            modal=1;
         }else if (option=='b1') {
            Buf1=1;
         }else if (option=='b2') {
            Buf2=1;
         }else if (option=='optionflags') {
            ops=parse_file(arg1);
            if (isinteger(ops)) {
               diff_options=def_diff_options=ops;
            }
         }else if (option=='filespec') {
            parse arg1 with "" filespec "" arg1;
         }else if (option=='excludefilespec') {
            parse arg1 with "" excludeFilespec "" arg1;
         }else if (option=='recursive') {
            recursive=1;
         }else if (option=='loadstate') {
            stateFilename=parse_file(arg1);
            LoadDiffStateFile(stateFilename);
            return(0);
         }else if (option=='verifymfd') {
            VerifyMFDInput=1;
         }else if (option=='registerasmfdchild') {
            ParentWIDToRegister=parse_file(arg1);
         }
      }
      filename2=parse_file(arg1);

      if (filespec!='') {
         //Multi file diff....
         //filename1,filename2 are really paths

         if (!VerifyMFDInput) {
            //9:02am 6/17/1998
            //This info should have already been verified by the dialog
            status=VerifyMultiFileDiffInput(filename1,filename2,filespec,excludeFilespec);
            if (status) {
               return(DisplayMFDiffErrorMessage(status));
            }
         }

         //filename1,filename2 are really paths
         DIFF_SETUP_INFO setupInfo;
         setupInfo._makeempty();
         InitDiffSetupStruct(&setupInfo);
         setupInfo.path1=filename1;
         setupInfo.path2=filename2;
         setupInfo.filespec=filespec;
         setupInfo.excludeFilespec=excludeFilespec;
         setupInfo.recursive=recursive;
         SaveDiffMapInfo(filename1,filename2,
                         setupInfo.filespec,setupInfo.excludeFilespec);
         return(MFDiff(&setupInfo));
      }else{
         //This is a hack to make comparing to files w/the same name a little
         //easier 9:26am 6/17/1996
         int ValidUNCRoot=0;
         if (isunc_root(filename2)) {
            temp=filename2;
            if (last_char(filename2)!=FILESEP) {
               temp=temp:+FILESEP'*';
               name=file_match(temp' +p',1);
               if (name!='') ValidUNCRoot=1;
            }
         }
         if (last_char(filename2)==FILESEP ||
             file_eq( file_match(filename2' -p +d',1),filename2:+FILESEP) ) {
            if (last_char(filename2)!=FILESEP) {
               filename2=filename2:+FILESEP;
            }
            filename2=filename2:+strip_filename(filename1,'p');
         }
         if (filename1=='.process' || filename2=='.process') {
            _message_box(nls("Cannot diff buffer '.process'"));
            return(1);
         }
         //We pass in modal because modal means that we have a VC diff,
         //which means that we want to include buffers with the hidden flag
         //in our search
         if (!file_exists(filename1,modal,!Buf1)) {
            _message_box(nls("File '%s' does not exist.",filename1));
            return(FILE_NOT_FOUND_RC);
         }
         if (!file_exists(filename2,modal,!Buf2)) {
            _message_box(nls("File %s does not exist.",filename2));
            return(FILE_NOT_FOUND_RC);
         }
      }
   }
   SaveDiffMapInfo(filename1,filename2,
                   setupInfo.filespec,setupInfo.excludeFilespec);
   diff_options=def_diff_options;
   flags=diff_options|interleaved_flag;
   //Be sure that filenames have double quotes if necessary
   if (!Buf1) {
      filename1=absolute(filename1);
   }
   if (!Buf2) {
      filename2=absolute(filename2);
   }
   if (file1trydisk/*&&CheckModifyStatus(filename1)*/ && !Buf1) {
      file1disk='+d';
   }else{
     file1disk='';
   }
   if (file2trydisk/*&&CheckModifyStatus(filename2)*/ && !Buf2) {
      file2disk='+d';
   }else{
      file2disk='';
   }
   orig_view_id=p_view_id;
   if (flags&DIFF_OUTPUT_INTERLEAVED) {
      status=GetFileHidden(filename1,ViewId1,orig_view_id,file1inmem,file1disk);
      if (status) {
         _message_box(nls("Could not open file '%s'.\n\n%s",filename1,get_message(status)));
      }
      status=GetFileHidden(filename2,ViewId2,orig_view_id,file2inmem,file2disk,File2Size);
      p_view_id=orig_view_id;
      if (status) {
         _message_box(nls("Could not open file '%s'.\n\n%s",filename2,get_message(status)));
      }
   }else{
      parse buf_match(filename1,1,'xv') with buf_id .;
      if (buf_id!="" && _isdiffed(buf_id)) {
         _message_box(nls("You cannot diff the file '%s' because it is already being diffed.",filename1));
         return(1);//Thought about returning ACCESS_DENIED_RC
      }
      parse buf_match(filename2,1,'xv') with buf_id .;
      if (buf_id!="" && _isdiffed(buf_id)) {
         _message_box(nls("You cannot diff the file '%s' because it is already being diffed.",filename2));
         return(1);
      }
      name1=filename1'('((file1disk==''&&file1inmem)?"Buffer":"File")')';
      name2=filename2'('((file2disk==''&&file2inmem)?"Buffer":"File")')';
      parent_option=(machine()=='OS2386')?'-mdi':'-desktop';
      diff_form_wid=show(parent_option' -xy -hidden -new  _diff_form',name1,name2);
      if (def_keys=='') {//SlickEdit emulation
         _nocheck _control _ctlundo;
         diff_form_wid._ctlundo.p_caption='Undo';
      }
      diff_form_wid._ctlfile1.p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG|OVERRIDE_CURLINE_COLOR_WFLAG);
      diff_form_wid._ctlfile1.p_window_flags&=~(CURLINE_COLOR_WFLAG);
      diff_form_wid._ctlfile2.p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG|OVERRIDE_CURLINE_COLOR_WFLAG);
      diff_form_wid._ctlfile2.p_window_flags&=~(CURLINE_COLOR_WFLAG);
      _nocheck _control _ctlcopy_right;
      diff_form_wid._ctlcopy_right.p_user=ParentWIDToRegister;
      Wid1=diff_form_wid._ctlfile1;
      Wid2=diff_form_wid._ctlfile2;

      nowindow=lowcase(def_one_file=='+w')?'-w':'';
      diff_form_wid._ctlfile1._delete_buffer();
      status=1;
      bufwidthstr=bufwidth?'+'bufwidth:'';
      if (file1disk=='') {
         parse filename1 with '<' bufid '>';
         if (bufid!='') {
            status=diff_form_wid._ctlfile1.load_files(def_load_options' 'bufwidthstr' +q +bi 'bufid);
         }else{
            status=diff_form_wid._ctlfile1.load_files(def_load_options' 'bufwidthstr' +q +b 'strip(filename1,'B','"'));
         }
      }
      temp=filename1;
      if (status) {
         file1inmem=0;
         temp=file1disk' 'maybe_quote_filename(filename1);
         status=diff_form_wid._ctlfile1.load_files(def_load_options' 'bufwidthstr' 'nowindow' 'temp);
         diff_form_wid._ctlfile1.p_buf_flags=HIDE_BUFFER;
         if (status) return status;
      }
      /*
      3:33pm 7/31/1998
      Nasty little problem here:  If we are diffing a file and a buffer, we
      will be doing a load_files +b on this same name later, so to be sure
      that we don't get this buffer by accident, we will append a filesep to
      the buffer name so that it doesn't get loaded by accident
      */
      diff_form_wid._ctlfile1.p_buf_name=diff_form_wid._ctlfile1.p_buf_name:+FILESEP;

      diff_form_wid._ctlfile1.top();diff_form_wid._ctlfile1.up();
      if (file1inmem){
         while (!diff_form_wid._ctlfile1.down()) {
            diff_form_wid._ctlfile1._lineflags(0,MODIFY_LF);
            diff_form_wid._ctlfile1._lineflags(0,INSERTED_LINE_LF);
         }
      }
      diff_form_wid._ctlfile1.p_user=diff_form_wid._ctlfile1.p_buf_id' 'file1inmem' 'diff_form_wid._ctlfile1.p_readonly_mode;
      diff_form_wid._ctlfile1_readonly.p_value=(int)(diff_form_wid._ctlfile1.p_readonly_mode||ReadOnly1);
      diff_form_wid._ctlfile1.p_ProtectReadOnlyMode=(diff_form_wid._ctlfile1_readonly.p_value)?VSPROTECTREADONLYMODE_ALWAYS:VSPROTECTREADONLYMODE_NEVER;
      diff_form_wid._ctlfile1_readonly.p_enabled=!diff_form_wid._ctlfile1_readonly.p_value;
      ext=_bufname2ext(filename1);
      if (ext!='' && !file1inmem) {
         Wid1.select_edit_mode(ext);
      }
      if (status) {
         _message_box(nls("Could not open file '%s'.\n\n%s",filename1,get_message(status)));
         return(status);
      }
      ViewId1=diff_form_wid._ctlfile1.p_view_id;
      diff_form_wid._ctlfile2._delete_buffer();
      status=1;
      if (file2disk=='') {
         status=diff_form_wid._ctlfile2.load_files(def_load_options' 'bufwidthstr' 'nowindow' +q +b 'strip(filename2,'B','"'));
      }
      temp=filename2;
      if (status) {
         file2inmem=0;
         temp=file2disk' 'maybe_quote_filename(filename2);

         parse filename2 with '<' bufid '>';
         if (bufid!='') {
            status=diff_form_wid._ctlfile2.load_files(def_load_options' 'bufwidthstr' +q +bi 'bufid);
         }else{
            status=diff_form_wid._ctlfile2.load_files(def_load_options' 'bufwidthstr' 'temp);
         }

         diff_form_wid._ctlfile2.p_buf_flags=HIDE_BUFFER;
         if (status) return(status);
      }
      /*
      3:38pm 7/31/1998
      Now that we have both buffers loaded, we can get rid of the filesep...
      (see note above)
      */
      diff_form_wid._ctlfile1.p_buf_name=substr(diff_form_wid._ctlfile1.p_buf_name,1,length(diff_form_wid._ctlfile1.p_buf_name)-1);
      wid=p_window_id;
      p_window_id=diff_form_wid;
      p_window_id=wid;
      diff_form_wid._ctlfile2.top();diff_form_wid._ctlfile2.up();
      if (file2inmem) {
         while (!diff_form_wid._ctlfile2.down()) {
            diff_form_wid._ctlfile2._lineflags(0,MODIFY_LF);
            diff_form_wid._ctlfile2._lineflags(0,INSERTED_LINE_LF);
         }
      }
      diff_form_wid._ctlfile2.p_user=diff_form_wid._ctlfile2.p_buf_id' 'file2inmem' 'diff_form_wid._ctlfile2.p_readonly_mode;
      diff_form_wid._ctlfile2_readonly.p_value=(int)(diff_form_wid._ctlfile2.p_readonly_mode||ReadOnly2);
      diff_form_wid._ctlfile2.p_ProtectReadOnlyMode=(diff_form_wid._ctlfile2_readonly.p_value)?VSPROTECTREADONLYMODE_ALWAYS:VSPROTECTREADONLYMODE_NEVER;
      diff_form_wid._ctlfile2_readonly.p_enabled=!diff_form_wid._ctlfile2_readonly.p_value;
      ext=_bufname2ext(filename2);
      if (ext!='' && !file2inmem) {
         Wid2.select_edit_mode(ext);
      }
      if (status) {
         _message_box(nls("Could not open file '%s'.\n\n%s",filename2,get_message(status)));
         return(status);
      }
      File2Size=Wid2.p_Noflines;
      ViewId2=diff_form_wid._ctlfile2.p_view_id;
      _nocheck _control _ctlcopy_right_line;
      _nocheck _control _ctlcopy_right_all;
      diff_form_wid.gBuf1StartTime=_file_date(diff_form_wid._ctlfile1.p_buf_name,'B');
      diff_form_wid.gBuf2StartTime=_file_date(diff_form_wid._ctlfile2.p_buf_name,'B');
   }
   mou_hour_glass(1);
   if (def_diff_edit_options & DIFF_SHOW_GAUGE) {
      gauge_form_wid=show('-mdi _diff_progress_form');
      gauge_form_wid.p_caption='Diff Progress';
      gauge_form_wid.refresh();
      gauge_wid=gauge_form_wid.p_child;
   }else{
      gauge_wid=0;
   }
   boolean AllCommentOverride=false;
   if (!(flags&DIFF_DONT_COMPARE_EOL_CHARS)) {
      status=CheckForDifferentEOLChars(ViewId1,ViewId2,flags);
      if (status==COMMAND_CANCELLED_RC) {
         p_view_id=orig_view_id;
         _delete_temp_view(ViewId1);
         _delete_temp_view(ViewId2);

         if (!(flags&DIFF_OUTPUT_INTERLEAVED)) {
            diff_form_wid._delete_window();
         }

         gauge_form_wid._delete_window();
         return(COMMAND_CANCELLED_RC);
      }
   }
   if (flags&DIFF_OUTPUT_INTERLEAVED) {
      ff=1;NumOutputBuffers=0;
      for (;;) {
         ++NumOutputBuffers;
         str1=file1trydisk?'(File)':'(Buffer)';
         str2=file2trydisk?'(File)':'(Buffer)';
         bufname=buf_match('Diff:'filename1:+str1'|'filename2:+str2,ff);
         if (bufname=='') break;
         ff=0;
      }
      StartLine1=StartLine2=0;
      int NCSStatus1=0,NCSStatus2=0;
      if (diff_options&DIFF_LEADING_SKIP_COMMENTS) {
         NCSStatus1=_GetNonCommentSeek(ViewId1,junk,StartLine1);
         NCSStatus2=_GetNonCommentSeek(ViewId2,junk,StartLine2);
         //If we get STRING_NOT_FOUND_RC for both of these, the files are all
         //comment
         if (NCSStatus1==STRING_NOT_FOUND_RC && 
             NCSStatus2==STRING_NOT_FOUND_RC) {
            AllCommentOverride=true;
         }
      }
      //For interleaved output, we still have to generate the buffer even 
      //if AllCommentOverrideis true.  The user will still get the files match
      //message though.
      Diff(ViewId1,ViewId2,
           flags,
           NumOutputBuffers,file1trydisk,
           file2trydisk,def_load_options,gauge_wid,
           OutputBufId,//This is pass by reference
           def_max_fast_diff_size,
           StartLine1,StartLine2);
   }else{
      diff_form_wid._ctlfile1.maybe_show_all();
      diff_form_wid._ctlfile2.maybe_show_all();
      StartLine1=StartLine2=0;
      int NCSStatus1=0,NCSStatus2=0;
      if (diff_options&DIFF_LEADING_SKIP_COMMENTS) {
         NCSStatus1=_GetNonCommentSeek(ViewId1,junk,StartLine1);
         NCSStatus2=_GetNonCommentSeek(ViewId2,junk,StartLine2);
         //If we get STRING_NOT_FOUND_RC for both of these, the files are all
         //comment
         if (NCSStatus1==STRING_NOT_FOUND_RC && 
             NCSStatus2==STRING_NOT_FOUND_RC) {
            AllCommentOverride=true;
         }
      }
      //5:50pm 7/3/1998
      //Don't want this to ever happen by accident
      if (usesmartdiff && 0) {
         SmartDiff(ViewId1,
                   ViewId2,
                   flags,//Ignore leading spaces, all spaces, etc.
                   0,//N/A (Interleaved output)
                   def_load_options,//Interleaved output
                   gauge_wid,
                   OutputBufId,//This is pass by reference
                   StartLine1,StartLine2);
      }else{
         if (!AllCommentOverride) {
            Diff(ViewId1,
                 ViewId2,
                 flags,//Ignore leading spaces, all spaces, etc.
                 0,//N/A (Interleaved output)
                 0,//N/A (Interleaved output)
                 0,//N/A (Interleaved output)
                 def_load_options,//Interleaved output
                 gauge_wid,
                 OutputBufId,//This is pass by reference
                 def_max_fast_diff_size,
                 StartLine1,StartLine2);
         }
      }
      if (gauge_form_wid) {
         gauge_form_wid._delete_window();
      }
   }
   //Cleanup if interleaved output
   if (flags&DIFF_OUTPUT_INTERLEAVED) {
      if (file1inmem || (filename1==filename2 && !file1disk)) {
         p_view_id=ViewId1;
         p_buf_flags&=~HIDE_BUFFER;
         _quit_view();
      }else{
         _delete_temp_view(ViewId1);
      }
      if (file2inmem || (filename1==filename2 && !file2disk)) {
         p_view_id=ViewId2;
         p_buf_flags&=~HIDE_BUFFER;
         _quit_view();
      }else{
         _delete_temp_view(ViewId2);
      }
      //status=edit('+b Diff:'absolute(filename1):+str1'|'absolute(filename2):+str2':'NumOutputBuffers);
      status=edit('+bi 'OutputBufId);
      if (status) {
         mou_hour_glass(0);
         return(status);
      }
      ext1=_bufname2ext(filename1);
      ext2=_bufname2ext(filename2);
      if (ext1!='') {
         select_edit_mode(ext1);
      }else{
         if (ext2!='') {
            select_edit_mode(ext2)
         }
      }
      //read_only_mode();
      p_color_flags|=MODIFY_COLOR_FLAG;
      top();
      if (gauge_form_wid) {
         gauge_form_wid._delete_window();
      }
   }
   mou_hour_glass(0);
   _mdi.p_child._set_focus();
   if (!(flags&DIFF_OUTPUT_INTERLEAVED)) {

      Wid1.diff_init(1,Wid2);
      Wid2.diff_init(2,Wid1);
      if (def_diff_edit_options&DIFF_START_AT_TOP) {
         Wid1.top();Wid2.top();
      }else if (def_diff_edit_options&DIFF_START_AT_FIRST_DIFF) {
         Wid1.top();Wid1.up();Wid2.top();Wid2.up();
         _control _ctlnext_difference;
         diff_form_wid._ctlnext_difference.call_event(diff_form_wid._ctlnext_difference,LBUTTON_UP);
         //Wid1.diff_next_difference();
      }
      diff_form_wid.vscroll1.p_max=diff_form_wid._ctlfile1.p_Noflines+1;
      diff_form_wid.vscroll1.p_min=0;
      diff_form_wid.vscroll1.p_large_change=diff_form_wid._ctlfile1.p_char_height-1;

      diff_form_wid.hscroll1.p_max=max(diff_form_wid._ctlfile1._find_longest_line() intdiv diff_form_wid._ctlfile1._text_width("W"),\
                                       diff_form_wid._ctlfile2._find_longest_line() intdiv diff_form_wid._ctlfile2._text_width("W"));
      diff_form_wid.hscroll1.p_min=0;
      diff_form_wid.hscroll1.p_large_change=diff_form_wid._ctlfile1.p_char_height-1;

      //_post_call(myset_focus,diff_form_wid._ctlfile1);

      if (AllCommentOverride) {
         diff_form_wid.EvenComments();
      }
      diff_form_wid._ctlfile1.BlastUndoInfo();
      diff_form_wid._ctlfile2.BlastUndoInfo();
      //diff_form_wid.UpdateForm();
      diff_form_wid._ctlfile1._set_focus();

      diff_form_wid._ctlfile1.p_readonly_mode=1;
      diff_form_wid._ctlfile2.p_readonly_mode=1;
   }
   if (DiffFilesMatched() || AllCommentOverride) {
      //messageNwait(nls('DiffFilesMatched()=%s StartLine1=%s StartLine2=%s',DiffFilesMatched(),StartLine1,StartLine2));
      if (flags&DIFF_OUTPUT_INTERLEAVED) {
         _message_box(nls("Files Match"));
      }else{
         diff_form_wid._ctlcopy_right_all.p_user='Files Match';
         if (!quiet) {
            if (StartLine1||StartLine2) {
               result=_message_box(nls("Files Match(Except for leading comments), view them anyway?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
            }else{
               result=_message_box(nls("Files Match, view them anyway?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
            }
            if (result!=IDYES) {
               diff_form_wid._delete_window(0);
               return(COMMAND_CANCELLED_RC);
            }
         }
      }
   }
   _macro('m',was_recording);
   _macro_append(nls("diff('%s %s');",filename1,filename2));
   if (diff_form_wid) {
      diff_form_wid.p_visible=1;
   }
   if (!(flags&DIFF_OUTPUT_INTERLEAVED)) {
      if (modal) {
         //VCdiff
         status=_modal_wait(diff_form_wid);
      }
   }
   return(0);
}

static void AddImaginaryLines(int NumLines)
{
   DiffIntraLineColoring(0,p_buf_id);
   save_pos(p);
   for (i=0;i<NumLines;++i) {
      bottom();
      insert_line('Imaginary Buffer Line');
      _lineflags(0,INSERTED_LINE_LF|NOSAVE_LF|MODIFY_LF);
      _lineflags(NOSAVE_LF,NOSAVE_LF);
   }
   restore_pos(p);
   DiffIntraLineColoring(1,p_buf_id);
}

static void EvenComments()
{
   if (_ctlfile1.p_Noflines > _ctlfile2.p_Noflines) {
      _ctlfile2.AddImaginaryLines(_ctlfile1.p_Noflines-_ctlfile2.p_Noflines);
   }else if (_ctlfile1.p_Noflines < _ctlfile2.p_Noflines) {
      _ctlfile1.AddImaginaryLines(_ctlfile2.p_Noflines-_ctlfile1.p_Noflines);
   }
}

static int GetFileHidden(_str &filename,int &ViewId,
                         int &orig_view_id,int &fileinmem,...)
{
   fileinmem=1
   _str options;
   options=arg(5);
   otherext=arg(7);
   if (!pos('+d',options,1,'i')) {
      status=_open_temp_view(filename,ViewId,orig_view_id,'+b 'options);
      if (!status) {
         if (otherext!='') {
            select_edit_mode(otherext);
         }else{
            select_edit_mode();
         }
         arg(6)=p_Noflines;
         p_view_id=orig_view_id;
      }
   }else{
      status=1;
   }
   if (status) {
      fileinmem=0;
      status=_open_temp_view(filename,ViewId,orig_view_id,options);
      if (!status) {
         if (otherext!='') {
            select_edit_mode(otherext);
         }else{
            select_edit_mode();
         }
         arg(6)=p_Noflines;
         p_view_id=orig_view_id;
      }
   }
   return(status);
}

//I always want the first file to be the one on top
static void GetFilenamesFrom2Windows(_str &filename1, _str &filename2/*
                                    ,int &File2Size,int &ViewId1,
                                    int &ViewId2*/)
{
   wid1=p_window_id;
   next_window();
   wid2=p_window_id;
   /*if (wid2.p_y>wid1.p_y) {
      filename2=p_buf_name;
      arg(3)=p_Noflines;arg(5)=p_view_id;
   }else{*/
      filename1=p_buf_name;
      arg(4)=p_view_id;
   //}
   next_window();
   if (filename1=='') {
      filename1=p_buf_name;
      arg(4)=p_view_id;
   }else{
      filename2=p_buf_name;
      arg(3)=p_Noflines;arg(5)=p_view_id;
   }
}

//Took this from compare.e
static _str have_two_matched_tiles()
{
   return(0);
#if 1
   if (p_window_state=='M' || _no_child_windows()) {
      return(0)//return(set_up_windows(w2_view_id));
   }
   tile_id=p_tile_id
   first_window_id=p_window_id
   w2_view_id=''
   for (;;) {
      _next_window('HF');
      if ( p_window_id==first_window_id ) break;
      if ( p_tile_id==tile_id && !(p_window_flags &HIDE_WINDOW_OVERLAP)) {
         if ( w2_view_id!='' ) {
            w2_view_id='error';
            break;
         }
         w2_view_id=p_view_id;
         wid2=p_window_id;
         buf_name2=p_buf_name;
      }
   }
   if ( w2_view_id=='' || w2_view_id=='error') {
      return(0)//return(set_up_windows(w2_view_id));
   }
   if (wid2.p_window_state=='I') {
      wid2.p_window_state='N';
   }
   if (p_window_state=='I') {
      p_window_state='N';
   }
   return(1);
#endif
}

defeventtab _diffsetup_form

#define pDiffInfo         _fl1.p_user
#define gMapInfo          _fl2.p_user
#define gPath1Names       frame1.p_user
#define gUserModified_fl2 frame2.p_user
#define gInRetrieve       ctlfilespecs.p_user
#define ASCII1            ""

_ctlbuffers.lbutton_up()
{
   orig_view_id=_create_temp_view(temp_view_id);
   _build_buf_list(width,p_buf_id);
   top();up();
   while (!search('^ ?  Untitled\<:i\>','@ri')) {
      _delete_line();_begin_line();
   }
   p_view_id=orig_view_id;
   result=show('-modal _sellist_form',
               'Choose a Buffer',
               SL_VIEWID,
               temp_view_id);
   if (result!='') {
      p_prev.p_prev.p_text=_buflist_name(' 'result);
   }
}

_diffsetup_form.F7()
{
   gInRetrieve=1;
   _retrieve_next_form('-',1);
   UpdateTextAndButtons();
   gInRetrieve=0;
}
_diffsetup_form.F8()
{
   gInRetrieve=1;
   _retrieve_next_form('',1);
   UpdateTextAndButtons();
   gInRetrieve=0;
}

static void LoadDiffStateFile(_str filename)
{
   parent_option=(machine()=='OS2386')?'-mdi':'-desktop';
   modaloption='';
   if (_default_option(VSOPTION_MDI_SHOW_WINDOW_FLAGS)==SW_HIDE) {
      modaloption=' -modal ';
   }
   show('-new -xy 'modaloption' 'parent_option' _difftree_output_form',
        filename);
}

#if 0
static int gMDIFocusTimerHandle=-1;

static void SetFocusToMDI()
{
   if (gMDIFocusTimerHandle>=0) {
      _kill_timer(gMDIFocusTimerHandle);
      gMDIFocusTimerHandle=-1;
   }
   _mdi._set_focus();
   _mdi._set_foreground_window();
}
#endif

#define DIFF_STATEFILE_EXT 'dif'

void ctlload.lbutton_up()
{
   result=_OpenDialog('-modal '_stdform('_open_form'),
                      'Open Diff State File',                   // Dialog Box Title
                      '',                   // Initial Wild Cards
                      'Diff State Files (*.':+DIFF_STATEFILE_EXT:+')',       // File Type List
                      OFN_FILEMUSTEXIST,
                      DIFF_STATEFILE_EXT
                      );
   if (result=='') return;
   filename=result;
   spawn=ctlspawn_process.p_value&&ctlspawn_process.p_enabled;
   _save_form_response();
   p_active_form._delete_window();
   refresh();
   if (spawn) {
      cmdline=maybe_quote_filename(editor_name('P'):+'vs');//editor name
      cmdline=cmdline' +new -st 0 -mdihide -p diff -loadstate 'filename;
      status=shell(cmdline,'QA');
      //gMDIFocusTimerHandle=_set_timer(500,SetFocusToMDI);
   }else{
      LoadDiffStateFile(filename);
   }
}

static void ReplaceAtZero(_str (&filelist)[],_str Filename)
{
   found=0;
   for (i=0;i<filelist._length();++i) {
      if (file_eq(filelist[i],Filename)) {
         found=1;
         filelist._deleteel(i);
         break;
      }
   }
   if (found) {
      for (i=filelist._length();i>0;--i) {
         filelist[i]=filelist[i-1];
      }
      filelist[0]=Filename;
   }
}

#define DIVIDER_STR      ''
#define DIFFMAP_FILENAME 'diffmap.ini'

void _fl2.on_change(reason)
{
   if (gInRetrieve==1) {
      return;
   }
   if (p_active_form.p_visible && gUserModified_fl2!=-1) {
      gUserModified_fl2=1;
   }
   if (reason==CHANGE_CLINE||
       reason==CHANGE_CLINE_NOTVIS) {
      gUserModified_fl2='';
      //say('p_text='p_text);
      GetMapPoints(_fl1.p_text,MapPoint1,_fl2.p_text,MapPoint2);
#if __UNIX__
      UMapPoint1=MapPoint1;
#else
      UMapPoint1=upcase(MapPoint1);
#endif
      _str MapInfo:[];
      MapInfo=gMapInfo;
      _str Path1Names[];
      Path1Names=gPath1Names;
      if (!MapInfo._indexin(UMapPoint1)) {
         return;
      }
      curMapInfo=MapInfo:[UMapPoint1];

      curMapInfo=ASCII1:+curMapInfo;
      parse curMapInfo with beglist (ASCII1:+MapPoint2:+ASCII1) endlist;
      MaybeAddDelims(beglist);
      MaybeAddDelims(endlist);
      MapInfo:[UMapPoint1]=MapPoint2:+beglist:+endlist;
      ReplaceAtZero(Path1Names,UMapPoint1);
      if (last_char(MapInfo:[UMapPoint1])!=ASCII1) {
         MapInfo:[UMapPoint1]=MapInfo:[UMapPoint1]:+ASCII1;
      }
      gMapInfo=MapInfo;
      gPath1Names=Path1Names;
   }
   UpdateTextAndButtons();
}

static int gtimerHandle=-1;
static boolean gMissedEvent=false;

static void UpdateTextCallback(int wid)
{
   if (gtimerHandle>=0) {
      _kill_timer(gtimerHandle);
      gtimerHandle=-1;
   }
   //say('text='text' p_text='wid._fl1.p_text);
   oldwid=p_window_id;
   p_window_id=wid._fl1;
   if (gMissedEvent) {
      //say('calling UpdateTextAndButtons');
      UpdateTextAndButtons();
      gMissedEvent=false;
   }
   //say('otext='wid._fl2.p_text);
   p_window_id=oldwid;
}

void _fl1.on_change()
{
   if (p_active_form.p_name=='_diffsetup_form') {
      if (gInRetrieve==1) {
         return;
      }
   }
   if (p_active_form.p_visible && gtimerHandle<0) {
      //say('set_timer p_text='p_text);
      if (p_active_form.p_name=='_diffsetup_form') {
         gMissedEvent=true;
         gtimerHandle=_set_timer(50,UpdateTextCallback,p_active_form);
      }
   }else if (!p_active_form.p_visible) {
      UpdateTextAndButtons();
   }else if (gtimerHandle && p_active_form.p_name=='_diffsetup_form') {
      //say('no timer p_text='p_text' gtimerHandle='gtimerHandle);
      gMissedEvent=true;
   }
}

void _fl1.on_destroy()
{
   if (gtimerHandle>=0) {
      _kill_timer(gtimerHandle);
      gtimerHandle=-1;
   }
}

#define MULTIFILE 1
#define TWOFILE   2

static void EnableAppropriateControls(int enable)
{
   if (enable==MULTIFILE) {
      ctlrecord_width_lablel.p_enabled=_file_width.p_enabled=_ctlinterleaved.p_enabled=0;
      ctlfilespec_label.p_enabled=ctlfilespecs.p_enabled=ctlexclude_filespec_label.p_enabled=ctlexclude_filespecs.p_enabled=ctlrecursive.p_enabled/*=ctlspawn_process.p_enabled*/=1
   }else if (enable==TWOFILE) {
      ctlrecord_width_lablel.p_enabled=_file_width.p_enabled=_ctlinterleaved.p_enabled=1;
      ctlfilespec_label.p_enabled=ctlfilespecs.p_enabled=ctlexclude_filespec_label.p_enabled=ctlexclude_filespecs.p_enabled=ctlrecursive.p_enabled/*=ctlspawn_process.p_enabled*/=0;
   }
}

void _browse1dir.lbutton_up()
{
   if (machine()=='NT386') {
      path=_ntBrowseForFolder();
   } else {
      result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
      if( result=='' ) {
         return;
      }
      path=strip_options(result,dummy);
   }
   if (path!='') {
      if (last_char(path)!=FILESEP) path=path:+FILESEP;
      p_prev.p_prev.p_prev.p_text=maybe_quote_filename(path);
   }
}

static _str _FormatCur(_str cur)
{
   cur=stranslate(cur,'','"');
   int len=length(cur);
   if (len>2) {
      while (len>1 && substr(cur,len-1,2)==FILESEP:+FILESEP) {
         cur=substr(cur,1,len-1);
         len=length(cur);
      }
   }
   return(cur);
}

static void AddMappedNames()
{
   wid=p_window_id;
   p_window_id=p_cb_list_box;
   _lbclear();
   _str PathsInBox:[];
   PathsInBox._makeempty();
   if (!(def_diff_edit_options&DIFF_NO_AUTO_MAPPING)) {
      _str MapInfo:[];
      _str Path1Names[];
      MapInfo=gMapInfo;
      Path1Names=gPath1Names;
      _str path1;
      path1=absolute(_fl1.p_text);
   #if __UNIX__
      Upath1=path1;
   #else
      Upath1=upcase(path1);
   #endif
      if (isdirectory(Upath1)) {
         if (last_char(Upath1)!=FILESEP) {
            Upath1=Upath1:+FILESEP;
         }
      }else{
         Upath1=strip_filename(Upath1,'N');
      }
      path1=strip_filename(path1,'N');
      int  BottomEntryIndexes:[];
      BottomEntryIndexes._makeempty();
      int added=0;
      for (i=0;i<Path1Names._length();++i) {
         curPathName=Path1Names[i];
         if (file_eq(curPathName,substr(Upath1,1,length(curPathName)))) {
            _str CurMapInfo=MapInfo:[curPathName];
            for (;;) {
               parse CurMapInfo with cur (ASCII1) CurMapInfo;

               cur=_FormatCur(cur);

               if (cur=='') break;
               CurPath=cur:+substr(path1,length(curPathName)+1);
   #if __UNIX__
               UCurPath=CurPath;
   #else
               UCurPath=upcase(CurPath);
   #endif
               if (!PathsInBox._indexin(UCurPath)) {
                  _lbadd_item(maybe_quote_filename(CurPath));
                  added=1;
               }
               PathsInBox:[UCurPath]=CurPath;
            }
         }else{
            BottomEntryIndexes:[i]=i;
         }
      }
      if (added) {
         _lbadd_item(DIVIDER_STR);
      }
   }
   orig_view_id=p_view_id;

   _str path=_config_path();
   if (last_char(path)!=FILESEP) path=path:+FILESEP;
   _str HistoryFilename=path:+DIFFMAP_FILENAME;
   status=_ini_get_section(HistoryFilename,"Path2History",temp_view_id);
   added=0;
   if (!status) {
      p_view_id=temp_view_id;
      top();up();
      while (!down()) {
         get_line(line);
         _str Uline;
#if __UNIX__
         Uline=line;
#else
         Uline=upcase(line);
#endif
         p_view_id=orig_view_id;
         if (!PathsInBox._indexin(Uline)) {
            _lbadd_item(maybe_quote_filename(line));
            added=1;
         }
         p_view_id=temp_view_id;
      }
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
   }
   if (!added) {
      _lbbottom();
      _lbdelete_item();
   }
   if (!(def_diff_edit_options&DIFF_NO_AUTO_MAPPING)) {
      if (gUserModified_fl2!=1) {
         _lbtop();
         old=gUserModified_fl2;
         gUserModified_fl2=-1;
         _fl2.p_text=_lbget_text();
         _fl2._set_sel(1,1);
         gUserModified_fl2=old;
      }
   }
   p_window_id=wid;
}

static void UpdateTextAndButtons()
{
   if (gignore_change) return;
   if (p_active_form.p_name=='_diffsetup_form') {
      filename=p_text;
      if (isdirectory(_fl1.p_text)) {
         EnableAppropriateControls(MULTIFILE);
      }else{
         EnableAppropriateControls(TWOFILE);
      }
      if (last_char(filename)==FILESEP && p_name=='_fl2') {
         //This is the special backslash thing....
         OtherFilename=_fl1.p_text;
         filename=filename:+strip_filename(OtherFilename,'P');
      }
      //boolean ValidUntitled=IsValidUntitled(filename);

      if (buf_match(absolute(filename),1,'e')=='' &&
          buf_match(filename,1,'e')==''/* &&
          !ValidUntitled*/) {
         //Have to do the second check because it could be a p_DocumentName buffer

         //No buffer, disable buffer button, set file buttons
         p_next.p_next.p_next.p_next.p_value=1;
         p_next.p_next.p_next.p_next.p_next.p_enabled=0;
      }else{
         //Have buffer, enable bufffer button
         p_next.p_next.p_next.p_next.p_next.p_enabled=1;
         otherwid=(p_window_id==_fl1)?_fl2:_fl1;
         if (file_eq(absolute(p_text),absolute(otherwid.p_text))) {
            //Filenames match, do something special with file/buffer buttons
            if (otherwid.p_next.p_next.p_next.p_next.p_value) {
               p_next.p_next.p_next.p_next.p_next.p_value=1;
            }else{
               p_next.p_next.p_next.p_next.p_value=1;
            }
         }else{
            //Always want buffer if filenames don't match
            p_next.p_next.p_next.p_next.p_next.p_value=1;
         }
      }
   }
   if (p_active_form.p_name=='_diffsetup_form') {
      if (p_window_id!=_fl2 && gInRetrieve!=1) {
         _fl2.AddMappedNames();
         _fl2.UpdateTextAndButtons();
      }
   }
}

void _ctlok.on_create()
{
   LoadMapTable();
   /*arg(1) is the initial buffer1 name. */
   _fl1.p_text=arg(1);
   _fl2.p_text=arg(2);
   pDiffInfo=arg(4);
   if (!_no_child_windows()) {
      _file_width.p_text=_mdi.p_child.p_buf_width;
   }
   if (arg(1)==''||arg(2)=='') {
      if (def_diff_edit_options&DIFF_CURFILE_INIT) {
      }else{
         gignore_change=1;
         _retrieve_prev_form();
         gignore_change=0;
         gInRetrieve=1;
         if (_fl1.p_text!="") {
            //_fl1.call_event(_fl1,ON_CHANGE);
            _fl1.UpdateTextAndButtons();
         }
         if (_fl2.p_text!="") {
            //_fl2.call_event(CHANGE_OTHER,_fl2,ON_CHANGE,'w');
            _fl2.UpdateTextAndButtons();
         }
         gInRetrieve=0;
      }
      // Could make this an option later.  This default
      // is here for safety. Try to always use buffers.
      //_fl1.p_text=_fl1.p_text;
      //_fl2.p_text=_fl2.p_text;
   }
   //p_active_form.p_caption=arg(3);
   isdir=isdirectory(_fl1.p_text);
   EnableAppropriateControls(isdir?MULTIFILE:TWOFILE);
   ctlsmart_diff.p_value=(int)def_smart_diff;
   if (_win32s()==1) {
      ctlspawn_process.p_visible=0;
   }
   ctlfilespecs.p_cb_list_box.LoadHistory("FilespecsHistory");
   ctlexclude_filespecs.p_cb_list_box.LoadHistory("ExcludeFilespecsHistory");

   _fl1.p_cb_list_box.LoadHistory("Path1History");
}

static void LoadHistory(_str SectionName)
{
   _str path=_config_path();
   if (last_char(path)!=FILESEP) path=path:+FILESEP;
   _str HistoryFilename=path:+DIFFMAP_FILENAME;
   orig_view_id=p_view_id;
   status=_ini_get_section(HistoryFilename,SectionName,temp_view_id);
   if (status) return;
   p_view_id=temp_view_id;
   top();up();
   while (!down()) {
      get_line(line);
      p_view_id=orig_view_id;
      _lbadd_item(line);
      p_view_id=temp_view_id;
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
}

static void LoadMapTable()
{
   _str Path1Names[];
   _str MapTable:[];
   _str path=_config_path();
   if (last_char(path)!=FILESEP) path=path:+FILESEP;
   _str HistoryFilename=path:+DIFFMAP_FILENAME;
   orig_view_id=p_view_id;
   status=_ini_get_section(HistoryFilename,"Mappings",temp_view_id);
   if (status) {
      gMapInfo=MapTable;
      gPath1Names=Path1Names;
      return;
   }
   p_view_id=temp_view_id;
   top();up();
   while (!down()) {
      get_line(line);
      parse line with file1 (ASCII1) rest;
#if __UNIX__
#else
      file1=upcase(file1);
#endif
      Path1Names[Path1Names._length()]=file1;
      MapTable:[file1]=rest;
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   gMapInfo=MapTable;
   gPath1Names=Path1Names;
}

static _str MaybeAppendFilesep(_str Path)
{
   if (last_char(Path)=='"') {
      Path=substr(Path,1,length(Path)-1);
      if (last_char(Path)!=FILESEP) Path=Path:+FILESEP;
      Path=Path:+'"';
      return(Path);
   }
   if (last_char(Path)!=FILESEP) Path=Path:+FILESEP;
   return(Path);
}

static int _GetFileTable(_str (&FileTable):[],_str Path,_str Filespecs,
                         _str ExcludeFilespecs,boolean recursive,
                         int ProgressFormWID)
{
   gCancel=0;
   list=Filespecs;
   count=0;
   recurseOption=(recursive?'+t':'');
   ProgressFormWID.SetProgressMessage('Building file lists for:',Path,'Items Found:'count);
   for (;;) {
      CurFilespec=parse_file(list);
      if (CurFilespec=='') break;
      CurFilespec=strip(CurFilespec,'B','"');
      ff=1;
      temp=' -p +d 'maybe_quote_filename(Path:+CurFilespec)' 'recurseOption;
      for (;;) {
         process_events(gCancel);
         if (gCancel) {
            return(-1);
         }
         filename=file_match(temp,ff);ff=0;
         if (filename=='') break;
         tfilename=filename;
         if (last_char(tfilename)==FILESEP) {
            tfilename=substr(tfilename,1,length(tfilename)-1);
            tfilename=strip_filename(tfilename,'P');
            if (tfilename=='..') continue;
         }else if (ExcludeFilespecs!='' && FileIsExcluded(filename,ExcludeFilespecs)) {
            continue;
         }
         FileTable:[_file_case(filename)]=filename;
         ++count;
         if (!(count%10)) {
            ProgressFormWID.SetProgressMessage('Building file lists for:',Path,'Items Found:'count);
         }
      }
   }
   return(count);
}

static boolean FilespecMatches(_str Filespec,_str Filename)
{
   Filespec=strip(Filespec);
   if (Filespec=='*') return(1);
   FilespecRE=stranslate(Filespec,'?*','*');
   FilespecRE=stranslate(FilespecRE,'\\','\');
#if __PCDOS__
   if (substr(FilespecRE,length(FilespecRE)-2,2)=='.*') {
      FilespecRE=substr(FilespecRE,1,length(FilespecRE)-2):+'(.|)?*';
   }
#endif
   FilespecRE='^'FilespecRE'$';
   p=pos(FilespecRE,Filename,1,'r'_fpos_case);
   if (p) return(true);
   return(false);
}

static boolean FileIsExcluded(_str Filename,_str ExcludeFilespecs)
{
   for (;;) {
      cur=parse_file(ExcludeFilespecs);
      if (cur=='') break;
      cur=strip(cur,'b','"');
      if (FilespecMatches(cur,strip_filename(Filename,'P'))) return(true);
   }
   return(false);
}

#define FORCE_PROCESS_OPTIONS (DIFF_EXPAND_TABS|DIFF_IGNORE_LSPACES|DIFF_IGNORE_TSPACES|DIFF_IGNORE_SPACES|DIFF_IGNORE_CASE)

static int _GetNonCommentSeek(int ViewId,long &SeekPos,...)
{
   orig_view_id=p_view_id;
   p_view_id=ViewId;
   boolean DoClex=true;
   {
      //Only want to do this once!!!
      if (_modename_eq(p_mode_name,'Fundamental') ) {
         extension= get_extension(p_buf_name);
         buf_name=p_buf_name;
         old_extension=extension;
         check_and_load_support(old_extension,setup_index,buf_name);

         extension=refer_ext(_file_case(extension),buf_name);

         if ( setup_index ) {
            parse name_info(setup_index) with 'MN=' mode_name ','\
               'TABS=' tabs ',' 'MA=' margins ',' 'KEYTAB=' keytab_name ','\
               'WW='word_wrap_style ',' 'IWT='indent_with_tabs ','\
               'ST='show_tabs ',' 'IN='indent_style ','\
               'WC='word_chars',' 'LN='lexer_name',' 'CF='color_flags','\
               'LNL='line_numbers_len',';
            p_mode_name=mode_name;
            p_extension=extension;
            _ext_init_values(extension,lexer_name,color_flags);
            p_color_flags=color_flags;
            p_lexer_name=lexer_name;
         }else{
            DoClex=false;
         }
      }
   }
   _GoToROffset(0);
   int status=0;
   if (DoClex) {
      status=_clex_find(COMMENT_CLEXFLAG,'N');
   }
   SeekPos=_QROffset();
   arg(3)=p_line;
   p_view_id=orig_view_id;
   return(status);
}

static int DiffFileTables(_str (&FileTable1):[],_str BasePath1,
                           _str (&FileTable2):[],_str BasePath2,
                           _str (&Output)[],int ProgressFormWID)
{
   BasePath1=strip(BasePath1,'B','"');
   BasePath2=strip(BasePath2,'B','"');
   path1len=length(BasePath1);
   path2len=length(BasePath2);
   count=0;
   dcount=0;
   _str DelTable1:[];
   _str DelTable2:[];
   AtLeastOneDifferent=0;
   int NumFiles=0;
   for (i._makeempty();;++NumFiles) {
      FileTable1._nextel(i);
      if (i._isempty()) break;
   }
   _nocheck _control gauge1;
   ProgressFormWID.ShowProgressGauge();
   ProgressFormWID.gauge1.p_min=0;
   ProgressFormWID.gauge1.p_max=NumFiles;
   for (i._makeempty();;) {
      ++ProgressFormWID.gauge1.p_value;
      FileTable1._nextel(i);
      if (i._isempty()) {
         ProgressFormWID.gauge1.p_value=ProgressFormWID.gauge1.p_max;
         ProgressFormWID.gauge1.refresh('W');
         break;
      }
      filename1=FileTable1:[i];
      filename2=BasePath2:+substr(filename1,path1len+1);
      if (last_char(filename1)==FILESEP) {
         filename1=substr(filename1,1,length(filename1)-1);
         if (strip_filename(filename1,'P')=='..') {
            DelTable1:[filename1]='';
            DelTable2:[filename2]='';
            continue;
         }
         filename1=strip_filename(filename1,'N');
         filename2=substr(filename2,1,length(filename2)-1);
         filename2=strip_filename(filename2,'N');

         if (FileTable2._indexin(filename2)) {
            //Have to put '0' at the end for status...
            //Directories[dcount++]=filename1"\tfilename2;
            DelTable1:[filename1]='';
            DelTable2:[filename2]='';
            continue;
         }
      }
      if (FileTable2._indexin(_file_case(filename2))) {
         orig_view_id=p_view_id;
         status=_open_temp_view(filename1,File1ViewId,junk);
         if (status) {
            p_view_id=orig_view_id;
            continue;
         }
         status=_open_temp_view(filename2,File2ViewId,junk);
         if (status) {
            _delete_temp_view(File1ViewId);
            p_view_id=orig_view_id;
            continue;
         }
         p_view_id=orig_view_id;
         process_events(gCancel);
         if (gCancel) {
            _delete_temp_view(File1ViewId);
            _delete_temp_view(File2ViewId);
            return(COMMAND_CANCELLED_RC);
         }
         _nocheck _control label1;
         if (!(def_diff_options&FORCE_PROCESS_OPTIONS)&&
             !(def_diff_options&DIFF_DONT_COMPARE_EOL_CHARS)) {
            ProgressFormWID.SetProgressMessage('Fast Comparing',filename1,filename2);
            //This means we are in the "sunny day" scenario.  Even a size
            //mismatch is good enough
            long seek1,seek2;
            seek1=seek2=0;
            int NCSStatus1=0,NCSStatus2=0;
            if (def_diff_options&DIFF_LEADING_SKIP_COMMENTS) {
               NCSStatus1=_GetNonCommentSeek(File1ViewId,seek1);
               NCSStatus2=_GetNonCommentSeek(File2ViewId,seek2);
            }
            //If we get STRING_NOT_FOUND_RC for both of these, the files are all
            //comment
            if (NCSStatus1==STRING_NOT_FOUND_RC &&
                NCSStatus2==STRING_NOT_FOUND_RC) {
               status=0;
            }else{
               status=FastCompare(File1ViewId,seek1,File2ViewId,seek2);
            }
         }else{
            ProgressFormWID.SetProgressMessage('Comparing',filename1,filename2);
            OutputBufId='';//Shouldn't have to do this...
            flags=def_diff_options|DIFF_OUTPUT_BOOLEAN;
            StartLine1=StartLine2=0;
            int NCSStatus1=0,NCSStatus2=0;
            if (def_diff_options&DIFF_LEADING_SKIP_COMMENTS) {
               NCSStatus1=_GetNonCommentSeek(File1ViewId,junk,StartLine1);
               NCSStatus2=_GetNonCommentSeek(File2ViewId,junk,StartLine2);
            }
            //If we get STRING_NOT_FOUND_RC for both of these, the files are all
            //comment
            if (NCSStatus1==STRING_NOT_FOUND_RC &&
                NCSStatus2==STRING_NOT_FOUND_RC) {
               status=0;
            }else{
               status=Diff(File1ViewId,File2ViewId,
                           flags,
                           0,
                           0,0,//Do nothing
                           def_load_options,0,
                           OutputBufId,//This is pass by reference
                           def_max_fast_diff_size,
                           StartLine1,StartLine2);
            }
         }
         if (status) AtLeastOneDifferent=1;
         Output[count++]=filename1"\t"_file_date(filename1,'B')"\t"filename2"\t"_file_date(filename2,'B')"\t"status;
         _delete_temp_view(File1ViewId);
         _delete_temp_view(File2ViewId);
         DelTable1:[filename1]='';
         DelTable2:[filename2]='';
      }
   }
   ProgressFormWID.gauge1.p_value=ProgressFormWID.gauge1.p_max;
   clear_message();
   if (!AtLeastOneDifferent) {
      //10:12am 10/28/1997
      //This seemed like a good idea, but it goes off even when there
      //are files that don't match
      //_message_box(nls("All files match"));
   }
   RemoveFromTable(FileTable1,DelTable1);
   RemoveFromTable(FileTable2,DelTable2);
   return(0);
}

static boolean VerifyPath(_str path)
{
   //Strip trailing filesep, throws off file_match
   if (last_char(path)==FILESEP) path=substr(path,1,length(path)-1);
   path=maybe_quote_filename(path)
   if (isunc_root(path) || isdrive(path)) {
      //If it is a unc root, file_match won't work the same, have to tinker a
      //little(This is actually an os thing, tested with "fftest" program
      match=file_match(path:+FILESEP:+ALLFILES_RE' +p +d',1);
      if (match=='') {
         return(1);
      }
      //This actually comes back with <path>FILESEP.FILESEP
      //ex:
      //\\dan\test\ -> \\dan\test\.\
      //But it seems to be consistent.  Thought about using chdir to see
      //if it was valid, but among other problems(don't know if we can still
      //cd to UNC name), thought that this could cause problems on UNIX
   }else{
      //If this is a "normal" situation, doing a file match with the
      //name missing the trailing FILESEP, will come back with it if
      //there is a directory there ex:
      //c:\dan\test -> c:\dan\test\.\
      if (substr(path,1,1)=='"') {
         if (last_char(path)=='"') path=substr(path,1,length(path)-1);
         if (last_char(path)==FILESEP) {
            path=substr(path,1,length(path)-1);
         }
         path=path:+'"';
         match=file_match(path' -p +d',1);
      }else{
         match=file_match(path' -p +d',1);
      }
      //If it is a directory, match will come back with trailing filesep
      if (last_char(match)!=FILESEP) {
         return(1);
      }
   }
   return(0);
}

static void RemoveFromTable(_str (&FileTable):[],_str RemoveTable:[])
{
   for (i._makeempty();;) {
      RemoveTable._nextel(i);
      if (i._isempty()) break;
      FileTable._deleteel(_file_case(i));
   }
}

#define MFDIFF_INPUT_ERROR_PATH1            1
#define MFDIFF_INPUT_ERROR_PATH2            2
#define MFDIFF_INPUT_ERROR_EQIVILANT_PATHS  3
#define MFDIFF_INPUT_ERROR_BLANK            4
#define MFDIFF_INPUT_ERROR_FILESPEC_HAS_DIR 5

//This is used for commmand line stuff....
//Others check return codes and call _text_box_error in the appropriate place
static int DisplayMFDiffErrorMessage(int status)
{
   switch (status) {
   case MFDIFF_INPUT_ERROR_PATH1:
      _message_box(nls("Error in Path 1"));
      break;
   case MFDIFF_INPUT_ERROR_PATH2:
      _message_box(nls("Error in Path 2"));
      break;
   case MFDIFF_INPUT_ERROR_EQIVILANT_PATHS:
      _message_box(nls("Paths must be different"));
      break;
   case MFDIFF_INPUT_ERROR_BLANK:
      _message_box(nls("Must specify filespec"));
      break;
   case MFDIFF_INPUT_ERROR_FILESPEC_HAS_DIR:
      _message_box(nls("Exclude filespec may not have path information"));
      break;
   }
   return(status);
}

static int VerifyFilespec(_str filespec,_str option='')
{
   if (option=='N') {
      if (pos(FILESEP,filespec)) {
         return(MFDIFF_INPUT_ERROR_FILESPEC_HAS_DIR);
      }
   }else {
      if (filespec=='') {
         //If it was blank, just put in a '*', this is probably what they meant
         return(MFDIFF_INPUT_ERROR_BLANK);
      }
   }
   return(0);
}
#if 0
static boolean VerifyFilespec(...)
{
   status=VerifyFilespec2(p_text,arg(2));
   if (status==MFDIFF_INPUT_ERROR_FILESPEC_HAS_DIR) {
      _text_box_error("This parameter may not specify subdirectories");
      return(status);
   }else if (status==MFDIFF_INPUT_ERROR_BLANK) {
      _text_box_error("This parameter cannot be blank");
      return(status);
   }
   return(0);
}
#endif

static int VerifyMultiFileDiffInput(_str path1,_str path2,
                                   _str filespec,_str excludeFilespec)
{
   if (VerifyPath(path1)) return(MFDIFF_INPUT_ERROR_PATH1);
   if (VerifyPath(path2)) return(MFDIFF_INPUT_ERROR_PATH2);
   path1=MaybeAppendFilesep(path1);
   path2=MaybeAppendFilesep(path2);
   //Be sure that paths are different
   if (file_eq(path1,path2)) {
      return(MFDIFF_INPUT_ERROR_EQIVILANT_PATHS);
   }
   status=VerifyFilespec(filespec);
   if (status) {
      return(status);
   }
   status=VerifyFilespec(excludeFilespec,'N');
   if (status) {
      return(status);
   }
   return(0);
}

static int MFDiff(DIFF_SETUP_INFO *pSetupInfo)
{
   _str path1=pSetupInfo->path1,path2=pSetupInfo->path2;
   _str Filespecs=pSetupInfo->filespec,ExcludeFilespecs=pSetupInfo->excludeFilespec;
   boolean recursive=pSetupInfo->recursive;
   if (pSetupInfo->spawnProcess &&_win32s()!=1/*just in case*/) {
      recursiveOptionString=(recursive?'-recursive':'');

      cmdline=maybe_quote_filename(editor_name('P'):+'vs');//editor name
      cmdline=cmdline' +new -st 0 -mdihide -p diff -filespec 'Filespecs' -excludefilespec 'ExcludeFilespecs' -optionflags 'def_diff_options' 'recursiveOptionString' 'path1' 'path2;
      status=list_modified();
      if (status==COMMAND_CANCELLED_RC) {
         return(COMMAND_CANCELLED_RC);
      }
      status=shell(cmdline,'QA');
      //gMDIFocusTimerHandle=_set_timer(500,SetFocusToMDI);
      return(0);
   }
   _str FileTable1:[],FileTable2:[];
   //message('Building File Lists...');

   int ProgressFormWID=show('-desktop -hidden _difftree_progress_form');
   ProgressFormWID.HideProgressGauge();
   ProgressFormWID.p_visible=1;
   disabled_wid_list=_enable_non_modal_forms(0,ProgressFormWID);
   //_mdi.p_enabled=0;
   ProgressFormWID._set_foreground_window();
   /*if (!_mdi.p_visible) {
      //ProgressFormWID._ShowWindow(SW_SHOWNOACTIVATE);
      ProgressFormWID._set_foreground_window();
   } */

   NumFilesInPath1=_GetFileTable(FileTable1,path1,Filespecs,ExcludeFilespecs,recursive,ProgressFormWID);
   if (NumFilesInPath1<0) {
      _enable_non_modal_forms(1,0,disabled_wid_list);
      ProgressFormWID._delete_window();
      return(1);
   }
   NumFilesInPath2=_GetFileTable(FileTable2,path2,Filespecs,ExcludeFilespecs,recursive,ProgressFormWID);
   if (NumFilesInPath2<0) {
      _enable_non_modal_forms(1,0,disabled_wid_list);
      ProgressFormWID._delete_window();
      return(1);
   }
   clear_message();

   if (!NumFilesInPath1 && !NumFilesInPath2) {
      _message_box("No Files match these parameters");
      _enable_non_modal_forms(1,0,disabled_wid_list);
      ProgressFormWID._delete_window();
      return(1);
   }
   _str OutputTable[];
   status=DiffFileTables(FileTable1,path1,FileTable2,path2,OutputTable,ProgressFormWID);
   if (status) {
      _enable_non_modal_forms(1,0,disabled_wid_list);
      ProgressFormWID._delete_window();
      return(status);
   }
   parent_option=(machine()=='OS2386')?'-mdi':'-desktop';
   modaloption='';
   if (_default_option(VSOPTION_MDI_SHOW_WINDOW_FLAGS)==SW_HIDE) {
      modaloption=' -modal ';
   }
   _enable_non_modal_forms(1,0,disabled_wid_list);
   ProgressFormWID._delete_window();
   show('-new -xy 'modaloption' 'parent_option' _difftree_output_form',
        FileTable1,path1,
        FileTable2,path2,
        OutputTable,
        path1,
        path2,
        recursive,
        Filespecs,
        ExcludeFilespecs,
        modaloption);
   formwid=_find_formobj('_difftree_output_form','N');
   if (formwid) {
       _nocheck _control tree1;
       _nocheck _control tree2;
      s1=formwid.tree1._TreeScroll();
      s2=formwid.tree2._TreeScroll();
      //say('s1='s1' s2='s2);
      formwid.tree2._TreeScroll(s1);
   }
   return(0);
}

static void MaybeAddDelims(_str &path)
{
   if (path=='') return;
   if (substr(path,1,1)!=ASCII1) {
      path=ASCII1:+path;
   }
   if (last_char(path)!=ASCII1) {
      path=path:+ASCII1
   }
}

static void GetMapPoints(_str DiffPath1,_str &MapPoint1,
                         _str DiffPath2,_str &MapPoint2)
{
   DiffPath1=strip_filename(DiffPath1,'N');
   DiffPath2=strip_filename(DiffPath2,'N');
   last1=cur1=DiffPath1;
   last2=cur2=DiffPath2;
   for (;;) {
      last1=cur1;
      last2=cur2;
      cur1=substr(cur1,1,length(cur1)-1);
      cur2=substr(cur2,1,length(cur2)-1);
      curName1=strip_filename(cur1,'P');
      curName2=strip_filename(cur2,'P');
      if (!file_eq(curName1,curName2)) {
         break;
      }
      cur1=strip_filename(cur1,'N');
      cur2=strip_filename(cur2,'N');
      if (cur1==''||cur2=='') break;
   }
   MapPoint1=stranslate(last1,'','"');
   MapPoint2=stranslate(last2,'','"');
}

static void SaveDiffMapInfo(_str filename1,_str filename2,
                            _str filespec,_str excludeFilespec)
{
   _str path=_config_path();
   if (last_char(path)!=FILESEP) path=path:+FILESEP;
   _str HistoryFilename=path:+DIFFMAP_FILENAME;
   //status=_open_temp_view(HistoryFilename,temp_view_id,orig_view_id);
   orig_view_id=p_view_id;
   status=_ini_get_section(HistoryFilename,"Mappings",temp_view_id);
   if (status) {
      if (status==FILE_NOT_FOUND_RC) {
         orig_view_id=_create_temp_view(temp_view_id);
         p_buf_name=HistoryFilename;
      }else{
         return;//Not that important
      }
   }
   p_view_id=temp_view_id;
#if 1
   DiffPath1=strip_filename(absolute(filename1),'N');
   DiffPath2=strip_filename(absolute(filename2),'N');
#else
   DiffPath1=strip_filename(filename1,'N');
   DiffPath2=strip_filename(filename2,'N');
#endif
   filename1=stranslate(filename1,'','"');
   filename2=stranslate(filename1,'','"');
   GetMapPoints(DiffPath1,MapPoint1,DiffPath2,MapPoint2);
   status=search('^'_escape_re_chars(MapPoint1)'($|\1)','@r'_fpos_case);
   if (status) {
      top();up();
      insert_line(MapPoint1:+ASCII1:+MapPoint2:+ASCII1);
   }else{
      get_line(line);
      parse line with . (ASCII1) paths;
      paths=ASCII1:+paths;
      parse paths with beglist (ASCII1:+MapPoint2:+ASCII1) endlist;
      MaybeAddDelims(beglist);
      MaybeAddDelims(endlist);
      _delete_line();
      top();up();
      insert_line(MapPoint1:+ASCII1:+MapPoint2:+beglist:+endlist);
   }
   //_save_file('+o');
   p_view_id=orig_view_id;
   status=_ini_put_section(HistoryFilename,"Mappings",temp_view_id);
   parse def_max_diffhist with MaxNumMaps MaxPath2NumHist MaxNumFilespecHist MaxNumExcludeFilespecHist;
   AddHistoryInfo(filename1,"Path1History",MaxPath2NumHist);
   if (last_char(Info)==FILESEP) {
      AddHistoryInfo(filename2,"Path2History",MaxPath2NumHist);
   }else{
      name=filename2;
      if (isdirectory(name)) {
      }else{
         name=strip_filename(name,'n');
      }
      AddHistoryInfo(name,"Path2History",MaxPath2NumHist);
   }
   if (filespec!='') {
      AddHistoryInfo(filespec,"FilespecsHistory",MaxNumFilespecHist);
   }
   if (excludeFilespec!='') {
      AddHistoryInfo(excludeFilespec,"ExcludeFilespecsHistory",MaxNumExcludeFilespecHist);
   }
}

static void AddHistoryInfo(_str Info,_str SectionName,int MaxNum)
{
   orig_view_id=p_view_id;
   _str path=_config_path();
   if (last_char(path)!=FILESEP) path=path:+FILESEP;
   _str HistoryFilename=path:+DIFFMAP_FILENAME;
   status=_ini_get_section(HistoryFilename,SectionName,temp_view_id);
   if (status) {
      orig_view_id=_create_temp_view(temp_view_id);
   }
   p_view_id=temp_view_id;
   top();up();
   status=search('^'_escape_re_chars(Info)'$','@r'_fpos_case);
   if (!status) {
      _delete_line();
   }
   top();up();
   insert_line(Info);
   bottom();
   while (p_Noflines>MaxNum) {
      _delete_line();
   }
   p_view_id=orig_view_id;
   status=_ini_put_section(HistoryFilename,SectionName,temp_view_id);
}

int _ctlok.lbutton_up()
{
   //_save_form_response();
   DIFF_SETUP_INFO *temp=pDiffInfo;
   int status;
   if (isdirectory(_fl1.p_text)) {
      status=VerifyMultiFileDiffInput(_fl1.p_text,_fl2.p_text,
                                     ctlfilespecs.p_text,
                                     ctlexclude_filespecs.p_text);
      //Verify paths are ok
      if (status==MFDIFF_INPUT_ERROR_PATH1) {
         _fl1._text_box_error("This parameter must be a valid path");
         return(status);
      }else if (status==MFDIFF_INPUT_ERROR_PATH2) {
         _fl2._text_box_error("This parameter must be a valid path");
         return(status);
      }else if (status==MFDIFF_INPUT_ERROR_EQIVILANT_PATHS) {
         _fl2._text_box_error("You must specify two different paths");
         return(status);
      }else if (status==MFDIFF_INPUT_ERROR_BLANK) {
         ctlfilespecs.p_text='*';
         ctlfilespecs._text_box_error("This parameter cannot be blank");
         return(status);
      }else if (status==MFDIFF_INPUT_ERROR_FILESPEC_HAS_DIR) {
         ctlexclude_filespecs._text_box_error("This parameter may not specify subdirectories");
         return(status);
      }
      temp->path1=MaybeAppendFilesep(absolute(_fl1.p_text));
      temp->path2=MaybeAppendFilesep(absolute(_fl2.p_text));
      temp->filespec=ctlfilespecs.p_text;
      temp->excludeFilespec=ctlexclude_filespecs.p_text;
      temp->recursive=ctlrecursive.p_value!=0;
      temp->spawnProcess=ctlspawn_process.p_value!=0&&ctlspawn_process.p_enabled;
   }else{
      temp->path1=maybe_quote_filename(_fl1.p_text);
      temp->path2=maybe_quote_filename(_fl2.p_text);
      temp->recordWidth=(int)(!isinteger(_file_width.p_text)?0:_file_width.p_text);
      temp->file1IsFile=_fl1.p_next.p_next.p_next.p_next.p_value!=0;
      temp->file2IsFile=_fl2.p_next.p_next.p_next.p_next.p_value!=0;
      temp->interleaved=_ctlinterleaved.p_value?DIFF_OUTPUT_INTERLEAVED:0;
      temp->smartDiff=ctlsmart_diff.p_value!=0;

      if (isdirectory(temp->path2)) {
         if (last_char(temp->path2)!=FILESEP) temp->path2=temp->path2:+FILESEP;
         temp->path2=temp->path2:+strip_filename(temp->path1,'p');
      }

      if (temp->path1==''||temp->path2=='') {
         _message_box(nls("You must select two files to compare."));
         return(1);
      }
      if (_fl1.p_text=='.process') {
         _fl1._text_box_error("Cannot diff buffer '.process'");
         return(1);
      }
      if (_fl2.p_text=='.process') {
         _fl2._text_box_error("Cannot diff buffer '.process'");
         return(1);
      }
      if (iswildcard(strip_filename(_fl1.p_text,'P'))) {
         _message_box(nls("This parameter must be a filename or directory name.\n\nTo compare directories, filespecs should then be specified in the box below",_param1));
         _fl1._set_focus();
         return(1);
      }
      if (iswildcard(strip_filename(_fl2.p_text,'P'))) {
         _message_box(nls("This parameter must be a filename or directory name.\n\nTo compare directories, filespecs should then be specified in the box below",_param1));
         _fl2._set_focus();
         return(1);
      }
      temp->buf1=buf_match(strip(temp->path1,'B','"'),1,'E')!='';
      if (!_fl1.file_exists(temp->path1) && !temp->buf1){
         _message_box(nls("File/buffer '%s' not found",temp->path1));
         _fl1._set_focus();
         return(1);
      }
      if (last_char(temp->path2)==FILESEP) {
         filename1=absolute(temp->path1);
         rfilename=strip_filename(filename1,'p');
         temp->path2=temp->path2:+rfilename;
      }
      temp->buf2=buf_match(strip(temp->path2,'B','"'),1,'E')!='';
      file2exists=_fl2.file_exists(temp->path2) || temp->buf2;
      if (!file2exists){
         _message_box(nls("File/buffer '%s' not found",temp->path2));
         _fl2._set_focus();
         return(1);
      }
   }
   if (file_eq(absolute(temp->path1),absolute(temp->path2))) {
      if ( ((temp->file1IsFile && temp->file2IsFile)) ||
           ((!temp->file1IsFile) && (!temp->file2IsFile)) ) {
         _fl2._text_box_error("You must specify two different paths");
         _fl2._set_focus();
         return(1);
      }
   }
   _save_form_response();

   p_active_form._delete_window(0);
   return(0);
}

_ctloptions.lbutton_up()
{
   status=show('-modal _diff_options_form');
}

_ctluse_original.lbutton_up()
{
   _fl1.p_next.p_next.p_value=1;
   _fl2.p_text=_fl1.p_text;
   _fl2.p_next.p_next.p_next.p_value=1;
}

defeventtab _merge_setup_form
_ctlok.on_create()
{
   _ctlbase.p_next.p_next.p_value=1;
   _ctlrev1.p_next.p_next.p_value=1;
   _ctlrev2.p_next.p_next.p_value=1;
   _ctlinteractive.p_value=1;
   p_active_form._retrieve_prev_form();
}

//Runs both buttons
_ctlinteractive.lbutton_up()
{
   if (p_name=='_ctlinteractive') {
      _ctlsmart_merge.p_enabled=p_value!=0;
   }else{
      _ctlsmart_merge.p_enabled=p_value==0;
   }
}

//2:25pm 9/4/1997
//Needed this in 3 places, so I made it global
void _text_box_error(_str msg)
{
   _message_box(nls("%s",msg));
   _set_focus();
   _set_sel(1,length(p_text)+1);
   return;
}

static int CheckFilename(...)
{
   if (p_text=='') {
      _text_box_error("You must fill in all four filenames");
      return(1);
   }
   filename=file_match(p_text' -p',1);
   if (arg(1)!='N') {
      if (filename=='') {
         _text_box_error(nls("Could not find file %s",p_text));
         return(FILE_NOT_FOUND_RC);
      }
   }else{
#if 0
      if (!_ctloverwrite.p_value && filename!='') {
         result=_message_box(nls("File '%s' exists.\n\nOverwrite?",filename),
                             '',
                             MB_YESNOCANCEL|MB_ICONQUESTION);
         if (result!=IDYES) {
            _set_focus();
            _set_sel(1,length(p_text)+1);
            return(1);
         }
      }
#endif
   }
   return(0);
}
	
struct MERGE_INFO_T {
   _str basefilename;
   boolean diskbase;
   _str rev1filename;
   boolean disk1;
   _str rev2filename;
   boolean disk2
   _str outputfilename;
   boolean overwriteoutput;
   boolean smart;
   boolean interleaved;
};

static _str GetFilenameStr()
{
   if (p_next.p_next.p_value) {//File is on
      return('+d 'absolute(maybe_quote_filename(p_text)));
   }else{
      return(absolute(maybe_quote_filename(p_text)));
   }
}

int _ctlok.lbutton_up()
{
   MERGE_INFO_T temp;
   status=_ctlbase.CheckFilename();
   if (status) return status;

   status=_ctlrev1.CheckFilename();
   if (status) return status;

   status=_ctlrev2.CheckFilename();
   if (status) return status;

   status=_ctloutput.CheckFilename('N');
   if (status) return status;

   temp.basefilename=   absolute(_ctlbase.p_text);
   temp.diskbase=       _ctlbase.p_next.p_next.p_value!=0;
   temp.rev1filename=   absolute(_ctlrev1.p_text);
   temp.disk1=          _ctlrev1.p_next.p_next.p_value!=0;
   temp.rev2filename=   absolute(_ctlrev2.p_text);
   temp.disk2=          _ctlrev2.p_next.p_next.p_value!=0;
   temp.outputfilename= absolute(_ctloutput.p_text);
   //temp.overwriteoutput=_ctloverwrite.p_value!=0;
   temp.smart          =(_ctlsmart_merge.p_value!=0 && _ctlsmart_merge.p_enabled!=0);
   temp.interleaved    =_ctlinterleaved.p_value!=0;

   status=DoubleCheckAllFilenames(temp.basefilename,temp.rev1filename,
                                  temp.rev2filename,temp.outputfilename);
   if (status) return(status);

   _param1=temp;
   p_active_form._save_form_response();
   p_active_form._delete_window(0);
   return(0);
}

static int DoubleCheckAllFilenames(_str basefilename,_str rev1filename,
                                   _str rev2filename,_str outputfilename)
{
   basefilename=maybe_quote_filename(basefilename);
   rev1filename=maybe_quote_filename(rev1filename);
   rev2filename=maybe_quote_filename(rev2filename);
   outputfilename=maybe_quote_filename(outputfilename);
   if (pos(' 'basefilename' ',' 'rev1filename' 'rev2filename' 'outputfilename,1,_fpos_case)) {
      _message_box(nls("You have used %s twice.",basefilename));
      return(1);
   }
   if (pos(' 'rev1filename' ',' 'basefilename' 'rev2filename' 'outputfilename,1,_fpos_case)) {
      _message_box(nls("You have used %s twice.",rev1filename));
      return(1);
   }
   if (pos(' 'rev2filename' ',' 'basefilename' 'rev1filename' 'outputfilename,1,_fpos_case)) {
      _message_box(nls("You have used %s twice.",rev2filename));
      return(1);
   }
   if (pos(' 'outputfilename' ',' 'basefilename' 'rev1filename' 'rev2filename,1,_fpos_case)) {
      _message_box(nls("You have used %s twice.",outputfilename));
      return(1);
   }
   return(0);
}

static _str OnDisk(...)
{
   if (arg(1)) return('+d');
   return('');
}

static int OpenAllViews(MERGE_INFO_T mInfo,var BaseFileViewId,var Rev1ViewId,
                        var Rev2ViewId,var OutputViewId1,var OutputViewId2,
                        var OutputExists)
{
   //Id changes in here
   orig_view_id=p_view_id;
   orig_wid=p_window_id;
   status=SmartOpen(mInfo.basefilename,BaseFileViewId,orig_view_id,OnDisk(mInfo.diskbase));
   if (status) {
      _message_box(nls("Could not open file %s\n%s",mInfo.basefilename,
                   get_message(status)));
      return(status);
   }
   p_view_id=orig_view_id;
   status=SmartOpen(mInfo.rev1filename,Rev1ViewId,orig_view_id,OnDisk(mInfo.disk1));
   if (status) {
      _message_box(nls("Could not open file %s\n%s",mInfo.rev1filename,
                   get_message(status)));
      return(status);
   }
   p_view_id=orig_view_id;
   status=SmartOpen(mInfo.rev2filename,Rev2ViewId,orig_view_id,OnDisk(mInfo.disk2));
   if (status) {
      _message_box(nls("Could not open file %s\n%s",mInfo.rev2filename,
                   get_message(status)));
      return(status);
   }
   p_view_id=orig_view_id;
   //Do not give this buffer a name right now...
   orig_view_id=_create_temp_view(OutputViewId1);
   if (orig_view_id=='') return(1);//We are in BAD shape
   p_view_id=orig_view_id;

   OutputExists=1;
   //def_load_options' +q +c +b 'mInfo.outputfilename);
   status=_open_temp_view(mInfo.outputfilename,temp_view_id,junk_view_id,'+b');
   if (status) {
      OutputExists=0;
      orig_view_id=_create_temp_view(OutputViewId2);
      if (orig_view_id=='') return(1);//We are in BAD shape
      p_buf_name=mInfo.outputfilename;
   }else{
      OutputViewId2=p_view_id;
   }
   //Now go back and give the first buffer a name
   p_view_id=OutputViewId1;
   p_buf_name=mInfo.outputfilename;
#if 0
   _delete_line();
#endif
   p_view_id=orig_view_id;
   p_window_id=orig_wid;
   return(0);
}

struct BUFFER_INFO_T {
   int buf_flags;
   int inmem;
};

static BUFFER_INFO_T BufferInfoArray[];

//Options string cannot contain a +b because that would not make sense.
//Does not activate new view if succesful.
int SmartOpen(_str Filename,int &TempViewId,int &OrigViewId,/*_str Options*/)
{
   Options=arg(4);
   if (pos('+b',Options,1,'ri')) return -5000;
   inmem=1;
   //status=_open_temp_view(Filename,TempViewId,OrigViewId,Options' +b ');
   OrigViewId=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   status=load_files(Options' +q +c +b 'Filename);
   if (status) {
      status=load_files(Options' +q +c 'Filename);
      if (status) {
         p_view_id=OrigViewId;
         return status;
      }
      inmem=0;
   }
   TempViewId=p_view_id;
   BufferInfoArray[-TempViewId].buf_flags=p_buf_flags;
   p_buf_flags=THROW_AWAY_CHANGES|HIDE_BUFFER;
   BufferInfoArray[-TempViewId].inmem=inmem;
   return(status);
}

void SmartClose(int TempViewId)
{
   if (!isinteger(TempViewId)) return;
   if (BufferInfoArray[-TempViewId]._varformat()==VF_EMPTY) return;
   OrigViewId=p_view_id;
   if (OrigViewId==TempViewId) {
      _message_box(nls("got here ids were the same"));
   }
   if (BufferInfoArray[-TempViewId].inmem) {
      p_view_id=TempViewId;
      p_buf_flags=BufferInfoArray[-TempViewId].buf_flags;
      _quit_view();
      p_view_id=OrigViewId;
   }else{
      _delete_temp_view(TempViewId);
   }
   BufferInfoArray[-TempViewId]._makeempty();
}

const MERGE_SMART=              0x01;
const MERGE_DIALOG_OUTPUT=      0x02;
const MERGE_INTERLEAVED_OUTPUT= 0x04;

//If arg(2) is not '', it should be a 0 if the file was not already in memory,
//or a 1 if it was
static void PrepEditControl(int ViewId,...)
{
   inmem=(arg(2)!='')?(arg(2)):0;
   _delete_buffer();
   load_files('+v 'ViewId);
   if (!inmem) {
      select_edit_mode();
      //ext=refer_ext(_file_case(get_extension(p_buf_name)),p_buf_name);
      //if (ext!='') select_edit_mode(ext);
   }
   p_buser=p_color_flags;
   p_color_flags|=MODIFY_COLOR_FLAG;
   p_user=p_buf_id' 'inmem' 'p_readonly_mode;
   p_modify=0;
}

static void SetUndoSteps()
{
   list = def_load_options;
   list=lowcase(list);
   undosteps=0;
   for (;;) {
      cur=parse_file(list);
      if (cur=='') break;
      if (substr(cur,2,2)=='u:') {
         parse cur with 'u:' undosteps;
      }
   }
   p_undo_steps=undosteps;
}

_command int merge() name_info(FILE_ARG'*,')
{
   if (p_window_id==_mdi) {
      p_window_id=_mdi.p_child;
   }
   real_orig_view_id=p_view_id;
   vcmerge=0;
   MERGE_INFO_T mInfo;
   if (arg(1)=='') {
      status=show('-modal _merge_setup_form');
      if (status) return status;
      mInfo=_param1;
   }else{
      vcmerge=1;
      //IF THERE ARE COMMAND LINE ARGUMENTS, WE ASSUME VC MERGE!!!!!!
      parse arg(1) with mInfo.basefilename mInfo.rev1filename mInfo.rev2filename mInfo.outputfilename;
      if (mInfo.basefilename==''||mInfo.rev1filename==''||mInfo.rev2filename==''||
          mInfo.outputfilename=='') {
         message('usage:merge <basefile> <rev1> <rev2> <outputfilename>');
         return(INVALID_ARGUMENT_RC);
      }
      mInfo.smart=true;
      mInfo.interleaved=false;
      mInfo.overwriteoutput=true;//Should be a nonexistent temp file - should not matter
      mInfo.diskbase=mInfo.disk1=true;
      //if vc merge, want to be sure that we get the file in memory if there is one
      mInfo.disk2=buf_match(absolute(mInfo.rev2filename),1)=='';
   }
   status=OpenAllViews(mInfo,BaseFileViewId,Rev1ViewId,Rev2ViewId,OutputViewId1,
                       OutputViewId2,OutputExists);
   if (status) {
      return status;
   }
   mou_hour_glass(1);
   flags=0;
   if (mInfo.smart) flags|=MERGE_SMART;
   if (mInfo.interleaved) {
      flags|=MERGE_INTERLEAVED_OUTPUT;
   }else{
      flags|=MERGE_DIALOG_OUTPUT;
   }
   MergeFiles(BaseFileViewId,Rev1ViewId,Rev2ViewId,OutputViewId1,OutputViewId2,
              flags);
   if (absolute(mInfo.basefilename)!=absolute(mInfo.outputfilename)) {
      SmartClose(BaseFileViewId);
   }else{
      ovid=p_view_id;
      p_view_id=BaseFileViewId;
      _quit_view();
      p_view_id=ovid;
   }
   SmartClose(Rev1ViewId);
   NeedToCloseOutput2=0;
   if (absolute(mInfo.outputfilename)!=absolute(mInfo.rev2filename)) {
      //It seems that SmartClose still isn't that smart
      p_view_id=real_orig_view_id;
      SmartClose(Rev2ViewId);
   }else{
      orig_view_id=p_view_id;
      p_view_id=Rev2ViewId;
      _quit_view();
      p_view_id=orig_view_id;
      NeedToCloseOutput2=mInfo.disk2;
   }
   NumConflicts=MergeNumConflicts();
   status=0;
   int diff_form_wid;
   if (NumConflicts && !mInfo.interleaved) {
      parent_option=(machine()=='OS2386')?'-mdi':'-desktop';
      diff_form_wid=show(parent_option' -xy -hidden -mdi _diff_form',mInfo.outputfilename,mInfo.outputfilename);
      _nocheck _control _ctlhelp;
      _nocheck _control _ctlfile1;
      _nocheck _control _ctlfile2;
      diff_form_wid._ctlhelp.p_help="Merge dialog box";
      if (vcmerge) {
         diff_form_wid._ctlok.p_visible=1;
         diff_form_wid._ctlok.p_enabled=1;
      }
      orig_wid=p_window_id;
      p_window_id=diff_form_wid;
      _nocheck _control _ctlfile1;
      _nocheck _control _ctlfile1_readonly;
      _nocheck _control _ctlfile2;
      _nocheck _control _ctlfile2save;
      _nocheck _control _ctlfile1save;
      _nocheck _control _ctlcopy_left;
      _nocheck _control _ctlcopy_left_all;
      _nocheck _control _ctlcopy_right_all;
      _nocheck _control vscroll1;
      _nocheck _control hscroll1;
      _nocheck _control _ctlnext_difference;
      _nocheck _control _ctlinserted_label;
      _nocheck _control _ctlmodified_label;
      _nocheck _control _ctlnext_difference;
      _nocheck _control _ctlprev_difference;
      _nocheck _control _ctlcopy_right;
      _nocheck _control _ctlcopy_right_all;
      _nocheck _control _ctlcopy_right_line;
      _nocheck _control _ctlcopy_left_line;
      p_caption='Merge - 'NumConflicts' Conflict':+((NumConflicts>1)?'s':'');
      _ctlcopy_right.p_caption="Copy &1>>";
      _ctlcopy_right.p_width=_ctlcopy_right_all.p_width;
      _ctlcopy_right_all.p_caption="Copy &2>>";
      _ctlfile1.PrepEditControl(OutputViewId1);
      _ctlfile2.PrepEditControl(OutputViewId2,OutputExists);
      _ctlfile1_readonly.p_value=1;
      diff_form_wid._ctlfile1.p_ProtectReadOnlyMode=(diff_form_wid._ctlfile1_readonly.p_value)?VSPROTECTREADONLYMODE_ALWAYS:VSPROTECTREADONLYMODE_NEVER;
      _ctlfile1_readonly.p_enabled=0;
      diff_form_wid._ctlfile1.SetUndoSteps()
      diff_form_wid._ctlfile2.SetUndoSteps()
      _ctlfile1.BlastUndoInfo();
      _ctlfile2.BlastUndoInfo();
      _ctlfile1save.p_visible=0;
      _ctlcopy_left.p_visible=0;
      _ctlcopy_right_line.p_visible=0;
      _ctlcopy_left_line.p_visible=0;
      _ctlcopy_left_all.p_visible=0;
      _ctlfile2save.p_caption="&Save";
      _ctlfile2.p_modify=1;
      _ctlinserted_label.p_caption=mInfo.rev1filename;
      _ctlmodified_label.p_caption=mInfo.rev2filename;
      _PositionDiffLegendLabels();

      vscroll1.p_max=diff_form_wid._ctlfile1.p_Noflines+1;
      vscroll1.p_min=0;
      vscroll1.p_large_change=diff_form_wid._ctlfile1.p_char_height-1;

      hscroll1.p_max=max(diff_form_wid._ctlfile1._find_longest_line() intdiv diff_form_wid._ctlfile1._text_width("W"),\
                         diff_form_wid._ctlfile2._find_longest_line() intdiv diff_form_wid._ctlfile2._text_width("W"));
      hscroll1.p_min=0;
      hscroll1.p_large_change=diff_form_wid._ctlfile1.p_char_height-1;

      _ctlfile1.p_line=0;_ctlfile2.p_line=0;
      _ctlnext_difference.call_event(_ctlnext_difference,LBUTTON_UP);
      _ctlnext_difference.p_caption='&Next Conflict';
      _ctlprev_difference.p_caption='&Prev Conflict';

      //Turn on Draw box around current line
      _ctlfile1.p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG|OVERRIDE_CURLINE_COLOR_WFLAG);
      _ctlfile1.p_window_flags&=~(CURLINE_COLOR_WFLAG);
      _ctlfile2.p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG|OVERRIDE_CURLINE_COLOR_WFLAG);
      _ctlfile2.p_window_flags&=~(CURLINE_COLOR_WFLAG);
      p_visible=1;
      status=_modal_wait(diff_form_wid);
      p_view_id=real_orig_view_id;
      p_window_id=orig_wid;
      mou_hour_glass(0);
      _delete_temp_view(OutputViewId1);
      if (NeedToCloseOutput2) {
         status=load_files('+q +b 'absolute(mInfo.rev2filename));
         if (!status) _delete_buffer();
      }
   }else{
      orig_view_id=p_view_id;
      _delete_temp_view(OutputViewId2);
      p_view_id=OutputViewId1;
      //We used to save the file here, but now we just name it so that
      //we're ok for the demo
      p_buf_name=mInfo.outputfilename;
      p_view_id=OutputViewId1;
      if (vcmerge) {
         _save_file("+o");//Save the temp file so that we can "get" it later
      }
      _quit_view();
      mou_hour_glass(0);
      if (!vcmerge) {
         //Don't want to bring this to foreground if vcmerge
         status=edit('+b 'absolute(mInfo.outputfilename));
      }
      if (status) {
         return status;
      }
      SetUndoSteps();
      select_edit_mode();
      if (NumConflicts) {
         _message_box(nls("Merge complete, %s conflicts detected",NumConflicts));
         p_line=0;
         search('^':+_escape_re_chars('******* Conflict 1'),'ri@<');
      }
   }
   return(status);
}

int gindex1,gindex2;//Used for debugging
int def_max_fast_diff_size;
defeventtab _difftree_output_form

/*

10:59am 5/27/1998
TreeUserInfo for treenodes is in the following format:

binarydatestring<ascii1>[manually hidden flag]

if "manually hidden flag" is 1, this node was manually hidden by the user.
Otherwise, it can be ''.

*/
#define GFilespecList        p_active_form.p_user
#define GExcludeFilespecList ctlclose.p_user
#define GPath1               tree1.p_user
#define GPath2               tree2.p_user
#define GRecursive           ctlleft.p_user
#define GModified            ctlright.p_user
#define GNoOnChange          ctlcopy_right.p_user
#define GReportInfo          ctlcopy_left.p_user
#define GNumHidden           ctlnext_mismatch.p_user
#define GChildDiffInfoList   ctlprev_mismatch.p_user

struct REPORT_INFO {
   int action;
   _str time;
   _str data1,
        data2,
        data3,
        data4;
}

/*
DIFF_REPORT_CREATED          data2=path1 data3=path2 data4=filespecs
DIFF_REPORT_LOADED           data1=filename data2=path1 data3=path2 data4=filespecs
DIFF_REPORT_DIFF             data1=filename1 data2=filename2 data3-4 unused
DIFF_REPORT_FILE_CHANGE      data1=filename1 data3-4 unused

DIFF_REPORT_COPY_FILE        data1=sourceFilename data2=destFilename data3-4 unused
DIFF_REPORT_COPY_TREE        data1=path1 data2=path2 data3-4 unused
DIFF_REPORT_COPY_TREE_FILE   data1=sourceFilename data2=destFilename data3-4 unused

DIFF_REPORT_DELETE_FILE      data1=filename
DIFF_REPORT_DELETE_TREE      data1=path1 data2-4 unused
DIFF_REPORT_DELETE_TREE_FILE data1=Filename data2-4 unused

//not going to use these right now
DIFF_REPORT_SAVED_DIFF_STATE data1=filename data2-data4 unused
DIFF_REPORT_SAVED_PATH1_LIST data1=path(from diff) data2=filename
DIFF_REPORT_SAVED_PATH2_LIST data1=path(from diff) data2=filename data3-4 unused

DIFF_REPORT_REFRESH_CHANGED   data1-4 unused
DIFF_REPORT_REFRESH_ALL       data1-4 unused
*/
void _AppendToDiffReport(int action,
                    _str data1='',_str data2='',
                    _str data3='',_str data4='')
{
   REPORT_INFO Report[];
   Report=GReportInfo;
   int len=0;
   if (Report._varformat()==VF_ARRAY) {
      len=Report._length();
   }
   Report[len].action=action;
   Report[len].time=_time();
   Report[len].data1=maybe_quote_filename(data1);
   Report[len].data2=maybe_quote_filename(data2);
   Report[len].data3=maybe_quote_filename(data3);
   Report[len].data4=maybe_quote_filename(data4);
   GReportInfo=Report;
}

static void GenerateReport()
{
   REPORT_INFO Report[];
   Report=GReportInfo;
   orig_view_id=_create_temp_view(temp_view_id);
   _delete_line();
   int len=Report._length();
   for (i=0;i<len;++i) {
      REPORT_INFO *pCur=&Report[i];
      //time=_time()':'
      line=pCur->time':';
      switch (pCur->action) {
      case DIFF_REPORT_CREATED:
         line=line:+'Started diff of 'pCur->data1' and 'pCur->data2;
         insert_line(line);
         line=substr('',1,length(pCur->time)):+'Filespecs='pCur->data3;
         insert_line(line);
         break;
      case DIFF_REPORT_LOADED:
         line=line:+'Loaded diff of 'pCur->data2' and 'pCur->data3' from 'pCur->data1;
         insert_line(line);
         line=substr('',1,length(pCur->time)):+'Filespecs='pCur->data4;
         insert_line(line);
         break;
      case DIFF_REPORT_DIFF:
         line=line:+'Diffed 'pCur->data1' and 'pCur->data2;
         insert_line(line);
         break;
      case DIFF_REPORT_FILE_CHANGE:
         line=line:+pCur->data1' changed during diff';
         insert_line(line);
         break;
      case DIFF_REPORT_COPY_FILE:
         line=line:+'Copied 'pCur->data1' to 'pCur->data2;
         insert_line(line);
         break;
      case DIFF_REPORT_COPY_TREE:
         line=line:+'Copying tree 'pCur->data1' to 'pCur->data2;
         insert_line(line);
         break;
      case DIFF_REPORT_COPY_TREE_FILE  :
         line=line:+'Copied 'pCur->data1' to 'pCur->data2' during tree copy';
         insert_line(line);
         break;
      case DIFF_REPORT_DELETE_FILE:
         line=line:+'Deleted 'pCur->data1
         insert_line(line);
         break;
      case DIFF_REPORT_DELETE_TREE:
         line=line:+'Deleting tree 'pCur->data1;
         insert_line(line);
         break;
      case DIFF_REPORT_DELETE_TREE_FILE:
         line=line:+'Deleted 'pCur->data1' during tree delete';
         insert_line(line);
         break;
      case DIFF_REPORT_REFRESH_CHANGED:
         line=line:+'Refreshed modified files';
         insert_line(line);
         break;
      case DIFF_REPORT_REFRESH_ALL:
         line=line:+'Refreshed all files';
         insert_line(line);
         break;
      }
   }
   bid=p_buf_id;
   p_modify=0;
   p_view_id=orig_view_id;
   show('-modal _showbuf_form',bid,'Multi-File Diff Report','S');
   p_active_form._set_foreground_window();
   _delete_temp_view(temp_view_id);
}

static int maybe_load_picture(int index,_str filename)
{
   newfilename=slick_path_search(filename);
   if (newfilename=='') {
      return(-1);
   }
   return(_update_picture(index,newfilename));
}


definit()
{
   if (arg(1)!='L') {
      return;
   }
   if (_pic_file_match<=0) {
      _pic_file_match=maybe_load_picture(-1,'_filemch.bmp');
      if (_pic_file_match>0) {
         set_name_info(_pic_file_match,"These files match");
      }
   }
   if (_pic_filed<=0) {
      _pic_filed=maybe_load_picture(-1,'_diffd.bmp');
      if (_pic_filed>0) {
         set_name_info(_pic_filed,"These files are different");
      }
   }
   if (_pic_filed2<=0) {
      _pic_filed2=maybe_load_picture(-1,slick_path_search('_diffd2.bmp'));
      if (_pic_filed2>0) {
         set_name_info(_pic_filed2,"These files are different, but you have viewed them");
      }
   }
   if (_pic_filem<=0) {
      _pic_filem=maybe_load_picture(-1,slick_path_search('_diffm.bmp'));
      if (_pic_filem>0) {
         set_name_info(_pic_filem,"This file does not exist");
      }
   }
   if (_pic_filep<=0) {
      _pic_filep=maybe_load_picture(-1,slick_path_search('_diffp.bmp'));
      if (_pic_filep>0) {
         set_name_info(_pic_filep,"This file only exists in this path");
      }
   }
   if (_pic_fldopenp<=0) {
      _pic_fldopenp=maybe_load_picture(-1,slick_path_search('_diffopp.bmp'));
      if (_pic_fldopenp>0) {
         set_name_info(_pic_fldopenp,"This directory only exists in this path");
      }
   }
   if (_pic_fldopenm<=0) {
      _pic_fldopenm=maybe_load_picture(-1,slick_path_search('_diffopm.bmp'));
      if (_pic_fldopenm>0) {
         set_name_info(_pic_fldopenm,"This directory does not exist");
      }
   }
   if (_pic_diffzs2<=0) {
      _pic_diffzs2=maybe_load_picture(-1,slick_path_search('diffz2.bmp'));
   }
   rc=0;
}

void _difftree_output_form.on_resize()
{
   oldcopy=ctlcopy_right.p_visible;
   ctlleft.p_visible=ctlright.p_visible=0;
   ctlcopy_right.p_visible=ctlcopy_left.p_visible=0;
   xbuff=tree1.p_x;
   tree1.p_width=(_dx2lx(SM_TWIP,p_active_form.p_client_width) intdiv 2)-xbuff;
   tree2.p_x=tree1.p_x+tree1.p_width+_twips_per_pixel_x();
   ctlpath2label.p_x=tree2.p_x;
   tree2.p_width=tree1.p_width;
   formheight=_dy2ly(SM_TWIP,p_active_form.p_client_height);

   //10:42am 5/13/1998
   //Too much flicker turning all controls on and off, so just do the ones that
   //get "overwritten"
   //ctloptions.p_visible=ctlclose.p_visible=ctlnext_mismatch.p_visible=ctlleft.p_visible=ctlright.p_visible=ctlreport.p_visible=0;
   cpy_visible=ctlcopy_right.p_visible;


   ctlclose.p_y=(formheight-xbuff)-ctlclose.p_height;
   ctlrefresh.p_y=ctlsave.p_y=ctlnext_mismatch.p_y=ctlprev_mismatch.p_y=ctloptions.p_y=ctlreport.p_y=ctlclose.p_y;
   ctlleft.p_y=(ctlclose.p_y-xbuff)-ctlleft.p_height;
   ctlright.p_y=ctlleft.p_y;
   ctlright.p_x=tree2.p_x;                                                                              //10:42am 5/13/1998
   //Too much flicker turning all controls on and off, so just do the ones that
   //get "overwritten"
   //ctloptions.p_visible=ctlclose.p_visible=ctlnext_mismatch.p_visible=ctlleft.p_visible=ctlright.p_visible=ctlreport.p_visible=0;
   //ctloptions.p_visible=ctlclose.p_visible=ctlnext_mismatch.p_visible=ctlleft.p_visible=ctlright.p_visible=ctlreport.p_visible=1;
   ctlleft.p_visible=ctlright.p_visible=1;
   ctlcopy_right.p_visible=ctlcopy_left.p_visible=cpy_visible;


   tree1.p_height=tree2.p_height=ctlleft.p_y-((xbuff*2)+tree1.p_y);
   filenamewidth=ctlpath2label.p_x-ctlpath1label.p_x-ctlpath1label._text_width('Path &1:');
   ctlpath1label.p_caption='Path &1:':+_ShrinkFilename(ctlpath1label.p_user,filenamewidth);
   ctlpath2label.p_caption='Path &2:':+_ShrinkFilename(ctlpath2label.p_user,filenamewidth);
   ctlcopy_right.p_y=ctlright.p_y;

   ctlcopy_left.p_y=ctlleft.p_y;

   int xbuf=ctlcopy_right.p_x-(ctlleft.p_x+ctlleft.p_width);
   ctlcopy_left.p_x=ctlright.p_x+ctlright.p_width+xbuf;
   ctlcopy_left.p_x+ctlcopy_left.p_width+xbuf;
   ctlcopy_right.p_visible=ctlcopy_left.p_visible=oldcopy;
   ctlleft.p_visible=ctlright.p_visible=1;
}

void ctloptions.lbutton_up()
{
   status=show('-modal _diff_options_form');
}

void ctlreport.lbutton_up()
{
   GenerateReport();
}

int ctlsave.lbutton_up()
{
   result=show('-modal _difftree_save_form',ctlpath1label.p_user,ctlpath2label.p_user);
   if (result=='') return(COMMAND_CANCELLED_RC);
   if (result=='S') {
      //Save state
      result=_OpenDialog('-modal '_stdform('_open_form'),
                         'Save Diff State As', // Dialog Box Title
                         '',                   // Initial Wild Cards
                         'Diff History Files (*.':+DIFF_STATEFILE_EXT:+')',       // File Type List
                         OFN_SAVEAS,        // Flags
                         DIFF_STATEFILE_EXT
                         );
      if (result=='') return(COMMAND_CANCELLED_RC);
      SaveMFDiffInfo(result);
      _AppendToDiffReport(DIFF_REPORT_SAVED_DIFF_STATE,result);
      GModified=0;
      return(0);
   }
   ch=substr(result,1,1);
   if (ch=='L' || ch=='R') {
      //Save file list
      parse result with type ' ' flags;
      result=_OpenDialog('-modal '_stdform('_open_form'),
                         'Save Diff Filelist As',                   // Dialog Box Title
                         '',                   // Initial Wild Cards
                         'Diff Filelist (*.lst)',    // File Type List
                         OFN_SAVEAS,
                         'lst'
                         );
      if (result=='') return(COMMAND_CANCELLED_RC);
      filename=result;
      orig_view_id=_create_temp_view(temp_view_id);
      filename=p_buf_name=result;
      p_view_id=orig_view_id;
      if (ch=='L') {
         _AppendToDiffReport(DIFF_REPORT_SAVED_PATH1_LIST,GPath1,filename);
         tree1.WriteDiffTreeData(TREE_ROOT_INDEX,0,temp_view_id,'L',flags);
      }else if (ch=='R') {
         _AppendToDiffReport(DIFF_REPORT_SAVED_PATH2_LIST,GPath2,filename);
         tree2.WriteDiffTreeData(TREE_ROOT_INDEX,0,temp_view_id,'L',flags);
      }
      p_view_id=temp_view_id;
      status=_save_file('+o');
      if (status) {
         _message_box(nls("Could not save file '%s'\n\n%s",filename,get_message(status)));
         return(status);
      }
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      return(0);
   }
   return(0);
}

static int GetPathIndex(_str Path,_str BasePath,int (&PathTable):[],
                        int FolderIndex=_pic_fldopen,boolean recursive=false,
                        int IndexTable:[]=null)
{
   _str PathsToAdd[];int count=0;
   _str OtherPathsToAdd[];
   int Othercount=0;
   Path=strip(Path,'B','"');
   BasePath=strip(BasePath,'B','"');
   if (PathTable._indexin(_file_case(Path))) {
      return(PathTable:[_file_case(Path)]);
   }
   Parent=TREE_ROOT_INDEX;
   for (;;) {
      PathsToAdd[count++]=Path;
      if (Path=='') {
         break;
      }
      Path=substr(Path,1,length(Path)-1);
      tPath=strip_filename(Path,'N');
      if (file_eq(Path:+FILESEP,BasePath) || file_eq(tPath,Path)) break;
      if (isunc_root(Path)) break;
      Path=tPath;
      if (PathTable._indexin(_file_case(Path))) {
         Parent=PathTable:[_file_case(Path)];
         break;
      }
   }
   PathsToAdd._sort('F');
   for (i=0;i<PathsToAdd._length();++i) {
      if ( (FolderIndex==_pic_fldopenp || FolderIndex==_pic_fldopenm) &&
           !recursive) {
         continue;
      }
      if (IndexTable._indexin(PathsToAdd[i])) {
         FolderIndex=IndexTable:[PathsToAdd[i]];
      }
      Parent=_TreeAddItem(Parent,
                          PathsToAdd[i],
                          TREE_ADD_AS_CHILD/*|TREE_ADD_SORTED_FILENAME*/,
                          FolderIndex,
                          FolderIndex,
                          1);
      PathTable:[_file_case(PathsToAdd[i])]=Parent;
   }
   return(Parent);
}

static int GetCurFilenameFromTree(_str &CurrentFilename)
{
   /*
   The error checking that this function does is kind of paranoid.  Shouldn't happen
   */
   CurrentFilename='';
   ci=_TreeCurIndex();
   pi=_TreeGetParentIndex(ci);
   if (pi==TREE_ROOT_INDEX) return(1);//Nothing we can do here
   CurrentFilename=_TreeGetCaption(pi):+_TreeGetCaption(ci);
   return(0);
}

static void CopyDifferentFile(int SourceWID,int DestWID)
{
   mou_hour_glass(1);
   status=SourceWID.GetCurFilenameFromTree(SourceFilename);
   if (status) return;
   status=DestWID.GetCurFilenameFromTree(DestFilename);
   if (status) return;

   buf1=buf_match(absolute(SourceFilename),1)!='';
   buf2=buf_match(absolute(DestFilename),1)!='';

   int filestatus=0;
   {
      //Ok, to REALLY do this right, we have to be sure that the buffer actually
      //matches the file on disk.  We don't have to worry about any diff
      //options, just run the FastCompare.
      wid=p_window_id;
      inmem1=inmem2=1;
      status=_mdi.p_child._open_temp_view(SourceFilename,viewid1,orig_view_id,'+b');
      if (!status) {
         status=_mdi.p_child._open_temp_view(SourceFilename,viewid2,junk_view_id,'+d');
         if (!status) {
            p_view_id=orig_view_id;
            long seek1,seek2;
            seek1=seek2=0;
            int line1=0,line2=0;
            filestatus=FastCompare(viewid1,seek1,viewid2,seek2);
            _delete_temp_view(viewid2);
         }
         p_view_id=orig_view_id;
         _delete_temp_view(viewid1);
         p_window_id=wid;
      }
   }

   if (buf1) {
      MaybeSaveBuffer(SourceFilename,filestatus);
   }

   if (buf2) {
      status=MaybeWarnModified(DestFilename);
      if (status) {
         return;
      }
   }
   status=copy_file(SourceFilename,DestFilename);
   mou_hour_glass(0);

   if (buf2) {
      ReloadBuffer(DestFilename);
   }

   if (status) {
      _message_box(nls("Could not copy '%s' to '%s'\n\n%s",SourceFilename,DestFilename,get_message(status)));
   }else{
      _UpdateFileBitmaps(SourceFilename,SourceWID._TreeCurIndex(),SourceWID,
                        DestFilename,DestWID._TreeCurIndex(),DestWID);
      _AppendToDiffReport(DIFF_REPORT_COPY_FILE,SourceFilename,DestFilename);
   }
}

void ctlcopy_left.lbutton_up()
{
   index1=tree1._TreeCurIndex();
   index2=tree2._TreeCurIndex();
   CopyDifferentFile(tree2,tree1);
   tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
   tree1.call_event(CHANGE_SELECTED,index1,tree1,ON_CHANGE,'W');
   tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
   tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));

   //Move to next mismatch
   if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
      ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
      tree1._set_focus();
   }
}

void ctlcopy_right.lbutton_up()
{
   index1=tree1._TreeCurIndex();
   index2=tree2._TreeCurIndex();
   CopyDifferentFile(tree1,tree2);
   tree1.call_event(CHANGE_SELECTED,index1,tree1,ON_CHANGE,'W');
   tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
   tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));

   tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
   //Move to next mismatch
   if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
      ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
      tree1._set_focus();
   }
}

static void GetFolderIndexes(_str path1,_str path2,int &index1,int &index2,
                             _str Options,int BothIndex,int PlusIndex,
                             int MinusIndex)
{
   path1=strip(path1,'B','"');
   path2=strip(path2,'B','"');
   if (pos(' +d ',' 'Options' ',1,'i')) {
      if (substr(path1,1,2)!='\\') {
         if (last_char(path1)==FILESEP) {
            path1=substr(path1,1,length(path1)-1);
         }
         exist1=file_match(maybe_quote_filename(path1)' 'Options' -p',1)!='';
      }else{
         //For UNC names, we can't just file match for a directory, so
         //we have to look for the first file...
         if (last_char(path1)!=FILESEP) {
            path1=path1:+FILESEP;
         }
         path1=path1'*';
         exist1=file_match(maybe_quote_filename(path1)' +p',1)!='';
      }
      if (substr(path2,1,2)!='\\') {
         if (last_char(path2)==FILESEP) {
            path2=substr(path2,1,length(path2)-1);
         }
         exist2=file_match(maybe_quote_filename(path2)' 'Options' -p',1)!='';
      }else{
         //For UNC names, we can't just file match for a directory, so
         //we have to look for the first file...
         if (last_char(path2)!=FILESEP) {
            path2=path2:+FILESEP;
         }
         path2=path2'*';
         exist2=file_match(maybe_quote_filename(path2)' +p',1)!='';
      }
   }else{
      exist1=file_match(maybe_quote_filename(path1)' 'Options' -p',1)!='';
      exist2=file_match(maybe_quote_filename(path2)' 'Options' -p',1)!='';
   }
   if (exist1 && exist2) {
      index1=BothIndex;
      index2=BothIndex;
      //index1=_pic_fldopen;
      //index2=_pic_fldopen;
   }else if (exist1 && !exist2) {
      index1=PlusIndex;
      index2=MinusIndex;
      //index1=_pic_fldopenp;
      //index2=_pic_fldopenm;
   }else if (!exist1 && exist2) {
      index1=MinusIndex;
      index2=PlusIndex;
      //index1=_pic_fldopenm;
      //index2=_pic_fldopenp;
   }else if (!exist1 && !exist2) {
      //THIS CANNOT HAPPEN
      index1=MinusIndex;
      index2=MinusIndex;
   }
}

static _str StripLastPath(_str Path)
{
   if (last_char(Path)==FILESEP) {
      Path=substr(Path,1,length(Path)-1);
   }
   Path=strip_filename(Path,'N');
   return(Path);
}

static void FillInMissing(_str FileTable:[],int otherwid,
                          _str path1,_str path2,
                          int (&PathTable1):[],
                          int (&PathTable2):[],
                          boolean recursive)
{
   path1=strip(path1,'B','"');
   path2=strip(path2,'B','"');
   LastParent=TREE_ROOT_INDEX;
   _str FileArray[];
   count=0;
   for (i._makeempty();;) {
      FileTable._nextel(i);
      if (i._isempty()) break;
      filename=FileTable:[i];
      FileArray[count++]=filename;
   }
   _str IndexTable:[];
   int Index1Table:[];
   int Index2Table:[];
   FileArray._sort('F');
   for (i=0;i<FileArray._length();++i) {
      filename=FileArray[i];
      curpath=strip_filename(filename,'N');
      isdir=last_char(filename)==FILESEP;
      if (isdir) {
         tempdir=substr(filename,1,length(filename)-1);
         tempdir=strip_filename(tempdir,'P');
         if (tempdir=='..') continue;
         if (tempdir=='.') {
            //What we want is the path without the '.' at the end
            filename=substr(filename,1,length(filename)-1);
            curpath=strip_filename(filename,'N');
         }
      }else{
         filename=strip_filename(filename,'P');
      }
      if (length(path1)==length(curpath)) {
         curpath2=path2;
      }else{
         if (last_char(path2)=='"') {
            curpath2=substr(path2,1,length(path2)-1);
            if (last_char(curpath2)!=FILESEP) {
               curpath2=curpath2:+FILESEP;
            }
            curpath2=curpath2:+substr(curpath,length(path1)+1)'"';
         }else{
            curpath2=path2:+substr(curpath,length(path1)+1);
         }
      }
      index=curpath"\t"curpath2;
#if 0
      if (!IndexTable._indexin(index)) {
         _str tcurpath=curpath,tcurpath2=curpath2;
         for (;;) {
            GetFolderIndexes(tcurpath,tcurpath2,
                             index1,index2,
                             '+d',_pic_fldopen,_pic_fldopenp,_pic_fldopenm);
            index=tcurpath"\t"tcurpath2;
            if (IndexTable._indexin(index)) break;

            IndexTable:[index]=index1"\t"index2;
            Index1Table:[tcurpath]=index1;
            Index2Table:[tcurpath2]=index2;
            tcurpath=StripLastPath(tcurpath);
            tcurpath2=StripLastPath(tcurpath2);
         }
      }
#else
      index=curpath"\t"curpath2;
      if (!IndexTable._indexin(index)) {
         GetFolderIndexes(curpath,curpath2,
                          index1,index2,
                          '+d',_pic_fldopen,_pic_fldopenp,_pic_fldopenm);
         IndexTable:[index]=index1"\t"index2;
      }else{
         parse IndexTable:[index] with index1 "\t" index2;
      }
#endif
      index=curpath"\t"curpath2;
      parse IndexTable:[index] with index1 "\t" index2;
      pindex=GetPathIndex(curpath,path1,PathTable1,index1,recursive);
      pindex2=otherwid.GetPathIndex(curpath2,path2,PathTable2,index2,recursive);
      if (!isdir && pindex>=0 && pindex>=0) {
         rfilename=strip_filename(filename,'P');
         date=_file_date(_TreeGetCaption(pindex):+rfilename,'B');
         newIndex1=_TreeAddItem(pindex,
                                rfilename,
                                TREE_ADD_AS_CHILD,
                                _pic_filep,
                                _pic_filep,
                                -1);
         _TreeSetUserInfo(newIndex1,date:+ASCII1);

         newIndex2=otherwid._TreeAddItem(pindex2,
                                         rfilename,
                                         TREE_ADD_AS_CHILD,
                                         _pic_filem,
                                         _pic_filem,
                                         -1);
         otherwid._TreeSetUserInfo(newIndex2,'-':+ASCII1);

         //This part isn't pretty(hardcoded wid's)
         if (!(def_diff_view_options&DIFF_VIEW_MISSING_FILES1)) {
            tree1._TreeGetInfo(newIndex1,state1,bm1_1,bm2_1,flags1);
            tree2._TreeGetInfo(newIndex2,state2,bm1_2,bm2_2,flags2);
            if ( (bm1_1==_pic_filem && bm1_2==_pic_filep) ) {
               tree1._TreeSetInfo(newIndex1,state1,bm1_1,bm2_1,flags1|TREENODE_HIDDEN);
               tree2._TreeSetInfo(newIndex2,state2,bm1_2,bm2_2,flags2|TREENODE_HIDDEN);
            }
         }
         if (!(def_diff_view_options&DIFF_VIEW_MISSING_FILES2)) {
            tree1._TreeGetInfo(newIndex1,state1,bm1_1,bm2_1,flags1);
            tree2._TreeGetInfo(newIndex2,state2,bm1_2,bm2_2,flags2);
            if ( (bm1_1==_pic_filep && bm1_2==_pic_filem) ) {
               tree1._TreeSetInfo(newIndex1,state1,bm1_1,bm2_1,flags1|TREENODE_HIDDEN);
               tree2._TreeSetInfo(newIndex2,state2,bm1_2,bm2_2,flags2|TREENODE_HIDDEN);
            }
         }
      }
   }
}

static void FileSort(int index)
{
   for (;index>=0;) {
      cindex=_TreeGetFirstChildIndex(index);
      if (cindex) {
         FileSort(cindex);
         _TreeSortCaption(index,'F');
      }
      index=_TreeGetNextSiblingIndex(index);
   }
}

void ctlclose.lbutton_up()
{
   if (GModified) {
      result=_message_box("Do you wish to save these results?",'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDCANCEL) return;//May not have wanted to exit
      if (result==IDYES) {
         status=ctlsave.call_event(ctlsave,LBUTTON_UP);
         if (status) return;
      }
   }
   p_active_form._delete_window('');
}

static void HideAllChildren(int index,int SearchBMIndex=0)
{
   index=_TreeGetFirstChildIndex(index);
   while (index>=0) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (state>=0) {
         HideAllChildren(_TreeGetFirstChildIndex(index));
      }
      if (!SearchBMIndex||bm1==SearchBMIndex) {
         _TreeGetInfo(index,state,bm1,bm2,flags);
         _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_HIDDEN);
      }
      index=_TreeGetNextSiblingIndex(index);
      if (index<0) break;
   }
}

static boolean isFolder(int index)
{
   return(index==_pic_fldopenm || index==_pic_fldopenp ||
          index==_pic_fldopen);
}

//Hides a node that has all hidden children
static int MaybeHideNode(int index)
{
   if (index<0) {
      return(0);
   }
   CIndex=_TreeGetFirstChildIndex(index);
   if (CIndex<0) {
      return(0);
   }
   count=0;
   NonHiddenExist=0;
   while (CIndex>=0) {
      _TreeGetInfo(CIndex,state,bm1,bm2,flags);
      if (state>=0) {
         count+=MaybeHideNode(CIndex);
      }
      _TreeGetInfo(CIndex,state,bm1,bm2,flags);
      if (!(flags&TREENODE_HIDDEN) && !isFolder(bm1)) {
         ++count;
      }
      CIndex=_TreeGetNextSiblingIndex(CIndex);
      if (CIndex<0) break;
   }
   if (!count) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_HIDDEN);
   }
   return(count);
}

static void GiveMFDIffFocus()
{
   wid=_find_formobj('_difftree_output_form','N');
   if (wid) {
      wid._set_foreground_window();
   }
}

#if 0
//Only used for debugging
static int CountHashTable(_str hashtab:[])
{
   count=0;
   for (i._makeempty();;++count) {
      hashtab._nextel(i);
      if (i._varformat()==VF_EMPTY) break;
   }
   return(count);
}
#endif


static void MakeRelativeTable(_str FileTable:[],_str BasePath,
                              _str (&RelativeTable):[])
{
   if (last_char(BasePath)!=FILESEP) {
      BasePath=BasePath:+FILESEP;
   }
   for (i._makeempty();;) {
      FileTable._nextel(i);
      if (i._varformat()==VF_EMPTY) break;
      path=substr(i,length(BasePath)+1);
      RelativeTable:[_file_case(path)]=path;
   }
}

static void FillInMissing2(_str RelativeTable1:[],
                           _str RelativeTable2:[],
                           _str CurFileTable:[],
                           int (&PathTable):[],
                           _str BasePath,
                           _str OtherBasePath
                          )
{
   if (last_char(BasePath)!=FILESEP) {
      BasePath=BasePath:+FILESEP;
   }
   for (i._makeempty();;) {
      RelativeTable1._nextel(i);
      _str CurPath=BasePath;
      p=pos(FILESEP,i);
      if (p) {
         CurPath=BasePath:+substr(i,1,p-1);
      }
      if (i._varformat()==VF_EMPTY) break;
      if (!RelativeTable2._indexin(i)) {
         //This File is missing....
         index=GetPathIndex(CurPath,BasePath,PathTable);
      }
   }
}


static void TreeCreate(...)
{
   mou_hour_glass(1);
   GNumHidden=0;
   GModified=0;
   _str FileTable1:[],FileTable2:[];
   _str path1,path2;
   _str OutputTable[];
   _str Directories[];
   int PathTable1:[],PathTable2:[];
   FileTable1=arg(1);
   _str modalOption='';
   if (FileTable1._varformat()==VF_LSTR) {
      mou_hour_glass(1);
      //This is a filename with stuff to load...
      filename=FileTable1;
      status=_ini_get_value(filename,'State','def_diff_view_options',result,'');
      if (result!='') def_diff_view_options=result;

      status=_ini_get_value(filename,'State','filespec_list',result,'');
      if (result!='') GFilespecList=result;

      status=_ini_get_value(filename,'State','exclude_filespec_list',result,'');
      if (result!='') GExcludeFilespecList=result;

      status=_ini_get_value(filename,'State','path1',result,'');
      if (result!='') path1=GPath1=result;

      status=_ini_get_value(filename,'State','path2',result,'');
      if (result!='') path2=GPath2=result;

      status=_ini_get_value(filename,'State','recursive',result,'');
      if (result!='') GRecursive=result;

      tree1.ReadTree(filename,'TreeData1');
      tree2.ReadTree(filename,'TreeData2');
      p_active_form.p_caption='Multi-File Diff Output ('GPath1' 'GPath2')';
      modalOption=_default_option(VSOPTION_MDI_SHOW_WINDOW_FLAGS)==SW_HIDE;
      tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'W');
      tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree2,ON_CHANGE,'W');
      _AppendToDiffReport(DIFF_REPORT_LOADED,filename,path1,path2,GFilespecList);
      mou_hour_glass(0);
   }else{
      GPath1=path1=arg(2);
      FileTable2=arg(3);
      GPath2=path2=arg(4);
      p_active_form.p_caption='Multi-File Diff Output ('path1' 'path2')';
      OutputTable=arg(5);
      BasePath1=arg(6);
      BasePath2=arg(7);
      GRecursive=recursive=arg(8);
      GFilespecList=arg(9);
      GExcludeFilespecList=arg(10);
      LastParent1=LastParent2=TREE_ROOT_INDEX;
      modalOption=arg(11);
      for (i=0;i<OutputTable._length();++i) {
         parse OutputTable[i] with filename1 "\t" date1 "\t" filename2 "\t" date2 "\t" status;
         curpath1=strip_filename(filename1,'N');
         curpath2=strip_filename(filename2,'N');
         filename1=strip_filename(filename1,'P');
         filename2=strip_filename(filename2,'P');
         parent1=tree1.GetPathIndex(curpath1,path1,PathTable1,_pic_fldopen,recursive);
         parent2=tree2.GetPathIndex(curpath2,path2,PathTable2,_pic_fldopen,recursive);
         if (status) {
            bmindex=_pic_filed;
         }else if (last_char(filename1)==FILESEP) {
            bmindex=_pic_fldopen;
         }else{
            bmindex=_pic_file_match;
         }
         newIndex1=tree1._TreeAddItem(parent1,
                                      filename1,
                                      TREE_ADD_AS_CHILD,
                                      bmindex,
                                      bmindex,
                                      -1);
         tree1._TreeSetUserInfo(newIndex1,date1:+ASCII1);
         newIndex2=tree2._TreeAddItem(parent2,
                                      filename2,
                                      TREE_ADD_AS_CHILD,
                                      bmindex,
                                      bmindex,
                                      -1);
         tree2._TreeSetUserInfo(newIndex2,date2:+ASCII1);
         if (bmindex==_pic_file_match && !(def_diff_view_options&DIFF_VIEW_MATCHING_FILES)) {
            tree1._TreeSetInfo(newIndex1,-1,bmindex,bmindex,TREENODE_HIDDEN);
            tree2._TreeSetInfo(newIndex2,-1,bmindex,bmindex,TREENODE_HIDDEN);
         }else if (bmindex==_pic_filed && !(def_diff_view_options&DIFF_VIEW_DIFFERENT_FILES)) {
            tree1._TreeSetInfo(newIndex1,-1,bmindex,bmindex,TREENODE_HIDDEN);
            tree2._TreeSetInfo(newIndex2,-1,bmindex,bmindex,TREENODE_HIDDEN);
         }
      }
      LastParent=TREE_ROOT_INDEX;
      tree1.FillInMissing(FileTable1,tree2,path1,path2,PathTable1,PathTable2,recursive);
      tree2.FillInMissing(FileTable2,tree1,path2,path1,PathTable2,PathTable1,recursive);
#if 0
      _str RelativeTable1:[],RelativeTable2:[];
      MakeRelativeTable(FileTable1,path1,RelativeTable1);
      MakeRelativeTable(FileTable2,path2,RelativeTable2);
      FillInMissing2(RelativeTable1,RelativeTable2,FileTable1,PathTable1,path1,path2);
      FillInMissing2(RelativeTable2,RelativeTable1,FileTable2,PathTable2,path2,path1);
#endif
#if 0
      show('-modal _var_editor_form','',&RelativeTable1);
      show('-modal _var_editor_form','',&RelativeTable2);
#endif

      if (!(def_diff_view_options&DIFF_VIEW_MISSING_FILES1)) {
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);
      }else if (!(def_diff_view_options&DIFF_VIEW_MISSING_FILES2)) {
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);
      }
      tree1._TreeTop();//tree2._TreeTop();
      tree1.call_event(CHANGE_SELECTED,tree1._TreeGetFirstChildIndex(TREE_ROOT_INDEX),tree1,ON_CHANGE,'W');
      tree1.FileSort(TREE_ROOT_INDEX);
      tree2.FileSort(TREE_ROOT_INDEX);
      _AppendToDiffReport(DIFF_REPORT_CREATED,path1,path2,GFilespecList);
   }
   if (modalOption!='') {
      _post_call(GiveMFDIffFocus);
   }
   ctlpath1label.p_user=path1;
   ctlpath1label.p_caption='Path &1:'path1;
   ctlpath2label.p_user=path2;
   ctlpath2label.p_caption='Path &2:'path2;
   tree1.MaybeHideNode(TREE_ROOT_INDEX);
   tree2.MaybeHideNode(TREE_ROOT_INDEX);
   ctlcopy_left.ctlcopy_right.p_visible=0;
   if (def_diff_edit_options&DIFF_START_AT_FIRST_DIFF) {
      ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
      tree1._set_focus();
   }
   mou_hour_glass(0);
}

void tree1.on_create()
{
   //Could not call call_event for on create with enough arguments
   TreeCreate(arg(1),
              arg(2),
              arg(3),
              arg(4),
              arg(5),
              arg(6),
              arg(7),
              arg(8),
              arg(9),
              arg(10),
              arg(11))
}

#define DIFF_CAPTION            '&Diff'
#define DIFF_CAPTION2           'Diff'
#define VIEW_CAPTION            '&View'
#define VIEW_CAPTION2           'View'
#define COPY_RIGHT_CAPTION      'Copy File>>'
#define COPY_LEFT_CAPTION       '<<Copy File'
#define COPY_TREE_RIGHT_CAPTION 'Copy Tree>>'
#define COPY_TREE_LEFT_CAPTION  '<<Copy Tree'
#define DELETE_FILE_CAPTION     'Del File'
#define DELETE_TREE_CAPTION     'Del Tree'

void tree1.lbutton_up()
{
#if 0
   GNoOnChange=1;
   tree2._TreeCurLineNumber(_TreeCurLineNumber());
   GNoOnChange=0;
#endif
}

void tree1.lbutton_double_click()
{
   ctlleft.call_event('M',ctlleft,LBUTTON_UP,'W');
}

void tree2.lbutton_up()
{
#if 0
   GNoOnChange=1;
   tree1._TreeCurLineNumber(_TreeCurLineNumber());
   GNoOnChange=0;
#endif
}

static void TreeEnter()
{
   index=_TreeCurIndex();
   otherwid=( (p_window_id==tree1) ? tree2:tree1);
   otherindex=otherwid._TreeCurIndex();
   _TreeGetInfo(index,state);
   if (state>-1) {
      newstate=!state;
      _TreeSetInfo(index,newstate);
      otherwid._TreeSetInfo(otherindex,newstate);
   }else{
      if (p_window_id==tree1) {
         ctlleft.call_event('M',ctlleft,LBUTTON_UP,'W');
      }else{
         ctlright.call_event('M',ctlleft,LBUTTON_UP,'W');
      }
   }
}

void tree1.ENTER()
{
   TreeEnter();
}

void tree2.ENTER()
{
   TreeEnter();
}

static void DiffPrefixMatch()
{
   event=last_event();
   wid=p_window_id;
   otherwid=(p_window_id==tree1?tree2:tree1);
   index=find_index('_ul2_tree',EVENTTAB_TYPE);
   if (index) {
      wid.call_event(index,event,'E');
      otherwid.call_event(index,event,'E');
   }
}

void tree1.'A'-'Z','a'-'z'()
{
   DiffPrefixMatch();
}

void tree2.'A'-'Z','a'-'z'()
{
   DiffPrefixMatch();
}

void tree2.lbutton_double_click()
{
   ctlright.call_event('M',ctlright,LBUTTON_UP,'W');
}

static void SyncScrollPositions(_str wids)
{
   parse wids with wid1 wid2;
   wid2._TreeScroll(wid1._TreeScroll());
}

void tree1.on_change(reason)
{
   index=arg(2);
   if (!p_visible||GNoOnChange==1) return;
   switch (reason) {
   case CHANGE_SELECTED:
      if (index<0) {
         ctlleft.p_enabled=0;
         ctlright.p_enabled=0;
         return;
      }
      _TreeGetInfo(_TreeCurIndex(),state,bm1,bm2,flags);
      if (flags&TREENODE_HIDDEN) {
         foundNode=0;
         while (flags&TREENODE_HIDDEN) {
            status=call_event(p_window_id,DOWN);
            if (status) break;
            _TreeGetInfo(_TreeCurIndex(),state,bm1,bm2,flags);
         }
         if (!foundNode) {
            ctlleft.p_enabled=0;
            ctlright.p_enabled=0;
         }
      }
      GNoOnChange=1;
      if (p_window_id==tree1) {
         tree2._TreeCurLineNumber(_TreeCurLineNumber());
      }else{
         tree1._TreeCurLineNumber(_TreeCurLineNumber());
      }
      GNoOnChange=0;
      tree1._TreeGetInfo(tree1._TreeCurIndex(),junk,tree1_bmindex1,tree1_bmindex2,flags);
      tree2._TreeGetInfo(tree2._TreeCurIndex(),junk,tree2_bmindex1,tree2_bmindex2,flags);
      //say('cap1='tree1._TreeGetCaption(_TreeCurIndex()));
      //say('cap2='tree2._TreeGetCaption(_TreeCurIndex()));
      if (tree1_bmindex1==_pic_filed||
          tree1_bmindex1==_pic_filed2) {
         ctlleft.p_caption=DIFF_CAPTION;
         ctlright.p_caption=DIFF_CAPTION2;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=1;
      }else if (tree1_bmindex1==_pic_filem) {
         ctlleft.p_caption=DELETE_FILE_CAPTION;
         ctlright.p_caption=COPY_LEFT_CAPTION;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }else if (tree1_bmindex1==_pic_filep) {
         ctlleft.p_caption=COPY_RIGHT_CAPTION;
         ctlright.p_caption=DELETE_FILE_CAPTION;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }else if (tree1_bmindex1==_pic_fldopenp) {
         ctlleft.p_caption=COPY_TREE_RIGHT_CAPTION;
         ctlright.p_caption=DELETE_TREE_CAPTION;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }else if (tree1_bmindex1==_pic_fldopenm) {
         ctlleft.p_caption=DELETE_TREE_CAPTION;
         ctlright.p_caption=COPY_TREE_LEFT_CAPTION;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }else if (tree1_bmindex1==_pic_file_match) {
         ctlleft.p_caption=VIEW_CAPTION;
         ctlright.p_caption=VIEW_CAPTION2;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }else if (tree1_bmindex1==_pic_fldopen) {
         ctlleft.p_caption=COPY_TREE_RIGHT_CAPTION;
         ctlright.p_caption=COPY_TREE_LEFT_CAPTION;
         ctlleft.p_enabled=1;ctlright.p_enabled=1;
         ctlcopy_left.p_visible=ctlcopy_right.p_visible=0;
      }
      sp=_TreeScroll();
      if (p_window_id==tree1) {
         owid=tree2;
      }else{
         owid=tree1;
      }
      GNoOnChange=1;
      owid._TreeScroll(sp);
      GNoOnChange=0;
      break;
   case CHANGE_SCROLL:
      sp=_TreeScroll();
      if (p_window_id==tree1) {
         owid=tree2;
      }else{
         owid=tree1;
      }
      GNoOnChange=1;
      owid._TreeScroll(sp);
      GNoOnChange=0;
      break;
   case CHANGE_COLLAPSED:
   case CHANGE_EXPANDED:
      CollapseIndex=arg(2);
      CurIndex=_TreeCurIndex();
      _TreeSetCurIndex(CollapseIndex);

      wid=p_window_id;p_window_id=(wid==tree1?tree2:tree1);
      CurIndex2=_TreeCurIndex();
      _TreeCurLineNumber(wid._TreeCurLineNumber());
      CollapseIndex2=_TreeCurIndex();
      _TreeSetInfo(CollapseIndex2,(reason==CHANGE_COLLAPSED?0:1) );
      _TreeSetCurIndex(CurIndex2);

      p_window_id=wid;
      _TreeSetCurIndex(CurIndex);

      _post_call(SyncScrollPositions,tree1' 'tree2);
      break;
   }
}

static void ReplaceIndexesUp(int index,int bmindex)
{
   for (;index>0;) {
      _TreeGetInfo(index,state);
      _TreeSetInfo(index,state,bmindex,bmindex);
      index=_TreeGetParentIndex(index);
   }
}

static int MyMakePath(_str DestPath,int spindex,int dpindex)
{
   status=make_path(DestPath);
   if (status) return(status);
   tree1.ReplaceIndexesUp(dpindex,_pic_fldopen);
   tree2.ReplaceIndexesUp(spindex,_pic_fldopen);
   return(status);
}

static int MaybeWarnModified(_str FileName)
{
   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   _safe_hidden_window();
   bid=p_buf_id;
   status=load_files('+b 'FileName);
   result=0;
   if (!status) {//Shouldn't ever get a status
      if (p_modify) {
         result=_message_box(nls("You have a modified buffer for '%s'.\n\nContinue?",FileName),'',MB_YESNOCANCEL|MB_ICONQUESTION);
         p_view_id=orig_view_id;
         if (result!=IDYES) {
            return(COMMAND_CANCELLED_RC);
         }
      }
   }
   p_view_id=orig_view_id;
   return(0);//If we couldn't load the buffer, why stop'em from copying over it?
}

static int MaybeSaveBuffer(_str FileName,int filestatus=0)
{
   orig_view_id=p_view_id;
   p_view_id=HIDDEN_VIEW_ID;
   _safe_hidden_window();
   bid=p_buf_id;
   status=load_files('+b 'FileName);
   if (!status) {//Shouldn't ever get a status
      if (p_modify||filestatus) {
         _str msg='';
         if (p_modify) {
            msg="The buffer '%s' is modified.\n\nDo you wish to save it before copying?";
         }else{
            msg="The buffer '%s' is does not match the file on disk.\n\nDo you wish to save it before copying?";
         }
         result=_message_box(nls(msg,FileName),'',MB_YESNOCANCEL|MB_ICONQUESTION);
         if (result==IDCANCEL) {
            status=load_files('+bi 'bid);
            p_view_id=orig_view_id;
            return(COMMAND_CANCELLED_RC);
         }
         if (result==IDYES) {
            status=save();
            status=load_files('+bi 'bid);
            p_view_id=orig_view_id;
         }
      }
   }
   p_view_id=orig_view_id;
   return(0);
}

static int ReloadBuffer(_str Filename)
{
   view_id=p_view_id;
   options='';
   p_view_id=HIDDEN_VIEW_ID;
   _safe_hidden_window();

   status=load_files('+b 'Filename)
   if (status) {
      _message_box(nls("Unable to reload %s",Filename)"\n\n"get_message(status));
      return(FILE_NOT_FOUND_RC);
   }
   if (p_buf_width==1) {
      options='+LW'
   } else if (p_buf_width) {
      options='+'p_buf_width
   }
   buf_name=p_buf_name;buf_id=p_buf_id;
   modify=p_modify;
   oldp_line_numbers_len=p_line_numbers_len;
   bfiledate=_file_date(p_buf_name,'B');
   activate_view(view_id);_set_focus();

   /* Make a view&buffer windows list which contains window and position info. */
   /* for all windows. */
   temp_view_id=_list_bwindow_pos(buf_id);
   activate_view(HIDDEN_VIEW_ID);
   // Use def_load_options for network,spill, and undo options. */
   status=load_files(def_load_options:+' +q +d +r +l ':+options' ':+maybe_quote_filename(Filename));
   if (status) {
      if (status==NEW_FILE_RC) {
         status=FILE_NOT_FOUND_RC;
         _delete_buffer();
      }
      activate_view(view_id);_set_focus();
      _message_box(nls("Unable to reload %s",Filename)"\n\n"get_message(status));
      p_file_date=bfiledate;
   } else {
      p_line_numbers_len=oldp_line_numbers_len;
      // Need to do an add buffer here so the debugging
      // information is updated.
      // load_files with +r options calls the delete buffer
      // callback.  Here we readd this buffer.
      call_list('_buffer_add_',p_buf_id,p_buf_name,p_buf_flags);
      _set_bwindow_pos(temp_view_id)
      noption='';
   }
   if (temp_view_id!='') {
      _delete_temp_view(temp_view_id);
   }
   p_view_id=view_id;
   return(0);
}

static int CopyMissingFile(int otherwid,...)
{
   PropmtOptions=arg(2);
   sindex=_TreeCurIndex();
   spindex=_TreeGetParentIndex(sindex);
   dindex=otherwid._TreeCurIndex();
   dpindex=otherwid._TreeGetParentIndex(dindex);
   SourcePath=_TreeGetCaption(spindex);
   SourceFilename=_TreeGetCaption(sindex);
   DestPath=otherwid._TreeGetCaption(dpindex);
   DestFilename=otherwid._TreeGetCaption(dindex);
   if (arg(2)=='M') {
      result=_message_box(nls('Copy %s to %s?',SourcePath:+SourceFilename,DestPath:+DestFilename),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) {
         return(COMMAND_CANCELLED_RC);
      }
   }
   //_TreeSetInfo(sindex,-1,_pic_file_match,_pic_file_match);
   //otherwid._TreeSetInfo(dindex,-1,_pic_file_match,_pic_file_match);
   _str matchname='';
   if (substr(DestPath,1,2)=='\\') {
      DestPathWithWildcards=DestPath;
      if (last_char(DestPathWithWildcards)!=FILESEP) {
         DestPathWithWildcards=DestPathWithWildcards:+FILESEP
      }
      DestPathWithWildcards=DestPathWithWildcards:+ALLFILES_RE;
      matchname=file_match(DestPathWithWildcards' -p +d',1);
   }else{
      //For a unc name, file_match is funny for the first dir, so
      //do this just in case...
      DestPathNoFS=maybe_quote_filename(DestPath);
      if (last_char(DestPathNoFS)==FILESEP) {
         DestPathNoFS=substr(DestPathNoFS,1,length(DestPathNoFS)-1);
      }
      matchname=file_match(DestPathNoFS' +p +d',1);
   }
   if (matchname=='') {
      status=otherwid.MyMakePath(DestPath,spindex,dpindex);
      if (status) {
         _message_box(nls("Could not make path %s\n%s",DestPath,get_message(status)));
         return(status);
      }
   }
   mou_hour_glass(1);
   SourceName=SourcePath:+SourceFilename;
   DestName=DestPath:+DestFilename;
   status=copy_file(SourceName,DestName);
   mou_hour_glass(0);
   if (status) {
      _message_box(nls("Could not copy file %s to %s\n%s",
                       SourceName,
                       DestName,get_message(status)));
   }else{
      _AppendToDiffReport(DIFF_REPORT_COPY_FILE,
                     SourceName,
                     DestName);
   }
   return(status);
}

int _UpdateFileBitmaps(_str filename1,int &index1,int Tree1WID,
                       _str filename2,int &index2,int Tree2WID,
                       int FilesMatch=0)
{
   if (!index1) {
      pindex=Tree1WID._TreeSearch(TREE_ROOT_INDEX,strip_filename(filename1,'N'),'t'_fpos_case);
      if (pindex<0) {
         return(1);
      }
      index1=Tree1WID._TreeSearch(pindex,strip_filename(filename1,'P'),_fpos_case);
   }
   if (!index2) {
      pindex=Tree1WID._TreeSearch(TREE_ROOT_INDEX,strip_filename(filename1,'N'),'t'_fpos_case);
      index2=Tree2WID._TreeSearch(pindex,strip_filename(filename2,'P'),_fpos_case);
   }
   wid=p_active_form;
   int filestatus=0;
   inmem1=inmem2=1;
   if (!FilesMatch) {
      status1=_mdi.p_child._open_temp_view(filename1,viewid1,orig_view_id,'+b');
      if (status1) {
         inmem1=0;
         status1=_mdi.p_child._open_temp_view(filename1,viewid1,orig_view_id);
      }
      if (status1) return(status1);
      status2=_mdi.p_child._open_temp_view(filename2,viewid2,junk_view_id,'+b');
      if (status2) {
         inmem2=0;
         status2=_mdi.p_child._open_temp_view(filename2,viewid2,orig_view_id);
      }
      if (status2) return(status2);
      p_view_id=orig_view_id;
      long seek1,seek2;
      seek1=seek2=0;
      int line1=0,line2=0;
      int NCSStatus1=0,NCSStatus2=0;
      if (def_diff_options&DIFF_LEADING_SKIP_COMMENTS) {
         NCSStatus1=_GetNonCommentSeek(viewid1,seek1,line1);
         NCSStatus2=_GetNonCommentSeek(viewid2,seek2,line2);
      }

      //If both of these are STRING_NOT_FOUND_RC we know that the file is all comments
      if (NCSStatus1==STRING_NOT_FOUND_RC &&
          NCSStatus2==STRING_NOT_FOUND_RC) {
         filestatus=0;
      }else{
         if (!(def_diff_options&FORCE_PROCESS_OPTIONS)&&
             !(def_diff_options&DIFF_DONT_COMPARE_EOL_CHARS)) {
            filestatus=FastCompare(viewid1,seek1,viewid2,seek2);
         }else{
            filestatus=Diff(viewid1,viewid2,
                            def_diff_options|DIFF_OUTPUT_BOOLEAN,
                            0,
                            0,0,//Do nothing
                            def_load_options,0,
                            '',//This is pass by reference
                            def_max_fast_diff_size,
                            line1,line2);
         }
      }
      if (inmem1) {
         p_view_id=viewid1;_quit_view();
      }else{
         _delete_temp_view(viewid1);
      }
      if (inmem2) {
         p_view_id=viewid2;_quit_view();
      }else{
         _delete_temp_view(viewid2);
      }
   }
   p_window_id=wid;
   Tree1WID._TreeGetInfo(index1,state1);
   Tree2WID._TreeGetInfo(index2,state2);
   if (filestatus) {
      bmindex=_pic_filed2;
   }else{
      bmindex=_pic_file_match;
   }
   flags=0;
   if (bmindex==_pic_file_match) {
      if (!(def_diff_view_options&DIFF_VIEW_MATCHING_FILES)) flags=TREENODE_HIDDEN;
   }else if (bmindex==_pic_filed2) {
      if (!(def_diff_view_options&DIFF_VIEW_VIEWED_FILES)) flags=TREENODE_HIDDEN;
   }
   Tree1WID._TreeSetInfo(index1,state1,bmindex,bmindex,flags);
   Tree2WID._TreeSetInfo(index2,state2,bmindex,bmindex,flags);
   return(0);
}

static void GetFileListFromTree2(int index,
                                 int (&DestIndexList)[],
                                 boolean Recursive,
                                 boolean IncludeMissing,
                                 boolean IncludeOnly)
{
   /*
   "IncludeOnly" means include files that only exist on one side
   */
   Caption=_TreeGetCaption(index);
   DestIndexList[DestIndexList._length()]=index;
   index=_TreeGetFirstChildIndex(index);
   for (;;) {
      if (index<0) break;
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (!(flags&TREENODE_HIDDEN)) break;
      index=_TreeGetNextSiblingIndex(index);
   }
   for (;;) {
      if (index<0) break;
      Filename=_TreeGetCaption(index);
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (last_char(Filename)==FILESEP) {
         if (Recursive) {
            GetFileListFromTree2(index,DestIndexList,Recursive,IncludeMissing,IncludeOnly);
         }
      }else{
         if ( (bm1==_pic_filem && IncludeMissing) ||
              (bm1==_pic_filep && IncludeOnly) ||
              (bm1!=_pic_filem && bm1!=_pic_filep) ) {
            DestIndexList[DestIndexList._length()]=index;
         }
      }
      for (;;) {
         index=_TreeGetNextSiblingIndex(index);
         if (index<0) break;
         _TreeGetInfo(index,state,bm1,bm2,flags);
         if (!(flags&TREENODE_HIDDEN)) break;
      }
   }
}

/*
static void GetFileListFromTree(int index,_str (&FileList)[],
                                int (&FolderIndexList)[],
                                int (&FileIndexList)[],
                                _str SourceOrDest='',
                                boolean Recursive=true)
{
   Path=_TreeGetCaption(index);

   FolderIndexCount=FolderIndexList._length();
   FolderIndexList[FolderIndexCount++]=index;

   FileIndexCount=FileIndexList._length();
   index=_TreeGetFirstChildIndex(index);

   count=FileList._length();
   for (;;) {
      if (index<0) break;
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (flags&TREENODE_HIDDEN || bm1==_pic_file_match/*No need to copy mathing files*/) {
         index=_TreeGetNextSiblingIndex(index);
         continue;
      }
      if (SourceOrDest!='') {
         if (SourceOrDest=='S' &&
             (bm1==_pic_filem || bm1==_pic_fldopenm) ) {
            index=_TreeGetNextSiblingIndex(index);
            continue;
         }
         if (SourceOrDest=='D' &&
             (bm1==_pic_filep || bm1==_pic_fldopenp) ) {
            index=_TreeGetNextSiblingIndex(index);
            continue;
         }
      }
      Filename=_TreeGetCaption(index);
      if (last_char(Filename)==FILESEP) {
         if (Recursive) {
            GetFileListFromTree(index,FileList,FolderIndexList,FileIndexList);
         }
      }else{
         FileList[count++]=Path:+Filename;
         FileIndexList[FileIndexCount++]=index;
      }
      index=_TreeGetNextSiblingIndex(index);
   }
}*/

static void ReplaceBitmapsForIndexes(int IndexList[],int NewBitmapIndex)
{
   for (i=0;i<IndexList._length();++i) {
      _TreeGetInfo(IndexList[i],state,bm1,bm2,flags);
      if (!(def_diff_view_options&DIFF_VIEW_MATCHING_FILES)) {
         flags|=TREENODE_HIDDEN;
      }
      _TreeSetInfo(IndexList[i],state,NewBitmapIndex,NewBitmapIndex,flags);
   }
}

static void MyCopyTree(int SourceTreeWID,int SourceIndex,
                       int DestTreeWID,  int DestIndex)
{
   path1=SourceTreeWID._TreeGetCaption(SourceIndex);
   path2=DestTreeWID._TreeGetCaption(DestIndex);
   result=show('-modal _vc_auto_inout_form',
               "Copy '"path1"' to '"path2"'?",
               'Recursive');
   if (result!=IDYES) return;
   boolean CopyRecursive=_param1
   _AppendToDiffReport(DIFF_REPORT_COPY_TREE,path1,path2);

   int SourceIndexList[];
   SourceIndexList._makeempty();
   int DestIndexList[];
   DestIndexList._makeempty();
   SourceTreeWID.GetFileListFromTree2(SourceIndex,SourceIndexList,CopyRecursive,0,1);
   DestTreeWID.GetFileListFromTree2(DestIndex,DestIndexList,CopyRecursive,1,0);

   for (i=0;i<SourceIndexList._length();++i) {
      SourcePath=SourceTreeWID._TreeGetCaption(SourceTreeWID._TreeGetParentIndex(SourceIndexList[i]));
      SourceRFilename=SourceTreeWID._TreeGetCaption(SourceIndexList[i]);
      if (last_char(SourceRFilename)==FILESEP) {
         SourceFilename=SourceRFilename;
      }else{
         SourceFilename=SourcePath:+SourceRFilename;
      }

      DestPath=DestTreeWID._TreeGetCaption(DestTreeWID._TreeGetParentIndex(DestIndexList[i]));
      DestRFilename=DestTreeWID._TreeGetCaption(DestIndexList[i]);
      if (last_char(DestRFilename)==FILESEP) {
         DestFilename=DestRFilename;
      }else{
         DestFilename=DestPath:+DestRFilename;
      }
      if (last_char(SourceFilename)==FILESEP) {
         //These are paths
         int status=0;
         if (file_match(maybe_quote_filename(DestFilename:+ALLFILES_RE),1)=='') {
            status=make_path(DestFilename);
         }
         //say('Making path 'DestFilename' i='i);
         if (status) {
            _message_box(nls("Could not create path '%s'",DestFilename));
         }else{
            SourceTreeWID.SetMatchingBitmap(SourceIndexList[i],_pic_fldopen);
            DestTreeWID.SetMatchingBitmap(DestIndexList[i],_pic_fldopen);
         }
      }else{
         status=copy_file(SourceFilename,DestFilename);
         //say('copy 'SourceFilename' to 'DestFilename);
         if (status) {
            result=_message_box(nls("Could not copy file '%s' to '%s'\n%s\n\nContinue?",SourceFilename,DestFilename,get_message(status)),'',MB_YESNOCANCEL);
            if (result!=IDYES) break;
         }else{
            SourceTreeWID.SetMatchingBitmap(SourceIndexList[i],_pic_file);
            DestTreeWID.SetMatchingBitmap(DestIndexList[i],_pic_file);
         }
      }
   }
   clear_message();
}

static void SetMatchingBitmap(int index,int NewBitmap)
{
   _TreeGetInfo(index,state,bm1,bm2,flags);
   if (!(def_diff_view_options&DIFF_VIEW_MATCHING_FILES) &&
       NewBitmap==_pic_file) {
      flags|=TREENODE_HIDDEN;
   }
   _TreeSetInfo(index,state,NewBitmap,NewBitmap,flags);
}

static void MyDeleteTree(int SourceTreeWID,int SourceIndex,
                         int DestTreeWID,  int DestIndex)
{
   _str SourceFileList[],DestFileList[];
   int SourceFolderIndexList[],SourceFileIndexList[];
   int DestFolderIndexList[],DestFileIndexList[];
   //RELAX!!!We have already been prompted before this call
   //SourceTreeWID.GetFileListFromTree(SourceIndex,SourceFileList,SourceFolderIndexList,SourceFileIndexList);
   int IndexList[];IndexList._makeempty();
   int DestIndexList[];DestIndexList._makeempty();
   SourceTreeWID.GetFileListFromTree2(SourceIndex,IndexList,1,0,1);
   DestTreeWID.GetFileListFromTree2(DestIndex,DestIndexList,1,1,0);
   _AppendToDiffReport(DIFF_REPORT_DELETE_TREE,SourceTreeWID._TreeGetCaption(SourceIndex));
   _str DirList:[];
   for (i=0;i<IndexList._length();++i) {
      index=IndexList[i];
      filename=SourceTreeWID._TreeGetCaption(index);
      if (last_char(filename)==FILESEP) {
         DirList:[_file_case(strip_filename(filename,'N'))]=IndexList[i]" "DestIndexList[i];
      }else{
         filename=SourceTreeWID._TreeGetCaption(SourceTreeWID._TreeGetParentIndex(index)):+filename;
         status=delete_file(filename);
         if (status) {
            result=_message_box(nls("Could not delete file %s\n%s\n\nContinue?",filename,get_message(status)),'',MB_YESNOCANCEL|MB_ICONQUESTION);
            if (result!=IDYES) break;
         }else{
            _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,filename);
            SourceTreeWID._TreeDelete(IndexList[i]);
            DestTreeWID._TreeDelete(DestIndexList[i]);
         }
      }
   }
   for (i._makeempty();;) {
      DirList._nextel(i);
      if (i._isempty()) break;
      status=rmdir(i);
      if (status) {
         result=_message_box(nls("Could not remove directory %s\n%s",i,get_message(status)),'',MB_YESNOCANCEL|MB_ICONQUESTION);
         if (result!=IDYES) break;
      }else{
         _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,i);
         parse DirList:[i] with SourceDirIndex DestDirIndex;
         SourceTreeWID._TreeDelete(SourceDirIndex);
         DestTreeWID._TreeDelete(DestDirIndex);
      }
   }
   clear_message();
   //Should not hurt anything to delete the whole thing even if we couldn't
   //delete a directory
   //SourceTreeWID._TreeDelete(SourceIndex);
   //DestTreeWID._TreeDelete(DestIndex);
}

static void maybe_kill_diff()
{
   wid=_find_formobj('_diff_form','N');
   if (wid) {
      _nocheck _control _ctlclose;
      wid._ctlclose.call_event(wid._ctlclose,LBUTTON_UP);
   }
}



//This function uses inheritance so that it actually works for the ctlleft
//button, and the ctlright button
void ctlleft.lbutton_up()
{
   GModified=1;
   sourceTreeWID=(p_window_id==ctlleft?tree1:tree2);
   destTreeWID=(p_window_id==ctlleft?tree2:tree1);
   if (p_caption==DIFF_CAPTION||
       p_caption==DIFF_CAPTION2||
       p_caption==VIEW_CAPTION) {
      curindex=tree1._TreeCurIndex();
      curindex2=tree2._TreeCurIndex();
   }else{
      curindex=sourceTreeWID._TreeCurIndex();
      curindex2=destTreeWID._TreeCurIndex();
   }

   int HidNodes=0;
   pi=sourceTreeWID._TreeGetParentIndex(curindex);
   if (pi==TREE_ROOT_INDEX) {
      switch (p_caption) {
      case COPY_TREE_RIGHT_CAPTION:
      case COPY_TREE_LEFT_CAPTION:
         index1=tree1._TreeCurIndex();
         index2=tree2._TreeCurIndex();
         MyCopyTree(sourceTreeWID,curindex,destTreeWID,curindex2);
         tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
         tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));

         tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
         //Move to next mismatch
         if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
            ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
            tree1._set_focus();
         }
         return;
      default:
         //Only tree copy is valid in this case
         return;
      }
   }
   if (p_caption==DIFF_CAPTION||
       p_caption==DIFF_CAPTION2||
       p_caption==VIEW_CAPTION||
       p_caption==VIEW_CAPTION2) {
      Path1=tree1._TreeGetCaption(pi);
      File1=tree1._TreeGetCaption(tree1._TreeCurIndex());

      Path2=tree2._TreeGetCaption(tree2._TreeGetParentIndex(curindex2));
      File2=tree2._TreeGetCaption(tree2._TreeCurIndex());
   }else{
      Path1=sourceTreeWID._TreeGetCaption(pi);
      File1=sourceTreeWID._TreeGetCaption(sourceTreeWID._TreeCurIndex());

      Path2=destTreeWID._TreeGetCaption(destTreeWID._TreeGetParentIndex(curindex2));
      File2=destTreeWID._TreeGetCaption(destTreeWID._TreeCurIndex());
   }
   switch (p_caption) {
   case DELETE_TREE_CAPTION:
      Path2=destTreeWID._TreeGetCaption(destTreeWID._TreeCurIndex());
      result=_message_box(nls("Are you sure you wish to remove the directory '%s'?",Path2),
                          '',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         MyDeleteTree(destTreeWID,curindex2,sourceTreeWID,curindex);
      }
#if 0
      //Move to next mismatch
      if (def_diff_edit_options&DIFF_AUTO_JUMP) {
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
         tree1._set_focus();
      }
#endif
      break;
   case DIFF_CAPTION:
   case DIFF_CAPTION2:
      fid=p_active_form;
      //All the if0'd stuff is becuase this dialog is modless and I have to do
      //it in on_destroy events now
#if 0
      OrigFile1Date=_file_date(Path1:+File1,'B');
      OrigFile2Date=_file_date(Path2:+File2,'B');
#endif
      //_mdi.p_child.diff('-modal 'maybe_quote_filename(Path1:+File1)' 'maybe_quote_filename(Path2:+File2));

      _mdi.p_child.diff('-RegisterAsMFDChild 'fid' 'maybe_quote_filename(Path1:+File1)' 'maybe_quote_filename(Path2:+File2));
#if 0
      File1Date=_file_date(Path1:+File1,'B');
      File2Date=_file_date(Path2:+File2,'B');
#endif
      _AppendToDiffReport(DIFF_REPORT_DIFF,Path1:+File1,Path2:+File2);
#if 0
      if (File1Date!=OrigFile1Date) {
         _AppendToDiffReport(DIFF_REPORT_FILE_CHANGE,Path1:+File1);
      }
      if (File2Date!=OrigFile2Date) {
         _AppendToDiffReport(DIFF_REPORT_FILE_CHANGE,Path2:+File2);
      }
      //fid._set_focus();
      index1=tree1._TreeCurIndex();
      index2=tree2._TreeCurIndex();
      //_UpdateFileBitmaps(Path1:+File1,curindex,tree1,Path2:+File2,curindex2,tree2);
      tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
      tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));
      sourceTreeWID.call_event(CHANGE_SELECTED,curindex,sourceTreeWID,ON_CHANGE,'W');
      destTreeWID.call_event(CHANGE_SELECTED,curindex2,destTreeWID,ON_CHANGE,'W');

      tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
      //Move to next mismatch
      if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
         //tree1._set_focus();
      }
#endif
      break;
   case VIEW_CAPTION:
   case VIEW_CAPTION2:
      fid=p_active_form;
      _mdi.p_child.diff('-RegisterAsMFDChild 'fid' -q 'maybe_quote_filename(Path1:+File1)' 'maybe_quote_filename(Path2:+File2));
      //fid._set_focus();
#if 0
      _UpdateFileBitmaps(Path1:+File1,curindex,tree1,Path2:+File2,curindex2,tree2);
      sourceTreeWID.call_event(CHANGE_SELECTED,curindex,sourceTreeWID,ON_CHANGE,'W');
      destTreeWID.call_event(CHANGE_SELECTED,curindex2,destTreeWID,ON_CHANGE,'W');

      tree1._TreeGetInfo(curindex,state,bm1,bm2,flags);
      //Move to next mismatch
      if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
         //tree1._set_focus();
      }
#endif
      break;
   case COPY_TREE_RIGHT_CAPTION:
   case COPY_TREE_LEFT_CAPTION:
      index1=tree1._TreeCurIndex();
      index2=tree2._TreeCurIndex();
      MyCopyTree(sourceTreeWID,curindex,destTreeWID,curindex2);
      HidNodes=tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
      tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));
      tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'w');
      tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree1,ON_CHANGE,'w');

      tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
      //Move to next mismatch
      if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
         tree1._set_focus();
      }
      break;
   case COPY_RIGHT_CAPTION:
   case COPY_LEFT_CAPTION:
      //arg(1) is 'M' if we want a message before the copy
      index1=tree1._TreeCurIndex();
      index2=tree2._TreeCurIndex();
      status=sourceTreeWID.CopyMissingFile(destTreeWID,arg(1));
      if (status) {
         return;
      }
      status=_UpdateFileBitmaps(Path1:+File1,curindex,tree1,Path2:+File2,curindex2,tree2,1);
      tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'w');
      tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree1,ON_CHANGE,'w');
      tree1._TreeGetInfo(index1,state,bm1,bm2,flags);
      tree1.MaybeHideNode(tree1._TreeGetParentIndex(index1));
      tree2.MaybeHideNode(tree2._TreeGetParentIndex(index2));

      //Move to next mismatch
      if (!(flags&TREENODE_HIDDEN) && def_diff_edit_options&DIFF_AUTO_JUMP) {
         ctlnext_mismatch.call_event(ctlnext_mismatch,LBUTTON_UP);
         tree1._set_focus();
      }
      break;
   case DELETE_FILE_CAPTION:
      result=_message_box(nls("Are you sure you wish to delete the file %s?",Path2:+File2),
                          '',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         status=delete_file(Path2:+File2);
         if (status) {
            _message_box(nls("Could not delete file %s.\n%s",Path2:+File2,get_message(status)));
            return;
         }
         _AppendToDiffReport(DIFF_REPORT_DELETE_FILE,Path2:+File2);
         sourceTreeWID._TreeDelete(curindex);
         destTreeWID._TreeDelete(curindex2);
         tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'w');
         tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree1,ON_CHANGE,'w');
      }
   }
}

void tree2.on_change(reason)
{
#if 0
   switch (reason) {
   case CHANGE_SELECTED:
      break;
   case CHANGE_SCROLL:
      tree1._TreeScroll(_TreeScroll());
      break;
   }
#else
   tree2.call_event(reason,arg(2),tree1,ON_CHANGE,'W');
#endif
}

void tree1.down,'C-K'()
{
   _TreeDown();
#if 0
   GNoOnChange=1;
   tree2._TreeDown();
   GNoOnChange=0;
#endif
}

void tree1.up,'C-I'()
{
   _TreeUp();
#if 0
   GNoOnChange=1;
   tree2._TreeUp();
   GNoOnChange=0;
#endif
}

void tree1.left()
{
   index=find_index('_ul2_tree',EVENTTAB_TYPE);
   //message('index='index);
   if (index) {
      tree1.call_event(index,LEFT,'E');
      tree2.call_event(index,LEFT,'E');
   }
}
void tree2.left()
{
   index=find_index('_ul2_tree',EVENTTAB_TYPE);
   if (index) {
      tree1.call_event(index,LEFT,'E');
      tree2.call_event(index,LEFT,'E');
   }
}

void tree1.right()
{
   index=find_index('_ul2_tree',EVENTTAB_TYPE);
   if (index) {
      tree2.call_event(index,RIGHT,'E');
      tree1.call_event(index,RIGHT,'E');
   }
}
void tree2.right()
{
   index=find_index('_ul2_tree',EVENTTAB_TYPE);
   if (index) {
      tree2.call_event(index,RIGHT,'E');
      tree1.call_event(index,RIGHT,'E');
   }
}

void tree1.PGUP,'C-P'()
{
   _TreePageUp();
   //tree2._TreePageUp();
}
void tree1.PGDN,'C-N'()
{
   _TreePageDown();
   //tree2._TreePageDown();
}

void tree1.HOME()
{
   _TreeTop();
   //tree2._TreeTop();
}

void tree1.END()
{
   _TreeBottom();
   //tree2._TreeBottom();
}

void tree2.down,'C-K'()
{
   _TreeDown();
   //tree1._TreeDown();
}

void tree2.up,'C-I'()
{
   _TreeUp();
   //tree1._TreeUp();
}
void tree2.PGUP,'C-P'()
{
   _TreePageUp();
   //tree1._TreePageUp();
}
void tree2.PGDN,'C-N'()
{
   _TreePageDown();
   ///tree1._TreePageDown();
}

void tree2.HOME()
{
   _TreeTop();
   //tree1._TreeTop();
}

void tree2.END()
{
   _TreeBottom();
   //tree1._TreeBottom();
}

static int GetOtherTreeWID(int wid)
{
   if (wid==tree1) {
      return(tree2);
   }
   return(tree1);
}

static int DelKey()
{
   index=_TreeCurIndex();
   _TreeGetInfo(index,state,bm1,bm2,flags);
   if (bm1==_pic_filem || bm1==_pic_filep) {
      //File only exists in other path
      if (bm1==_pic_filem) {
         wid=p_window_id;
         if (p_window_id==tree1) {
            p_window_id=tree2;
         }else{
            p_window_id=tree1;
         }
      }
      otherwid=GetOtherTreeWID(p_window_id);
      otherindex=otherwid._TreeCurIndex();
      Path=_TreeGetCaption(_TreeGetParentIndex(index));
      Filename=_TreeGetCaption(index);
      result=_message_box(nls("Are you sure you wish to delete the file %s?",Path:+Filename),
                          '',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         status=delete_file(Path:+Filename);
         if (status) {
            _message_box(nls("Could not delete file %s.\n%s",Path:+Filename,get_message(status)));
            return(status);
         }
         _AppendToDiffReport(DIFF_REPORT_DELETE_FILE,Path:+Filename);
         _TreeDelete(index);
         otherwid._TreeDelete(otherindex);
         tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'w');
         tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree1,ON_CHANGE,'w');
      }
      if (bm1==_pic_filem) p_window_id=wid;
      return(0);
   }
   otherwid=GetOtherTreeWID(p_window_id);
   otherindex=otherwid._TreeCurIndex();
   rfilename1=_TreeGetCaption(index);
   rfilename2=otherwid._TreeGetCaption(otherindex);
   Path1=_TreeGetCaption(_TreeGetParentIndex(index));
   Path2=otherwid._TreeGetCaption(otherwid._TreeGetParentIndex(otherindex));
   Filename1=Path1:+rfilename1;
   Filename2=Path2:+rfilename2;
   result=show('-modal _rb_form','Delete Files',0,'',
               'Delete 'Filename1,
               'Delete 'Filename2,
               'Delete 'Filename1' and 'Filename2);
   if (result=='') return(COMMAND_CANCELLED_RC);
   _str Files[];
   if (result==1) {
      status=delete_file(Filename1);
      if (status) {
         _message_box(nls("Could not delete file %s\n\n%s",Filename1,get_message(status)));
         return(status);
      }
      _TreeSetInfo(index,state,_pic_filem,_pic_filem,flags);
      otherwid._TreeSetInfo(otherindex,state,_pic_filep,_pic_filep,flags);
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
      _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,Filename1);
   }else if (result==2) {
      status=delete_file(Filename2);
      if (status) {
         _message_box(nls("Could not delete file %s\n\n%s",Filename2,get_message(status)));
         return(status);
      }
      _TreeSetInfo(index,state,_pic_filep,_pic_filep,flags);
      otherwid._TreeSetInfo(otherindex,state,_pic_filem,_pic_filem,flags);
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
      _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,Filename2);
   }else if (result==3) {
      status=delete_file(Filename1);
      if (status) {
         _message_box(nls("Could not delete file %s\n\n%s",Filename1,get_message(status)));
         return(status);
      }
      status=delete_file(Filename2);
      if (status) {
         _message_box(nls("Could not delete file %s\n\n%s",Filename2,get_message(status)));
         return(status);
      }
      _TreeDelete(index);
      otherwid._TreeDelete(otherindex);
      tree1.call_event(CHANGE_SELECTED,index,tree1,ON_CHANGE,'W');
      _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,Filename1);
      _AppendToDiffReport(DIFF_REPORT_DELETE_TREE_FILE,Filename2);
   }
   return(0);
}

void tree1.del()
{
   DelKey();
}

void tree2.del()
{
   DelKey();
}

static void rclickmenu()
{
   call_event(p_window_id,LBUTTON_DOWN);
   index=find_index("_mfdiff_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');

   _str path1=ctlpath1label.p_caption;
   _str path2=ctlpath2label.p_caption;
   parse path1 with 'Path &1:' path1;
   parse path2 with 'Path &2:' path2;
   status=_menu_set_state(menu_handle,
                          2,MF_ENABLED,'p',
                'Show files not in 'path1,
                'MFDiffCommand hmissing1','','',
                'Show files Missing from 'path1);
   status=_menu_set_state(menu_handle,
                          3,MF_ENABLED,'p',
                'Show files not in 'path2,
                'MFDiffCommand hmissing2','','',
                'Show files Missing from 'path2);

   index=_TreeCurIndex();
   mou_get_xy(x,y);

   if (def_diff_view_options&DIFF_VIEW_MATCHING_FILES) {
      _menu_set_state(menu_handle,"match",MF_CHECKED,'C');
   }
   if (def_diff_view_options&DIFF_VIEW_VIEWED_FILES) {
      _menu_set_state(menu_handle,"viewed",MF_CHECKED,'C');
   }
   if (def_diff_view_options&DIFF_VIEW_MISSING_FILES1) {
      _menu_set_state(menu_handle,"missing1",MF_CHECKED,'C');
   }
   if (def_diff_view_options&DIFF_VIEW_MISSING_FILES2) {
      _menu_set_state(menu_handle,"missing2",MF_CHECKED,'C');
   }
   if (def_diff_view_options&DIFF_VIEW_DIFFERENT_FILES) {
      _menu_set_state(menu_handle,"different",MF_CHECKED,'C');
   }

   if (!GNumHidden) {
      _menu_set_state(menu_handle,"hiddenexist",MF_GRAYED,'C');
   }

   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
}

void tree1.rbutton_up()
{
   rclickmenu();
}

void tree2.rbutton_up()
{
   rclickmenu();
}

static void RefreshByDate(int index1,int index2)
{
   origParent=tree1._TreeGetParentIndex(index1);
   s1=tree1._TreeScroll();
   s2=tree2._TreeScroll();
   for (;;) {
      if (index1<0||index2<0) break;
      cap1=tree1._TreeGetCaption(index1);
      cap2=tree2._TreeGetCaption(index2);
      if (last_char(cap1)==FILESEP) {
         //Directory node
         tree1._TreeGetInfo(index1,state1,bm11,bm12,flags1);
         tree2._TreeGetInfo(index2,state2,bm21,bm22,flags2);
         GetFolderIndexes(cap1,cap2,newindex1,newindex2,'+d',
                          _pic_fldopen,_pic_fldopenp,_pic_fldopenm);
         if (bm11!=newindex1 ||
             bm12!=newindex2) {

            tree1._TreeSetInfo(index1,state1,newindex1,newindex1,flags1);
            tree2._TreeSetInfo(index2,state2,newindex2,newindex2,flags2);
         }
         ci1=tree1._TreeGetFirstChildIndex(index1);
         ci2=tree2._TreeGetFirstChildIndex(index2);
         if (ci1>=0 && ci2>=0) RefreshByDate(ci1,ci2);
      }else{
         //File node
         info1=tree1._TreeGetUserInfo(index1);
         parse info1 with old_file_date1 (ASCII1) manually_hidden1 .;
         info2=tree2._TreeGetUserInfo(index2);
         parse info2 with old_file_date2 (ASCII1) manually_hidden2 .;

         filename1=tree1._TreeGetCaption(tree1._TreeGetParentIndex(index1)):+tree1._TreeGetCaption(index1);
         file_date1=_file_date(filename1,'B');

         filename2=tree2._TreeGetCaption(tree2._TreeGetParentIndex(index2)):+tree2._TreeGetCaption(index2);
         file_date2=_file_date(filename2,'B');

         if (old_file_date1!=file_date1 ||
             old_file_date2!=file_date2) {
            GetFolderIndexes(filename1,filename2,newindex1,newindex2,'',
                             _pic_file_match,_pic_filep,_pic_filem);
            tree1._TreeGetInfo(index1,state1,bm11,bm12,flags1);
            tree2._TreeGetInfo(index2,state2,bm21,bm22,flags2);
            if (newindex1==_pic_filem || newindex2==_pic_filem) {
               if (newindex1==newindex2) {
                  //Files do not exist
                  nextindex1=tree1._TreeGetNextSiblingIndex(index1);
                  nextindex2=tree2._TreeGetNextSiblingIndex(index2);
                  tree1._TreeDelete(index1);
                  tree2._TreeDelete(index2);
                  index1=nextindex1;
                  index2=nextindex2;
                  continue;
               }
               tree1._TreeSetInfo(index1,state1,newindex1,newindex1,flags1);
               tree2._TreeSetInfo(index2,state2,newindex2,newindex2,flags2);
               index1=tree1._TreeGetNextSiblingIndex(index1);
               index2=tree2._TreeGetNextSiblingIndex(index2);
               continue;
            }
            status=_open_temp_view(filename1,File1ViewId,orig_view_id);
            if (status) {
               _message_box(nls("Could not open file %s\ns",filename1,get_message(status)));
            }
            p_view_id=orig_view_id;
            status=_open_temp_view(filename2,File2ViewId,junk);
            if (status) {
               _message_box(nls("Could not open file %s\n%s",filename2,get_message(status)));
            }
            p_view_id=orig_view_id;
            if (!(def_diff_options&FORCE_PROCESS_OPTIONS)&&
                !(def_diff_options&DIFF_DONT_COMPARE_EOL_CHARS)) {
               message('Fast Comparing 'filename1' and 'filename2);
               //This means we are in the "sunny day" scenario.  Even a size
               //mismatch is good enough
               long seek1,seek2;
               seek1=seek2=0;
               if (def_diff_options&DIFF_LEADING_SKIP_COMMENTS) {
                  _GetNonCommentSeek(File1ViewId,seek1);
                  _GetNonCommentSeek(File2ViewId,seek2);
               }
               status=FastCompare(File1ViewId,seek1,File2ViewId,seek2);
               //status=0;
            }else{
               message('Comparing 'filename1' and 'filename2);
               OutputBufId='';//Shouldn't have to do this...
               flags=def_diff_options|DIFF_OUTPUT_BOOLEAN;
               StartLine1=StartLine2=0;
               if (def_diff_options&DIFF_LEADING_SKIP_COMMENTS) {
                  _GetNonCommentSeek(File1ViewId,junk,StartLine1);
                  _GetNonCommentSeek(File2ViewId,junk,StartLine2);
               }
               status=Diff(File1ViewId,File2ViewId,
                           flags,
                           0,
                           0,0,//Do nothing
                           def_load_options,0,
                           OutputBufId,//This is pass by reference
                           def_max_fast_diff_size,
                           StartLine1,StartLine2);
            }
            _delete_temp_view(File1ViewId);
            _delete_temp_view(File2ViewId);
            tree1._TreeGetInfo(index1,state1,bm11,bm12,flags1);
            tree2._TreeGetInfo(index2,state2,bm21,bm22,flags2);
            if (status) {
               //Files do not match
               if (def_diff_view_options&DIFF_VIEW_DIFFERENT_FILES) {
                  flags1&=~TREENODE_HIDDEN;
                  flags2&=~TREENODE_HIDDEN;
               }else{
                  flags1|=TREENODE_HIDDEN;
                  flags2|=TREENODE_HIDDEN;
               }
               tree1._TreeSetInfo(index1,state1,_pic_filed,_pic_filed,flags1);
               tree2._TreeSetInfo(index2,state2,_pic_filed,_pic_filed,flags2);
            }else{
               //Files match
               if (def_diff_view_options&DIFF_VIEW_MATCHING_FILES) {
                  flags1&=~TREENODE_HIDDEN;
                  flags2&=~TREENODE_HIDDEN;
               }else{
                  flags1|=TREENODE_HIDDEN;
                  flags2|=TREENODE_HIDDEN;
               }
               tree1._TreeSetInfo(index1,state1,_pic_file_match,_pic_file_match,flags1);
               tree2._TreeSetInfo(index2,state2,_pic_file_match,_pic_file_match,flags2);
            }
         }else{
            message('Skipping 'filename1' and 'filename2);
         }
      }
      index1=tree1._TreeGetNextSiblingIndex(index1);
      index2=tree2._TreeGetNextSiblingIndex(index2);
   }
   if (origParent==TREE_ROOT_INDEX) {
      tree1._TreeScroll(s1);
      tree2._TreeScroll(s2);
   }
   clear_message();
}

void ctlrefresh.lbutton_up()
{

   result=_message_box("Refresh modified files only?",'',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result==IDCANCEL) return;
   if (result==IDNO) {
      //message('Building File Lists...');
      int ProgressFormWID=show('-desktop -hidden _difftree_progress_form');
      disabled_wid_list=_enable_non_modal_forms(0,ProgressFormWID);
      ProgressFormWID.HideProgressGauge();
      ProgressFormWID.p_visible=1;
      mou_hour_glass(1);
      recursive=GRecursive;
      _str FileTable1:[],FileTable2:[];
      NumFilesInPath1=_GetFileTable(FileTable1,GPath1,GFilespecList,GExcludeFilespecList,GRecursive,ProgressFormWID);
      if (NumFilesInPath1<0) {
         _enable_non_modal_forms(1,0,disabled_wid_list);
         return;
      }
      NumFilesInPath2=_GetFileTable(FileTable2,GPath2,GFilespecList,GExcludeFilespecList,GRecursive,ProgressFormWID);
      if (NumFilesInPath2<0) {
         _enable_non_modal_forms(1,0,disabled_wid_list);
         return;
      }

      _AppendToDiffReport(DIFF_REPORT_REFRESH_ALL);
      tree1._TreeDelete(TREE_ROOT_INDEX,'C');
      tree2._TreeDelete(TREE_ROOT_INDEX,'C');

      if (!NumFilesInPath1 && !NumFilesInPath2) {
         _message_box("No Files match these parameters");
         _enable_non_modal_forms(1,0,disabled_wid_list);
         return;
      }
      _str OutputTable[];
      _str Directories[];
      status=DiffFileTables(FileTable1,GPath1,FileTable2,GPath2,OutputTable,ProgressFormWID);
      if (status!=COMMAND_CANCELLED_RC) {
         ProgressFormWID._delete_window();
      }
      _enable_non_modal_forms(1,0,disabled_wid_list);
      if (status) {
         return;
      }
      TreeCreate(FileTable1,GPath1,
                 FileTable2,GPath2,
                 OutputTable,
                 GPath1,
                 GPath2,
                 GRecursive,
                 GFilespecList,
                 GExcludeFilespecList);
      mou_hour_glass(0);
      p_active_form._set_foreground_window();
   }else if (result==IDYES) {
      _AppendToDiffReport(DIFF_REPORT_REFRESH_CHANGED);
      RefreshByDate(tree1._TreeGetFirstChildIndex(TREE_ROOT_INDEX),
                    tree2._TreeGetFirstChildIndex(TREE_ROOT_INDEX));
   }
}

//You can't pass a pointer to a builtin, so I had to do this.  Maybe it would
//have been better to duplicate code for next and prev...
static int MyTreeGetPrevIndex(index) {return(_TreeGetPrevIndex(index))}
static int MyTreeGetNextIndex(index) {return(_TreeGetNextIndex(index))}

static int FindMismatchNode2(typeless *pfn)
{
   index=_TreeCurIndex();
   for (;;) {
      index=(*pfn)(index);
      if (index<0) break;
      _TreeGetInfo(index,state,bmindex,bmindex);
      if (bmindex!=_pic_file_match && bmindex!=_pic_fldopen) return(index);
   }
   return(-1);
}

static void FindMismatchNode(typeless *pfn)
{
   index=tree1.FindMismatchNode2(pfn);
   if (index<0) {
      _message_box(nls("No more differences"));
      return;
   }
   tree1._TreeSetCurIndex(index);
   //tree2._TreeCurLineNumber(tree1._TreeCurLineNumber());
   tree2._TreeScroll(tree1._TreeScroll());
}

void _difftree_output_form.C_F6()
{
   FindMismatchNode(MyTreeGetNextIndex);
}
void ctlnext_mismatch.lbutton_up()
{
   FindMismatchNode(MyTreeGetNextIndex);
}
void _difftree_output_form.'C-S-F6'()
{
   FindMismatchNode(MyTreeGetPrevIndex);
}
void ctlprev_mismatch.lbutton_up()
{
   FindMismatchNode(MyTreeGetPrevIndex);
}

#define MATCHING_FILES 1
#define VIEWED_FILES   2
#define MISSING_FILES  3

static void ReplaceFiles(int index,int bmindex)
{
   UnhidParents=0;
   for (;index>=0;) {
      _TreeGetInfo(index,state,curbmindex,curbmindex,flags);
      userinfo=_TreeGetUserInfo(index);
      parse userinfo with date (ASCII1) manuallyhidden .;
      if ((flags&TREENODE_HIDDEN) &&
          (curbmindex==bmindex || (bmindex<0 && manuallyhidden==1)) ) {
         _TreeSetInfo(index,state,curbmindex,curbmindex,flags&~TREENODE_HIDDEN);
         _TreeSetUserInfo(index,date:+ASCII1);
         if (bmindex<0) {
            //showing the manually hidden nodes
            --GNumHidden;
         }
         if (!UnhidParents) {
            UnhidParents=1;
            pindex=_TreeGetParentIndex(index);
            while (pindex>=0) {
               _TreeGetInfo(pindex,state,curbmindex,curbmindex,flags);
               if (flags&TREENODE_HIDDEN) {
                  _TreeSetInfo(pindex,state,curbmindex,curbmindex,flags&~TREENODE_HIDDEN);
                  userinfo=_TreeGetUserInfo(pindex);
                  parse userinfo with date (ASCII1) manuallyhidden .;
                  _TreeSetUserInfo(pindex,date:+ASCII1);
               }
               pindex=_TreeGetParentIndex(pindex);
            }
         }
      }
      cindex=_TreeGetFirstChildIndex(index);
      if (cindex>=0) ReplaceFiles(cindex,bmindex);
      index=_TreeGetNextSiblingIndex(index);
   }
}

static void HideFiles(int index,int bmindex)
{
   for (;index>=0;) {
      _TreeGetInfo(index,state,curbmindex,curbmindex,flags);
      if (!(flags&TREENODE_HIDDEN) && curbmindex==bmindex) {
         _TreeSetInfo(index,state,curbmindex,curbmindex,flags|TREENODE_HIDDEN);
      }
      cindex=_TreeGetFirstChildIndex(index);
      if (cindex>=0) HideFiles(cindex,bmindex);
      index=_TreeGetNextSiblingIndex(index);
   }
}

static void HideCurrent()
{
   index=_TreeCurIndex();
   if (index<1) return;//ShowRoot is off
   ++GNumHidden;
   _TreeGetInfo(index,state,bm1,bm2,flags);
   _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_HIDDEN);
   info=_TreeGetUserInfo(index);
   parse info with date (ASCII1) .;
   info=date:+ASCII1:+1;//The 1 means that this item was manually hidden
   _TreeSetUserInfo(index,info);
}

_command void MFDiffCommand()
{
   tree1.p_redraw=0;
   tree2.p_redraw=0;
   if (arg(1)=='') {
      tree1.p_redraw=1;
      tree2.p_redraw=1;
      return;
   }
   switch (arg(1)) {
   case 'HideCurrent':
      wid=p_window_id;
      GNoOnChange=1;
      index=_TreeCurIndex();
      ln=_TreeCurLineNumber();
      HideCurrent();
      index=_TreeGetNextIndex(index);
      if (index>0) {//ShowRoot is off
         _TreeSetCurIndex(index);
      }

      if (p_window_id==tree1) {
         p_window_id=tree2;
      }else{
         p_window_id=tree1;
      }
      _TreeCurLineNumber(ln);
      index=_TreeCurIndex();
      HideCurrent();
      index=_TreeGetNextIndex(index);
      if (index>0) {//ShowRoot is off
         _TreeSetCurIndex(index);
      }
      index1=tree1._TreeCurIndex();

      p_window_id=wid;
      GNoOnChange=0;
      tree1.call_event(CHANGE_SELECTED,index1,tree1,ON_CHANGE,'W');
      tree1.p_redraw=1;
      tree2.p_redraw=1;
      return;
   case 'ShowHidden':
      //Show those items that were manually hidden
      tree1.ReplaceFiles(TREE_ROOT_INDEX,-1);
      tree2.ReplaceFiles(TREE_ROOT_INDEX,-1);
      break;
   case 'hdifferent':
      mou_hour_glass(1);
      if (def_diff_view_options&DIFF_VIEW_DIFFERENT_FILES) {
         def_diff_view_options&=~DIFF_VIEW_DIFFERENT_FILES;
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_filed);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_filed);
         tree1.MaybeHideNode(TREE_ROOT_INDEX);
         tree2.MaybeHideNode(TREE_ROOT_INDEX);
      }else{
         def_diff_view_options|=DIFF_VIEW_DIFFERENT_FILES;
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filed);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filed);
      }
      mou_hour_glass(0);
      break;
   case 'hmatching':
      mou_hour_glass(1);
      if (def_diff_view_options&DIFF_VIEW_MATCHING_FILES) {
         def_diff_view_options&=~DIFF_VIEW_MATCHING_FILES;
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_file_match);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_file_match);
         tree1.MaybeHideNode(TREE_ROOT_INDEX);
         tree2.MaybeHideNode(TREE_ROOT_INDEX);
      }else{
         def_diff_view_options|=DIFF_VIEW_MATCHING_FILES;
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_file_match);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_file_match);
      }
      mou_hour_glass(0);
      break;
   case 'hviewed':
      mou_hour_glass(1);
      if (def_diff_view_options&DIFF_VIEW_VIEWED_FILES) {
         def_diff_view_options&=~DIFF_VIEW_VIEWED_FILES;
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_filed2);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_filed2);
         tree1.MaybeHideNode(TREE_ROOT_INDEX);
         tree2.MaybeHideNode(TREE_ROOT_INDEX);
      }else{
         def_diff_view_options|=DIFF_VIEW_VIEWED_FILES;
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filed2);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filed2);
      }
      mou_hour_glass(0);
      break;
   case 'hmissing1':
      mou_hour_glass(1);
      if (def_diff_view_options&DIFF_VIEW_MISSING_FILES1) {
         def_diff_view_options&=~DIFF_VIEW_MISSING_FILES1;
         //tree1.HideFiles(TREE_ROOT_INDEX,_pic_filep);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_filep);
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_filem);
         //tree2.HideFiles(TREE_ROOT_INDEX,_pic_filem);
         //tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);
         //tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);

         tree1.MaybeHideNode(TREE_ROOT_INDEX);
         tree2.MaybeHideNode(TREE_ROOT_INDEX);
      }else{
         def_diff_view_options|=DIFF_VIEW_MISSING_FILES1;
         //tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filep);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filep);
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filem);
         //tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filem);
         //tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenm);
         //tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenm);
      }
      mou_hour_glass(0);
      break;
   case 'hmissing2':
      mou_hour_glass(1);
      if (def_diff_view_options&DIFF_VIEW_MISSING_FILES2) {
         def_diff_view_options&=~DIFF_VIEW_MISSING_FILES2;
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_filep);
         //tree2.HideFiles(TREE_ROOT_INDEX,_pic_filep);
         //tree1.HideFiles(TREE_ROOT_INDEX,_pic_filem);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_filem);
         tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         //tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         //tree1.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);
         tree2.HideFiles(TREE_ROOT_INDEX,_pic_fldopenm);

         tree1.MaybeHideNode(TREE_ROOT_INDEX);
         tree2.MaybeHideNode(TREE_ROOT_INDEX);
      }else{
         def_diff_view_options|=DIFF_VIEW_MISSING_FILES2;
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filep);
         //tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filep);
         //tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_filem);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_filem);
         tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         //tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenp);
         //tree1.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenm);
         tree2.ReplaceFiles(TREE_ROOT_INDEX,_pic_fldopenm);
      }
      mou_hour_glass(0);
      break;
   }
   tree1.call_event(CHANGE_SELECTED,tree1._TreeCurIndex(),tree1,ON_CHANGE,'w');
   tree2.call_event(CHANGE_SELECTED,tree2._TreeCurIndex(),tree1,ON_CHANGE,'w');
   tree1.p_redraw=1;
   tree2.p_redraw=1;
   tree1._TreeTop();
   tree2._TreeTop();
}

static void InsertByFlags(int bmindex,_str path,int flags,int origwid=0)
{
   if (bmindex==_pic_file_match) {
      if (flags&DIFF_VIEW_MATCHING_FILES) {
         insert_line(path);
      }
   }else if (bmindex==_pic_filem) {
      if (flags&DIFF_VIEW_MISSING_FILES1) {
         if (origwid.p_name=='tree1') {
            insert_line(path);
         }
      }else if (flags&DIFF_VIEW_MISSING_FILES2) {
         if (origwid.p_name=='tree2') {
            insert_line(path);
         }
      }
   }else if (bmindex==_pic_filep) {
      //say('plus n='origwid.p_name' m1='(flags&DIFF_VIEW_MISSING_FILES1));
      if (flags&DIFF_VIEW_MISSING_FILES1) {
         if (origwid.p_name=='tree2') {
            insert_line(path);
         }
      }else if (flags&DIFF_VIEW_MISSING_FILES2) {
         if (origwid.p_name=='tree1') {
            insert_line(path);
         }
      }
   }else if (bmindex==_pic_filed2) {
      if (flags&DIFF_VIEW_VIEWED_FILES) {
         insert_line(path);
      }
   }else if (bmindex==_pic_filed) {
      if (flags&DIFF_VIEW_DIFFERENT_FILES) {
         insert_line(path);
      }
   }
}

//ParentIndex is actually the linenumber of the parent entry in the file
static void WriteDiffTreeData(int index,int indent,int temp_view_id,...)
{
   options=arg(4);
   OutputFlags=arg(5);
   _TreeGetInfo(index,state,bm1,bm2,flags);
   cap=_TreeGetCaption(index);
   info=_TreeGetUserInfo(index);
   parse info with date (ASCII1) manually_hidden .;
   pindex=_TreeGetParentIndex(index);
   _str path='';
   if (pindex>=0) {
      path=_TreeGetCaption(pindex);
   }
   orig_view_id=p_view_id;
   origwid=p_window_id;
   p_view_id=temp_view_id;
   if (options=='') {
      insert_line(indent"\1"cap"\1"state"\1"name_name(bm1)"\1"name_name(bm2)"\1"flags"\1"date);
   }else if (pindex>0) {
      InsertByFlags(bm1,path:+cap,OutputFlags,origwid);
   }
   pLineNum=p_line;
   p_view_id=orig_view_id;
   cindex=_TreeGetFirstChildIndex(index);
   if (cindex>-1) {
      WriteDiffTreeData(cindex,indent+1,temp_view_id,options,OutputFlags);
   }
   for (;;) {
      sindex=_TreeGetNextSiblingIndex(index);
      if (sindex<0) break;
      //message('writing '_TreeGetCaption(sindex));
      _TreeGetInfo(sindex,state,bm1,bm2,flags);
      cap=_TreeGetCaption(sindex);
      info=_TreeGetUserInfo(sindex);
      parse info with date (ASCII1) manually_hidden .;
      path=_TreeGetCaption(_TreeGetParentIndex(sindex));
      orig_view_id=p_view_id;
      p_view_id=temp_view_id;
      if (options=='') {
         insert_line(indent"\1"cap"\1"state"\1"name_name(bm1)"\1"name_name(bm2)"\1"flags"\1"date);
      }else{
         if (OutputFlags=='') {
            OutputFlags=0;
         }
         InsertByFlags(bm1,path:+cap,OutputFlags,origwid);
      }
      pLineNum=p_line;
      p_view_id=orig_view_id;
      index=sindex;
      cindex=_TreeGetFirstChildIndex(index);
      if (cindex>-1) {
         WriteDiffTreeData(cindex,indent+1,temp_view_id,options,OutputFlags);
      }
   }
}

static void InsertDataForTree(int temp_view_id)
{
   orig_view_id=p_view_id;
   showRoot=p_ShowRoot;
   controlName=p_name;
   p_view_id=temp_view_id;
   insert_line(controlName);
   insert_line('p_ShowRoot='showRoot);
   p_view_id=orig_view_id;
   index=TREE_ROOT_INDEX;
   WriteDiffTreeData(TREE_ROOT_INDEX,0,temp_view_id);
}

static int SaveMFDiffInfo(_str filename)
{
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=orig_view_id;

   p_window_id=tree1;
   _ini_set_value(filename,'State','def_diff_view_options',def_diff_view_options);
   _ini_set_value(filename,'State','filespec_list',GFilespecList);
   _ini_set_value(filename,'State','exclude_filespec_list',GExcludeFilespecList);
   _ini_set_value(filename,'State','path1',GPath1);
   _ini_set_value(filename,'State','path2',GPath2);
   _ini_set_value(filename,'State','recursive',GRecursive);
   tree1.InsertDataForTree(temp_view_id);

   p_view_id=temp_view_id;
   p_view_id=orig_view_id;
   status=_ini_put_section(filename,'TreeData1',temp_view_id);

   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=orig_view_id;
   tree2.InsertDataForTree(temp_view_id);
   status=_ini_put_section(filename,'TreeData2',temp_view_id);

   //p_view_id=temp_view_id;
   //status=_save_file('+o');
   return(status);
}

static void AddChildren(int Parent,int Indent,int tree_view_id,int hashtab:[]=null)
{
   orig_view_id=p_view_id;
   Last=Parent;
   while (!down()) {
      get_line(line);
      //IndentLevel=GetIndent(line);
      parse line with IndentLevel"\1"cap"\1"state"\1"bm1Name"\1"bm2Name"\1"flags"\1"date .;
      if (hashtab._indexin(bm1Name)) {
         bm1=hashtab:[bm1Name];
      }else{
         bm1=find_index(bm1Name,PICTURE_TYPE);
         hashtab:[bm1Name]=bm1;
      }
      if (hashtab._indexin(bm2Name)) {
         bm2=hashtab:[bm2Name];
      }else{
         bm2=find_index(bm2Name,PICTURE_TYPE);
         hashtab:[bm2Name]=bm2;
      }
      if (IndentLevel>Indent) {
         up();
         AddChildren(Last,IndentLevel,tree_view_id,hashtab);
      }else if (IndentLevel<Indent) {
         if (IndentLevel>0) up();
         return;
      }else{
         p_view_id=tree_view_id;
         IsCurIndex=0;
         Last=_TreeAddItem(Parent,
                           cap,
                           TREE_ADD_AS_CHILD,
                           bm1,
                           bm2,
                           state);      //Initial State
         _TreeSetUserInfo(Last,date);
         _TreeSetInfo(Last,state,bm1,bm2,flags);
         if (IsCurIndex) {
            _TreeSetCurIndex(Last);
         }
         p_view_id=orig_view_id;
      }
   }
}

static int ReadTree(_str filename,_str section)
{
   //status=_open_temp_view(filename,temp_view_id,orig_view_id);
   orig_view_id=p_view_id;
   status=_ini_get_section(filename,section,temp_view_id);
   if (status) {
      if (status==NEW_FILE_RC) {
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }
      return(status);
   }
   p_view_id=temp_view_id;
   p_line=3;//Skip the first 3 lines
   AddChildren(0,0,orig_view_id);
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(0);
}

defeventtab _difftree_save_form

ctlstate.lbutton_up()
{
   if (p_window_id==ctlstate) {
      ctlmatching.p_enabled=ctlviewed.p_enabled=ctlmissing1.p_enabled=ctlmissing2.p_enabled=ctldifferent.p_enabled=0;
   }else{
      ctlmatching.p_enabled=ctlviewed.p_enabled=ctlmissing1.p_enabled=ctlmissing2.p_enabled=ctldifferent.p_enabled=1;
   }
}

#define SAVE_PATH1_CAPTION "Save Path &1 Filelist ()"
#define SAVE_PATH2_CAPTION "Save Path &2 Filelist ()"

void ctlok.on_create(/*_str path1,_str path2*/)
{
   _str path1=arg(1);
   _str path2=arg(2);
   if (def_diff_view_options&DIFF_VIEW_MATCHING_FILES) {
      ctlmatching.p_value=1;
   }
   if (def_diff_view_options&DIFF_VIEW_VIEWED_FILES) {
      ctlviewed.p_value=1;
   }
   if (def_diff_view_options&DIFF_VIEW_MISSING_FILES1) {
      ctlmissing1.p_value=1;
   }
   if (def_diff_view_options&DIFF_VIEW_MISSING_FILES2) {
      ctlmissing2.p_value=1;
   }
   if (def_diff_view_options&DIFF_VIEW_DIFFERENT_FILES) {
      ctldifferent.p_value=1;
   }
#define RB_CHEAT_FACTOR 200
//Cheat factor for width of a radio button
   ctllist_left.p_width=ctllist_left._text_width(SAVE_PATH1_CAPTION)+
                        ctllist_left._text_width(path1)+RB_CHEAT_FACTOR;
   int path1CaptionLength=ctllist_left._text_width(SAVE_PATH1_CAPTION);
   int path2CaptionLength=ctllist_right._text_width(SAVE_PATH2_CAPTION);
   if (ctllist_left.p_width+ctllist_left.p_x > p_active_form.p_width) {
      path1=_ShrinkFilename(path1,p_active_form.p_width-(ctllist_left.p_x+RB_CHEAT_FACTOR+path1CaptionLength));
   }
   ctllist_left.p_caption=stranslate(SAVE_PATH1_CAPTION,'('path1')','()');

   ctllist_right.p_width=ctllist_right._text_width(SAVE_PATH1_CAPTION)+
                         ctllist_right._text_width(path2)+RB_CHEAT_FACTOR;
   if (ctllist_right.p_width+ctllist_right.p_x>p_active_form.p_width) {
      path2=_ShrinkFilename(path2,p_active_form.p_width-(ctllist_right.p_x+RB_CHEAT_FACTOR+path2CaptionLength));
   }
   ctllist_right.p_caption=stranslate(SAVE_PATH2_CAPTION,'('path2')','()');
}

_str ctlok.lbutton_up()
{
   if (ctlstate.p_value) {
      p_active_form._delete_window('S');
      return('S');
   }
   flags=0;
   if (ctlmatching.p_value) flags|=DIFF_VIEW_MATCHING_FILES;
   if (ctlviewed.p_value) flags|=DIFF_VIEW_VIEWED_FILES;
   if (ctlmissing1.p_value) flags|=DIFF_VIEW_MISSING_FILES1;
   if (ctlmissing2.p_value) flags|=DIFF_VIEW_MISSING_FILES2;
   if (ctldifferent.p_value) flags|=DIFF_VIEW_DIFFERENT_FILES;
   if (ctllist_left.p_value) {
      p_active_form._delete_window('L 'flags);
      return('L 'flags);
   }else if (ctllist_right.p_value) {
      p_active_form._delete_window('R 'flags);
      return('R 'flags);
   }
   p_active_form._delete_window();
   return('');
}

defeventtab _difftree_progress_form

void _difftree_progress_form.on_got_focus()
{
   p_active_form.refresh('W');
}

void ctlcancel.on_create()
{
   gCancel=false;
}

void ctlcancel.lbutton_up()
{
   gCancel=true;
   //p_active_form._delete_window();
}

static void SetProgressMessage(_str Prefix='',_str Filename1='',_str Filename2='')
{
   //5:52pm 6/15/1998
   //this is pretty special case stuff here
   //set label captions differently for "compares" and "build file lists"
   if (pos('Comparing',Prefix,1,'i')) {
      int FilenameWidth=label1.p_width-(label1._text_width(Prefix' '));
      label1.p_caption=Prefix' '_ShrinkFilename(Filename1,FilenameWidth);
      label2.p_caption="and";
      label3.p_caption=_ShrinkFilename(Filename2,label2.p_width);
   }else if (pos('Building',Prefix,1,'i')) {
      label1.p_caption=Prefix;
      label2.p_caption=_ShrinkFilename(Filename1,label2.p_width);
      label3.p_caption=Filename2;
      p_active_form.refresh('W');
   }
}

static void HideProgressGauge()
{
   gauge1.p_visible=0;
   ctlcancel.p_y-=gauge1.p_height;
   p_active_form.p_height-=gauge1.p_height;
   refresh();
}

static void ShowProgressGauge()
{
   gauge1.p_visible=1;
   ctlcancel.p_y+=gauge1.p_height;
   p_active_form.p_height+=gauge1.p_height;
   refresh();
}
