/*
$VerboseHistory: dlgman.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:45a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:44a
 * Comment:
 * Changed run_selected binding to use Ctrl+Shift+Space
 * instead of Shift+Space
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

static _str _default_wid,_adefault_wid,_in_enter,_cancel_wid
definit()
{
   _in_enter=0
}

//
//    DIALOG MANAGER.  Automatic inheritance for form control
//
defeventtab _ainh_dlg_manager
_ainh_dlg_manager.c_e()
{
   p_enabled=0
}

_ainh_dlg_manager."c-s- "()
{
   p_window_id=p_active_form
   _on_edit_form()
}

#if 0
_ainh_dlg_manager."s- "()
{
   p_window_id=p_active_form
   _on_edit_form()
}
#endif
#if 0
_ainh_dlg_manager." "()
{
   if (p_object==OI_CHECK_BOX) {
      call_event(p_window_id,LBUTTON_UP)
   }
}
#endif
_ainh_dlg_manager.F7()
{
   _retrieve_next_form('-',1);
}
_ainh_dlg_manager.F8()
{
   _retrieve_next_form('',1);
}
_ainh_dlg_manager.up,left()
{
   if (p_object!=OI_RADIO_BUTTON && p_object!=OI_CHECK_BOX &&
       p_object!=OI_COMMAND_BUTTON) return('');
   /* Look for previous radio button. */
   wid=first_wid=p_window_id
   tab_index=0;
   next_wid=0;
   wrap_index=0;
   wrap_wid=0;
   for (;;) {
      wid=wid.p_next;
      if (wid==first_wid) break;
      if (wid.p_tab_stop && wid.p_tab_index>0 &&
          wid._enabled()){
          if(wid.p_tab_index<p_tab_index && wid.p_tab_index>tab_index) {
             tab_index=wid.p_tab_index;
             next_wid=wid;
          }
          if (!wrap_wid || wid.p_tab_index>wrap_index) {
             wrap_index=wid.p_tab_index;
             wrap_wid=wid;
          }
      }
   }
   if (next_wid) {
      p_window_id=next_wid;
      if (p_object==OI_RADIO_BUTTON) {
         if (!p_value) {
            p_value=1;
            call_event(p_window_id,LBUTTON_UP)
         }
      }
   } else if (wrap_wid) {
      p_window_id=wrap_wid;
      if (p_object==OI_RADIO_BUTTON) {
         if (!p_value) {
            p_value=1;
            call_event(p_window_id,LBUTTON_UP)
         }
      }
   }
   _set_focus();
}
_ainh_dlg_manager.down,right()
{
   if (p_object!=OI_RADIO_BUTTON && p_object!=OI_CHECK_BOX &&
       p_object!=OI_COMMAND_BUTTON) return('');
   /* Look for previous radio button. */
   wid=first_wid=p_window_id
   next_tab_index=0xffffff;  /* Make this larger that 65535 */
   next_wid=0;
   wrap_index=0;
   wrap_wid=0;
   for (;;) {
      wid=wid.p_next;
      if (wid==first_wid) break;
      if (wid.p_tab_stop && wid.p_tab_index>0 &&
          wid._enabled()){
          if(wid.p_tab_index>p_tab_index &&
             (wid.p_tab_index<next_tab_index)) {
             next_tab_index=wid.p_tab_index;
             next_wid=wid;
          }
          if(!wrap_wid || wid.p_tab_index<wrap_index) {
             wrap_index=wid.p_tab_index;
             wrap_wid=wid;
          }
      }
   }
   if (next_wid) {
      p_window_id=next_wid;
      if (p_object==OI_RADIO_BUTTON) {
         if (!p_value) {
            p_value=1;
            call_event(p_window_id,LBUTTON_UP)
         }
      }
   } else if (wrap_wid) {
      p_window_id=wrap_wid;
      if (p_object==OI_RADIO_BUTTON) {
         if (!p_value) {
            p_value=1;
            call_event(p_window_id,LBUTTON_UP)
         }
      }
   }
   _set_focus();
}
static int _default2(wid)
{
   if (wid.p_object!=OI_COMMAND_BUTTON) {
      return(0)
   }
   if (!wid.p_enabled) {
      return(0);
   }
   if (wid.p_cancel) {
      _cancel_wid=wid
   }
   if (wid.p_adefault) {
      _adefault_wid=wid
   } else if (wid.p_default){
      _default_wid=wid
   }
   return(0)
}
static _str in_lbdown=0;
_ainh_dlg_manager.lbutton_up()
{
   if (p_object==OI_COMMAND_BUTTON) {
      if (p_cancel) {
         call_event(defeventtab  _ainh_dlg_manager,ESC,'E')
      } else if (p_default) {
         if (_in_enter) {
            _dmhelp();
         } else {
            call_event(defeventtab  _ainh_dlg_manager,ENTER,'E')
         }
      } else if(p_command!=""){
         _in_enter=p_window_id;
         _tbCommand();
         _in_enter=0;
      } else {
         _dmhelp();
      }
   }
}

static void _dmhelp2(help_item)
{
   if (substr(help_item,1,1)=='?') {
      popup_imessage(substr(help_item,2));
      return;
   }
   parse help_item with keyword ':' help_file
   help(keyword,help_file);

}
void _dmhelp()
{
   help_item=p_help;
   if (help_item=='') {
      help_item=p_active_form.p_help;
      if (help_item == "") {
         // Loop thru form's children for a tab control and use
         // the active tab's ActiveHelp string.
         int formwid;
         formwid = p_active_form;
         int child, orichild;
         orichild = child = formwid.p_child;
         while (child) {
            if (child.p_object == OI_SSTAB) {
               help_item = child.p_ActiveHelp;
               break;
            }
            child = child.p_next;
            if (child == orichild) break;
         }
      }
   }
   if (help_item=='') {
      return;
   }
   _dmhelp2(help_item);
}
void _ainh_dlg_manager.esc,A_F4,on_close()
{
   if (p_isbutton_bar) {
      if (last_event():==A_F4 && name_on_key(A_F4)=='safe-exit') {
         safe_exit();
      }
      if (last_event():==ESC) {
         if (_default_option(VSOPTION_HAVECMDLINE)) {
            _cmdline._set_focus();
         } else {
           if (_no_child_windows()) {
              _mdi.p_child._set_focus();
           }
         }
         //if (!_no_child_windows()) {
         //   _mdi.p_child._set_focus();
         //} else {
         //   _cmdline._set_focus();
         //}
      }
      return;
   }
   event=last_event()
   handler=p_active_form._event_handler(on_close);
   if (handler) {
      p_active_form.call_event(p_active_form,on_close);
      return;
   }
   _cancel_wid='';_default_wid='';_adefault_wid='';
   _for_each_control(p_active_form,_default2)
   if (_cancel_wid!='') {
      handler=_cancel_wid._event_handler(LBUTTON_UP)
   }
   if (_cancel_wid!='' && handler) {
      _cancel_wid.call_event(_cancel_wid,LBUTTON_UP)
   } else if (event:==A_F4 || event:==ON_CLOSE || (_cancel_wid!='' && !handler)) {
      rc=COMMAND_CANCELLED_RC
      p_active_form._delete_window
   }
   //return(0)
}
_ainh_dlg_manager.enter()
{
   if (_in_enter && p_window_id==_in_enter) {
      return(1)
   }
   _default_wid=''
   _adefault_wid=''

   _for_each_control(p_active_form,_default2)
   if (_adefault_wid!='') {
      wid=_adefault_wid;
   } else if (_default_wid!='') {
      wid=_default_wid;
   } else {
      wid=_get_focus();
      if (!(wid==p_window_id && p_object==OI_COMMAND_BUTTON && p_command!="")) {
         // message 'nothing'
         return(1)
      }
   }
   //messageNwait('name='wid.p_name)
   /* IF the default button is the cancel button. */
   if (wid.p_cancel) {
      _in_enter=wid  // Don't want call self
      call_event(defeventtab  _ainh_dlg_manager,ESC,'E')
      _in_enter=0
      return(0)
   }
   if (wid.p_object==OI_COMMAND_BUTTON && wid.p_command!="") {
      _in_enter=wid  // Don't want call self
      _tbCommand();
      _in_enter=0;
      return(0);
   }
   // Call the default button
   _in_enter=wid;  // Don't want call self
   wid.call_event(wid,LBUTTON_UP);
   _in_enter=0;
   return(0)
}

static _str _help2(int wid)
{
   if (wid.p_help!='') {
      return(wid);
   }
   return(0);
}
_ainh_dlg_manager.f1()
{
   if (p_object == OI_SSTAB) {
      help_item=p_ActiveHelp;
   } else {
      help_item=p_help;
   }
   if (help_item=='') {
      help_item=p_active_form.p_help;
      if (help_item=='') {
         parent = p_window_id;
         while (parent) {
            if (parent.p_object == OI_SSTAB) {
               help_item=parent.p_ActiveHelp;
               break;
            }
            if (parent.p_object == OI_FORM || parent.p_object == OI_MDI_FORM) {
               break;
            }
            parent = parent.p_parent;
         }
      }
   }
   if (help_item=='') {
      wid=_for_each_control(p_active_form,_help2)
      if (!wid) {
         return('');
      }
      help_item=wid.p_help;
      if (help_item!='' && wid.p_object==OI_COMMAND_BUTTON) {
         _in_enter=wid  // Don't want call self
         wid.call_event(wid,LBUTTON_UP)
         _in_enter=0
         return('');
      }
   }
   _dmhelp2(help_item);
}
_ainh_dlg_manager.on_destroy2()
{
   if (p_init_style&IS_SAVE_XY) {
      _save_form_xy();
   }
}
static typeless _wrap, _wrap_wid,_next,_next_wid, _orig_wid;
static int _do_letter2(int wid,_str after,_str letter)
{
   switch (wid.p_object) {
   case OI_TEXT_BOX:
   case OI_COMBO_BOX:
   case OI_FORM:
   case OI_HTHELP:
   case OI_PICTURE_BOX:
   case OI_IMAGE:
   case OI_LIST_BOX:
   case OI_EDITOR:
   case OI_HSCROLL_BAR:
   case OI_VSCROLL_BAR:
   case OI_GAUGE:
   case OI_SPIN:
   case OI_TREE_VIEW:
      return(0)
   }
   if (!wid._enabled()) {
      return(0);
   }

   // For the tab control, check all the tabs for hot keys:
   if (wid.p_object==OI_SSTAB) {
      _str widTI;
      widTI = wid.MakeTabIndexString();
      int childI;
      for (childI=0; childI<wid.p_NofTabs; childI++) {
         _str text, caption;
         text = wid._getTabInfo(childI);
         parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
         caption = extractCaption(theRest);
         if (pos('&'letter,caption,1,'i')) {
            if (widTI>after && (widTI<_next || _next=='')) {
               _next=widTI;
               _next_wid=wid;
               return(0);
            }
            if (widTI<_wrap || _wrap=='') {
               _wrap=widTI;
               _wrap_wid=wid;
               return(0);
            }
            return(0);
         }
      }
      return(0);
   }

   text=wid.p_caption
   if (pos('&'letter,text,1,'i')) {
      if (wid.p_tab_index<=0 /*|| !wid.p_tab_stop*/) {
         return(0)
      }
      _str widTI;
      widTI = wid.MakeTabIndexString();
      if (widTI>after && (widTI<_next || _next=='')) {
         _next=widTI;
         _next_wid=wid
         return(0)
      }
      if (widTI<_wrap || _wrap=='') {
         _wrap=widTI;
         _wrap_wid=wid
         return(0)
      }
   }
   return(0)
}
static _str do_letter(letter)
{
   _wrap=''
   after=MakeTabIndexString();
   _next=''
   _for_each_control(p_active_form,_do_letter2,'',after,letter)
   if (_next!='') {
      wid=_next_wid
   } else if (_wrap!='') {
      wid=_wrap_wid
   } else {
      return(1)
   }
   if (wid.p_tab_stop) {
      p_window_id=wid;_set_focus();
   }
   switch (wid.p_object) {
   case OI_COMMAND_BUTTON:
      p_window_id=wid;
      call_event(p_window_id,LBUTTON_UP)
      return(0)
   case OI_CHECK_BOX:
      p_window_id=wid;
      _next_button_state();
      call_event(p_window_id,LBUTTON_UP)
      return(0);
   case OI_RADIO_BUTTON:
      p_window_id=wid;
      _set_focus();
      return(0);
   case OI_SSTAB:
      p_window_id=wid;
      _str text;
      text = p_ActiveCaption;
      // If the tab with the matching letter is the active tab, do nothing.
      // Otherwise, locate the first matching tab and activate it.
      if (!pos('&'letter,text,1,'i')) {
         int childI;
         for (childI=0; childI<p_NofTabs; childI++) {
            _str text, caption;
            text = _getTabInfo(childI);
            parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW ;
            caption = extractCaption(theRest);
            if (pos('&'letter,caption,1,'i')) {
               p_ActiveTab = childI;
               break;
            }
         }
      }
      _set_focus();
      return(0);
   }
   /* User has selected frame or label. Switch to next control. */
   p_window_id=wid;
   _next_control();
   return(0)
}
static _str _denext_control2(wid,after)
{
   if (wid.p_object==OI_FORM) return(0);
   //    IF have closer tab index
   tab_index=wid.MakeTabIndexString();
   if ((tab_index>after && (tab_index<_next || _next==''))) {
      _next=tab_index
      _next_wid=wid
      return(0)
   }
   // IF  have closer tab index
   if ((tab_index<_wrap || _wrap=='')) {
      _wrap=tab_index;
      _wrap_wid=wid;
      return(0)
   }
   return(0)
}
static _str MakeTabIndexLevel(int number)
{
   result=number;
   if (length(number)<6) {
      result=substr("",1,6-length(number),"0"):+result;
   }
   return(result);
}
static _str MakeTabIndexString()
{
   result="";
   wid=p_window_id;
   while (wid && wid.p_tab_index) {
      result=MakeTabIndexLevel(wid.p_tab_index):+result;
      if (wid.p_parent.p_object==OI_SSTAB_CONTAINER) {
         wid=wid.p_parent;
      }
      wid=wid.p_parent;
   }
   //messageNwait("MakeTabIndexString: "result);
   /*tab_index=wid.p_tab_index;
   if (wid.p_active_form.p_tab_index) {
      tab_index=(wid.p_active_form.p_tab_index<<16)+tab_index;
   } */
   // Force string compare
   return("T"result);
}
_str _next_control2(wid,after)
{
   if (!wid.p_tab_stop || wid.p_tab_index<=0 || !wid._enabled()) {
      return(0)
   }
   tab_index=wid.MakeTabIndexString();
   /*tab_index=wid.p_tab_index;
   if (wid.p_active_form.p_tab_index) {
      tab_index=(wid.p_active_form.p_tab_index<<16)+tab_index;
   } */
   //messageNwait("_next_control2: tab_index="tab_index" a="after" n="_next);
   // IF chosen control is radio button with same parent OR
   //    have closer tab index
   if ((_next!='' && wid.p_object==OI_RADIO_BUTTON &&
         _next_wid.p_object==OI_RADIO_BUTTON &&
         _next_wid.p_parent==wid.p_parent
       )
       ||
       (tab_index>after && (tab_index<_next || _next==''))) {
      if (wid.p_object==OI_RADIO_BUTTON) {
         // If original control was radio button with same parent,
         // do nothing.
         if (_orig_wid.p_object==OI_RADIO_BUTTON &&
             wid.p_parent==_orig_wid.p_parent) {
            /* messageNwait('caption='wid.p_caption) */
             return(0)
         }
         if (_next_wid!='' && _next_wid.p_object==OI_RADIO_BUTTON &&
            _next_wid.p_parent==wid.p_parent) {
            if (_next_wid.p_value) {
            /* messageNwait('h2 caption='wid.p_caption) */
               return(0)
            }
            if (wid.p_value) {
            /* messageNwait('h3 caption='wid.p_caption) */
              _next=tab_index
              _next_wid=wid
              return(0)
            }
         }
      }
      /* messageNwait('h4 caption='wid.p_caption) */
      _next=tab_index;
      _next_wid=wid;
      return(0)
   }
   // IF chosen control is option button with same parent OR
   //    have closer tab index
   if ((_wrap!='' && wid.p_object==OI_RADIO_BUTTON &&
         _wrap_wid.p_object==OI_RADIO_BUTTON &&
         _wrap_wid.p_parent==wid.p_parent
       )
       ||
        (tab_index<_wrap || _wrap=='')) {
      if (wid.p_object==OI_RADIO_BUTTON) {
         if (_wrap!='' && wid.p_parent==_orig_wid.p_parent) {
             return(0)
         }
         if (_wrap_wid!='' && _wrap_wid.p_object==OI_RADIO_BUTTON &&
            _wrap_wid.p_parent==wid.p_parent) {
            if (_wrap_wid.p_value) {
               return(0)
            }
            if (wid.p_value) {
              _wrap=tab_index
              _wrap_wid=wid
              return(0)
            }
         }
      }
      _wrap=tab_index
      _wrap_wid=wid
      return(0)
   }
   return(0)
}
_str _prev_control2(wid,before)
{
   if (wid.p_tab_index<=0 || !wid.p_tab_stop || !wid._enabled()) {
      return(0)
   }
   tab_index=wid.MakeTabIndexString();
   /*tab_index=wid.p_tab_index;
   if (wid.p_active_form.p_tab_index) {
      tab_index=(wid.p_active_form.p_tab_index<<16)+tab_index;
   } */
   // IF chosen control is radio button with same parent OR
   //    have closer tab index
   if ((_next!='' && wid.p_object==OI_RADIO_BUTTON &&
         _next_wid.p_object==OI_RADIO_BUTTON &&
         _next_wid.p_parent==wid.p_parent
       )
       ||
        (tab_index<before && (tab_index>_next || _next==''))) {
      if (wid.p_object==OI_RADIO_BUTTON) {
         // If original control was radio button with same parent,
         // do nothing.
         if (_orig_wid.p_object==OI_RADIO_BUTTON &&
             wid.p_parent==_orig_wid.p_parent) {
             return(0)
         }
         if (_next_wid!='' && _next_wid.p_object==OI_RADIO_BUTTON &&
            _next_wid.p_parent==wid.p_parent) {
            if (_next_wid.p_value) {
               return(0)
            }
            if (wid.p_value) {
              _next=tab_index
              _next_wid=wid
              return(0)
            }
         }
      }
      _next=tab_index
      _next_wid=wid
      return(0)
   }
   // IF chosen control is option button with same parent OR
   //    have closer tab index
   if ((_wrap!='' && wid.p_object==OI_RADIO_BUTTON &&
         _wrap_wid.p_object==OI_RADIO_BUTTON &&
         _wrap_wid.p_parent==wid.p_parent
       )
       ||
       (tab_index>_wrap || _wrap=='')) {
      if (wid.p_object==OI_RADIO_BUTTON) {
         if (_wrap!='' && wid.p_parent==_orig_wid.p_parent) {
             return(0)
         }
         if (_wrap_wid!='' && _wrap_wid.p_object==OI_RADIO_BUTTON &&
            _wrap_wid.p_parent==wid.p_parent) {
            if (_wrap_wid.p_value) {
               return(0)
            }
            if (wid.p_value) {
              _wrap=tab_index
              _wrap_wid=wid
              return(0)
            }
         }
      }
      _wrap=tab_index
      _wrap_wid=wid
      return(0)
   }
   return(0)
}
static _str _deprev_control2(wid,before)
{
   if (wid.p_object==OI_FORM) return(0);
   // IF have closer tab index
   tab_index=wid.MakeTabIndexString();
   if ((tab_index<before && (tab_index>_next || _next==''))) {
      _next=tab_index
      _next_wid=wid
      return(0)
   }
   // IF have closer tab index
   if ((tab_index>_wrap || _wrap=='')) {
      _wrap=tab_index
      _wrap_wid=wid
      return(0)
   }
   return(0)
}
void _prev_control()
{
   _next_control('P')
}
void _next_control(_str direction="",int form_wid=0)
{
   _orig_wid=p_window_id;
   _wrap='';   // Window id of control to wrap to
   //after=p_tab_index   // Want to fint tab index after this one.
   after=MakeTabIndexString();
   _next=''   // Window id of next control
   _next_wid=''
   _wrap_wid=''
   if (p_cb && p_object!=OI_COMBO_BOX) {
      after=p_cb.p_tab_index
   }
   if (upcase(arg(1))=='P') {
      index=find_index('_prev_control2',PROC_TYPE)
   } else {
      index=find_index('_next_control2',PROC_TYPE)
   }
   if (!form_wid) {
      form_wid=p_active_form;
   }
   if (form_wid.p_isbutton_bar && form_wid.p_parent && form_wid.p_parent.p_isbutton_bar==p_isbutton_bar) {
      //after=(form_wid.p_tab_index<<16)+after;
      form_wid=form_wid.p_parent.p_active_form;
   } 
   _for_each_control(form_wid,index,'',after)
   if (_next!='') {
      p_window_id=_next_wid;_set_focus();
      return;
   }
   if (_wrap!='') {
      p_window_id=_wrap_wid;_set_focus();
   }
}
void _deprev_control()
{
   _denext_control('P')
}
void _denext_control()
{
   //_orig_wid=p_window_id
   _wrap='';
   after=MakeTabIndexString();
   //after=p_tab_index
   _next=''
   if (p_cb && p_object!=OI_COMBO_BOX) {
      after=p_cb.p_tab_index
   }
   if (upcase(arg(1))=='P') {
      pfn=_deprev_control2;
   } else {
      pfn=_denext_control2;
   }
   _for_each_control(p_active_form,pfn,'',after)
   if (_next!='') {
      p_window_id=_next_wid
      return;
   }
   if (_wrap!='') {
      p_window_id=_wrap_wid
   }
}
//
//   Changes p_value to next value based on p_style and p_object
//   Currently this function only supports p_object==OI_CHECK_BOX
//
void _next_button_state()
{
    switch (p_style) {
    case PSCH_AUTO2STATE:
       p_value= (int)(!p_value);
       break;
    case PSCH_AUTO3STATEA:    /* Gray, check, uncheck. */
       switch (p_value) {
       case 0:
          p_value=2
          break;
       case 1:
          p_value=0;
          break;
       case 2:
          p_value=1;
          break;
       }
       break;
    case PSCH_AUTO3STATEB:    /* Gray, uncheck, check */
       switch (p_value) {
       case 0:
          p_value=1
          break;
       case 1:
          p_value=2;
          break;
       case 2:
          p_value=0;
          break;
       }
       break;
    }
}
_ainh_dlg_manager.'A'-'Z','a'-'z'()
{
   status=do_letter(last_event())
   if (status) {
      _beep()
   } else {
      _dmselect_text();
   }
}

void _ainh_dlg_manager.A_A-A_Z,A_0-A_9()
{
   if (p_isbutton_bar) {
      if (def_alt_menu) {
         _mdi._menu_event(last_event());
         return;
      }
   }
   event=last_event();
   parse event2name(event) with 'A-' id
   status=do_letter(id)
   if (status) {
      p_active_form._menu_event(event);
      //_beep()
   } else {
      _dmselect_text();
   }
}

_ainh_dlg_manager.on_lost_focus()
{
   if (p_object==OI_TEXT_BOX || p_object==OI_COMBO_BOX) {
      if (!p_auto_select) return('');
      _set_sel(p_sel_start+p_sel_length)
   }
#if 0
   if(p_object==OI_TEXT_BOX) {
      if (!p_auto_select) return('');
      _set_sel(p_sel_start+p_sel_length)
   } else if(p_object==OI_COMBO_BOX && p_style!=PSCBO_NOEDIT){
      if (!p_auto_select) return('');
      p_cb_text_box._set_sel(p_sel_start+p_sel_length)
   }
#endif
}
static _dmselect_text()
{
   if(p_object==OI_TEXT_BOX) {
      if (!p_auto_select) return('');
      _set_sel(1,length(p_text)+1)
   } else if(p_object==OI_COMBO_BOX && p_style!=PSCBO_NOEDIT){
      if (!p_auto_select) return('');
      p_cb_text_box._set_sel(1,length(p_text)+1)
   }
}
_ainh_dlg_manager."c-tab"()
{
   int parent;
   parent = p_window_id;
   if (p_object != OI_SSTAB) {
      parent = parent.p_parent;
outerloop:
      while (parent) {
         if (parent.p_object == OI_SSTAB) {
            break;
         }
         if (parent.p_object == OI_FORM || parent.p_object == OI_MDI_FORM) {
            // Search for Tab control on form.
            first_wid=parent.p_child;
            if (!first_wid) {
               return("");
            }
            for (wid=first_wid;;) {
               if (wid.p_object==OI_SSTAB) {
                  parent=wid;
                  break;
               }
               wid=wid.p_next;
               if (wid==first_wid) {
                  return("");
               }
            }
            break outerloop;
         }
         parent = parent.p_parent;
      }
      if (!parent || parent.p_object != OI_SSTAB) return("");
   }
   p_window_id = parent;
   if (parent.p_tab_stop) {
      _set_focus();
   }
   call_event(p_window_id,RIGHT);
   return("");
}
_ainh_dlg_manager."c-s-tab"()
{
   int parent;
   parent = p_window_id;
   if (p_object != OI_SSTAB) {
      parent = parent.p_parent;
      while (parent) {
         if (parent.p_object == OI_SSTAB) {
            break;
         }
         if (parent.p_object == OI_FORM || parent.p_object == OI_MDI_FORM) {
            return("");
         }
         parent = parent.p_parent;
      }
      if (parent.p_object != OI_SSTAB) return("");
   }
   p_window_id = parent;
   if (parent.p_tab_stop) {
      _set_focus();
   }
   call_event(p_window_id,LEFT)
   return("");
}
_ainh_dlg_manager.tab()
{
   orig_wid=p_window_id
   _next_control();
   if (orig_wid!=p_window_id){
      _dmselect_text();
   }
}
_ainh_dlg_manager.s_tab()
{
   orig_wid=p_window_id
   _prev_control();
   if (orig_wid!=p_window_id){
      if(p_object==OI_TEXT_BOX) {
         if (!p_auto_select) return('');
         _set_sel(1,length(p_text)+1)
      } else if(p_object==OI_COMBO_BOX && p_style!=PSCBO_NOEDIT){
         if (!p_auto_select) return('');
         p_cb_text_box._set_sel(1,length(p_text)+1)
      }
   }
}
/*
      callback   may be index to function or function pointer
      arg(3)  Set to 'H' if hidden (p_visible=0) controls should be
              included in tree traversal.
      arg(4)..arg(7)   arguments to call back function
*/
_str _for_each_control(wid,callback,...)
{
   if (upcase(arg(3))!='H') {
      if( (!wid.p_edit && !wid.p_visible && wid.p_object!=OI_SSTAB_CONTAINER) ||
            (wid.p_edit && !wid.p_undo_visible)
        ){
         //message('h1 p_name='p_name);delay(300);clear_message
         return(0);
      }
      form_wid=wid.p_active_form;
      if (!wid.p_edit && wid.p_object!=OI_FORM &&
          (wid.p_y> _dy2ly(form_wid.p_xyscale_mode,form_wid.p_client_height) ||
           wid.p_x> _dx2lx(form_wid.p_xyscale_mode,form_wid.p_client_width)
          )
          ) {
         //message('h2 p_name='p_name);delay(300);clear_message
         return(0);
      }
   }
   if(!_isfunptr(callback)){
      if (!isinteger(callback)) {
         name=callback
         callback=find_index(callback,PROC_TYPE|COMMAND_TYPE)
         if (!callback) {
            _message_box(nls("_sellist: Call back function '%s', not found",name))
            callback=0
         }
      }
      callback=name_index2funptr(callback);
   }
   status=(*callback)(wid,arg(4),arg(5),arg(6),arg(7))
   if (status) {
      return(status)
   }
   if (wid.p_child && wid.p_object!=OI_COMBO_BOX) {
      child=first_child=wid.p_child;
      if (!(child&0xffff0000) && child.p_object==OI_SSTAB_CONTAINER) {
         tabwid=wid._getActiveWindow();
         //say( "wid obj="wid.p_object" tabwid obj="tabwid.p_object );
         //say( "Skipping over OI_SSTAB_CONTAINER="tabwid.p_object" child="child );
         child=first_child=tabwid.p_child;
      }
      for (;child;) {
         // Don't recurse forms.  Form can be child of dialog box.
         // This indicates owner.
         if (child.p_object!=OI_FORM || child.p_isbutton_bar) {
            status=_for_each_control(child,callback,arg(3),arg(4),arg(5),arg(6),arg(7))
            if (status) {
               return(status)
            }
         }
         child=child.p_next;
         if (child==first_child) break;
      }
   }
   return(0)
}

_str _rgb(r,g,b)
{
   return((b<<16)|(g<<8)|r)
}

void _save_draw_setup(typeless &draw_setup)
{
   draw_setup=p_fill_style' 'p_draw_width' 'p_draw_style' 'p_draw_mode
}
void _restore_draw_setup(typeless draw_setup)
{
   parse draw_setup with fill_style draw_width draw_style draw_mode
   p_fill_style=fill_style
   p_draw_width=draw_width
   p_draw_style=draw_style
   p_draw_mode=draw_mode
}

static _str _event_handler(_str event)
{
   // inheritance is not check yet.
   if (p_eventtab) {
      index=eventtab_index(p_eventtab,p_eventtab,event2index(event))
      if (index) {
         return(index)
      }
   }
   if (p_eventtab2) {
      index=eventtab_index(p_eventtab2,p_eventtab2,event2index(event))
      if (index) {
         return(index)
      }
   }
   wid=p_active_form
   if (wid.p_eventtab) {
      index=eventtab_index(wid.p_eventtab,wid.p_eventtab,event2index(event))
      if (index) {
         return(index)
      }
   }
   return(0)
}
//  This function is called when the editor doing a refresh and
//  about to set focus to a disabled window.  This function should
//  try to tab to the next control in the form or reenable forms.
_on_disabled()
{
   wid=p_active_form;
   if (wid==_mdi || wid==_cmdline ||wid.p_mdi_child) {
      form_disabled= !_mdi.p_enabled;
      _mdi.p_enabled=1;_mdi.p_visible=1;
      first_wid=wid=_mdi.p_child;
      for (;;) {
         if (wid.p_enabled==0
             // (wid.p_visible==1 && (wid.p_window_flags & HIDE_WINDOW_OVERLAP))
             ) {
             form_disabled=1;
             wid.p_enabled=1;
             // Don't want to make mdi windows visible since windows seems to
             // to get confused.  In addition, in the future there may be user
             // defined hidden windows.
             //wid.p_visible=1;
         }
         wid=wid.p_next;
         if (wid==first_wid) break;
      }
      if (form_disabled) {
         _message_box("A macro has incorrectly disabled a form or died while a form was invisible.  The form has been enabled and made visible.")
      }
      return('');
   }
   if (!wid.p_visible || !wid.p_enabled) {
      _mdi.p_enabled=1;_mdi.p_visible=1;
      wid.p_enabled=1;wid.p_visible=1;
      _message_box("A macro has incorrectly disabled a form or died while a form was invisible.  The form has been enabled and made visible.")
   }
   _next_control()
}
// returns window id of form if a form window exists with the form name given.
_find_formobj(form_name,...)
{
   option=upcase(arg(2));
   if (arg()>=3) {
      i=arg(3);
      if (_iswindow_valid(i) && i.p_object==OI_FORM &&
           (option=='' || (option=='E' && i.p_edit) ||
                   (option=='N' && !i.p_edit)
           )
         ) {
         if (name_eq(i.p_name,form_name)) {
            return(i);
         }
      }

   }
   last=_last_window_id()
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) && i.p_object==OI_FORM &&
           (option=='' || (option=='E' && i.p_edit) ||
                   (option=='N' && !i.p_edit)
           )
         ) {
         if (name_eq(i.p_name,form_name)) {
            if (arg()>=3) {
               arg(3)=i;
            }
            return(i)
         }
      }
   }
   return(0)
}
_find_object(name)
{
   parse name with form_name '.' ctl_name
   wid=_find_formobj(form_name,arg(2))
   if (!wid || ctl_name=='') {
      return(wid);
   }
   return(wid._find_control(ctl_name))
}
#if 0
_str _dmvalidate2(wid)
{
   if (wid.p_object==OI_TEXT_BOX || wid.p_object==OI_COMBO_BOX) {
      switch (wid.p_validate_style) {
      case VS_INTEGER:
         if (!isinteger(wid.p_text)) {
            return(wid);
         }
         break;
      }
   }
   return(0);
}
_dmvalidate()
{
   wid=_for_each_control(p_active_form,'_dmvalidate2')
   if (!wid) {
      return(0);
   }
   //p_window_id=wid;refresh();
   switch (wid.p_validate_style) {
   case VS_INTEGER:
      if (!isinteger(wid.p_text)) {
         _message_box("Invalid integer")
      }
      break;
   }
   p_window_id=wid;refresh();

}
#endif

static int _morelargest
_str _dmmorelargest(wid)
{
   if (wid.p_object==OI_FORM) {
      return(0)
   }
   if (lowcase(arg(2))=='h') {
      x=wid.p_x+wid.p_width
      if (x>_morelargest) {
         _morelargest=x;
      }
   } else {
      y=wid.p_y+wid.p_height
      if (y>_morelargest) {
         _morelargest=y;
      }
   }
   return(0);
}
#define MORE_V_PAD 80
#define MORE_H_PAD 140

void _dmmore(...)
{
   _morelargest=0;
   form_wid=p_active_form;
   _for_each_control(form_wid,'_dmmorelargest','H',arg(1))
   if (lowcase(arg(1))=='h') {
      pad=_lx2lx(SM_TWIP,form_wid.p_xyscale_mode,MORE_H_PAD)
      if (arg(2)!='') pad=arg(2);
      cx=form_wid.p_width-_dx2lx(form_wid.p_xyscale_mode,form_wid.p_client_width);
      form_wid.p_width=_morelargest+cx+pad;
   } else {
      pad=_ly2ly(SM_TWIP,form_wid.p_xyscale_mode,MORE_V_PAD)
      if (arg(2)!='') pad=arg(2);
      cy=form_wid.p_height-_dy2ly(form_wid.p_xyscale_mode,form_wid.p_client_height);
      form_wid.p_height=_morelargest+cy+pad;
   }
   parse p_caption with before '>>|<<','r'
   p_caption=strip(before)' <<'
   p_active_form._show_entire_form();
}
void _dmless(...)
{
   form_wid=_get_form(p_window_id)
   if (lowcase(arg(1))=='h') {
      pad=_lx2lx(SM_TWIP,form_wid.p_xyscale_mode,MORE_H_PAD)
      if (arg(2)!='') pad=arg(2);
      cx=form_wid.p_width-_dx2lx(form_wid.p_xyscale_mode,form_wid.p_client_width);
      form_wid.p_width=p_x+p_width+cx+pad;
   } else {
      pad=_ly2ly(SM_TWIP,form_wid.p_xyscale_mode,MORE_V_PAD)
      if (arg(2)!='') pad=arg(2);
      cy=form_wid.p_height-_dy2ly(form_wid.p_xyscale_mode,form_wid.p_client_height);
      form_wid.p_height=p_y+p_height+cy+pad;
   }
   parse p_caption with before '>>|<<','r'
   p_caption=strip(before)' >>'
}
void _dmmoreless()
{
   if (pos('>>',p_caption)) {
      _dmmore(arg(1),arg(2));
   } else {
      _dmless(arg(1),arg(2));
   }
}
void _save_form_xy()
{
   form_name=p_name;x=p_x;y=p_y;width=p_width;height=p_height;
   width='';height='';
   if( p_border_style==BDS_SIZABLE ) {
      width=p_width;
      height=p_height;
   }
   get_view_id view_id
   activate_view RETRIEVE_VIEW_ID
   _save_pos2(p)
   bottom();
   status=search('^\@xy 'form_name'\:','-ri@')
   if (status) {
      insert_line '@xy 'form_name':'x' 'y' 'width' 'height
   } else {
      replace_line '@xy 'form_name':'x' 'y' 'width' 'height
   }
   _restore_pos2(p)
   activate_view view_id
}
_restore_form_xy()
{
   form_name=p_name;x=p_x;y=p_y;
   get_view_id view_id
   activate_view RETRIEVE_VIEW_ID
   save_pos(p)
   bottom();
   status=search('^\@xy 'form_name'\:','-ri@')
   if (!status) {
      get_line line
      parse line with ':'x y w h;
   }
   restore_pos(p)
   activate_view view_id
   if (!status) {
      _get_window(junk,junk,width,height);
      if( p_border_style==BDS_SIZABLE && isinteger(w) && isinteger(h) ) {
         width=w;
         height=h;
         _lxy2dxy(p_xyscale_mode,width,height);
         if (width>_screen_width()) width=_screen_width();
         if (height>_screen_height()) height=_screen_height();
         _dxy2lxy(p_xyscale_mode,width,height);
      }
      _move_window(x,y,width,height);
   }
   return(status);
}
#if 0
_isparent_control()
{
   switch (p_object) {
   case OI_PICTURE_BOX:
   case OI_FRAME:
   case OI_FORM:
      return(1);
   }
   return(0);
}
#endif
_get_form(wid)
{
   while(wid.p_parent && wid.p_object!=OI_FORM && wid.p_object!=OI_MDI_FORM){
      wid=wid.p_parent
   }
   return(wid)
}
_enabled()
{
   wid=p_window_id
   for (;;) {
      if (!wid.p_enabled || !wid.p_visible) {
         return(0)
      }
      if (!wid.p_parent || wid.p_object==OI_FORM ||
           wid.p_object==OI_MDI_FORM) {
         return(1)
      }
      wid=wid.p_parent
   }
}

_set_value(value)
{
   p_value=value;
   if (p_object==OI_GAUGE) {
      call_event(p_window_id,ON_CHANGE);
   } else {
      call_event(p_window_id,LBUTTON_UP);
   }
}

_str _enable_non_modal_forms(boolean value,int skip_wid)
{
   if (value) {
      wid_list=arg(3)
      for (;;) {
         parse wid_list with wid wid_list
         if (wid=='') return('');
         if (wid!=skip_wid && _iswindow_valid(wid) && (wid.p_object==OI_FORM || wid.p_object==OI_MDI_FORM) && !wid.p_enabled &&
             !wid.p_edit && !wid.p_modal && !wid.p_mdi_child && !wid.p_isbutton_bar
            ) {
            wid.p_enabled=1;
         }
      }
   }
   last=_last_window_id()
   //option=upcase(arg(2))
   wid_list='';
   for (i=1;i<=last;++i) {
      if (i!=skip_wid && _iswindow_valid(i) && (i.p_object==OI_FORM || i.p_object==OI_MDI_FORM) && i.p_enabled &&
          !i.p_edit&& !i.p_modal && !i.p_mdi_child && !i.p_isbutton_bar
         ) {
         i.p_enabled=0;
         wid_list=wid_list' 'i
      }
   }
   return(wid_list)

}
_left_width()
{
   buf_wid=p_window_id;
   buf_x= buf_wid.p_x;
   buf_y= buf_wid.p_y;
   _map_xy(buf_wid.p_xyparent,0,buf_x,buf_y,buf_wid.p_xyscale_mode);
   client_x=client_y=0;
   _map_xy(buf_wid,0,client_x,client_y,buf_wid.p_xyscale_mode);
   left_border_width=client_x-buf_x;
   return(left_border_width);
}
_top_height()
{
   buf_wid=p_window_id;
   buf_x= buf_wid.p_x;
   buf_y= buf_wid.p_y;
   _map_xy(buf_wid.p_xyparent,0,buf_x,buf_y,buf_wid.p_xyscale_mode);
   client_x=client_y=0;
   _map_xy(buf_wid,0,client_x,client_y,buf_wid.p_xyscale_mode);
   caption_height=client_y-buf_y;
   return(caption_height);
}
_bottom_height()
{
   buf_wid=p_window_id;
   border_height=_ly2dy(p_xyscale_mode,p_height)-p_client_height;
   return(_dy2ly(p_xyscale_mode,border_height)-_top_height());
}

