/*
$VerboseHistory: fortran.e$
*/
/*
  To install this package, perform the following steps.

    -  Load this macro module with LOAD command.  The ST.EXE
       compiler will automatically get invoked if necessary.
    -  Save the configuration. {CONFIG,Save configuration...}

  Options for FORTRAN syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             Keyword case.  Values may be 0,1, or 2 which correspond
                     to lower case, upper case, and capitalized.  Default
                     is 0.
       3             reserved.
       4             reserved
       5             Multi-line if expansion.  Defaults to 0.

*/
#include 'slick.sh'
static _str word_case(s)
{
   parse name_info(p_index) with . . . scase .
   if ( scase==0 ) {
      return(lowcase(s)) /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s))    /* Upper case language key words. */
   }
   return(upcase(substr(s,1,1)):+lowcase(substr(s,2)))  /* Capitalize */
}
#define MODE_NAME 'Fortran'
#define EXTENSION 'for'

defload()
{
   setup_info='MN='MODE_NAME',TABS=1 7 250 +3,MA=1 74 1,':+
              'KEYTAB='MODE_NAME'-keys,WW=1,IWT=0,ST=0,';
   compile_info='400 lp77 *';
   syntax_info='3 1 1 0 0 1 0';
   be_info='';
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info);
   if ( kt_index ) {
      set_eventtab_index kt_index,event2index(name2event('tab')),
                 find_index('for-tab',COMMAND_TYPE);
      set_eventtab_index kt_index,event2index(name2event('s-tab')),
                 find_index('for-backtab',COMMAND_TYPE);
   }
   create_ext(kt_index,'f',EXTENSION);
}
_command fortran_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode(EXTENSION);
}
_command fortran_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         fortran_expand_enter(p_SyntaxIndent) ) {
      call_root_key(ENTER)
   } else if (_argument=='') {
      _undo 'S'
   }

}
_command fortran_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . . . multi_line_if .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      fortran_expand_space(multi_line_if) ) {
      if ( command_state() ) {
         call_root_key(' ')
      } else {
         keyin ' '
      }
   } else if (_argument=='') {
      _undo 'S'
   }

}
#define ENTER_WORDS ' do if else '
#define ENTER_WORDS2 ''
#define EXPAND_WORDS ' continue else return '

static _str space_words[]={'continue','else','if','program','return','subroutine'};

/* Returns non-zero number if fall through to enter key required */
static _str fortran_expand_enter(syntax_indent)
{
   get_line line
   i=verify(line,'0123456789')  /* Skip the linenumbers */
   if ( ! i ) {
      i=7
   }
   parse substr(line,i) with orig_first_word rest
   first_word=lowcase(orig_first_word)
   if ( (pos(' 'first_word' ',ENTER_WORDS) || pos(' 'first_word' ',ENTER_WORDS2)) &&
       (first_word!='if' || pos('then',line,1,'i')) ) {
      old_col=p_col;
      p_col=verify(line,' ','',i)
      tab
      new_col=p_col;p_col=old_col
      indent_on_enter(syntax_indent)
   } else {
      if ( first_word!='' ) {
         new_col=verify(line,' ','',i)
      } else {
         if ( i<7 ) {
            i=7
         }
         new_col=i
      }
      call_root_key(ENTER)
   }
   get_line next_line
   if ( p_col<new_col ) {
      diff=new_col-p_col
      if ( next_line!='' ) {
         replace_line substr('',1,diff):+next_line
      }
      p_col=p_col+diff
   }
   return(0)

}
static _str fortran_expand_space(multi_line_if)
{
   status=0
   get_line line
   line=strip(line,'T')
   i=verify(line,'0123456789')  /* Skip the linenumbers */
   if ( ! i ) {
      return(1)
   }
   orig_word=lowcase(strip(substr(line,i)))
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='' ) return(1);
   /* Grab line number with blanks. */
   linenum_space=substr(line,1,verify(line,' '\t,'',i)-1)
   leading_space=indent_string(length(expand_tabs(linenum_space)))
   if ( word=='if' ) {
      if ( multi_line_if ) {
         replace_line linenum_space:+word_case('if () then')
         insert_line leading_space:+word_case('endif')
         up;_end_line;p_col=p_col-6
      } else {
         replace_line linenum_space:+word_case('if () ')
         _end_line;p_col=p_col-2
      }
      if ( ! _insert_state() ) { _insert_toggle }
   } else if ( word=='program' ) {
      replace_line linenum_space:+word_case('program ')
      insert_line leading_space:+word_case('end')
      up;_end_line
   } else if ( word=='subroutine' ) {
      replace_line linenum_space:+word_case('subroutine ')
      insert_line leading_space:+word_case('end')
      up;_end_line
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line linenum_space:+word_case(word' ')
      _end_line
   } else {
      status=1
   }
   return status

}
static _str strip_comment(line)
{
   if ( pos(substr(line,1,1),'Cc*') ) {
      return('')
   }
   i=pos('!',line)
   if ( text_col(line,i,'I')!=6 ) {
      parse line with line '!'  /* LP77 extension */
   }
   return(line)

}
#define LINE_PREFIX_RE '^[0-9 \t][ \t]*(:d)*[ \t]*'
#define NAME_RE '{[A-Za-z][ A-Za-z0-9$_]*[A-Za-z0-9$_]}'
#define PROC_RE (LINE_PREFIX_RE'[~!]*(subroutine|function|program) *\c'NAME_RE' *(\(|$|!|    )')

_str for_proc_search(var proc_name,find_first)
{
   if ( find_first ) {
      status=search('(subroutine|function|program)','@riw');
   } else {
      status=repeat_search();
   }
   for (;;) {
      if ( status ) {
         return(status)
      }
      get_line(line);
      if ( pos(PROC_RE,line,1,'ri') ) {
         ret_proc_name=stranslate(substr(line,pos('S0'),pos('0')),'',' ')
         if ( proc_name=='' ) {
            proc_name=ret_proc_name;
         } else if ( !stricmp(proc_name,ret_proc_name) ) {
            status=repeat_search();
            continue
         }
         return(0)
      } else {
         status=repeat_search();
      }
   }
}

/*
  if then
  endif
  $if
  $endif
  do 10
10  continue
  do while
  end do
*/
/* Code for Layhey fortran support */
#if 0 //__PCDOS__
_str
   _error_search
   ,_error_parse
   ,_error_re
   ,_error_re2

void for_parse_error(var filename,var line,var col,var err_msg)
{
   col=7
   get_line orig_line
   parse_error(filename,line,junk,line_text)
   /* Check if error message is before 'File xyz.for, line    N:' */
   up
   if ( ! rc ) {
      get_line prev_line
      down
      parse prev_line with '(FATAL|WARNING) -','ri' err_msg
      if ( err_msg!='' ) {
         col=7
         return;
      }
   }
   search '^(([ \t]*\^)|((WARNING|FATAL) - @{?@}$))','ri'
   get_line col_line
   if ( last_char(col_line)=='^' ) {
      new_col=pos('^',col_line)-pos(':d\:',orig_line,1,'r')-2
      if ( ! rc && new_col>0 ) {
         col=new_col
      }
      search '(WARNING|FATAL) - @{?@}$','ri'
   }
   if ( rc ) {
      err_msg=''
   } else {
      err_msg=get_text(match_length('0'),match_length('S0'))
   }
   /* messageNwait('filename='filename' line='line' col='col' err_msg='err_msg) */

}
void for_init_error()
{
   _error_parse= find_index(EXTENSION'-parse-error',PROC_TYPE)
   _error_re='^(?*,|) *File {:p}, *line *{:i}{}(\:|.) @{?@}$'
   _error_re2=''
}
#endif

_command for_tab() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   index=_edit_window().p_index
   p_index=0
   call_root_key(TAB)
   _edit_window().p_index=index

}
_command for_backtab() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   index=_edit_window().p_index
   p_index=0
   call_root_key(S_TAB)
   _edit_window().p_index=index
}
