#include "slick.sh"
#include "sock.sh"
#include "ftp.sh"

#define FTPTOOLTAB_DIR (0)
#define FTPTOOLTAB_LOG (1)
static boolean gchangeprofile_allowed=true;
static boolean gchangeremotecwd_allowed=true;
defeventtab _tbproject_form;

// This expects the active window to be a combo box
static void _FillProfiles(boolean set_textbox)
{
   oldchangeprofile_allowed=gchangeprofile_allowed;
   gchangeprofile_allowed=false;
   p_cb_list_box._lbclear();
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      p_cb_list_box._lbadd_item(i);
   }
   if( p_cb_list_box.p_Noflines ) {
      p_cb_list_box._lbsort('AI');
      p_cb_list_box._lbselect_line();
      if( set_textbox ) {
         p_text=p_cb_list_box._lbget_seltext();
      }
   }
   gchangeprofile_allowed=oldchangeprofile_allowed;

   return;
}

static void oncreateFTPTab()
{
   // Current connections
   gchangeprofile_allowed=false;
   _ctl_profile.p_cb_list_box.p_scroll_bars=SB_BOTH;
   _ctl_profile.p_text="";
   _ctl_profile._FillProfiles(true);
   profile=_ctl_profile._retrieve_value();
   status=_ctl_profile.p_cb_list_box._lbsearch(profile);
   if( !status ) {
      _ctl_profile.p_text=profile;
   }
   gchangeprofile_allowed=true;
   
   // Remote session
   _ctl_remote_dir.p_multi_select=MS_EXTENDED;
   _ctl_remote_dir.p_visible=false;
   _ctl_remote_cwd.p_visible=false;
   _ctl_no_connection.p_visible=true;

   _ctl_operation.p_caption="";
   _ctl_nofbytes.p_caption="";
   
   // Horizontal scroll bars
   val=_retrieve_value("_tbproject_form._ctl_remote_dir.p_scroll_bars");
   if( !isinteger(val) || val<SB_NONE || val>SB_BOTH ) val=SB_BOTH;
   _ctl_remote_dir.p_scroll_bars= (int)val;
   if( (_ctl_remote_dir.p_scroll_bars)&SB_HORIZONTAL ) {
      _ctl_remote_dir.p_delay= -1;
   } else {
      _ctl_remote_dir.p_delay= 0;
   }
   
   return;
}

void _ctl_profile.on_create()
{
   oncreateFTPTab();

   _ctl_profile.call_event(CHANGE_SELECTED,_ctl_profile,ON_CHANGE,'W');

   return;
}

void _ctl_profile.on_destroy()
{
   // Remember the active profile
   _append_retrieve(_ctl_profile,_ctl_profile.p_text);
   
   // Remember horizontal scroll bar settings
   _append_retrieve(0,_ctl_remote_dir.p_scroll_bars,"_tbproject_form._ctl_remote_dir.p_scroll_bars");
   
   return;
}

void _ctl_profile.on_drop_down(reason)
{
   if( reason!=DROP_DOWN ) return;
   _FillProfiles(false);
}

// This expects the active window to be a combo box
static int _ChangeProfile(...)
{
   ftpConnProfile_t *fcp_p;

   oldchangeprofile_allowed=gchangeprofile_allowed;
   gchangeprofile_allowed=false;
   if( arg()>0 && arg(1)!="" ) {
      profile_name=arg(1);
   } else {
      // Get the profile in the text box
      profile_name=p_text;
   }

   if( profile_name=="" ) {
      // This should only happen when there are no connections
      if( !p_cb_list_box.p_Noflines ) _FillProfiles(false);
      if( p_cb_list_box.p_Noflines ) {
         p_cb_list_box._lbtop();
         profile_name=p_cb_list_box._lbget_text();
      }
      if( profile_name=="" ) {
         p_text="";
         gchangeprofile_allowed=oldchangeprofile_allowed;
         return(0);
      }
   }

   //messageNwait(_ftpCurrentConnections._isempty()'  '_ftpCurrentConnections._indexin(profile_name));
   //messageNwait('profile_name='profile_name);
   if( !_ftpCurrentConnections._indexin(profile_name) ) {
      // Remove this profile from the combo box
      _FillProfiles(false);
      p_cb_list_box._lbtop();
      p_cb_list_box._lbselect_line();
      p_text=p_cb_list_box._lbget_seltext();
      profile_name=p_text;
   } else {
      // Always find the profile name in case the user just opened a new connection
      status=p_cb_list_box._lbsearch(profile_name,'i');
      if( status ) {
         // This normally happens when user connects with "Connect..." button
         _FillProfiles(false);
         p_cb_list_box._lbsearch(profile_name,'i');
      }
      p_cb_list_box._lbselect_line();
      p_text=p_cb_list_box._lbget_seltext();
   }
   fcp_p=_ftpCurrentConnections._indexin(profile_name);
   if( fcp_p ) {
      formWid=_find_object("_tbproject_form","N");
      asciiWid=formWid._find_control("_ctl_ascii");
      binWid=formWid._find_control("_ctl_binary");
      if( asciiWid && binWid ) {
         switch( fcp_p->XferType ) {
         case FTPXFER_ASCII:
            asciiWid.p_value=1;
            asciiWid.call_event(asciiWid,LBUTTON_UP,'W');
            break;
         case FTPXFER_BINARY:
            binWid.p_value=1;
            binWid.call_event(binWid,LBUTTON_UP,'W');
            break;
         default:
            // This should never happen
            asciiWid.p_value=0;
            binWid.p_value=0;
         }
      }

      if( fcp_p->LogBufName=="" ) {
         _message_box('Warning:  Forced to create a log for profile "':+profile_name:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         log_buf_name=_ftpCreateLogBuffer();
         if( log_buf_name=="" ) {
            // _ftpCreateLogBuffer() will take care of error messages to user
            gchangeprofile_allowed=oldchangeprofile_allowed;
            return(1);
         }
         fcp_p->LogBufName=log_buf_name;
         _ftpLog(fcp_p,"*** Log started on ":+_date():+" at ":+_time('M'));
      }
   }
   gchangeprofile_allowed=oldchangeprofile_allowed;

   return(0);
}

/* This expects the active window to be a tree view.
 * Sets up column widths in the directory listing.
 */
//#define isvalid_field_width(w) (isinteger(w) && w>0)
#define FTPDIR_FIELDGAP (300)
static void _RefreshDirFields()
{
   if( _TreeGetDepth(TREE_ROOT_INDEX) ) return;   // Nothing to process

   #if 0
   nofargs=arg();
   if( nofargs>0 && isvalid_dirfield_width(arg(1)) ) filename_width=arg(1);
   if( nofargs>1 && isvalid_dirfield_width(arg(2)) ) size_width=arg(2);
   if( nofargs>2 && isvalid_dirfield_width(arg(3)) ) date_width=arg(3);
   if( nofargs>3 && isvalid_dirfield_width(arg(4)) ) time_width=arg(4);
   if( nofargs>4 && isvalid_dirfield_width(arg(5)) ) attribs_width=arg(5);
   #endif

   filename_width=size_width=date_width=time_width=attribs_width=0;
   idx=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   for(;;) {
      caption=_TreeGetCaption(idx);
      parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;

      // Find the longest widths for each field in the tree
      width=_text_width(filename);
      if( width>filename_width ) filename_width=width;
      width=_text_width(size);
      if( width>size_width ) size_width=width;
      width=_text_width(date);
      if( width>date_width ) date_width=width;
      width=_text_width(time);
      if( width>time_width ) time_width=width;
      width=_text_width(attribs);
      if( width>attribs_width ) attribs_width=width;

      idx=_TreeGetNextSiblingIndex(idx);
      if(idx<0) break;
   }

   _col_width(0,filename_width+FTPDIR_FIELDGAP);
   _col_width(1,size_width+FTPDIR_FIELDGAP);
   _col_width(2,date_width+FTPDIR_FIELDGAP);
   _col_width(3,time_width+FTPDIR_FIELDGAP);
   _col_width(4,attribs_width+FTPDIR_FIELDGAP);

   return;
}

/* This expects the active window to be a tree view.
 * If force is true then it forces this function to get a new directory
 * listing even if there is already one present for this connection.
 */
static int _RefreshDir(ftpConnProfile_t *fcp_p)
{
   ftpFile_t files[];

   if( !fcp_p ) return(1);

   // Fill in the file list
   _TreeDelete(TREE_ROOT_INDEX,"C");   // Clear the tree out
   files=fcp_p->RemoteDir.files;
   filename_width=size_width=date_width=time_width=attribs_width=0;
   for( i=0;i<files._length();++i ) {
      if( files[i].filename=="." || files[i].filename==".." ) {
         continue;
      }
      picidx=_pic_ftpfile;
      type=files[i].type;
      if( type&FTPFILETYPE_DIR ) {
         if( type&FTPFILETYPE_LINK ) {
            picidx=_pic_ftplfol;
         } else {
            picidx=_pic_ftpfold;
         }
      } else if( type&FTPFILETYPE_LINK ) {
         picidx=_pic_ftplfil;
      }
      filename=files[i].filename;
      size=files[i].size
      date=files[i].month' 'files[i].day' 'files[i].year;
      time=files[i].time;
      attribs=files[i].attribs;
      caption=filename"\t"size"\t"date"\t"time"\t"attribs;
      idx=_TreeAddItem(TREE_ROOT_INDEX,caption,TREE_ADD_AS_CHILD,picidx,picidx,-1,0);
      _TreeSetUserInfo(idx,"");
      if( type&FTPFILETYPE_DIR ) {
         // Directory name
         info="D";
         if( type&FTPFILETYPE_LINK ) info=info:+"L";
         _TreeSetUserInfo(idx,info);   // Use this for primary/secondary sort on directories/files
      } else {
         // File name
         _TreeSetUserInfo(idx,"F");   // Use this for primary/secondary sort on directories/files
      }
   }
   _TreeSortUserInfo(TREE_ROOT_INDEX,"","FE");   // Primary sort directories / secondary sort filenames
   idx=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   if( idx<0 ) {
      // No children, just add ".."
      _TreeAddItem(TREE_ROOT_INDEX,"..",TREE_ADD_AS_CHILD,_pic_ftpcdup,_pic_ftpcdup,-1,0);   // Add the up-one-level ".."
   } else {
      _TreeAddItem(idx,"..",TREE_ADD_BEFORE,_pic_ftpcdup,_pic_ftpcdup,-1,0);
   }
   _RefreshDirFields();
   _TreeTop();

   return(0);
}

static ftpConnProfile_t *GetCurrentConnProfile()
{
   ftpConnProfile_t *fcp_p;

   fcp_p=0;
   profile=_ctl_profile.p_text;
   if( profile!="" && !_ftpCurrentConnections._isempty() && _ftpCurrentConnections._indexin(profile) ) {
      fcp_p=_ftpCurrentConnections._indexin(profile);
   }

   return(fcp_p);
}

void _ftpopenProgressCB(_str operation,int nofbytes,int total_nofbytes)
{
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   operationWid=formWid._find_control("_ctl_operation");
   nofbytesWid=formWid._find_control("_ctl_nofbytes");
   //say('operation='operation'  nofbytes='nofbytes'  total_nofbytes='total_nofbytes);
   if( operationWid ) {
      operationWid.p_caption=operation;
   }
   if( nofbytes==total_nofbytes ) {
      if( nofbytesWid ) {
         nofbytesWid.p_caption="Complete";
      }
   } else if( nofbytes>=0 && total_nofbytes>0 && nofbytes<=total_nofbytes ) {
      if( nofbytesWid ) {
         nofbytesWid.p_caption=nofbytes:+' / ':+total_nofbytes:+' bytes';
      }
   } else {
      if( nofbytesWid ) {
         nofbytesWid.p_caption=nofbytes:+" bytes";
      }
   }
   
   return;
}

void _ftpopenProgressDlgCB(_str operation,int nofbytes,int total_nofbytes)
{
   _ftpopenProgressCB(operation,nofbytes,total_nofbytes);
   
   formWid=_find_object("_ftpProgress_form","N");
   if( !formWid ) return;
   formWid.p_caption=operation;
   progressWid=formWid._find_control("_ctl_progress");
   nofbytesWid=formWid._find_control("_ctl_nofbytes");
   if( nofbytes==total_nofbytes ) {
      if( progressWid ) {
         progressWid.p_value=100;
      }
      if( nofbytesWid ) {
         nofbytesWid.p_caption="Complete";
      }
   } else if( nofbytes>=0 && total_nofbytes>0 && nofbytes<=total_nofbytes ) {
      if( progressWid ) {
         int val;
         val= (int)(100*nofbytes/total_nofbytes);
         progressWid.p_value=val;
      }
      if( nofbytesWid ) {
         nofbytes_text=nofbytes;
         if( nofbytes>1024 ) {
            nofbytes_text= nofbytes/1024;
            nofbytes_text=nofbytes_text:+"K";
         }
         if( total_nofbytes>1024 ) {
            total_nofbytes_text= total_nofbytes/1024;
            total_nofbytes_text=total_nofbytes_text:+"K";
         }
         nofbytesWid.p_caption=nofbytes_text:+" / ":+total_nofbytes_text;
      }
   } else {
      if( progressWid ) {
         progressWid.p_value=0;
      }
      if( nofbytesWid ) {
         nofbytesWid.p_caption=nofbytes:+" bytes";
      }
   }
   
   return;
}

void __ftpopenUpdateSessionCB(...)
{
   ftpQEvent_t event;
   RecvCmd_t rcmd;
   ftpConnProfile_t fcp;
   ftpConnProfile_t *fcp_p;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;

   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   if( event.event==QE_PWD ) {
      /* We just printed the current working directory.
       * Now we must list its contents.
       */
       
      /*
      typedef struct RecvCmd_s {
         boolean pasv;
         _str cmdargv[];
         _str dest;
         _str datahost;
         _str dataport;
         int  size;
         pfnProgressCallback_tp ProgressCB;
      } RecvCmd_t;
      */
      fcp.PostedCB=__ftpopenUpdateSessionCB;
      pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv );
      rcmd.pasv=pasv;
      cmdargv._makeempty();
      cmdargv[0]="LIST";
      if( fcp.ResolveLinks ) {
         cmdargv[cmdargv._length()]="-L";
      }
      rcmd.cmdargv=cmdargv;
      dest=mktemp();
      if( dest=="" ) {
         msg="Unable to create temp file for remote directory listing";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
      rcmd.dest=dest;
      datahost=dataport="";
      size=0;
      fcp.XferType=FTPXFER_ASCII;   // Always transfer listings ASCII
      rcmd.ProgressCB=_ftpopenProgressCB;
      _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
      return;
   }
   
   /* We just listed the contents of the current working directory.
    * Now stick it in the remote tree view.
    */
   rcmd= (RecvCmd_t)event.info[0];
   status=_ftpCreateDir(&fcp,rcmd.dest);
   if( _ftpdebug&FTPDEBUG_SAVE_LIST ) {
      // Make a copy of the raw listing
      copy_file(rcmd.dest,'$list');
   }
   status2=delete_file(rcmd.dest);
   if( status2 && status2!=FILE_NOT_FOUND_RC && status2!=PATH_NOT_FOUND_RC ) {
      msg='Warning: Could not delete temp file "':+rcmd.dest:+'".  ':+_ftpGetMessage(status2);
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
   }
   if( status ) return;
   
   /* Find the matching connection profile in current connections
    * so we can update its stored remote directory listing.
    */
   fcp_p=0;
   for( i._makeempty();; ) {
      _ftpCurrentConnections._nextel(i);
      if( i._isempty() ) break;
      currentconn=_ftpCurrentConnections:[i];
      if( _ftpCurrentConnections:[i].ProfileName==fcp.ProfileName &&
          _ftpCurrentConnections:[i].Instance==fcp.Instance ) {
         // Found it
         fcp_p= &(_ftpCurrentConnections:[i]);
         break;
      }
   }
   if( !fcp_p ) {
      // We didn't find the matching connection profile, so bail out
      return;
   }
   fcp_p->RemoteDir=fcp.RemoteDir;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) {
      // This should never happen
      return;
   }
   remotecwdWid=formWid._find_control("_ctl_remote_cwd");
   if( !remotecwdWid ) return;
   noconnWid=formWid._find_control("_ctl_no_connection");
   if( !noconnWid ) return;
   
   if( !remoteWid._RefreshDir(fcp_p) ) {
      remoteWid.p_visible=true;
      remotecwdWid.p_visible=true;
      cwd=fcp_p->RemoteCWD;
      gchangeremotecwd_allowed=false;
      _ftpAddCwdHist(fcp_p->CwdHist,cwd);
      remotecwdWid.p_text=cwd;
      gchangeremotecwd_allowed=true;
   }
   noconnWid.p_visible= !remoteWid.p_visible;

   _MaybeUpdateFTPClient(profileWid.p_text);

   return;
}

/* Attach the current connection profile's directory listing, log buffer,etc.
 * Note: force=true means force a refresh of the current connection
 */
static void _UpdateSession(boolean force)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      
      if( force || fcp_p->RemoteDir._isempty() ) {
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpopenUpdateSessionCB;
         _ftpEnQ(QE_PWD,QS_BEGIN,0,&fcp);
         return;
      }

      // Update the remote current working directory list
      if( !_ctl_remote_dir._RefreshDir(fcp_p) ) {
         _ctl_remote_dir.p_visible=true;
         _ctl_remote_cwd.p_visible=true;
         cwd=fcp_p->RemoteCWD;
         gchangeremotecwd_allowed=false;
         _ftpAddCwdHist(fcp_p->CwdHist,cwd);
         _ctl_remote_cwd.p_text=cwd;
         gchangeremotecwd_allowed=true;
      }
      _ctl_no_connection.p_visible= !_ctl_remote_dir.p_visible;
      return;
   } else {
      _ctl_remote_dir.p_visible=false;
      _ctl_remote_cwd.p_visible=false;
      _ctl_no_connection.p_visible=true;
   }

   _MaybeUpdateFTPClient(_ctl_profile.p_text);
   
   return;
}

void _ctl_profile.on_change(int reason)
{
   boolean force;
   
   if( !gchangeprofile_allowed ) return;

   force= (arg(2)!="" && arg(2));
   _ctl_profile._ChangeProfile()
   /* Remember current profile.
    * Must do this here because exiting the editor does not call a control's
    * ON_DESTROY event.
    */
   _append_retrieve(_ctl_profile,_ctl_profile.p_text);
   _ctl_profile._UpdateSession(force);

   return;
}

void __ftpopenConnectCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   int formWid;
   int profileWid,operationWid,nofbytesWid;
   _str CwdHist[];

   event= *((ftpQEvent_t *)(arg(1)));

   formWid=_find_object("_tbproject_form","N");
   if( formWid ) {
      profileWid=formWid._find_control("_ctl_profile");
      operationWid=formWid._find_control("_ctl_operation");
      nofbytesWid=formWid._find_control("_ctl_nofbytes");
   }
   fcp=event.fcp;
   
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      if( event.event!=QE_CWD && event.event!=QE_PWD && event.event!=QE_SYST ) {
         operationWid.p_caption="";
         nofbytesWid.p_caption="";
         return;
      }
      /* The only thing that failed is:
       *   Changing directory, so use '/'
       *   OR
       *   Issuing the SYST command to get the operating system name
       */
      if( event.event==QE_CWD || event.event==QE_PWD ) {
         fcp.RemoteCWD="/";
      }
   }
   
   if( event.event==QE_CWD || event.event==QE_PWD ) {
      // Still need to get operating system name
      fcp.PostedCB=__ftpopenConnectCB;
      _ftpEnQ(QE_SYST,QS_BEGIN,0,&fcp);
      return;
   }
      
   _ftpGetCwdHist(fcp.ProfileName,CwdHist);
   fcp.CwdHist=CwdHist;
   _ftpAddCurrentConnProfile(&fcp,htindex);

   if( !formWid ) {
      /* This could happen if user closes Project toolbar in the middle
       * of the connection attempt.
       */
      return;
   }
   profileWid._FillProfiles(true);
   profileWid._ChangeProfile(htindex);
   formWid._UpdateSession(true);
   
   operationWid.p_caption="Connected";
   nofbytesWid.p_caption="";
   
   return;
}

void _ctl_connect.lbutton_up()
{
   ftpConnProfile_t fcp;

   fcp._makeempty();
   status=show("-modal _ftpProfileManager_form",&fcp);
   if( status ) {
      return;
   }

   _ctl_operation.p_caption="Connecting...";
   _ctl_nofbytes.p_caption="";
   fcp.PostedCB= __ftpopenConnectCB;
   _ftpEnQ(QE_START_CONN_PROFILE,QS_BEGIN,0,&fcp);
   
   return;
}

void __ftpopenDisconnectCB(...)
{
   ftpQEvent_t event;

   event= *((ftpQEvent_t *)(arg(1)));

   _ftpDeleteLogBuffer(&event.fcp);   // Paranoid
   _ftpRemoveCurrentConnProfile(&event.fcp);
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) {
      /* This could happen if user closes Project toolbar in the middle
       * of the connection attempt.
       */
      return;
   }
   
   formWid._ctl_profile._FillProfiles(true);
   formWid._ctl_profile._ChangeProfile();

   if( formWid._ctl_profile.p_text=="" ) {
      // No more connections, so leave a final message
      formWid._ctl_operation.p_caption="Disconnected";
      formWid._ctl_nofbytes.p_caption="";
   } else {
      formWid._ctl_operation.p_caption="";
      formWid._ctl_nofbytes.p_caption="";
   }
   
   formWid._ctl_profile._UpdateSession(false);
   
   return;
}

void _ctl_disconnect.lbutton_up()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      _ftpSaveCwdHist(fcp_p->ProfileName,fcp_p->CwdHist);
      _ctl_operation.p_caption="Disconnecting...";
      _ctl_nofbytes.p_caption="";
      fcp_p->PostedCB= __ftpopenDisconnectCB;
      _ftpEnQ(QE_END_CONN_PROFILE,QS_BEGIN,0,fcp_p);
      return;
   }
   _ctl_profile._ChangeProfile();
   _ctl_profile._UpdateSession(false);
   
   return;
}

static void _UpdateFTPClientXferType()
{
   ftpConnProfile_t *fcp_p;
   int formWid;
   int asciiWid;
   int binWid;
   int xfer_type;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   profileWid=formWid._find_control("_ctl_profile");
   if( !profileWid ) return;
   thisprofile=profileWid.p_text;
   
   formWid=_find_object("_tbFTPClient_form","N");
   if( !formWid ) return;
   profileWid=formWid._find_control("_ctl_profile");
   if( !profileWid ) return;
   
   if( thisprofile!=profileWid.p_text ) return;
   
   xfer_type=fcp_p->XferType;   // This had better match what is displayed
   
   asciiWid=formWid._find_control("_ctl_ascii");
   if( !asciiWid ) return;   // This should never happen
   binWid=formWid._find_control("_ctl_binary");
   if( !binWid ) return;   // This should never happen
   asciiWid.p_value=binWid.p_value=0;
   if( xfer_type==FTPXFER_ASCII ) {
      asciiWid.p_value=1;
      binWid.p_value=0;
   } else if( xfer_type==FTPXFER_BINARY ) {
      asciiWid.p_value=0;
      binWid.p_value=1;
   }
   
   return;
}

void _ctl_ascii.lbutton_up()
{
   ftpConnProfile_t *fcp_p;

   // Both ASCII and Binary cannot be on at the same time
   _ctl_binary.p_value= (int)(p_value==0);

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      if( p_value ) {
         fcp_p->XferType=FTPXFER_ASCII;
      } else {
         fcp_p->XferType=FTPXFER_BINARY;
      }
   }
   
   _UpdateFTPClientXferType();

   return;
}

void _ctl_binary.lbutton_up()
{
   ftpConnProfile_t *fcp_p;

   // Both ASCII and Binary cannot be on at the same time
   _ctl_ascii.p_value= (int)(p_value==0);

   fcp_p=GetCurrentConnProfile();
   if( fcp_p ) {
      if( p_value ) {
         fcp_p->XferType=FTPXFER_BINARY;
      } else {
         fcp_p->XferType=FTPXFER_ASCII;
      }
   }

   _UpdateFTPClientXferType();
   
   return;
}

void __ftpopenAbortCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state!=QS_ERROR ) {
      formWid=_find_object("_tbproject_form","N");
      if( !formWid ) return;
      operationWid=formWid._find_control("_ctl_operation");
      if( !operationWid ) return;
      nofbytesWid=formWid._find_control("_ctl_nofbytes");
      if( !nofbytesWid ) return;
      operationWid.p_caption="Aborted";
      nofbytesWid.p_caption="";
   }

   return;
}

void _ctl_abort.lbutton_up()
{
   ftpQEvent_t event;
   
   if( _ftpQ._length()<1 ) return;
   event=_ftpQ[0];
   
   /* Find all events in the queue that match this one and delete them.
    */
   for( i=0;i<_ftpQ._length();++i ) {
      if( _ftpQ[i].event==event.event ) {
         _ftpQ._deleteel(i);
      }
   }
   
   if( event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // The user wants to abort the abort
      return;
   }
   
   /* We queue it this way because the original event might have had
    * optional data in the info field that we don't want to lose.
    */
   event.state=QS_ABORT;
   event.start=0;
   _ctl_operation.p_caption="Aborting...";
   _ctl_nofbytes.p_caption="";
   event.fcp.PostedCB=__ftpopenAbortCB;
   _ftpQ[0]=event;
   
   return;
}

static int _ftpopenFindAllControls(int formWid,
                                   int &profilecbWid,
                                   int &remotetreeWid)
{
   profilecbWid=formWid._find_control("_ctl_profile");
   if( !profilecbWid ) return(1);
   remotetreeWid=formWid._find_control("_ctl_remote_dir");
   if( !remotetreeWid ) return(1);

   return(0);
}

static boolean __OpenLinks=false;
void __ftpopenOpenCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   RecvCmd_t rcmd;
   ftpFile_t files[];
   ftpFile_t next_file;

   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   fcp.PostedCB=0;

   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   if( event.event==QE_RECV_CMD ) {
      rcmd=event.info[0];
      action=upcase(rcmd.cmdargv[0]);
      if( action=="RETR" ) {
         edit_options="";
         if( fcp.XferType==FTPXFER_BINARY ) {
            edit_options=edit_options" +LB ";
         }
         status=_mdi.p_child.edit(edit_options:+maybe_quote_filename(rcmd.dest));
         if( status ) {
            msg='Unable to open local file "':+rcmd.dest:+'".  ':+_ftpGetMessage(status);
            _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return;
         }
         document_name='ftp://':+fcp.Host;
         remote_path=rcmd.extra;   // This is the fully qualified remote path
         if( substr(remote_path,1,1)!='/' ) document_name=document_name:+'/';
         document_name=document_name:+remote_path;
         _mdi.p_child.docname(document_name);
         refresh();
      } else {
         // This should never happen
         _message_box('Invalid action: "':+action:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
   }
   
   /* We are done.
    * Find the next selected file/directory.
    */
   ftpConnProfile_t *fcp_p;
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;   // This should never happen
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) {
      return;
   }
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      // This should never happen
      return;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=0;
   remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) {
      /* This could happen if the user docked/undocked/killed
       * the Project toolbar in the middle of transferring.
       */
      return;
   }
   idx=remoteWid._TreeFindSelected(0);
   while( idx>=0 ) {
      caption=remoteWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename!=".." ) {
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         if( info=="f" || (__OpenLinks && pos("l",info)) ) {
            // File
            fcp.PostedCB=__ftpopenOpenCB;
            rcmd._makeempty();
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            
            dest=fcp.RemoteCWD;
            if( last_char(dest)!='/' ) dest=dest:+'/';
            dest=dest:+filename;
            
            // Check for an already existing buffer with this document name
            document_name='ftp://':+fcp.Host:+dest;
            #if 0
            buf_name=_ftpDocMatch(document_name);
            if( buf_name!="" ) {
               edit("+b ":+buf_name);
               idx=remoteWid._TreeFindSelected(0);
               continue;
            }
            #else
            info=buf_match(document_name,1,"EVD");
            if( info!="" ) {
               parse info with buf_id . . .;
               edit("+bi ":+buf_id);
               idx=remoteWid._TreeFindSelected(0);
               continue;
            }
            #endif
            
            rcmd.extra=dest;   // Save this so we know how to set p_DocumentName
            dest=_ftpRemoteToLocalPath(&fcp,dest);
            if( dest=="" ) {
               _message_box("Unable to create local filename",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            rcmd.dest=dest;
            
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpopenProgressDlgCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
         } else if( pos("d",info) ) {
            // Directory
            idx=remoteWid._TreeFindSelected(0);
            continue;
         }
         return;
      }
   }
   
   return;
}

#if 1
_command void ftpopenOpen(...) name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   __OpenLinks= (arg(1)!="" && arg(1));
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   idx=remoteWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=remoteWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         continue;
      } else {
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=0;
         if( info=="f" || (__OpenLinks && pos("l",info)) ) {
            // File
            fcp.PostedCB=__ftpopenOpenCB;
            RecvCmd_t rcmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            
            dest=fcp.RemoteCWD;
            if( last_char(dest)!='/' ) dest=dest:+'/';
            dest=dest:+filename;
            
            // Check for an already existing buffer with this document name
            document_name='ftp://':+fcp.Host:+dest;
            #if 0
            buf_name=_ftpDocMatch(document_name);
            if( buf_name!="" ) {
               edit("+b ":+buf_name);
               idx=remoteWid._TreeFindSelected(0);
               continue;
            }
            #else
            info=buf_match(document_name,1,"EVD");
            if( info!="" ) {
               parse info with buf_id . . .;
               edit("+bi ":+buf_id);
               idx=remoteWid._TreeFindSelected(0);
               continue;
            }
            #endif
            
            rcmd.extra=dest;   // Save this so we know how to set p_DocumentName
            dest=_ftpRemoteToLocalPath(&fcp,dest);
            if( dest=="" ) {
               _message_box("Unable to create local filename",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            rcmd.dest=dest;
            
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpopenProgressDlgCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
            break;
         } else if( pos("d",info) ) {
            // Directory
            idx=remoteWid._TreeFindSelected(0);
            continue;
         }
      }
      idx=remoteWid._TreeFindSelected(0);
   }
   
   if( _ftpQ._length()<1 ) return;
   
   gftpAbort=false;
   formWid=show("_ftpProgress_form");
   if( !formWid ) {
      _message_box('Could not show form: "_ftpProgress_form"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   for(;;) {
      process_events(gftpAbort);
      if( gftpAbort ) {
         ftpQEvent_t event;

         if( _ftpQ._length()<1 ) break;
         event=_ftpQ[0];

         /* Find all events in the queue that match this one and delete them.
          */
         for( i=0;i<_ftpQ._length();++i ) {
            if( _ftpQ[i].event==event.event ) {
               _ftpQ._deleteel(i);
            }
         }

         event.state=QS_ABORT;
         event.start=0;
         /* We queue it this way because the original event might have had
          * optional data in the info field that we don't want to lose.
          */
         _ftpQ[0]=event;
         break;
      }
      if( _ftpQ._length()<1 ) {
         // We are done
         break;
      } else {
         /* If the processed event was the last event for that particular
          * connection profile, then we are done
          */
         last=true;
         for( i=0;i<_ftpQ._length();++i ) {
            if( _ftpQ[i].fcp.ProfileName==fcp.ProfileName &&
                _ftpQ[i].fcp.Instance==fcp.Instance ) {
               last=false;
               break;
            }
         }
         if( last ) {
            break;
         }
      }
      if( machine()=='OS2386' || _win32s() ) {
         /* Windows 95/3.1, OS/2 hack.
          * Windows 95/3.1 and OS/2 performance with tight loops is poor.
          * Putting in this 0.05sec delay actually makes it run
          * about 1million % faster.
          */
         delay(5);
      }
      _ftpQTimerCallback();
   }
   formWid._delete_window();

   return;
}

_command void ftpopenOpenLinks() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpopenOpen(1);
}
#else
_command void ftpopenOpen() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   idx=remoteWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=remoteWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         continue;
      } else {
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=0;
         if( info=="f" ) {
            // File
            fcp.PostedCB=__ftpopenOpenCB;
            RecvCmd_t rcmd;
            _str cmdargv[];
            cmdargv._makeempty();
            cmdargv[0]="RETR";
            cmdargv[1]=filename;
            rcmd.cmdargv=cmdargv;
            rcmd.datahost=rcmd.dataport="";
            
            dest=fcp.RemoteCWD;
            if( last_char(dest)!='/' ) dest=dest:+'/';
            dest=dest:+filename;
            rcmd.extra=dest;   // Save this so we know how to set p_DocumentName
            dest=_ftpRemoteToLocalPath(&fcp,dest);
            if( dest=="" ) {
               _message_box("Unable to create local filename",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            rcmd.dest=dest;
            
            rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
            rcmd.ProgressCB=_ftpopenProgressDlgCB;
            rcmd.size=0;
            _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
         } else if( pos("d",info) ) {
            // Directory
            continue;
         }
         return;
      }
      idx=remoteWid._TreeFindSelected(0);
   }

   return;
}
#endif

void __ftpopenManualOpenCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   RecvCmd_t rcmd;

   event= *((ftpQEvent_t *)(arg(1)));

   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   fcp=event.fcp;
   if( event.event==QE_RECV_CMD ) {
      rcmd=event.info[0];
      action=upcase(rcmd.cmdargv[0]);
      if( action=="RETR" ) {
         edit_options="";
         if( fcp.XferType==FTPXFER_BINARY ) {
            edit_options=edit_options" +LB ";
         }
         status=_mdi.p_child.edit(edit_options:+maybe_quote_filename(rcmd.dest));
         if( status ) {
            msg='Unable to open local file "':+rcmd.dest:+'".  ':+_ftpGetMessage(status);
            _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            return;
         }
         document_name='ftp://':+fcp.Host;
         remote_path=rcmd.extra;   // This is the fully qualified remote path
         if( substr(remote_path,1,1)!='/' ) document_name=document_name:+'/';
         document_name=document_name:+remote_path;
         _mdi.p_child.docname(document_name);
         refresh();
      } else {
         // This should never happen
         _message_box('Invalid action: "':+action:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return;
      }
   }

   return;
}

_command void ftpopenManualOpen(...) name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   RecvCmd_t rcmd;
   _str cmdargv[];

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   fcp= *fcp_p;   // Make a copy
   
   // Prompt for the remote path
   result=show("-modal _textbox_form","Manual Open",0,"","","","","Remote filename");
   if( result=="" ) {
      // User cancelled
      return;
   }
   remote_path=strip(_param1);
   if( remote_path=="" ) return;
   
   fcp.PostedCB=__ftpopenManualOpenCB;
   cmdargv._makeempty();
   cmdargv[0]="RETR";
   cmdargv[1]=remote_path;
   rcmd.cmdargv=cmdargv;
   rcmd.datahost=rcmd.dataport="";

   dest=_ftpAbsolute(&fcp,remote_path);

   // Check for an already existing buffer with this document name
   document_name='ftp://':+fcp.Host:+dest;
   #if 0
   buf_name=_ftpDocMatch(document_name);
   if( buf_name!="" ) {
      edit("+b ":+buf_name);
      return;
   }
   #else
   info=buf_match(document_name,1,"EVD");
   if( info!="" ) {
      parse info with buf_id . . .;
      edit("+bi ":+buf_id);
      return;
   }
   #endif

   rcmd.extra=dest;   // Save this so we know how to set p_DocumentName
   dest=_ftpRemoteToLocalPath(&fcp,dest);
   if( dest=="" ) {
      _message_box("Unable to create local filename",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   rcmd.dest=dest;

   rcmd.pasv= (fcp.UseFW && fcp.Options.fwenable && fcp.Options.fwpasv);
   rcmd.ProgressCB=_ftpopenProgressDlgCB;
   rcmd.size=0;
   _ftpEnQ(QE_RECV_CMD,QS_BEGIN,0,&fcp,rcmd);
   
   if( _ftpQ._length()<1 ) return;
   
   gftpAbort=false;
   formWid=show("_ftpProgress_form");
   if( !formWid ) {
      _message_box('Could not show form: "_ftpProgress_form"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   for(;;) {
      process_events(gftpAbort);
      if( gftpAbort ) {
         ftpQEvent_t event;

         if( _ftpQ._length()<1 ) break;
         event=_ftpQ[0];

         /* Find all events in the queue that match this one and delete them.
          */
         for( i=0;i<_ftpQ._length();++i ) {
            if( _ftpQ[i].event==event.event ) {
               _ftpQ._deleteel(i);
            }
         }

         event.state=QS_ABORT;
         event.start=0;
         /* We queue it this way because the original event might have had
          * optional data in the info field that we don't want to lose.
          */
         _ftpQ[0]=event;
         break;
      }
      if( _ftpQ._length()<1 ) {
         // We are done
         break;
      } else {
         /* If the processed event was the last event for that particular
          * connection profile, then we are done
          */
         last=true;
         for( i=0;i<_ftpQ._length();++i ) {
            if( _ftpQ[i].fcp.ProfileName==fcp.ProfileName &&
                _ftpQ[i].fcp.Instance==fcp.Instance ) {
               last=false;
               break;
            }
         }
         if( last ) {
            break;
         }
      }
      if( machine()=='OS2386' || _win32s() ) {
         /* Windows 95/3.1, OS/2 hack.
          * Windows 95/3.1 and OS/2 performance with tight loops is poor.
          * Putting in this 0.05sec delay actually makes it run
          * about a million times faster.
          */
         delay(5);
      }
      _ftpQTimerCallback();
   }
   formWid._delete_window();

   return;
}

_command void ftpopenNew() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   // Prompt for the new file
   remote_path=fcp_p->RemoteCWD;
   result=show("-modal _textbox_form","New FTP file",0,"","?Specify the new remote file.\n\nIf you do not give a full path then it will be relative to ":+remote_path,"","","Remote filename");
   if( result=="" ) {
      // User cancelled
      return;
   }
   remote_path=strip(_param1);
   if( remote_path=="" ) return;
   if( substr(remote_path,1,1)!='/' ) {
      // Relative to remote current working directory
      remotecwd=fcp_p->RemoteCWD;
      if( last_char(remotecwd)!='/' ) remotecwd=remotecwd:+'/';
      remote_path=remotecwd:+remote_path;
   }
   local_path=_ftpRemoteToLocalPath(fcp_p,remote_path);
   if( remote_path=="" ) {
      _message_box("Unable to create a locally mapped filename");
      return;
   }
   document_name='ftp://':+fcp_p->Host;
   if( substr(remote_path,1,1)!='/' ) {
      // This should never happen
      document_name=document_name:+'/';
   }
   document_name=document_name:+remote_path;
   status=edit('+t ':+maybe_quote_filename(local_path));
   if( !status ) {
      _mdi.p_child.docname(document_name);
      //_mdi.p_child.p_ModifyFlags |= MODIFYFLAG_FTP_NEED_TO_SAVE;
      refresh();
   } else {
      msg="Unable to open locally mapped filename";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
   }
   
   return;
}

_command void ftpopenOpenLocalFiles() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   // Prompt for local files
   remote_path=fcp_p->RemoteCWD;
   if( last_char(remote_path)!='/' ) remote_path=remote_path:+'/';
   form_name=_stdform("_open_form");
   result=show("-modal ":+form_name,
               "Specify local filenames to map to ":+remote_path,
               ALLFILES_RE,
               def_file_types,
               OFN_ALLOWMULTISELECT|OFN_FILEMUSTEXIST|OFN_NOCHANGEDIR,
               "",
               "",
               "",
               "",
               "?Specify local filenames to map to ":+remote_path);
   if( result=="" ) {
      // User cancelled
      return;
   }
   for(;;) {
      local_path=parse_file(result);
      filename=strip_filename(local_path,'P');
      document_name='ftp://':+fcp_p->Host:+remote_path:+filename;
      status=edit(maybe_quote_filename(local_path));
      if( !status ) {
         _mdi.p_child.docname(document_name);
         _mdi.p_child.p_ModifyFlags |= MODIFYFLAG_FTP_NEED_TO_SAVE;
         refresh();
      }
      if( result=="" ) break;
   }
   
   return;
}

void __ftpopenChangeDirCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;   // Make a copy
   
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      formWid=_find_object("_tbproject_form","N");
      if( !formWid ) return;
      formWid._UpdateSession(true);
      return;
   }
   
   return;
}

void __ftpopenCwdCB(...);
_command void ftpopenChangeDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   cwd=arg(1);
   if( cwd=="" ) {
      // Prompt for the remote directory
      result=show("-modal _textbox_form","Change remote directory",0,"","?Type the remote directory you would like to change to","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      cwd=_param1;
      if( cwd=="" ) return;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpopenCwdCB;
   _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,cwd);

   return;
}

void __ftpopenMkDirCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   // _UpdateSession() will take care of asynchronous refresh
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   formWid._UpdateSession(true);

   return;
}

_command void ftpopenMkDir() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   path=arg(1);
   if( path=="" ) {
      // Prompt for the remote directory to make
      result=show("-modal _textbox_form","Make remote directory",0,"","?Type the remote directory you would like to make","","","Directory");
      if( result=="" ) {
         // User cancelled
         return;
      }
      path=_param1;
      if( path=="" ) return;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpopenMkDirCB;
   _ftpEnQ(QE_MKD,QS_BEGIN,0,&fcp,path);

   return;
}

void __ftpopenDelFileCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      // Find the next selected file/directory in the tree
      formWid=_find_object("_tbproject_form","N");
      if( !formWid ) return;
      if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) {
         // This should never happen
         return;
      }
      remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
      if( !nofselected ) {
         /* This could happen if the user docked/undocked/killed
          * the Project toolbar in the middle of transferring.
          */
         formWid._UpdateSession(true);
         return;
      }
      idx=remoteWid._TreeFindSelected(0);
      while( idx>=0 ) {
         caption=remoteWid._TreeGetCaption(idx);
         parse caption with filename "\t" .;
         if( filename==".." ) {
            continue;
         }
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp.PostedCB=__ftpopenDelFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      // _UpdateSession() will take care of asynchronous refresh
      formWid._UpdateSession(true);
      return;
   }
   
   return;
}

_command void ftpopenDelFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   _TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected ) return;
   status=_message_box("Delete ":+nofselected:+" files/directories?","FTP",MB_YESNO|MB_ICONQUESTION);
   if( status!=IDYES ) return;
   idx=remoteWid._TreeFindSelected(1);
   while( idx>=0 ) {
      caption=remoteWid._TreeGetCaption(idx);
      parse caption with filename "\t" .;
      if( filename==".." ) {
         continue;
      } else {
         info=remoteWid._TreeGetUserInfo(idx);
         info=lowcase(info);
         fcp= *fcp_p;   // Make a copy
         fcp.PostedCB=__ftpopenDelFileCB;
         if( info=="f" ) {
            _ftpEnQ(QE_DELE,QS_BEGIN,0,&fcp,filename);
         } else if( pos("d",info) ) {
            _ftpEnQ(QE_RMD,QS_BEGIN,0,&fcp,filename);
         }
         return;
      }
      idx=remoteWid._TreeFindSelected(0);
   }

   return;
}

void __ftpopenRenameFileCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   if( event.state==QS_ERROR || event.state==QS_ABORT || event.state==QS_ABORT_WAITING_FOR_REPLY ) {
      // Nothing to do
      return;
   }
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   // _UpdateSession() will take care of asynchronous refresh
   formWid._UpdateSession(true);

   return;
}

_command void ftpopenRenameFile() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,remoteWid) ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   remoteWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( !nofselected || nofselected>1 ) return;
   idx=remoteWid._TreeCurIndex();
   if( idx<0 ) return;
   caption=remoteWid._TreeGetCaption(idx);
   parse caption with rnfr "\t" .;
   if( rnfr==".." ) {
      return;
   } else {
      status=show("-modal _textbox_form","Rename ":+rnfr:+" to...",0,"","?Specify a filename to rename to","","","Rename to");
      if( status=="" ) {
         // User cancelled
         return;
      }
      rnto=_param1;
      if( rnto=="" ) {
         return;
      }
      fcp= *fcp_p;   // Make a copy
      fcp.PostedCB=__ftpopenRenameFileCB;
      _ftpEnQ(QE_RENAME,QS_BEGIN,0,&fcp,rnfr,rnto);
      return;
   }
   
   return;
}

void __ftpopenCustomCmdCB(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   CustomCmd_t ccmd;

   event= *((ftpQEvent_t *)(arg(1)));

   fcp=event.fcp;
   fcp.PostedCB=__ftpopenCustomCmdCB;   // Paranoid
   ccmd=event.info[0];
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      pattern=ccmd.pattern;
      if( pos('%f',pattern) ) {
         idx=_ftpTodoFindNext();
         if( idx>=0 ) {
            _ftpTodoGetCaption(caption);
            parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
            cmdline=stranslate(pattern,filename,'%f','');
            if( cmdline=="" ) {
               msg='Your custom command evaluates to ""';
               _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            ccmd.cmdargv[0]=cmdline;
            _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
            return;
         }
         // That was the last one
      } else {
         // The command was only sent once, so we are done
      }
   }

   if( pos('%f',ccmd.pattern) ) {
      // We were operating on files, so refresh the remote listing
      formWid=_find_object("_tbproject_form","N");
      if( formWid ) {
         formWid._UpdateSession(true);
      }
   }
   
   return;
}

_command void ftpopenCustomCmd() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;
   int formWid;
   CustomCmd_t ccmd;

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   treeWid=formWid._find_control("_ctl_remote_dir");
   if( !treeWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   /* We use the fake name ftpCustomCmd to keep track of retrieve info.
    * Because we use the same retrieve name for both the FTP Client toolbar
    * and the FTP open tab, they share retrieve history.
    */
   status=show("-modal _textbox_form","FTP Custom Command",TB_RETRIEVE|TB_RETRIEVE_INIT,"","?Substitutions:\n\n%f - Remote filename (no path)\n\nExample: To give full permissions to selected files in the tree, issue the command:\n\nSITE CHMOD 777 %f","","ftpCustomCmd","Command");
   if( status=="" ) {
      // User cancelled
      return;
   }
   pattern=_param1;
   if( pattern=="" ) {
      return;
   }
   ccmd._makeempty();
   ccmd.pattern=pattern;
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpopenCustomCmdCB;
   if( pos('%f',pattern) ) {
      // We are acting on selected files in the tree
      treeWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
      if( nofselected ) {
         _ftpTodoGetList(treeWid);
         idx=_ftpTodoFindNext();
         if( idx>=0 ) {
            _ftpTodoGetCaption(caption);
            parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
            cmdline=stranslate(pattern,filename,'%f','');
            if( cmdline=="" ) {
               msg='Your custom command evaluates to ""';
               _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
               return;
            }
            ccmd.cmdargv[0]=cmdline;
            _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
         }
      } else {
         msg="Your custom command requires atleast one file to be selected";
         _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      }
   } else {
      // Send the command line once
      ccmd.cmdargv[0]=pattern;
      _ftpEnQ(QE_CUSTOM_CMD,QS_BEGIN,0,&fcp,ccmd);
   }
   
   return;
}

_command void ftpopenFilter() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) return;
   filter=fcp_p->RemoteFileFilter;
   if( filter=="" ) filter=FTP_ALLFILES_RE;
   status=show("-modal _textbox_form","Remote file filter",TB_RETRIEVE|TB_RETRIEVE_INIT,"","?Specify the file filter for file listings. Separate multiple filters with a space.\n\nExample: *.html *.shtml","","ftpFilter","Filter:":+filter);
   if( status=="" ) {
      // User cancelled
      return;
   }
   filter=_param1;
   if( filter=="" ) return;
   fcp_p->RemoteFileFilter=filter;
   formWid._UpdateSession(true);

   return;
}

_command void ftpopenRefreshSession() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   
   formWid._UpdateSession(true);

   return;
}

_command void ftpopenHScrollbar() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   if( _ftpopenFindAllControls(formWid,profileWid,treeWid) ) return;
   scroll_bars=treeWid.p_scroll_bars;
   if( scroll_bars&SB_HORIZONTAL ) {
      // Turn horizontal scroll bar OFF, turn popup ON
      treeWid.p_scroll_bars &= ~(SB_HORIZONTAL);
      treeWid.p_delay=0;
   } else {
      // Turn horizontal scroll bar ON, turn popup OFF
      treeWid.p_scroll_bars |= SB_HORIZONTAL;
      treeWid.p_delay= -1;
   }
   
   /* Remember horizontal scroll bar settings.
    * Must do this here because exiting the editor does not call a control's
    * ON_DESTROY event.
    */
   _append_retrieve(0,_ctl_remote_dir.p_scroll_bars,"_tbproject_form._ctl_remote_dir.p_scroll_bars");
   
   return;
}

_command void ftpopenViewLog() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   ftpConnProfile_t *fcp_p;
   
   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;
   show("-modal _ftpLog_form",fcp_p,fcp_p->Host);
   
   return;
}

void _ctl_remote_dir.rbutton_down()
{
   _TreeGetSelInfo(nofselected,firstidx,lastidx);
   x=mou_last_x();
   y=mou_last_y();
   idx=_TreeGetIndexFromPoint(x,y,'P');
   if( idx>=0 ) {
      firstline=MAXINT;
      if( firstidx>=0 ) _TreeGetInfo(firstidx,state,bm1,bm2,flags,firstline);
      lastline=-1;
      if( lastidx>=0 ) _TreeGetInfo(lastidx,state,bm1,bm2,flags,lastline);
      _TreeGetInfo(idx,state,bm1,bm2,flags,line);
      if( !nofselected || line<firstline || line>lastline ) {
         // First deselect any lines
         i=_TreeFindSelected(1);
         while( i>=0 ) {
            _TreeGetInfo(i,state,bm1,bm2,flags);
            _TreeSetInfo(i,state,bm1,bm2,flags&~(TREENODE_SELECTED));
            i=_TreeFindSelected(0);
         }
         _TreeSetCurIndex(idx);
         _TreeGetInfo(idx,state,bm1,bm2,flags);
         _TreeSetInfo(idx,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
   }
   
   return;
}

void _ctl_remote_dir.rbutton_up()
{
   int formWid;
   
   menu_name="_FTPOpen_menu";
   idx=find_index(menu_name,oi2type(OI_MENU))
   if( !idx ) {
      return;
   }
   mh=p_active_form._menu_load(idx,'P');
   if( mh<0) {
      _message_box('Unable to load menu: "':+menu_name:+'"',"",MB_OK|MB_ICONEXCLAMATION);
      return;
   }

   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;
   treeWid=formWid._find_control("_ctl_remote_dir");
   if( !treeWid ) return;   // Should never happen

   // If a remote file/directory is not selected then disable file operations
   noffiles=0;
   nofdirs=0;
   noflinks=0;
   treeWid._TreeGetSelInfo(nofselected,firstidx,lastidx);
   if( nofselected ) {
      idx=treeWid._TreeFindSelected(1);
      while( idx>=0 ) {
         caption=treeWid._TreeGetCaption(idx);
         parse caption with filename "\t" size "\t" date "\t" time "\t" attribs;
         if( filename!=".." ) {
            userinfo=treeWid._TreeGetUserInfo(idx);
            userinfo=lowcase(userinfo);
            // Filename
            if( userinfo=="f" ) {
               ++noffiles;
            }
            if( pos("d",userinfo) ) {
               ++nofdirs;
            }
            if( pos("l",userinfo) ) {
               ++noflinks;
            }
         }
         idx=treeWid._TreeFindSelected(0);
      }
   }
   if( !noffiles && !nofdirs ) {
      _menu_set_state(mh,"ftpopenDelFile",MF_GRAYED,'M');
   }
   if( !noffiles ) {
      _menu_set_state(mh,"ftpopenOpen",MF_GRAYED,'M');
   }
   if( (noffiles+nofdirs)!=1 ) {
      _menu_set_state(mh,"ftpopenRenameFile",MF_GRAYED,'M');
   }
   if( !noflinks ) {
      _menu_set_state(mh,"ftpopenOpenLinks",MF_GRAYED,'M');
   }
   on=treeWid.p_scroll_bars&SB_HORIZONTAL;
   if( on ) {
      _menu_set_state(mh,"ftpopenHScrollbar",MF_CHECKED,'M');
   } else {
      _menu_set_state(mh,"ftpopenHScrollbar",MF_UNCHECKED,'M');
   }

   // Show the menu:
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   status=_menu_show(mh,flags,x,y);
   _menu_destroy(mh);
}

void _ctl_remote_dir.'F5'()
{
   ftpopenRefreshSession();
   
   return;
}

void _ctl_remote_cwd.on_drop_down(reason)
{
   ftpConnProfile_t *fcp_p;

   if( reason!=DROP_DOWN ) return;
   
   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen
   
   gchangeremotecwd_allowed=false;
   p_cb_list_box._lbclear();
   len=fcp_p->CwdHist._length();
   for( i=len-1;i>=0;--i ) {
      p_cb_list_box._lbadd_item(fcp_p->CwdHist[i]);
   }
   gchangeremotecwd_allowed=true;
   
   return;
}

void _ctl_remote_cwd.on_change(int reason)
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   if( !gchangeremotecwd_allowed ) return;

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen

   old_RemoteCWD=fcp_p->RemoteCWD;
   if( old_RemoteCWD=="" ) {
      // This should never happen
      old_RemoteCWD='/';
   }
   cwd=p_text;
   if( cwd=="" ) {
      // This should never happen
      cwd=old_RemoteCWD;
   }
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=__ftpopenCwdCB;
   _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,cwd);
   return;
}

void __ftpopenDoubleClick(...)
{
   ftpQEvent_t event;
   ftpConnProfile_t fcp;
   ftpConnProfile_t *fcp_p;
   int formWid;
   
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;   // This should never happen
   
   event= *((ftpQEvent_t *)(arg(1)));
   fcp=event.fcp;
   //message("event.fcp.RemoteCWD="event.fcp.RemoteCWD);
   
   action= upcase(arg(arg()));   // Action word is always last
   if( action!="CDUP" && action!="CWD" ) {
      // This should never happen
      _message_box('Invalid action: "':+action:+'"',FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return;
   }
   
   if( event.state!=QS_ERROR && event.state!=QS_ABORT && event.state!=QS_ABORT_WAITING_FOR_REPLY ) {
      /* Find the matching connection profile in current connections
       * so we can update its stored remote current working directory.
       */
      fcp_p=0;
      for( i._makeempty();; ) {
         _ftpCurrentConnections._nextel(i);
         if( i._isempty() ) break;
         currentconn=_ftpCurrentConnections:[i];
         if( _ftpCurrentConnections:[i].ProfileName==fcp.ProfileName &&
             _ftpCurrentConnections:[i].Instance==fcp.Instance ) {
            // Found it
            fcp_p= &(_ftpCurrentConnections:[i]);
            break;
         }
      }
      if( !fcp_p ) {
         // We didn't find the matching connection profile, so bail out
         return;
      }
      fcp_p->RemoteCWD=fcp.RemoteCWD;
      
      // _UpdateSession() already handles asynchronous operations
      formWid._UpdateSession(true);
      return;
   }
   
   return;
}
void __ftpopenCdupCB(...)
{
   __ftpopenDoubleClick(arg(1),"CDUP");
   
   return;
}
void __ftpopenCwdCB(...)
{
   __ftpopenDoubleClick(arg(1),"CWD");
   
   return;
}

void _ctl_remote_dir.'ENTER',lbutton_double_click()
{
   ftpConnProfile_t *fcp_p;
   ftpConnProfile_t fcp;

   fcp_p=GetCurrentConnProfile();
   if( !fcp_p ) return;   // This should never happen

   idx=_TreeCurIndex();
   caption=_TreeGetCaption(idx);
   parse caption with filename "\t" .;
   fcp= *fcp_p;   // Make a copy
   fcp.PostedCB=0;
   if( filename==".." ) {
      fcp.PostedCB=__ftpopenCdupCB;
      _ftpEnQ(QE_CDUP,QS_BEGIN,0,&fcp);
      return;
   } else {
      info=_TreeGetUserInfo(idx);
      info=lowcase(info);
      if( info=="f" ) {
         /* We have a file so transfer it.
          * Note that ftpopenDownload() will take care of asynchronous
          * operations.
          */
         ftpopenOpen();
      } else if( pos("d",info) ) {
         // We have a directory so CWD to it
         fcp.PostedCB=__ftpopenCwdCB;
         _ftpEnQ(QE_CWD,QS_BEGIN,0,&fcp,filename);
         return;
      }
   }
}

/* Gets called when the queue is processing events.
 * Only gets called once when the queue receives the first
 * event after being idle.
 */
static boolean _busy_override=false;
void _ftpQBusy_ftpopen()
{
   if( _busy_override ) return;
   
   _enable_ftpopen(false);
   
   return;
}

/* Gets called when the queue is idle.
 * Only gets called once when the queue process the last
 * event and then goes idle.
 */
static boolean _idle_override=false;
void _ftpQIdle_ftpopen()
{
   ftpConnProfile_t *fcp_p;
   
   if( _idle_override ) return;
   
   _enable_ftpopen(true);
   
   
   return;
}

static void _enable_children(int parent,boolean enable)
{
   int firstwid,wid;
   
   if( !parent ) return;
   
   firstwid=parent.p_child;
   if( !firstwid ) return;
   wid=firstwid;
   for(;;) {
      if( wid.p_name!="_ctl_abort" ) {
         if( enable ) {
            if( wid.p_mouse_pointer!=MP_DEFAULT ) wid.p_mouse_pointer=MP_DEFAULT;
         } else {
            if( wid.p_mouse_pointer!=MP_HOUR_GLASS ) wid.p_mouse_pointer=MP_HOUR_GLASS;
         }
         _enable_children(wid,enable);
      }
      wid=wid.p_next;
      if( wid==firstwid ) break;
   }
   
   return;
}

static void _enable_ftpopen(boolean enable)
{
   formWid=_find_object("_tbproject_form","N");
   if( !formWid ) return;

   sstabWid=formWid._find_control("_proj_toolbar_sstab");
   if( !sstabWid ) return;
   line=sstabWid._getTabInfo(sstabWid.p_ActiveTab);
   parse line with field1 field2 field3 field4 field5 field6 field7 field8 field9 field10 field11 caption .;
   caption=strip(caption,'B','"');
   /* I have to set p_mouse_pointer for the form for this to
    * work reliably. Shouldn't have to do this though.
    */
   if( !pos("FTP",caption) || enable ) {
      formWid.p_mouse_pointer=MP_DEFAULT;
      _enable_children(formWid,true);
   } else {
      formWid.p_mouse_pointer=MP_HOUR_GLASS;
      _enable_children(formWid,false);
   }
   
   groupWid=formWid._find_control("_ctl_group");
   if( groupWid ) groupWid.p_enabled=enable;
   
   return;
}

_command int ftpOpen() name_info(','VSARG2_NCW|VSARG2_READ_ONLY)
{
   int formWid;
   ftpConnProfile_t *fcp_p;
   
   tbShow("_tbproject_form");
   formWid=_find_object("_tbproject_form");
   if( !formWid ) {
      msg="Could not show _tbproject_form!";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   sstabWid=formWid._find_control("_proj_toolbar_sstab");
   if( !sstabWid ) {
      msg="Could not find the FTP open tab!";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   for( i=0;i<sstabWid.p_NofTabs;++i ) {
      line=sstabWid._getTabInfo(i);
      parse line with field1 field2 field3 field4 field5 field6 field7 field8 field9 field10 field11 caption .;
      caption=strip(caption,'B','"');
      if( pos("FTP",caption) ) {
         // Found it
         break;
      }
   }
   if( i>sstabWid.p_NofTabs ) {
      msg="Could not find the FTP open tab!";
      _message_box(msg,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
      return(1);
   }
   sstabWid.p_ActiveTab=i;
   fcp_p=formWid.GetCurrentConnProfile();
   if( !fcp_p ) {
      /* There are no connections at present.
       * Rather than present the user with a blank tab we will "click"
       * the Connect button for them.
       */
      buttonWid=formWid._find_control("_ctl_connect");
      if( buttonWid ) {
         buttonWid.call_event(buttonWid,LBUTTON_UP,'W');
      }
   } else {
      msg="The FTP open tab is already active.\n\nRight click in the remote directory listing window to open a file.";
      _message_box(msg,"",MB_OK);
   }
   
   return(0);
}

#if 0
_command int ftpEdit() name_info(','VSARG2_LASTKEY|VSARG2_NCW|VSARG2_READ_ONLY)
{
   _str host,port,path,profile;
   ftpConnProfile_t fcp;
   ftpFileHist_t *p1;
   ftpFileHistFile_t *p2;

   key_or_cmdline=_executed_from_key_or_cmdline(name_name(last_index('','C')));

   host=port=path=profile="";

   address=arg(1);
   if( key_or_cmdline ) {
      address=prompt(arg(1),'FTP Edit');
   }
   if( address=='' ) return(0);   // User probably cancelled

   status=0;
   for( ;; ) {   // Use this in place of a goto as a way to quickly handle errors
      if( !vssIsInit() ) {
         status=vssInit(SOCKDEF_CONNECT_TIMEOUT);
         if( status ) break;
      }
      status=_ftpParseAddress(address,host,port,path);
      if( status ) break;
      if( port=='' ) {
         port='ftp';
      }

      // Check for an already existing buffer with this document name
      document_name='ftp://':+host;
      if( substr(path,1,1)!='/' ) document_name=document_name:+'/';
      document_name=document_name:+path;
      #if 0
      buf_name=_ftpDocMatch(document_name);
      if( buf_name!="" ) {
         edit("+b ":+buf_name);
         return(0);
      }
      #else
      info=buf_match(document_name,1,"EVD");
      if( info!="" ) {
         parse info with . . . buf_name;
         edit("+b ":+maybe_quote_filename(buf_name));
         return(0);
      }
      #endif

      fcp._makeempty();
      // arg(4)=true means to connect after succesful creation of the connection profile
      status=_ftpHHWCreateConnProfile(host,port,&fcp,true);
      if( status ) break;

      // First check _ftpFileHist for recently opened files that have a locally mapped filename
      xfer_type=fcp.XferType;
      p1=_ftpFileHist._indexin(fcp.Host);
      if( p1 ) {
         p2=p1->files._indexin(path);
         if( p2 ) {
            local_path=p2->local_path;
            i=lastpos('/',local_path);
            if( i ) {
               temp_path=substr(local_path,1,i-1);
               temp_name=substr(local_path,i+1);
               if( file_match('+D -P +X ':+maybe_quote_filename(path),1)=="" ) {
                  // Path does not exist
                  p1->files._deleteel(path);
                  local_path=_ftpRemoteToLocalPath(&fcp,path);
               } else {
                  xfer_type=p2->xfer_type;
               }
            } else {
               // This should never happen
               p1->files._deleteel(path);
               local_path=_ftpRemoteToLocalPath(&fcp,path);
            }
         } else {
            // No local mapping in _ftpFileHist
            local_path=_ftpRemoteToLocalPath(&fcp,path);
         }
      } else {
         local_path=_ftpRemoteToLocalPath(&fcp,path);
      }
      if( local_path=="" ) {
         _message_box("Unable to create local filename",FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         return(FTP_ERROR_CREATING_LOCAL_FILE_RC);
      }
      if( xfer_type!=FTPXFER_ASCII && xfer_type!=FTPXFER_BINARY ) {
         // Invalid transfer type, so prompt
         xfer_type=show("-modal _ftpDownload_form",path);
         if( xfer_type=="" ) return(0);   // User cancelled
      }
      old_XferType=fcp.XferType;
      fcp.XferType=xfer_type;
      status=_ftpRetr(&fcp,path,local_path);
      fcp.XferType=old_XferType;
      if( status ) break;
      _ftpFileHist:[fcp.Host].files:[path].local_path="";
      if( _ftpUseShortFilenames ) {
         /* Add it to the hash table of opened files - these will be written
          * to the user ini file.
          * NOTE: We only add entries to _ftpFileHist when we are on an 8.3
          *       file system, but we ALWAYS check to see if there is a
          *       remote-to-local filename mapping when we create the local
          *       filename because we might end up with 2 copies of the same
          *       file. This could happen if the user switches from NT (long
          *       file names), to OS/2 (short file names).
          */
         _ftpFileHist:[fcp.Host].files:[path].local_path=local_path;
      }
      _ftpFileHist:[fcp.Host].files:[path].xfer_type=fcp.XferType;
      /* We assemble the document name again because the user might have
       * changed the host name if prompted with the _ftpCreateProfile_form
       * dialog.
       */
      document_name='ftp://':+fcp.Host;
      if( substr(path,1,1)!='/' ) document_name=document_name:+'/';
      document_name=document_name:+path;
      options="";
      if( fcp.XferType==FTPXFER_BINARY ) {
         // Open as a binary file
         options=options:+"+LB ";
      }
      status=edit(options:+maybe_quote_filename(local_path));
      if( status ) break;
      docname(document_name);

      break;
   }
   // Save these for later error reporting
   ftpedit_status=status;
   laststatusline=fcp.LastStatusLine;

   //_ftpEndConnProfile(&fcp);

   if( ftpedit_status ) {
      if( ftpedit_status!=COMMAND_CANCELLED_RC ) {
         if( ftpedit_status==FTP_BAD_RESPONSE_RC ) {
            _message_box(_ftpGetMessage(ftpedit_status):+"\n\n":+laststatusline,FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
         } else {
            if( status==SOCK_SOCKET_NOT_CONNECTED_RC ) {
               // Means that the host name resolved, but cannot connect to it
               _message_box("Unable to connect to ":+host:+":":+port:+"\n\n":+_ftpGetMessage(status),FTP_ERRORBOX_TITLE,MB_OK|MB_ICONEXCLAMATION);
            } else {
               _ftpError(status);
            }
         }
      }
   }

   return(status);
}
#endif

