/*
$VerboseHistory: maketags.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:33a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:33a
 * Comment:
 * Added support for faster tagging.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

static boolean buildcancel;
static _str gdisabled_wid_list;

_control _buildcancel;

defeventtab _buildtag_form
_buildcancel.lbutton_up()
{
   buildcancel=1;
   _enable_non_modal_forms(1,0,gdisabled_wid_list);
   p_active_form._delete_window();
}
defmain()
{
   if ( arg(1)=='' ) {  /* help? */
      _message_box(nls('Arguments:  [-L] file1 [-L] file2...  where -L specifies list file.'));
      command_put('make-tags ');
      return(1)
   }
   /* look for -R and -D option. */
   update_option='';
   list=arg(1)
   params=''
   output_name=SLICK_TAGS_DB;
   output_description='';
   cancel_option = 0;
   for (;;) {
      option=parse_file(list)
      if (option=='') break;
      uoption=upcase(option);
      if ( uoption=='-R' || uoption=='+R') {
         update_option='-R';
      } else if ( uoption=='-D' || uoption=='+D') {
         update_option='-D';
      } else if ( uoption=='-C' || uoption=='+C') {
         cancel_option= 1;
      } else if ( uoption=='-O' || uoption=='+O') {
         output_name=parse_file(list);
      } else if ( uoption=='-N' || uoption=='+N') {
         output_description=strip(parse_file(list),'B','"');
      } else {
         params=params' 'maybe_quote_filename(option)
      }
   }
   mou_hour_glass(1);
   int orig_def_autotag_flags;
   orig_def_autotag_flags=def_autotag_flags2;
   def_autotag_flags2=0;
   status=make_tags2(params,cancel_option,update_option,output_name,output_description);
   def_autotag_flags2=orig_def_autotag_flags;
   mou_hour_glass(0);
   return(status)

}
static _str make_tags2(_str params,boolean cancel_option,_str option2,_str tag_dbname,_str tag_dbdescription)
{
   tag_dbname=absolute(strip(tag_dbname,'B','"'));
   // ask if they want to blow away old style tags files
   if (file_eq(strip_filename(tag_dbname, "P"),SLICK_TAGS_DB)) {
      old_filename=strip_filename(tag_dbname, "N") :+ SLICK_TAGS_FILE;
      if (file_match('-p 'maybe_quote_filename(old_filename),1) != '' &&
          file_match('-p 'maybe_quote_filename(tag_dbname),1) == '' 
          ) {
         btn = _message_box(nls("Delete old style tag file: %s?%s?", old_filename), '', MB_YESNOCANCEL|MB_DEFBUTTON2|MB_ICONQUESTION);
         if (btn!=IDYES && btn!=IDNO) {
            tag_close_db(tag_dbname,1);
            return(1);
         }
         if (btn==IDYES) {
            rc=delete_file(old_filename);
            if ( rc ) {
               message 'Could not delete "'old_filename'"'
               return(1)
            }
         }
         rc=0;
      }
   }
   tag_file_already_exists=0;
   if ( option2=='-R' || option2=='-D') {
      tag_file_already_exists=1;
      //_message_box('make_tags2: loading file 'tag_dbname);
      status=tag_open_db(tag_dbname);
      if ( status==FILE_NOT_FOUND_RC ) {
         message(nls('This option requires that "%s" exists',tag_dbname));
         return(status);
      } else if (status) {
         message(nls("Error reading tag file '%s'",tag_dbname)". "get_message(status));
         return(status);
      }
   } else {
      status=tag_read_db(tag_dbname);
      if (!status) {
         tag_file_already_exists=1;
      }
      //tag_close_db(tag_dbname);
      status=tag_create_db(tag_dbname);
      if ( status ) {
         message('Could not create "'tag_dbname'"');
         return(status);
      }
   }
   if (tag_dbdescription!='') {
      tag_set_db_comment(tag_dbdescription);
   }
   list_view_id='';
   list_stack='';
   path_prefix='';

   if (cancel_option) {
      buildcancel=0;
      buildform_wid=show('_buildtag_form');
      gdisabled_wid_list=_enable_non_modal_forms(0,buildform_wid);
      status=make_tags3(params,option2,cancel_option,list_view_id,path_prefix, tag_dbname)
      if (!buildcancel) {
         _enable_non_modal_forms(1,0,gdisabled_wid_list);
         buildform_wid._delete_window();
      }
   } else {
      status=make_tags3(params,option2,cancel_option,list_view_id,path_prefix, tag_dbname)
   }
   if ( status ) {
      for (;;) {
         if ( list_view_id=='' ) {
            break
         }
         activate_view list_view_id
         _delete_buffer;_quit_view;
         parse list_stack with list_view_id . list_stack;
      }
      tag_close_db(tag_dbname);
      return(status)
   }
   tag_close_db(tag_dbname,1);
   message(nls('Finished. Tag file is %s.', tag_dbname));
   if (pos(PATHSEP:+tag_dbname:+PATHSEP,PATHSEP:+tags_filename():+PATHSEP,1,_fpos_case)) {
      if (tag_file_already_exists) {
         _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tag_dbname);
      } else {
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,tag_dbname);
      }
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   } else {
      // really close the database here, it is not in the tag file path
      tag_close_db(tag_dbname);
   }
   return(status)
}
static _str make_tags3(_str params,_str option2,boolean cancel_option,typeless list_view_id,_str path_prefix, _str tag_db_name)
{
   status=0
   tree_option=''
   for (;;) {
      if (cancel_option) {
         process_events(buildcancel);
         if (buildcancel) {
            tag_close_db(tag_db_name);
            delete_file(tag_db_name);
            message(nls("Command Canceled"));
            status = COMMAND_CANCELLED_RC;
            break;
         }
      }
      if ( list_view_id!='' && params=='' ) {
         activate_view list_view_id
         status=down();
         if ( status ) {
            _delete_buffer();_quit_view();
            list_view_id=''
            return(0);
         }
         get_line params
         if ( params=='' ) {
            continue;
         }
         params=strip(params);
         ch1=substr(params,1,1);
         if (ch1!="-" && ch1!="+") {
            params=maybe_quote_filename(params);
         }
      }
      filename=parse_file(params);
      filename=strip(filename,"B",'"');
      if ( substr(filename,1,1)=='@' ) {
         params=maybe_quote_filename(substr(filename,2))" "params;
         filename='-L';
      }
      option=upcase(filename);
      list_switches='+d ';
      if (option=='+B') {
         list_switches='+b ';
         option='-L';
      }
      if ( option=='-L' || option=='+L') {  /* specify list? */
         filename=parse_file(params);
         filename=translate(filename,FILESEP,FILESEP2);
         if ( strip_filename(filename,'D'):==filename && /* Not absolute spec? */
             substr(filename,1,1):!=FILESEP ) {
            filename=path_prefix:+filename;
         }
         filename=strip(filename,"B",'"');
         //_message_box('make_tags3: loading ' filename);
         load_files('+c 'list_switches:+filename);
         if ( rc ) {
            if ( rc==NEW_FILE_RC ) {
               _delete_buffer();_quit_view();
               msg=nls("File '%s' not found",filename)'.';
            } else {
               msg=get_message(rc);
            }
            message nls("Error reading list '%s'",filename)". "msg;
            status=1;
            break;
         }
         get_view_id new_list_view_id
         if ( path_prefix!='' ) {
            new_path_prefix=substr(path_prefix,1,length(path_prefix)-1);
         }
         new_path_prefix=strip_filename(filename,'N');

         top;up();
         status=make_tags3(params,option2,cancel_option,new_list_view_id,new_path_prefix, tag_db_name);
         if ( status ) {
            return(status);
         }
         params='';
         continue;
      } else if (option=='-T' || option=='+T'){
         tree_option='+T';
         continue;
      }
      if ( filename=='' ) {
         break;
      }
      filename=translate(filename,FILESEP,FILESEP2);
      if ( strip_filename(filename,'D'):==filename && /* Not absolute spec? */
          substr(filename,1,1):!=FILESEP ) {
         filename=path_prefix:+filename;
      }
      temp_view_id=0;
      if ( iswildcard(filename) || tree_option!='') {
         orig_view_id=_create_temp_view(temp_view_id);
         insert_file_list('-dv +p 'tree_option' 'maybe_quote_filename(filename));
         top();
         if (p_line==0) {
            match="";
         } else {
            get_line(match);match=strip(match);
         }
         //match=file_match('-pd 'tree_option' 'maybe_quote_filename(filename),1);
      } else {
         match=filename;
      }
      for (;;) {
         if (cancel_option) {
            process_events(buildcancel);
            if (buildcancel) {
               tag_close_db(tag_db_name);
               delete_file(tag_db_name);
               message(nls("Command Canceled"));
               status = COMMAND_CANCELLED_RC;
               break;
            }
         }
         if ( match=='' ) {
            break;
         }

         /* HERE - delete old tags before adding new ones */
         //if ( option2=='-R' || option2=='-D') {
         if ( option2=='-D') {
            message nls("Deleting tags for '%s'...",match);
            status = tag_remove_from_file(absolute(match),1);
            if (status) {
               if (status!=BT_RECORD_NOT_FOUND_RC) {
                  message nls("Error deleting tags in '%s'",match);
                  status=1;
                  break;
               } else {
                  status=0;
               }
            }
         } else {
            /*====*/
            message nls("Searching '%s'...",match);
            //if ( add_tags(match,tag_view_id,names_view_id) ) {


            //if (option2=='-R') {
               status = tag_insert_file_start(absolute(match));
               if (status) {
                  if (status!=BT_RECORD_NOT_FOUND_RC) {
                     message(nls("Error searching for tags in '%s'",match));
                     status=1;
                  } else {
                     status=0;
                  }
               }
            //}
            if ( add_tags(match) ) {
               status=1;
               break;
            }

            //if (option2=='-R') {
               status = tag_insert_file_end();
               if (status) {
                  if (status!=BT_RECORD_NOT_FOUND_RC) {
                     message(nls("Error deleting stale tags in '%s'",match));
                     status=1;
                  } else {
                     status=0;
                  }
               }
            //}
         }
         if (temp_view_id) {
            activate_view(temp_view_id);
            if (down()) {
               match="";
            } else {
               get_line(match);match=strip(match);
            }
         }  else {
            match="";
         }
         //_message_box('filename='filename', match='match);
      }
      if (temp_view_id) {
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
      }
      if ( status ) {
         break;
      }
   }
   if (status) {
      if (list_view_id!='') {
         activate_view list_view_id;
         _delete_buffer;_quit_view;
         list_view_id='';
      }
   }
   return(status);
}
static _str add_tags(filename)
{
   filename=absolute(filename)
   tag_set_date(filename);
   ext=_bufname2ext(filename);
   index=find_index('vs'ext'_list_tags',PROC_TYPE);
   if (index_callable(index) ) {
      status=call_index(0,filename,ext,index);
      if (status) {
         if (status==FILE_NOT_FOUND_RC) {
            message(nls("File '%s' not found",filename));
         } else {
            message(nls("Error reading '%s'",filename));
         }
      }
      return(status);
   }

   index=find_index(ext'-proc-search',PROC_TYPE)
   /* Search for Pascal functions */
   if ( ! index_callable(index)) {
      if (file_eq(ext,'Fundamental') || ext=='mak'){
         return(0);
      }                

      // see if there is a load-tags function
      index = find_index('vs'ext'_load_tags',PROC_TYPE);
      if (index_callable(index)) {
         tag_set_date(filename);
         status=call_index(filename,index);
         if (status) {
            message nls("Error "status" reading '%s'",filename)
         }
         return status;
      }
      message(nls('Procedure %s not found',ext'-proc-search'));
      return(1)
   }

   //_message_box('add_tags: editing file ' filename);
   rc=edit_file('+c +d 'maybe_quote_filename(filename))
   if ( rc ) {
      if ( rc==NEW_FILE_RC ) {
         _delete_buffer();_quit_view();
         msg=nls("File '%s' not found",filename)"."
      } else {
         msg=get_message(rc)
      }
      message nls('Error reading file "%s"',filename)'. 'msg
      return(rc)
   }
   select_edit_mode();
   get_view_id view_id
   proc_name=''
   _tag_pass=1
   rc=call_index(proc_name,1,ext,index)
   for (;;) {
      if ( rc ) {
         break
      }
      // myproc(package:proc)
      
      int tag_flags;
      _str signature = '';
      _str return_type = '';
      tag_tree_decompose_tag(proc_name, tag_name, class_name, type_name, tag_flags, signature, return_type);
      if (tag_name :!= "") {
         _str s = '';
         if (return_type != '' || signature != '') {
            s = return_type :+ VS_TAGSEPARATOR_args :+ signature;
         }
         status = tag_insert_tag(tag_name, type_name, filename, 
                                 p_line, class_name, tag_flags, s);
      }

      proc_name="";
      rc=call_index(proc_name,0,ext,index)
   }
   _delete_buffer;_quit_view
   return(0)

}
