/*
$VerboseHistory: mfsearch.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:36a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:36a
 * Comment:
 * Search and replace in one file per window hide
 * active buffer and replace it with search hit.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
#define OLDMFOUTPUT 0

static _str mf_search_string,mf_options;

typeless old_search_flags;
_str old_search_string,old_word_re,old_go;


int FindGrepBuffer()
{
   grep_buf_id= -1;
   if (_grep_buffer=='') return(grep_buf_id);

   parse buf_match(_grep_buffer,1,'hvx') with buf_id rest;
   if (buf_id=="") {
      return(grep_buf_id);
   }
   return(buf_id);
}
static void set_old_search()
{
   if (def_mfflags&1) {
      restore_search(old_search_string,old_search_flags,'['p_word_chars']');
      search('',mf_options);
      save_search(old_search_string,old_search_flags,old_word_re);
      old_search_string=mf_search_string;
   }
}
int _mffind(_str search_string,_str options,_str files,_str atbuflist) {
    
   int window_list[];                             // List of Window ID's
   int count;

   last=_last_window_id();                         // Record last window ID
   //messageNwait("last_window_id = "last);
   
   count = 0;
   
   for (i=1;i<=last ;++i) {                        // Loop through window ID's
      if ( _iswindow_valid(i) ) {                  // Check for valid Window ID

         if (i.p_mdi_child && i.p_window_state == 'I') {
                                                   // Check for Active window and if it is Iconized
            window_list[count] = i;                // Add ID to array
            ++count;                               //Increment
           // messageNwait("i= "i);
         }
      }
   }
   focus_wid=_get_focus();
   if (focus_wid==_cmdline) {
      VSWID_STATUS._set_focus();
   }
   status =  _mffind2(search_string, options, files, atbuflist,arg(5));
   if (_get_focus()==VSWID_STATUS) {
      _cmdline._set_focus();
   }

   for (i = 0; i < count ; ++i) {                   //Loop through list of Windows
      if (_iswindow_valid(window_list[i]) && ( window_list[i] != _mdi.p_child)) { // Check and make sure that window is valid
         window_list[i].p_window_state= 'I';   //Set Window Back to Iconized
      }

   }
   return (status);

}


_str _mfreplace(search_string,replace_string,options,files,atbuflist){

   int window_list[];                             // List of Window ID's
   int count;

   last=_last_window_id();                         // Record last window ID
   //messageNwait("last_window_id = "last);
   
   count = 0;
   
   for (i=1;i<=last ;++i) {                        // Loop through window ID's
      if ( _iswindow_valid(i) ) {                  // Check for valid Window ID

         if (i.p_mdi_child && i.p_window_state == 'I') {
                                                   // Check for Active window and if it is Iconized
            window_list[count] = i;                // Add ID to array
            ++count;                               //Increment
           // messageNwait("i= "i);
         }
      }
   }
   
   focus_wid=_get_focus();
   if (focus_wid==_cmdline) {
      VSWID_STATUS._set_focus();
   }
   status =  _mfreplace2(search_string,replace_string, options, files, atbuflist);
   if (_get_focus()==VSWID_STATUS) {
      _cmdline._set_focus();
   }

   for (i = 0; i < count ; ++i) {                   //Loop through list of Windows
      if (_iswindow_valid(window_list[i]) && ( window_list[i] != _mdi.p_child)) { // Check and make sure that window is valid
         window_list[i].p_window_state= 'I';   //Set Window Back to Iconized
      }

   }
   return (status);

}

struct MFFINDINFO {
   int list_view_id;
   int output_buf_id;
   int list_buf_id;
#define DONE_ERROR_DISPLAYED  1
#define DONE_GO               2
#define DONE_NEXTFILE         2
#define DONE_NOMORE           3
   int DoneReason;
}



static int _mffind2(_str search_string,_str options,_str files,_str atbuflist,typeless mfflags)
{
   _nocheck _control list1;
   if (mfflags=="") mfflags=0;

   options=options:+'+';
   get_view_id(orig_view_id);
   boolean WasVisible;
#if OLDMFOUTPUT
   mflastform_wid=_find_object("_mflast_form","n");
#else 
   mflastform_wid=_find_object("_tboutput_form","n");
#endif 
   WasVisible= mflastform_wid!=0;
   // Find existing grep buffer and reuse it
   grep_buf_id=FindGrepBuffer();
   if (grep_buf_id<0) {
      _grep_buffer=absolute(_temp_path():+_GREP1_BUFFER);
   }
   focus_wid=_get_focus();
   if (mfflags & MFFIND_MDICHILD) {
      status=edit(maybe_quote_filename(_grep_buffer));
      if (status && status!=NEW_FILE_RC) {
         return(status);
      }
      grep_buf_id=p_buf_id;
   } else {
      if (mflastform_wid) {
         mflastform_wid._set_foreground_window();
         outputTabToolShowSearch();
      } else {
#if OLDMFOUTPUT
         mflastform_wid=show('-hidden -xy -mdi _mflast_form',0);
#else 
         // Show the output toolbar and activate the search tab:
         int view_id;
         get_view_id(view_id);
         mflastform_wid = outputTabToolShowSearch();
         activate_view(view_id);
#endif 
      }
      grep_buf_id=mflastform_wid.list1.p_buf_id;
      mflastform_wid.list1.p_buf_name=_grep_buffer;
      mflastform_wid.list1.p_buf_flags = THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT;
   }
   if (focus_wid) {
      focus_wid._set_focus();
   }
   // Display wait message and hour glass.  Doing file matches may take a long
   // time for large directories and subdirs.
   mou_hour_glass(1);
   message("Matching files...");
   status=_mfinit(files,atbuflist,junk1,junk2,true)
   if (status) {
      mflastform_wid.p_visible=1;
      return(status);
   }
   mf_options=options;
   mf_search_string=search_string;
   get_view_id(list_view_id);list_buf_id=p_buf_id;

   modify=0;FirstLine=1;
   if (grep_buf_id>=0) {
      output_buf_id=grep_buf_id;

      p_buf_id=grep_buf_id;
      modify=p_modify;
      FirstLine=p_Noflines+1;
      if (!(mfflags & MFFIND_APPEND)) {
         p_undo_steps=0;
         _lbclear();
         FirstLine=1;
      }
      bottom();
   } else {
      load_files('+t');
      _delete_line();
      /* give it a buffer name so MFLAST can find the list */
      p_buf_name=_grep_buffer;
      output_buf_id=p_buf_id;
      if (!(mfflags & MFFIND_MDICHILD) ) { //def_mffind_style!=MDICHILD
         // We want next/prev buffer to skip this buffer.
         // We want dialog to close buffer if edit/quit commands don't indicate otherwise
         p_buf_flags=p_buf_flags|HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE;
      }
   }
   grep_mode();
   p_undo_steps=0;
   p_buf_id=list_buf_id;
   mou_hour_glass(1);
   NofMatches=NofFileMatches=0;
   qmffind_wid=0;
   SelectedMatch=0;
   RestoreToNoMdiChildren=_no_child_windows();
   if (mfflags & MFFIND_CURBUFFERONLY) {
      activate_view(orig_view_id);save_pos(p);
      path=_build_buf_name();

      top();

      get_view_id(buf_view_id);
      restore_search(old_search_string,old_search_flags,'['p_word_chars']');
      found_one_status=search(mf_search_string,'@'mf_options);
      if (!found_one_status) {
         activate_view(list_view_id);p_buf_id=output_buf_id;
         insert_line('File 'path);
         p_col=1;_SetTextColor(CFG_FILENAME,_line_length());
         activate_view(buf_view_id);
         {
            // Insert all occurrences
            _SetAllOldLineNumbers();
            status=0;
            for (;;) {
               if (status) break;
               ++NofMatches;
               get_line(line);
               pcol=_text_colc(p_col,'P');
               FoundLen=match_length();
               if (pcol+FoundLen>_line_length(1)) {
                  FoundLen=_line_length(1)-pcol;
                  // User is searching for 0 length string.
                  if (FoundLen<0) FoundLen=0;
               }
               linenum=p_line;col=p_col;
               activate_view(list_view_id);
               prefix='  'linenum' 'col':';
               insert_line(prefix:+line);
               pcol+=length(prefix);
               p_col=_text_colc(pcol,'I');
               _SetTextColor(CFG_HILIGHT,FoundLen);
               activate_view(buf_view_id);
               status=repeat_search();
            }
         }
         activate_view(list_view_id);p_buf_id=list_buf_id;
      }
      activate_view(orig_view_id);
      restore_pos(p);
      activate_view(list_view_id);
   } else {
      PromptInitDone=false;
      SearchingForColor=pos('x',mf_options,1,'i') || pos('c',mf_options,1,'i');
      if (!down()) {
         done=0;
         for (;;) {
            path=_lbget_text();
            path=strip(path,'b','"');
            status=0;
            file_already_loaded= ! load_files('+c +q +b 'path)
            if (mfflags & MFFIND_GLOBAL) {
               if ( ! file_already_loaded ) {
                  //say("File hh2a1: "path);shell("/bin/date");
                  /* If the file already exists in memory, then this creates a whole */
                  /* new view of that file so that we can search without messing up */
                  /* the cursor position of the user's already loaded file */
                  status=edit_file(build_load_options(path)' +q +c -w 'maybe_quote_filename(path));
                  if (!status && SearchingForColor) {
                     select_edit_mode();
                  }
               }
               ViewCreated=1;
               orig_pos="";
            } else {
               // To allow us to find buffer with invalid file names like "Directory of ..." buffer
               // look for the buffer first.
               parse buf_match(path,1,'hvx') with buf_id . buf_flags buf_name;
               if (buf_id!='') {
                  status=edit('+bi 'buf_id);
               } else {
                  status=edit(maybe_quote_filename(path));
               }
               ViewCreated=0;
               save_pos(orig_pos);
            }

            if (status && status!=NEW_FILE_RC) {
               if (qmffind_wid) {
                  qmffind_wid._delete_window();
               }
               activate_view(list_view_id);
               p_buf_id=output_buf_id;
               // If the grep buffer did not already exist
               if (grep_buf_id<0) {
                  _delete_buffer();  // delete the output buffer
               }
               p_buf_id=list_buf_id;_delete_temp_view(list_view_id);

               activate_view(orig_view_id);_set_focus();
               if (status==FILE_NOT_FOUND_RC) {
                  _message_box(nls("File '%s' not found",path))
               } else {
                  _message_box(nls("Unable to edit '%s'.\n\n",path)get_message(status))
               }
               mou_hour_glass(0);
               clear_message();
               mflastform_wid.p_visible=1;
               return(status);
            }
            if (status!=NEW_FILE_RC) {
               message("File: "path);
               get_view_id(buf_view_id);
               restore_search(old_search_string,old_search_flags,'['p_word_chars']');
               top();
               found_one_status=search(mf_search_string,'@'mf_options);
               save_search(a1,flags,a3);
               if (!found_one_status) {
                  ++NofFileMatches;
                  activate_view(list_view_id);p_buf_id=output_buf_id;
                  insert_line('File 'path);
                  p_col=1;_SetTextColor(CFG_FILENAME,_line_length());
                  activate_view(buf_view_id);
                  if (mfflags & MFFIND_GLOBAL) {
                     save_search(a1,flags,a3);
                     if (!(mfflags & MFFIND_FILESONLY)) {
                        // Insert all occurrences
                        if (file_already_loaded) {
                           _SetAllOldLineNumbers();
                        }
                        status=0;
                        for (;;) {
                           if (status) break;
                           get_line(line);
                           pcol=_text_colc(p_col,'P');
                           FoundLen=match_length();
                           if (pcol+FoundLen>_line_length(1)) {
                              FoundLen=_line_length(1)-pcol;
                           }
                           linenum=p_line;col=p_col;
                           activate_view(list_view_id);
                           ++NofMatches;
                           prefix='  'linenum' 'col':';
                           insert_line(prefix:+line);
                           pcol+=length(prefix);
                           p_col=_text_colc(pcol,'I');
                           _SetTextColor(CFG_HILIGHT,FoundLen);
                           activate_view(buf_view_id);
                           status=repeat_search();
                        }
                     }
                  } else {
                     if (!(mfflags & MFFIND_GLOBAL)) {
                        // Insert all occurrences
                        status=0;cancel=0;
                        buf_wid=p_window_id;
                        if (file_already_loaded) {
                           _SetAllOldLineNumbers();
                        }
                        for (;;) {
                           if (status) break;
                           pcol=_text_colc(p_col,'P');
                           SelectedMatch=1;
                           _deselect();_select_match();
                           if (!(mfflags & MFFIND_FILESONLY)) {
                              get_line(line);
                              pcol=_text_colc(p_col,'P');
                              FoundLen=match_length();
                              if (pcol+FoundLen>_line_length(1)) {
                                 FoundLen=_line_length(1)-pcol;
                              }
                              found=get_text(match_length(''),match_length('s'));
                              linenum=p_line;col=p_col;
                              activate_view(list_view_id);
                              ++NofMatches;
                              prefix='  'linenum' 'col':';
                              insert_line(prefix:+line);
                              pcol+=length(prefix);
                              p_col=_text_colc(pcol,'I');
                              _SetTextColor(CFG_HILIGHT,FoundLen);
                           }
                           if (!(mfflags & (MFFIND_GLOBAL))) {
                              if (mfflags & MFFIND_SINGLE) {
                                 result="";
                              } else {
                                 if (!PromptInitDone) {
                                    PromptInitDone=1;
                                    qmffind_wid=show('-mdi _qmffind_form');
                                    _search_form_xy(qmffind_wid,buf_wid);
                                 }
                                 _nocheck _control ctlfound,ctlyes;
                                 qmffind_wid.ctlfound.p_caption=found;
                                 qmffind_wid.ctlyes._set_focus();
                                 _SearchViewMatch(qmffind_wid,buf_wid);
                                 save_search(p1,p2,p3,p4);
                                 result=_modal_wait(qmffind_wid);
                                 restore_search(p1,p2,p3,p4);
                              }
                              if (result=="") {  // Esc or NO
                                 //focus_wid=0;  // Don't restore original focus
                                 //orig_pos="";  // Don't restore original position
                                 RestoreToNoMdiChildren=0;
                                 qmffind_wid=0;
                                 done=1;
                                 activate_view(buf_view_id);
                                 _SetAllOldLineNumbers();
                                 break;
                              }
                              if (result=='n') {  // Next file
                                 break;
                              }
                              if (result=='g') {
                                 mfflags|=MFFIND_GLOBAL;
                              }
                           }
                           activate_view(buf_view_id);
                           status=repeat_search();
                        }
                     }
                  }
                  activate_view(list_view_id);p_buf_id=list_buf_id;
                  activate_view(buf_view_id);
               }
               if (done) break;
               if (orig_pos!="") {
                  restore_pos(orig_pos);
               }
            }
            // whether we found an occurrence or not
            if ( ! file_already_loaded ) {
               old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
               quit_file();
               switch_buffer(old_buffer_name,'Q');
            }
            if (ViewCreated) {
               _quit_view();
            } else if(def_one_file!='' && !file_already_loaded) { // If we are in one file per window mode
               _delete_window();
            }
            activate_view(list_view_id);
            if(down()) break;
         }
      }
   }
   if (RestoreToNoMdiChildren && !_no_child_windows() && def_one_file=="") {
      _mdi.p_child._delete_window();
   }
   if (SelectedMatch && 
       !(def_persistent_select=='D' && def_leave_selected) &&
       !(def_keys=='brief-keys' &&
              def_persistent_select!='Y' && def_leave_selected)) {
      _deselect();
   }
   if (qmffind_wid) {
      qmffind_wid._delete_window();
   }
   activate_view(list_view_id);p_buf_id=list_buf_id;
   save_search(old_search_string,old_search_flags,old_word_re);
   mou_hour_glass(0);
   p_buf_id=output_buf_id;

#if 0
   // If the grep output buffer is empty
   if (!p_Noflines) {
      This code is only useful for the mdichild case.  However,
      it will have to be smarter to handle no mdi child windows
      and one file per window.  For now we force the user to close
      the buffer/window.
      // If the grep buffer did not already exist
      if (grep_buf_id<0) {
         _delete_buffer();  // delete the output buffer
      }
      p_buf_id=list_buf_id;
      _delete_temp_view(list_view_id);

      activate_view(orig_view_id);_set_focus();
      _message_box('Search string not found.')
      return(1)
   }
#endif
   // If the grep output buffer is empty
   if (!p_Noflines) {
      message("No matches found.");
   } else if (mfflags & MFFIND_SINGLE) {
      clear_message();
   } else {
      if (mfflags & MFFIND_CURBUFFERONLY) {
         if (NofMatches > 1) {
            text=NofMatches" matches found."
      } else {
            text=NofMatches" match found."
         }
      } else {
         if (mfflags &MFFIND_FILESONLY) {
            if (NofFileMatches > 1) {
               text=NofFileMatches" files found."
            } else {
               text=NofFileMatches" file found."
            }
         } else {
            text=NofMatches"/"NofFileMatches" matches/files found."
         }
      }
      if (def_mfflags & 1) {
         bindings=_mdi.p_child.where_is("find_next",1);
      } else {
         bindings=_mdi.p_child.where_is("next_error",1);
      }
      parse bindings with 'is bound to 'bindings;
      parse bindings with bindings ',';
      if (bindings!="") {
         text=text:+"  Press "bindings:+" for next occurrence.";
      }
      sticky_message(text);
   }

   // If the grep output buffer is empty
   p_modify=modify;
   p_line=FirstLine;p_col=1;
   if (mflastform_wid) {
      mflastform_wid.list1.p_line=FirstLine;
   }
   up();_mffindSetMark();down();
   p_color_flags=CLINE_COLOR_FLAG;
   p_undo_steps=_DefaultUndoSteps();
   if ((mfflags & MFFIND_MDICHILD)) {
      // Force mflast command to use mdi child
      p_buf_flags&=~(HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE);
   }

   p_buf_id=list_buf_id;_delete_temp_view(list_view_id);

   activate_view(orig_view_id);
   if (mflastform_wid) {
      if (!WasVisible && !mflastform_wid.list1.p_Noflines) {
         if (mflastform_wid.p_isbutton_bar) {
            _mdi._bbdockFindWid(mflastform_wid,bbside,i);
            _mdi._bbdockRemove(bbside,i);
            _mdi._bbdockRefresh(bbside);
         } else {
            mflastform_wid._delete_window();
         }
      } else {
         mflastform_wid.p_visible=1;
      }
   }
   if (!(mfflags & MFFIND_CURBUFFERONLY) && 
       (mfflags & MFFIND_MDICHILD) &&
       NofMatches) {
      mflast();
   }
   /*if (focus_wid) {
      focus_wid._set_focus();
   } */

   return(0);
}

_command void grep_mode() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_MDI)
{
  p_mode_name='Grep';
  p_extension="";
  p_mode_eventtab=find_index('grep-keys',EVENTTAB_TYPE)
}
_str _mffind_markid;
void _SetNextErrorMark(_str &markid,...)
{
   // markid could be $errors.tmp, .process, or search tab output buffer
   doSearchTab=arg(2)!='';
   if (markid=="") {
      markid=_alloc_selection('b');
   } else {
      if (_select_type(markid)!="") {
         save_pos(p);
         orig_buf_id=p_buf_id;
         status=_begin_select(markid);
         if (status) {
            clear_message();
         } else {
            _lineflags(0,CURLINEBITMAP_LF);
            p_buf_id=orig_buf_id;
            restore_pos(p);
         }
      }
   }
   _select_char(markid);
   _lineflags(CURLINEBITMAP_LF,CURLINEBITMAP_LF);
   linenum=p_line;
   if (doSearchTab) {
      wid=_find_object('_tboutput_form.list1');
      if (wid) {
         //wid.p_col=1;
         //wid.p_line=linenum;
         wid.p_scroll_left_edge=-1;
      }
   } else if (p_buf_name=='.process' || _process_info('b')) {
      wid=_find_object('_tboutput_form._shellEditor');
      if (wid) {
         wid.p_col=1;
         wid.p_line=linenum;
         wid.p_scroll_left_edge=-1;
      }
   }
}
void _mffindSetMark()
{
   _SetNextErrorMark(_mffind_markid,1);
}
/*
    Forces _mffindActive to return false.
*/
void _mffindNoMore(int srcbit /*1-search 2-compile */)
{
   if (!(def_mfflags & srcbit)) {
      return;
   }
   if (_mffind_markid=="") return;
   if (_select_type(_mffind_markid)!="") {
      get_view_id(orig_view_id);
      activate_view(HIDDEN_VIEW_ID);
      _safe_hidden_window();

      _get_selinfo(start_col,end_col,grep_buf_id,_mffind_markid);
      p_buf_id=grep_buf_id
      _begin_select(_mffind_markid);
      _lineflags(0,CURLINEBITMAP_LF);
      _deselect(_mffind_markid);
      activate_view(orig_view_id);
      _safe_hidden_window();
   }
}
/*
    Returns true if _mffindNext/Prev function can traverse
    the multi-file find messages.
*/
boolean _mffindActive(int srcbit /*1-search 2-compile */)
{
   if (!(def_mfflags & srcbit)) {
      return(false);
   }
   if (_mffind_markid=="") return(false);
   if (_select_type(_mffind_markid)=="") {
      return(false);
   }
   return(true);
}
int _mffindPrev()
{
   return(_mffindNext(-1));
}
int _mffindNext()
{
   doPrev=(arg(1)!="");
   if (_mffind_markid=="" || _select_type(_mffind_markid)=="") {
      return(STRING_NOT_FOUND_RC);
   }
   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   _begin_select(_mffind_markid);
   if (doPrev) {
      get_line(line);
      parse line with line rest;
      if (lowcase(line)=='file') {
         up();
      } else {
         up();
         get_line(line);
         parse line with line rest;
         if (lowcase(line)=='file') {
            up();
         }
      }
   } else {
      was_line0=(p_line==0);
      if (was_line0) {
         down();
      } 
      get_line(line);
      parse line with line rest;
      if (lowcase(line)=='file' && !was_line0) {
         if (down()) {
            _safe_hidden_window();
            return(NO_MORE_FILES_RC);
         }
      } else {
         if (!was_line0 && down()) {
            _safe_hidden_window();
            return(NO_MORE_FILES_RC);
         }
         get_line(line);
         parse line with line rest;
         if (lowcase(line)=='file') {
            if(down() ){
               _safe_hidden_window();
               return(NO_MORE_FILES_RC);
            }
            get_line(line);
            parse line with line rest;
            if (lowcase(line)=='file') {
               up();
            }
         }
      }
   }
   if (p_line==0) {
      _safe_hidden_window();
      return(NO_MORE_FILES_RC);
   }
   status=_mffindGetDest(filename,linenum,col);
   _safe_hidden_window();
   if (status) return(status);
   return(_mffindGoTo(filename,linenum,col));

}
int _mffindGetDest(_str &filename,int &linenum,int &col)
{
   get_line(line);
   parse line with line rest;
   if (lowcase(line)=='file') {
      _mffindSetMark();
      filename=rest;
      linenum= -1;
      return(0);
   }
   parse rest with colstr ':';
   if (!isinteger(line) || !isinteger(colstr)) {
      return(1);
   }
   linenum=line;col=colstr;
   save_pos(p);
   status=search('^ *file','-@ri');
   get_line(filename);
   parse filename with . filename;

   restore_pos(p);
   if (status) {
      return(1);
   }
   _mffindSetMark();
   return(0);
}
/*
     Use must call _mffindGetDest before calling this function.
*/
int _mffindGoTo(_str filename,int linenum,int col)
{
   _get_selinfo(start_col,end_col,grep_buf_id,_mffind_markid);
   for (i=1;i<=_last_window_id();++i) {
      if (_iswindow_valid(i) && i.p_view_id<0 && i.p_buf_id==grep_buf_id) {
         i._begin_select(_mffind_markid);
      }
   }
   if (_isno_name(filename)) {
      parse filename with '<' buf_id'>';
      status=edit('+bi 'buf_id);
   } else {
      // To allow us to find buffer with invalid file names
      // look for the buffer first.
      parse buf_match(filename,1,'hvx') with buf_id modify buf_flags buf_name;
      if (buf_id!='') {
         status=edit('+bi 'buf_id);
      } else {
         file_already_loaded= ! _mdi.p_child.load_files('+c +q +b 'filename);
         status=edit(maybe_quote_filename(filename));
         if (!file_already_loaded && !status) {
            _SetAllOldLineNumbers();
         }
      }
   }
   if (status) return(status);
   old_scroll_style=_scroll_style();
   _scroll_style('c');
   if (linenum>=0) {
      _GoToOldLineNumber(linenum);
      //p_line=linenum;
      p_col=col;
   }
   _scroll_style(old_scroll_style);
   set_old_search();
   return(0);
}
_command int grep_goto() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_MDI)
{
   if ( command_state() || p_window_state:=='I' ) {
      try_calling(eventtab_index(_default_keys,
                          _default_keys,event2index(ENTER)));
      return(1)
   }
   status=_mffindGetDest(filename,linenum,col);
   if (status==FILE_NOT_FOUND_RC) {
      _message_box("Can't find file");
      return(FILE_NOT_FOUND_RC);
   }
   return(_mffindGoTo(filename,linenum,col));
}

defeventtab _mflast_form
_mflast_form.on_resize()
{
   parse p_active_form.p_user with dx_from_right dy_from_bottom dy_between

   button_y=p_active_form.p_height-dy_from_bottom-_ok.p_height;
   list_height=(button_y-dy_between)-list1.p_y;
   list_width=(p_active_form.p_width-dx_from_right)-list1.p_x;

   _ok.p_y=button_y;
   command2.p_y=button_y;
   command3.p_y=button_y;
   list1.p_width=list_width;
   list1.p_height=list_height;
}
#if 0
list1.'RIGHT'()
{
   scroll_right();
}
list1.'LEFT'()
{
   scroll_left();
}
#endif

list1.lbutton_double_click()
{
   _ok.call_event(_ok,LBUTTON_UP);
}
int initMFOutputList(int InitGrepBuffer)
{
   p_window_id=_control list1;
   p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG);
   p_MouseActivate=MA_NOACTIVATE;
   //p_window_flags&=~(CURLINE_COLOR_WFLAG);
   if (InitGrepBuffer) {
      grep_buf_id=FindGrepBuffer();
      if (grep_buf_id<0) {
#if OLDMFOUTPUT
         p_active_form._delete_window();
         _message_box(nls('Use Find command on Search menu first to build a list.'))
         return(1);
#endif 
      } else {
      //list_buf_id=p_buf_id;
      _delete_buffer();
      p_buf_id=grep_buf_id;
      //_lbselect_all();_lbdeselect_all();
      if (_mffind_markid=='') {
         top();
      } else {
         if (_select_type(_mffind_markid)!="") {
            status=_begin_select(_mffind_markid);
            if (status) {
               clear_message();
               top();
            }
         } else {
            top();
         }
      }
      up();_mffindSetMark();down();
      }
   }
   parse _default_font(CFG_WINDOW_TEXT) with font_name ',' size ',' font_flags ','
   if (font_name!='') p_font_name=font_name;
   if (size!='') p_font_size=size;
   if (font_flags!='') _font_flags2props(font_flags);
   return(0);
}
_ok.on_create()
{
   if (initMFOutputList(arg(1))) {
      return(1);
   }

   dx_from_right=p_active_form.p_width-(list1.p_x+list1.p_width);   /* Distance from right border to right side of 'list1' */
   dy_from_bottom=p_active_form.p_height-(_ok.p_y+_ok.p_height);    /* Distance from bottom border to bottom of '_ok' button */
   dy_between=_ok.p_y-(list1.p_y+list1.p_height);                   /* Distance between the bottom of 'list1' and top of '_ok' button */

   p_active_form.p_user=dx_from_right' 'dy_from_bottom' 'dy_between

   p_active_form.call_event(p_active_form,ON_RESIZE);
}
void _ok.lbutton_up()
{
   p_window_id=_control list1;
   list1._set_focus();
   if (list1.p_line==0) return;
   status=_mffindGetDest(filename,linenum,col);
   if (status==FILE_NOT_FOUND_RC) {
      _message_box("Can't find file");
      return;
   }
   _mffindGoTo(filename,linenum,col);
   return;
}
int _OnUpdate_mflast(CMDUI &cmdui,int target_wid,_str command)
{
   if ( _grep_buffer=='' || buf_match(_grep_buffer,1,'hx')=='') {
      return(MF_GRAYED);
   }
   return(MF_ENABLED);
}
_command int mflast() name_info(','VSARG2_REQUIRES_MDI)
{
   filename='';
   if (_grep_buffer!='') {
      filename=buf_match(_grep_buffer,1,'hx');
   }
   if (filename=='') {
      _message_box(nls('Use Find command on Search menu first to build a list.'))
      return(1);
   }
   parse buf_match(_grep_buffer,1,'hvx') with buf_id modify buf_flags buf_name;
	if ((buf_flags & DELETE_BUFFER_ON_CLOSE) && upcase(arg(1))!='w') {
#if OLDMFOUTPUT
      show('-xy -mdi _mflast_form');
#else 
      outputTabToolShowSearch(0);
#endif 
      return(0);  // Modless dialog box
   }
   

   qfilename=maybe_quote_filename(filename);
   if (def_one_file=='') {
      status=edit(qfilename);
   } else {
      wid=window_match(filename,1,'hx');
      if (wid) {
         status=edit(qfilename);
      } else {
         _get_max_window(mx,my,mwidth,mheight);
         x=0;
         width=mwidth    //_mdi.p_width-_mdi._left_width()*2;
         height=_ly2ly(SM_TWIP,SM_PIXEL,2300);
         //messageNwait('mheight='mheight' my='my' ch='_mdi.p_client_height);
         y=my+mheight-height
         if (y<my) y=my;
         p_window_id=_mdi.p_child;
         if (!_no_child_windows() && p_window_state=='M') {
            status=load_files('+i 'def_load_options' 'qfilename);
            if (!status) {
               // Set normalized size of window
               _move_window(x,y,width,height,'N');
            }
         } else {
            status=load_files('+i:'x' 'y' 'width' 'height' n ':+def_load_options' 'qfilename);
         }
      }
   }
   if (!status) {
      grep_mode();
   }
   return(status)
}

static _str _mfreplace2(search_string,replace_string,options,files,atbuflist)
{
   _mffindNoMore(1);
   options=options:+'+'
   mou_hour_glass(1);
   message("Matching files...");
   status=_mfinit(files,atbuflist,orig_view_id,junk,true);
   if (status) {
      rc='';  // Name of file in which error occurred
      return(status);
   }
   get_view_id(list_view_id);
   old_go=0;
   mou_hour_glass(1);
   Nofchanges=0;
   RestoreToNoMdiChildren=_no_child_windows();

   // Disable the procs tab in the project tooltab if the 
   // active tab is the procs tab:
   int tbsstabid=0;
   int tbformid;
   tbformid = _find_object("_tbproject_form","N")
   if (tbformid) {
      tbsstabid = tbformid._find_control("_proj_toolbar_sstab");
      if (tbsstabid.p_ActiveTab == PROJTOOLTAB_PROCS) {
         tbsstabid.p_ActiveEnabled = FALSE;
      } else {
         tbsstabid=0;
      }
   }

   for (;;) {
      if ( down() ) {
         status=0;
         path='';  // Name of file in which error occurred
         break;
      }
      path=_lbget_text()
      path=strip(path,'b','"');
      activate_view(orig_view_id);
      message("File: "path);
      // To allow us to find buffer with invalid file names like "Directory of ..." buffer
      // look for the buffer first.
      parse buf_match(path,1,'hvx') with buf_id . buf_flags buf_name;
      file_already_loaded= buf_id!='';
      if (file_already_loaded) {
         edit_status=edit('+bi 'buf_id);
      } else {
         edit_status=edit(maybe_quote_filename(path));
      }
      if (edit_status && edit_status!=NEW_FILE_RC) {
         _delete_temp_view(list_view_id);
         activate_view(orig_view_id);
         if (status==FILE_NOT_FOUND_RC || status==NEW_FILE_RC) {
            _message_box(nls("File '%s' not found",path))
         } else {
            _message_box(nls("Unable to edit '%s'.\n\n",path)get_message(status))
         }
         rc=path;  // Name of file in which error occurred
         mou_hour_glass(0);
         if (tbsstabid) {
            tbsstabid.p_ActiveEnabled = TRUE;
         }
         return(status);
      }
      save_pos(p);
      if (!edit_status) {
         get_view_id(buf_view_id);
         restore_search(old_search_string,old_search_flags,'['p_word_chars']');
         top();
         //status=gui_replace2(search_string,replace_string,((old_go)?'*':'')options);
         status=gui_replace2(search_string,replace_string,((old_go)?'*':'')options,1);
         Nofchanges+=_Nofchanges;
         activate_view(buf_view_id);
         if (status && status!=STRING_NOT_FOUND_RC) {
            // Command must have been cancelled
            message(get_message(status));
            rc=path;  // Name of file in which error occurred
            break;
         }
      }
      /* whether we found an occurrence or not */
      if ( ! file_already_loaded ) {
         if (old_go && p_modify && _need_to_save2()) {
            status=save();
            if (status) {
               break;
            }
         }
         if (tbsstabid && p_modify && _need_to_save2()) {
            tbsstabid.p_ActiveEnabled=true;
            status=quit();
            tbsstabid.p_ActiveEnabled=false;
         } else {
            status=quit();
         }
         if (status) {
            break;
         }
      } else if(p_line==1 && p_col==1){   //No occurrences found?
         restore_pos(p);
      }
      activate_view(list_view_id);
   }
   if (!status && RestoreToNoMdiChildren && !_no_child_windows() && def_one_file=="") {
      _mdi.p_child._delete_window();
   }
   mou_hour_glass(0);
   save_search(old_search_string,old_search_flags,old_word_re);
   _delete_temp_view(list_view_id);
   activate_view(orig_view_id);
   if (status==COMMAND_CANCELLED_RC) {
      activate_view(buf_view_id);
   } else if (Nofchanges && status==STRING_NOT_FOUND_RC) {
      clear_message();
   } else if (!Nofchanges) {  // if did not replace anything in any file, print the STRING_NOT_FOUND_RC message
      message(get_message(STRING_NOT_FOUND_RC));
   }
   if (tbsstabid) {
      tbsstabid.p_ActiveEnabled = TRUE;
   }
   rc=path;
   return(status)
}
/*
    When CreateTempView option is given orig_hidden_buf_id is
    set to current buffer id and NOT the current hidden window
    buffer id.
*/
static _str _mfinit(_str files,_str atbuflist,int &orig_view_id,
                    int &orig_hidden_buf_id,
                    boolean CreateTempView)
{
   get_view_id(orig_view_id);
   orig_hidden_buf_id=-1;
   if (!CreateTempView) {
      activate_view(HIDDEN_VIEW_ID);
      orig_hidden_buf_id=p_buf_id;
   }
   if (atbuflist!='' && substr(atbuflist,1,1)=='@') {
      if (CreateTempView) {
         status=_open_temp_view(substr(atbuflist,2),temp_view_id,orig_view_id,"+b");
      } else {
         status=load_files('+m +b 'substr(atbuflist,2));
      }
      if ( status ) {
         activate_view orig_view_id;_set_focus();
         _message_box(nls("Buffer '%s' not found",substr(atbuflist,2)))
         return(status);
      }
   } else {
      if (CreateTempView) {
         orig_view_id=_create_temp_view(temp_view_id);
         status=0;
      } else {
         status=load_files('+m +t');
      }
      if (status) {
         activate_view orig_view_id;_set_focus();
         _message_box(nls("Unable to create temp buffer"))
         return(status);
      }
      _delete_line();
      for (;;) {
         word = parse_file(atbuflist);
         if (word=='') break;
         _lbadd_item(word);
      }
   }
   tree_option='';
   for (;;) {
      word = parse_file(files);
      if (word=='') break;
      ch=substr(word,1,1);
      if (ch=='-' || ch=='+') {
         option=upcase(substr(word,2));
         switch (option) {
         case 'T':
            if (ch=='-') {
               tree_option='';
            } else {
               tree_option='+t';
            }
            break;
         default:
            p_buf_id=orig_hidden_buf_id;
            activate_view orig_view_id;_set_focus();
            _message_box('Invalid switch')
            return(1)
         }
      } else {
         if (file_match('-pd 'tree_option' 'word,1)!='') {
             bottom;
             insert_file_list('-v +p 'tree_option' ':+word);
             status=down();_begin_line
         } else if (!iswildcard(word)) {
            p_buf_id=orig_hidden_buf_id;
            activate_view orig_view_id;_set_focus();
            _message_box(nls('File "%s" not found',word))
            return(1)
         }
      }
   }
   top;up();
   return(0);
}

#define LIST_FILES_ONLY 1
#define MODELESS_DIALOG_BOX 2
#define MDICHILD  3

defeventtab _search_options_form
void _ctlso_ok.on_create()
{
   if (def_persistent_select!='D') {
      _ctlso_leave_selected.p_enabled=0;
   }
   /*Get Search Options*/
   search_options = _default_option('S');
   _ctlso_match_case.p_value = (int)!(search_options & IGNORECASE_SEARCH);
   _ctlso_re.p_value         = search_options & (RE_SEARCH|UNIXRE_SEARCH|BRIEFRE_SEARCH);
   _ctlso_wrap.p_value       = search_options & WRAP_SEARCH;
   _ctlso_restore_cursor.p_value   = (int)(def_restore_cursor!=0);
   _ctlso_leave_selected.p_value   = (int)(def_leave_selected!=0);
   if ( def_re_search == RE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 1;
      _ctlso_resyntax_unix.p_value = 0;
      _ctlso_resyntax_brief.p_value = 0;
   } else if ( def_re_search == UNIXRE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 0;
      _ctlso_resyntax_unix.p_value = 1;
      _ctlso_resyntax_brief.p_value = 0;
   } else if ( def_re_search == BRIEFRE_SEARCH ) {
      _ctlso_resyntax_slick.p_value = 0;
      _ctlso_resyntax_unix.p_value = 0;
      _ctlso_resyntax_brief.p_value = 1;
   }
   if (def_mffind_style==MODELESS_DIALOG_BOX) {
      _ctlso_mfout_dialog.p_value=1;
   }else if (def_mffind_style==LIST_FILES_ONLY) {
      _ctlso_mfout_filesonly.p_value=1;
   }else if (def_mffind_style==MDICHILD) {
      _ctlso_mfout_mdichild.p_value=1;
   }
   if (def_mfsearch_init_flags&MFSEARCH_INIT_HISTORY) {
      _ctlso_init_retrieve.p_value=1;
   }else if (def_mfsearch_init_flags&MFSEARCH_INIT_CURWORD) {
      _ctlso_init_curword.p_value=1;
   }
   if (def_mfsearch_init_flags&MFSEARCH_INIT_SELECTION) {
      _ctlso_init_selection.p_value=1;
   }
}

void _ctlso_ok.lbutton_up()
{
   /*Set Search Options*/
   search_options = 0;
   if ( _ctlso_resyntax_slick.p_value ) {
      def_re_search=RE_SEARCH;
   } else if ( _ctlso_resyntax_unix.p_value ) {
      def_re_search=UNIXRE_SEARCH;
   } else if ( _ctlso_resyntax_brief.p_value ) {
      def_re_search=BRIEFRE_SEARCH;
   }
   if (!_ctlso_match_case.p_value) {
      search_options |= IGNORECASE_SEARCH;
   }
   if (_ctlso_re.p_value) {
      search_options |= def_re_search;
   }
   if (_ctlso_wrap.p_value) {
      search_options |= WRAP_SEARCH;
   }
   def_restore_cursor = _ctlso_restore_cursor.p_value!=0;
   def_leave_selected = _ctlso_leave_selected.p_value;
   _default_option('S', search_options);
   _macro_call('_default_option','S', search_options);
   if (_ctlso_mfout_dialog.p_value) {
      def_mffind_style=MODELESS_DIALOG_BOX;
   }else if (_ctlso_mfout_filesonly.p_value) {
      def_mffind_style=LIST_FILES_ONLY;
   }else if (_ctlso_mfout_mdichild.p_value) {
      def_mffind_style=MDICHILD;
   }
   def_mfsearch_init_flags=0;
   if (_ctlso_init_retrieve.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_HISTORY;
   } else if (_ctlso_init_curword.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_CURWORD;
   }
   if (_ctlso_init_selection.p_value) {
      def_mfsearch_init_flags|=MFSEARCH_INIT_SELECTION;
   }
   if ( _ctlso_resyntax_slick.p_value ) {
      def_re_search=RE_SEARCH;
      _macro_append("def_re_search=RE_SEARCH;");
   } else if ( _ctlso_resyntax_unix.p_value ) {
      def_re_search=UNIXRE_SEARCH;
      _macro_append("def_re_search=UNIXRE_SEARCH;");
   } else if ( _ctlso_resyntax_brief.p_value ) {
      def_re_search=BRIEFRE_SEARCH;
      _macro_append("def_re_search=BRIEFRE_SEARCH;");
   }
   _config_modify|=CFGMODIFY_DEFVAR|CFGMODIFY_OPTION;
   p_active_form._delete_window();
}
defeventtab _qmffind_form
void ctlyes.lbutton_up()
{
   p_active_form._end_modal_wait("y");
}
void ctlno.lbutton_up()
{
   p_active_form._delete_window("");
}
void ctlglobal.lbutton_up()
{
   p_active_form._end_modal_wait("g");
}
void ctlnextfile.lbutton_up()
{
   p_active_form._end_modal_wait("n");
}
