/*
$VerboseHistory: mouse.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:42a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:42a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
static _str _chg_count=DEF_FS_CHG_COUNT
static int _max_skip=1
static _str _last_fast_event
_str def_click_past_end;
static _str movecopy_selection

_command void fast_scroll() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if (p_cb) p_window_id=p_cb_list_box
   if (last_event()==ON_SB_END_SCROLL) {
      _chg_count=DEF_FS_CHG_COUNT
      _max_skip=1
      _last_fast_event=''
      return
   }
   --_chg_count;
   if ( _chg_count<=0 ) {
      _chg_count=DEF_FS_CHG_COUNT;
      _max_skip=_max_skip+DEF_FS_INC_MAX_SKIP_BY;
      if ( _max_skip>DEF_FS_MAX_SKIP ) {
         _max_skip=DEF_FS_MAX_SKIP;
      }
   }
   if (_last_fast_event:=='') {
      _last_fast_event=last_event()
   }
   for (i=1;i<=_max_skip;++i) {
      switch (_last_fast_event) {
      case on_vsb_line_down:
         _scroll_page('d',1)
         break;
      case on_vsb_line_up:
         _scroll_page('u',1)
         break;
      case on_hsb_line_up:
         _sb_line_left()
         break;
      case on_hsb_line_down:
         _sb_line_right()
         break;
      }
   }
}
#if 0
defc mou_split_window
   check_windows('0')
#endif
void _set_scroll_speed(var init_delay,var skip_count,var count,int mx,int my)
{

   if (my<p_windent_y) {
      diff_y= -my-p_windent_y;
   } else if (my>=p_client_height){
      diff_y=my-p_client_height;
   } else {
      return;
   }
   parse def_scroll_speeds with s1 s2 s3 s4 .
   diff_y=_dy2ly(SM_TWIP,diff_y);
   if (diff_y<=200) {
      speed=s1
   } else if (diff_y<=400) {
      speed=s2
   } else if (diff_y<=600) {
      speed=s3
   } else {
      speed=s4
   }
   parse speed with init_delay '.' skip_count
   count=99999
}
static _str selectNscroll(var mark_name,mstyle,orig_col,lastkey_not_rbutton,mx,my,wx,wy,select_words)
{
   /* we are outside the window. */
   /* Determine which side of window we are outside. */
   set_scroll_directions(past_bottom,past_right,past_top,past_left,new_x,new_y,mx,my);
   _SelectToCursor(mark_name,mstyle,new_x,new_y,select_words,movecopy_selection,past_bottom,past_right,past_top,past_left);
   init_delay=def_init_delay
   max_skip=1
   count=DEF_CHG_COUNT
   _set_scroll_speed(init_delay,max_skip,count,mx,my);

   skip_count=0
   if ( machine()=='NT386' || machine()=='NTMIPS' ) {
      max_skip=2
   }
   NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
   _set_timer init_delay
   for (;;) {
      event=ON_TIMER
      ++skip_count
      no_skip=skip_count>=max_skip   //  || test_event('r'):!='')
      if ( no_skip ) {
         event=get_event('k')
         skip_count=0
      }
      if (event:==ON_TIMER) {
         --count;
         if ( count<=0 ) {
            count=DEF_CHG_COUNT
#if 0
            if ( init_delay>DEF_MIN_DELAY ) {
               init_delay=init_delay-DEF_DEC_DELAY_BY
            } else {
               init_delay=DEF_MIN_DELAY
            }
#endif
            max_skip=max_skip+DEF_INC_MAX_SKIP_BY
            if ( max_skip>DEF_MAX_SKIP ) {
               max_skip=DEF_MAX_SKIP
            }
         }
      } else if ( event:==MOUSE_MOVE ) {
         // Mapping coordinates under UNIX is VERY VERY slow.
         // Here were reduce the number of calls a lot.
         mx=mou_last_x('D');my=mou_last_y('D');
         mx-=wx;my-=wy;
         if ( mou_in_window3(mx,my) ) {
            _SelectToCursor(mark_name,mstyle,mx,my,select_words,movecopy_selection)
            _kill_timer
            return(0)
         }
         set_scroll_directions(past_bottom,past_right,past_top,past_left,new_x,new_y,mx,my)
         _SelectToCursor(mark_name,mstyle,new_x,new_y,select_words,select_words,movecopy_selection)
         _set_scroll_speed(init_delay,max_skip,count,mx,my);
         _set_timer init_delay
      } else if ( !movecopy_selection && lastkey_not_rbutton && any_rbutton(event) ) {
         if ( mark_name=='CHAR' ) {
            mark_name='BLOCK'
            switch_select_type(mark_name,'',orig_col)
         } else if ( mark_name=='BLOCK' ) {
            mark_name='LINE'
            switch_select_type(mark_name,'',orig_col)
         } else if ( mark_name=='LINE' ) {
            mark_name='CHAR'
            switch_select_type(mark_name,'',orig_col)
         }
      } else if ( !movecopy_selection && lastkey_not_rbutton && event:==RBUTTON_UP ) {
      } else {
         _kill_timer
         return(1)
      }
      down_rc=0
      if (p_hex_mode) {
         offset=_nrseek();
         if ( past_bottom ) {
            temp=offset+NofbytesPerLine;
            if (temp>p_buf_size) {
               temp-=NofbytesPerLine;
               down_rc=BOTTOM_OF_FILE_RC;
            } else {
               _nrseek(temp);
            }
         }
         if ( past_top ) {
            temp=offset-NofbytesPerLine;
            if (temp<0) temp=0;
            _nrseek(temp);
         }
         if ( past_right ) {
            LineOfs=offset%NofbytesPerLine;
            if (LineOfs<NofbytesPerLine-1) {
               _nrseek(offset+1);
            }
         }
         if ( past_left ) {
            p_cursor_x=0;
         }
         if ( down_rc && ! past_left ) {
            /* save_pos(p); */
            _nrseek(p_buf_size);
            if (!movecopy_selection) {
               select_it(mark_name,'',mstyle)
            }
            /* restore_pos(p) */
         } else {
            if (!movecopy_selection) select_it(mark_name,'',mstyle)
         }
      } else {
         if ( past_bottom ) {
            down_rc=cursor_down()
         }
         if ( past_top ) {
            cursor_up();
            if (!movecopy_selection && _on_line0() ) {
               cursor_down();
            }
         }
         if ( past_right ) {
            right
         }
         if ( past_left ) {
            _refresh_scroll
            p_cursor_x=0;
            left
         }
         if ( down_rc && ! past_left ) {
            /* save_pos(p); */
            end_line()
            if ( ! p_buf_width ) {
               p_col=p_col+1
            }
            if (!movecopy_selection) {
               if (select_words) {
                  select_more_words(mstyle,-1,-1,past_bottom,past_right,past_top,past_left);
               } else {
                  select_it(mark_name,'',mstyle);
               }
            }
            /* restore_pos(p) */
         } else {
            if (!movecopy_selection) {
               if (select_words) {
                  select_more_words(mstyle,-1,-1,past_bottom,past_right,past_top,past_left);
               } else {
                  select_it(mark_name,'',mstyle);
               }
            }
         }
      }
   }

}
#if 0
// This is built-in to C code now
static mou_create_window()
{
   selected_wid=orig_wid=p_window_id;

   p_window_id=p_xyparent;
   DrawOnWid=p_window_id;

   _save_draw_setup(draw_setup);

   p_fill_style=PSFS_TRANSPARENT;
   p_draw_width=1;
   p_draw_style=PSDS_DOT;
   p_draw_mode=PSDM_XORPEN
   if (machine()=='OS2386') {
      color=_rgb(0xcc,0xcc,0xcc);
   } else {
      color=_rgb(0x80,0x80,0x80)  /* Gray */
   }

   mou_mode(1);
   mou_capture();
   morig_x=mou_last_x('M');morig_y=mou_last_y('M');

   rectangle_drawn=0;
   done=0;

   orig_x=morig_x;orig_y=morig_y;
   orig_width=0;orig_height=0;

   x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
   orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
   smallest_width=1300;
   smallest_height=700;
   _lxy2lxy(SM_TWIP,p_scale_mode,smallest_width,smallest_height);
   for (;;) {
       event=get_event('k');
       p_window_id=DrawOnWid;
       switch (event) {
       case MOUSE_MOVE:
           new_x1=x1;new_y1=y1;new_x2=x2;new_y2=y2;
           // Size the right corner of the window
           new_x2=mou_last_x('M');
           new_y2=mou_last_y('M');
#if 0
           if (new_x2-new_x1<smallest_width) {
              new_x1=x1;new_x2=x2;
           }
           if (new_y2-new_y1<smallest_height) {
             new_y1=y1;new_y2=y2;
           }
#endif
           if (rectangle_drawn) {

              if (x1==new_x1 && y1==new_y1 && x2==new_x2 && y2==new_y2) {
                  break;
              }
              /* Erase the rectangle. */
              _draw_rect(x1,y1,x2,y2,color/*,'e'*/);
           }
            rectangle_drawn=1;
            x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
            _draw_rect(x1,y1,x2,y2,color/*,'e'*/);
            break;
       case LBUTTON_UP:
       case RBUTTON_UP:
       case MBUTTON_UP:
       case ESC:
           done=1
       }
       if( done) break;
   }
   mou_mode(0);
   mou_release();
   if (rectangle_drawn) {

      /* Erase the rectangle. */
      _draw_rect(x1,y1,x2,y2,color/*,'e'*/);
   }
   _restore_draw_setup(draw_setup);
   selected_wid._get_window(new_x,new_y,new_width,new_height);

   // MDI child windows coordinates are relative to the client area. */
   // Adjust coordinates by top_height and left_width */
   th=0;
   lw=0;
   x1-=lw;x2-=lw;
   y1-=th;y2-=th;
   if (x2<x1) {
      temp=x1;x1=x2;x2=temp;
   }
   if (y2<y1) {
      temp=y1;y1=y2;y2=temp;
   }
   width=x2-x1;height=y2-y1;
   if (event:!=ESC && width>=smallest_width && height>=smallest_height) {
      if (_no_child_windows()) {
         load_options="";def_load_options;
         buffer_option='+t';
      } else {
         load_options='';
         buffer_option='+bi '_mdi.p_child.p_buf_id;
      }
      p_window_id=_mdi.p_child;
      status=load_files(load_options" +i:"(x1)" "y1" "width" "height" n +c "buffer_option);
      if (buffer_option=='+t') {
         select_edit_mode();
      }
   } else {
      p_window_id=orig_wid;
   }
   return(0);
}
#endif
_command int mou_paste() name_info(','VSARG2_NOEXIT_SCROLL|VSARG2_REQUIRES_EDITORCTL|VSARG2_TEXT_BOX)
{
   if (command_state()) {
      col=mou_col(mou_last_x())
      line=p_text
      if (col-1>length(line)) {
         col=length(line)+1
      }
      _set_sel col
   } else {
      if (p_scroll_left_edge>=0) {
         parse _scroll_page() with line_pos down_count
         goto_point line_pos
         down down_count
         set_scroll_pos p_scroll_left_edge,0
         p_scroll_left_edge= -1
      }
      // X Windows is slow at mapping window coordinates
      mx=mou_last_x('D');my=mou_last_y('D');
      _map_xy(0,p_window_id,mx,my);
      p_cursor_y=my;
      p_cursor_x=mx;
      if (/*!def_click_past_end && */_select_type()!='BLOCK') {
         if (p_col>_text_colc()) _end_line();
      }
   }
   _cvtautoclipboard();
   status=paste();
   return(status);
}
_command void mou_copy_to_cursor(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   movecopy_option=arg(1);  // Can be "M", "C", or ""
   if (movecopy_option=="") {
      movecopy_option="C";
   }
   if (_select_type()=='' /*!select_active2()*/) {
      message(get_message(TEXT_NOT_SELECTED_RC));
      return;
   }
   _get_selinfo(first_col,last_col,buf_id);
   doSmartPaste=false;
   if (p_buf_id==buf_id) {
      doSmartPaste=true;
      lock_selection('0');
   }

   if (p_scroll_left_edge>=0) {
      parse _scroll_page() with line_pos down_count
      goto_point line_pos
      down down_count
      set_scroll_pos p_scroll_left_edge,0
      p_scroll_left_edge= -1
   }
   p_cursor_y=mou_last_y()
   p_cursor_x=mou_last_x()
   _copy_or_move('',
                 movecopy_option /* Copy the selection. */,
                 doSmartPaste/* do smart paste. */);
   if (def_deselect_paste) {
      _deselect();
   }
}
_command void mou_move_to_cursor() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   mou_copy_to_cursor('M');
}
_command int mou_click_copy() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_NOEXIT_SCROLL)
{
   return(mou_click('','C'));
}

//def "mouse_move"=
/*
def "mouse_move"=mymouse_move

void mymouse_move()
{
   word=_MouCurWord(mou_last_x(),mou_last_y(),
               false,
               1,
               PhysicalStartCol,
               0)  //  int option /* 1 from cursor, 2- end prev word*/)
   message('word='word);
}
*/

_str _MouCurWord(int x,int y,boolean XYAreInScreenCoordinates,
                 int MaybeReturnSelectedText,
                 int &PhysicalStartCol,
                 int option /* 1 from cursor, 2- end prev word*/)
{
   //say('MaybeReturnSelectedText='MaybeReturnSelectedText);
   if(XYAreInScreenCoordinates) {
      _map_xy(0,p_window_id,x,y);
   }
   save_pos(p);
   p_cursor_y=y;
   p_cursor_x=x;

   mark_locked=0;
   if (_select_type('','S')=='C') {
      mark_locked=1;
      _select_type('','S','E');
   }

   // IF we are past the end of line OR
   //    NOT
   //       the character under the cursor is not a word character OR
   //       the cursor is in a selection which is only one line
   in_selection=MaybeReturnSelectedText && (mou_in_selection(x,y) && count_lines_in_selection()==1);
   //say('in_selection='mou_in_selection(x,y));
   if (p_col>=_text_colc() || 
       !( pos('[\od'p_word_chars']',get_text(1),1,'r') ||
          in_selection
        )
      ) {
      result="";
   } else if (in_selection) {
      _get_selinfo(start_col,end_col,buf_id);
      //say('start_col='start_col' end_col='end_col);
      result=_expand_tabsc(start_col,end_col-start_col,'S');
   } else {
      from_cursor=option==1;
      end_prev_word=option==2;
      result=cur_word(PhysicalStartCol,from_cursor,end_prev_word);
   }
   restore_pos(p);
   if (mark_locked) {
      _select_type('','S','C');
   }
   return(result);
}
/*
   This function is called by windows drag drop dll
*/
void _scroll(boolean past_left,boolean past_top, boolean past_right, boolean past_bottom)
{
   //say('past_bottom='past_bottom);
   down_rc=0
   if (p_hex_mode) {
      NofbytesPerLine=p_hex_Nofcols*HEX_CHARSPERCOL;
      offset=_nrseek();
      if ( past_bottom ) {
         temp=offset+NofbytesPerLine;
         if (temp>p_buf_size) {
            temp-=NofbytesPerLine;
            down_rc=BOTTOM_OF_FILE_RC;
         } else {
            _nrseek(temp);
         }
      }
      if ( past_top ) {
         temp=offset-NofbytesPerLine;
         if (temp<0) temp=0;
         _nrseek(temp);
      }
      if ( past_right ) {
         LineOfs=offset%NofbytesPerLine;
         if (LineOfs<NofbytesPerLine-1) {
            _nrseek(offset+1);
         }
      }
      if ( past_left ) {
         p_cursor_x=0;
      }
      if ( down_rc && ! past_left ) {
         /* save_pos(p); */
         _nrseek(p_buf_size);
         //if (!movecopy_selection) select_it(mark_name,'',mstyle)
         
      } else {
         //if (!movecopy_selection) select_it(mark_name,'',mstyle)
      }
   } else {
      if ( past_bottom ) {
         down_rc=cursor_down()
      }
      if ( past_top ) {
         cursor_up();
         //if (!movecopy_selection && _on_line0() ) {
         //   cursor_down();
         //}
      }
      if ( past_right ) {
         right
      }
      if ( past_left ) {
         _refresh_scroll
         p_cursor_x=0;
         left();
      }
      if ( down_rc && ! past_left ) {
         end_line()
         if ( ! p_buf_width ) {
            p_col=p_col+1
         }
         /*if (!movecopy_selection) {
            if (select_words) {
               select_more_words(mstyle,-1,-1);
            } else {
               select_it(mark_name,'',mstyle);
            }
         }
         */
      } else {
         /*if (!movecopy_selection) {
            if (select_words) {
               select_more_words(mstyle,-1,-1);
            } else {
               select_it(mark_name,'',mstyle);
            }
         }
         */
      }
   }
}
int _isDragDrop(int mx,int my)
{
   mou_mode(1);
   mou_capture();
   cxdragmin= _default_option(VSOPTION_CXDRAGMIN);
   cydragmin= _default_option(VSOPTION_CYDRAGMIN);
   //say(' dx='cxdragmin' 'cydragmin);
   //mx=mou_last_x('D');my=mou_last_y('D');
   //say('wx='wx' 'wy' mx='mx);
   _set_timer(_default_option(VSOPTION_DRAGDELAY));
   doDragDrop=false;
   for (;;) {
       event=get_event('k');
       if ( event:==MOUSE_MOVE ) {
          //say('cc');
          // Mapping coordinates under UNIX is VERY VERY slow.
          // Here were reduce the number of calls a lot.
          tx=mou_last_x();ty=mou_last_y();
          tx-=mx;y=ty-=my;
          if (abs(tx)>=cxdragmin || abs(ty)>=cydragmin) {
             //say('h1 tx='tx' ty='ty' dx='cxdragmin' wx='wx' 'wy);
             doDragDrop=true;
             break;
          }
       } else if (event:==ON_TIMER) {
          //say('h2');
          doDragDrop=true;
          break;
       } else {
          break
       }
   }
   _kill_timer();
   mou_mode(0)
   mou_release();
   return(doDragDrop);
}
_command int mou_click(_str mark_name="",
                       _str option="",  /* C, M, or E  == Copy, Move, Extend */
                       boolean select_words=false) name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_NOEXIT_SCROLL)
{
#if 0
   if (_select_type('','S')=='C') {
      say('mou_click');
      mark_locked=1;
      _select_type('','S','E');
      stop
   }
#endif
   copytext_option=upcase(option)=='C';
   menu_option=upcase(option)=='M';
   extend_mark_option=upcase(option)=='E';
   //select_words=upcase(arg(3))=='W';
   // If we are extending the selection and last cua selection was a word selection.
   if (extend_mark_option && _cua_select==2) {
      select_words=1;
   }
   lastkey_not_rbutton=! any_rbutton(last_event())
   if ( command_state() ) {
      // Assume that retrieve_prev_form/next_form called
      get_view_id(view_id);
      activate_view(RETRIEVE_VIEW_ID);
      bottom();
      activate_view(view_id);
      mou_command_click(extend_mark_option)
      return(1);
   }
   // Mapping coordinates under UNIX is VERY VERY slow.
   // Here were reduce the number of calls a lot by getting the mouse
   // coordinates relative the screen and mapping top left corner of
   // client window.
   mx=mou_last_x('D');my=mou_last_y('D');
   wx=wy=0;_map_xy(p_window_id,0,wx,wy);
   mx-=wx;my-=wy;

   if (p_mdi_child && p_window_state=='I') {
      if (extend_mark_option) return(2);
      //mou_create_window();
      return(3);
   }
   save_pos(orig_pos);
   mark_locked=0;
   if (!extend_mark_option) {
      if (_select_type('','S')=='C') {
         mark_locked=1;
         _select_type('','S','E');
      }
   }
   if (!extend_mark_option && !mou_in_window()) {
      if (_isEditorCtl()) {
         if(!mou_debugbitmap(1+((select_words)?1:0))) {
            if (mark_locked) {
               _select_type('','S','C');
            }
            return(4);
         }
      }
   }
   if (!extend_mark_option && def_seldisp_single && (!mou_in_window())) {
      if (_isEditorCtl()) {
         if(!mou_plusminus()) {
            if (mark_locked) {
               _select_type('','S','C');
            }
            return(4);
         }
      }
   }


   if (_macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   init_mark=! extend_mark_option || ! select_active()

   if (extend_mark_option && !init_mark) {
      save_pos(p);
      if (substr(_select_type('','p'),1,1)=='B') {
         _begin_select()
      } else {
         _end_select()
      }
      orig_col=p_col;
      restore_pos(p);
   }
   old_scroll_style=_scroll_style()
   _scroll_style('s 0')
   if ( command_state() ) {
      cursor_data();
   }
   persistant=(def_persistent_select=='Y')?'P':'';
   //mstyle='CN'persistant;
   if ( pos('C',def_select_style) && def_persistent_select!='Y' ) {
      mstyle='CN';
   } else {
      mstyle='EN';
   }
   in_left_margin=0;
   mark_name=upcase(mark_name);
   if ( mark_name=='' ) {
      if (!extend_mark_option && mx<p_windent_x) {
         in_left_margin=1;
         mark_name='LINE'
      } else {
         mark_name='CHAR'
      }
   }
   if (p_scroll_left_edge>=0) {
      scroll_info=_scroll_page();
      if (extend_mark_option && !select_active()) {
         _deselect();
         if (select_words) {
            select_whole_word();
         } else {
            select_it(mark_name,'','CN')
         }
      }
      //p_scroll_left_edge= -1;

      parse scroll_info with line_pos down_count;
      goto_point(line_pos);
      down(down_count);
      set_scroll_pos(p_scroll_left_edge,0);
      p_scroll_left_edge= -1;
   }
   if ( extend_mark_option ) {
      if ( select_active() ) {
         mark_name=_select_type()
      } else {
         _deselect();
         if (select_words) {
            select_whole_word();
         } else {
            select_it(mark_name,'','CN')
         }
      }
      if (select_words) {
         select_more_words(mstyle,mx,my);
      } else {
         p_cursor_y=my;
         p_cursor_x=mx;
         select_it(mark_name,'','CN')
      }
   } else {
      p_cursor_y=my;
      p_cursor_x=mx;
   }
   movecopy_selection=0;
   if (!select_words && def_dragdrop && !in_left_margin && !p_hex_mode && !extend_mark_option && !menu_option &&
      mou_in_selection(mou_last_x(),mou_last_y()) && 
       (!_QReadOnly() || ((machine()=='NT386' && _win32s()!=1)))
      ) {
      if (machine()=='NT386' && _win32s()!=1) {
         if (!_isDragDrop(mx,my)) {
            // IF this is a mark start with shift-arrow keys or mouse and */
            // marks are not persistant  OR  menu_option given
            if ( (_cua_select && def_persistent_select!='Y') || menu_option
               // OR the mark is a locked persistant mark
               // || (! _cua_select && _select_type('','U')=='P' && _select_type('','s')=='E')
            ) {
               _deselect();
            }
         } else {
#define	DROPEFFECT_NONE	( 0 )
#define	DROPEFFECT_COPY	( 1 )
#define	DROPEFFECT_MOVE	( 2 )
#define	DROPEFFECT_LINK	( 4 )
#define	DROPEFFECT_LOCAL  0x8000
#define	DROPEFFECT_SCROLL	( 0x80000000 )
            old=def_autotag_flags2;
            status=_DragDropStart(p_window_id);
            def_autotag_flags2=old;

            if (status!=DROPEFFECT_NONE) {
               if ((status & DROPEFFECT_MOVE) &&
                    !(status &DROPEFFECT_LOCAL) &&
                   !_QReadOnly()
                   ) {
                  begin_select();
                  _delete_selection();
               }
            } else {
               if (mark_locked) {
                  _select_type('','S','C');
               }
               restore_pos(orig_pos);
            }
         }
         if (_isnull_selection()) {
            _cua_select=1;
         }
         return(1);

      }
      old_mouse_pointer=p_mouse_pointer;
      movecopy_selection=1;
      save_pos(orig_pos);
      blank_inserted=0;
      if (_select_type()!='LINE' || def_line_insert=='B') {
         // Want to allow user to copy/move past end of buffer.
         old_modify=p_modify;
         bottom;
         if (!p_buf_width && _line_length()==_line_length(1)) {
            if (p_buf_width) {
               insert_line('');
               blank_inserted=1;
            } else {
               // For now don't allow insert after EOF character.
               blank_inserted=0;
            }
         } else {
            insert_line('');
            _delete_text(2); // Delete NLChars
            blank_inserted=1;
         }
         restore_pos(orig_pos);
         if (!old_modify) p_modify=0;
      }
#if 0
      mark_locked2=0;
      if (mark_locked) {
         mark_locked2=1;
         // Lock the selection so we can move the cursor without
         // changing the selection
         _begin_select();
         //if (_select_type('','S')=='E') {
         stop;say("got here");
         
         restore_pos(orig_pos);
         _end_select();restore_pos(orig_pos);
      }
#endif
      p_cursor_y=my
      p_cursor_x=mx;
      save_pos(orig_pos);
      mou_mode(1)
      mou_release;
      p_mouse_pointer=MP_MOVETEXT;
      mou_capture
      p_mouse_pointer=MP_MOVETEXT;
      if (copytext_option) {
         message nls('Copy selected text to new location')
      } else {
         message nls('Move selected text to new location')
      }
      // Turn off cursor blink
      _default_option('k',0);
      for (;;) {
          event=get_event('k');
          if ( event:==MOUSE_MOVE ) {
             // Mapping coordinates under UNIX is VERY VERY slow.
             // Here were reduce the number of calls a lot.
             mx=mou_last_x('D');my=mou_last_y('D');
             mx-=wx;my-=wy;
             // This code has gotten more complicated to handle BLOCK marks and menus better
             if ( mou_in_window3(mx,my) ) {
                _SelectToCursor(mark_name,mstyle,mx,my,select_words,movecopy_selection)
             } else {
                done=selectNscroll(mark_name,mstyle,orig_col,lastkey_not_rbutton,mx,my,wx,wy,select_words)
                if ( done ) {
                   break
                }
             }
          } else {
             break
          }
      }
      // Turn on cursor blink
      _default_option('k',1);
      clear_message
      mou_mode(0)
      mou_release
      _scroll_style(old_scroll_style)
      p_mouse_pointer=old_mouse_pointer;
      switch (last_event()) {
      case LBUTTON_UP:
      case RBUTTON_UP:
      case MBUTTON_UP:
         in_selection=mou_in_selection(mou_last_x(),mou_last_y());
         do_delete=0;
         if (blank_inserted) {
            if (in_selection) {
               old_modify=p_modify;
               bottom();_delete_line();
               restore_pos(orig_pos);
               p_modify=old_modify;
            } else {
               if (_select_type()=='LINE') {
                  do_delete=1;
               } else {
                  typeless p;
                  save_pos(p);
                  status=down();
                  if (!status) {
                     up();
                     do_delete=1;
                  }
                  restore_pos(p);
               }
            }
         }
         if (in_selection) {
            /*if (mark_locked) {
               _select_type('','S','C');
            } */
            _deselect();
            _cua_select=1;
            return(0);
         }
         if (copytext_option) {
            status=_copy_or_move('','C',1 /* smart paste*/ ,0 /* no deselect */);
         } else {
            status=_copy_or_move('','M',1 /* smart paste*/ ,0 /* no deselect */);
         }
         _end_select()
         if (do_delete) {
            save_pos(p);
            bottom;_delete_line();
            restore_pos(p);
         }
         if (def_deselect_paste) {
            _deselect();
            _cua_select=1;
         } else {
            if (mark_locked) {
               _select_type('','S','C');
            }
            /*if (mark_locked2) {
               select_it(_select_type(),'',_select_type('','I'):+_select_type('','U'):+'C')
            } */
         }
         return(0);
      }
      if (blank_inserted) {
         bottom;_delete_line();
      }
      // Operation cancelled
      restore_pos(orig_pos);
      if (mark_locked) {
         _select_type('','S','C');
      }
      /*if (mark_locked2) {
         select_it(_select_type(),'',_select_type('','I'):+_select_type('','U'):+'C')
      } */
      return(1);
   }
   if (mark_locked) {
      _select_type('','S','C');
   }
#if 0
   if (!(select_words && extend_mark_option)) {
      p_cursor_y=my;
      p_cursor_x=mx;
   }
#endif
   if (!def_click_past_end && _select_type()!='BLOCK' && mark_name!='BLOCK') {
      if (p_col>_text_colc()) _end_line();
   }
   mou_mode(1)
   mou_release;mou_capture

   if ( ! extend_mark_option ) {
      // IF this is a mark start with shift-arrow keys or mouse and */
      // marks are not persistant  OR  menu_option given
      if ( (_cua_select && def_persistent_select!='Y') || menu_option
         // OR the mark is a locked persistant mark
         // || (! _cua_select && _select_type('','U')=='P' && _select_type('','s')=='E')
      ) {
         _deselect
      }
   }
   if (init_mark && select_words) {
      select_whole_word(mstyle);
      init_mark=0;
      _cua_select=2;   // Indicate that we are in word select mode. Need to know this
                       // so Shift+LbuttonDown extends selection using words.
   }
   if (in_left_margin) {
      p_cursor_y=my;
      p_cursor_x=mx;
      _deselect;select_it(mark_name,'',mstyle)
      initmark=0;
   }
   if (select_words) {
      // Turn off cursor blink
      _default_option('k',0);
   }

   for (;;) {
       event=get_event('k')
       if ( event:==MOUSE_MOVE ) {
          // This code has gotten more complicated to handle BLOCK marks and menus better
          old_init_mark=init_mark;
          if ( init_mark ) {
             init_mark=0;
             _deselect;
             select_it(mark_name,'',mstyle)
          }
          // Mapping coordinates under UNIX is VERY VERY slow.
          // Here were reduce the number of calls a lot.
          mx=mou_last_x('D');my=mou_last_y('D');
          mx-=wx;my-=wy;
          if ( mou_in_window3(mx,my) ) {
             if (old_init_mark && mark_name!='LINE') {
                old_cursor_y=p_cursor_y;
                old_cursor_x=p_cursor_x;
                _SelectToCursor(mark_name,mstyle,mx,my,select_words,movecopy_selection);
                if (old_cursor_y==p_cursor_y && old_cursor_x==p_cursor_x &&
                   mx>p_cursor_x-(p_font_width intdiv 2) && mx<p_cursor_x+(p_font_width intdiv 2)) {
                   init_mark=1;old_init_mark=0;
                   _deselect();
                }
             } else {
                _SelectToCursor(mark_name,mstyle,mx,my,select_words,movecopy_selection);
             }
             if (old_init_mark) {
                orig_col=p_col
                _cua_select=1
                last_index(find_index('cua-select',COMMAND_TYPE))
             }
          } else {
             if (old_init_mark) {
                orig_col=p_col
                _cua_select=1
                last_index(find_index('cua-select',COMMAND_TYPE))
             }
             done=selectNscroll(mark_name,mstyle,orig_col,lastkey_not_rbutton,mx,my,wx,wy,select_words);
             if ( done ) {
                break
             }
          }
       } else if ( lastkey_not_rbutton && any_rbutton(event) && ! init_mark ) {
          if ( mark_name=='CHAR' ) {
             mark_name='BLOCK'
             switch_select_type(mark_name,'',orig_col)
          } else if ( mark_name=='BLOCK' ) {
             mark_name='LINE'
             switch_select_type(mark_name,'',orig_col)
          } else if ( mark_name=='LINE' ) {
             mark_name='CHAR'
             switch_select_type(mark_name,'',orig_col)
          }
       } else if ( lastkey_not_rbutton && event:==RBUTTON_UP ) {
       } else {
          break
       }
   }
   if (select_words) {
      // Turn on cursor blink
      _default_option('k',1);
      // Maybe unlock selection
      select_it(mark_name,'',mstyle);
   }
   if (_isnull_selection()) {
      _cua_select=1;
      _deselect();
      if (!def_click_past_end) {
         if (p_col>_text_colc()) _end_line();
      }
   }
   _autoclipboard();
   mou_mode(0);
   mou_release();
   _scroll_style(old_scroll_style)
   return(0);
}
static void select_more_words(_str mstyle, int new_x,int new_y,
                              boolean past_bottom=false,boolean past_right=false,
                              boolean past_top=false,boolean past_left=false)
{
   _get_selinfo(start_col,end_col,buf_id);
   bool1=(_begin_select_compare()==0 && p_col==start_col);
   save_pos(p);
   bool2=_end_select_compare()>0 || (_end_select_compare()==0 && p_col>=end_col);
   bool3=_begin_select_compare()<0 || (_begin_select_compare()==0 && p_col<start_col);
   // Try to extend word selection
   _select_char('','EN');  // lock the selection so we can compare selection
                           // to cursor position
   if (new_y>=0) {
      p_cursor_y=new_y;
      p_cursor_x=new_x;
   }
   search_direction='+';
   search_direction2='-';
   if (past_top || (past_left && !past_bottom)) {
      search_direction='-';
      search_direction2='+';
   }
   // IF cursor is after selection
   if (bool2) {
      save_pos(p2);
      _begin_select();_deselect();_select_char('','EN');
      restore_pos(p2);
      // Select more words after selection
      // Search for beginning of next word
      status=search('[\od'p_word_chars"]","sr@"search_direction);
      if (!status) {
         // Search for end of word
         status=search('[~\od'p_word_chars"]|$","sr@"search_direction);
         if (status) _end_line();
      }
      _select_char('',mstyle);
   } else if (bool3) {
      save_pos(p2);
      _end_select();_deselect();_select_char('','EN');
      restore_pos(p2);
      // Select more words before selection
      // Search for end of previous word.
      status=search('[\od'p_word_chars"]","sr@"search_direction2);
      if (!status) {
         // Search for beginning of word
         status=search('[~\od'p_word_chars"]|^","sr@>"search_direction2);
         if (status) _end_line();
      }
      _select_char('',mstyle);
   } else {
      // We are inside the selection
      if(bool1) {
         save_pos(p2);
         _end_select();_deselect();_select_char('','EN');
         restore_pos(p2);
         // Select more words before selection
         // Search for end of previous word.
         status=search('[\od'p_word_chars"]","sr@"search_direction2);
         if (!status) {
            // Search for beginning of word
            status=search('[~\od'p_word_chars"]|^","sr@>"search_direction2);
            if (status) _end_line();
         }
         _select_char('',mstyle);
      } else {
         save_pos(p2);
         _begin_select();_deselect();_select_char('','EN');
         restore_pos(p2);
         // Select more words after selection
         // Search for beginning of next word
         status=search('[\od'p_word_chars"]","sr@"search_direction);
         if (!status) {
            // Search for end of word
            status=search('[~\od'p_word_chars"]|$","sr@"search_direction);
            if (status) _end_line();
         }
         _select_char('',mstyle);
      }
      //_select_char('',mstyle);
   }
}
void _SelectToCursor(_str mark_name,_str mstyle,int new_x,int new_y,boolean select_words,boolean movecopy_selection,
                     boolean past_bottom=false,boolean past_right=false,
                     boolean past_top=false,boolean past_left=false)
{
   if (p_hex_mode) {
      old_field=p_hex_field;
      p_cursor_y=new_y
      p_cursor_x=new_x
      // This move cursor to end of buffer if y position is past last hex line.
      p_cursor_y=new_y;
      if (!_on_line0()) {
         if (!movecopy_selection) select_it(mark_name,'',mstyle)
      }
      if (!p_hex_field && old_field) {
         p_cursor_x=0x7fffffff;
      } else if (p_hex_field && !old_field) {
         p_cursor_x=0;
      }
      p_hex_field=old_field;
      p_hex_nibble=0;
      return;
   }
   if (select_words) {
      select_more_words(mstyle,new_x,new_y,past_bottom,past_right,past_top,past_left);
      return;
   }
   y=new_y
   old_cursor_y=p_cursor_y;
   old_cursor_x=p_cursor_x;
   p_cursor_y=y
   p_cursor_x=new_x
   if (movecopy_selection && p_cursor_x==old_cursor_x && p_cursor_y==old_cursor_y) {
      // Avoid some extra cursor refreshes so the mouse pointer
      // does not blink as much during a drag drop operation.
      // p_cursor_y and p_cursor_x are optimized so that the cursor
      // is redrawn only if it moved.
      return;
   }
   if (!def_click_past_end && _select_type()!='BLOCK') {
      if (p_col>_text_colc()) _end_line();
   }
   save_pos(p);
   down_rc=down()
   if ( ! down_rc ) {
      restore_pos(p);
   }
   /* When multiple fonts are supported, want the font height */
   /* of the current line, and not the average font height. */
   if ( y>=p_cursor_y+p_font_height && down_rc ) {
      /* save_pos(p) */
      cursor_x=p_cursor_x
      end_line()
      if ( ! p_buf_width ) {
         p_col=p_col+1
      }
      if ( p_cursor_x<cursor_x ) {
         p_cursor_x=cursor_x
      }
      if (!_on_line0()) {
         if (!movecopy_selection) select_it(mark_name,'',mstyle)
      }
      /* restore_pos(p) */
   } else {
      if (!_on_line0()) {
         if (!movecopy_selection) select_it(mark_name,'',mstyle)
      }
   }

}
static void set_scroll_directions(var past_bottom,var past_right,
     var past_top,var past_left,var new_x,var new_y,mx,my)
{

   new_x=mx;
   new_y=my;
   past_bottom=0;past_right=0;past_top=0;past_left=0
   if ( my>=p_client_height ) {
      past_bottom=1
      new_y=p_client_height /* -1 */
   }
   if ( mx>=p_client_width ) {
      past_right=1
      new_x=p_client_width-1
   }
   if ( my<0 ) {
      past_top=1
      new_y=0
   }
   if ( mx<p_windent_x ) {
      past_left=1
      new_x=0
   }

}
_command void page_right() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      width=p_char_width intdiv 2;
   } else {
      width=p_client_width intdiv 2;
   }
   cursor_x=p_cursor_x
   left_edge=p_left_edge+width
   set_scroll_pos left_edge,p_cursor_y
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      p_cursor_x=cursor_x*p_font_width;
   } else {
      p_cursor_x=cursor_x
   }

}
_command void page_left() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      width=p_char_width intdiv 2;
   } else {
      width=p_client_width intdiv 2;
   }
   cursor_x=p_cursor_x
   left_edge=p_left_edge-width
   if ( left_edge<0 ) {
      cursor_x=cursor_x-width
   }
   set_scroll_pos left_edge,p_cursor_y
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      p_cursor_x=cursor_x*p_font_width;
   } else {
      p_cursor_x=cursor_x
   }
}
/*
   Returns TRUE if any right button down events happens

*/
static _str any_rbutton(event)
{
   return(
   event:==RBUTTON_DOWN || event:==RBUTTON_DOUBLE_CLICK ||
              event:==RBUTTON_TRIPLE_CLICK ||
   event:==name2event('a-rbutton_down') || event:==name2event('a-rbutton_double_click') ||
              event:==name2event('a-rbutton_triple_click') ||
   event:==name2event('c-rbutton_down') || event:==name2event('c-rbutton_double_click') ||
              event:==name2event('c-rbutton_triple_click') ||
   event:==name2event('s-rbutton_down') || event:==name2event('s-rbutton_double_click') ||
              event:==name2event('s-rbutton_triple_click')
              )
}
// checks whether mouse is in client area of window
static _str mou_in_window2(mx,my)
{
   return mx>=0 && mx<p_client_width &&
      my>=0 && my<p_client_height

}
//
// Edit window only.  Checks whether mouse is in text area
//
_str mou_in_window()
{
   mx=mou_last_x('D');my=mou_last_y('D');
   _map_xy(0,p_window_id,mx,my);
   return mx>=p_windent_x && mx<p_client_width &&
      my>=0 && my<p_client_height
}
//
// This function is here only because mapping window coordinates
// under X windows is extremely slow.
//
typeless mou_in_window3(mx,my)
{
   return mx>=p_windent_x && mx<p_client_width &&
      my>=0 && my<p_client_height

}

_command void mou_select_line() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   /*if (_isEditorCtl() && !mou_in_window()) {
      return;
   } */
   if (!command_state() && _macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   if (p_object!=OI_TEXT_BOX) {
      // X Windows is slow at mapping window coordinates
      mx=mou_last_x('D');my=mou_last_y('D');
      _map_xy(0,p_window_id,mx,my);
      p_cursor_x=mx;
      p_cursor_y=my;
   }
   init_command_op()
#if 0
   if ( ! mou_in_window() ) {
      check_other_areas()
      return(1)
   }
#endif
   _deselect;_select_line
   _autoclipboard();
   retrieve_command_results()
   // Make sure selection will be extended when click mouse in another
   // window.
   if (!command_state() && pos('C',def_select_style) && def_persistent_select!='Y' ) {
      mstyle='CN';
      select_it('LINE','',mstyle);
   }
}
#if 0
/*
*/
int _on_DebugBitmapClick(int wid,int flags,int NofClicks)
{
   say('Nofclicks='NofClicks);
   return(flags?0:1);
}
#endif
static int mou_debugbitmap(int NofClicks)
{
   // X Windows is slow at mapping window coordinates
   mx=mou_last_x('D');my=mou_last_y('D');
   _map_xy(0,p_window_id,mx,my);
   p_cursor_x=mx;
   p_cursor_y=my;
   status=1;
   // IF we are in the left margin
   debugbitmapclick_index=find_index("_on_DebugBitmapClick",PROC_TYPE);
   if(mou_last_x()<p_windent_x && index_callable(debugbitmapclick_index)) {
      index=find_index("scBPMQFlags",PROC_TYPE);
      flags=0;
      if (index_callable(index)) {
         flags=call_index(index);
      }
      // Return 0 if click has been processed
      status=call_index(p_window_id,flags,NofClicks,debugbitmapclick_index);
   }
   return(status);
}
static int mou_plusminus()
{
   // X Windows is slow at mapping window coordinates
   mx=mou_last_x('D');my=mou_last_y('D');
   _map_xy(0,p_window_id,mx,my);
   p_cursor_x=mx;
   p_cursor_y=my;
   status=1;
   // IF we are in the left margin
   if(mou_last_x()<p_windent_x) {
      status=plusminus();
   }
   return(status);
}
_command void mou_select_word() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   was_command_state=command_state();
   if (!def_seldisp_single && (_isEditorCtl() &&  !mou_in_window())) {
      if(!mou_debugbitmap(2)) {
         return;
      }
      mou_plusminus();
      return;
   }
   if (!command_state() && _macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   if (p_object!=OI_TEXT_BOX) {
      // X Windows is slow at mapping window coordinates
      mx=mou_last_x('D');my=mou_last_y('D');
      _map_xy(0,p_window_id,mx,my);
      p_cursor_x=mx;
      p_cursor_y=my;
   }
   init_command_op()
#if 0
   if ( ! mou_in_window() ) {
      check_other_areas()
      return(1)
   }
   p_cursor_x==mou_last_x()
   p_cursor_y==mou_last_y()
#endif
   if (was_command_state) {
      select_whole_word();
      _autoclipboard();
      retrieve_command_results()
   } else {
      mou_click('','',true);
   }
}
_command void mou_extend_selection() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   if (!command_state() && _macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   mou_click('','E')

}
_command void select_whole_word() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _select_word_wp('0')

}

static _str _select_word_wp()
{
   save_pos(position);
   if ( p_col>_text_colc() ) {
      do_word=1;
   } else {
      ch=get_text();
      do_word=pos('[\od'p_word_chars']',ch,1,'r') || _dbcsIsLeadByte(ch);
   }
   if ( do_word ) {
      blanks_re=''
      if ( arg(1) ) {
         blanks_re='[ \t]@'
      }
      /* Search for beginning of word and match spaces at end of word*/
      search '{[\od'p_word_chars']#'blanks_re'|^}','r-' /* rev2a */
   } else {
      /* Search for beginning of word and match spaces at end of word*/
      search '{[~\od'p_word_chars']#|^}','r-' /* rev2a */
   }
   if ( ! match_length() ) {
      restore_pos(position)
      message nls('No word at cursor')
      return(1)
   }
   _deselect;

   _select_char('','CN');
   goto_point match_length('S0')+match_length()
   _select_char();
   restore_pos(position)
   _end_select();
   if ( pos('C',def_select_style) && def_persistent_select!='Y' ) {
      _select_char('','CN');
   } else {
      _select_char('','EN');
   }
   _cua_select=1
   return(0)

}
_command void mou_click_block() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_NOEXIT_SCROLL)
{
   if (!command_state() && _macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   mou_click('block')

}
_command void mou_click_line() name_info(','VSARG2_MARK|VSARG2_TEXT_BOX|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_NOEXIT_SCROLL)
{
   if (!command_state() && _macro()) {
      _message_box('You cannot select text with the mouse while macro recording');
   }
   mou_click('line')

}
static _str switch_select_type(type)
{
   if ( _select_type()=='' ) {
      return(1)
   }
   _select_type('','T',type);
   return(0);
}
void mou_command_click(boolean extend_mark_option)
{
   // X Windows is slow at mapping window coordinates
   wx=wy=0;_map_xy(p_window_id,0,wx,wy);
   mx=mou_last_x('D');mx-=wx;

   pixel_x=mx;
   col=mou_col(pixel_x)
   line=p_text
   if (col-1>length(line)) {
      col=length(line)+1
   }
   if ( extend_mark_option ) {
      _get_sel begin_col,junk
      _set_sel begin_col,col
      init_mark=0
   } else {
      init_mark=1
      begin_col=col
      _set_sel begin_col
   }
   mou_mode(1)
   mou_release;mou_capture
   for (;;) {
       if (pixel_x<p_windent_x) {
          event=MOUSE_MOVE
       } else {
          refresh('w');
          event=get_event('k')
       }
       if ( event:==MOUSE_MOVE ) {
          mx=mou_last_x('D');mx-=wx;
          pixel_x=mx;
          new_col=mou_col(pixel_x)
          if (new_col-1>length(line)) {
             new_col=length(line)+1
          }
          direction=0
          if (pixel_x<p_windent_x) {
             direction= -1;
          } else if (pixel_x>=p_client_width){
             direction=1;
          }
          if (!direction) {
             _set_sel begin_col,new_col
             /* message 'begin_col='begin_col' new_col='new_col */
             col=new_col
          } else {
             done=command_selectNscroll(begin_col,new_col,direction,mx,wx)
             if ( done ) {
                break
             }
             col=_get_sel()
          }
       } else {
          break
       }
   }
   mou_mode(0)
   mou_release
   init_command_op();
   _autoclipboard();
   retrieve_command_results();
}
static _str command_selectNscroll(begin_col,col,direction,mx,wx)
{
   /* we are outside the window. */
   _set_sel begin_col,col
   init_delay=def_init_delay
   count=DEF_CHG_COUNT
   skip_count=0
   max_skip=1
   _set_timer init_delay
   for (;;) {
      col=col+direction
      _set_sel begin_col,col
      event=ON_TIMER
      ++skip_count
      no_skip=skip_count>=max_skip   //  || test_event('r'):!='')
      if ( no_skip ) {
         refresh('w');
         event=get_event('k')
         skip_count=0
      }
      if(event:==ON_TIMER) {
         --count;
         if ( count<=0 ) {
            count=DEF_CHG_COUNT
#if 0
            if ( init_delay>DEF_MIN_DELAY ) {
               init_delay=init_delay-DEF_DEC_DELAY_BY
            } else {
               init_delay=DEF_MIN_DELAY
            }
#endif
            max_skip=max_skip+DEF_INC_MAX_SKIP_BY
            if ( max_skip>DEF_MAX_SKIP ) {
               max_skip=DEF_MAX_SKIP
            }
         }
      } else if ( event:==MOUSE_MOVE ) {
         mx=mou_last_x('D');mx-=wx;
         pixel_x=mx;
         new_col=mou_col(pixel_x)
         if (pixel_x<0) new_col=1;
         direction=0
         if (pixel_x<p_windent_x) {
            direction= -1;
         } else if (pixel_x>=p_client_width){
            direction=1;
         }
         if ( !direction) {
            _set_sel begin_col,new_col
            _kill_timer
            return(0)
         }
         col=new_col;
         _set_sel begin_col,col
         continue

      } else {
         _kill_timer
         return(1)
      }
   }
}
_sb_line_left()
{
   if (p_scroll_left_edge<0) {
      p_scroll_left_edge=p_left_edge
   }
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      new_value=p_scroll_left_edge-1;
   } else {
      new_value=p_scroll_left_edge-p_font_width
   }
   if (new_value<0) {
      new_value=0
   }
   p_scroll_left_edge=new_value
}
_sb_line_right()
{
   old_val=p_scroll_left_edge
   if (p_scroll_left_edge<0) {
      p_scroll_left_edge=p_left_edge
   }
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      p_scroll_left_edge=p_scroll_left_edge+1;
   } else {
      p_scroll_left_edge=p_scroll_left_edge+p_font_width;
   }
}
_sb_page_left()
{
   if (p_cb) p_window_id=p_cb_list_box
   if (p_scroll_left_edge<0) {
      p_scroll_left_edge=p_left_edge
   }
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      new_value=p_scroll_left_edge-(p_char_width intdiv 2);
   } else {
      new_value=p_scroll_left_edge-(p_client_width intdiv 2);
   }
   if (new_value<0) {
      new_value=0
   }
   p_scroll_left_edge=new_value
}
_sb_page_right()
{
   if (p_cb) p_window_id=p_cb_list_box
   if (p_scroll_left_edge<0) {
      p_scroll_left_edge=p_left_edge
   }
   if (p_object!=OI_LIST_BOX && p_fixed_font) {
      p_scroll_left_edge=p_scroll_left_edge+(p_char_width intdiv 2)
   } else {
      p_scroll_left_edge=p_scroll_left_edge+(p_client_width intdiv 2)
   }
}
_sb_page_down()
{
   if (p_cb) p_window_id=p_cb_list_box
   _scroll_page('d')
}
_sb_page_up()
{
   if (p_cb) p_window_id=p_cb_list_box
   _scroll_page('u')
}

_str mou_show_menu(menu_name)
{
   event=last_event();
   button=arg(2);
   if (arg()<2) {
      if (event:==RBUTTON_DOWN || event:==name2event('s-rbutton-down') ||
          event:==name2event('c-rbutton-down') || event:==name2event('a-rbutton-down')
          ) {
         button='R';
      } else if ((event:==LBUTTON_DOWN || event:==LBUTTON_UP) || event:==name2event('s-lbutton-down') ||
          event:==name2event('c-lbutton-down') || event:==name2event('a-lbutton-down')
          ) {
         button='L';
      } else {
         return(show(menu_name));
      }
   }
   if (button=='') {
      return(show(menu_name));
   }
   index=find_index(menu_name,oi2type(OI_MENU))
   if (!index) {
      return(STRING_NOT_FOUND_RC);
   }
   menu_handle=_menu_load(index,'P');
   x=100;y=100;
   _lxy2lxy(SM_TWIP,p_scale_mode,x,y)
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy p_window_id,0,x,y
   if (upcase(button)=='L') {
      flags=VPM_LEFTALIGN|VPM_LEFTBUTTON;
   } else {
      flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   }
   status=_menu_show(menu_handle,flags,x,y)
   _menu_destroy(menu_handle);
   return(status);
}
void mou_hour_glass(onoff)
{
   if (onoff) {
      mou_set_pointer(MP_HOUR_GLASS)
      //_cmdline.mou_capture();
      //_cmdline.p_mouse_pointer=MP_HOUR_GLASS;
      return;
   }
   //_cmdline.p_mouse_pointer=0;
   //_cmdline.mou_release();
   //return;

}
/*

   If def_mouse_menu_style is MM_TRACK_MOUSE, we automatically track the popup
   the menu and track the mouse.

   Otherwise, we do the appropriate selection first, and then popup a menu if
   the mouse never moved.

   Looks for menus in the following manner:

      1. If there is a selection, it looks for _ext_menu(mode_name)_sel.

      2. Looks for _ext_menu(mode_name)

      3. If there is a selection, looks for _ext_menu_default_sel

      4. Looks for _ext_menu_default

*/

#define MM_TRACK_MOUSE 1
#define MM_MARK_FIRST 2

_command mou_click_menu_block() name_info(','VSARG2_TEXT_BOX|VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   _mou_menu('BLOCK');
}
_command mou_click_menu_line() name_info(','VSARG2_TEXT_BOX|VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   _mou_menu('LINE');
}
_command mou_click_menu() name_info(','VSARG2_TEXT_BOX|VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   _mou_menu('CHAR');
}
static void _mou_menu(mark_type)
{
   if (command_state()) {
      call_event(defeventtab _ul2_textbox,RBUTTON_DOWN,'e');
      return;
   }
   mx=mou_last_x();
   my=mou_last_y();
   if (select_active2() && def_mouse_menu_style==MM_MARK_FIRST) {
      mark_id=_duplicate_selection();
      orig_mark_id=_duplicate_selection('');
      save_pos(p);
      status=mou_click(mark_type,'M');
      if (!status && !select_active2()) {
         restore_pos(p);
         _show_selection(mark_id);
         _free_selection(orig_mark_id);
         refresh();
         _mou_mode_menu();
         return;
      }
      _free_selection(mark_id);
      return;
   }
   if (mark_type!='' && def_mouse_menu_style==MM_MARK_FIRST) {
      status=mou_click(mark_type,'M');
      if (status) return;
   }else{
      _mou_mode_menu();
      return;
   }
   if (!select_active2() || (mx==mou_last_x() && my==mou_last_y())) {
      _mou_mode_menu();
   }
}


#define QUOTE_SINGLE "'"
#define QUOTE_DOUBLE '"'

static get_menu_name()
{
   mode_name=p_mode_name;
   mode_name=stranslate(mode_name'_menu','__',' -');
   index=find_index(mode_name,oi2type(OBJECT_TYPE)|IGNORECASE_TYPE);
   if (!index) {
      index=find_index('_'mode_name,oi2type(OI_MENU)|IGNORECASE_TYPE);
      if (!index) {
         index=find_index('_'lowcase(mode_name),oi2type(OI_MENU)|IGNORECASE_TYPE);
      }
   }
   if (index && select_active2()) {
      sel_index=find_index(name_name(index)'_sel',oi2type(OI_MENU)|IGNORECASE_TYPE);
      if (!sel_index) {
         sel_index=find_index(lowcase(name_name(index))'_sel',oi2type(OI_MENU)|IGNORECASE_TYPE);
      }
      if (!sel_index) {
         index=sel_index;
      }
   }
   menu_name=name_name(index);
   if (menu_name!='') {
      return(menu_name);
   }
   ext=p_extension;
   index=find_index('def-menu-'ext,MISC_TYPE);
   if (!index) {
      index=find_index('def-menu-'ext,MISC_TYPE|IGNORECASE_TYPE);
   }
   parse name_info(index) with menu_name','sel_menu_name',' .;
   if (select_active2()) {
      if (sel_menu_name=='') {
         sel_menu_name='_ext_menu_default_sel';
      }
      return(sel_menu_name);
   }
   if (menu_name=='') {
      menu_name='_ext_menu_default';
   }
   return(menu_name);
}

_command void context_menu() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_NOEXIT_SCROLL)
{
   x=_dx2lx(p_xyscale_mode,p_client_width intdiv 2);
   y=_dy2ly(p_xyscale_mode,p_client_height intdiv 2);
   _mou_mode_menu(x,y);
}
_str Nofclipboards
static _mou_mode_menu()
{
   event=last_event();
   menu_name=get_menu_name();
   if (menu_name=='') {
      return('');
   }
   if (event:==RBUTTON_DOWN || event:==name2event('s-rbutton-down') ||
       event:==name2event('c-rbutton-down') || event:==name2event('a-rbutton-down')
       ) {
      button='R';
   } else if (event:==LBUTTON_DOWN || event:==name2event('s-lbutton-down') ||
       event:==name2event('c-lbutton-down') || event:==name2event('a-lbutton-down')
       ) {
      button='L';
   } else {
      //return(show(menu_name));
   }
   button='R';
   index=find_index(menu_name,oi2type(OI_MENU))
   if (!index) {
      return(STRING_NOT_FOUND_RC);
   }
   menu_handle=p_active_form._menu_load(index,'P');
   /*if (_isEditorCtl() && _QReadOnly()) {
      _menu_set_state(menu_handle,'nrdonly',MF_GRAYED);
   }
   if ( ! Nofclipboards && !_clipboard_format(CBF_TEXT) ) {
      _menu_set_state(menu_handle,'clipboard',MF_GRAYED)
   } */
   x=100;y=100;
   //x=0;y=0;
   _lxy2lxy(SM_TWIP,p_scale_mode,x,y)
   mx=mou_last_x('M');
   my=mou_last_y('M');
   if (arg(1)!='') {
      mx=arg(1);
   }
   if (arg(2)!='') {
      my=arg(2);
   }
   x=mx-x;y=my-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy p_window_id,0,x,y
   if (upcase(button)=='L') {
      flags=VPM_LEFTALIGN|VPM_LEFTBUTTON;
   } else {
      flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   }
   if (!def_process_tab_output) {
      cmd="set-var def-process-tab-output ";
      _menu_get_state(menu_handle,cmd:+"0",mf_flags,'M',caption);
      _menu_set_state(menu_handle,cmd:+"0",MF_CHECKED,'M',caption,cmd:+"1");
   }
   _menu_set_bindings(menu_handle);
   if (!p_mdi_child) {
      _menu_remove_non_mdi(menu_handle);
   }
   if (_isEditorCtl()) {
      call_list('_on_popup_',translate(menu_name,'_','-'),menu_handle);
   }
   status=_menu_show(menu_handle,flags,x,y)
   _menu_destroy(menu_handle);
   return(status);
}
static void _menu_set_bindings(int menu_handle)
{
   //cmd='cursor-error';
   for (i=0;i<_menu_info(menu_handle);++i) {
      _menu_get_state(menu_handle, i, flags, 'P', caption,cmdlist);
      if ((flags&MF_SUBMENU)) {
         _menu_set_bindings(cmdlist);
      } else {
         //messageNwait('cmd='cmd' caption='caption);
         for (;;) {
            parse cmdlist with cmd "\t" cmdlist;
            if (cmd=='') {
               break;
            }
            if (cmd!='' && cmd!='-') {
               bindings = _mdi.p_child.where_is(cmd,2);
               parse stranslate(bindings,'+Comma','+,') with bindings ',' second ',';
               bindings=strip(bindings);second=strip(second);
               if (pos(' ',bindings) && (!pos(' ',second) && second!='')) {
                  bindings=second;
               }
               if (bindings != '') {
                  _menu_get_state(menu_handle, i, flags, 'P', caption);
                  parse caption with caption "\t" rest;
                  _menu_set_state(menu_handle, i, flags, 'P', caption "\t" bindings);
                  break;
               }
            }
         }
      }
   }
}
void _menu_remove_non_mdi(int menu_handle)
{
   //cmd='cursor-error';
   for (i=0;i<_menu_info(menu_handle);++i) {
      _menu_get_state(menu_handle, i, flags, 'P', caption,cmdlist);
      if ((flags&MF_SUBMENU)) {
         _menu_remove_non_mdi(cmdlist);
      } else {
         //messageNwait('cmd='cmd' caption='caption);
          parse cmdlist with cmd "\t" cmdlist;
          if (cmd!='') {
             parse cmd with cmd .;
             index=find_index(cmd,COMMAND_TYPE);
             parse name_info(index) with arg1','arg2;
             if (!isinteger(arg2) || !(arg2&VSARG2_EDITORCTL) ||
                 ((arg2&VSARG2_REQUIRES_MDI) && !(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW))) {
                _menu_delete(menu_handle,i);--i;

                // IF there are still some menu items AND we deleted the last menu item
                if (i>=0 && i+1==_menu_info(menu_handle)) {
                   // Check if the last menu item is a dash
                   _menu_get_state(menu_handle,i, flags, 'P', caption,cmdlist);
                   if (caption=='-') {
                      _menu_delete(menu_handle,i);--i;
                   }
                // IF we deleted the first menu item AND there are still some menu items
                } else if (i<0 && _menu_info(menu_handle)>0) {
                   _menu_get_state(menu_handle,i+1, flags, 'P', caption,cmdlist);
                   if (caption=='-') {
                      _menu_delete(menu_handle,i+1);
                   }
                // IF there is a previous menu item AND there is a next menu item
                } else if (i>=0 && i+1<_menu_info(menu_handle)) {
                   _menu_get_state(menu_handle,i, flags, 'P', caption,cmdlist);
                   if (caption=='-') {
                      _menu_get_state(menu_handle,i+1, flags, 'P', caption,cmdlist);
                      if (caption=='-') {
                        _menu_delete(menu_handle,i+1);
                      }
                   }
                }

             }
         }
      }
   }
}

_command gui_shift_selection() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   if ( _select_type()=='' ) {
      message get_message(TEXT_NOT_SELECTED_RC)
      return(TEXT_NOT_SELECTED_RC)
   }
   was_recording=_macro();
   _macro_delete_line();
   numshifts=get_num_shifts(arg(1));
   if (numshifts!='') {
      _macro('m',was_recording)
      if (lowcase(arg(1))=='r') {
         _macro_call('shift_selection_right', numshifts);
         shift_selection_right(numshifts);
      }else{
         _macro_call('shift_selection_left', numshifts);
         shift_selection_left(numshifts);
      }
   }
}

static get_num_shifts(direction)
{
   direction=(lowcase(direction)=='r')?('Right'):('Left');
   result=show('-modal _textbox_form',
               'Shift Selection 'direction,
               TB_RETRIEVE_INIT,
               '',           //tb width
               '',           //Help item
               '',           //reserved
               'shift',      //retrieve
               '-e _valid_shift_amount Shift Amount');//prompts
   if (result=='') {
      return('');
   }
   return(_param1);
}

_valid_shift_amount(cl)
{
   if (!isnumber(cl)) {
      return(1);
   }
   integer=isinteger(cl);
   positive=(cl>=1);
   rv=positive&&integer
   return(!rv);
}

int mou_in_selection(int mou_x,int mou_y)
{
   if (select_active2()) {
      x=p_cursor_x;y=p_cursor_y;
      p_cursor_x=mou_x;p_cursor_y=mou_y;
      _get_selinfo first_col,last_col,buf_id
      status=0;
      switch (_select_type()) {
      case 'LINE':
         if (_begin_select_compare()>=0 && _end_select_compare()<=0) {
            status=1;
         }
         break;
      case 'BLOCK':
         if (_begin_select_compare()>=0 && _end_select_compare()<=0 &&
              p_col>=first_col && p_col<=last_col) {
            status=1;
         }
         break;
      default:
         if (_begin_select_compare()>0 && _end_select_compare()<0) {
            status=1;
         } else if (_begin_select_compare()==0) {
            if (p_col>=first_col) {
               status=1;
               if (_end_select_compare()==0){
                  if(p_col>=last_col+_select_type('','I')) {
                     status=0;
                  }
               }
            }
         } else if (_end_select_compare()==0 && p_col<last_col+_select_type('','I')){
            status=1;
         }
         break;
      }
      p_cursor_x=x;p_cursor_y=y;
      return(status);
   }
   return(0);
}
_version()
{
   parse get_message(SLICK_EDITOR_VERSION_RC) with . . . number .
   return(number)
}
