/*
	MR/2 ICE - RCVFAX.CMD

	Copyright (c) 1996, Nick Knight
	All Rights Reserved.

	Author: 	Nick Knight
	Created:	08/10/96
	Usage:		rcvfax MessageFile
	Purpose:	To interface with PMFax v3.0 or better and pass
				it faxes transported via email.
	US Mail:	Nick Knight, PO Box 22366, Beachwood, Ohio 44122
    Internet:   nick@mr2ice.com
*/


/* 
	If FxRcv is not in your path, you can simply supply the path to it
	below.	Example would be PMFaxPath='f:\pmfax\'.  INCLUDE the closing
	backslash, please!!
*/	  

PMFaxPath=''


parse arg filename

say ' '
say 'MR/2 ICE Email-to-Fax script v1.0'
say 'Copyright (c) 1996, Nick Knight'
say 'All Rights Reserved.'
say ' '

logfile = 'detach.$$$'
from = ''
subject = ''

'@echo off'

'del 'logfile' >nul'
'mr2i /D'filename logfile


/*
	This section walks through the incoming message header, collecting
	the pertainent header values into save strings.  There is a little
	bit of a trick here, as we ALSO try to see if the first line of the
	message contains the command.
*/

fHeader = 1
ctr = 0

status = stream(filename,'c','open read')
do while ((ctr < 100) & (lines(filename) > 0))
	iline = linein(filename)
	Parse VALUE iline with tag ': ' value
	Parse UPPER VALUE iline with tag ': '
	
	if (tag == 'FROM') then
		from = value
	else if (tag == 'SUBJECT') then
		subject = value

	if (Length(iline) == 0) then
		fHeader = 0

	if Length(from) > 0 then
		if Length(subject) > 0 then
			ctr = 200;
	
	ctr = ctr + 1
end

status = stream(filename,'c','close')

say 'Fax from' from 'regarding' subject

/* Call FxRcv for each dettached file listed in the log */

status = stream(logfile,'c','open read')
do while (lines(logfile) > 0)
	iline = linein(logfile)
	if (Length(iline) > 2) then do
		SAY PMFaxPath||'FxRcv -rcvd' iline '"'from'"' '"'subject'"'
		PMFaxPath||'FxRcv -rcvd' iline '"'from'"' '"'subject'"'
		'del' iline
	end
end

status = stream(logfile,'c','close')

'del' logfile '>nul'

return 0

