#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <time.h>

#include "mailto.h"
#include "smtpsession.hpp"
#include "smtpsession.h"

BOOL setBlocking(int socknum, BOOL blockVal)
{
    #ifdef __OS2__
    int noblock=!blockVal;
    if (ioctl(socknum, FIONBIO, (char*)&noblock, sizeof(noblock))<0)
        {
        return FALSE;
        }    
    #endif

    #ifdef __MINGW32__
    ULONG noblock=!blockVal;
    if (ioctlsocket(socknum, FIONBIO, &noblock)<0)
        {
        return FALSE;
        }
    #endif

    #ifdef __linux__    
	int opts;
    opts=fcntl(socknum, F_GETFL);
    if (opts<0) 
        {
        return FALSE;
        }
    if (blockVal)
        {
        opts = opts &~ O_NONBLOCK;
        }
    else
        {
        opts = opts | O_NONBLOCK;
        }
    if (fcntl(socknum, F_SETFL, opts)< 0) 
        {
        return FALSE;
        }
    #endif

    return TRUE;
}

BOOL SMTPResponseData::expandArray()
{
	char **ta;

	arsize+=RESP_ARRAY_INCREMENT;

	ta = new char*[arsize];
	if (ta==NULL)
		OutOfMemory();

	memcpy(ta, ra, lc*sizeof(char*));
	delete[] ra;
	ra=ta;

	return TRUE;
}

void SMTPSession::initData(void)
{
    hostname = new char[STSIZE];

    memset(hostname, 0, STSIZE);

    smtpPort=25;

    memset(&scr, 0, sizeof(scr));
}

SMTPSession::SMTPSession(char *host)
{
    this->initData();
    strcpy(hostname, host);
}

SMTPSession::SMTPSession(char *host, USHORT port)
{
    this->initData();
    strcpy(hostname, host);
    smtpPort=port;
}

SMTPSession::SMTPSession()
{
    this->initData();
}

SMTPSession::~SMTPSession()
{
    delete[] hostname;
    this->cleanUpSockets();
}

void SMTPSession::cleanUpSockets(void)
{
    soclose(csock);
}

void SMTPSession::setHost(char *host)
{
    memset(hostname, 0, STSIZE);
    strncpy(hostname, host, STSIZE-1);
}

void SMTPSession::setHost(char *host, USHORT port)
{
    memset(hostname, 0, STSIZE);
    strncpy(hostname, host, STSIZE-1);
    smtpPort=port;
}

void SMTPSession::setPort(USHORT port)
{
    smtpPort=port;
}


BOOL SMTPSession::sendSender(char *sender)
{
    char *cmdstring;
    SMTPCommandResult *cr;

    cmdstring = new char[STSIZE];

    if (cmdstring==NULL)
        this->outOfMemory();

    memset(cmdstring, 0, STSIZE);
    strcpy(cmdstring, "MAIL FROM:<");
    strncat(cmdstring, sender, STSIZE-15);
    strcat(cmdstring, ">\r\n");

    cout << "Sending origin information... " << flush;
    cr=this->sendCommand(cmdstring);

    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        cout << "Failed" << endl;
        return FALSE;
        }
    if (cr->returnValue[0]!=250)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        cout << "Failed" << endl;
        return FALSE;
        }

    cout << "Done" << endl;

    delete[] cmdstring;

    return TRUE;
}

BOOL SMTPSession::sendReceiver(char *receiver)
{
    char *cmdstring;
    SMTPCommandResult *cr;

    cmdstring = new char[STSIZE];

    if (cmdstring==NULL)
        this->outOfMemory();

    memset(cmdstring, 0, STSIZE);
    strcpy(cmdstring, "RCPT TO:<");
    strncat(cmdstring, receiver, STSIZE-13);
    strcat(cmdstring, ">\r\n");

    cout << "Sending recipient information... " << flush;
    cr=this->sendCommand(cmdstring);

    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        cout << "Failed" << endl;
        return FALSE;
        }
    if (cr->returnValue[0]!=250)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        cout << "Failed" << endl;
        return FALSE;
        }

    cout << "Done" << endl;

    delete[] cmdstring;

    return TRUE;
}

BOOL SMTPSession::sendMailData(char *fname, BOOL noDateHeader)
{
    char *cmdstring, *fbuf, *sbuf;
    SMTPCommandResult *cr;
    ifstream *lfile;
    int scheck, dlength;
    ULONG totalt;
    time_t currTime, gmTime;
    struct tm lcTime, gmTm, *tptr;
    double gmoff;
    char tbuf[48], goff[5];    

    cmdstring = new char[STSIZE];
    fbuf = new char[BUFSIZE];
    sbuf = new char[BUFSIZE];

    if (cmdstring==NULL || fbuf==NULL)
        this->outOfMemory();

    if (fname[0]==0)
        {
        lfile = new ifstream(0);
        if (lfile->fail())
            {
            this->setFailureCause(SMTPS_FAILURE_LOCALOPENFAILURE);
            return FALSE;
            }
        }
    else
        {
        lfile = new ifstream;

        lfile->open(fname, ios::in);

        if (lfile->fail())
            {
            this->setFailureCause(SMTPS_FAILURE_LOCALOPENFAILURE);
            return FALSE;
            }
        }

    memset(cmdstring, 0, STSIZE);
    strcpy(cmdstring, "DATA\r\n");

    cout << "Sending mail data... " << endl;
    cr=this->sendCommand(cmdstring);

    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        return FALSE;
        }
    if (cr->returnValue[0]!=354)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        return FALSE;
        }

    cout << endl << "Bytes sent:         " << flush;
    totalt=0;
    dlength=0;

    if (!noDateHeader)
        {
        time(&currTime); // add date header
        tzset();
        tptr=localtime(&currTime);
        lcTime=*tptr;
    
        tptr=gmtime(&currTime);
        if (tptr!=NULL)
            {
            gmTm=*tptr;
            gmTime=mktime(&gmTm);
            
            gmoff=difftime(gmTime, currTime);
    
            if ((float)gmoff>=0.0)
                {
                sprintf(goff, "-%02d%02d", (int)gmoff/3600, ((int)gmoff%3600)/60);
                }
            else
                {
                sprintf(goff, "+%02d%02d", (int)gmoff/3600, ((int)gmoff%3600)/60);
                }
            }
        else
            {
            strftime(goff, sizeof(goff), "%Z", &lcTime);
            }
        
        strftime(tbuf, sizeof(tbuf), "Date: %a, %d %b %Y %T ", &lcTime);
        strcat(tbuf, goff);
        strcat(tbuf, "\r\n");
    
        memset(sbuf, 0, BUFSIZE);
        strcpy(sbuf, tbuf);
        dlength=strlen(sbuf);        
        }

    do
        {
        memset(fbuf, 0, BUFSIZE);
        lfile->getline(fbuf, BUFSIZE-1);
        if (!lfile->fail())
            {
            if (fbuf[0]=='.')
                {
                if (dlength==0)
                    strcpy(sbuf, ".");
                else
                    strcat(sbuf, ".");
                strcat(sbuf, fbuf);
                strcat(sbuf, "\r\n");
                dlength+=strlen(fbuf)+3;
                }
            else
                {
                if (dlength==0)
                    strcpy(sbuf, fbuf);
                else
                    strcat(sbuf, fbuf);
                strcat(sbuf, "\r\n");
                }
            dlength+=strlen(fbuf)+2;
            if (dlength>4096)
                {
                scheck=send(csock, sbuf, dlength, 0);
                if (scheck<0)
                    {
                    this->setFailureCause(SMTPS_FAILURE_SOCKET);
                    return FALSE;
                    }
                totalt+=scheck;
                cout << "\b\b\b\b\b\b\b\b" << setw(8) << totalt << flush;
                dlength=0;
                memset(sbuf, 0, BUFSIZE);
                }
            }
        } while (!lfile->fail());
    lfile->close();

    strcat(sbuf, ".\r\n");
    scheck=send(csock, sbuf, dlength+3, 0);

    if (scheck<0)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        return FALSE;
        }

    totalt+=scheck;
    cout << "\b\b\b\b\b\b\b\b" << setw(8) << totalt << flush;

    cr=this->sendCommand("");

    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        return FALSE;
        }
    if (cr->returnValue[0]!=250)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        return FALSE;
        }

    cout << endl << endl << "Transfer complete." << endl;

    delete[] cmdstring;
    delete[] fbuf;
    delete[] sbuf;
    delete lfile;

    return TRUE;
}

BOOL SMTPSession::sendClose(void)
{
    char *cmdstring;
    SMTPCommandResult *cr;

    cmdstring = new char[STSIZE];

    if (cmdstring==NULL)
        this->outOfMemory();

    memset(cmdstring, 0, STSIZE);
    strcpy(cmdstring, "QUIT\r\n");

    cout << "Sending close... " << flush;
    cr=this->sendCommand(cmdstring);

    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        cout << "Failed" << endl;
        return FALSE;
        }

// oddly enough, some servers don't implement QUIT
// so, we ignore the result
/*
    if (cr->returnValue[0]!=221)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        cout << "Failed" << endl;
        return FALSE;
        }
*/

    cout << "Done" << endl;

    delete[] cmdstring;

    return TRUE;
}

BOOL SMTPSession::openConnection(void)
{
	int scheck, srange;
	ULONG haddr;
	BOOL noblock=TRUE;
	struct hostent *hs;
	struct sockaddr_in sa;
	struct in_addr *iadd;
	struct timeval tout;
	fd_set writes, reads;
    SMTPCommandResult *cr;

	csock=socket(AF_INET, SOCK_STREAM, 0);

	if (csock<0)
		{
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
		return FALSE;
		}

	if ((LONG)(haddr=inet_addr(hostname))<0)
		{
		if ((hs=gethostbyname(hostname))==NULL)
			{
            this->setFailureCause(SMTPS_FAILURE_UNKNOWN_HOST);
			return FALSE;
			}
		iadd=(struct in_addr*)hs->h_addr;
		haddr=iadd->s_addr;
		}

	memset(&sa, 0, sizeof(sa));
	sa.sin_family=AF_INET;
    sa.sin_port=htons(smtpPort);
	sa.sin_addr.s_addr=haddr;

	setBlocking(csock, FALSE);

	if (connect(csock, (struct sockaddr*)&sa, sizeof(sa))<0)
		{
		if (sock_errno()==SOCEINPROGRESS ||
			sock_errno()==SOCEWOULDBLOCK)
			{
            tout.tv_sec=60;
			tout.tv_usec=0;
			srange=csock+1;
	
			FD_ZERO(&writes);
			FD_SET(csock, &writes);
			scheck=select(srange, 0, &writes, 0, &tout);
			if (scheck<1)
				{
                this->setFailureCause(SMTPS_FAILURE_CONNTIMEOUT);
				return FALSE;
				}
			}
		else
			{
            this->setFailureCause(SMTPS_FAILURE_NOCONNECT);
			return FALSE;
			}
		}

	tout.tv_sec=0;
	tout.tv_usec=0;
	srange=csock+1;

	FD_ZERO(&reads);
	FD_SET(csock, &reads);
	scheck=select(srange, &reads, 0, 0, &tout);
	if (scheck>0)
		{
		char foo[1];
		scheck=recv(csock, foo, sizeof(foo), MSG_PEEK);
		if (scheck<0)
			{
			if (sock_errno()==SOCECONNREFUSED)
				{
                this->setFailureCause(SMTPS_FAILURE_NOCONNECT);
				return FALSE;
				}
			}
		}

	memset(&sa, 0, sizeof(sa));

	#ifdef __linux__
	socklen_t sasz=sizeof(sa);
	#else
	int sasz=sizeof(sa);
	#endif
	
	if (!setBlocking(csock, TRUE))
		{
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
		return FALSE;
		}

    cr=this->sendCommand("");
    if (!cr->noSocketFailure)
        {
        this->setFailureCause(SMTPS_FAILURE_SOCKET);
        return FALSE;
        }
    if (cr->returnValue[0]!=220)
        {
        this->setFailureCause(SMTPS_FAILURE_COMMAND);
        return FALSE;
        }
            
	return TRUE;
}

ULONG SMTPSession::failureCause(void)
{
    return failCause;
}

void SMTPSession::setFailureCause(ULONG fail)
{
    failCause=fail;
}

SMTPCommandResult* SMTPSession::sendCommand(char *cmdstring)
{
	char ebuf[7], cbuf[5], cbuf2[5], *sptr, *tptr, *rbuf, *tbuf, *le;
	int scheck, srange;
	BOOL xferDone=FALSE;
	struct timeval tout;
	fd_set reads;

	rbuf = new char[BUFSIZE];
	tbuf = new char[BUFSIZE*20];

	if (rbuf==NULL || tbuf==NULL)
		OutOfMemory();

	memset(tbuf, 0, BUFSIZE*20);

	memset(cbuf, 0, sizeof(cbuf));
	memset(ebuf, 0, sizeof(ebuf));
	memset(cbuf2, 0, sizeof(cbuf2));

	scr.reset();

	if (strcmp(cmdstring, "")!=0)
		{
		scheck=send(csock, cmdstring, strlen(cmdstring), 0);
		if (scheck<0)
			{
			scr.noSocketFailure=FALSE;
			delete[] rbuf;
			delete[] tbuf;
			return &scr;
			}
		}

	do
		{
        tout.tv_sec=60;
		tout.tv_usec=0;
		srange=csock+1;

		FD_ZERO(&reads);
		FD_SET(csock, &reads);
		scheck=select(srange, &reads, 0, 0, &tout);
		if (scheck<1)
			{
			scr.noSocketFailure=FALSE;
			delete[] rbuf;
			delete[] tbuf;
			return &scr;
			}

		memset(rbuf, 0, BUFSIZE);
		scheck=recv(csock, rbuf, BUFSIZE, 0);
		if (scheck<0)
			{
			scr.noSocketFailure=FALSE;
			delete[] rbuf;
			delete[] tbuf;
			return &scr;
			}
		strcat(tbuf, rbuf);
		le=tbuf+strlen(tbuf)-2;
		} while (strcmp(le, "\r\n")!=0);

	strncpy(cbuf, tbuf, 4); // primary return code plus one
	strncpy(ebuf, cbuf, 3);
	strcat(ebuf, " "); // last line signature

	if (!strcmp(cbuf, ebuf))
		{
		xferDone=TRUE; // no need for further receives, most likely
		}
	else
		{
		strcpy(ebuf, "\r\n");
		strncat(ebuf, cbuf, 3);
		strcat(ebuf, " "); // new end signature
		if (strstr(tbuf, ebuf)!=NULL)
			{
			xferDone=TRUE; // no more receives, most likely
			}
		}

	while (!xferDone)
		{
		do
			{
            tout.tv_sec=60;
			tout.tv_usec=0;
			srange=csock+1;

			FD_ZERO(&reads);
			FD_SET(csock, &reads);
			scheck=select(srange, &reads, 0, 0, &tout);
			if (scheck<1)
				{
				scr.noSocketFailure=FALSE;
                this->setFailureCause(SMTPS_FAILURE_TIMEOUT);
				delete[] rbuf;
				delete[] tbuf;
				return &scr;
				}

			memset(rbuf, 0, BUFSIZE);
			scheck=recv(csock, rbuf, BUFSIZE, 0);
			if (scheck<0)
				{
				scr.noSocketFailure=FALSE;
				delete[] rbuf;
				delete[] tbuf;
				return &scr;
				}
			strcat(tbuf, rbuf);
			le=tbuf+strlen(tbuf)-2;
			} while (strcmp(le, "\r\n")!=0);

		if (strstr(tbuf, ebuf)!=NULL) // code end in middle somewhere
			{
			xferDone=TRUE;
			}
		}

	cbuf[3]=0x00; // nix "-" if it exists

	scr.returnValue[0]=(USHORT)atoi(cbuf); // primary return code
	scr.numReturnValues=1;

	tptr=tbuf;

	while (strlen(tptr)>0)
		{
		sptr=strstr(tptr, "\r\n");
		if (sptr!=NULL)
			{
			sptr[0]=0x00;
			sptr[1]=0x00;
			if (!scr.responseData.addLine(tptr))
				OutOfMemory();
			if (scr.numReturnValues==1)
				{
				strncpy(cbuf2, tptr, 3);
				if (strcmp(cbuf, cbuf2)!=0 && atoi(cbuf2)!=0) // secondary response
					{
					scr.numReturnValues++;
					scr.returnValue[1]=(USHORT)atoi(cbuf2);
					strcpy(ebuf, cbuf2);
					strcat(ebuf, " ");
					if (strstr(tptr, ebuf)==NULL) // more data to retrieve
						{
						xferDone=FALSE;
						memcpy(sptr, (void*)"\r\n", 2);
						while (!xferDone)
							{
							do
								{
                                tout.tv_sec=60;
								tout.tv_usec=0;
								srange=csock+1;

								FD_ZERO(&reads);
								FD_SET(csock, &reads);
								scheck=select(srange, &reads, 0, 0, &tout);
								if (scheck<1)
									{
									scr.noSocketFailure=FALSE;
                                    this->setFailureCause(SMTPS_FAILURE_TIMEOUT);
									delete[] rbuf;
									delete[] tbuf;
									return &scr;
									}

								memset(rbuf, 0, BUFSIZE);
								scheck=recv(csock, rbuf, BUFSIZE, 0);
								if (scheck<0)
									{
									scr.noSocketFailure=FALSE;
									delete[] rbuf;
									delete[] tbuf;
									return &scr;
									}
								strcat(tptr, rbuf);
								le=tptr+strlen(tptr)-2;
								} while (strcmp(le, "\r\n")!=0);

							if (strstr(tptr, ebuf)!=NULL)
								{
								xferDone=TRUE;
								strcpy(cbuf, cbuf2);
								}
							}
						}
					}
				tptr=sptr+2;
				}
			else
				{
				tptr=sptr+2;
				}
			}
		}

	scr.noSocketFailure=TRUE;

	delete[] rbuf;
	delete[] tbuf;

	return &scr;
}

void SMTPSession::outOfMemory(void)
{
    this->cleanUpSockets();
    cout << endl << "Out of memory." << endl;
    exit(1);
}
