/*****************************************************************************/
/* IBM Internal Use Only                                                     */
/* Copyright (c) IBM Corp 1997                                               */
/*---------------------------------------------------------------------------*/
/* File        : pmBandit.hpp                                                */
/* Contains    : THe definition to the pmBandit object.                      */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-06-10  | Created                                 | FB                */
/* 1997-11-07  | Inspeceted for Win32 comp.              | FB                */
/*****************************************************************************/

//* Conditional inclusion ****************************************************
#ifndef _PM_BANDIT_HPP_
#define _PM_BANDIT_HPP_

//* Include headers **********************************************************

#include <mlist.h>
#include <istring.hpp>

#include <iframe.hpp>
#include <iframhdr.hpp>
#include <icmdhdr.hpp>
#include <imcelcv.hpp>
#include <ilistbox.hpp>
#include <ipushbut.hpp>
#include <iselhdr.hpp>
#include <inotebk.hpp>
#include <iinfoa.hpp>
#include <imoushdr.hpp>
#include <ITimer.hpp>

#include "..\..\BanditTagger\PM_Interface\userPreference.hpp"

//* Forward declarations *****************************************************
//****************************************************************************
// Class : TAGNotebookPage
//
//****************************************************************************

class TAGNotebookPage : public IFrameWindow
{
  private:
    //* Privat members.     ****************************************************
    IString     _filename;
    IListBox    _listbox;

    Boolean 		_disable;
    //* Prvate functions *****************************************************
    void        loadTagFile();
  public:
    //* Constuctor ***********************************************************
    TAGNotebookPage(IWindow* pParentOwner, IString filename, Boolean disable = false);
    //* Public functions *****************************************************
    IListBox*   listbox() {return &_listbox;}
};


//****************************************************************************
// Class : TAGNotebook
//
//****************************************************************************

class TAGNotebook : public IFrameWindow
                  , public ICommandHandler
                  , public IMouseHandler
{
  //* Privatclass         ****************************************************
  class TAGNotebookSelect : public ISelectHandler
  {
    private:
      TAGNotebook*  _notebook;
      IListBox*     _listbox;
      virtual IHandler& handleEventsFor(IWindow*) {return *this;}
    protected:
      virtual Boolean enter   (IControlEvent& ctrlEvt);
//      virtual Boolean selected(IControlEvent& ctrlEvt);
    public:
      TAGNotebookSelect(TAGNotebook* aNotebook) :_notebook(aNotebook){}
      virtual TAGNotebookSelect& handleEventsFor(IListBox* aListBox);
      const IListBox* listbox() {return _listbox;}
  };
  //* Privat members.     ****************************************************
  MList<IString>&     _filenameList;
  IString             _filepath;
  TAGUserIni&         _userIni;

  IPushButton*        _ppbOk          ;
  IPushButton*        _ppbCancel      ;
  IInfoArea*          _pInfoArea      ;

  TAGNotebookSelect   _selectHandler  ;
  IString             _itemText       ;
  //* Prvate functions *****************************************************
  IMultiCellCanvas*   insertButtons(IMultiCellCanvas* pParentOwner);
  INotebook*          insertNotebookPages(IMultiCellCanvas* pParentOwner);

  //* Protected ***********************************************************
  protected:
     virtual Boolean command      (ICommandEvent& cmdEvt);
     virtual Boolean mouseClicked (IMouseClickEvent &mouseClick);
//   virtual Boolean systemCommand(ICommandEvent& cmdEvt);
  //* Public declarations ****************************************************
  public:
    //* Constuctor ***********************************************************
    TAGNotebook(MList<IString>& afileList, const IString& filepath, TAGUserIni& aUserIni);

    //* Destructor ***********************************************************
    virtual ~TAGNotebook() {}

    //* Public functions *****************************************************
    long           layout();
    const IString& itemText() {return _itemText;}
    IInfoArea*     infoArea() {return _pInfoArea;}
    Boolean        handleOk();
};

class TAGViewer : public IFrameWindow
                , public IFrameHandler
{
  private:
  //* Privat members.     ****************************************************
  ITimer    timer;
  long      _timer;
  //* Prvate functions *****************************************************
  void closeFrame();
  //* Protected ***********************************************************
  //* Public declarations ****************************************************
  public:
    virtual Boolean activated(IFrameEvent& frameEvt);
    //* Constuctor ***********************************************************
    TAGViewer(MList<IString>& tagList, long aValue, const IString& newline);
    //* Destructor ***********************************************************
    virtual ~TAGViewer() {}
    //* Public functions *****************************************************
};

#endif
