/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@stealthmail.com       */
/* Copyright (c) FA Partners 1997                                            */
/*---------------------------------------------------------------------------*/
/* Name        : bandit.cpp                                                  */
/* Description : This file just woorks as a launcher for the program.        */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-06-02  | Created                                 | FB                */
/* 1997-06-09  | Inserted exception handles.             | FB                */
/*---------------------------------------------------------------------------*/
/* Compile     : exepack:2 /packd /optfunc                                   */
/*****************************************************************************/

#include <IApp.hpp>
#include <IThread.hpp>
#include <imsgbox.hpp>
#include <fstream.h>
#ifndef __TOS_OS2__
  #include <icoordsy.hpp>
#endif

#include "..\..\BanditTagger\Tagger\mailmain.hpp"
#include "..\..\BanditTagger\Tagger\tagini.hpp"
#include "..\..\BanditTagger\Tagger\commonDef.hpp"
#ifdef __TOS_OS2__
#include "..\..\BanditTagger\Tagger\netscape.hpp"
#endif
#include "..\..\BanditTagger\PM_Interface\pmBandit.hpp"
#include "..\..\BanditTagger\PM_Interface\userPreference.hpp"

main(int argc, char *argv[], char *envp[])
{
  // Use the Warp 4.0 dlls instead of the IBMCPP's.
  // IApplication::current().setResourceLibrary("os2oor3u");

  // Adjust the windows operating system to use the OS/2 origin.
  #ifndef __TOS_OS2__
    ICoordinateSystem::setApplicationOrientation();
  #endif

  // Read the ini file.
  TAGUserIni tagIni(argv[0]);
  Boolean    handleNetscape(false);

  if (argc == 1) {
    TAGUserPM  tagIniPM(tagIni);
    tagIniPM.layout();
    tagIniPM.show();
    IApplication::current().run();
    if(tagIniPM.saveIni())
      tagIni.save();
  } else  {
    Boolean debug (false);
    Boolean forceX(false);
    IString mailfile;
    for (int index = 1; index < argc; index++ ) {
      switch (argv[index][0]) {
      case '/':
        switch (argv[index][1]) {
        case 'd':
        case 'D':
          debug = true;
          break;
        case 'f':
        case 'F':
          forceX = true;
          break;
        case 'n':
        case 'N':
          #ifdef __TOS_OS2__
          handleNetscape = true;
          #endif
        break;
        } // endswitch
        break;
      default:
        mailfile = argv[index];
        break;
      } // endswitch
    }
    if (!handleNetscape) {
      MailHandler  mail(tagIni, mailfile, debug, forceX);
      MailTagger   *tag;

      try {
        tag = new MailTagger(tagIni);
      }
      catch (IException& exc)
       {
         cout << "Error : " << exc.text() << endl;
         return -1;
       }

      tag->isTaglines(mail.tagMarkers());
      mail.insertTaglines(*tag);
      mail.handleX();
      mail.anonymous();

      if (mail.changed())
         mail.save();
      if (tagIni.pause() && mail.changed()) {
  //      TAGViewer view(tag->tagList(), tagIni.pause(), tagIni.wysiwyg() ? IString("\n")
  //                                                                      : tagIni.newline());
        TAGViewer view(tag->tagList(), tagIni.pause(), IString("\n"));
        view.setFocus();
        view.showModally();
      }
    } else { // Handling the netscape thing.
      #ifdef __TOS_OS2__
      BANNetscape banditNetscape(tagIni);

      if (!banditNetscape.start())
        IMessageBox(IWindow::desktopWindow())
                   .setTitle("Bandit Tagger Error")
                   .show("Unable to load hookdll.dll", IMessageBox::catastrophic);
      #endif
    }
  }

  return 0;
}


